/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.usage.UsageStatsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UiccAccessRule;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.cat.CatService;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.InstallCarrierAppTrampolineActivity;
import com.android.internal.telephony.uicc.InstallCarrierAppUtils;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccCarrierPrivilegeRules;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.euicc.EuiccCard;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UiccProfile
extends IccCard {
    protected static final String LOG_TAG = "UiccProfile";
    protected static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String OPERATOR_BRAND_OVERRIDE_PREFIX = "operator_branding_";
    private final Object mLock;
    private IccCardStatus.PinState mUniversalPinState;
    private int mGsmUmtsSubscriptionAppIndex;
    private int mCdmaSubscriptionAppIndex;
    private int mImsSubscriptionAppIndex;
    private UiccCardApplication[] mUiccApplications = new UiccCardApplication[8];
    private Context mContext;
    private CommandsInterface mCi;
    private final UiccCard mUiccCard;
    private CatService mCatService;
    private UiccCarrierPrivilegeRules mCarrierPrivilegeRules;
    private boolean mDisposed = false;
    private RegistrantList mCarrierPrivilegeRegistrants = new RegistrantList();
    private RegistrantList mOperatorBrandOverrideRegistrants = new RegistrantList();
    private final int mPhoneId;
    private static final int EVENT_RADIO_OFF_OR_UNAVAILABLE = 1;
    private static final int EVENT_ICC_LOCKED = 2;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static final int EVENT_APP_READY = 3;
    private static final int EVENT_RECORDS_LOADED = 4;
    private static final int EVENT_NETWORK_LOCKED = 5;
    private static final int EVENT_EID_READY = 6;
    private static final int EVENT_ICC_RECORD_EVENTS = 7;
    private static final int EVENT_OPEN_LOGICAL_CHANNEL_DONE = 8;
    private static final int EVENT_CLOSE_LOGICAL_CHANNEL_DONE = 9;
    private static final int EVENT_TRANSMIT_APDU_LOGICAL_CHANNEL_DONE = 10;
    private static final int EVENT_TRANSMIT_APDU_BASIC_CHANNEL_DONE = 11;
    private static final int EVENT_SIM_IO_DONE = 12;
    private static final int EVENT_CARRIER_PRIVILEGES_LOADED = 13;
    private static final int EVENT_CARRIER_CONFIG_CHANGED = 14;
    private TelephonyManager mTelephonyManager;
    private RegistrantList mNetworkLockedRegistrants = new RegistrantList();
    private int mCurrentAppType = 1;
    private UiccCardApplication mUiccApplication = null;
    private IccRecords mIccRecords = null;
    private IccCardConstants.State mExternalState = IccCardConstants.State.UNKNOWN;
    private final ContentObserver mProvisionCompleteContentObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean selfChange) {
            UiccProfile.this.mContext.getContentResolver().unregisterContentObserver(this);
            for (String pkgName : UiccProfile.this.getUninstalledCarrierPackages()) {
                InstallCarrierAppUtils.showNotification(UiccProfile.this.mContext, pkgName);
                InstallCarrierAppUtils.registerPackageInstallReceiver(UiccProfile.this.mContext);
            }
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                UiccProfile.this.mHandler.sendMessage(UiccProfile.this.mHandler.obtainMessage(14));
            }
        }
    };
    @VisibleForTesting
    public final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            if (UiccProfile.this.mDisposed && msg.what != 8 && msg.what != 9 && msg.what != 10 && msg.what != 11 && msg.what != 12) {
                UiccProfile.loge("handleMessage: Received " + msg.what + " after dispose(); ignoring the message");
                return;
            }
            UiccProfile.this.loglocal("handleMessage: Received " + msg.what + " for phoneId " + UiccProfile.this.mPhoneId);
            switch (msg.what) {
                case 5: {
                    UiccProfile.this.mNetworkLockedRegistrants.notifyRegistrants();
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    UiccProfile.this.updateExternalState();
                    break;
                }
                case 7: {
                    if (UiccProfile.this.mCurrentAppType != 1 || UiccProfile.this.mIccRecords == null) break;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    int eventCode = (Integer)ar.result;
                    if (eventCode != 2) break;
                    UiccProfile.this.mTelephonyManager.setSimOperatorNameForPhone(UiccProfile.this.mPhoneId, UiccProfile.this.mIccRecords.getServiceProviderName());
                    break;
                }
                case 13: {
                    UiccProfile.this.onCarrierPrivilegesLoadedMessage();
                    UiccProfile.this.updateExternalState();
                    break;
                }
                case 14: {
                    UiccProfile.this.handleCarrierNameOverride();
                    UiccProfile.this.handleSimCountryIsoOverride();
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        UiccProfile.this.loglocal("handleMessage: Exception " + ar.exception);
                        UiccProfile.log("handleMessage: Error in SIM access with exception" + ar.exception);
                    }
                    AsyncResult.forMessage((Message)ar.userObj, ar.result, ar.exception);
                    ((Message)ar.userObj).sendToTarget();
                    break;
                }
                default: {
                    UiccProfile.loge("handleMessage: Unhandled message with number: " + msg.what);
                }
            }
        }
    };

    public UiccProfile(Context c, CommandsInterface ci, IccCardStatus ics, int phoneId, UiccCard uiccCard, Object lock) {
        UiccProfile.log("Creating profile");
        this.mLock = lock;
        this.mUiccCard = uiccCard;
        this.mPhoneId = phoneId;
        Phone phone = PhoneFactory.getPhone(phoneId);
        if (phone != null) {
            this.setCurrentAppType(phone.getPhoneType() == 1);
        }
        if (this.mUiccCard instanceof EuiccCard) {
            ((EuiccCard)this.mUiccCard).registerForEidReady(this.mHandler, 6, null);
        }
        this.update(c, ci, ics);
        ci.registerForOffOrNotAvailable(this.mHandler, 1, null);
        this.resetProperties();
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        c.registerReceiver(this.mReceiver, intentfilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        UiccProfile.log("Disposing profile");
        if (this.mUiccCard instanceof EuiccCard) {
            ((EuiccCard)this.mUiccCard).unregisterForEidReady(this.mHandler);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.unregisterAllAppEvents();
            this.unregisterCurrAppEvents();
            InstallCarrierAppUtils.hideAllNotifications(this.mContext);
            InstallCarrierAppUtils.unregisterPackageInstallReceiver(this.mContext);
            this.mCi.unregisterForOffOrNotAvailable(this.mHandler);
            this.mContext.unregisterReceiver(this.mReceiver);
            if (this.mCatService != null) {
                this.mCatService.dispose();
            }
            for (UiccCardApplication app : this.mUiccApplications) {
                if (app == null) continue;
                app.dispose();
            }
            this.mCatService = null;
            this.mUiccApplications = null;
            this.mCarrierPrivilegeRules = null;
            this.mContext.getContentResolver().unregisterContentObserver(this.mProvisionCompleteContentObserver);
            this.mDisposed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceRadioTech(int radioTech) {
        Object object = this.mLock;
        synchronized (object) {
            UiccProfile.log("Setting radio tech " + ServiceState.rilRadioTechnologyToString(radioTech));
            this.setCurrentAppType(ServiceState.isGsm(radioTech));
            this.updateIccAvailability(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentAppType(boolean isGsm) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentAppType = isGsm ? 1 : 2;
        }
    }

    private void handleCarrierNameOverride() {
        Phone phone;
        SubscriptionController subCon = SubscriptionController.getInstance();
        int subId = subCon.getSubIdUsingPhoneId(this.mPhoneId);
        if (subId == -1) {
            UiccProfile.loge("subId not valid for Phone " + this.mPhoneId);
            return;
        }
        CarrierConfigManager configLoader = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configLoader == null) {
            UiccProfile.loge("Failed to load a Carrier Config");
            return;
        }
        PersistableBundle config = configLoader.getConfigForSubId(subId);
        boolean preferCcName = config.getBoolean("carrier_name_override_bool", false);
        String ccName = config.getString("carrier_name_string");
        String newCarrierName = null;
        String currSpn = this.getServiceProviderName();
        int nameSource = 1;
        if (preferCcName || TextUtils.isEmpty(currSpn) && !TextUtils.isEmpty(ccName)) {
            newCarrierName = ccName;
            nameSource = 3;
        } else if (TextUtils.isEmpty(currSpn) && (phone = PhoneFactory.getPhone(this.mPhoneId)) != null) {
            newCarrierName = phone.getCarrierName();
        }
        if (!TextUtils.isEmpty(newCarrierName)) {
            this.mTelephonyManager.setSimOperatorNameForPhone(this.mPhoneId, newCarrierName);
            this.mOperatorBrandOverrideRegistrants.notifyRegistrants();
        }
        this.updateCarrierNameForSubscription(subCon, subId, nameSource);
    }

    private void handleSimCountryIsoOverride() {
        SubscriptionController subCon = SubscriptionController.getInstance();
        int subId = subCon.getSubIdUsingPhoneId(this.mPhoneId);
        if (subId == -1) {
            UiccProfile.loge("subId not valid for Phone " + this.mPhoneId);
            return;
        }
        CarrierConfigManager configLoader = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configLoader == null) {
            UiccProfile.loge("Failed to load a Carrier Config");
            return;
        }
        PersistableBundle config = configLoader.getConfigForSubId(subId);
        String iso = config.getString("sim_country_iso_override_string");
        if (!TextUtils.isEmpty(iso) && !iso.equals(this.mTelephonyManager.getSimCountryIsoForPhone(this.mPhoneId))) {
            this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, iso);
            subCon.setCountryIso(iso, subId);
        }
    }

    private void updateCarrierNameForSubscription(SubscriptionController subCon, int subId, int nameSource) {
        SubscriptionInfo subInfo = subCon.getActiveSubscriptionInfo(subId, this.mContext.getOpPackageName());
        if (subInfo == null) {
            return;
        }
        CharSequence oldSubName = subInfo.getDisplayName();
        String newCarrierName = this.mTelephonyManager.getSimOperatorName(subId);
        if (!TextUtils.isEmpty(newCarrierName) && !newCarrierName.equals(oldSubName)) {
            UiccProfile.log("sim name[" + this.mPhoneId + "] = " + newCarrierName);
            subCon.setDisplayNameUsingSrc(newCarrierName, subId, nameSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIccAvailability(boolean allAppsChanged) {
        Object object = this.mLock;
        synchronized (object) {
            IccRecords newRecords = null;
            UiccCardApplication newApp = this.getApplication(this.mCurrentAppType);
            if (newApp != null) {
                newRecords = newApp.getIccRecords();
            }
            if (allAppsChanged) {
                this.unregisterAllAppEvents();
                this.registerAllAppEvents();
            }
            if (this.mIccRecords != newRecords || this.mUiccApplication != newApp) {
                UiccProfile.log("Icc changed. Reregistering.");
                this.unregisterCurrAppEvents();
                this.mUiccApplication = newApp;
                this.mIccRecords = newRecords;
                this.registerCurrAppEvents();
            }
            this.updateExternalState();
        }
    }

    void resetProperties() {
        if (this.mCurrentAppType == 1) {
            UiccProfile.log("update icc_operator_numeric=");
            this.mTelephonyManager.setSimOperatorNumericForPhone(this.mPhoneId, "");
            this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, "");
            this.mTelephonyManager.setSimOperatorNameForPhone(this.mPhoneId, "");
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void updateExternalState() {
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ERROR) {
            this.setExternalState(IccCardConstants.State.CARD_IO_ERROR);
            return;
        }
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_RESTRICTED) {
            this.setExternalState(IccCardConstants.State.CARD_RESTRICTED);
            return;
        }
        if (this.mUiccCard instanceof EuiccCard && ((EuiccCard)this.mUiccCard).getEid() == null) {
            UiccProfile.log("EID is not ready yet.");
            return;
        }
        if (this.mUiccApplication == null) {
            UiccProfile.loge("updateExternalState: setting state to NOT_READY because mUiccApplication is null");
            this.setExternalState(IccCardConstants.State.NOT_READY);
            return;
        }
        boolean cardLocked = false;
        IccCardConstants.State lockedState = null;
        IccCardApplicationStatus.AppState appState = this.mUiccApplication.getState();
        IccCardStatus.PinState pin1State = this.mUiccApplication.getPin1State();
        if (pin1State == IccCardStatus.PinState.PINSTATE_ENABLED_PERM_BLOCKED) {
            cardLocked = true;
            lockedState = IccCardConstants.State.PERM_DISABLED;
        } else if (appState == IccCardApplicationStatus.AppState.APPSTATE_PIN) {
            cardLocked = true;
            lockedState = IccCardConstants.State.PIN_REQUIRED;
        } else if (appState == IccCardApplicationStatus.AppState.APPSTATE_PUK) {
            cardLocked = true;
            lockedState = IccCardConstants.State.PUK_REQUIRED;
        } else if (appState == IccCardApplicationStatus.AppState.APPSTATE_SUBSCRIPTION_PERSO && this.mUiccApplication.getPersoSubState() == IccCardApplicationStatus.PersoSubState.PERSOSUBSTATE_SIM_NETWORK) {
            cardLocked = true;
            lockedState = IccCardConstants.State.NETWORK_LOCKED;
        }
        if (cardLocked) {
            if (this.mIccRecords != null && (this.mIccRecords.getLockedRecordsLoaded() || this.mIccRecords.getNetworkLockedRecordsLoaded())) {
                this.setExternalState(lockedState);
            } else {
                this.setExternalState(IccCardConstants.State.NOT_READY);
            }
            return;
        }
        switch (appState) {
            case APPSTATE_UNKNOWN: {
                this.setExternalState(IccCardConstants.State.NOT_READY);
                break;
            }
            case APPSTATE_READY: {
                this.checkAndUpdateIfAnyAppToBeIgnored();
                if (this.areAllApplicationsReady()) {
                    if (this.areAllRecordsLoaded() && this.areCarrierPriviligeRulesLoaded()) {
                        this.setExternalState(IccCardConstants.State.LOADED);
                        break;
                    }
                    this.setExternalState(IccCardConstants.State.READY);
                    break;
                }
                this.setExternalState(IccCardConstants.State.NOT_READY);
            }
        }
    }

    private void registerAllAppEvents() {
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.registerForReady(this.mHandler, 3, null);
            IccRecords ir = app.getIccRecords();
            if (ir == null) continue;
            ir.registerForRecordsLoaded(this.mHandler, 4, null);
            ir.registerForRecordsEvents(this.mHandler, 7, null);
        }
    }

    private void unregisterAllAppEvents() {
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.unregisterForReady(this.mHandler);
            IccRecords ir = app.getIccRecords();
            if (ir == null) continue;
            ir.unregisterForRecordsLoaded(this.mHandler);
            ir.unregisterForRecordsEvents(this.mHandler);
        }
    }

    private void registerCurrAppEvents() {
        if (this.mIccRecords != null) {
            this.mIccRecords.registerForLockedRecordsLoaded(this.mHandler, 2, null);
            this.mIccRecords.registerForNetworkLockedRecordsLoaded(this.mHandler, 5, null);
        }
    }

    private void unregisterCurrAppEvents() {
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForLockedRecordsLoaded(this.mHandler);
            this.mIccRecords.unregisterForNetworkLockedRecordsLoaded(this.mHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExternalState(IccCardConstants.State newState, boolean override) {
        Object object = this.mLock;
        synchronized (object) {
            if (!SubscriptionManager.isValidSlotIndex(this.mPhoneId)) {
                UiccProfile.loge("setExternalState: mPhoneId=" + this.mPhoneId + " is invalid; Return!!");
                return;
            }
            if (!override && newState == this.mExternalState) {
                UiccProfile.log("setExternalState: !override and newstate unchanged from " + (Object)((Object)newState));
                return;
            }
            this.mExternalState = newState;
            if (this.mExternalState == IccCardConstants.State.LOADED && this.mIccRecords != null) {
                String operator = this.mIccRecords.getOperatorNumeric();
                UiccProfile.log("setExternalState: operator=" + operator + " mPhoneId=" + this.mPhoneId);
                if (!TextUtils.isEmpty(operator)) {
                    this.mTelephonyManager.setSimOperatorNumericForPhone(this.mPhoneId, operator);
                    String countryCode = operator.substring(0, 3);
                    if (countryCode != null) {
                        this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, MccTable.countryCodeForMcc(countryCode));
                    } else {
                        UiccProfile.loge("setExternalState: state LOADED; Country code is null");
                    }
                } else {
                    UiccProfile.loge("setExternalState: state LOADED; Operator name is null");
                }
            }
            UiccProfile.log("setExternalState: set mPhoneId=" + this.mPhoneId + " mExternalState=" + (Object)((Object)this.mExternalState));
            UiccController.updateInternalIccState(this.mContext, this.mExternalState, this.getIccStateReason(this.mExternalState), this.mPhoneId);
        }
    }

    private void setExternalState(IccCardConstants.State newState) {
        this.setExternalState(newState, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIccRecordsLoaded() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getRecordsLoaded();
            }
            return false;
        }
    }

    private String getIccStateReason(IccCardConstants.State state) {
        switch (state) {
            case PIN_REQUIRED: {
                return "PIN";
            }
            case PUK_REQUIRED: {
                return "PUK";
            }
            case NETWORK_LOCKED: {
                return "NETWORK";
            }
            case PERM_DISABLED: {
                return "PERM_DISABLED";
            }
            case CARD_IO_ERROR: {
                return "CARD_IO_ERROR";
            }
            case CARD_RESTRICTED: {
                return "CARD_RESTRICTED";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IccCardConstants.State getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mExternalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IccRecords getIccRecords() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerForNetworkLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mNetworkLockedRegistrants.add(r);
            if (this.getState() == IccCardConstants.State.NETWORK_LOCKED) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterForNetworkLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNetworkLockedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPin(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPuk(String puk, String newPin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk(puk, newPin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPin2(String pin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin2(pin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyPuk2(String puk2, String newPin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk2(puk2, newPin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supplyNetworkDepersonalization(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyNetworkDepersonalization(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("CommandsInterface is not set.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIccLockEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccApplication != null && this.mUiccApplication.getIccLockEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIccFdnEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccApplication != null && this.mUiccApplication.getIccFdnEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIccFdnAvailable() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccApplication != null && this.mUiccApplication.getIccFdnAvailable();
        }
    }

    @Override
    public boolean getIccPin2Blocked() {
        return this.mUiccApplication != null && this.mUiccApplication.getIccPin2Blocked();
    }

    @Override
    public boolean getIccPuk2Blocked() {
        return this.mUiccApplication != null && this.mUiccApplication.getIccPuk2Blocked();
    }

    @Override
    public boolean isEmptyProfile() {
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccLockEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccFdnEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccLockPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccFdnPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getServiceProviderName() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getServiceProviderName();
            }
            return null;
        }
    }

    @Override
    public boolean hasIccCard() {
        if (this.mUiccCard.getCardState() != IccCardStatus.CardState.CARDSTATE_ABSENT) {
            return true;
        }
        UiccProfile.loge("hasIccCard: UiccProfile is not null but UiccCard is null or card state is ABSENT");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Context c, CommandsInterface ci, IccCardStatus ics) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUniversalPinState = ics.mUniversalPinState;
            this.mGsmUmtsSubscriptionAppIndex = ics.mGsmUmtsSubscriptionAppIndex;
            this.mCdmaSubscriptionAppIndex = ics.mCdmaSubscriptionAppIndex;
            this.mImsSubscriptionAppIndex = ics.mImsSubscriptionAppIndex;
            this.mContext = c;
            this.mCi = ci;
            this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            UiccProfile.log(ics.mApplications.length + " applications");
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null) {
                    if (i >= ics.mApplications.length) continue;
                    this.mUiccApplications[i] = new UiccCardApplication(this, ics.mApplications[i], this.mContext, this.mCi);
                    continue;
                }
                if (i >= ics.mApplications.length) {
                    this.mUiccApplications[i].dispose();
                    this.mUiccApplications[i] = null;
                    continue;
                }
                this.mUiccApplications[i].update(ics.mApplications[i], this.mContext, this.mCi);
            }
            this.createAndUpdateCatServiceLocked();
            UiccProfile.log("Before privilege rules: " + this.mCarrierPrivilegeRules + " : " + (Object)((Object)ics.mCardState));
            if (this.mCarrierPrivilegeRules == null && ics.mCardState == IccCardStatus.CardState.CARDSTATE_PRESENT) {
                this.mCarrierPrivilegeRules = new UiccCarrierPrivilegeRules(this, this.mHandler.obtainMessage(13));
            } else if (this.mCarrierPrivilegeRules != null && ics.mCardState != IccCardStatus.CardState.CARDSTATE_PRESENT) {
                this.mCarrierPrivilegeRules = null;
                this.mContext.getContentResolver().unregisterContentObserver(this.mProvisionCompleteContentObserver);
            }
            this.sanitizeApplicationIndexesLocked();
            this.updateIccAvailability(true);
        }
    }

    private void createAndUpdateCatServiceLocked() {
        if (this.mUiccApplications.length > 0 && this.mUiccApplications[0] != null) {
            if (this.mCatService == null) {
                this.mCatService = CatService.getInstance(this.mCi, this.mContext, this, this.mPhoneId);
            } else {
                this.mCatService.update(this.mCi, this.mContext, this);
            }
        } else {
            if (this.mCatService != null) {
                this.mCatService.dispose();
            }
            this.mCatService = null;
        }
    }

    protected void finalize() {
        UiccProfile.log("UiccProfile finalized");
    }

    private void sanitizeApplicationIndexesLocked() {
        this.mGsmUmtsSubscriptionAppIndex = this.checkIndexLocked(this.mGsmUmtsSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_SIM, IccCardApplicationStatus.AppType.APPTYPE_USIM);
        this.mCdmaSubscriptionAppIndex = this.checkIndexLocked(this.mCdmaSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_RUIM, IccCardApplicationStatus.AppType.APPTYPE_CSIM);
        this.mImsSubscriptionAppIndex = this.checkIndexLocked(this.mImsSubscriptionAppIndex, IccCardApplicationStatus.AppType.APPTYPE_ISIM, null);
    }

    private boolean isSupportedApplication(UiccCardApplication app) {
        return app.getType() == IccCardApplicationStatus.AppType.APPTYPE_USIM || app.getType() == IccCardApplicationStatus.AppType.APPTYPE_SIM || UiccController.isCdmaSupported(this.mContext) && (app.getType() == IccCardApplicationStatus.AppType.APPTYPE_CSIM || app.getType() == IccCardApplicationStatus.AppType.APPTYPE_RUIM);
    }

    private void checkAndUpdateIfAnyAppToBeIgnored() {
        boolean[] appReadyStateTracker = new boolean[IccCardApplicationStatus.AppType.APPTYPE_ISIM.ordinal() + 1];
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null || !this.isSupportedApplication(app) || !app.isReady()) continue;
            appReadyStateTracker[app.getType().ordinal()] = true;
        }
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null || !this.isSupportedApplication(app) || app.isReady() || !appReadyStateTracker[app.getType().ordinal()]) continue;
            app.setAppIgnoreState(true);
        }
    }

    private boolean areAllApplicationsReady() {
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null || !this.isSupportedApplication(app) || app.isReady() || app.isAppIgnored()) continue;
            return false;
        }
        return this.mUiccApplication != null;
    }

    private boolean areAllRecordsLoaded() {
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || !this.isSupportedApplication(app) || app.isAppIgnored() || (ir = app.getIccRecords()) != null && ir.isLoaded()) continue;
            return false;
        }
        return this.mUiccApplication != null;
    }

    private int checkIndexLocked(int index, IccCardApplicationStatus.AppType expectedAppType, IccCardApplicationStatus.AppType altExpectedAppType) {
        if (this.mUiccApplications == null || index >= this.mUiccApplications.length) {
            UiccProfile.loge("App index " + index + " is invalid since there are no applications");
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (this.mUiccApplications[index].getType() != expectedAppType && this.mUiccApplications[index].getType() != altExpectedAppType) {
            UiccProfile.loge("App index " + index + " is invalid since it's not " + (Object)((Object)expectedAppType) + " and not " + (Object)((Object)altExpectedAppType));
            return -1;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForOpertorBrandOverride(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mOperatorBrandOverrideRegistrants.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForCarrierPrivilegeRulesLoaded(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mCarrierPrivilegeRegistrants.add(r);
            if (this.areCarrierPriviligeRulesLoaded()) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForCarrierPrivilegeRulesLoaded(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCarrierPrivilegeRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForOperatorBrandOverride(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOperatorBrandOverrideRegistrants.remove(h);
        }
    }

    static boolean isPackageInstalled(Context context, String pkgName) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(pkgName, 1);
            UiccProfile.log(pkgName + " is installed.");
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            UiccProfile.log(pkgName + " is not installed.");
            return false;
        }
    }

    private void promptInstallCarrierApp(String pkgName) {
        Intent showDialogIntent = InstallCarrierAppTrampolineActivity.get(this.mContext, pkgName);
        showDialogIntent.addFlags(0x10000000);
        this.mContext.startActivity(showDialogIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCarrierPrivilegesLoadedMessage() {
        UsageStatsManager usm = (UsageStatsManager)this.mContext.getSystemService("usagestats");
        if (usm != null) {
            usm.onCarrierPrivilegedAppsChanged();
        }
        InstallCarrierAppUtils.hideAllNotifications(this.mContext);
        InstallCarrierAppUtils.unregisterPackageInstallReceiver(this.mContext);
        Object object = this.mLock;
        synchronized (object) {
            boolean isProvisioned;
            this.mCarrierPrivilegeRegistrants.notifyRegistrants();
            boolean bl = isProvisioned = Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 1) == 1;
            if (isProvisioned) {
                for (String pkgName : this.getUninstalledCarrierPackages()) {
                    this.promptInstallCarrierApp(pkgName);
                }
            } else {
                Uri uri = Settings.Global.getUriFor("device_provisioned");
                this.mContext.getContentResolver().registerContentObserver(uri, false, this.mProvisionCompleteContentObserver);
            }
        }
    }

    private Set<String> getUninstalledCarrierPackages() {
        String whitelistSetting = Settings.Global.getString(this.mContext.getContentResolver(), "carrier_app_whitelist");
        if (TextUtils.isEmpty(whitelistSetting)) {
            return Collections.emptySet();
        }
        Map<String, String> certPackageMap = UiccProfile.parseToCertificateToPackageMap(whitelistSetting);
        if (certPackageMap.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.mCarrierPrivilegeRules == null) {
            return Collections.emptySet();
        }
        ArraySet<String> uninstalledCarrierPackages = new ArraySet<String>();
        List<UiccAccessRule> accessRules = this.mCarrierPrivilegeRules.getAccessRules();
        for (UiccAccessRule accessRule : accessRules) {
            String certHexString = accessRule.getCertificateHexString().toUpperCase();
            String pkgName = certPackageMap.get(certHexString);
            if (TextUtils.isEmpty(pkgName) || UiccProfile.isPackageInstalled(this.mContext, pkgName)) continue;
            uninstalledCarrierPackages.add(pkgName);
        }
        return uninstalledCarrierPackages;
    }

    @VisibleForTesting
    public static Map<String, String> parseToCertificateToPackageMap(String whitelistSetting) {
        String pairDelim = "\\s*;\\s*";
        String keyValueDelim = "\\s*:\\s*";
        List<String> keyValuePairList = Arrays.asList(whitelistSetting.split("\\s*;\\s*"));
        if (keyValuePairList.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayMap<String, String> map = new ArrayMap<String, String>(keyValuePairList.size());
        for (String keyValueString : keyValuePairList) {
            String[] keyValue = keyValueString.split("\\s*:\\s*");
            if (keyValue.length == 2) {
                map.put(keyValue[0].toUpperCase(), keyValue[1]);
                continue;
            }
            UiccProfile.loge("Incorrect length of key-value pair in carrier app whitelist map.  Length should be exactly 2");
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isApplicationOnIcc(IccCardApplicationStatus.AppType type) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || this.mUiccApplications[i].getType() != type) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardStatus.PinState getUniversalPinState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUniversalPinState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getApplication(int family) {
        Object object = this.mLock;
        synchronized (object) {
            int index = 8;
            switch (family) {
                case 1: {
                    index = this.mGsmUmtsSubscriptionAppIndex;
                    break;
                }
                case 2: {
                    index = this.mCdmaSubscriptionAppIndex;
                    break;
                }
                case 3: {
                    index = this.mImsSubscriptionAppIndex;
                }
            }
            if (index >= 0 && index < this.mUiccApplications.length) {
                return this.mUiccApplications[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getApplicationIndex(int index) {
        Object object = this.mLock;
        synchronized (object) {
            if (index >= 0 && index < this.mUiccApplications.length) {
                return this.mUiccApplications[index];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getApplicationByType(int type) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || this.mUiccApplications[i].getType().ordinal() != type) continue;
                return this.mUiccApplications[i];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetAppWithAid(String aid, boolean reset) {
        Object object = this.mLock;
        synchronized (object) {
            boolean changed = false;
            for (int i = 0; i < this.mUiccApplications.length; ++i) {
                if (this.mUiccApplications[i] == null || !TextUtils.isEmpty(aid) && !aid.equals(this.mUiccApplications[i].getAid())) continue;
                this.mUiccApplications[i].dispose();
                this.mUiccApplications[i] = null;
                changed = true;
            }
            if (reset && TextUtils.isEmpty(aid)) {
                if (this.mCarrierPrivilegeRules != null) {
                    this.mCarrierPrivilegeRules = null;
                    this.mContext.getContentResolver().unregisterContentObserver(this.mProvisionCompleteContentObserver);
                    changed = true;
                }
                if (this.mCatService != null) {
                    this.mCatService.dispose();
                    this.mCatService = null;
                    changed = true;
                }
            }
            return changed;
        }
    }

    public void iccOpenLogicalChannel(String aid, int p2, Message response) {
        this.loglocal("iccOpenLogicalChannel: " + aid + " , " + p2 + " by pid:" + Binder.getCallingPid() + " uid:" + Binder.getCallingUid());
        this.mCi.iccOpenLogicalChannel(aid, p2, this.mHandler.obtainMessage(8, response));
    }

    public void iccCloseLogicalChannel(int channel, Message response) {
        this.loglocal("iccCloseLogicalChannel: " + channel);
        this.mCi.iccCloseLogicalChannel(channel, this.mHandler.obtainMessage(9, response));
    }

    public void iccTransmitApduLogicalChannel(int channel, int cla, int command, int p1, int p2, int p3, String data, Message response) {
        this.mCi.iccTransmitApduLogicalChannel(channel, cla, command, p1, p2, p3, data, this.mHandler.obtainMessage(10, response));
    }

    public void iccTransmitApduBasicChannel(int cla, int command, int p1, int p2, int p3, String data, Message response) {
        this.mCi.iccTransmitApduBasicChannel(cla, command, p1, p2, p3, data, this.mHandler.obtainMessage(11, response));
    }

    public void iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String pathID, Message response) {
        this.mCi.iccIO(command, fileID, pathID, p1, p2, p3, null, null, this.mHandler.obtainMessage(12, response));
    }

    public void sendEnvelopeWithStatus(String contents, Message response) {
        this.mCi.sendEnvelopeWithStatus(contents, response);
    }

    public int getNumApplications() {
        int count = 0;
        for (UiccCardApplication a : this.mUiccApplications) {
            if (a == null) continue;
            ++count;
        }
        return count;
    }

    public int getPhoneId() {
        return this.mPhoneId;
    }

    public boolean areCarrierPriviligeRulesLoaded() {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null || carrierPrivilegeRules.areCarrierPriviligeRulesLoaded();
    }

    public boolean hasCarrierPrivilegeRules() {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules != null && carrierPrivilegeRules.hasCarrierPrivilegeRules();
    }

    public int getCarrierPrivilegeStatus(Signature signature, String packageName) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatus(signature, packageName);
    }

    public int getCarrierPrivilegeStatus(PackageManager packageManager, String packageName) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatus(packageManager, packageName);
    }

    public int getCarrierPrivilegeStatus(PackageInfo packageInfo) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatus(packageInfo);
    }

    public int getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatusForCurrentTransaction(packageManager);
    }

    public int getCarrierPrivilegeStatusForUid(PackageManager packageManager, int uid) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? -1 : carrierPrivilegeRules.getCarrierPrivilegeStatusForUid(packageManager, uid);
    }

    public List<String> getCertsFromCarrierPrivilegeAccessRules() {
        ArrayList<String> certs = new ArrayList<String>();
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        if (carrierPrivilegeRules != null) {
            List<UiccAccessRule> accessRules = carrierPrivilegeRules.getAccessRules();
            for (UiccAccessRule accessRule : accessRules) {
                certs.add(accessRule.getCertificateHexString());
            }
        }
        return certs.isEmpty() ? null : certs;
    }

    public List<String> getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        UiccCarrierPrivilegeRules carrierPrivilegeRules = this.getCarrierPrivilegeRules();
        return carrierPrivilegeRules == null ? null : carrierPrivilegeRules.getCarrierPackageNamesForIntent(packageManager, intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UiccCarrierPrivilegeRules getCarrierPrivilegeRules() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCarrierPrivilegeRules;
        }
    }

    public boolean setOperatorBrandOverride(String brand) {
        UiccProfile.log("setOperatorBrandOverride: " + brand);
        UiccProfile.log("current iccId: " + SubscriptionInfo.givePrintableIccid(this.getIccId()));
        String iccId = this.getIccId();
        if (TextUtils.isEmpty(iccId)) {
            return false;
        }
        SharedPreferences.Editor spEditor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
        String key = OPERATOR_BRAND_OVERRIDE_PREFIX + iccId;
        if (brand == null) {
            spEditor.remove(key).commit();
        } else {
            spEditor.putString(key, brand).commit();
        }
        this.mOperatorBrandOverrideRegistrants.notifyRegistrants();
        return true;
    }

    public String getOperatorBrandOverride() {
        String iccId = this.getIccId();
        if (TextUtils.isEmpty(iccId)) {
            return null;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        return sp.getString(OPERATOR_BRAND_OVERRIDE_PREFIX + iccId, null);
    }

    public String getIccId() {
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || (ir = app.getIccRecords()) == null || ir.getIccId() == null) continue;
            return ir.getIccId();
        }
        return null;
    }

    private static void log(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private static void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    private void loglocal(String msg) {
        UiccController.sLocalLog.log("UiccProfile[" + this.mPhoneId + "]: " + msg);
    }

    @VisibleForTesting
    public void refresh() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13));
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        int i2;
        pw.println("UiccProfile:");
        pw.println(" mCi=" + this.mCi);
        pw.println(" mCatService=" + this.mCatService);
        for (i2 = 0; i2 < this.mCarrierPrivilegeRegistrants.size(); ++i2) {
            pw.println("  mCarrierPrivilegeRegistrants[" + i2 + "]=" + ((Registrant)this.mCarrierPrivilegeRegistrants.get(i2)).getHandler());
        }
        for (i2 = 0; i2 < this.mOperatorBrandOverrideRegistrants.size(); ++i2) {
            pw.println("  mOperatorBrandOverrideRegistrants[" + i2 + "]=" + ((Registrant)this.mOperatorBrandOverrideRegistrants.get(i2)).getHandler());
        }
        pw.println(" mUniversalPinState=" + (Object)((Object)this.mUniversalPinState));
        pw.println(" mGsmUmtsSubscriptionAppIndex=" + this.mGsmUmtsSubscriptionAppIndex);
        pw.println(" mCdmaSubscriptionAppIndex=" + this.mCdmaSubscriptionAppIndex);
        pw.println(" mImsSubscriptionAppIndex=" + this.mImsSubscriptionAppIndex);
        pw.println(" mUiccApplications: length=" + this.mUiccApplications.length);
        for (i2 = 0; i2 < this.mUiccApplications.length; ++i2) {
            if (this.mUiccApplications[i2] == null) {
                pw.println("  mUiccApplications[" + i2 + "]=" + null);
                continue;
            }
            pw.println("  mUiccApplications[" + i2 + "]=" + (Object)((Object)this.mUiccApplications[i2].getType()) + " " + this.mUiccApplications[i2]);
        }
        pw.println();
        for (UiccCardApplication app : this.mUiccApplications) {
            if (app == null) continue;
            app.dump(fd, pw, args);
            pw.println();
        }
        for (UiccCardApplication app : this.mUiccApplications) {
            IccRecords ir;
            if (app == null || (ir = app.getIccRecords()) == null) continue;
            ir.dump(fd, pw, args);
            pw.println();
        }
        if (this.mCarrierPrivilegeRules == null) {
            pw.println(" mCarrierPrivilegeRules: null");
        } else {
            pw.println(" mCarrierPrivilegeRules: " + this.mCarrierPrivilegeRules);
            this.mCarrierPrivilegeRules.dump(fd, pw, args);
        }
        pw.println(" mCarrierPrivilegeRegistrants: size=" + this.mCarrierPrivilegeRegistrants.size());
        for (i = 0; i < this.mCarrierPrivilegeRegistrants.size(); ++i) {
            pw.println("  mCarrierPrivilegeRegistrants[" + i + "]=" + ((Registrant)this.mCarrierPrivilegeRegistrants.get(i)).getHandler());
        }
        pw.flush();
        pw.println(" mNetworkLockedRegistrants: size=" + this.mNetworkLockedRegistrants.size());
        for (i = 0; i < this.mNetworkLockedRegistrants.size(); ++i) {
            pw.println("  mNetworkLockedRegistrants[" + i + "]=" + ((Registrant)this.mNetworkLockedRegistrants.get(i)).getHandler());
        }
        pw.println(" mCurrentAppType=" + this.mCurrentAppType);
        pw.println(" mUiccCard=" + this.mUiccCard);
        pw.println(" mUiccApplication=" + this.mUiccApplication);
        pw.println(" mIccRecords=" + this.mIccRecords);
        pw.println(" mExternalState=" + (Object)((Object)this.mExternalState));
        pw.flush();
    }
}

