/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.uicc.AnswerToReset;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccSlotStatus;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.euicc.EuiccCard;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class UiccSlot
extends Handler {
    private static final String TAG = "UiccSlot";
    private static final boolean DBG = true;
    public static final String EXTRA_ICC_CARD_ADDED = "com.android.internal.telephony.uicc.ICC_CARD_ADDED";
    public static final int INVALID_PHONE_ID = -1;
    private final Object mLock = new Object();
    private boolean mActive;
    private boolean mStateIsUnknown = true;
    private IccCardStatus.CardState mCardState;
    private Context mContext;
    private CommandsInterface mCi;
    private UiccCard mUiccCard;
    private int mLastRadioState = 2;
    private boolean mIsEuicc;
    private String mIccId;
    private AnswerToReset mAtr;
    private int mPhoneId = -1;
    private boolean mIsRemovable;
    private static final int EVENT_CARD_REMOVED = 13;
    private static final int EVENT_CARD_ADDED = 14;

    public UiccSlot(Context c, boolean isActive) {
        this.log("Creating");
        this.mContext = c;
        this.mActive = isActive;
        this.mCardState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CommandsInterface ci, IccCardStatus ics, int phoneId, int slotIndex) {
        this.log("cardStatus update: " + ics.toString());
        Object object = this.mLock;
        synchronized (object) {
            IccCardStatus.CardState oldState = this.mCardState;
            this.mCardState = ics.mCardState;
            this.mIccId = ics.iccid;
            this.mPhoneId = phoneId;
            this.parseAtr(ics.atr);
            this.mCi = ci;
            this.mIsRemovable = this.isSlotRemovable(slotIndex);
            int radioState = this.mCi.getRadioState();
            this.log("update: radioState=" + radioState + " mLastRadioState=" + this.mLastRadioState);
            if (this.absentStateUpdateNeeded(oldState)) {
                this.updateCardStateAbsent();
            } else if ((oldState == null || oldState == IccCardStatus.CardState.CARDSTATE_ABSENT || this.mUiccCard == null) && this.mCardState != IccCardStatus.CardState.CARDSTATE_ABSENT) {
                if (radioState == 1 && this.mLastRadioState == 1) {
                    this.log("update: notify card added");
                    this.sendMessage(this.obtainMessage(14, null));
                }
                if (this.mUiccCard != null) {
                    this.loge("update: mUiccCard != null when card was present; disposing it now");
                    this.mUiccCard.dispose();
                }
                if (!this.mIsEuicc) {
                    this.mUiccCard = new UiccCard(this.mContext, this.mCi, ics, this.mPhoneId, this.mLock);
                } else {
                    if (TextUtils.isEmpty(ics.eid)) {
                        this.loge("update: eid is missing. ics.eid=" + ics.eid);
                    }
                    this.mUiccCard = new EuiccCard(this.mContext, this.mCi, ics, phoneId, this.mLock);
                }
            } else if (this.mUiccCard != null) {
                this.mUiccCard.update(this.mContext, this.mCi, ics);
            }
            this.mLastRadioState = radioState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CommandsInterface ci, IccSlotStatus iss, int slotIndex) {
        this.log("slotStatus update: " + iss.toString());
        Object object = this.mLock;
        synchronized (object) {
            IccCardStatus.CardState oldState = this.mCardState;
            this.mCi = ci;
            this.parseAtr(iss.atr);
            this.mCardState = iss.cardState;
            this.mIccId = iss.iccid;
            this.mIsRemovable = this.isSlotRemovable(slotIndex);
            if (iss.slotState == IccSlotStatus.SlotState.SLOTSTATE_INACTIVE) {
                if (this.mActive) {
                    this.mActive = false;
                    this.mLastRadioState = 2;
                    UiccController.updateInternalIccState(this.mContext, IccCardConstants.State.ABSENT, null, this.mPhoneId, true);
                    this.mPhoneId = -1;
                    this.nullifyUiccCard(true);
                }
            } else {
                this.mActive = true;
                this.mPhoneId = iss.logicalSlotIndex;
                if (this.absentStateUpdateNeeded(oldState)) {
                    this.updateCardStateAbsent();
                }
            }
        }
    }

    private boolean absentStateUpdateNeeded(IccCardStatus.CardState oldState) {
        return (oldState != IccCardStatus.CardState.CARDSTATE_ABSENT || this.mUiccCard != null) && this.mCardState == IccCardStatus.CardState.CARDSTATE_ABSENT;
    }

    private void updateCardStateAbsent() {
        int radioState;
        int n = radioState = this.mCi == null ? 2 : this.mCi.getRadioState();
        if (radioState == 1 && this.mLastRadioState == 1) {
            this.log("update: notify card removed");
            this.sendMessage(this.obtainMessage(13, null));
        }
        UiccController.updateInternalIccState(this.mContext, IccCardConstants.State.ABSENT, null, this.mPhoneId);
        this.nullifyUiccCard(false);
        this.mLastRadioState = radioState;
    }

    private void nullifyUiccCard(boolean stateUnknown) {
        if (this.mUiccCard != null) {
            this.mUiccCard.dispose();
        }
        this.mStateIsUnknown = stateUnknown;
        this.mUiccCard = null;
    }

    public boolean isStateUnknown() {
        if (this.mCardState == null || this.mCardState == IccCardStatus.CardState.CARDSTATE_ABSENT) {
            return this.mStateIsUnknown;
        }
        return this.mUiccCard == null;
    }

    private boolean isSlotRemovable(int slotIndex) {
        int[] euiccSlots = this.mContext.getResources().getIntArray(17236094);
        if (euiccSlots == null) {
            return true;
        }
        for (int euiccSlot : euiccSlots) {
            if (euiccSlot != slotIndex) continue;
            return false;
        }
        return true;
    }

    private void checkIsEuiccSupported() {
        this.mIsEuicc = this.mAtr != null && this.mAtr.isEuiccSupported();
    }

    private void parseAtr(String atr) {
        this.mAtr = AnswerToReset.parseAtr(atr);
        this.checkIsEuiccSupported();
    }

    public boolean isEuicc() {
        return this.mIsEuicc;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public int getPhoneId() {
        return this.mPhoneId;
    }

    public boolean isRemovable() {
        return this.mIsRemovable;
    }

    public String getIccId() {
        if (this.mIccId != null) {
            return this.mIccId;
        }
        if (this.mUiccCard != null) {
            return this.mUiccCard.getIccId();
        }
        return null;
    }

    public boolean isExtendedApduSupported() {
        return this.mAtr != null && this.mAtr.isExtendedApduSupported();
    }

    protected void finalize() {
        this.log("UiccSlot finalized");
    }

    private void onIccSwap(boolean isAdded) {
        boolean isHotSwapSupported = this.mContext.getResources().getBoolean(17891466);
        if (isHotSwapSupported) {
            this.log("onIccSwap: isHotSwapSupported is true, don't prompt for rebooting");
            return;
        }
        this.log("onIccSwap: isHotSwapSupported is false, prompt for rebooting");
        this.promptForRestart(isAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptForRestart(boolean isAdded) {
        Object object = this.mLock;
        synchronized (object) {
            Resources res = this.mContext.getResources();
            String dialogComponent = res.getString(17039740);
            if (dialogComponent != null) {
                Intent intent = new Intent().setComponent(ComponentName.unflattenFromString(dialogComponent)).addFlags(0x10000000).putExtra(EXTRA_ICC_CARD_ADDED, isAdded);
                try {
                    this.mContext.startActivity(intent);
                    return;
                }
                catch (ActivityNotFoundException e) {
                    this.loge("Unable to find ICC hotswap prompt for restart activity: " + e);
                }
            }
            DialogInterface.OnClickListener listener = null;
            listener = new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    Object object = UiccSlot.this.mLock;
                    synchronized (object) {
                        if (which == -1) {
                            UiccSlot.this.log("Reboot due to SIM swap");
                            PowerManager pm = (PowerManager)UiccSlot.this.mContext.getSystemService("power");
                            pm.reboot("SIM is added.");
                        }
                    }
                }
            };
            Resources r = Resources.getSystem();
            String title = isAdded ? r.getString(17041028) : r.getString(17041031);
            String message = isAdded ? r.getString(17041027) : r.getString(17041030);
            String buttonTxt = r.getString(17041032);
            AlertDialog dialog = new AlertDialog.Builder(this.mContext).setTitle(title).setMessage(message).setPositiveButton(buttonTxt, listener).create();
            dialog.getWindow().setType(2003);
            dialog.show();
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 13: {
                this.onIccSwap(false);
                break;
            }
            case 14: {
                this.onIccSwap(true);
                break;
            }
            default: {
                this.loge("Unknown Event " + msg.what);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardStatus.CardState getCardState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCardState == null) {
                return IccCardStatus.CardState.CARDSTATE_ABSENT;
            }
            return this.mCardState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCard getUiccCard() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccCard;
        }
    }

    public void onRadioStateUnavailable() {
        this.nullifyUiccCard(true);
        if (this.mPhoneId != -1) {
            UiccController.updateInternalIccState(this.mContext, IccCardConstants.State.UNKNOWN, null, this.mPhoneId);
        }
        this.mCardState = null;
        this.mLastRadioState = 2;
    }

    private void log(String msg) {
        Rlog.d(TAG, msg);
    }

    private void loge(String msg) {
        Rlog.e(TAG, msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("UiccSlot:");
        pw.println(" mCi=" + this.mCi);
        pw.println(" mActive=" + this.mActive);
        pw.println(" mIsEuicc=" + this.mIsEuicc);
        pw.println(" mLastRadioState=" + this.mLastRadioState);
        pw.println(" mIccId=" + this.mIccId);
        pw.println(" mCardState=" + (Object)((Object)this.mCardState));
        if (this.mUiccCard != null) {
            pw.println(" mUiccCard=" + this.mUiccCard);
            this.mUiccCard.dump(fd, pw, args);
        } else {
            pw.println(" mUiccCard=null");
        }
        pw.println();
        pw.flush();
    }
}

