/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;

public class UiccStateChangedLauncher
extends Handler {
    private static final String TAG = UiccStateChangedLauncher.class.getName();
    private static final int EVENT_ICC_CHANGED = 1;
    private static String sDeviceProvisioningPackage = null;
    private Context mContext;
    private UiccController mUiccController;
    private boolean[] mIsRestricted = null;

    public UiccStateChangedLauncher(Context context, UiccController controller) {
        sDeviceProvisioningPackage = context.getResources().getString(17039717);
        if (sDeviceProvisioningPackage != null && !sDeviceProvisioningPackage.isEmpty()) {
            this.mContext = context;
            this.mUiccController = controller;
            this.mUiccController.registerForIccChanged(this, 1, null);
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                boolean shouldNotify = false;
                if (this.mIsRestricted == null) {
                    this.mIsRestricted = new boolean[TelephonyManager.getDefault().getPhoneCount()];
                    shouldNotify = true;
                }
                for (int i = 0; i < this.mIsRestricted.length; ++i) {
                    UiccCard uiccCard = this.mUiccController.getUiccCardForPhone(i);
                    if ((uiccCard == null || uiccCard.getCardState() != IccCardStatus.CardState.CARDSTATE_RESTRICTED) == this.mIsRestricted[i]) continue;
                    this.mIsRestricted[i] = !this.mIsRestricted[i];
                    shouldNotify = true;
                }
                if (!shouldNotify) break;
                this.notifyStateChanged();
                break;
            }
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
        }
    }

    private void notifyStateChanged() {
        Intent intent = new Intent("android.intent.action.SIM_STATE_CHANGED");
        intent.setPackage(sDeviceProvisioningPackage);
        try {
            this.mContext.sendBroadcast(intent);
        }
        catch (Exception e) {
            Log.e(TAG, e.toString());
        }
    }
}

