/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc.asn1;

import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.asn1.Asn1Node;
import com.android.internal.telephony.uicc.asn1.InvalidAsn1DataException;

public final class Asn1Decoder {
    private final byte[] mSrc;
    private int mPosition;
    private final int mEnd;

    public Asn1Decoder(String hex) {
        this(IccUtils.hexStringToBytes(hex));
    }

    public Asn1Decoder(byte[] src) {
        this(src, 0, src.length);
    }

    public Asn1Decoder(byte[] bytes, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > bytes.length) {
            throw new IndexOutOfBoundsException("Out of the bounds: bytes=[" + bytes.length + "], offset=" + offset + ", length=" + length);
        }
        this.mSrc = bytes;
        this.mPosition = offset;
        this.mEnd = offset + length;
    }

    public int getPosition() {
        return this.mPosition;
    }

    public boolean hasNextNode() {
        return this.mPosition < this.mEnd;
    }

    public Asn1Node nextNode() throws InvalidAsn1DataException {
        int dataLen;
        int tag;
        int b;
        int offset;
        if (this.mPosition >= this.mEnd) {
            throw new IllegalStateException("No bytes to parse.");
        }
        int tagStart = offset = this.mPosition;
        if (((b = this.mSrc[offset++]) & 0x1F) == 31) {
            while (offset < this.mEnd && (this.mSrc[offset++] & 0x80) != 0) {
            }
        }
        if (offset >= this.mEnd) {
            throw new InvalidAsn1DataException(0, "Invalid length at position: " + offset);
        }
        try {
            tag = IccUtils.bytesToInt(this.mSrc, tagStart, offset - tagStart);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAsn1DataException(0, "Cannot parse tag at position: " + tagStart, e);
        }
        b = this.mSrc[offset++];
        if ((b & 0x80) == 0) {
            dataLen = b;
        } else {
            int lenLen = b & 0x7F;
            if (offset + lenLen > this.mEnd) {
                throw new InvalidAsn1DataException(tag, "Cannot parse length at position: " + offset);
            }
            try {
                dataLen = IccUtils.bytesToInt(this.mSrc, offset, lenLen);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidAsn1DataException(tag, "Cannot parse length at position: " + offset, e);
            }
            offset += lenLen;
        }
        if (offset + dataLen > this.mEnd) {
            throw new InvalidAsn1DataException(tag, "Incomplete data at position: " + offset + ", expected bytes: " + dataLen + ", actual bytes: " + (this.mEnd - offset));
        }
        Asn1Node root = new Asn1Node(tag, this.mSrc, offset, dataLen);
        this.mPosition = offset + dataLen;
        return root;
    }
}

