/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc.euicc;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Registrant;
import android.os.RegistrantList;
import android.service.carrier.CarrierIdentifier;
import android.service.euicc.EuiccProfileInfo;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.UiccAccessRule;
import android.telephony.euicc.EuiccNotification;
import android.telephony.euicc.EuiccRulesAuthTable;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.asn1.Asn1Decoder;
import com.android.internal.telephony.uicc.asn1.Asn1Node;
import com.android.internal.telephony.uicc.asn1.InvalidAsn1DataException;
import com.android.internal.telephony.uicc.asn1.TagNotFoundException;
import com.android.internal.telephony.uicc.euicc.EuiccCardErrorException;
import com.android.internal.telephony.uicc.euicc.EuiccCardException;
import com.android.internal.telephony.uicc.euicc.EuiccSpecVersion;
import com.android.internal.telephony.uicc.euicc.Tags;
import com.android.internal.telephony.uicc.euicc.apdu.ApduException;
import com.android.internal.telephony.uicc.euicc.apdu.ApduSender;
import com.android.internal.telephony.uicc.euicc.apdu.ApduSenderResultCallback;
import com.android.internal.telephony.uicc.euicc.apdu.RequestBuilder;
import com.android.internal.telephony.uicc.euicc.apdu.RequestProvider;
import com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback;
import com.android.internal.telephony.uicc.euicc.async.AsyncResultHelper;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;

public class EuiccCard
extends UiccCard {
    private static final String LOG_TAG = "EuiccCard";
    private static final boolean DBG = true;
    private static final String ISD_R_AID = "A0000005591010FFFFFFFF8900000100";
    private static final int ICCID_LENGTH = 20;
    private static final int APDU_ERROR_SIM_REFRESH = 28416;
    private static final int CODE_OK = 0;
    private static final int CODE_PROFILE_NOT_IN_EXPECTED_STATE = 2;
    private static final int CODE_NOTHING_TO_DELETE = 1;
    private static final int CODE_NO_RESULT_AVAILABLE = 1;
    private static final EuiccSpecVersion SGP22_V_2_0 = new EuiccSpecVersion(2, 0, 0);
    private static final EuiccSpecVersion SGP22_V_2_1 = new EuiccSpecVersion(2, 1, 0);
    private static final String DEV_CAP_GSM = "gsm";
    private static final String DEV_CAP_UTRAN = "utran";
    private static final String DEV_CAP_CDMA_1X = "cdma1x";
    private static final String DEV_CAP_HRPD = "hrpd";
    private static final String DEV_CAP_EHRPD = "ehrpd";
    private static final String DEV_CAP_EUTRAN = "eutran";
    private static final String DEV_CAP_NFC = "nfc";
    private static final String DEV_CAP_CRL = "crl";
    private final ApduSender mApduSender;
    private RegistrantList mEidReadyRegistrants;
    private EuiccSpecVersion mSpecVersion;
    private volatile String mEid;

    public EuiccCard(Context c, CommandsInterface ci, IccCardStatus ics, int phoneId, Object lock) {
        super(c, ci, ics, phoneId, lock);
        this.mApduSender = new ApduSender(ci, ISD_R_AID, false);
        if (TextUtils.isEmpty(ics.eid)) {
            EuiccCard.loge("no eid given in constructor for phone " + phoneId);
            this.loadEidAndNotifyRegistrants();
        } else {
            this.mEid = ics.eid;
            this.mCardId = ics.eid;
        }
    }

    public void registerForEidReady(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        if (this.mEid != null) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        } else {
            if (this.mEidReadyRegistrants == null) {
                this.mEidReadyRegistrants = new RegistrantList();
            }
            this.mEidReadyRegistrants.add(r);
        }
    }

    public void unregisterForEidReady(Handler h) {
        if (this.mEidReadyRegistrants != null) {
            this.mEidReadyRegistrants.remove(h);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    protected void loadEidAndNotifyRegistrants() {
        Handler euiccMainThreadHandler = new Handler();
        AsyncResultCallback<String> cardCb = new AsyncResultCallback<String>(){

            @Override
            public void onResult(String result) {
                if (EuiccCard.this.mEidReadyRegistrants != null) {
                    EuiccCard.this.mEidReadyRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                }
            }

            @Override
            public void onException(Throwable e) {
                if (EuiccCard.this.mEidReadyRegistrants != null) {
                    EuiccCard.this.mEidReadyRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                }
                EuiccCard.this.mEid = "";
                EuiccCard.this.mCardId = "";
                Rlog.e(EuiccCard.LOG_TAG, "Failed loading eid", e);
            }
        };
        this.getEid(cardCb, euiccMainThreadHandler);
    }

    public void getSpecVersion(AsyncResultCallback<EuiccSpecVersion> callback, Handler handler) {
        if (this.mSpecVersion != null) {
            AsyncResultHelper.returnResult(this.mSpecVersion, callback, handler);
            return;
        }
        this.sendApdu(this.newRequestProvider(requestBuilder -> {}), response -> this.mSpecVersion, callback, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Context c, CommandsInterface ci, IccCardStatus ics) {
        Object object = this.mLock;
        synchronized (object) {
            if (!TextUtils.isEmpty(ics.eid)) {
                this.mEid = ics.eid;
            }
            super.update(c, ci, ics);
        }
    }

    @Override
    protected void updateCardId() {
        if (TextUtils.isEmpty(this.mEid)) {
            super.updateCardId();
        } else {
            this.mCardId = this.mEid;
        }
    }

    public void getAllProfiles(AsyncResultCallback<EuiccProfileInfo[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48941).addChildAsBytes(92, Tags.EUICC_PROFILE_TAGS).build().toHex())), response -> {
            List<Asn1Node> profileNodes = new Asn1Decoder(response).nextNode().getChild(160, new int[0]).getChildren(227);
            int size = profileNodes.size();
            EuiccProfileInfo[] profiles = new EuiccProfileInfo[size];
            int profileCount = 0;
            for (int i = 0; i < size; ++i) {
                Asn1Node profileNode = profileNodes.get(i);
                if (!profileNode.hasChild(90, new int[0])) {
                    EuiccCard.loge("Profile must have an ICCID.");
                    continue;
                }
                String strippedIccIdString = EuiccCard.stripTrailingFs(profileNode.getChild(90, new int[0]).asBytes());
                EuiccProfileInfo.Builder profileBuilder = new EuiccProfileInfo.Builder(strippedIccIdString);
                EuiccCard.buildProfile(profileNode, profileBuilder);
                EuiccProfileInfo profile = profileBuilder.build();
                profiles[profileCount++] = profile;
            }
            return profiles;
        }, callback, handler);
    }

    public final void getProfile(String iccid, AsyncResultCallback<EuiccProfileInfo> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48941).addChild(Asn1Node.newBuilder(160).addChildAsBytes(90, IccUtils.bcdToBytes(EuiccCard.padTrailingFs(iccid))).build()).addChildAsBytes(92, Tags.EUICC_PROFILE_TAGS).build().toHex())), response -> {
            List<Asn1Node> profileNodes = new Asn1Decoder(response).nextNode().getChild(160, new int[0]).getChildren(227);
            if (profileNodes.isEmpty()) {
                return null;
            }
            Asn1Node profileNode = profileNodes.get(0);
            String strippedIccIdString = EuiccCard.stripTrailingFs(profileNode.getChild(90, new int[0]).asBytes());
            EuiccProfileInfo.Builder profileBuilder = new EuiccProfileInfo.Builder(strippedIccIdString);
            EuiccCard.buildProfile(profileNode, profileBuilder);
            return profileBuilder.build();
        }, callback, handler);
    }

    public void disableProfile(String iccid, boolean refresh, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApduWithSimResetErrorWorkaround(this.newRequestProvider(requestBuilder -> {
            byte[] iccidBytes = IccUtils.bcdToBytes(EuiccCard.padTrailingFs(iccid));
            requestBuilder.addStoreData(Asn1Node.newBuilder(48946).addChild(Asn1Node.newBuilder(160).addChildAsBytes(90, iccidBytes)).addChildAsBoolean(129, refresh).build().toHex());
        }), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            switch (result) {
                case 0: {
                    return null;
                }
                case 2: {
                    EuiccCard.logd("Profile is already disabled, iccid: " + SubscriptionInfo.givePrintableIccid(iccid));
                    return null;
                }
            }
            throw new EuiccCardErrorException(11, result);
        }, callback, handler);
    }

    public void switchToProfile(String iccid, boolean refresh, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApduWithSimResetErrorWorkaround(this.newRequestProvider(requestBuilder -> {
            byte[] iccidBytes = IccUtils.bcdToBytes(EuiccCard.padTrailingFs(iccid));
            requestBuilder.addStoreData(Asn1Node.newBuilder(48945).addChild(Asn1Node.newBuilder(160).addChildAsBytes(90, iccidBytes)).addChildAsBoolean(129, refresh).build().toHex());
        }), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            switch (result) {
                case 0: {
                    return null;
                }
                case 2: {
                    EuiccCard.logd("Profile is already enabled, iccid: " + SubscriptionInfo.givePrintableIccid(iccid));
                    return null;
                }
            }
            throw new EuiccCardErrorException(10, result);
        }, callback, handler);
    }

    public String getEid() {
        return this.mEid;
    }

    public void getEid(AsyncResultCallback<String> callback, Handler handler) {
        if (this.mEid != null) {
            AsyncResultHelper.returnResult(this.mEid, callback, handler);
            return;
        }
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48958).addChildAsBytes(92, new byte[]{90}).build().toHex())), response -> {
            String eid = IccUtils.bytesToHexString(EuiccCard.parseResponse(response).getChild(90, new int[0]).asBytes());
            Object object = this.mLock;
            synchronized (object) {
                this.mEid = eid;
                this.mCardId = eid;
            }
            return eid;
        }, callback, handler);
    }

    public void setNickname(String iccid, String nickname, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48937).addChildAsBytes(90, IccUtils.bcdToBytes(EuiccCard.padTrailingFs(iccid))).addChildAsString(144, nickname).build().toHex())), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            if (result != 0) {
                throw new EuiccCardErrorException(7, result);
            }
            return null;
        }, callback, handler);
    }

    public void deleteProfile(String iccid, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> {
            byte[] iccidBytes = IccUtils.bcdToBytes(EuiccCard.padTrailingFs(iccid));
            requestBuilder.addStoreData(Asn1Node.newBuilder(48947).addChildAsBytes(90, iccidBytes).build().toHex());
        }), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            if (result != 0) {
                throw new EuiccCardErrorException(12, result);
            }
            return null;
        }, callback, handler);
    }

    public void resetMemory(int options, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApduWithSimResetErrorWorkaround(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48948).addChildAsBits(130, options).build().toHex())), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            if (result != 0 && result != 1) {
                throw new EuiccCardErrorException(13, result);
            }
            return null;
        }, callback, handler);
    }

    public void getDefaultSmdpAddress(AsyncResultCallback<String> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48956).build().toHex())), response -> EuiccCard.parseResponse(response).getChild(128, new int[0]).asString(), callback, handler);
    }

    public void getSmdsAddress(AsyncResultCallback<String> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48956).build().toHex())), response -> EuiccCard.parseResponse(response).getChild(129, new int[0]).asString(), callback, handler);
    }

    public void setDefaultSmdpAddress(String defaultSmdpAddress, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48959).addChildAsString(128, defaultSmdpAddress).build().toHex())), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            if (result != 0) {
                throw new EuiccCardErrorException(14, result);
            }
            return null;
        }, callback, handler);
    }

    public void getRulesAuthTable(AsyncResultCallback<EuiccRulesAuthTable> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48963).build().toHex())), response -> {
            Asn1Node root = EuiccCard.parseResponse(response);
            List<Asn1Node> nodes = root.getChildren(160);
            EuiccRulesAuthTable.Builder builder = new EuiccRulesAuthTable.Builder(nodes.size());
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                Asn1Node node = nodes.get(i);
                List<Asn1Node> opIdNodes = node.getChild(48, 161).getChildren();
                int opIdSize = opIdNodes.size();
                CarrierIdentifier[] opIds = new CarrierIdentifier[opIdSize];
                for (int j = 0; j < opIdSize; ++j) {
                    opIds[j] = EuiccCard.buildCarrierIdentifier(opIdNodes.get(j));
                }
                builder.add(node.getChild(48, 128).asBits(), Arrays.asList(opIds), node.getChild(48, 130).asBits());
            }
            return builder.build();
        }, callback, handler);
    }

    public void getEuiccChallenge(AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48942).build().toHex())), response -> EuiccCard.parseResponse(response).getChild(128, new int[0]).asBytes(), callback, handler);
    }

    public void getEuiccInfo1(AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48928).build().toHex())), response -> response, callback, handler);
    }

    public void getEuiccInfo2(AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48930).build().toHex())), response -> response, callback, handler);
    }

    public void authenticateServer(String matchingId, byte[] serverSigned1, byte[] serverSignature1, byte[] euiccCiPkIdToBeUsed, byte[] serverCertificate, AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> {
            byte[] imeiBytes = this.getDeviceId();
            byte[] tacBytes = new byte[4];
            System.arraycopy(imeiBytes, 0, tacBytes, 0, 4);
            Asn1Node.Builder devCapsBuilder = Asn1Node.newBuilder(161);
            String[] devCapsStrings = this.getResources().getStringArray(17236064);
            if (devCapsStrings != null) {
                for (String devCapItem : devCapsStrings) {
                    this.addDeviceCapability(devCapsBuilder, devCapItem);
                }
            } else {
                EuiccCard.logd("No device capabilities set.");
            }
            Asn1Node.Builder ctxParams1Builder = Asn1Node.newBuilder(160).addChildAsString(128, matchingId).addChild(Asn1Node.newBuilder(161).addChildAsBytes(128, tacBytes).addChild(devCapsBuilder).addChildAsBytes(130, imeiBytes));
            requestBuilder.addStoreData(Asn1Node.newBuilder(48952).addChild(new Asn1Decoder(serverSigned1).nextNode()).addChild(new Asn1Decoder(serverSignature1).nextNode()).addChild(new Asn1Decoder(euiccCiPkIdToBeUsed).nextNode()).addChild(new Asn1Decoder(serverCertificate).nextNode()).addChild(ctxParams1Builder).build().toHex());
        }), response -> {
            Asn1Node root = EuiccCard.parseResponse(response);
            if (root.hasChild(161, 2)) {
                throw new EuiccCardErrorException(3, root.getChild(161, 2).asInteger());
            }
            return root.toBytes();
        }, callback, handler);
    }

    public void prepareDownload(byte[] hashCc, byte[] smdpSigned2, byte[] smdpSignature2, byte[] smdpCertificate, AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> {
            Asn1Node.Builder builder = Asn1Node.newBuilder(48929).addChild(new Asn1Decoder(smdpSigned2).nextNode()).addChild(new Asn1Decoder(smdpSignature2).nextNode());
            if (hashCc != null) {
                builder.addChildAsBytes(4, hashCc);
            }
            requestBuilder.addStoreData(builder.addChild(new Asn1Decoder(smdpCertificate).nextNode()).build().toHex());
        }), response -> {
            Asn1Node root = EuiccCard.parseResponse(response);
            if (root.hasChild(161, 2)) {
                throw new EuiccCardErrorException(2, root.getChild(161, 2).asInteger());
            }
            return root.toBytes();
        }, callback, handler);
    }

    public void loadBoundProfilePackage(byte[] boundProfilePackage, AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> {
            int i;
            Asn1Node bppNode = new Asn1Decoder(boundProfilePackage).nextNode();
            Asn1Node initialiseSecureChannelRequest = bppNode.getChild(48931, new int[0]);
            Asn1Node firstSequenceOf87 = bppNode.getChild(160, new int[0]);
            Asn1Node sequenceOf88 = bppNode.getChild(161, new int[0]);
            List<Asn1Node> metaDataSeqs = sequenceOf88.getChildren(136);
            Asn1Node sequenceOf86 = bppNode.getChild(163, new int[0]);
            List<Asn1Node> elementSeqs = sequenceOf86.getChildren(134);
            requestBuilder.addStoreData(bppNode.getHeadAsHex() + initialiseSecureChannelRequest.toHex());
            requestBuilder.addStoreData(firstSequenceOf87.toHex());
            requestBuilder.addStoreData(sequenceOf88.getHeadAsHex());
            int size = metaDataSeqs.size();
            for (i = 0; i < size; ++i) {
                requestBuilder.addStoreData(metaDataSeqs.get(i).toHex());
            }
            if (bppNode.hasChild(162, new int[0])) {
                requestBuilder.addStoreData(bppNode.getChild(162, new int[0]).toHex());
            }
            requestBuilder.addStoreData(sequenceOf86.getHeadAsHex());
            size = elementSeqs.size();
            for (i = 0; i < size; ++i) {
                requestBuilder.addStoreData(elementSeqs.get(i).toHex());
            }
        }), response -> {
            Asn1Node root = EuiccCard.parseResponse(response);
            if (root.hasChild(48935, 162, 161, 129)) {
                Asn1Node errorNode = root.getChild(48935, 162, 161, 129);
                throw new EuiccCardErrorException(5, errorNode.asInteger(), errorNode);
            }
            return root.toBytes();
        }, intermediateResult -> {
            int tag;
            byte[] payload = intermediateResult.payload;
            if (payload != null && payload.length > 2 && (tag = (payload[0] & 0xFF) << 8 | payload[1] & 0xFF) == 48951) {
                EuiccCard.logd("loadBoundProfilePackage failed due to an early error.");
                return false;
            }
            return true;
        }, callback, handler);
    }

    public void cancelSession(byte[] transactionId, int reason, AsyncResultCallback<byte[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48961).addChildAsBytes(128, transactionId).addChildAsInteger(129, reason).build().toHex())), response -> EuiccCard.parseResponseAndCheckSimpleError(response, 4).toBytes(), callback, handler);
    }

    public void listNotifications(int events, AsyncResultCallback<EuiccNotification[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48936).addChildAsBits(129, events).build().toHex())), response -> {
            Asn1Node root = EuiccCard.parseResponseAndCheckSimpleError(response, 6);
            List<Asn1Node> nodes = root.getChild(160, new int[0]).getChildren();
            EuiccNotification[] notifications = new EuiccNotification[nodes.size()];
            for (int i = 0; i < notifications.length; ++i) {
                notifications[i] = EuiccCard.createNotification(nodes.get(i));
            }
            return notifications;
        }, callback, handler);
    }

    public void retrieveNotificationList(int events, AsyncResultCallback<EuiccNotification[]> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48939).addChild(Asn1Node.newBuilder(160).addChildAsBits(129, events)).build().toHex())), response -> {
            Asn1Node root = EuiccCard.parseResponse(response);
            if (root.hasChild(129, new int[0])) {
                int error = root.getChild(129, new int[0]).asInteger();
                switch (error) {
                    case 1: {
                        return new EuiccNotification[0];
                    }
                }
                throw new EuiccCardErrorException(8, error);
            }
            List<Asn1Node> nodes = root.getChild(160, new int[0]).getChildren();
            EuiccNotification[] notifications = new EuiccNotification[nodes.size()];
            for (int i = 0; i < notifications.length; ++i) {
                notifications[i] = EuiccCard.createNotification(nodes.get(i));
            }
            return notifications;
        }, callback, handler);
    }

    public void retrieveNotification(int seqNumber, AsyncResultCallback<EuiccNotification> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48939).addChild(Asn1Node.newBuilder(160).addChildAsInteger(128, seqNumber)).build().toHex())), response -> {
            Asn1Node root = EuiccCard.parseResponseAndCheckSimpleError(response, 8);
            List<Asn1Node> nodes = root.getChild(160, new int[0]).getChildren();
            if (nodes.size() > 0) {
                return EuiccCard.createNotification(nodes.get(0));
            }
            return null;
        }, callback, handler);
    }

    public void removeNotificationFromList(int seqNumber, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApdu(this.newRequestProvider(requestBuilder -> requestBuilder.addStoreData(Asn1Node.newBuilder(48944).addChildAsInteger(128, seqNumber).build().toHex())), response -> {
            int result = EuiccCard.parseSimpleResult(response);
            if (result != 0 && result != 1) {
                throw new EuiccCardErrorException(9, result);
            }
            return null;
        }, callback, handler);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void addDeviceCapability(Asn1Node.Builder devCapBuilder, String devCapItem) {
        Integer version;
        Object[] split = devCapItem.split(",");
        if (split.length != 2) {
            EuiccCard.loge("Invalid device capability item: " + Arrays.toString(split));
            return;
        }
        String devCap = split[0].trim();
        try {
            version = Integer.parseInt(((String)split[1]).trim());
        }
        catch (NumberFormatException e) {
            EuiccCard.loge("Invalid device capability version number.", e);
            return;
        }
        byte[] versionBytes = new byte[]{version.byteValue(), 0, 0};
        switch (devCap) {
            case "gsm": {
                devCapBuilder.addChildAsBytes(128, versionBytes);
                break;
            }
            case "utran": {
                devCapBuilder.addChildAsBytes(129, versionBytes);
                break;
            }
            case "cdma1x": {
                devCapBuilder.addChildAsBytes(130, versionBytes);
                break;
            }
            case "hrpd": {
                devCapBuilder.addChildAsBytes(131, versionBytes);
                break;
            }
            case "ehrpd": {
                devCapBuilder.addChildAsBytes(132, versionBytes);
                break;
            }
            case "eutran": {
                devCapBuilder.addChildAsBytes(133, versionBytes);
                break;
            }
            case "nfc": {
                devCapBuilder.addChildAsBytes(134, versionBytes);
                break;
            }
            case "crl": {
                devCapBuilder.addChildAsBytes(135, versionBytes);
                break;
            }
            default: {
                EuiccCard.loge("Invalid device capability name: " + devCap);
            }
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    protected byte[] getDeviceId() {
        Phone phone = PhoneFactory.getPhone(this.getPhoneId());
        if (phone == null) {
            return new byte[8];
        }
        return EuiccCard.getDeviceId(phone.getDeviceId(), this.mSpecVersion);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static byte[] getDeviceId(String imei, EuiccSpecVersion specVersion) {
        byte[] imeiBytes = new byte[8];
        if (specVersion.compareTo(SGP22_V_2_1) >= 0) {
            imei = imei + 'F';
            IccUtils.bcdToBytes(imei, imeiBytes);
            byte last = imeiBytes[7];
            imeiBytes[7] = (byte)((last & 0xFF) << 4 | (last & 0xFF) >>> 4);
        } else {
            IccUtils.bcdToBytes(imei, imeiBytes);
        }
        return imeiBytes;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    protected Resources getResources() {
        return Resources.getSystem();
    }

    private RequestProvider newRequestProvider(ApduRequestBuilder builder) {
        return (selectResponse, requestBuilder) -> {
            EuiccSpecVersion ver = this.getOrExtractSpecVersion(selectResponse);
            if (ver == null) {
                throw new EuiccCardException("Cannot get eUICC spec version.");
            }
            try {
                if (ver.compareTo(SGP22_V_2_0) < 0) {
                    throw new EuiccCardException("eUICC spec version is unsupported: " + ver);
                }
                builder.build(requestBuilder);
            }
            catch (InvalidAsn1DataException | TagNotFoundException e) {
                throw new EuiccCardException("Cannot parse ASN1 to build request.", e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EuiccSpecVersion getOrExtractSpecVersion(byte[] selectResponse) {
        if (this.mSpecVersion != null) {
            return this.mSpecVersion;
        }
        EuiccSpecVersion ver = EuiccSpecVersion.fromOpenChannelResponse(selectResponse);
        if (ver != null) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSpecVersion == null) {
                    this.mSpecVersion = ver;
                }
            }
        }
        return ver;
    }

    private <T> void sendApdu(RequestProvider requestBuilder, ApduResponseHandler<T> responseHandler, AsyncResultCallback<T> callback, Handler handler) {
        this.sendApdu(requestBuilder, responseHandler, e -> callback.onException(new EuiccCardException("Cannot send APDU.", e)), null, callback, handler);
    }

    private <T> void sendApdu(RequestProvider requestBuilder, ApduResponseHandler<T> responseHandler, ApduIntermediateResultHandler intermediateResultHandler, AsyncResultCallback<T> callback, Handler handler) {
        this.sendApdu(requestBuilder, responseHandler, e -> callback.onException(new EuiccCardException("Cannot send APDU.", e)), intermediateResultHandler, callback, handler);
    }

    private void sendApduWithSimResetErrorWorkaround(RequestProvider requestBuilder, ApduResponseHandler<Void> responseHandler, AsyncResultCallback<Void> callback, Handler handler) {
        this.sendApdu(requestBuilder, responseHandler, e -> {
            if (e instanceof ApduException && ((ApduException)e).getApduStatus() == 28416) {
                EuiccCard.logi("Sim is refreshed after disabling profile, no response got.");
                callback.onResult(null);
            } else {
                callback.onException(new EuiccCardException("Cannot send APDU.", e));
            }
        }, null, callback, handler);
    }

    private <T> void sendApdu(RequestProvider requestBuilder, final ApduResponseHandler<T> responseHandler, final ApduExceptionHandler exceptionHandler, final ApduIntermediateResultHandler intermediateResultHandler, final AsyncResultCallback<T> callback, Handler handler) {
        this.mApduSender.send(requestBuilder, new ApduSenderResultCallback(){

            @Override
            public void onResult(byte[] response) {
                try {
                    callback.onResult(responseHandler.handleResult(response));
                }
                catch (EuiccCardException e) {
                    callback.onException(e);
                }
                catch (InvalidAsn1DataException | TagNotFoundException e) {
                    callback.onException(new EuiccCardException("Cannot parse response: " + IccUtils.bytesToHexString(response), e));
                }
            }

            @Override
            public boolean shouldContinueOnIntermediateResult(IccIoResult result) {
                if (intermediateResultHandler == null) {
                    return true;
                }
                return intermediateResultHandler.shouldContinue(result);
            }

            @Override
            public void onException(Throwable e) {
                exceptionHandler.handleException(e);
            }
        }, handler);
    }

    private static void buildProfile(Asn1Node profileNode, EuiccProfileInfo.Builder profileBuilder) throws TagNotFoundException, InvalidAsn1DataException {
        if (profileNode.hasChild(144, new int[0])) {
            profileBuilder.setNickname(profileNode.getChild(144, new int[0]).asString());
        }
        if (profileNode.hasChild(145, new int[0])) {
            profileBuilder.setServiceProviderName(profileNode.getChild(145, new int[0]).asString());
        }
        if (profileNode.hasChild(146, new int[0])) {
            profileBuilder.setProfileName(profileNode.getChild(146, new int[0]).asString());
        }
        if (profileNode.hasChild(183, new int[0])) {
            profileBuilder.setCarrierIdentifier(EuiccCard.buildCarrierIdentifier(profileNode.getChild(183, new int[0])));
        }
        if (profileNode.hasChild(40816, new int[0])) {
            profileBuilder.setState(profileNode.getChild(40816, new int[0]).asInteger());
        } else {
            profileBuilder.setState(0);
        }
        if (profileNode.hasChild(149, new int[0])) {
            profileBuilder.setProfileClass(profileNode.getChild(149, new int[0]).asInteger());
        } else {
            profileBuilder.setProfileClass(2);
        }
        if (profileNode.hasChild(153, new int[0])) {
            profileBuilder.setPolicyRules(profileNode.getChild(153, new int[0]).asBits());
        }
        if (profileNode.hasChild(49014, new int[0])) {
            List<Asn1Node> refArDoNodes = profileNode.getChild(49014, new int[0]).getChildren(226);
            UiccAccessRule[] rules = EuiccCard.buildUiccAccessRule(refArDoNodes);
            List<UiccAccessRule> rulesList = null;
            if (rules != null) {
                rulesList = Arrays.asList(rules);
            }
            profileBuilder.setUiccAccessRule(rulesList);
        }
    }

    private static CarrierIdentifier buildCarrierIdentifier(Asn1Node node) throws InvalidAsn1DataException, TagNotFoundException {
        String gid1 = null;
        if (node.hasChild(129, new int[0])) {
            gid1 = IccUtils.bytesToHexString(node.getChild(129, new int[0]).asBytes());
        }
        String gid2 = null;
        if (node.hasChild(130, new int[0])) {
            gid2 = IccUtils.bytesToHexString(node.getChild(130, new int[0]).asBytes());
        }
        return new CarrierIdentifier(node.getChild(128, new int[0]).asBytes(), gid1, gid2);
    }

    private static UiccAccessRule[] buildUiccAccessRule(List<Asn1Node> nodes) throws InvalidAsn1DataException, TagNotFoundException {
        if (nodes.isEmpty()) {
            return null;
        }
        int count = nodes.size();
        UiccAccessRule[] rules = new UiccAccessRule[count];
        for (int i = 0; i < count; ++i) {
            Asn1Node node = nodes.get(i);
            Asn1Node refDoNode = node.getChild(225, new int[0]);
            byte[] signature = refDoNode.getChild(193, new int[0]).asBytes();
            String packageName = null;
            if (refDoNode.hasChild(202, new int[0])) {
                packageName = refDoNode.getChild(202, new int[0]).asString();
            }
            long accessType = 0L;
            if (node.hasChild(227, 219)) {
                Asn1Node permArDoNode = node.getChild(227, 219);
                accessType = permArDoNode.asRawLong();
            }
            rules[i] = new UiccAccessRule(signature, packageName, accessType);
        }
        return rules;
    }

    private static EuiccNotification createNotification(Asn1Node node) throws TagNotFoundException, InvalidAsn1DataException {
        Asn1Node metadataNode = node.getTag() == 48943 ? node : (node.getTag() == 48951 ? node.getChild(48935, 48943) : node.getChild(48943, new int[0]));
        return new EuiccNotification(metadataNode.getChild(128, new int[0]).asInteger(), metadataNode.getChild(12, new int[0]).asString(), metadataNode.getChild(129, new int[0]).asBits(), node.getTag() == 48943 ? null : node.toBytes());
    }

    private static int parseSimpleResult(byte[] response) throws EuiccCardException, TagNotFoundException, InvalidAsn1DataException {
        return EuiccCard.parseResponse(response).getChild(128, new int[0]).asInteger();
    }

    private static Asn1Node parseResponse(byte[] response) throws EuiccCardException, InvalidAsn1DataException {
        Asn1Decoder decoder = new Asn1Decoder(response);
        if (!decoder.hasNextNode()) {
            throw new EuiccCardException("Empty response", null);
        }
        return decoder.nextNode();
    }

    private static Asn1Node parseResponseAndCheckSimpleError(byte[] response, int opCode) throws EuiccCardException, InvalidAsn1DataException, TagNotFoundException {
        Asn1Node root = EuiccCard.parseResponse(response);
        if (root.hasChild(129, new int[0])) {
            throw new EuiccCardErrorException(opCode, root.getChild(129, new int[0]).asInteger());
        }
        return root;
    }

    private static String stripTrailingFs(byte[] iccId) {
        return IccUtils.stripTrailingFs(IccUtils.bchToString(iccId, 0, iccId.length));
    }

    private static String padTrailingFs(String iccId) {
        if (!TextUtils.isEmpty(iccId) && iccId.length() < 20) {
            iccId = iccId + new String(new char[20 - iccId.length()]).replace('\u0000', 'F');
        }
        return iccId;
    }

    private static void loge(String message) {
        Rlog.e(LOG_TAG, message);
    }

    private static void loge(String message, Throwable tr) {
        Rlog.e(LOG_TAG, message, tr);
    }

    private static void logi(String message) {
        Rlog.i(LOG_TAG, message);
    }

    private static void logd(String message) {
        Rlog.d(LOG_TAG, message);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        pw.println("EuiccCard:");
        pw.println(" mEid=" + this.mEid);
    }

    private static interface ApduExceptionHandler {
        public void handleException(Throwable var1);
    }

    private static interface ApduIntermediateResultHandler {
        public boolean shouldContinue(IccIoResult var1);
    }

    private static interface ApduResponseHandler<T> {
        public T handleResult(byte[] var1) throws EuiccCardException, TagNotFoundException, InvalidAsn1DataException;
    }

    private static interface ApduRequestBuilder {
        public void build(RequestBuilder var1) throws EuiccCardException, TagNotFoundException, InvalidAsn1DataException;
    }
}

