/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc.euicc;

import android.telephony.Rlog;
import com.android.internal.telephony.uicc.asn1.Asn1Decoder;
import com.android.internal.telephony.uicc.asn1.Asn1Node;
import com.android.internal.telephony.uicc.asn1.InvalidAsn1DataException;
import com.android.internal.telephony.uicc.asn1.TagNotFoundException;
import java.util.Arrays;

public final class EuiccSpecVersion
implements Comparable<EuiccSpecVersion> {
    private static final String LOG_TAG = "EuiccSpecVer";
    private static final int TAG_ISD_R_APP_TEMPLATE = 224;
    private static final int TAG_VERSION = 130;
    private final int[] mVersionValues = new int[3];

    public static EuiccSpecVersion fromOpenChannelResponse(byte[] response) {
        Asn1Node node;
        try {
            Asn1Decoder decoder = new Asn1Decoder(response);
            if (!decoder.hasNextNode()) {
                return null;
            }
            node = decoder.nextNode();
        }
        catch (InvalidAsn1DataException e) {
            Rlog.e(LOG_TAG, "Cannot parse the select response of ISD-R.", e);
            return null;
        }
        try {
            byte[] versionType = node.getTag() == 224 ? node.getChild(130, new int[0]).asBytes() : node.getChild(224, 130).asBytes();
            if (versionType.length == 3) {
                return new EuiccSpecVersion(versionType);
            }
            Rlog.e(LOG_TAG, "Cannot parse select response of ISD-R: " + node.toHex());
        }
        catch (InvalidAsn1DataException | TagNotFoundException e) {
            Rlog.e(LOG_TAG, "Cannot parse select response of ISD-R: " + node.toHex());
        }
        return null;
    }

    public EuiccSpecVersion(int major, int minor, int revision) {
        this.mVersionValues[0] = major;
        this.mVersionValues[1] = minor;
        this.mVersionValues[2] = revision;
    }

    public EuiccSpecVersion(byte[] version) {
        this.mVersionValues[0] = version[0] & 0xFF;
        this.mVersionValues[1] = version[1] & 0xFF;
        this.mVersionValues[2] = version[2] & 0xFF;
    }

    public int getMajor() {
        return this.mVersionValues[0];
    }

    public int getMinor() {
        return this.mVersionValues[1];
    }

    public int getRevision() {
        return this.mVersionValues[2];
    }

    @Override
    public int compareTo(EuiccSpecVersion that) {
        if (this.getMajor() > that.getMajor()) {
            return 1;
        }
        if (this.getMajor() < that.getMajor()) {
            return -1;
        }
        if (this.getMinor() > that.getMinor()) {
            return 1;
        }
        if (this.getMinor() < that.getMinor()) {
            return -1;
        }
        if (this.getRevision() > that.getRevision()) {
            return 1;
        }
        if (this.getRevision() < that.getRevision()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals(this.mVersionValues, ((EuiccSpecVersion)obj).mVersionValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mVersionValues);
    }

    public String toString() {
        return this.mVersionValues[0] + "." + this.mVersionValues[1] + "." + this.mVersionValues[2];
    }
}

