/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.usb;

import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import com.android.internal.util.dump.DualDumpOutputStream;

public class DumpUtils {
    public static void writeAccessory(DualDumpOutputStream dump, String idName, long id2, UsbAccessory accessory) {
        long token = dump.start(idName, id2);
        dump.write("manufacturer", 0x10900000001L, accessory.getManufacturer());
        dump.write("model", 1138166333442L, accessory.getModel());
        com.android.internal.util.dump.DumpUtils.writeStringIfNotNull(dump, "description", 1138166333443L, accessory.getManufacturer());
        dump.write("version", 1138166333444L, accessory.getVersion());
        com.android.internal.util.dump.DumpUtils.writeStringIfNotNull(dump, "uri", 1138166333445L, accessory.getUri());
        dump.write("serial", 1138166333446L, accessory.getSerial());
        dump.end(token);
    }

    public static void writeDevice(DualDumpOutputStream dump, String idName, long id2, UsbDevice device) {
        long token = dump.start(idName, id2);
        dump.write("name", 0x10900000001L, device.getDeviceName());
        dump.write("vendor_id", 1120986464258L, device.getVendorId());
        dump.write("product_id", 1120986464259L, device.getProductId());
        dump.write("class", 1120986464260L, device.getDeviceClass());
        dump.write("subclass", 0x10500000005L, device.getDeviceSubclass());
        dump.write("protocol", 1120986464262L, device.getDeviceProtocol());
        dump.write("manufacturer_name", 1138166333447L, device.getManufacturerName());
        dump.write("product_name", 1138166333448L, device.getProductName());
        dump.write("version", 0x10900000009L, device.getVersion());
        dump.write("serial_number", 1138166333450L, device.getSerialNumber());
        int numConfigurations = device.getConfigurationCount();
        for (int i = 0; i < numConfigurations; ++i) {
            DumpUtils.writeConfiguration(dump, "configurations", 0x20B0000000BL, device.getConfiguration(i));
        }
        dump.end(token);
    }

    private static void writeConfiguration(DualDumpOutputStream dump, String idName, long id2, UsbConfiguration configuration) {
        long token = dump.start(idName, id2);
        dump.write("id", 0x10500000001L, configuration.getId());
        dump.write("name", 1138166333442L, configuration.getName());
        dump.write("attributes", 1155346202627L, configuration.getAttributes());
        dump.write("max_power", 1120986464260L, configuration.getMaxPower());
        int numInterfaces = configuration.getInterfaceCount();
        for (int i = 0; i < numInterfaces; ++i) {
            DumpUtils.writeInterface(dump, "interfaces", 2246267895813L, configuration.getInterface(i));
        }
        dump.end(token);
    }

    private static void writeInterface(DualDumpOutputStream dump, String idName, long id2, UsbInterface iface) {
        long token = dump.start(idName, id2);
        dump.write("id", 0x10500000001L, iface.getId());
        dump.write("alternate_settings", 1120986464258L, iface.getAlternateSetting());
        dump.write("name", 1138166333443L, iface.getName());
        dump.write("class", 1120986464260L, iface.getInterfaceClass());
        dump.write("subclass", 0x10500000005L, iface.getInterfaceSubclass());
        dump.write("protocol", 1120986464262L, iface.getInterfaceProtocol());
        int numEndpoints = iface.getEndpointCount();
        for (int i = 0; i < numEndpoints; ++i) {
            DumpUtils.writeEndpoint(dump, "endpoints", 2246267895815L, iface.getEndpoint(i));
        }
        dump.end(token);
    }

    private static void writeEndpoint(DualDumpOutputStream dump, String idName, long id2, UsbEndpoint endpoint) {
        long token = dump.start(idName, id2);
        dump.write("endpoint_number", 0x10500000001L, endpoint.getEndpointNumber());
        dump.write("direction", 1159641169922L, endpoint.getDirection());
        dump.write("address", 1120986464259L, endpoint.getAddress());
        dump.write("type", 1159641169924L, endpoint.getType());
        dump.write("attributes", 1155346202629L, endpoint.getAttributes());
        dump.write("max_packet_size", 1120986464262L, endpoint.getMaxPacketSize());
        dump.write("interval", 1120986464263L, endpoint.getInterval());
        dump.end(token);
    }

    public static void writePort(DualDumpOutputStream dump, String idName, long id2, UsbPort port) {
        long token = dump.start(idName, id2);
        dump.write("id", 0x10900000001L, port.getId());
        int mode = port.getSupportedModes();
        if (dump.isProto()) {
            if (mode == 0) {
                dump.write("supported_modes", 0x20E00000002L, 0);
            } else {
                if ((mode & 3) == 3) {
                    dump.write("supported_modes", 0x20E00000002L, 3);
                } else if ((mode & 2) == 2) {
                    dump.write("supported_modes", 0x20E00000002L, 2);
                } else if ((mode & 1) == 1) {
                    dump.write("supported_modes", 0x20E00000002L, 1);
                }
                if ((mode & 4) == 4) {
                    dump.write("supported_modes", 0x20E00000002L, 4);
                }
                if ((mode & 8) == 8) {
                    dump.write("supported_modes", 0x20E00000002L, 8);
                }
            }
        } else {
            dump.write("supported_modes", 0x20E00000002L, UsbPort.modeToString(mode));
        }
        dump.end(token);
    }

    private static void writePowerRole(DualDumpOutputStream dump, String idName, long id2, int powerRole) {
        if (dump.isProto()) {
            dump.write(idName, id2, powerRole);
        } else {
            dump.write(idName, id2, UsbPort.powerRoleToString(powerRole));
        }
    }

    private static void writeDataRole(DualDumpOutputStream dump, String idName, long id2, int dataRole) {
        if (dump.isProto()) {
            dump.write(idName, id2, dataRole);
        } else {
            dump.write(idName, id2, UsbPort.dataRoleToString(dataRole));
        }
    }

    private static void writeContaminantPresenceStatus(DualDumpOutputStream dump, String idName, long id2, int contaminantPresenceStatus) {
        if (dump.isProto()) {
            dump.write(idName, id2, contaminantPresenceStatus);
        } else {
            dump.write(idName, id2, UsbPort.contaminantPresenceStatusToString(contaminantPresenceStatus));
        }
    }

    public static void writePortStatus(DualDumpOutputStream dump, String idName, long id2, UsbPortStatus status) {
        int index;
        long token = dump.start(idName, id2);
        dump.write("connected", 0x10800000001L, status.isConnected());
        if (dump.isProto()) {
            dump.write("current_mode", 1159641169922L, status.getCurrentMode());
        } else {
            dump.write("current_mode", 1159641169922L, UsbPort.modeToString(status.getCurrentMode()));
        }
        DumpUtils.writePowerRole(dump, "power_role", 1159641169923L, status.getCurrentPowerRole());
        DumpUtils.writeDataRole(dump, "data_role", 1159641169924L, status.getCurrentDataRole());
        for (int undumpedCombinations = status.getSupportedRoleCombinations(); undumpedCombinations != 0; undumpedCombinations &= ~(1 << index)) {
            index = Integer.numberOfTrailingZeros(undumpedCombinations);
            int powerRole = index / 3 + 0;
            int dataRole = index % 3;
            long roleCombinationToken = dump.start("role_combinations", 2246267895813L);
            DumpUtils.writePowerRole(dump, "power_role", 0x10E00000001L, powerRole);
            DumpUtils.writeDataRole(dump, "data_role", 1159641169922L, dataRole);
            dump.end(roleCombinationToken);
        }
        DumpUtils.writeContaminantPresenceStatus(dump, "contaminant_presence_status", 1159641169926L, status.getContaminantDetectionStatus());
        dump.end(token);
    }
}

