/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.NotificationHeaderView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class MediaNotificationView
extends FrameLayout {
    private final int mNotificationContentMarginEnd;
    private final int mNotificationContentImageMarginEnd;
    private ImageView mRightIcon;
    private View mActions;
    private NotificationHeaderView mHeader;
    private View mMainColumn;
    private View mMediaContent;
    private int mImagePushIn;

    public MediaNotificationView(Context context) {
        this(context, null);
    }

    public MediaNotificationView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaNotificationView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean hasIcon;
        boolean bl = hasIcon = this.mRightIcon.getVisibility() != 8;
        if (!hasIcon) {
            this.resetHeaderIndention();
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int mode = View.MeasureSpec.getMode(widthMeasureSpec);
        boolean reMeasure = false;
        this.mImagePushIn = 0;
        if (hasIcon && mode != 0) {
            ViewGroup.MarginLayoutParams params;
            int marginEnd;
            int fullHeight;
            int size = View.MeasureSpec.getSize(widthMeasureSpec);
            size -= this.mActions.getMeasuredWidth();
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRightIcon.getLayoutParams();
            int imageEndMargin = layoutParams.getMarginEnd();
            if ((size -= imageEndMargin) > (fullHeight = this.mMediaContent.getMeasuredHeight())) {
                size = fullHeight;
            } else if (size < fullHeight) {
                size = Math.max(0, size);
                this.mImagePushIn = fullHeight - size;
            }
            if (layoutParams.width != fullHeight || layoutParams.height != fullHeight) {
                layoutParams.width = fullHeight;
                layoutParams.height = fullHeight;
                this.mRightIcon.setLayoutParams(layoutParams);
                reMeasure = true;
            }
            if ((marginEnd = size + imageEndMargin + this.mNotificationContentMarginEnd) != (params = (ViewGroup.MarginLayoutParams)this.mMainColumn.getLayoutParams()).getMarginEnd()) {
                params.setMarginEnd(marginEnd);
                this.mMainColumn.setLayoutParams(params);
                reMeasure = true;
            }
            int headerMarginEnd = imageEndMargin;
            int headerTextMarginEnd = size + imageEndMargin;
            if (headerTextMarginEnd != this.mHeader.getHeaderTextMarginEnd()) {
                this.mHeader.setHeaderTextMarginEnd(headerTextMarginEnd);
                reMeasure = true;
            }
            if ((params = (ViewGroup.MarginLayoutParams)this.mHeader.getLayoutParams()).getMarginEnd() != headerMarginEnd) {
                params.setMarginEnd(headerMarginEnd);
                this.mHeader.setLayoutParams(params);
                reMeasure = true;
            }
            if (this.mHeader.getPaddingEnd() != this.mNotificationContentImageMarginEnd) {
                this.mHeader.setPaddingRelative(this.mHeader.getPaddingStart(), this.mHeader.getPaddingTop(), this.mNotificationContentImageMarginEnd, this.mHeader.getPaddingBottom());
                reMeasure = true;
            }
        }
        if (reMeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mImagePushIn > 0) {
            if (this.getLayoutDirection() == 1) {
                this.mImagePushIn *= -1;
            }
            this.mRightIcon.layout(this.mRightIcon.getLeft() + this.mImagePushIn, this.mRightIcon.getTop(), this.mRightIcon.getRight() + this.mImagePushIn, this.mRightIcon.getBottom());
        }
    }

    private void resetHeaderIndention() {
        if (this.mHeader.getPaddingEnd() != this.mNotificationContentMarginEnd) {
            this.mHeader.setPaddingRelative(this.mHeader.getPaddingStart(), this.mHeader.getPaddingTop(), this.mNotificationContentMarginEnd, this.mHeader.getPaddingBottom());
        }
        ViewGroup.MarginLayoutParams headerParams = (ViewGroup.MarginLayoutParams)this.mHeader.getLayoutParams();
        headerParams.setMarginEnd(0);
        if (headerParams.getMarginEnd() != 0) {
            headerParams.setMarginEnd(0);
            this.mHeader.setLayoutParams(headerParams);
        }
    }

    public MediaNotificationView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mNotificationContentMarginEnd = context.getResources().getDimensionPixelSize(17105307);
        this.mNotificationContentImageMarginEnd = context.getResources().getDimensionPixelSize(17105305);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mRightIcon = (ImageView)this.findViewById(16909294);
        this.mActions = this.findViewById(16909096);
        this.mHeader = (NotificationHeaderView)this.findViewById(16909164);
        this.mMainColumn = this.findViewById(16909165);
        this.mMediaContent = this.findViewById(16909172);
    }
}

