/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.CertificatePinner;
import com.android.okhttp.ConfigAwareConnectionPool;
import com.android.okhttp.ConnectionSpec;
import com.android.okhttp.ConnectionSpecs;
import com.android.okhttp.HttpHandler;
import com.android.okhttp.OkHttpClient;
import com.android.okhttp.OkUrlFactories;
import com.android.okhttp.OkUrlFactory;
import com.android.okhttp.Protocol;
import dalvik.annotation.compat.UnsupportedAppUsage;
import java.net.Proxy;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;

public final class HttpsHandler
extends HttpHandler {
    private static final ConnectionSpec TLS_CONNECTION_SPEC = ConnectionSpecs.builder(true).allEnabledCipherSuites().allEnabledTlsVersions().supportsTlsExtensions(true).build();
    private static final List<Protocol> HTTP_1_1_ONLY = Collections.singletonList(Protocol.HTTP_1_1);
    private final ConfigAwareConnectionPool configAwareConnectionPool = ConfigAwareConnectionPool.getInstance();

    @UnsupportedAppUsage
    public HttpsHandler() {
    }

    @Override
    protected int getDefaultPort() {
        return 443;
    }

    @Override
    protected OkUrlFactory newOkUrlFactory(Proxy proxy) {
        OkUrlFactory okUrlFactory = HttpsHandler.createHttpsOkUrlFactory(proxy);
        okUrlFactory.client().setConnectionPool(this.configAwareConnectionPool.get());
        return okUrlFactory;
    }

    public static OkUrlFactory createHttpsOkUrlFactory(Proxy proxy) {
        OkUrlFactory okUrlFactory = HttpHandler.createHttpOkUrlFactory(proxy);
        OkUrlFactories.setUrlFilter(okUrlFactory, null);
        OkHttpClient okHttpClient = okUrlFactory.client();
        okHttpClient.setProtocols(HTTP_1_1_ONLY);
        okHttpClient.setConnectionSpecs(Collections.singletonList(TLS_CONNECTION_SPEC));
        okHttpClient.setCertificatePinner(CertificatePinner.DEFAULT);
        okUrlFactory.client().setHostnameVerifier(HttpsURLConnection.getDefaultHostnameVerifier());
        okHttpClient.setSslSocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory());
        return okUrlFactory;
    }
}

