/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal;

import android.net.ssl.SSLSockets;
import com.android.okhttp.Protocol;
import com.android.okhttp.internal.OptionalMethod;
import com.android.okhttp.internal.Util;
import com.android.okhttp.internal.tls.RealTrustRootIndex;
import com.android.okhttp.internal.tls.TrustRootIndex;
import com.android.okhttp.okio.Buffer;
import dalvik.annotation.compat.UnsupportedAppUsage;
import dalvik.system.SocketTagger;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class Platform {
    private static final AtomicReference<Platform> INSTANCE_HOLDER = new AtomicReference<Platform>(new Platform());
    private static final OptionalMethod<Socket> SET_USE_SESSION_TICKETS = new OptionalMethod(null, "setUseSessionTickets", Boolean.TYPE);
    private static final OptionalMethod<Socket> SET_HOSTNAME = new OptionalMethod(null, "setHostname", String.class);
    private static final OptionalMethod<Socket> GET_ALPN_SELECTED_PROTOCOL = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
    private static final OptionalMethod<Socket> SET_ALPN_PROTOCOLS = new OptionalMethod(null, "setAlpnProtocols", byte[].class);

    protected Platform() {
    }

    @UnsupportedAppUsage
    public static Platform get() {
        return INSTANCE_HOLDER.get();
    }

    public static Platform getAndSetForTest(Platform platform) {
        if (platform == null) {
            throw new NullPointerException();
        }
        return INSTANCE_HOLDER.getAndSet(platform);
    }

    @UnsupportedAppUsage
    public void logW(String warning) {
        System.logW((String)warning);
    }

    public void tagSocket(Socket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public void untagSocket(Socket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        SSLParameters sslParams = sslSocket.getSSLParameters();
        if (hostname != null) {
            if (SSLSockets.isSupportedSocket(sslSocket)) {
                SSLSockets.setUseSessionTickets(sslSocket, true);
            } else {
                SET_USE_SESSION_TICKETS.invokeOptionalWithoutCheckedException(sslSocket, true);
            }
            try {
                sslParams.setServerNames(Collections.singletonList(new SNIHostName(hostname)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!Platform.isPlatformSocket(sslSocket)) {
                SET_HOSTNAME.invokeOptionalWithoutCheckedException(sslSocket, hostname);
            }
        }
        sslParams.setApplicationProtocols(Platform.getProtocolIds(protocols));
        if (!Platform.isPlatformSocket(sslSocket) && SET_ALPN_PROTOCOLS.isSupported(sslSocket)) {
            Object[] parameters = new Object[]{Platform.concatLengthPrefixed(protocols)};
            SET_ALPN_PROTOCOLS.invokeWithoutCheckedException(sslSocket, parameters);
        }
        sslSocket.setSSLParameters(sslParams);
    }

    public void afterHandshake(SSLSocket sslSocket) {
    }

    public String getSelectedProtocol(SSLSocket socket) {
        try {
            return socket.getApplicationProtocol();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            boolean alpnSupported = GET_ALPN_SELECTED_PROTOCOL.isSupported(socket);
            if (!alpnSupported) {
                return null;
            }
            byte[] alpnResult = (byte[])GET_ALPN_SELECTED_PROTOCOL.invokeWithoutCheckedException(socket, new Object[0]);
            if (alpnResult != null) {
                return new String(alpnResult, Util.UTF_8);
            }
            return null;
        }
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        socket.connect(address, connectTimeout);
    }

    public String getPrefix() {
        return "X-Android";
    }

    public X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        Class<?> sslParametersClass;
        try {
            sslParametersClass = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Object context = Platform.readFieldOrNull(sslSocketFactory, sslParametersClass, "sslParameters");
        return Platform.readFieldOrNull(context, X509TrustManager.class, "x509TrustManager");
    }

    public TrustRootIndex trustRootIndex(X509TrustManager trustManager) {
        return new RealTrustRootIndex(trustManager.getAcceptedIssuers());
    }

    private static <T> T readFieldOrNull(Object instance, Class<T> fieldType, String fieldName) {
        Object delegate;
        for (Class<?> c = instance.getClass(); c != Object.class; c = c.getSuperclass()) {
            try {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                Object value = field.get(instance);
                if (value == null || !fieldType.isInstance(value)) {
                    return null;
                }
                return fieldType.cast(value);
            }
            catch (NoSuchFieldException field) {
                continue;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }
        if (!fieldName.equals("delegate") && (delegate = Platform.readFieldOrNull(instance, Object.class, "delegate")) != null) {
            return Platform.readFieldOrNull(delegate, fieldType, fieldName);
        }
        return null;
    }

    private static boolean isPlatformSocket(SSLSocket socket) {
        return socket.getClass().getName().startsWith("com.android.org.conscrypt");
    }

    private static String[] getProtocolIds(List<Protocol> protocols) {
        String[] result = new String[protocols.size()];
        for (int i = 0; i < protocols.size(); ++i) {
            result[i] = protocols.get(i).toString();
        }
        return result;
    }

    static byte[] concatLengthPrefixed(List<Protocol> protocols) {
        Buffer result = new Buffer();
        int size = protocols.size();
        for (int i = 0; i < size; ++i) {
            Protocol protocol = protocols.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            result.writeByte(protocol.toString().length());
            result.writeUtf8(protocol.toString());
        }
        return result.readByteArray();
    }
}

