/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.CertBlacklist;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CertBlacklistImpl
implements CertBlacklist {
    private static final Logger logger = Logger.getLogger(CertBlacklistImpl.class.getName());
    private final Set<BigInteger> serialBlacklist;
    private final Set<byte[]> pubkeyBlacklist;
    private static final byte[] HEX_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public CertBlacklistImpl(Set<BigInteger> serialBlacklist, Set<byte[]> pubkeyBlacklist) {
        this.serialBlacklist = serialBlacklist;
        this.pubkeyBlacklist = pubkeyBlacklist;
    }

    public static CertBlacklist getDefault() {
        String androidData = System.getenv("ANDROID_DATA");
        String blacklistRoot = androidData + "/misc/keychain/";
        String defaultPubkeyBlacklistPath = blacklistRoot + "pubkey_blacklist.txt";
        String defaultSerialBlacklistPath = blacklistRoot + "serial_blacklist.txt";
        Set<byte[]> pubkeyBlacklist = CertBlacklistImpl.readPublicKeyBlackList(defaultPubkeyBlacklistPath);
        Set<BigInteger> serialBlacklist = CertBlacklistImpl.readSerialBlackList(defaultSerialBlacklistPath);
        return new CertBlacklistImpl(serialBlacklist, pubkeyBlacklist);
    }

    private static boolean isHex(String value) {
        try {
            new BigInteger(value, 16);
            return true;
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, "Could not parse hex value " + value, e);
            return false;
        }
    }

    private static boolean isPubkeyHash(String value) {
        if (value.length() != 40) {
            logger.log(Level.WARNING, "Invalid pubkey hash length: " + value.length());
            return false;
        }
        return CertBlacklistImpl.isHex(value);
    }

    private static String readBlacklist(String path) {
        try {
            return CertBlacklistImpl.readFileAsString(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not read blacklist", e);
        }
        return "";
    }

    private static String readFileAsString(String path) throws IOException {
        return CertBlacklistImpl.readFileAsBytes(path).toString("UTF-8");
    }

    private static ByteArrayOutputStream readFileAsBytes(String path) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        int byteCount;
        byte[] buffer;
        ByteArrayOutputStream bytes;
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(path, "r");
            bytes = new ByteArrayOutputStream((int)f.length());
            buffer = new byte[8192];
            while (true) {
                if ((byteCount = f.read(buffer)) != -1) break block4;
                byteArrayOutputStream = bytes;
                break;
            }
        }
        catch (Throwable throwable) {
            CertBlacklistImpl.closeQuietly(f);
            throw throwable;
        }
        {
            block4: {
                CertBlacklistImpl.closeQuietly(f);
                return byteArrayOutputStream;
            }
            bytes.write(buffer, 0, byteCount);
            continue;
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Set<BigInteger> readSerialBlackList(String path) {
        HashSet<BigInteger> bl = new HashSet<BigInteger>(Arrays.asList(new BigInteger("077a59bcd53459601ca6907267a6dd1c", 16), new BigInteger("047ecbe9fca55f7bd09eae36e10cae1e", 16), new BigInteger("d8f35f4eb7872b2dab0692e315382fb0", 16), new BigInteger("b0b7133ed096f9b56fae91c874bd3ac0", 16), new BigInteger("9239d5348f40d1695a745470e1f23f43", 16), new BigInteger("e9028b9578e415dc1a710a2b88154447", 16), new BigInteger("d7558fdaf5f1105bb213282b707729a3", 16), new BigInteger("f5c86af36162f13a64f54f6dc9587c06", 16), new BigInteger("392a434f0e07df1f8aa305de34e0c229", 16), new BigInteger("3e75ced46b693021218830ae86a82a71", 16)));
        String serialBlacklist = CertBlacklistImpl.readBlacklist(path);
        if (!serialBlacklist.equals("")) {
            for (String value : serialBlacklist.split(",")) {
                try {
                    bl.add(new BigInteger(value, 16));
                }
                catch (NumberFormatException e) {
                    logger.log(Level.WARNING, "Tried to blacklist invalid serial number " + value, e);
                }
            }
        }
        return Collections.unmodifiableSet(bl);
    }

    private static Set<byte[]> readPublicKeyBlackList(String path) {
        HashSet<byte[]> bl = new HashSet<byte[]>(Arrays.asList("bae78e6bed65a2bf60ddedde7fd91e825865e93d".getBytes(StandardCharsets.UTF_8), "410f36363258f30b347d12ce4863e433437806a8".getBytes(StandardCharsets.UTF_8), "ba3e7bd38cd7e1e6b9cd4c219962e59d7a2f4e37".getBytes(StandardCharsets.UTF_8), "e23b8d105f87710a68d9248050ebefc627be4ca6".getBytes(StandardCharsets.UTF_8), "7b2e16bc39bcd72b456e9f055d1de615b74945db".getBytes(StandardCharsets.UTF_8), "e8f91200c65cee16e039b9f883841661635f81c5".getBytes(StandardCharsets.UTF_8), "0129bcd5b448ae8d2496d1c3e19723919088e152".getBytes(StandardCharsets.UTF_8), "5f3ab33d55007054bc5e3e5553cd8d8465d77c61".getBytes(StandardCharsets.UTF_8), "783333c9687df63377efceddd82efa9101913e8e".getBytes(StandardCharsets.UTF_8), "3ecf4bbbe46096d514bb539bb913d77aa4ef31bf".getBytes(StandardCharsets.UTF_8)));
        String pubkeyBlacklist = CertBlacklistImpl.readBlacklist(path);
        if (!pubkeyBlacklist.equals("")) {
            for (String value : pubkeyBlacklist.split(",")) {
                if (CertBlacklistImpl.isPubkeyHash(value = value.trim())) {
                    bl.add(value.getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                logger.log(Level.WARNING, "Tried to blacklist invalid pubkey " + value);
            }
        }
        return bl;
    }

    @Override
    public boolean isPublicKeyBlackListed(PublicKey publicKey) {
        MessageDigest md;
        byte[] encoded = publicKey.getEncoded();
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (GeneralSecurityException e) {
            logger.log(Level.SEVERE, "Unable to get SHA1 MessageDigest", e);
            return false;
        }
        byte[] out = CertBlacklistImpl.toHex(md.digest(encoded));
        for (byte[] blacklisted : this.pubkeyBlacklist) {
            if (!Arrays.equals(blacklisted, out)) continue;
            return true;
        }
        return false;
    }

    private static byte[] toHex(byte[] in) {
        byte[] out = new byte[in.length * 2];
        int outIndex = 0;
        for (int i = 0; i < in.length; ++i) {
            int value = in[i] & 0xFF;
            out[outIndex++] = HEX_TABLE[value >> 4];
            out[outIndex++] = HEX_TABLE[value & 0xF];
        }
        return out;
    }

    @Override
    public boolean isSerialNumberBlackListed(BigInteger serial) {
        return this.serialBlacklist.contains(serial);
    }
}

