/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.ConscryptCertStore;
import com.android.org.conscrypt.Hex;
import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLX509Certificate;
import com.android.org.conscrypt.io.IoUtils;
import dalvik.annotation.compat.UnsupportedAppUsage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class TrustedCertificateStore
implements ConscryptCertStore {
    private static final String PREFIX_SYSTEM = "system:";
    private static final String PREFIX_USER = "user:";
    private static final CertificateFactory CERT_FACTORY;
    private final File systemDir;
    private final File addedDir;
    private final File deletedDir;

    public static final boolean isSystem(String alias) {
        return alias.startsWith(PREFIX_SYSTEM);
    }

    public static final boolean isUser(String alias) {
        return alias.startsWith(PREFIX_USER);
    }

    public static void setDefaultUserDirectory(File root) {
        PreloadHolder.defaultCaCertsAddedDir = new File(root, "cacerts-added");
        PreloadHolder.defaultCaCertsDeletedDir = new File(root, "cacerts-removed");
    }

    @UnsupportedAppUsage
    public TrustedCertificateStore() {
        this(PreloadHolder.defaultCaCertsSystemDir, PreloadHolder.defaultCaCertsAddedDir, PreloadHolder.defaultCaCertsDeletedDir);
    }

    public TrustedCertificateStore(File systemDir, File addedDir, File deletedDir) {
        this.systemDir = systemDir;
        this.addedDir = addedDir;
        this.deletedDir = deletedDir;
    }

    public Certificate getCertificate(String alias) {
        return this.getCertificate(alias, false);
    }

    public Certificate getCertificate(String alias, boolean includeDeletedSystem) {
        File file = this.fileForAlias(alias);
        if (file == null || TrustedCertificateStore.isUser(alias) && this.isTombstone(file)) {
            return null;
        }
        X509Certificate cert = this.readCertificate(file);
        if (cert == null || TrustedCertificateStore.isSystem(alias) && !includeDeletedSystem && this.isDeletedSystemCertificate(cert)) {
            return null;
        }
        return cert;
    }

    private File fileForAlias(String alias) {
        File file;
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        if (TrustedCertificateStore.isSystem(alias)) {
            file = new File(this.systemDir, alias.substring(PREFIX_SYSTEM.length()));
        } else if (TrustedCertificateStore.isUser(alias)) {
            file = new File(this.addedDir, alias.substring(PREFIX_USER.length()));
        } else {
            return null;
        }
        if (!file.exists() || this.isTombstone(file)) {
            return null;
        }
        return file;
    }

    private boolean isTombstone(File file) {
        return file.length() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private X509Certificate readCertificate(File file) {
        if (!file.isFile()) {
            return null;
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            X509Certificate x509Certificate = (X509Certificate)CERT_FACTORY.generateCertificate(is);
            IoUtils.closeQuietly(is);
            return x509Certificate;
        }
        catch (IOException e) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        catch (CertificateException e2) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCertificate(File file, X509Certificate cert) throws IOException, CertificateException {
        File dir = file.getParentFile();
        dir.mkdirs();
        dir.setReadable(true, false);
        dir.setExecutable(true, false);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(cert.getEncoded());
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(os);
            throw throwable;
        }
        IoUtils.closeQuietly(os);
        file.setReadable(true, false);
    }

    private boolean isDeletedSystemCertificate(X509Certificate x) {
        return this.getCertificateFile(this.deletedDir, x).exists();
    }

    public Date getCreationDate(String alias) {
        if (!this.containsAlias(alias)) {
            return null;
        }
        File file = this.fileForAlias(alias);
        if (file == null) {
            return null;
        }
        long time = file.lastModified();
        if (time == 0L) {
            return null;
        }
        return new Date(time);
    }

    public Set<String> aliases() {
        HashSet<String> result = new HashSet<String>();
        this.addAliases(result, PREFIX_USER, this.addedDir);
        this.addAliases(result, PREFIX_SYSTEM, this.systemDir);
        return result;
    }

    public Set<String> userAliases() {
        HashSet<String> result = new HashSet<String>();
        this.addAliases(result, PREFIX_USER, this.addedDir);
        return result;
    }

    private void addAliases(Set<String> result, String prefix, File dir) {
        String[] files = dir.list();
        if (files == null) {
            return;
        }
        for (String filename : files) {
            String alias = prefix + filename;
            if (!this.containsAlias(alias)) continue;
            result.add(alias);
        }
    }

    public Set<String> allSystemAliases() {
        HashSet<String> result = new HashSet<String>();
        String[] files = this.systemDir.list();
        if (files == null) {
            return result;
        }
        for (String filename : files) {
            String alias = PREFIX_SYSTEM + filename;
            if (!this.containsAlias(alias, true)) continue;
            result.add(alias);
        }
        return result;
    }

    public boolean containsAlias(String alias) {
        return this.containsAlias(alias, false);
    }

    private boolean containsAlias(String alias, boolean includeDeletedSystem) {
        return this.getCertificate(alias, includeDeletedSystem) != null;
    }

    public String getCertificateAlias(Certificate c) {
        return this.getCertificateAlias(c, false);
    }

    public String getCertificateAlias(Certificate c, boolean includeDeletedSystem) {
        if (c == null || !(c instanceof X509Certificate)) {
            return null;
        }
        X509Certificate x = (X509Certificate)c;
        File user = this.getCertificateFile(this.addedDir, x);
        if (user.exists()) {
            return PREFIX_USER + user.getName();
        }
        if (!includeDeletedSystem && this.isDeletedSystemCertificate(x)) {
            return null;
        }
        File system = this.getCertificateFile(this.systemDir, x);
        if (system.exists()) {
            return PREFIX_SYSTEM + system.getName();
        }
        return null;
    }

    public boolean isUserAddedCertificate(X509Certificate cert) {
        return this.getCertificateFile(this.addedDir, cert).exists();
    }

    public File getCertificateFile(File dir, final X509Certificate x) {
        CertSelector selector = new CertSelector(){

            @Override
            public boolean match(X509Certificate cert) {
                return cert.equals(x);
            }
        };
        return this.findCert(dir, x.getSubjectX500Principal(), selector, File.class);
    }

    @Override
    public X509Certificate getTrustAnchor(final X509Certificate c) {
        CertSelector selector = new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                return ca.getPublicKey().equals(c.getPublicKey());
            }
        };
        X509Certificate user = this.findCert(this.addedDir, c.getSubjectX500Principal(), selector, X509Certificate.class);
        if (user != null) {
            return user;
        }
        X509Certificate system = this.findCert(this.systemDir, c.getSubjectX500Principal(), selector, X509Certificate.class);
        if (system != null && !this.isDeletedSystemCertificate(system)) {
            return system;
        }
        return null;
    }

    public X509Certificate findIssuer(final X509Certificate c) {
        CertSelector selector = new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                try {
                    c.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        X500Principal issuer = c.getIssuerX500Principal();
        X509Certificate user = this.findCert(this.addedDir, issuer, selector, X509Certificate.class);
        if (user != null) {
            return user;
        }
        X509Certificate system = this.findCert(this.systemDir, issuer, selector, X509Certificate.class);
        if (system != null && !this.isDeletedSystemCertificate(system)) {
            return system;
        }
        return null;
    }

    @Override
    public Set<X509Certificate> findAllIssuers(final X509Certificate c) {
        Set systemCerts;
        Set issuers = null;
        CertSelector selector = new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                try {
                    c.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        X500Principal issuer = c.getIssuerX500Principal();
        Set userAddedCerts = this.findCert(this.addedDir, issuer, selector, Set.class);
        if (userAddedCerts != null) {
            issuers = userAddedCerts;
        }
        if ((systemCerts = this.findCert(this.systemDir, issuer, selector = new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                try {
                    if (TrustedCertificateStore.this.isDeletedSystemCertificate(ca)) {
                        return false;
                    }
                    c.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }, Set.class)) != null) {
            if (issuers != null) {
                issuers.addAll(systemCerts);
            } else {
                issuers = systemCerts;
            }
        }
        return issuers != null ? issuers : Collections.emptySet();
    }

    private static boolean isSelfIssuedCertificate(OpenSSLX509Certificate cert) {
        long ctx = cert.getContext();
        return NativeCrypto.X509_check_issued(ctx, cert, ctx, cert) == 0;
    }

    private static OpenSSLX509Certificate convertToOpenSSLIfNeeded(X509Certificate cert) throws CertificateException {
        if (cert == null) {
            return null;
        }
        if (cert instanceof OpenSSLX509Certificate) {
            return (OpenSSLX509Certificate)cert;
        }
        try {
            return OpenSSLX509Certificate.fromX509Der(cert.getEncoded());
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    @UnsupportedAppUsage
    public List<X509Certificate> getCertificateChain(X509Certificate leaf) throws CertificateException {
        LinkedHashSet<OpenSSLX509Certificate> chain = new LinkedHashSet<OpenSSLX509Certificate>();
        OpenSSLX509Certificate cert = TrustedCertificateStore.convertToOpenSSLIfNeeded(leaf);
        chain.add(cert);
        while (!TrustedCertificateStore.isSelfIssuedCertificate(cert) && (cert = TrustedCertificateStore.convertToOpenSSLIfNeeded(this.findIssuer(cert))) != null && !chain.contains(cert)) {
            chain.add(cert);
        }
        return new ArrayList<X509Certificate>(chain);
    }

    private <T> T findCert(File dir, X500Principal subject, CertSelector selector, Class<T> desiredReturnType) {
        HashSet<X509Certificate> certs = null;
        String hash = this.hash(subject);
        int index = 0;
        while (true) {
            X509Certificate cert;
            File file;
            if (!(file = this.file(dir, hash, index)).isFile()) {
                if (desiredReturnType == Boolean.class) {
                    return (T)Boolean.FALSE;
                }
                if (desiredReturnType == File.class) {
                    return (T)file;
                }
                if (desiredReturnType == Set.class) {
                    return (T)certs;
                }
                return null;
            }
            if (!this.isTombstone(file) && (cert = this.readCertificate(file)) != null && selector.match(cert)) {
                if (desiredReturnType == X509Certificate.class) {
                    return (T)cert;
                }
                if (desiredReturnType == Boolean.class) {
                    return (T)Boolean.TRUE;
                }
                if (desiredReturnType == File.class) {
                    return (T)file;
                }
                if (desiredReturnType == Set.class) {
                    if (certs == null) {
                        certs = new HashSet<X509Certificate>();
                    }
                    certs.add(cert);
                } else {
                    throw new AssertionError();
                }
            }
            ++index;
        }
    }

    private String hash(X500Principal name) {
        int hash = NativeCrypto.X509_NAME_hash_old(name);
        return Hex.intToHexString(hash, 8);
    }

    private File file(File dir, String hash, int index) {
        return new File(dir, hash + '.' + index);
    }

    public void installCertificate(X509Certificate cert) throws IOException, CertificateException {
        if (cert == null) {
            throw new NullPointerException("cert == null");
        }
        File system = this.getCertificateFile(this.systemDir, cert);
        if (system.exists()) {
            File deleted = this.getCertificateFile(this.deletedDir, cert);
            if (deleted.exists()) {
                if (!deleted.delete()) {
                    throw new IOException("Could not remove " + deleted);
                }
                return;
            }
            return;
        }
        File user = this.getCertificateFile(this.addedDir, cert);
        if (user.exists()) {
            return;
        }
        this.writeCertificate(user, cert);
    }

    public void deleteCertificateEntry(String alias) throws IOException, CertificateException {
        if (alias == null) {
            return;
        }
        File file = this.fileForAlias(alias);
        if (file == null) {
            return;
        }
        if (TrustedCertificateStore.isSystem(alias)) {
            X509Certificate cert = this.readCertificate(file);
            if (cert == null) {
                return;
            }
            File deleted = this.getCertificateFile(this.deletedDir, cert);
            if (deleted.exists()) {
                return;
            }
            this.writeCertificate(deleted, cert);
            return;
        }
        if (TrustedCertificateStore.isUser(alias)) {
            new FileOutputStream(file).close();
            this.removeUnnecessaryTombstones(alias);
            return;
        }
    }

    private void removeUnnecessaryTombstones(String alias) throws IOException {
        File file;
        int lastTombstoneIndex;
        if (!TrustedCertificateStore.isUser(alias)) {
            throw new AssertionError((Object)alias);
        }
        int dotIndex = alias.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new AssertionError((Object)alias);
        }
        String hash = alias.substring(PREFIX_USER.length(), dotIndex);
        if (this.file(this.addedDir, hash, (lastTombstoneIndex = Integer.parseInt(alias.substring(dotIndex + 1))) + 1).exists()) {
            return;
        }
        while (lastTombstoneIndex >= 0 && this.isTombstone(file = this.file(this.addedDir, hash, lastTombstoneIndex))) {
            if (!file.delete()) {
                throw new IOException("Could not remove " + file);
            }
            --lastTombstoneIndex;
        }
    }

    static {
        try {
            CERT_FACTORY = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static interface CertSelector {
        public boolean match(X509Certificate var1);
    }

    private static class PreloadHolder {
        private static File defaultCaCertsSystemDir;
        private static File defaultCaCertsAddedDir;
        private static File defaultCaCertsDeletedDir;

        private PreloadHolder() {
        }

        static {
            String ANDROID_ROOT = System.getenv("ANDROID_ROOT");
            String ANDROID_DATA = System.getenv("ANDROID_DATA");
            defaultCaCertsSystemDir = new File(ANDROID_ROOT + "/etc/security/cacerts");
            TrustedCertificateStore.setDefaultUserDirectory(new File(ANDROID_DATA + "/misc/keychain"));
        }
    }
}

