/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.IUidObserver;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManagerInternal;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseSetArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.StatLogger;
import com.android.server.LocalServices;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class AppStateTracker {
    private static final String TAG = "AppStateTracker";
    private static final boolean DEBUG = false;
    private final Object mLock = new Object();
    private final Context mContext;
    @VisibleForTesting
    static final int TARGET_OP = 70;
    IActivityManager mIActivityManager;
    ActivityManagerInternal mActivityManagerInternal;
    AppOpsManager mAppOpsManager;
    IAppOpsService mAppOpsService;
    PowerManagerInternal mPowerManagerInternal;
    StandbyTracker mStandbyTracker;
    UsageStatsManagerInternal mUsageStatsManagerInternal;
    private final MyHandler mHandler;
    @VisibleForTesting
    FeatureFlagsObserver mFlagsObserver;
    @GuardedBy(value={"mLock"})
    final ArraySet<Pair<Integer, String>> mRunAnyRestrictedPackages = new ArraySet();
    @GuardedBy(value={"mLock"})
    final SparseBooleanArray mActiveUids = new SparseBooleanArray();
    @GuardedBy(value={"mLock"})
    final SparseBooleanArray mForegroundUids = new SparseBooleanArray();
    @GuardedBy(value={"mLock"})
    private int[] mPowerWhitelistedAllAppIds = new int[0];
    @GuardedBy(value={"mLock"})
    private int[] mPowerWhitelistedUserAppIds = new int[0];
    @GuardedBy(value={"mLock"})
    private int[] mTempWhitelistedAppIds = this.mPowerWhitelistedAllAppIds;
    @GuardedBy(value={"mLock"})
    private final SparseSetArray<String> mExemptedPackages = new SparseSetArray();
    @GuardedBy(value={"mLock"})
    final ArraySet<Listener> mListeners = new ArraySet();
    @GuardedBy(value={"mLock"})
    boolean mStarted;
    @GuardedBy(value={"mLock"})
    boolean mIsPluggedIn;
    @GuardedBy(value={"mLock"})
    boolean mBatterySaverEnabled;
    @GuardedBy(value={"mLock"})
    boolean mForceAllAppsStandby;
    @GuardedBy(value={"mLock"})
    boolean mForceAllAppStandbyForSmallBattery;
    @GuardedBy(value={"mLock"})
    boolean mForcedAppStandbyEnabled;
    private final StatLogger mStatLogger = new StatLogger(new String[]{"UID_FG_STATE_CHANGED", "UID_ACTIVE_STATE_CHANGED", "RUN_ANY_CHANGED", "ALL_UNWHITELISTED", "ALL_WHITELIST_CHANGED", "TEMP_WHITELIST_CHANGED", "EXEMPT_CHANGED", "FORCE_ALL_CHANGED", "FORCE_APP_STANDBY_FEATURE_FLAG_CHANGED", "IS_UID_ACTIVE_CACHED", "IS_UID_ACTIVE_RAW"});

    public AppStateTracker(Context context, Looper looper) {
        this.mContext = context;
        this.mHandler = new MyHandler(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSystemServicesReady() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                return;
            }
            this.mStarted = true;
            this.mIActivityManager = Preconditions.checkNotNull(this.injectIActivityManager());
            this.mActivityManagerInternal = Preconditions.checkNotNull(this.injectActivityManagerInternal());
            this.mAppOpsManager = Preconditions.checkNotNull(this.injectAppOpsManager());
            this.mAppOpsService = Preconditions.checkNotNull(this.injectIAppOpsService());
            this.mPowerManagerInternal = Preconditions.checkNotNull(this.injectPowerManagerInternal());
            this.mUsageStatsManagerInternal = Preconditions.checkNotNull(this.injectUsageStatsManagerInternal());
            this.mFlagsObserver = new FeatureFlagsObserver();
            this.mFlagsObserver.register();
            this.mForcedAppStandbyEnabled = this.mFlagsObserver.isForcedAppStandbyEnabled();
            this.mForceAllAppStandbyForSmallBattery = this.mFlagsObserver.isForcedAppStandbyForSmallBatteryEnabled();
            this.mStandbyTracker = new StandbyTracker();
            this.mUsageStatsManagerInternal.addAppIdleStateChangeListener(this.mStandbyTracker);
            try {
                this.mIActivityManager.registerUidObserver(new UidObserver(), 15, -1, null);
                this.mAppOpsService.startWatchingMode(70, null, new AppOpsWatcher());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.USER_REMOVED");
            filter.addAction("android.intent.action.BATTERY_CHANGED");
            this.mContext.registerReceiver(new MyReceiver(), filter);
            this.refreshForcedAppStandbyUidPackagesLocked();
            this.mPowerManagerInternal.registerLowPowerModeObserver(11, state -> {
                Object object = this.mLock;
                synchronized (object) {
                    this.mBatterySaverEnabled = state.batterySaverEnabled;
                    this.updateForceAllAppStandbyState();
                }
            });
            this.mBatterySaverEnabled = this.mPowerManagerInternal.getLowPowerState((int)11).batterySaverEnabled;
            this.updateForceAllAppStandbyState();
        }
    }

    @VisibleForTesting
    AppOpsManager injectAppOpsManager() {
        return this.mContext.getSystemService(AppOpsManager.class);
    }

    @VisibleForTesting
    IAppOpsService injectIAppOpsService() {
        return IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
    }

    @VisibleForTesting
    IActivityManager injectIActivityManager() {
        return ActivityManager.getService();
    }

    @VisibleForTesting
    ActivityManagerInternal injectActivityManagerInternal() {
        return LocalServices.getService(ActivityManagerInternal.class);
    }

    @VisibleForTesting
    PowerManagerInternal injectPowerManagerInternal() {
        return LocalServices.getService(PowerManagerInternal.class);
    }

    @VisibleForTesting
    UsageStatsManagerInternal injectUsageStatsManagerInternal() {
        return LocalServices.getService(UsageStatsManagerInternal.class);
    }

    @VisibleForTesting
    boolean isSmallBatteryDevice() {
        return ActivityManager.isSmallBatteryDevice();
    }

    @VisibleForTesting
    int injectGetGlobalSettingInt(String key, int def) {
        return Settings.Global.getInt(this.mContext.getContentResolver(), key, def);
    }

    @GuardedBy(value={"mLock"})
    private void refreshForcedAppStandbyUidPackagesLocked() {
        this.mRunAnyRestrictedPackages.clear();
        List<AppOpsManager.PackageOps> ops = this.mAppOpsManager.getPackagesForOps(new int[]{70});
        if (ops == null) {
            return;
        }
        int size = ops.size();
        for (int i = 0; i < size; ++i) {
            AppOpsManager.PackageOps pkg = ops.get(i);
            List<AppOpsManager.OpEntry> entries = ops.get(i).getOps();
            for (int j = 0; j < entries.size(); ++j) {
                AppOpsManager.OpEntry ent = entries.get(j);
                if (ent.getOp() != 70 || ent.getMode() == 0) continue;
                this.mRunAnyRestrictedPackages.add(Pair.create(pkg.getUid(), pkg.getPackageName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateForceAllAppStandbyState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mForceAllAppStandbyForSmallBattery && this.isSmallBatteryDevice()) {
                this.toggleForceAllAppsStandbyLocked(!this.mIsPluggedIn);
            } else {
                this.toggleForceAllAppsStandbyLocked(this.mBatterySaverEnabled);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void toggleForceAllAppsStandbyLocked(boolean enable) {
        if (enable == this.mForceAllAppsStandby) {
            return;
        }
        this.mForceAllAppsStandby = enable;
        this.mHandler.notifyForceAllAppsStandbyChanged();
    }

    @GuardedBy(value={"mLock"})
    private int findForcedAppStandbyUidPackageIndexLocked(int uid, String packageName) {
        int size = this.mRunAnyRestrictedPackages.size();
        if (size > 8) {
            return this.mRunAnyRestrictedPackages.indexOf(Pair.create(uid, packageName));
        }
        for (int i = 0; i < size; ++i) {
            Pair<Integer, String> pair = this.mRunAnyRestrictedPackages.valueAt(i);
            if ((Integer)pair.first != uid || !packageName.equals(pair.second)) continue;
            return i;
        }
        return -1;
    }

    @GuardedBy(value={"mLock"})
    boolean isRunAnyRestrictedLocked(int uid, String packageName) {
        return this.findForcedAppStandbyUidPackageIndexLocked(uid, packageName) >= 0;
    }

    @GuardedBy(value={"mLock"})
    boolean updateForcedAppStandbyUidPackageLocked(int uid, String packageName, boolean restricted) {
        boolean wasRestricted;
        int index = this.findForcedAppStandbyUidPackageIndexLocked(uid, packageName);
        boolean bl = wasRestricted = index >= 0;
        if (wasRestricted == restricted) {
            return false;
        }
        if (restricted) {
            this.mRunAnyRestrictedPackages.add(Pair.create(uid, packageName));
        } else {
            this.mRunAnyRestrictedPackages.removeAt(index);
        }
        return true;
    }

    private static boolean addUidToArray(SparseBooleanArray array2, int uid) {
        if (UserHandle.isCore(uid)) {
            return false;
        }
        if (array2.get(uid)) {
            return false;
        }
        array2.put(uid, true);
        return true;
    }

    private static boolean removeUidFromArray(SparseBooleanArray array2, int uid, boolean remove) {
        if (UserHandle.isCore(uid)) {
            return false;
        }
        if (!array2.get(uid)) {
            return false;
        }
        if (remove) {
            array2.delete(uid);
        } else {
            array2.put(uid, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Listener[] cloneListeners() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mListeners.toArray(new Listener[this.mListeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUserRemoved(int removedUserId) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mRunAnyRestrictedPackages.size() - 1; i >= 0; --i) {
                Pair<Integer, String> pair = this.mRunAnyRestrictedPackages.valueAt(i);
                int uid = (Integer)pair.first;
                int userId = UserHandle.getUserId(uid);
                if (userId != removedUserId) continue;
                this.mRunAnyRestrictedPackages.removeAt(i);
            }
            this.cleanUpArrayForUser(this.mActiveUids, removedUserId);
            this.cleanUpArrayForUser(this.mForegroundUids, removedUserId);
            this.mExemptedPackages.remove(removedUserId);
        }
    }

    private void cleanUpArrayForUser(SparseBooleanArray array2, int removedUserId) {
        for (int i = array2.size() - 1; i >= 0; --i) {
            int uid = array2.keyAt(i);
            int userId = UserHandle.getUserId(uid);
            if (userId != removedUserId) continue;
            array2.removeAt(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPowerSaveWhitelistAppIds(int[] powerSaveWhitelistExceptIdleAppIdArray, int[] powerSaveWhitelistUserAppIdArray, int[] tempWhitelistAppIdArray) {
        Object object = this.mLock;
        synchronized (object) {
            int[] previousWhitelist = this.mPowerWhitelistedAllAppIds;
            int[] previousTempWhitelist = this.mTempWhitelistedAppIds;
            this.mPowerWhitelistedAllAppIds = powerSaveWhitelistExceptIdleAppIdArray;
            this.mTempWhitelistedAppIds = tempWhitelistAppIdArray;
            this.mPowerWhitelistedUserAppIds = powerSaveWhitelistUserAppIdArray;
            if (AppStateTracker.isAnyAppIdUnwhitelisted(previousWhitelist, this.mPowerWhitelistedAllAppIds)) {
                this.mHandler.notifyAllUnwhitelisted();
            } else if (!Arrays.equals(previousWhitelist, this.mPowerWhitelistedAllAppIds)) {
                this.mHandler.notifyAllWhitelistChanged();
            }
            if (!Arrays.equals(previousTempWhitelist, this.mTempWhitelistedAppIds)) {
                this.mHandler.notifyTempWhitelistChanged();
            }
        }
    }

    @VisibleForTesting
    static boolean isAnyAppIdUnwhitelisted(int[] prevArray, int[] newArray) {
        boolean newFinished;
        boolean prevFinished;
        int i1 = 0;
        int i2 = 0;
        while (true) {
            prevFinished = i1 >= prevArray.length;
            boolean bl = newFinished = i2 >= newArray.length;
            if (prevFinished || newFinished) break;
            int a1 = prevArray[i1];
            int a2 = newArray[i2];
            if (a1 == a2) {
                ++i1;
                ++i2;
                continue;
            }
            if (a1 < a2) {
                return true;
            }
            ++i2;
        }
        if (prevFinished) {
            return false;
        }
        return newFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListeners.add(listener);
        }
    }

    public boolean areAlarmsRestricted(int uid, String packageName, boolean isExemptOnBatterySaver) {
        return this.isRestricted(uid, packageName, false, isExemptOnBatterySaver);
    }

    public boolean areJobsRestricted(int uid, String packageName, boolean hasForegroundExemption) {
        return this.isRestricted(uid, packageName, true, hasForegroundExemption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areForegroundServicesRestricted(int uid, String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            return this.isRunAnyRestrictedLocked(uid, packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRestricted(int uid, String packageName, boolean useTempWhitelistToo, boolean exemptOnBatterySaver) {
        if (this.isUidActive(uid)) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            int appId = UserHandle.getAppId(uid);
            if (ArrayUtils.contains(this.mPowerWhitelistedAllAppIds, appId)) {
                return false;
            }
            if (useTempWhitelistToo && ArrayUtils.contains(this.mTempWhitelistedAppIds, appId)) {
                return false;
            }
            if (this.mForcedAppStandbyEnabled && this.isRunAnyRestrictedLocked(uid, packageName)) {
                return true;
            }
            if (exemptOnBatterySaver) {
                return false;
            }
            int userId = UserHandle.getUserId(uid);
            if (this.mExemptedPackages.contains(userId, packageName)) {
                return false;
            }
            return this.mForceAllAppsStandby;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUidActive(int uid) {
        if (UserHandle.isCore(uid)) {
            return true;
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.mActiveUids.get(uid);
        }
    }

    public boolean isUidActiveSynced(int uid) {
        if (this.isUidActive(uid)) {
            return true;
        }
        long start = this.mStatLogger.getTime();
        boolean ret = this.mActivityManagerInternal.isUidActive(uid);
        this.mStatLogger.logDurationStat(10, start);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUidInForeground(int uid) {
        if (UserHandle.isCore(uid)) {
            return true;
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.mForegroundUids.get(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isForceAllAppsStandbyEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mForceAllAppsStandby;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunAnyInBackgroundAppOpsAllowed(int uid, String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            return !this.isRunAnyRestrictedLocked(uid, packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUidPowerSaveWhitelisted(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            return ArrayUtils.contains(this.mPowerWhitelistedAllAppIds, UserHandle.getAppId(uid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUidPowerSaveUserWhitelisted(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            return ArrayUtils.contains(this.mPowerWhitelistedUserAppIds, UserHandle.getAppId(uid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUidTempPowerSaveWhitelisted(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            return ArrayUtils.contains(this.mTempWhitelistedAppIds, UserHandle.getAppId(uid));
        }
    }

    @Deprecated
    public void dump(PrintWriter pw, String prefix) {
        this.dump(new IndentingPrintWriter((Writer)pw, "  ").setIndent(prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Forced App Standby Feature enabled: " + this.mForcedAppStandbyEnabled);
            pw.print("Force all apps standby: ");
            pw.println(this.isForceAllAppsStandbyEnabled());
            pw.print("Small Battery Device: ");
            pw.println(this.isSmallBatteryDevice());
            pw.print("Force all apps standby for small battery device: ");
            pw.println(this.mForceAllAppStandbyForSmallBattery);
            pw.print("Plugged In: ");
            pw.println(this.mIsPluggedIn);
            pw.print("Active uids: ");
            this.dumpUids(pw, this.mActiveUids);
            pw.print("Foreground uids: ");
            this.dumpUids(pw, this.mForegroundUids);
            pw.print("Except-idle + user whitelist appids: ");
            pw.println(Arrays.toString(this.mPowerWhitelistedAllAppIds));
            pw.print("User whitelist appids: ");
            pw.println(Arrays.toString(this.mPowerWhitelistedUserAppIds));
            pw.print("Temp whitelist appids: ");
            pw.println(Arrays.toString(this.mTempWhitelistedAppIds));
            pw.println("Exempted packages:");
            pw.increaseIndent();
            for (int i = 0; i < this.mExemptedPackages.size(); ++i) {
                pw.print("User ");
                pw.print(this.mExemptedPackages.keyAt(i));
                pw.println();
                pw.increaseIndent();
                for (int j = 0; j < this.mExemptedPackages.sizeAt(i); ++j) {
                    pw.print(this.mExemptedPackages.valueAt(i, j));
                    pw.println();
                }
                pw.decreaseIndent();
            }
            pw.decreaseIndent();
            pw.println();
            pw.println("Restricted packages:");
            pw.increaseIndent();
            for (Pair<Integer, String> uidAndPackage : this.mRunAnyRestrictedPackages) {
                pw.print(UserHandle.formatUid((Integer)uidAndPackage.first));
                pw.print(" ");
                pw.print((String)uidAndPackage.second);
                pw.println();
            }
            pw.decreaseIndent();
            this.mStatLogger.dump(pw);
        }
    }

    private void dumpUids(PrintWriter pw, SparseBooleanArray array2) {
        pw.print("[");
        String sep = "";
        for (int i = 0; i < array2.size(); ++i) {
            if (!array2.valueAt(i)) continue;
            pw.print(sep);
            pw.print(UserHandle.formatUid(array2.keyAt(i)));
            sep = " ";
        }
        pw.println("]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpProto(ProtoOutputStream proto, long fieldId) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            long token = proto.start(fieldId);
            proto.write(0x10800000001L, this.mForceAllAppsStandby);
            proto.write(1133871366150L, this.isSmallBatteryDevice());
            proto.write(1133871366151L, this.mForceAllAppStandbyForSmallBattery);
            proto.write(0x10800000008L, this.mIsPluggedIn);
            for (i = 0; i < this.mActiveUids.size(); ++i) {
                if (!this.mActiveUids.valueAt(i)) continue;
                proto.write(0x20500000002L, this.mActiveUids.keyAt(i));
            }
            for (i = 0; i < this.mForegroundUids.size(); ++i) {
                if (!this.mForegroundUids.valueAt(i)) continue;
                proto.write(2220498092043L, this.mForegroundUids.keyAt(i));
            }
            for (int appId : this.mPowerWhitelistedAllAppIds) {
                proto.write(2220498092035L, appId);
            }
            for (int appId : this.mPowerWhitelistedUserAppIds) {
                proto.write(2220498092044L, appId);
            }
            for (int appId : this.mTempWhitelistedAppIds) {
                proto.write(2220498092036L, appId);
            }
            for (int i2 = 0; i2 < this.mExemptedPackages.size(); ++i2) {
                for (int j = 0; j < this.mExemptedPackages.sizeAt(i2); ++j) {
                    long token2 = proto.start(2246267895818L);
                    proto.write(0x10500000001L, this.mExemptedPackages.keyAt(i2));
                    proto.write(1138166333442L, this.mExemptedPackages.valueAt(i2, j));
                    proto.end(token2);
                }
            }
            for (Pair<Integer, String> uidAndPackage : this.mRunAnyRestrictedPackages) {
                long token2 = proto.start(2246267895813L);
                proto.write(0x10500000001L, (Integer)uidAndPackage.first);
                proto.write(1138166333442L, (String)uidAndPackage.second);
                proto.end(token2);
            }
            this.mStatLogger.dumpProto(proto, 1146756268041L);
            proto.end(token);
        }
    }

    private class MyHandler
    extends Handler {
        private static final int MSG_UID_ACTIVE_STATE_CHANGED = 0;
        private static final int MSG_UID_FG_STATE_CHANGED = 1;
        private static final int MSG_RUN_ANY_CHANGED = 3;
        private static final int MSG_ALL_UNWHITELISTED = 4;
        private static final int MSG_ALL_WHITELIST_CHANGED = 5;
        private static final int MSG_TEMP_WHITELIST_CHANGED = 6;
        private static final int MSG_FORCE_ALL_CHANGED = 7;
        private static final int MSG_USER_REMOVED = 8;
        private static final int MSG_FORCE_APP_STANDBY_FEATURE_FLAG_CHANGED = 9;
        private static final int MSG_EXEMPT_CHANGED = 10;
        private static final int MSG_ON_UID_STATE_CHANGED = 11;
        private static final int MSG_ON_UID_ACTIVE = 12;
        private static final int MSG_ON_UID_GONE = 13;
        private static final int MSG_ON_UID_IDLE = 14;

        public MyHandler(Looper looper) {
            super(looper);
        }

        public void notifyUidActiveStateChanged(int uid) {
            this.obtainMessage(0, uid, 0).sendToTarget();
        }

        public void notifyUidForegroundStateChanged(int uid) {
            this.obtainMessage(1, uid, 0).sendToTarget();
        }

        public void notifyRunAnyAppOpsChanged(int uid, String packageName) {
            this.obtainMessage(3, uid, 0, packageName).sendToTarget();
        }

        public void notifyAllUnwhitelisted() {
            this.removeMessages(4);
            this.obtainMessage(4).sendToTarget();
        }

        public void notifyAllWhitelistChanged() {
            this.removeMessages(5);
            this.obtainMessage(5).sendToTarget();
        }

        public void notifyTempWhitelistChanged() {
            this.removeMessages(6);
            this.obtainMessage(6).sendToTarget();
        }

        public void notifyForceAllAppsStandbyChanged() {
            this.removeMessages(7);
            this.obtainMessage(7).sendToTarget();
        }

        public void notifyForcedAppStandbyFeatureFlagChanged() {
            this.removeMessages(9);
            this.obtainMessage(9).sendToTarget();
        }

        public void notifyExemptChanged() {
            this.removeMessages(10);
            this.obtainMessage(10).sendToTarget();
        }

        public void doUserRemoved(int userId) {
            this.obtainMessage(8, userId, 0).sendToTarget();
        }

        public void onUidStateChanged(int uid, int procState) {
            this.obtainMessage(11, uid, procState).sendToTarget();
        }

        public void onUidActive(int uid) {
            this.obtainMessage(12, uid, 0).sendToTarget();
        }

        public void onUidGone(int uid, boolean disabled) {
            this.obtainMessage(13, uid, disabled ? 1 : 0).sendToTarget();
        }

        public void onUidIdle(int uid, boolean disabled) {
            this.obtainMessage(14, uid, disabled ? 1 : 0).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            long start;
            AppStateTracker sender;
            switch (msg.what) {
                case 8: {
                    AppStateTracker.this.handleUserRemoved(msg.arg1);
                    return;
                }
            }
            Object object = AppStateTracker.this.mLock;
            synchronized (object) {
                if (!AppStateTracker.this.mStarted) {
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                sender = AppStateTracker.this;
                start = AppStateTracker.this.mStatLogger.getTime();
            }
            switch (msg.what) {
                case 0: {
                    for (Listener l : AppStateTracker.this.cloneListeners()) {
                        l.onUidActiveStateChanged(sender, msg.arg1);
                    }
                    AppStateTracker.this.mStatLogger.logDurationStat(1, start);
                    return;
                }
                case 1: {
                    for (Listener l : AppStateTracker.this.cloneListeners()) {
                        l.onUidForegroundStateChanged(sender, msg.arg1);
                    }
                    AppStateTracker.this.mStatLogger.logDurationStat(0, start);
                    return;
                }
                case 3: {
                    for (Listener l : AppStateTracker.this.cloneListeners()) {
                        l.onRunAnyAppOpsChanged(sender, msg.arg1, (String)msg.obj);
                    }
                    AppStateTracker.this.mStatLogger.logDurationStat(2, start);
                    return;
                }
                case 4: {
                    for (Listener l : AppStateTracker.this.cloneListeners()) {
                        l.onPowerSaveUnwhitelisted(sender);
                    }
                    AppStateTracker.this.mStatLogger.logDurationStat(3, start);
                    return;
                }
                case 5: {
                    for (Listener l : AppStateTracker.this.cloneListeners()) {
                        l.onPowerSaveWhitelistedChanged(sender);
                    }
                    AppStateTracker.this.mStatLogger.logDurationStat(4, start);
                    return;
                }
                case 6: {
                    for (Listener l : AppStateTracker.this.cloneListeners()) {
                        l.onTempPowerSaveWhitelistChanged(sender);
                    }
                    AppStateTracker.this.mStatLogger.logDurationStat(5, start);
                    return;
                }
                case 10: {
                    for (Listener l : AppStateTracker.this.cloneListeners()) {
                        l.onExemptChanged(sender);
                    }
                    AppStateTracker.this.mStatLogger.logDurationStat(6, start);
                    return;
                }
                case 7: {
                    for (Listener l : AppStateTracker.this.cloneListeners()) {
                        l.onForceAllAppsStandbyChanged(sender);
                    }
                    AppStateTracker.this.mStatLogger.logDurationStat(7, start);
                    return;
                }
                case 9: {
                    boolean unblockAlarms;
                    Listener[] listenerArray = AppStateTracker.this.mLock;
                    synchronized (listenerArray) {
                        unblockAlarms = !AppStateTracker.this.mForcedAppStandbyEnabled && !AppStateTracker.this.mForceAllAppsStandby;
                    }
                    for (Listener l : AppStateTracker.this.cloneListeners()) {
                        l.updateAllJobs();
                        if (!unblockAlarms) continue;
                        l.unblockAllUnrestrictedAlarms();
                    }
                    AppStateTracker.this.mStatLogger.logDurationStat(8, start);
                    return;
                }
                case 8: {
                    AppStateTracker.this.handleUserRemoved(msg.arg1);
                    return;
                }
                case 11: {
                    this.handleUidStateChanged(msg.arg1, msg.arg2);
                    return;
                }
                case 12: {
                    this.handleUidActive(msg.arg1);
                    return;
                }
                case 13: {
                    this.handleUidGone(msg.arg1, msg.arg1 != 0);
                    return;
                }
                case 14: {
                    this.handleUidIdle(msg.arg1, msg.arg1 != 0);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleUidStateChanged(int uid, int procState) {
            Object object = AppStateTracker.this.mLock;
            synchronized (object) {
                if (procState > 7) {
                    if (AppStateTracker.removeUidFromArray(AppStateTracker.this.mForegroundUids, uid, false)) {
                        AppStateTracker.this.mHandler.notifyUidForegroundStateChanged(uid);
                    }
                } else if (AppStateTracker.addUidToArray(AppStateTracker.this.mForegroundUids, uid)) {
                    AppStateTracker.this.mHandler.notifyUidForegroundStateChanged(uid);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleUidActive(int uid) {
            Object object = AppStateTracker.this.mLock;
            synchronized (object) {
                if (AppStateTracker.addUidToArray(AppStateTracker.this.mActiveUids, uid)) {
                    AppStateTracker.this.mHandler.notifyUidActiveStateChanged(uid);
                }
            }
        }

        public void handleUidGone(int uid, boolean disabled) {
            this.removeUid(uid, true);
        }

        public void handleUidIdle(int uid, boolean disabled) {
            this.removeUid(uid, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeUid(int uid, boolean remove) {
            Object object = AppStateTracker.this.mLock;
            synchronized (object) {
                if (AppStateTracker.removeUidFromArray(AppStateTracker.this.mActiveUids, uid, remove)) {
                    AppStateTracker.this.mHandler.notifyUidActiveStateChanged(uid);
                }
                if (AppStateTracker.removeUidFromArray(AppStateTracker.this.mForegroundUids, uid, remove)) {
                    AppStateTracker.this.mHandler.notifyUidForegroundStateChanged(uid);
                }
            }
        }
    }

    final class StandbyTracker
    extends UsageStatsManagerInternal.AppIdleStateChangeListener {
        StandbyTracker() {
        }

        @Override
        public void onAppIdleStateChanged(String packageName, int userId, boolean idle, int bucket, int reason) {
            boolean changed = bucket == 5 ? AppStateTracker.this.mExemptedPackages.add(userId, packageName) : AppStateTracker.this.mExemptedPackages.remove(userId, packageName);
            if (changed) {
                AppStateTracker.this.mHandler.notifyExemptChanged();
            }
        }

        @Override
        public void onParoleStateChanged(boolean isParoleOn) {
        }
    }

    private final class MyReceiver
    extends BroadcastReceiver {
        private MyReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_REMOVED".equals(intent.getAction())) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userId > 0) {
                    AppStateTracker.this.mHandler.doUserRemoved(userId);
                }
            } else if ("android.intent.action.BATTERY_CHANGED".equals(intent.getAction())) {
                Object object = AppStateTracker.this.mLock;
                synchronized (object) {
                    AppStateTracker.this.mIsPluggedIn = intent.getIntExtra("plugged", 0) != 0;
                }
                AppStateTracker.this.updateForceAllAppStandbyState();
            }
        }
    }

    private final class AppOpsWatcher
    extends IAppOpsCallback.Stub {
        private AppOpsWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void opChanged(int op, int uid, String packageName) throws RemoteException {
            boolean restricted = false;
            try {
                restricted = AppStateTracker.this.mAppOpsService.checkOperation(70, uid, packageName) != 0;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            Object object = AppStateTracker.this.mLock;
            synchronized (object) {
                if (AppStateTracker.this.updateForcedAppStandbyUidPackageLocked(uid, packageName, restricted)) {
                    AppStateTracker.this.mHandler.notifyRunAnyAppOpsChanged(uid, packageName);
                }
            }
        }
    }

    private final class UidObserver
    extends IUidObserver.Stub {
        private UidObserver() {
        }

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq) {
            AppStateTracker.this.mHandler.onUidStateChanged(uid, procState);
        }

        @Override
        public void onUidActive(int uid) {
            AppStateTracker.this.mHandler.onUidActive(uid);
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
            AppStateTracker.this.mHandler.onUidGone(uid, disabled);
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
            AppStateTracker.this.mHandler.onUidIdle(uid, disabled);
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
        }
    }

    public static abstract class Listener {
        private void onRunAnyAppOpsChanged(AppStateTracker sender, int uid, String packageName) {
            this.updateJobsForUidPackage(uid, packageName, sender.isUidActive(uid));
            if (!sender.areAlarmsRestricted(uid, packageName, false)) {
                this.unblockAlarmsForUidPackage(uid, packageName);
            } else if (!sender.areAlarmsRestricted(uid, packageName, true)) {
                this.unblockAllUnrestrictedAlarms();
            }
            if (!sender.isRunAnyInBackgroundAppOpsAllowed(uid, packageName)) {
                Slog.v(AppStateTracker.TAG, "Package " + packageName + "/" + uid + " toggled into fg service restriction");
                this.stopForegroundServicesForUidPackage(uid, packageName);
            }
        }

        private void onUidForegroundStateChanged(AppStateTracker sender, int uid) {
            this.onUidForeground(uid, sender.isUidInForeground(uid));
        }

        private void onUidActiveStateChanged(AppStateTracker sender, int uid) {
            boolean isActive = sender.isUidActive(uid);
            this.updateJobsForUid(uid, isActive);
            if (isActive) {
                this.unblockAlarmsForUid(uid);
            }
        }

        private void onPowerSaveUnwhitelisted(AppStateTracker sender) {
            this.updateAllJobs();
            this.unblockAllUnrestrictedAlarms();
        }

        private void onPowerSaveWhitelistedChanged(AppStateTracker sender) {
            this.updateAllJobs();
        }

        private void onTempPowerSaveWhitelistChanged(AppStateTracker sender) {
            this.updateAllJobs();
        }

        private void onExemptChanged(AppStateTracker sender) {
            this.updateAllJobs();
            this.unblockAllUnrestrictedAlarms();
        }

        private void onForceAllAppsStandbyChanged(AppStateTracker sender) {
            this.updateAllJobs();
            if (!sender.isForceAllAppsStandbyEnabled()) {
                this.unblockAllUnrestrictedAlarms();
            }
        }

        public void updateAllJobs() {
        }

        public void updateJobsForUid(int uid, boolean isNowActive) {
        }

        public void updateJobsForUidPackage(int uid, String packageName, boolean isNowActive) {
        }

        public void stopForegroundServicesForUidPackage(int uid, String packageName) {
        }

        public void unblockAllUnrestrictedAlarms() {
        }

        public void unblockAlarmsForUid(int uid) {
        }

        public void unblockAlarmsForUidPackage(int uid, String packageName) {
        }

        public void onUidForeground(int uid, boolean foreground) {
        }
    }

    @VisibleForTesting
    class FeatureFlagsObserver
    extends ContentObserver {
        FeatureFlagsObserver() {
            super(null);
        }

        void register() {
            AppStateTracker.this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("forced_app_standby_enabled"), false, this);
            AppStateTracker.this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("forced_app_standby_for_small_battery_enabled"), false, this);
        }

        boolean isForcedAppStandbyEnabled() {
            return AppStateTracker.this.injectGetGlobalSettingInt("forced_app_standby_enabled", 1) == 1;
        }

        boolean isForcedAppStandbyForSmallBatteryEnabled() {
            return AppStateTracker.this.injectGetGlobalSettingInt("forced_app_standby_for_small_battery_enabled", 0) == 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (Settings.Global.getUriFor("forced_app_standby_enabled").equals(uri)) {
                boolean enabled = this.isForcedAppStandbyEnabled();
                Object object = AppStateTracker.this.mLock;
                synchronized (object) {
                    if (AppStateTracker.this.mForcedAppStandbyEnabled == enabled) {
                        return;
                    }
                    AppStateTracker.this.mForcedAppStandbyEnabled = enabled;
                }
                AppStateTracker.this.mHandler.notifyForcedAppStandbyFeatureFlagChanged();
            } else if (Settings.Global.getUriFor("forced_app_standby_for_small_battery_enabled").equals(uri)) {
                boolean enabled = this.isForcedAppStandbyForSmallBatteryEnabled();
                Object object = AppStateTracker.this.mLock;
                synchronized (object) {
                    if (AppStateTracker.this.mForceAllAppStandbyForSmallBattery == enabled) {
                        return;
                    }
                    AppStateTracker.this.mForceAllAppStandbyForSmallBattery = enabled;
                    AppStateTracker.this.updateForceAllAppStandbyState();
                }
            } else {
                Slog.w(AppStateTracker.TAG, "Unexpected feature flag uri encountered: " + uri);
            }
        }
    }

    static interface Stats {
        public static final int UID_FG_STATE_CHANGED = 0;
        public static final int UID_ACTIVE_STATE_CHANGED = 1;
        public static final int RUN_ANY_CHANGED = 2;
        public static final int ALL_UNWHITELISTED = 3;
        public static final int ALL_WHITELIST_CHANGED = 4;
        public static final int TEMP_WHITELIST_CHANGED = 5;
        public static final int EXEMPT_CHANGED = 6;
        public static final int FORCE_ALL_CHANGED = 7;
        public static final int FORCE_APP_STANDBY_FEATURE_FLAG_CHANGED = 8;
        public static final int IS_UID_ACTIVE_CACHED = 9;
        public static final int IS_UID_ACTIVE_RAW = 10;
    }
}

