/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.LruCache;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;

public final class AttributeCache {
    private static final int CACHE_SIZE = 4;
    private static AttributeCache sInstance = null;
    private final Context mContext;
    @GuardedBy(value={"this"})
    private final LruCache<String, Package> mPackages = new LruCache(4);
    @GuardedBy(value={"this"})
    private final Configuration mConfiguration = new Configuration();

    public static void init(Context context) {
        if (sInstance == null) {
            sInstance = new AttributeCache(context);
        }
    }

    public static AttributeCache instance() {
        return sInstance;
    }

    public AttributeCache(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(String packageName) {
        AttributeCache attributeCache = this;
        synchronized (attributeCache) {
            Package pkg = this.mPackages.remove(packageName);
            if (pkg != null) {
                for (int i = 0; i < pkg.mMap.size(); ++i) {
                    ArrayMap map = (ArrayMap)pkg.mMap.valueAt(i);
                    for (int j = 0; j < map.size(); ++j) {
                        ((Entry)map.valueAt(j)).recycle();
                    }
                }
                Resources res = pkg.context.getResources();
                res.flushLayoutCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(Configuration config) {
        AttributeCache attributeCache = this;
        synchronized (attributeCache) {
            int changes = this.mConfiguration.updateFrom(config);
            if ((changes & 0xBFFFFF5F) != 0) {
                this.mPackages.evictAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get(String packageName, int resId, int[] styleable2, int userId) {
        AttributeCache attributeCache = this;
        synchronized (attributeCache) {
            Package pkg = this.mPackages.get(packageName);
            ArrayMap<int[], Entry> map = null;
            Entry ent = null;
            if (pkg != null) {
                map = (ArrayMap<int[], Entry>)pkg.mMap.get(resId);
                if (map != null && (ent = (Entry)map.get(styleable2)) != null) {
                    return ent;
                }
            } else {
                Context context;
                try {
                    context = this.mContext.createPackageContextAsUser(packageName, 0, new UserHandle(userId));
                    if (context == null) {
                        return null;
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    return null;
                }
                pkg = new Package(context);
                this.mPackages.put(packageName, pkg);
            }
            if (map == null) {
                map = new ArrayMap<int[], Entry>();
                pkg.mMap.put(resId, map);
            }
            try {
                ent = new Entry(pkg.context, pkg.context.obtainStyledAttributes(resId, styleable2));
                map.put(styleable2, ent);
            }
            catch (Resources.NotFoundException e) {
                return null;
            }
            return ent;
        }
    }

    public static final class Entry {
        public final Context context;
        public final TypedArray array;

        public Entry(Context c, TypedArray ta) {
            this.context = c;
            this.array = ta;
        }

        void recycle() {
            if (this.array != null) {
                this.array.recycle();
            }
        }
    }

    public static final class Package {
        public final Context context;
        private final SparseArray<ArrayMap<int[], Entry>> mMap = new SparseArray();

        public Package(Context c) {
            this.context = c;
        }
    }
}

