/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.hardware.health.V2_0.HealthInfo;
import android.hardware.health.V2_0.IHealth;
import android.hardware.health.V2_0.IHealthInfoCallback;
import android.hardware.health.V2_0.Result;
import android.hidl.manager.V1_0.IServiceManager;
import android.hidl.manager.V1_0.IServiceNotification;
import android.metrics.LogMaker;
import android.os.BatteryManagerInternal;
import android.os.BatteryProperty;
import android.os.Binder;
import android.os.Bundle;
import android.os.DropBoxManager;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBatteryPropertiesRegistrar;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.EventLog;
import android.util.MutableInt;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.DumpUtils;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.am.BatteryStatsService;
import com.android.server.lights.Light;
import com.android.server.lights.LightsManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class BatteryService
extends SystemService {
    private static final String TAG = BatteryService.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int BATTERY_SCALE = 100;
    private static final long HEALTH_HAL_WAIT_MS = 1000L;
    private static final long BATTERY_LEVEL_CHANGE_THROTTLE_MS = 60000L;
    private static final int MAX_BATTERY_LEVELS_QUEUE_SIZE = 100;
    private int mCriticalBatteryLevel;
    private static final String[] DUMPSYS_ARGS = new String[]{"--checkin", "--unplugged"};
    private static final String DUMPSYS_DATA_PATH = "/data/system/";
    private static final int BATTERY_PLUGGED_NONE = 0;
    private final Context mContext;
    private final IBatteryStats mBatteryStats;
    BinderService mBinderService;
    private final Handler mHandler;
    private final Object mLock = new Object();
    private android.hardware.health.V1_0.HealthInfo mHealthInfo;
    private final android.hardware.health.V1_0.HealthInfo mLastHealthInfo = new android.hardware.health.V1_0.HealthInfo();
    private boolean mBatteryLevelCritical;
    private int mLastBatteryStatus;
    private int mLastBatteryHealth;
    private boolean mLastBatteryPresent;
    private int mLastBatteryLevel;
    private int mLastBatteryVoltage;
    private int mLastBatteryTemperature;
    private boolean mLastBatteryLevelCritical;
    private int mLastMaxChargingCurrent;
    private int mLastMaxChargingVoltage;
    private int mLastChargeCounter;
    private int mSequence = 1;
    private int mInvalidCharger;
    private int mLastInvalidCharger;
    private int mLowBatteryWarningLevel;
    private int mLowBatteryCloseWarningLevel;
    private int mShutdownBatteryTemperature;
    private int mPlugType;
    private int mLastPlugType = -1;
    private boolean mBatteryLevelLow;
    private long mDischargeStartTime;
    private int mDischargeStartLevel;
    private long mChargeStartTime;
    private int mChargeStartLevel;
    private boolean mUpdatesStopped;
    private Led mLed;
    private boolean mSentLowBatteryBroadcast = false;
    private ActivityManagerInternal mActivityManagerInternal;
    private HealthServiceWrapper mHealthServiceWrapper;
    private HealthHalCallback mHealthHalCallback;
    private BatteryPropertiesRegistrar mBatteryPropertiesRegistrar;
    private ArrayDeque<Bundle> mBatteryLevelsEventQueue;
    private long mLastBatteryLevelChangedSentMs;
    private MetricsLogger mMetricsLogger;
    static final int OPTION_FORCE_UPDATE = 1;

    public BatteryService(Context context) {
        super(context);
        this.mContext = context;
        this.mHandler = new Handler(true);
        this.mLed = new Led(context, this.getLocalService(LightsManager.class));
        this.mBatteryStats = BatteryStatsService.getService();
        this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mCriticalBatteryLevel = this.mContext.getResources().getInteger(17694763);
        this.mLowBatteryWarningLevel = this.mContext.getResources().getInteger(17694827);
        this.mLowBatteryCloseWarningLevel = this.mLowBatteryWarningLevel + this.mContext.getResources().getInteger(17694826);
        this.mShutdownBatteryTemperature = this.mContext.getResources().getInteger(17694892);
        this.mBatteryLevelsEventQueue = new ArrayDeque();
        this.mMetricsLogger = new MetricsLogger();
        if (new File("/sys/devices/virtual/switch/invalid_charger/state").exists()) {
            UEventObserver invalidChargerObserver = new UEventObserver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onUEvent(UEventObserver.UEvent event) {
                    int invalidCharger = "1".equals(event.get("SWITCH_STATE")) ? 1 : 0;
                    Object object = BatteryService.this.mLock;
                    synchronized (object) {
                        if (BatteryService.this.mInvalidCharger != invalidCharger) {
                            BatteryService.this.mInvalidCharger = invalidCharger;
                        }
                    }
                }
            };
            invalidChargerObserver.startObserving("DEVPATH=/devices/virtual/switch/invalid_charger");
        }
    }

    @Override
    public void onStart() {
        this.registerHealthCallback();
        this.mBinderService = new BinderService();
        this.publishBinderService("battery", this.mBinderService);
        this.mBatteryPropertiesRegistrar = new BatteryPropertiesRegistrar();
        this.publishBinderService("batteryproperties", this.mBatteryPropertiesRegistrar);
        this.publishLocalService(BatteryManagerInternal.class, new LocalService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 550) {
            Object object = this.mLock;
            synchronized (object) {
                ContentObserver obs = new ContentObserver(this.mHandler){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onChange(boolean selfChange) {
                        Object object = BatteryService.this.mLock;
                        synchronized (object) {
                            BatteryService.this.updateBatteryWarningLevelLocked();
                        }
                    }
                };
                ContentResolver resolver = this.mContext.getContentResolver();
                resolver.registerContentObserver(Settings.Global.getUriFor("low_power_trigger_level"), false, obs, -1);
                this.updateBatteryWarningLevelLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerHealthCallback() {
        BatteryService.traceBegin("HealthInitWrapper");
        this.mHealthServiceWrapper = new HealthServiceWrapper();
        this.mHealthHalCallback = new HealthHalCallback();
        try {
            this.mHealthServiceWrapper.init(this.mHealthHalCallback, new HealthServiceWrapper.IServiceManagerSupplier(){}, new HealthServiceWrapper.IHealthSupplier(){});
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "health: cannot register callback. (RemoteException)");
            throw ex.rethrowFromSystemServer();
        }
        catch (NoSuchElementException ex) {
            Slog.e(TAG, "health: cannot register callback. (no supported health HAL service)");
            throw ex;
        }
        finally {
            BatteryService.traceEnd();
        }
        BatteryService.traceBegin("HealthInitWaitUpdate");
        long beforeWait = SystemClock.uptimeMillis();
        Object object = this.mLock;
        synchronized (object) {
            while (this.mHealthInfo == null) {
                Slog.i(TAG, "health: Waited " + (SystemClock.uptimeMillis() - beforeWait) + "ms for callbacks. Waiting another " + 1000L + " ms...");
                try {
                    this.mLock.wait(1000L);
                }
                catch (InterruptedException ex) {
                    Slog.i(TAG, "health: InterruptedException when waiting for update.  Continuing...");
                }
            }
        }
        Slog.i(TAG, "health: Waited " + (SystemClock.uptimeMillis() - beforeWait) + "ms and received the update.");
        BatteryService.traceEnd();
    }

    private void updateBatteryWarningLevelLocked() {
        ContentResolver resolver = this.mContext.getContentResolver();
        int defWarnLevel = this.mContext.getResources().getInteger(17694827);
        this.mLowBatteryWarningLevel = Settings.Global.getInt(resolver, "low_power_trigger_level", defWarnLevel);
        if (this.mLowBatteryWarningLevel == 0) {
            this.mLowBatteryWarningLevel = defWarnLevel;
        }
        if (this.mLowBatteryWarningLevel < this.mCriticalBatteryLevel) {
            this.mLowBatteryWarningLevel = this.mCriticalBatteryLevel;
        }
        this.mLowBatteryCloseWarningLevel = this.mLowBatteryWarningLevel + this.mContext.getResources().getInteger(17694826);
        this.processValuesLocked(true);
    }

    private boolean isPoweredLocked(int plugTypeSet) {
        if (this.mHealthInfo.batteryStatus == 1) {
            return true;
        }
        if ((plugTypeSet & 1) != 0 && this.mHealthInfo.chargerAcOnline) {
            return true;
        }
        if ((plugTypeSet & 2) != 0 && this.mHealthInfo.chargerUsbOnline) {
            return true;
        }
        return (plugTypeSet & 4) != 0 && this.mHealthInfo.chargerWirelessOnline;
    }

    private boolean shouldSendBatteryLowLocked() {
        boolean plugged = this.mPlugType != 0;
        boolean oldPlugged = this.mLastPlugType != 0;
        return !plugged && this.mHealthInfo.batteryStatus != 1 && this.mHealthInfo.batteryLevel <= this.mLowBatteryWarningLevel && (oldPlugged || this.mLastBatteryLevel > this.mLowBatteryWarningLevel);
    }

    private boolean shouldShutdownLocked() {
        if (this.mHealthInfo.batteryLevel > 0) {
            return false;
        }
        if (!this.mHealthInfo.batteryPresent) {
            return false;
        }
        return this.mHealthInfo.batteryStatus != 2;
    }

    private void shutdownIfNoPowerLocked() {
        if (this.shouldShutdownLocked()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BatteryService.this.mActivityManagerInternal.isSystemReady()) {
                        Intent intent = new Intent("com.android.internal.intent.action.REQUEST_SHUTDOWN");
                        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
                        intent.putExtra("android.intent.extra.REASON", "battery");
                        intent.setFlags(0x10000000);
                        BatteryService.this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
                    }
                }
            });
        }
    }

    private void shutdownIfOverTempLocked() {
        if (this.mHealthInfo.batteryTemperature > this.mShutdownBatteryTemperature) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BatteryService.this.mActivityManagerInternal.isSystemReady()) {
                        Intent intent = new Intent("com.android.internal.intent.action.REQUEST_SHUTDOWN");
                        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
                        intent.putExtra("android.intent.extra.REASON", "thermal,battery");
                        intent.setFlags(0x10000000);
                        BatteryService.this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(HealthInfo info) {
        BatteryService.traceBegin("HealthInfoUpdate");
        Trace.traceCounter(131072L, "BatteryChargeCounter", info.legacy.batteryChargeCounter);
        Trace.traceCounter(131072L, "BatteryCurrent", info.legacy.batteryCurrent);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mUpdatesStopped) {
                this.mHealthInfo = info.legacy;
                this.processValuesLocked(false);
                this.mLock.notifyAll();
            } else {
                BatteryService.copy(this.mLastHealthInfo, info.legacy);
            }
        }
        BatteryService.traceEnd();
    }

    private static void copy(android.hardware.health.V1_0.HealthInfo dst, android.hardware.health.V1_0.HealthInfo src) {
        dst.chargerAcOnline = src.chargerAcOnline;
        dst.chargerUsbOnline = src.chargerUsbOnline;
        dst.chargerWirelessOnline = src.chargerWirelessOnline;
        dst.maxChargingCurrent = src.maxChargingCurrent;
        dst.maxChargingVoltage = src.maxChargingVoltage;
        dst.batteryStatus = src.batteryStatus;
        dst.batteryHealth = src.batteryHealth;
        dst.batteryPresent = src.batteryPresent;
        dst.batteryLevel = src.batteryLevel;
        dst.batteryVoltage = src.batteryVoltage;
        dst.batteryTemperature = src.batteryTemperature;
        dst.batteryCurrent = src.batteryCurrent;
        dst.batteryCycleCount = src.batteryCycleCount;
        dst.batteryFullCharge = src.batteryFullCharge;
        dst.batteryChargeCounter = src.batteryChargeCounter;
        dst.batteryTechnology = src.batteryTechnology;
    }

    private void processValuesLocked(boolean force) {
        boolean logOutlier = false;
        long dischargeDuration = 0L;
        boolean bl = this.mBatteryLevelCritical = this.mHealthInfo.batteryStatus != 1 && this.mHealthInfo.batteryLevel <= this.mCriticalBatteryLevel;
        this.mPlugType = this.mHealthInfo.chargerAcOnline ? 1 : (this.mHealthInfo.chargerUsbOnline ? 2 : (this.mHealthInfo.chargerWirelessOnline ? 4 : 0));
        try {
            this.mBatteryStats.setBatteryState(this.mHealthInfo.batteryStatus, this.mHealthInfo.batteryHealth, this.mPlugType, this.mHealthInfo.batteryLevel, this.mHealthInfo.batteryTemperature, this.mHealthInfo.batteryVoltage, this.mHealthInfo.batteryChargeCounter, this.mHealthInfo.batteryFullCharge);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.shutdownIfNoPowerLocked();
        this.shutdownIfOverTempLocked();
        if (force || this.mHealthInfo.batteryStatus != this.mLastBatteryStatus || this.mHealthInfo.batteryHealth != this.mLastBatteryHealth || this.mHealthInfo.batteryPresent != this.mLastBatteryPresent || this.mHealthInfo.batteryLevel != this.mLastBatteryLevel || this.mPlugType != this.mLastPlugType || this.mHealthInfo.batteryVoltage != this.mLastBatteryVoltage || this.mHealthInfo.batteryTemperature != this.mLastBatteryTemperature || this.mHealthInfo.maxChargingCurrent != this.mLastMaxChargingCurrent || this.mHealthInfo.maxChargingVoltage != this.mLastMaxChargingVoltage || this.mHealthInfo.batteryChargeCounter != this.mLastChargeCounter || this.mInvalidCharger != this.mLastInvalidCharger) {
            if (this.mPlugType != this.mLastPlugType) {
                if (this.mLastPlugType == 0) {
                    this.mChargeStartLevel = this.mHealthInfo.batteryLevel;
                    this.mChargeStartTime = SystemClock.elapsedRealtime();
                    LogMaker builder = new LogMaker(1417);
                    builder.setType(4);
                    builder.addTaggedData(1421, this.mPlugType);
                    builder.addTaggedData(1418, this.mHealthInfo.batteryLevel);
                    this.mMetricsLogger.write(builder);
                    if (this.mDischargeStartTime != 0L && this.mDischargeStartLevel != this.mHealthInfo.batteryLevel) {
                        dischargeDuration = SystemClock.elapsedRealtime() - this.mDischargeStartTime;
                        logOutlier = true;
                        EventLog.writeEvent(2730, dischargeDuration, this.mDischargeStartLevel, this.mHealthInfo.batteryLevel);
                        this.mDischargeStartTime = 0L;
                    }
                } else if (this.mPlugType == 0) {
                    this.mDischargeStartTime = SystemClock.elapsedRealtime();
                    this.mDischargeStartLevel = this.mHealthInfo.batteryLevel;
                    long chargeDuration = SystemClock.elapsedRealtime() - this.mChargeStartTime;
                    if (this.mChargeStartTime != 0L && chargeDuration != 0L) {
                        LogMaker builder = new LogMaker(1417);
                        builder.setType(5);
                        builder.addTaggedData(1421, this.mLastPlugType);
                        builder.addTaggedData(1420, chargeDuration);
                        builder.addTaggedData(1418, this.mChargeStartLevel);
                        builder.addTaggedData(1419, this.mHealthInfo.batteryLevel);
                        this.mMetricsLogger.write(builder);
                    }
                    this.mChargeStartTime = 0L;
                }
            }
            if (this.mHealthInfo.batteryStatus != this.mLastBatteryStatus || this.mHealthInfo.batteryHealth != this.mLastBatteryHealth || this.mHealthInfo.batteryPresent != this.mLastBatteryPresent || this.mPlugType != this.mLastPlugType) {
                EventLog.writeEvent(2723, this.mHealthInfo.batteryStatus, this.mHealthInfo.batteryHealth, this.mHealthInfo.batteryPresent ? 1 : 0, this.mPlugType, this.mHealthInfo.batteryTechnology);
            }
            if (this.mHealthInfo.batteryLevel != this.mLastBatteryLevel) {
                EventLog.writeEvent(2722, this.mHealthInfo.batteryLevel, this.mHealthInfo.batteryVoltage, this.mHealthInfo.batteryTemperature);
            }
            if (this.mBatteryLevelCritical && !this.mLastBatteryLevelCritical && this.mPlugType == 0) {
                dischargeDuration = SystemClock.elapsedRealtime() - this.mDischargeStartTime;
                logOutlier = true;
            }
            if (!this.mBatteryLevelLow) {
                if (this.mPlugType == 0 && this.mHealthInfo.batteryStatus != 1 && this.mHealthInfo.batteryLevel <= this.mLowBatteryWarningLevel) {
                    this.mBatteryLevelLow = true;
                }
            } else if (this.mPlugType != 0) {
                this.mBatteryLevelLow = false;
            } else if (this.mHealthInfo.batteryLevel >= this.mLowBatteryCloseWarningLevel) {
                this.mBatteryLevelLow = false;
            } else if (force && this.mHealthInfo.batteryLevel >= this.mLowBatteryWarningLevel) {
                this.mBatteryLevelLow = false;
            }
            ++this.mSequence;
            if (this.mPlugType != 0 && this.mLastPlugType == 0) {
                final Intent statusIntent = new Intent("android.intent.action.ACTION_POWER_CONNECTED");
                statusIntent.setFlags(0x4000000);
                statusIntent.putExtra("seq", this.mSequence);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BatteryService.this.mContext.sendBroadcastAsUser(statusIntent, UserHandle.ALL);
                    }
                });
            } else if (this.mPlugType == 0 && this.mLastPlugType != 0) {
                final Intent statusIntent = new Intent("android.intent.action.ACTION_POWER_DISCONNECTED");
                statusIntent.setFlags(0x4000000);
                statusIntent.putExtra("seq", this.mSequence);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BatteryService.this.mContext.sendBroadcastAsUser(statusIntent, UserHandle.ALL);
                    }
                });
            }
            if (this.shouldSendBatteryLowLocked()) {
                this.mSentLowBatteryBroadcast = true;
                final Intent statusIntent = new Intent("android.intent.action.BATTERY_LOW");
                statusIntent.setFlags(0x4000000);
                statusIntent.putExtra("seq", this.mSequence);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BatteryService.this.mContext.sendBroadcastAsUser(statusIntent, UserHandle.ALL);
                    }
                });
            } else if (this.mSentLowBatteryBroadcast && this.mHealthInfo.batteryLevel >= this.mLowBatteryCloseWarningLevel) {
                this.mSentLowBatteryBroadcast = false;
                final Intent statusIntent = new Intent("android.intent.action.BATTERY_OKAY");
                statusIntent.setFlags(0x4000000);
                statusIntent.putExtra("seq", this.mSequence);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BatteryService.this.mContext.sendBroadcastAsUser(statusIntent, UserHandle.ALL);
                    }
                });
            }
            this.sendBatteryChangedIntentLocked();
            if (this.mLastBatteryLevel != this.mHealthInfo.batteryLevel || this.mLastPlugType != this.mPlugType) {
                this.sendBatteryLevelChangedIntentLocked();
            }
            this.mLed.updateLightsLocked();
            if (logOutlier && dischargeDuration != 0L) {
                this.logOutlierLocked(dischargeDuration);
            }
            this.mLastBatteryStatus = this.mHealthInfo.batteryStatus;
            this.mLastBatteryHealth = this.mHealthInfo.batteryHealth;
            this.mLastBatteryPresent = this.mHealthInfo.batteryPresent;
            this.mLastBatteryLevel = this.mHealthInfo.batteryLevel;
            this.mLastPlugType = this.mPlugType;
            this.mLastBatteryVoltage = this.mHealthInfo.batteryVoltage;
            this.mLastBatteryTemperature = this.mHealthInfo.batteryTemperature;
            this.mLastMaxChargingCurrent = this.mHealthInfo.maxChargingCurrent;
            this.mLastMaxChargingVoltage = this.mHealthInfo.maxChargingVoltage;
            this.mLastChargeCounter = this.mHealthInfo.batteryChargeCounter;
            this.mLastBatteryLevelCritical = this.mBatteryLevelCritical;
            this.mLastInvalidCharger = this.mInvalidCharger;
        }
    }

    private void sendBatteryChangedIntentLocked() {
        Intent intent = new Intent("android.intent.action.BATTERY_CHANGED");
        intent.addFlags(0x60000000);
        int icon = this.getIconLocked(this.mHealthInfo.batteryLevel);
        intent.putExtra("seq", this.mSequence);
        intent.putExtra("status", this.mHealthInfo.batteryStatus);
        intent.putExtra("health", this.mHealthInfo.batteryHealth);
        intent.putExtra("present", this.mHealthInfo.batteryPresent);
        intent.putExtra("level", this.mHealthInfo.batteryLevel);
        intent.putExtra("battery_low", this.mSentLowBatteryBroadcast);
        intent.putExtra("scale", 100);
        intent.putExtra("icon-small", icon);
        intent.putExtra("plugged", this.mPlugType);
        intent.putExtra("voltage", this.mHealthInfo.batteryVoltage);
        intent.putExtra("temperature", this.mHealthInfo.batteryTemperature);
        intent.putExtra("technology", this.mHealthInfo.batteryTechnology);
        intent.putExtra("invalid_charger", this.mInvalidCharger);
        intent.putExtra("max_charging_current", this.mHealthInfo.maxChargingCurrent);
        intent.putExtra("max_charging_voltage", this.mHealthInfo.maxChargingVoltage);
        intent.putExtra("charge_counter", this.mHealthInfo.batteryChargeCounter);
        this.mHandler.post(() -> ActivityManager.broadcastStickyIntent(intent, -1));
    }

    private void sendBatteryLevelChangedIntentLocked() {
        Bundle event = new Bundle();
        long now = SystemClock.elapsedRealtime();
        event.putInt("seq", this.mSequence);
        event.putInt("status", this.mHealthInfo.batteryStatus);
        event.putInt("health", this.mHealthInfo.batteryHealth);
        event.putBoolean("present", this.mHealthInfo.batteryPresent);
        event.putInt("level", this.mHealthInfo.batteryLevel);
        event.putBoolean("battery_low", this.mSentLowBatteryBroadcast);
        event.putInt("scale", 100);
        event.putInt("plugged", this.mPlugType);
        event.putInt("voltage", this.mHealthInfo.batteryVoltage);
        event.putLong("android.os.extra.EVENT_TIMESTAMP", now);
        boolean queueWasEmpty = this.mBatteryLevelsEventQueue.isEmpty();
        this.mBatteryLevelsEventQueue.add(event);
        if (this.mBatteryLevelsEventQueue.size() > 100) {
            this.mBatteryLevelsEventQueue.removeFirst();
        }
        if (queueWasEmpty) {
            long delay = now - this.mLastBatteryLevelChangedSentMs > 60000L ? 0L : this.mLastBatteryLevelChangedSentMs + 60000L - now;
            this.mHandler.postDelayed(this::sendEnqueuedBatteryLevelChangedEvents, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEnqueuedBatteryLevelChangedEvents() {
        ArrayList<Bundle> events;
        Object object = this.mLock;
        synchronized (object) {
            events = new ArrayList<Bundle>(this.mBatteryLevelsEventQueue);
            this.mBatteryLevelsEventQueue.clear();
        }
        Intent intent = new Intent("android.intent.action.BATTERY_LEVEL_CHANGED");
        intent.addFlags(0x1000000);
        intent.putParcelableArrayListExtra("android.os.extra.EVENTS", events);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.BATTERY_STATS");
        this.mLastBatteryLevelChangedSentMs = SystemClock.elapsedRealtime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logBatteryStatsLocked() {
        IBinder batteryInfoService = ServiceManager.getService("batterystats");
        if (batteryInfoService == null) {
            return;
        }
        DropBoxManager db = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (db == null || !db.isTagEnabled("BATTERY_DISCHARGE_INFO")) {
            return;
        }
        File dumpFile = null;
        FileOutputStream dumpStream = null;
        try {
            dumpFile = new File("/data/system/batterystats.dump");
            dumpStream = new FileOutputStream(dumpFile);
            batteryInfoService.dump(dumpStream.getFD(), DUMPSYS_ARGS);
            FileUtils.sync(dumpStream);
            db.addFile("BATTERY_DISCHARGE_INFO", dumpFile, 2);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "failed to dump battery service", e);
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to write dumpsys file", e);
        }
        finally {
            if (dumpStream != null) {
                try {
                    dumpStream.close();
                }
                catch (IOException e) {
                    Slog.e(TAG, "failed to close dumpsys output stream");
                }
            }
            if (dumpFile != null && !dumpFile.delete()) {
                Slog.e(TAG, "failed to delete temporary dumpsys file: " + dumpFile.getAbsolutePath());
            }
        }
    }

    private void logOutlierLocked(long duration) {
        ContentResolver cr = this.mContext.getContentResolver();
        String dischargeThresholdString = Settings.Global.getString(cr, "battery_discharge_threshold");
        String durationThresholdString = Settings.Global.getString(cr, "battery_discharge_duration_threshold");
        if (dischargeThresholdString != null && durationThresholdString != null) {
            try {
                long durationThreshold = Long.parseLong(durationThresholdString);
                int dischargeThreshold = Integer.parseInt(dischargeThresholdString);
                if (duration <= durationThreshold && this.mDischargeStartLevel - this.mHealthInfo.batteryLevel >= dischargeThreshold) {
                    this.logBatteryStatsLocked();
                }
            }
            catch (NumberFormatException e) {
                Slog.e(TAG, "Invalid DischargeThresholds GService string: " + durationThresholdString + " or " + dischargeThresholdString);
            }
        }
    }

    private int getIconLocked(int level) {
        if (this.mHealthInfo.batteryStatus == 2) {
            return 17303534;
        }
        if (this.mHealthInfo.batteryStatus == 3) {
            return 17303520;
        }
        if (this.mHealthInfo.batteryStatus == 4 || this.mHealthInfo.batteryStatus == 5) {
            if (this.isPoweredLocked(7) && this.mHealthInfo.batteryLevel >= 100) {
                return 17303534;
            }
            return 17303520;
        }
        return 17303548;
    }

    static void dumpHelp(PrintWriter pw) {
        pw.println("Battery service (battery) commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("  set [-f] [ac|usb|wireless|status|level|temp|present|invalid] <value>");
        pw.println("    Force a battery property value, freezing battery state.");
        pw.println("    -f: force a battery change broadcast be sent, prints new sequence.");
        pw.println("  unplug [-f]");
        pw.println("    Force battery unplugged, freezing battery state.");
        pw.println("    -f: force a battery change broadcast be sent, prints new sequence.");
        pw.println("  reset [-f]");
        pw.println("    Unfreeze battery state, returning to current hardware values.");
        pw.println("    -f: force a battery change broadcast be sent, prints new sequence.");
    }

    int parseOptions(Shell shell) {
        String opt;
        int opts = 0;
        while ((opt = shell.getNextOption()) != null) {
            if (!"-f".equals(opt)) continue;
            opts |= 1;
        }
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int onShellCommand(Shell shell, String cmd) {
        if (cmd == null) {
            return shell.handleDefaultCommands(cmd);
        }
        PrintWriter pw = shell.getOutPrintWriter();
        switch (cmd) {
            case "unplug": {
                int opts = this.parseOptions(shell);
                this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                if (!this.mUpdatesStopped) {
                    BatteryService.copy(this.mLastHealthInfo, this.mHealthInfo);
                }
                this.mHealthInfo.chargerAcOnline = false;
                this.mHealthInfo.chargerUsbOnline = false;
                this.mHealthInfo.chargerWirelessOnline = false;
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mUpdatesStopped = true;
                    this.processValuesFromShellLocked(pw, opts);
                    break;
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            case "set": {
                int opts = this.parseOptions(shell);
                this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                String key = shell.getNextArg();
                if (key == null) {
                    pw.println("No property specified");
                    return -1;
                }
                String value = shell.getNextArg();
                if (value == null) {
                    pw.println("No value specified");
                    return -1;
                }
                try {
                    if (!this.mUpdatesStopped) {
                        BatteryService.copy(this.mLastHealthInfo, this.mHealthInfo);
                    }
                    boolean update = true;
                    switch (key) {
                        case "present": {
                            this.mHealthInfo.batteryPresent = Integer.parseInt(value) != 0;
                            break;
                        }
                        case "ac": {
                            this.mHealthInfo.chargerAcOnline = Integer.parseInt(value) != 0;
                            break;
                        }
                        case "usb": {
                            this.mHealthInfo.chargerUsbOnline = Integer.parseInt(value) != 0;
                            break;
                        }
                        case "wireless": {
                            this.mHealthInfo.chargerWirelessOnline = Integer.parseInt(value) != 0;
                            break;
                        }
                        case "status": {
                            this.mHealthInfo.batteryStatus = Integer.parseInt(value);
                            break;
                        }
                        case "level": {
                            this.mHealthInfo.batteryLevel = Integer.parseInt(value);
                            break;
                        }
                        case "counter": {
                            this.mHealthInfo.batteryChargeCounter = Integer.parseInt(value);
                            break;
                        }
                        case "temp": {
                            this.mHealthInfo.batteryTemperature = Integer.parseInt(value);
                            break;
                        }
                        case "invalid": {
                            this.mInvalidCharger = Integer.parseInt(value);
                            break;
                        }
                        default: {
                            pw.println("Unknown set option: " + key);
                            update = false;
                        }
                    }
                    if (!update) break;
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mUpdatesStopped = true;
                        this.processValuesFromShellLocked(pw, opts);
                        break;
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                catch (NumberFormatException ex) {
                    pw.println("Bad value: " + value);
                    return -1;
                }
            }
            case "reset": {
                int opts = this.parseOptions(shell);
                this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                long ident = Binder.clearCallingIdentity();
                try {
                    if (!this.mUpdatesStopped) break;
                    this.mUpdatesStopped = false;
                    BatteryService.copy(this.mHealthInfo, this.mLastHealthInfo);
                    this.processValuesFromShellLocked(pw, opts);
                    break;
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            default: {
                return shell.handleDefaultCommands(cmd);
            }
        }
        return 0;
    }

    private void processValuesFromShellLocked(PrintWriter pw, int opts) {
        this.processValuesLocked((opts & 1) != 0);
        if ((opts & 1) != 0) {
            pw.println(this.mSequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInternal(FileDescriptor fd, PrintWriter pw, String[] args) {
        Object object = this.mLock;
        synchronized (object) {
            if (args == null || args.length == 0 || "-a".equals(args[0])) {
                pw.println("Current Battery Service state:");
                if (this.mUpdatesStopped) {
                    pw.println("  (UPDATES STOPPED -- use 'reset' to restart)");
                }
                pw.println("  AC powered: " + this.mHealthInfo.chargerAcOnline);
                pw.println("  USB powered: " + this.mHealthInfo.chargerUsbOnline);
                pw.println("  Wireless powered: " + this.mHealthInfo.chargerWirelessOnline);
                pw.println("  Max charging current: " + this.mHealthInfo.maxChargingCurrent);
                pw.println("  Max charging voltage: " + this.mHealthInfo.maxChargingVoltage);
                pw.println("  Charge counter: " + this.mHealthInfo.batteryChargeCounter);
                pw.println("  status: " + this.mHealthInfo.batteryStatus);
                pw.println("  health: " + this.mHealthInfo.batteryHealth);
                pw.println("  present: " + this.mHealthInfo.batteryPresent);
                pw.println("  level: " + this.mHealthInfo.batteryLevel);
                pw.println("  scale: 100");
                pw.println("  voltage: " + this.mHealthInfo.batteryVoltage);
                pw.println("  temperature: " + this.mHealthInfo.batteryTemperature);
                pw.println("  technology: " + this.mHealthInfo.batteryTechnology);
            } else {
                Shell shell = new Shell();
                shell.exec(this.mBinderService, null, fd, null, args, null, new ResultReceiver(null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpProto(FileDescriptor fd) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        Object object = this.mLock;
        synchronized (object) {
            proto.write(0x10800000001L, this.mUpdatesStopped);
            int batteryPluggedValue = 0;
            if (this.mHealthInfo.chargerAcOnline) {
                batteryPluggedValue = 1;
            } else if (this.mHealthInfo.chargerUsbOnline) {
                batteryPluggedValue = 2;
            } else if (this.mHealthInfo.chargerWirelessOnline) {
                batteryPluggedValue = 4;
            }
            proto.write(1159641169922L, batteryPluggedValue);
            proto.write(1120986464259L, this.mHealthInfo.maxChargingCurrent);
            proto.write(1120986464260L, this.mHealthInfo.maxChargingVoltage);
            proto.write(0x10500000005L, this.mHealthInfo.batteryChargeCounter);
            proto.write(1159641169926L, this.mHealthInfo.batteryStatus);
            proto.write(1159641169927L, this.mHealthInfo.batteryHealth);
            proto.write(0x10800000008L, this.mHealthInfo.batteryPresent);
            proto.write(1120986464265L, this.mHealthInfo.batteryLevel);
            proto.write(1120986464266L, 100);
            proto.write(1120986464267L, this.mHealthInfo.batteryVoltage);
            proto.write(1120986464268L, this.mHealthInfo.batteryTemperature);
            proto.write(1138166333453L, this.mHealthInfo.batteryTechnology);
        }
        proto.flush();
    }

    private static void traceBegin(String name) {
        Trace.traceBegin(524288L, name);
    }

    private static void traceEnd() {
        Trace.traceEnd(524288L);
    }

    @VisibleForTesting
    static final class HealthServiceWrapper {
        private static final String TAG = "HealthServiceWrapper";
        public static final String INSTANCE_HEALTHD = "backup";
        public static final String INSTANCE_VENDOR = "default";
        private static final List<String> sAllInstances = Arrays.asList("default", "backup");
        private final IServiceNotification mNotification = new Notification();
        private final HandlerThread mHandlerThread = new HandlerThread("HealthServiceRefresh");
        private Callback mCallback;
        private IHealthSupplier mHealthSupplier;
        private String mInstanceName;
        private final AtomicReference<IHealth> mLastService = new AtomicReference();

        HealthServiceWrapper() {
        }

        IHealth getLastService() {
            return this.mLastService.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init(Callback callback, IServiceManagerSupplier managerSupplier, IHealthSupplier healthSupplier) throws RemoteException, NoSuchElementException, NullPointerException {
            if (callback == null || managerSupplier == null || healthSupplier == null) {
                throw new NullPointerException();
            }
            this.mCallback = callback;
            this.mHealthSupplier = healthSupplier;
            IHealth newService = null;
            for (String name : sAllInstances) {
                BatteryService.traceBegin("HealthInitGetService_" + name);
                try {
                    newService = healthSupplier.get(name);
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                finally {
                    BatteryService.traceEnd();
                }
                if (newService == null) continue;
                this.mInstanceName = name;
                this.mLastService.set(newService);
                break;
            }
            if (this.mInstanceName == null || newService == null) {
                throw new NoSuchElementException(String.format("No IHealth service instance among %s is available. Perhaps no permission?", sAllInstances.toString()));
            }
            this.mCallback.onRegistration(null, newService, this.mInstanceName);
            BatteryService.traceBegin("HealthInitRegisterNotification");
            this.mHandlerThread.start();
            try {
                managerSupplier.get().registerForNotifications("android.hardware.health@2.0::IHealth", this.mInstanceName, this.mNotification);
            }
            finally {
                BatteryService.traceEnd();
            }
            Slog.i(TAG, "health: HealthServiceWrapper listening to instance " + this.mInstanceName);
        }

        @VisibleForTesting
        HandlerThread getHandlerThread() {
            return this.mHandlerThread;
        }

        private class Notification
        extends IServiceNotification.Stub {
            private Notification() {
            }

            @Override
            public final void onRegistration(String interfaceName, String instanceName, boolean preexisting) {
                if (!"android.hardware.health@2.0::IHealth".equals(interfaceName)) {
                    return;
                }
                if (!HealthServiceWrapper.this.mInstanceName.equals(instanceName)) {
                    return;
                }
                HealthServiceWrapper.this.mHandlerThread.getThreadHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IHealth newService = HealthServiceWrapper.this.mHealthSupplier.get(HealthServiceWrapper.this.mInstanceName);
                            IHealth oldService = HealthServiceWrapper.this.mLastService.getAndSet(newService);
                            if (Objects.equals(newService, oldService)) {
                                return;
                            }
                            Slog.i(HealthServiceWrapper.TAG, "health: new instance registered " + HealthServiceWrapper.this.mInstanceName);
                            HealthServiceWrapper.this.mCallback.onRegistration(oldService, newService, HealthServiceWrapper.this.mInstanceName);
                        }
                        catch (RemoteException | NoSuchElementException ex) {
                            Slog.e(HealthServiceWrapper.TAG, "health: Cannot get instance '" + HealthServiceWrapper.this.mInstanceName + "': " + ex.getMessage() + ". Perhaps no permission?");
                        }
                    }
                });
            }
        }

        static interface IHealthSupplier {
            default public IHealth get(String name) throws NoSuchElementException, RemoteException {
                return IHealth.getService(name, true);
            }
        }

        static interface IServiceManagerSupplier {
            default public IServiceManager get() throws NoSuchElementException, RemoteException {
                return IServiceManager.getService();
            }
        }

        static interface Callback {
            public void onRegistration(IHealth var1, IHealth var2, String var3);
        }
    }

    private final class LocalService
    extends BatteryManagerInternal {
        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPowered(int plugTypeSet) {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return BatteryService.this.isPoweredLocked(plugTypeSet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getPlugType() {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return BatteryService.this.mPlugType;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getBatteryLevel() {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return ((BatteryService)BatteryService.this).mHealthInfo.batteryLevel;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getBatteryChargeCounter() {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return ((BatteryService)BatteryService.this).mHealthInfo.batteryChargeCounter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getBatteryFullCharge() {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return ((BatteryService)BatteryService.this).mHealthInfo.batteryFullCharge;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getBatteryLevelLow() {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return BatteryService.this.mBatteryLevelLow;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInvalidCharger() {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return BatteryService.this.mInvalidCharger;
            }
        }
    }

    private final class BatteryPropertiesRegistrar
    extends IBatteryPropertiesRegistrar.Stub {
        private BatteryPropertiesRegistrar() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getProperty(int id2, BatteryProperty prop) throws RemoteException {
            BatteryService.traceBegin("HealthGetProperty");
            try {
                IHealth service = BatteryService.this.mHealthServiceWrapper.getLastService();
                if (service == null) {
                    throw new RemoteException("no health service");
                }
                MutableInt outResult = new MutableInt(1);
                switch (id2) {
                    case 1: {
                        service.getChargeCounter((result, value) -> {
                            outResult.value = result;
                            if (result == 0) {
                                prop.setLong(value);
                            }
                        });
                        break;
                    }
                    case 2: {
                        service.getCurrentNow((result, value) -> {
                            outResult.value = result;
                            if (result == 0) {
                                prop.setLong(value);
                            }
                        });
                        break;
                    }
                    case 3: {
                        service.getCurrentAverage((result, value) -> {
                            outResult.value = result;
                            if (result == 0) {
                                prop.setLong(value);
                            }
                        });
                        break;
                    }
                    case 4: {
                        service.getCapacity((result, value) -> {
                            outResult.value = result;
                            if (result == 0) {
                                prop.setLong(value);
                            }
                        });
                        break;
                    }
                    case 6: {
                        service.getChargeStatus((result, value) -> {
                            outResult.value = result;
                            if (result == 0) {
                                prop.setLong(value);
                            }
                        });
                        break;
                    }
                    case 5: {
                        service.getEnergyCounter((result, value) -> {
                            outResult.value = result;
                            if (result == 0) {
                                prop.setLong(value);
                            }
                        });
                    }
                }
                int n = outResult.value;
                return n;
            }
            finally {
                BatteryService.traceEnd();
            }
        }

        @Override
        public void scheduleUpdate() throws RemoteException {
            BatteryService.traceBegin("HealthScheduleUpdate");
            try {
                IHealth service = BatteryService.this.mHealthServiceWrapper.getLastService();
                if (service == null) {
                    throw new RemoteException("no health service");
                }
                service.update();
            }
            finally {
                BatteryService.traceEnd();
            }
        }
    }

    private final class BinderService
    extends Binder {
        private BinderService() {
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(BatteryService.this.mContext, TAG, pw)) {
                return;
            }
            if (args.length > 0 && "--proto".equals(args[0])) {
                BatteryService.this.dumpProto(fd);
            } else {
                BatteryService.this.dumpInternal(fd, pw, args);
            }
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new Shell().exec(this, in, out, err, args, callback, resultReceiver);
        }
    }

    private final class HealthHalCallback
    extends IHealthInfoCallback.Stub
    implements HealthServiceWrapper.Callback {
        private HealthHalCallback() {
        }

        @Override
        public void healthInfoChanged(HealthInfo props) {
            BatteryService.this.update(props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRegistration(IHealth oldService, IHealth newService, String instance) {
            int r;
            if (newService == null) {
                return;
            }
            BatteryService.traceBegin("HealthUnregisterCallback");
            try {
                if (oldService != null && (r = oldService.unregisterCallback(this)) != 0) {
                    Slog.w(TAG, "health: cannot unregister previous callback: " + Result.toString(r));
                }
            }
            catch (RemoteException ex) {
                Slog.w(TAG, "health: cannot unregister previous callback (transaction error): " + ex.getMessage());
            }
            finally {
                BatteryService.traceEnd();
            }
            BatteryService.traceBegin("HealthRegisterCallback");
            try {
                r = newService.registerCallback(this);
                if (r != 0) {
                    Slog.w(TAG, "health: cannot register callback: " + Result.toString(r));
                    return;
                }
                newService.update();
            }
            catch (RemoteException ex) {
                Slog.e(TAG, "health: cannot register callback (transaction error): " + ex.getMessage());
            }
            finally {
                BatteryService.traceEnd();
            }
        }
    }

    private final class Led {
        private final Light mBatteryLight;
        private final int mBatteryLowARGB;
        private final int mBatteryMediumARGB;
        private final int mBatteryFullARGB;
        private final int mBatteryLedOn;
        private final int mBatteryLedOff;

        public Led(Context context, LightsManager lights) {
            this.mBatteryLight = lights.getLight(3);
            this.mBatteryLowARGB = context.getResources().getInteger(17694864);
            this.mBatteryMediumARGB = context.getResources().getInteger(17694865);
            this.mBatteryFullARGB = context.getResources().getInteger(17694861);
            this.mBatteryLedOn = context.getResources().getInteger(17694863);
            this.mBatteryLedOff = context.getResources().getInteger(17694862);
        }

        public void updateLightsLocked() {
            int level = ((BatteryService)BatteryService.this).mHealthInfo.batteryLevel;
            int status = ((BatteryService)BatteryService.this).mHealthInfo.batteryStatus;
            if (level < BatteryService.this.mLowBatteryWarningLevel) {
                if (status == 2) {
                    this.mBatteryLight.setColor(this.mBatteryLowARGB);
                } else {
                    this.mBatteryLight.setFlashing(this.mBatteryLowARGB, 1, this.mBatteryLedOn, this.mBatteryLedOff);
                }
            } else if (status == 2 || status == 5) {
                if (status == 5 || level >= 90) {
                    this.mBatteryLight.setColor(this.mBatteryFullARGB);
                } else {
                    this.mBatteryLight.setColor(this.mBatteryMediumARGB);
                }
            } else {
                this.mBatteryLight.turnOff();
            }
        }
    }

    class Shell
    extends ShellCommand {
        Shell() {
        }

        @Override
        public int onCommand(String cmd) {
            return BatteryService.this.onShellCommand(this, cmd);
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            BatteryService.dumpHelp(pw);
        }
    }
}

