/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Process;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.KeyValueListParser;
import android.util.Slog;
import com.android.internal.os.AppIdToPackageMap;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BinderCallsStats;
import com.android.internal.os.BinderInternal;
import com.android.internal.os.CachedDeviceState;
import com.android.server.SystemService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class BinderCallsStatsService
extends Binder {
    private static final String TAG = "BinderCallsStatsService";
    private static final String PERSIST_SYS_BINDER_CALLS_DETAILED_TRACKING = "persist.sys.binder_calls_detailed_tracking";
    private SettingsObserver mSettingsObserver;
    private final BinderCallsStats mBinderCallsStats;
    private final AuthorizedWorkSourceProvider mWorkSourceProvider;

    BinderCallsStatsService(BinderCallsStats binderCallsStats, AuthorizedWorkSourceProvider workSourceProvider) {
        this.mBinderCallsStats = binderCallsStats;
        this.mWorkSourceProvider = workSourceProvider;
    }

    public void systemReady(Context context) {
        this.mSettingsObserver = new SettingsObserver(context, this.mBinderCallsStats, this.mWorkSourceProvider);
    }

    public void reset() {
        Slog.i(TAG, "Resetting stats");
        this.mBinderCallsStats.reset();
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        boolean verbose = false;
        if (args != null) {
            for (String arg : args) {
                if ("-a".equals(arg)) {
                    verbose = true;
                    continue;
                }
                if ("--reset".equals(arg)) {
                    this.reset();
                    pw.println("binder_calls_stats reset.");
                    return;
                }
                if ("--enable".equals(arg)) {
                    Binder.setObserver(this.mBinderCallsStats);
                    return;
                }
                if ("--disable".equals(arg)) {
                    Binder.setObserver(null);
                    return;
                }
                if ("--no-sampling".equals(arg)) {
                    this.mBinderCallsStats.setSamplingInterval(1);
                    return;
                }
                if ("--enable-detailed-tracking".equals(arg)) {
                    SystemProperties.set(PERSIST_SYS_BINDER_CALLS_DETAILED_TRACKING, "1");
                    this.mBinderCallsStats.setDetailedTracking(true);
                    pw.println("Detailed tracking enabled");
                    return;
                }
                if ("--disable-detailed-tracking".equals(arg)) {
                    SystemProperties.set(PERSIST_SYS_BINDER_CALLS_DETAILED_TRACKING, "");
                    this.mBinderCallsStats.setDetailedTracking(false);
                    pw.println("Detailed tracking disabled");
                    return;
                }
                if ("--dump-worksource-provider".equals(arg)) {
                    this.mWorkSourceProvider.dump(pw, AppIdToPackageMap.getSnapshot());
                    return;
                }
                if ("-h".equals(arg)) {
                    pw.println("binder_calls_stats commands:");
                    pw.println("  --reset: Reset stats");
                    pw.println("  --enable: Enable tracking binder calls");
                    pw.println("  --disable: Disables tracking binder calls");
                    pw.println("  --no-sampling: Tracks all calls");
                    pw.println("  --enable-detailed-tracking: Enables detailed tracking");
                    pw.println("  --disable-detailed-tracking: Disables detailed tracking");
                    return;
                }
                pw.println("Unknown option: " + arg);
            }
        }
        this.mBinderCallsStats.dump(pw, AppIdToPackageMap.getSnapshot(), verbose);
    }

    public static class LifeCycle
    extends SystemService {
        private BinderCallsStatsService mService;
        private BinderCallsStats mBinderCallsStats;
        private AuthorizedWorkSourceProvider mWorkSourceProvider;

        public LifeCycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mBinderCallsStats = new BinderCallsStats(new BinderCallsStats.Injector());
            this.mWorkSourceProvider = new AuthorizedWorkSourceProvider();
            this.mService = new BinderCallsStatsService(this.mBinderCallsStats, this.mWorkSourceProvider);
            this.publishLocalService(Internal.class, new Internal(this.mBinderCallsStats));
            this.publishBinderService("binder_calls_stats", this.mService);
            boolean detailedTrackingEnabled = SystemProperties.getBoolean(BinderCallsStatsService.PERSIST_SYS_BINDER_CALLS_DETAILED_TRACKING, false);
            if (detailedTrackingEnabled) {
                Slog.i(BinderCallsStatsService.TAG, "Enabled CPU usage tracking for binder calls. Controlled by persist.sys.binder_calls_detailed_tracking or via dumpsys binder_calls_stats --enable-detailed-tracking");
                this.mBinderCallsStats.setDetailedTracking(true);
            }
        }

        @Override
        public void onBootPhase(int phase) {
            if (500 == phase) {
                CachedDeviceState.Readonly deviceState = this.getLocalService(CachedDeviceState.Readonly.class);
                this.mBinderCallsStats.setDeviceState(deviceState);
                this.mWorkSourceProvider.systemReady(this.getContext());
                this.mService.systemReady(this.getContext());
            }
        }
    }

    public static class Internal {
        private final BinderCallsStats mBinderCallsStats;

        Internal(BinderCallsStats binderCallsStats) {
            this.mBinderCallsStats = binderCallsStats;
        }

        public void reset() {
            this.mBinderCallsStats.reset();
        }

        public ArrayList<BinderCallsStats.ExportedCallStat> getExportedCallStats() {
            return this.mBinderCallsStats.getExportedCallStats();
        }

        public ArrayMap<String, Integer> getExportedExceptionStats() {
            return this.mBinderCallsStats.getExportedExceptionStats();
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private static final String SETTINGS_ENABLED_KEY = "enabled";
        private static final String SETTINGS_DETAILED_TRACKING_KEY = "detailed_tracking";
        private static final String SETTINGS_UPLOAD_DATA_KEY = "upload_data";
        private static final String SETTINGS_SAMPLING_INTERVAL_KEY = "sampling_interval";
        private static final String SETTINGS_TRACK_SCREEN_INTERACTIVE_KEY = "track_screen_state";
        private static final String SETTINGS_TRACK_DIRECT_CALLING_UID_KEY = "track_calling_uid";
        private static final String SETTINGS_MAX_CALL_STATS_KEY = "max_call_stats_count";
        private boolean mEnabled;
        private final Uri mUri = Settings.Global.getUriFor("binder_calls_stats");
        private final Context mContext;
        private final KeyValueListParser mParser = new KeyValueListParser(',');
        private final BinderCallsStats mBinderCallsStats;
        private final AuthorizedWorkSourceProvider mWorkSourceProvider;

        SettingsObserver(Context context, BinderCallsStats binderCallsStats, AuthorizedWorkSourceProvider workSourceProvider) {
            super(BackgroundThread.getHandler());
            this.mContext = context;
            context.getContentResolver().registerContentObserver(this.mUri, false, this, 0);
            this.mBinderCallsStats = binderCallsStats;
            this.mWorkSourceProvider = workSourceProvider;
            this.onChange();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            if (this.mUri.equals(uri)) {
                this.onChange();
            }
        }

        public void onChange() {
            if (!SystemProperties.get(BinderCallsStatsService.PERSIST_SYS_BINDER_CALLS_DETAILED_TRACKING).isEmpty()) {
                return;
            }
            try {
                this.mParser.setString(Settings.Global.getString(this.mContext.getContentResolver(), "binder_calls_stats"));
            }
            catch (IllegalArgumentException e) {
                Slog.e(BinderCallsStatsService.TAG, "Bad binder call stats settings", e);
            }
            this.mBinderCallsStats.setDetailedTracking(this.mParser.getBoolean(SETTINGS_DETAILED_TRACKING_KEY, true));
            this.mBinderCallsStats.setSamplingInterval(this.mParser.getInt(SETTINGS_SAMPLING_INTERVAL_KEY, 1000));
            this.mBinderCallsStats.setMaxBinderCallStats(this.mParser.getInt(SETTINGS_MAX_CALL_STATS_KEY, 1500));
            this.mBinderCallsStats.setTrackScreenInteractive(this.mParser.getBoolean(SETTINGS_TRACK_SCREEN_INTERACTIVE_KEY, false));
            this.mBinderCallsStats.setTrackDirectCallerUid(this.mParser.getBoolean(SETTINGS_TRACK_DIRECT_CALLING_UID_KEY, true));
            boolean enabled = this.mParser.getBoolean(SETTINGS_ENABLED_KEY, true);
            if (this.mEnabled != enabled) {
                if (enabled) {
                    Binder.setObserver(this.mBinderCallsStats);
                    Binder.setProxyTransactListener(new Binder.PropagateWorkSourceTransactListener());
                    Binder.setWorkSourceProvider(this.mWorkSourceProvider);
                } else {
                    Binder.setObserver(null);
                    Binder.setProxyTransactListener(null);
                    Binder.setWorkSourceProvider(x -> Binder.getCallingUid());
                }
                this.mEnabled = enabled;
                this.mBinderCallsStats.reset();
                this.mBinderCallsStats.setAddDebugEntries(enabled);
            }
        }
    }

    static class AuthorizedWorkSourceProvider
    implements BinderInternal.WorkSourceProvider {
        private ArraySet<Integer> mAppIdWhitelist = new ArraySet();

        AuthorizedWorkSourceProvider() {
        }

        @Override
        public int resolveWorkSourceUid(int untrustedWorkSourceUid) {
            int callingUid = this.getCallingUid();
            int appId = UserHandle.getAppId(callingUid);
            if (this.mAppIdWhitelist.contains(appId)) {
                int workSource = untrustedWorkSourceUid;
                boolean isWorkSourceSet = workSource != -1;
                return isWorkSourceSet ? workSource : callingUid;
            }
            return callingUid;
        }

        public void systemReady(Context context) {
            this.mAppIdWhitelist = this.createAppidWhitelist(context);
        }

        public void dump(PrintWriter pw, AppIdToPackageMap packageMap) {
            pw.println("AppIds of apps that can set the work source:");
            ArraySet<Integer> whitelist = this.mAppIdWhitelist;
            for (Integer appId : whitelist) {
                pw.println("\t- " + packageMap.mapAppId(appId));
            }
        }

        protected int getCallingUid() {
            return Binder.getCallingUid();
        }

        private ArraySet<Integer> createAppidWhitelist(Context context) {
            ArraySet<Integer> whitelist = new ArraySet<Integer>();
            whitelist.add(UserHandle.getAppId(Process.myUid()));
            PackageManager pm = context.getPackageManager();
            String[] permissions = new String[]{"android.permission.UPDATE_DEVICE_STATS"};
            int queryFlags = 786432;
            List<PackageInfo> packages = pm.getPackagesHoldingPermissions(permissions, 786432);
            int packagesSize = packages.size();
            for (int i = 0; i < packagesSize; ++i) {
                PackageInfo pkgInfo = packages.get(i);
                try {
                    int uid = pm.getPackageUid(pkgInfo.packageName, 786432);
                    int appId = UserHandle.getAppId(uid);
                    whitelist.add(appId);
                    continue;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.e(BinderCallsStatsService.TAG, "Cannot find uid for package name " + pkgInfo.packageName, e);
                }
            }
            return whitelist;
        }
    }
}

