/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import com.android.internal.os.RoSystemProperties;
import com.android.server.BluetoothManagerService;
import com.android.server.SystemService;

class BluetoothService
extends SystemService {
    private BluetoothManagerService mBluetoothManagerService;
    private boolean mInitialized = false;

    public BluetoothService(Context context) {
        super(context);
        this.mBluetoothManagerService = new BluetoothManagerService(context);
    }

    private void initialize() {
        if (!this.mInitialized) {
            this.mBluetoothManagerService.handleOnBootPhase();
            this.mInitialized = true;
        }
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.publishBinderService("bluetooth_manager", this.mBluetoothManagerService);
        } else if (phase == 550 && !RoSystemProperties.MULTIUSER_HEADLESS_SYSTEM_USER) {
            this.initialize();
        }
    }

    @Override
    public void onSwitchUser(int userHandle) {
        this.initialize();
        this.mBluetoothManagerService.handleOnSwitchUser(userHandle);
    }

    @Override
    public void onUnlockUser(int userHandle) {
        this.mBluetoothManagerService.handleOnUnlockUser(userHandle);
    }
}

