/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.BatteryManagerInternal;
import android.os.PowerManager;
import android.util.Slog;
import com.android.internal.os.CachedDeviceState;
import com.android.server.LocalServices;
import com.android.server.SystemService;

public class CachedDeviceStateService
extends SystemService {
    private static final String TAG = "CachedDeviceStateService";
    private final CachedDeviceState mDeviceState = new CachedDeviceState();
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.intent.action.BATTERY_CHANGED": {
                    CachedDeviceStateService.this.mDeviceState.setCharging(intent.getIntExtra("plugged", 0) != 0);
                    break;
                }
                case "android.intent.action.SCREEN_ON": {
                    CachedDeviceStateService.this.mDeviceState.setScreenInteractive(true);
                    break;
                }
                case "android.intent.action.SCREEN_OFF": {
                    CachedDeviceStateService.this.mDeviceState.setScreenInteractive(false);
                }
            }
        }
    };

    public CachedDeviceStateService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        this.publishLocalService(CachedDeviceState.Readonly.class, this.mDeviceState.getReadonlyClient());
    }

    @Override
    public void onBootPhase(int phase) {
        if (500 == phase) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.BATTERY_CHANGED");
            filter.addAction("android.intent.action.SCREEN_ON");
            filter.addAction("android.intent.action.SCREEN_OFF");
            filter.setPriority(1000);
            this.getContext().registerReceiver(this.mBroadcastReceiver, filter);
            this.mDeviceState.setCharging(this.queryIsCharging());
            this.mDeviceState.setScreenInteractive(this.queryScreenInteractive(this.getContext()));
        }
    }

    private boolean queryIsCharging() {
        BatteryManagerInternal batteryManager = LocalServices.getService(BatteryManagerInternal.class);
        if (batteryManager == null) {
            Slog.wtf(TAG, "BatteryManager null while starting CachedDeviceStateService");
            return true;
        }
        return batteryManager.getPlugType() != 0;
    }

    private boolean queryScreenInteractive(Context context) {
        PowerManager powerManager = context.getSystemService(PowerManager.class);
        if (powerManager == null) {
            Slog.wtf(TAG, "PowerManager null while starting CachedDeviceStateService");
            return false;
        }
        return powerManager.isInteractive();
    }
}

