/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.BroadcastOptions;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.net.CaptivePortal;
import android.net.ConnectionInfo;
import android.net.ConnectivityManager;
import android.net.ICaptivePortal;
import android.net.IConnectivityManager;
import android.net.IDnsResolver;
import android.net.IIpConnectivityMetrics;
import android.net.INetd;
import android.net.INetdEventCallback;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkMonitor;
import android.net.INetworkMonitorCallbacks;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.ISocketKeepaliveCallback;
import android.net.ITetheringEventCallback;
import android.net.InetAddresses;
import android.net.IpMemoryStore;
import android.net.IpPrefix;
import android.net.LinkProperties;
import android.net.MatchAllNetworkSpecifier;
import android.net.Network;
import android.net.NetworkAgent;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkFactory;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkMonitorManager;
import android.net.NetworkPolicyManager;
import android.net.NetworkQuotaInfo;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;
import android.net.NetworkStackClient;
import android.net.NetworkState;
import android.net.NetworkUtils;
import android.net.NetworkWatchlistManager;
import android.net.PrivateDnsConfigParcel;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.UidRange;
import android.net.Uri;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.NetworkEvent;
import android.net.netlink.InetDiagMessage;
import android.net.shared.NetworkMonitorUtils;
import android.net.shared.PrivateDnsConfig;
import android.net.util.MultinetworkPolicyTracker;
import android.net.util.NetdService;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.security.KeyStore;
import android.system.OsConstants;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.LocalLog;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnInfo;
import com.android.internal.net.VpnProfile;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.WakeupMessage;
import com.android.internal.util.XmlUtils;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.TestNetworkService;
import com.android.server.am.BatteryStatsService;
import com.android.server.connectivity.AutodestructReference;
import com.android.server.connectivity.DataConnectionStats;
import com.android.server.connectivity.DnsManager;
import com.android.server.connectivity.IpConnectivityMetrics;
import com.android.server.connectivity.KeepaliveTracker;
import com.android.server.connectivity.LingerMonitor;
import com.android.server.connectivity.MockableSystemProperties;
import com.android.server.connectivity.MultipathPolicyTracker;
import com.android.server.connectivity.NetworkAgentInfo;
import com.android.server.connectivity.NetworkDiagnostics;
import com.android.server.connectivity.NetworkNotificationManager;
import com.android.server.connectivity.PermissionMonitor;
import com.android.server.connectivity.ProxyTracker;
import com.android.server.connectivity.Tethering;
import com.android.server.connectivity.Vpn;
import com.android.server.connectivity.tethering.TetheringDependencies;
import com.android.server.net.BaseNetdEventCallback;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.LockdownVpnTracker;
import com.android.server.net.NetworkPolicyManagerInternal;
import com.android.server.utils.PriorityDump;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConnectivityService
extends IConnectivityManager.Stub
implements PendingIntent.OnFinished {
    private static final String TAG = ConnectivityService.class.getSimpleName();
    private static final String DIAG_ARG = "--diag";
    public static final String SHORT_ARG = "--short";
    private static final String TETHERING_ARG = "tethering";
    private static final String NETWORK_ARG = "networks";
    private static final String REQUEST_ARG = "requests";
    private static final boolean DBG = true;
    private static final boolean DDBG = Log.isLoggable(TAG, 3);
    private static final boolean VDBG = Log.isLoggable(TAG, 2);
    private static final boolean LOGD_BLOCKED_NETWORKINFO = true;
    private static final String DEFAULT_CAPTIVE_PORTAL_HTTP_URL = "http://connectivitycheck.gstatic.com/generate_204";
    private static final int RESTORE_DEFAULT_NETWORK_DELAY = 60000;
    private static final String NETWORK_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    private static final int PROMPT_UNVALIDATED_DELAY_MS = 8000;
    private static final int TIMEOUT_NOTIFICATION_DELAY_MS = 20000;
    private static final String LINGER_DELAY_PROPERTY = "persist.netmon.linger";
    private static final int DEFAULT_LINGER_DELAY_MS = 30000;
    @VisibleForTesting
    protected int mLingerDelayMs;
    private final int mReleasePendingIntentDelayMs;
    private MockableSystemProperties mSystemProperties;
    private Tethering mTethering;
    @VisibleForTesting
    protected final PermissionMonitor mPermissionMonitor;
    private KeyStore mKeyStore;
    @VisibleForTesting
    @GuardedBy(value={"mVpns"})
    protected final SparseArray<Vpn> mVpns = new SparseArray();
    @GuardedBy(value={"mVpns"})
    private boolean mLockdownEnabled;
    @GuardedBy(value={"mVpns"})
    private LockdownVpnTracker mLockdownTracker;
    private SparseIntArray mUidRules = new SparseIntArray();
    private boolean mRestrictBackground;
    private final Context mContext;
    private int mDefaultInetConditionPublished = 0;
    private INetworkManagementService mNMS;
    @VisibleForTesting
    protected IDnsResolver mDnsResolver;
    @VisibleForTesting
    protected INetd mNetd;
    private INetworkStatsService mStatsService;
    private INetworkPolicyManager mPolicyManager;
    private NetworkPolicyManagerInternal mPolicyManagerInternal;
    @GuardedBy(value={"mTNSLock"})
    private TestNetworkService mTNS;
    private final Object mTNSLock = new Object();
    private String mCurrentTcpBufferSizes;
    private static final SparseArray<String> sMagicDecoderRing = MessageUtils.findMessageNames(new Class[]{AsyncChannel.class, ConnectivityService.class, NetworkAgent.class, NetworkAgentInfo.class});
    private static final int EVENT_CLEAR_NET_TRANSITION_WAKELOCK = 8;
    private static final int EVENT_APPLY_GLOBAL_HTTP_PROXY = 9;
    private static final int EVENT_PROXY_HAS_CHANGED = 16;
    private static final int EVENT_REGISTER_NETWORK_FACTORY = 17;
    private static final int EVENT_REGISTER_NETWORK_AGENT = 18;
    private static final int EVENT_REGISTER_NETWORK_REQUEST = 19;
    private static final int EVENT_TIMEOUT_NETWORK_REQUEST = 20;
    private static final int EVENT_REGISTER_NETWORK_LISTENER = 21;
    private static final int EVENT_RELEASE_NETWORK_REQUEST = 22;
    private static final int EVENT_UNREGISTER_NETWORK_FACTORY = 23;
    private static final int EVENT_EXPIRE_NET_TRANSITION_WAKELOCK = 24;
    private static final int EVENT_SYSTEM_READY = 25;
    private static final int EVENT_REGISTER_NETWORK_REQUEST_WITH_INTENT = 26;
    private static final int EVENT_RELEASE_NETWORK_REQUEST_WITH_INTENT = 27;
    private static final int EVENT_SET_ACCEPT_UNVALIDATED = 28;
    private static final int EVENT_PROMPT_UNVALIDATED = 29;
    private static final int EVENT_CONFIGURE_ALWAYS_ON_NETWORKS = 30;
    private static final int EVENT_REGISTER_NETWORK_LISTENER_WITH_INTENT = 31;
    private static final int EVENT_SET_AVOID_UNVALIDATED = 35;
    private static final int EVENT_REVALIDATE_NETWORK = 36;
    private static final int EVENT_PRIVATE_DNS_SETTINGS_CHANGED = 37;
    private static final int EVENT_PRIVATE_DNS_VALIDATION_UPDATE = 38;
    private static final int EVENT_UID_RULES_CHANGED = 39;
    private static final int EVENT_DATA_SAVER_CHANGED = 40;
    public static final int EVENT_NETWORK_TESTED = 41;
    public static final int EVENT_PRIVATE_DNS_CONFIG_RESOLVED = 42;
    public static final int EVENT_PROVISIONING_NOTIFICATION = 43;
    public static final int EVENT_TIMEOUT_NOTIFICATION = 44;
    private static final int EVENT_SET_ACCEPT_PARTIAL_CONNECTIVITY = 45;
    public static final int PROVISIONING_NOTIFICATION_SHOW = 1;
    public static final int PROVISIONING_NOTIFICATION_HIDE = 0;
    @VisibleForTesting
    protected final HandlerThread mHandlerThread;
    private final InternalHandler mHandler;
    private final NetworkStateTrackerHandler mTrackerHandler;
    private final DnsManager mDnsManager;
    private boolean mSystemReady;
    private Intent mInitialBroadcast;
    private PowerManager.WakeLock mNetTransitionWakeLock;
    private int mNetTransitionWakeLockTimeout;
    private final PowerManager.WakeLock mPendingIntentWakeLock;
    @VisibleForTesting
    protected final ProxyTracker mProxyTracker;
    private final SettingsObserver mSettingsObserver;
    private UserManager mUserManager;
    private NetworkConfig[] mNetConfigs;
    private int mNetworksDefined;
    private List mProtectedNetworks;
    private TelephonyManager mTelephonyManager;
    private KeepaliveTracker mKeepaliveTracker;
    private NetworkNotificationManager mNotifier;
    private LingerMonitor mLingerMonitor;
    private static final int MIN_NET_ID = 100;
    private static final int MAX_NET_ID = 64511;
    private int mNextNetId = 100;
    private int mNextNetworkRequestId = 1;
    private static final int MAX_NETWORK_REQUEST_LOGS = 20;
    private final LocalLog mNetworkRequestInfoLogs = new LocalLog(20);
    private static final int MAX_NETWORK_INFO_LOGS = 40;
    private final LocalLog mNetworkInfoBlockingLogs = new LocalLog(40);
    private static final int MAX_WAKELOCK_LOGS = 20;
    private final LocalLog mWakelockLogs = new LocalLog(20);
    private int mTotalWakelockAcquisitions = 0;
    private int mTotalWakelockReleases = 0;
    private long mTotalWakelockDurationMs = 0L;
    private long mMaxWakelockDurationMs = 0L;
    private long mLastWakeLockAcquireTimestamp = 0L;
    private final IpConnectivityLog mMetricsLog;
    @GuardedBy(value={"mBandwidthRequests"})
    private final SparseArray<Integer> mBandwidthRequests = new SparseArray(10);
    @VisibleForTesting
    final MultinetworkPolicyTracker mMultinetworkPolicyTracker;
    @VisibleForTesting
    final MultipathPolicyTracker mMultipathPolicyTracker;
    private final LegacyTypeTracker mLegacyTypeTracker = new LegacyTypeTracker(this);
    private final PriorityDump.PriorityDumper mPriorityDumper = new PriorityDump.PriorityDumper(){

        @Override
        public void dumpHigh(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            ConnectivityService.this.doDump(fd, pw, new String[]{ConnectivityService.DIAG_ARG}, asProto);
            ConnectivityService.this.doDump(fd, pw, new String[]{ConnectivityService.SHORT_ARG}, asProto);
        }

        @Override
        public void dumpNormal(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            ConnectivityService.this.doDump(fd, pw, args, asProto);
        }

        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            ConnectivityService.this.doDump(fd, pw, args, asProto);
        }
    };
    private INetworkManagementEventObserver mDataActivityObserver = new BaseNetworkObserver(){

        @Override
        public void interfaceClassDataActivityChanged(String label, boolean active, long tsNanos) {
            int deviceType = Integer.parseInt(label);
            ConnectivityService.this.sendDataActivityBroadcast(deviceType, active, tsNanos);
        }
    };
    @VisibleForTesting
    protected final INetdEventCallback mNetdEventCallback = new BaseNetdEventCallback(){

        @Override
        public void onPrivateDnsValidationEvent(int netId, String ipAddress, String hostname, boolean validated) {
            try {
                ConnectivityService.this.mHandler.sendMessage(ConnectivityService.this.mHandler.obtainMessage(38, new DnsManager.PrivateDnsValidationUpdate(netId, InetAddress.parseNumericAddress((String)ipAddress), hostname, validated)));
            }
            catch (IllegalArgumentException e) {
                ConnectivityService.loge("Error parsing ip address in validation event");
            }
        }

        @Override
        public void onDnsEvent(int netId, int eventType, int returnCode, String hostname, String[] ipAddresses, int ipAddressesCount, long timestamp, int uid) {
            NetworkAgentInfo nai = ConnectivityService.this.getNetworkAgentInfoForNetId(netId);
            if (nai != null && nai.satisfies(ConnectivityService.this.mDefaultRequest)) {
                nai.networkMonitor().notifyDnsResponse(returnCode);
            }
        }

        @Override
        public void onNat64PrefixEvent(int netId, boolean added, String prefixString, int prefixLength) {
            ConnectivityService.this.mHandler.post(() -> ConnectivityService.this.handleNat64PrefixEvent(netId, added, prefixString, prefixLength));
        }
    };
    private final INetworkPolicyListener mPolicyListener = new NetworkPolicyManager.Listener(){

        @Override
        public void onUidRulesChanged(int uid, int uidRules) {
            ConnectivityService.this.mHandler.sendMessage(ConnectivityService.this.mHandler.obtainMessage(39, uid, uidRules));
        }

        @Override
        public void onRestrictBackgroundChanged(boolean restrictBackground) {
            ConnectivityService.log("onRestrictBackgroundChanged(restrictBackground=" + restrictBackground + ")");
            ConnectivityService.this.mHandler.sendMessage(ConnectivityService.this.mHandler.obtainMessage(40, restrictBackground ? 1 : 0, 0));
            if (restrictBackground) {
                ConnectivityService.log("onRestrictBackgroundChanged(true): disabling tethering");
                ConnectivityService.this.mTethering.untetherAll();
            }
        }
    };
    @VisibleForTesting
    protected static final String DEFAULT_TCP_BUFFER_SIZES = "4096,87380,110208,4096,16384,110208";
    private static final String DEFAULT_TCP_RWND_KEY = "net.tcp.default_init_rwnd";
    private static final String PROVISIONING_URL_PATH = "/data/misc/radio/provisioning_urls.xml";
    private final File mProvisioningUrlFile = new File("/data/misc/radio/provisioning_urls.xml");
    private static final String TAG_PROVISIONING_URLS = "provisioningUrls";
    private static final String TAG_PROVISIONING_URL = "provisioningUrl";
    private static final String ATTR_MCC = "mcc";
    private static final String ATTR_MNC = "mnc";
    private BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String packageName;
            ConnectivityService.this.ensureRunningOnConnectivityServiceThread();
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            Uri packageData = intent.getData();
            String string2 = packageName = packageData != null ? packageData.getSchemeSpecificPart() : null;
            if (userId == -10000) {
                return;
            }
            if ("android.intent.action.USER_STARTED".equals(action)) {
                ConnectivityService.this.onUserStart(userId);
            } else if ("android.intent.action.USER_STOPPED".equals(action)) {
                ConnectivityService.this.onUserStop(userId);
            } else if ("android.intent.action.USER_ADDED".equals(action)) {
                ConnectivityService.this.onUserAdded(userId);
            } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                ConnectivityService.this.onUserRemoved(userId);
            } else if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                ConnectivityService.this.onUserUnlocked(userId);
            } else if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                ConnectivityService.this.onPackageAdded(packageName, uid);
            } else if ("android.intent.action.PACKAGE_REPLACED".equals(action)) {
                ConnectivityService.this.onPackageReplaced(packageName, uid);
            } else if ("android.intent.action.PACKAGE_REMOVED".equals(action)) {
                boolean isReplacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                ConnectivityService.this.onPackageRemoved(packageName, uid, isReplacing);
            }
        }
    };
    private BroadcastReceiver mUserPresentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            ConnectivityService.this.updateLockdownVpn();
            ConnectivityService.this.mContext.unregisterReceiver(this);
        }
    };
    private final HashMap<Messenger, NetworkFactoryInfo> mNetworkFactoryInfos = new HashMap();
    private final HashMap<NetworkRequest, NetworkRequestInfo> mNetworkRequests = new HashMap();
    private static final int MAX_NETWORK_REQUESTS_PER_UID = 100;
    @GuardedBy(value={"mUidToNetworkRequestCount"})
    private final SparseIntArray mUidToNetworkRequestCount = new SparseIntArray();
    @GuardedBy(value={"mNetworkForRequestId"})
    private final SparseArray<NetworkAgentInfo> mNetworkForRequestId = new SparseArray();
    @GuardedBy(value={"mNetworkForNetId"})
    private final SparseArray<NetworkAgentInfo> mNetworkForNetId = new SparseArray();
    @GuardedBy(value={"mNetworkForNetId"})
    private final SparseBooleanArray mNetIdInUse = new SparseBooleanArray();
    private final HashMap<Messenger, NetworkAgentInfo> mNetworkAgentInfos = new HashMap();
    @GuardedBy(value={"mBlockedAppUids"})
    private final HashSet<Integer> mBlockedAppUids = new HashSet();
    private final NetworkRequest mDefaultRequest;
    private final NetworkRequest mDefaultMobileDataRequest;
    private final NetworkRequest mDefaultWifiRequest;

    private static String eventName(int what) {
        return sMagicDecoderRing.get(what, Integer.toString(what));
    }

    private static IDnsResolver getDnsResolver() {
        return IDnsResolver.Stub.asInterface(ServiceManager.getService("dnsresolver"));
    }

    public ConnectivityService(Context context, INetworkManagementService netManager, INetworkStatsService statsService, INetworkPolicyManager policyManager) {
        this(context, netManager, statsService, policyManager, ConnectivityService.getDnsResolver(), new IpConnectivityLog(), NetdService.getInstance());
    }

    @VisibleForTesting
    protected ConnectivityService(Context context, INetworkManagementService netManager, INetworkStatsService statsService, INetworkPolicyManager policyManager, IDnsResolver dnsresolver, IpConnectivityLog logger, INetd netd) {
        int[] protectedNetworks;
        String[] naStrings;
        ConnectivityService.log("ConnectivityService starting up");
        this.mSystemProperties = this.getSystemProperties();
        this.mMetricsLog = logger;
        this.mDefaultRequest = this.createDefaultInternetRequestForTransport(-1, NetworkRequest.Type.REQUEST);
        NetworkRequestInfo defaultNRI = new NetworkRequestInfo(null, this.mDefaultRequest, new Binder());
        this.mNetworkRequests.put(this.mDefaultRequest, defaultNRI);
        this.mNetworkRequestInfoLogs.log("REGISTER " + defaultNRI);
        this.mDefaultMobileDataRequest = this.createDefaultInternetRequestForTransport(0, NetworkRequest.Type.BACKGROUND_REQUEST);
        this.mDefaultWifiRequest = this.createDefaultInternetRequestForTransport(1, NetworkRequest.Type.BACKGROUND_REQUEST);
        this.mHandlerThread = new HandlerThread("ConnectivityServiceThread");
        this.mHandlerThread.start();
        this.mHandler = new InternalHandler(this.mHandlerThread.getLooper());
        this.mTrackerHandler = new NetworkStateTrackerHandler(this.mHandlerThread.getLooper());
        this.mReleasePendingIntentDelayMs = Settings.Secure.getInt(context.getContentResolver(), "connectivity_release_pending_intent_delay_ms", 5000);
        this.mLingerDelayMs = this.mSystemProperties.getInt(LINGER_DELAY_PROPERTY, 30000);
        this.mContext = Preconditions.checkNotNull(context, "missing Context");
        this.mNMS = Preconditions.checkNotNull(netManager, "missing INetworkManagementService");
        this.mStatsService = Preconditions.checkNotNull(statsService, "missing INetworkStatsService");
        this.mPolicyManager = Preconditions.checkNotNull(policyManager, "missing INetworkPolicyManager");
        this.mPolicyManagerInternal = Preconditions.checkNotNull(LocalServices.getService(NetworkPolicyManagerInternal.class), "missing NetworkPolicyManagerInternal");
        this.mDnsResolver = Preconditions.checkNotNull(dnsresolver, "missing IDnsResolver");
        this.mProxyTracker = this.makeProxyTracker();
        this.mNetd = netd;
        this.mKeyStore = KeyStore.getInstance();
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        try {
            this.mPolicyManager.registerListener(this.mPolicyListener);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("unable to register INetworkPolicyListener" + e);
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mNetTransitionWakeLock = powerManager.newWakeLock(1, TAG);
        this.mNetTransitionWakeLockTimeout = this.mContext.getResources().getInteger(17694854);
        this.mPendingIntentWakeLock = powerManager.newWakeLock(1, TAG);
        this.mNetConfigs = new NetworkConfig[19];
        boolean wifiOnly = this.mSystemProperties.getBoolean("ro.radio.noril", false);
        ConnectivityService.log("wifiOnly=" + wifiOnly);
        for (String naString : naStrings = context.getResources().getStringArray(17236090)) {
            try {
                NetworkConfig n = new NetworkConfig(naString);
                if (VDBG) {
                    ConnectivityService.log("naString=" + naString + " config=" + n);
                }
                if (n.type > 18) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to define type " + n.type);
                    continue;
                }
                if (wifiOnly && ConnectivityManager.isNetworkTypeMobile(n.type)) {
                    ConnectivityService.log("networkAttributes - ignoring mobile as this dev is wifiOnly " + n.type);
                    continue;
                }
                if (this.mNetConfigs[n.type] != null) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to redefine type " + n.type);
                    continue;
                }
                this.mLegacyTypeTracker.addSupportedType(n.type);
                this.mNetConfigs[n.type] = n;
                ++this.mNetworksDefined;
            }
            catch (Exception n) {
                // empty catch block
            }
        }
        if (this.mNetConfigs[17] == null) {
            this.mLegacyTypeTracker.addSupportedType(17);
            ++this.mNetworksDefined;
        }
        if (this.mNetConfigs[9] == null && this.hasService("ethernet")) {
            this.mLegacyTypeTracker.addSupportedType(9);
            ++this.mNetworksDefined;
        }
        if (VDBG) {
            ConnectivityService.log("mNetworksDefined=" + this.mNetworksDefined);
        }
        this.mProtectedNetworks = new ArrayList();
        for (int p : protectedNetworks = context.getResources().getIntArray(17236049)) {
            if (this.mNetConfigs[p] != null && !this.mProtectedNetworks.contains(p)) {
                this.mProtectedNetworks.add(p);
                continue;
            }
            ConnectivityService.loge("Ignoring protectedNetwork " + p);
        }
        this.mTethering = this.makeTethering();
        this.mPermissionMonitor = new PermissionMonitor(this.mContext, this.mNetd);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_STARTED");
        intentFilter.addAction("android.intent.action.USER_STOPPED");
        intentFilter.addAction("android.intent.action.USER_ADDED");
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        intentFilter.addAction("android.intent.action.USER_UNLOCKED");
        this.mContext.registerReceiverAsUser(this.mIntentReceiver, UserHandle.ALL, intentFilter, null, this.mHandler);
        this.mContext.registerReceiverAsUser(this.mUserPresentReceiver, UserHandle.SYSTEM, new IntentFilter("android.intent.action.USER_PRESENT"), null, null);
        intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_REPLACED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mIntentReceiver, UserHandle.ALL, intentFilter, null, this.mHandler);
        try {
            this.mNMS.registerObserver(this.mTethering);
            this.mNMS.registerObserver(this.mDataActivityObserver);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("Error registering observer :" + e);
        }
        this.mSettingsObserver = new SettingsObserver(this.mContext, this.mHandler);
        this.registerSettingsCallbacks();
        DataConnectionStats dataConnectionStats = new DataConnectionStats(this.mContext);
        dataConnectionStats.startMonitoring();
        this.mUserManager = (UserManager)context.getSystemService("user");
        this.mKeepaliveTracker = new KeepaliveTracker(this.mContext, this.mHandler);
        this.mNotifier = new NetworkNotificationManager(this.mContext, this.mTelephonyManager, this.mContext.getSystemService(NotificationManager.class));
        int dailyLimit = Settings.Global.getInt(this.mContext.getContentResolver(), "network_switch_notification_daily_limit", 3);
        long rateLimit = Settings.Global.getLong(this.mContext.getContentResolver(), "network_switch_notification_rate_limit_millis", 60000L);
        this.mLingerMonitor = new LingerMonitor(this.mContext, this.mNotifier, dailyLimit, rateLimit);
        this.mMultinetworkPolicyTracker = this.createMultinetworkPolicyTracker(this.mContext, this.mHandler, () -> this.rematchForAvoidBadWifiUpdate());
        this.mMultinetworkPolicyTracker.start();
        this.mMultipathPolicyTracker = new MultipathPolicyTracker(this.mContext, this.mHandler);
        this.mDnsManager = new DnsManager(this.mContext, this.mDnsResolver, this.mSystemProperties);
        this.registerPrivateDnsSettingsCallbacks();
    }

    @VisibleForTesting
    protected Tethering makeTethering() {
        TetheringDependencies deps = new TetheringDependencies(){

            @Override
            public boolean isTetheringSupported() {
                return ConnectivityService.this.isTetheringSupported();
            }

            @Override
            public NetworkRequest getDefaultNetworkRequest() {
                return ConnectivityService.this.mDefaultRequest;
            }
        };
        return new Tethering(this.mContext, this.mNMS, this.mStatsService, this.mPolicyManager, IoThread.get().getLooper(), new MockableSystemProperties(), deps);
    }

    @VisibleForTesting
    protected ProxyTracker makeProxyTracker() {
        return new ProxyTracker(this.mContext, this.mHandler, 16);
    }

    private static NetworkCapabilities createDefaultNetworkCapabilitiesForUid(int uid) {
        NetworkCapabilities netCap = new NetworkCapabilities();
        netCap.addCapability(12);
        netCap.addCapability(13);
        netCap.removeCapability(15);
        netCap.setSingleUid(uid);
        return netCap;
    }

    private NetworkRequest createDefaultInternetRequestForTransport(int transportType, NetworkRequest.Type type) {
        NetworkCapabilities netCap = new NetworkCapabilities();
        netCap.addCapability(12);
        netCap.addCapability(13);
        if (transportType > -1) {
            netCap.addTransportType(transportType);
        }
        return new NetworkRequest(netCap, -1, this.nextNetworkRequestId(), type);
    }

    @VisibleForTesting
    void updateAlwaysOnNetworks() {
        this.mHandler.sendEmptyMessage(30);
    }

    @VisibleForTesting
    void updatePrivateDnsSettings() {
        this.mHandler.sendEmptyMessage(37);
    }

    private void handleAlwaysOnNetworkRequest(NetworkRequest networkRequest, String settingName, boolean defaultValue) {
        boolean isEnabled;
        boolean enable = ConnectivityService.toBool(Settings.Global.getInt(this.mContext.getContentResolver(), settingName, ConnectivityService.encodeBool(defaultValue)));
        boolean bl = isEnabled = this.mNetworkRequests.get(networkRequest) != null;
        if (enable == isEnabled) {
            return;
        }
        if (enable) {
            this.handleRegisterNetworkRequest(new NetworkRequestInfo(null, networkRequest, new Binder()));
        } else {
            this.handleReleaseNetworkRequest(networkRequest, 1000, false);
        }
    }

    private void handleConfigureAlwaysOnNetworks() {
        this.handleAlwaysOnNetworkRequest(this.mDefaultMobileDataRequest, "mobile_data_always_on", true);
        this.handleAlwaysOnNetworkRequest(this.mDefaultWifiRequest, "wifi_always_requested", false);
    }

    private void registerSettingsCallbacks() {
        this.mSettingsObserver.observe(Settings.Global.getUriFor("http_proxy"), 9);
        this.mSettingsObserver.observe(Settings.Global.getUriFor("mobile_data_always_on"), 30);
        this.mSettingsObserver.observe(Settings.Global.getUriFor("wifi_always_requested"), 30);
    }

    private void registerPrivateDnsSettingsCallbacks() {
        for (Uri uri : DnsManager.getPrivateDnsSettingsUris()) {
            this.mSettingsObserver.observe(uri, 37);
        }
    }

    private synchronized int nextNetworkRequestId() {
        return this.mNextNetworkRequestId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected int reserveNetId() {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            for (int i = 100; i <= 64511; ++i) {
                int netId = this.mNextNetId++;
                if (this.mNextNetId > 64511) {
                    this.mNextNetId = 100;
                }
                if (this.mNetIdInUse.get(netId)) continue;
                this.mNetIdInUse.put(netId, true);
                return netId;
            }
        }
        throw new IllegalStateException("No free netIds");
    }

    private NetworkState getFilteredNetworkState(int networkType, int uid) {
        if (this.mLegacyTypeTracker.isTypeSupported(networkType)) {
            NetworkState state;
            NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
            if (nai != null) {
                state = nai.getNetworkState();
                state.networkInfo.setType(networkType);
            } else {
                NetworkInfo info = new NetworkInfo(networkType, 0, ConnectivityManager.getNetworkTypeName(networkType), "");
                info.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                info.setIsAvailable(true);
                NetworkCapabilities capabilities = new NetworkCapabilities();
                capabilities.setCapability(18, !info.isRoaming());
                state = new NetworkState(info, new LinkProperties(), capabilities, null, null, null);
            }
            this.filterNetworkStateForUid(state, uid, false);
            return state;
        }
        return NetworkState.EMPTY;
    }

    @VisibleForTesting
    protected NetworkAgentInfo getNetworkAgentInfoForNetwork(Network network) {
        if (network == null) {
            return null;
        }
        return this.getNetworkAgentInfoForNetId(network.netId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkAgentInfo getNetworkAgentInfoForNetId(int netId) {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            return this.mNetworkForNetId.get(netId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Network[] getVpnUnderlyingNetworks(int uid) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            int user;
            Vpn vpn;
            if (!this.mLockdownEnabled && (vpn = this.mVpns.get(user = UserHandle.getUserId(uid))) != null && vpn.appliesToUid(uid)) {
                return vpn.getUnderlyingNetworks();
            }
            return null;
        }
    }

    private NetworkState getUnfilteredActiveNetworkState(int uid) {
        NetworkAgentInfo nai = this.getDefaultNetwork();
        Network[] networks = this.getVpnUnderlyingNetworks(uid);
        if (networks != null) {
            nai = networks.length > 0 ? this.getNetworkAgentInfoForNetwork(networks[0]) : null;
        }
        if (nai != null) {
            return nai.getNetworkState();
        }
        return NetworkState.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNetworkWithLinkPropertiesBlocked(LinkProperties lp, int uid, boolean ignoreBlocked) {
        String iface;
        if (ignoreBlocked) {
            return false;
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(UserHandle.getUserId(uid));
            if (vpn != null && vpn.getLockdown() && vpn.isBlockingUid(uid)) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
            iface = lp == null ? "" : lp.getInterfaceName();
        }
        return this.mPolicyManagerInternal.isUidNetworkingBlocked(uid, iface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLogBlockedNetworkInfo(NetworkInfo ni, int uid) {
        String action;
        if (ni == null) {
            return;
        }
        HashSet<Integer> hashSet = this.mBlockedAppUids;
        synchronized (hashSet) {
            boolean blocked;
            if (ni.getDetailedState() == NetworkInfo.DetailedState.BLOCKED && this.mBlockedAppUids.add(uid)) {
                blocked = true;
            } else if (ni.isConnected() && this.mBlockedAppUids.remove(uid)) {
                blocked = false;
            } else {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var4_3
            action = blocked ? "BLOCKED" : "UNBLOCKED";
        }
        ConnectivityService.log(String.format("Returning %s NetworkInfo to uid=%d", action, uid));
        this.mNetworkInfoBlockingLogs.log(action + " " + uid);
    }

    private void maybeLogBlockedStatusChanged(NetworkRequestInfo nri, Network net, boolean blocked) {
        if (nri == null || net == null) {
            return;
        }
        String action = blocked ? "BLOCKED" : "UNBLOCKED";
        ConnectivityService.log(String.format("Blocked status changed to %s for %d(%d) on netId %d", blocked, nri.mUid, nri.request.requestId, net.netId));
        this.mNetworkInfoBlockingLogs.log(action + " " + nri.mUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterNetworkStateForUid(NetworkState state, int uid, boolean ignoreBlocked) {
        if (state == null || state.networkInfo == null || state.linkProperties == null) {
            return;
        }
        if (this.isNetworkWithLinkPropertiesBlocked(state.linkProperties, uid, ignoreBlocked)) {
            state.networkInfo.setDetailedState(NetworkInfo.DetailedState.BLOCKED, null, null);
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (this.mLockdownTracker != null) {
                this.mLockdownTracker.augmentNetworkInfo(state.networkInfo);
            }
        }
    }

    @Override
    public NetworkInfo getActiveNetworkInfo() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        this.filterNetworkStateForUid(state, uid, false);
        this.maybeLogBlockedNetworkInfo(state.networkInfo, uid);
        return state.networkInfo;
    }

    @Override
    public Network getActiveNetwork() {
        this.enforceAccessPermission();
        return this.getActiveNetworkForUidInternal(Binder.getCallingUid(), false);
    }

    @Override
    public Network getActiveNetworkForUid(int uid, boolean ignoreBlocked) {
        this.enforceConnectivityInternalPermission();
        return this.getActiveNetworkForUidInternal(uid, ignoreBlocked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Network getActiveNetworkForUidInternal(int uid, boolean ignoreBlocked) {
        NetworkCapabilities requiredCaps;
        NetworkAgentInfo nai;
        int user = UserHandle.getUserId(uid);
        int vpnNetId = 0;
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(user);
            if (vpn != null && vpn.appliesToUid(uid)) {
                vpnNetId = vpn.getNetId();
            }
        }
        if (vpnNetId != 0 && (nai = this.getNetworkAgentInfoForNetId(vpnNetId)) != null && (requiredCaps = ConnectivityService.createDefaultNetworkCapabilitiesForUid(uid)).satisfiedByNetworkCapabilities(nai.networkCapabilities)) {
            return nai.network;
        }
        nai = this.getDefaultNetwork();
        if (nai != null && this.isNetworkWithLinkPropertiesBlocked(nai.linkProperties, uid, ignoreBlocked)) {
            nai = null;
        }
        return nai != null ? nai.network : null;
    }

    public NetworkInfo getActiveNetworkInfoUnfiltered() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        return state.networkInfo;
    }

    @Override
    public NetworkInfo getActiveNetworkInfoForUid(int uid, boolean ignoreBlocked) {
        this.enforceConnectivityInternalPermission();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        this.filterNetworkStateForUid(state, uid, ignoreBlocked);
        return state.networkInfo;
    }

    @Override
    public NetworkInfo getNetworkInfo(int networkType) {
        NetworkState state;
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        if (this.getVpnUnderlyingNetworks(uid) != null) {
            state = this.getUnfilteredActiveNetworkState(uid);
            if (state.networkInfo != null && state.networkInfo.getType() == networkType) {
                this.filterNetworkStateForUid(state, uid, false);
                return state.networkInfo;
            }
        }
        state = this.getFilteredNetworkState(networkType, uid);
        return state.networkInfo;
    }

    @Override
    public NetworkInfo getNetworkInfoForUid(Network network, int uid, boolean ignoreBlocked) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai != null) {
            NetworkState state = nai.getNetworkState();
            this.filterNetworkStateForUid(state, uid, ignoreBlocked);
            return state.networkInfo;
        }
        return null;
    }

    @Override
    public NetworkInfo[] getAllNetworkInfo() {
        this.enforceAccessPermission();
        ArrayList<NetworkInfo> result = Lists.newArrayList();
        for (int networkType = 0; networkType <= 18; ++networkType) {
            NetworkInfo info = this.getNetworkInfo(networkType);
            if (info == null) continue;
            result.add(info);
        }
        return result.toArray(new NetworkInfo[result.size()]);
    }

    @Override
    public Network getNetworkForType(int networkType) {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getFilteredNetworkState(networkType, uid);
        if (!this.isNetworkWithLinkPropertiesBlocked(state.linkProperties, uid, false)) {
            return state.network;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Network[] getAllNetworks() {
        this.enforceAccessPermission();
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            Network[] result = new Network[this.mNetworkForNetId.size()];
            for (int i = 0; i < this.mNetworkForNetId.size(); ++i) {
                result[i] = this.mNetworkForNetId.valueAt((int)i).network;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkCapabilities[] getDefaultNetworkCapabilitiesForUser(int userId) {
        this.enforceAccessPermission();
        HashMap<Network, NetworkCapabilities> result = new HashMap<Network, NetworkCapabilities>();
        NetworkAgentInfo nai = this.getDefaultNetwork();
        NetworkCapabilities nc = this.getNetworkCapabilitiesInternal(nai);
        if (nc != null) {
            result.put(nai.network, nc);
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Network[] networks;
            Vpn vpn;
            if (!this.mLockdownEnabled && (vpn = this.mVpns.get(userId)) != null && (networks = vpn.getUnderlyingNetworks()) != null) {
                for (Network network : networks) {
                    nai = this.getNetworkAgentInfoForNetwork(network);
                    nc = this.getNetworkCapabilitiesInternal(nai);
                    if (nc == null) continue;
                    result.put(network, nc);
                }
            }
        }
        NetworkCapabilities[] out = new NetworkCapabilities[result.size()];
        out = result.values().toArray(out);
        return out;
    }

    @Override
    public boolean isNetworkSupported(int networkType) {
        this.enforceAccessPermission();
        return this.mLegacyTypeTracker.isTypeSupported(networkType);
    }

    @Override
    public LinkProperties getActiveLinkProperties() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        return state.linkProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkProperties getLinkPropertiesForType(int networkType) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                return new LinkProperties(nai.linkProperties);
            }
        }
        return null;
    }

    @Override
    public LinkProperties getLinkProperties(Network network) {
        this.enforceAccessPermission();
        return this.getLinkProperties(this.getNetworkAgentInfoForNetwork(network));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkProperties getLinkProperties(NetworkAgentInfo nai) {
        if (nai == null) {
            return null;
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            return new LinkProperties(nai.linkProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkCapabilities getNetworkCapabilitiesInternal(NetworkAgentInfo nai) {
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                if (nai.networkCapabilities != null) {
                    return this.networkCapabilitiesRestrictedForCallerPermissions(nai.networkCapabilities, Binder.getCallingPid(), Binder.getCallingUid());
                }
            }
        }
        return null;
    }

    @Override
    public NetworkCapabilities getNetworkCapabilities(Network network) {
        this.enforceAccessPermission();
        return this.getNetworkCapabilitiesInternal(this.getNetworkAgentInfoForNetwork(network));
    }

    private NetworkCapabilities networkCapabilitiesRestrictedForCallerPermissions(NetworkCapabilities nc, int callerPid, int callerUid) {
        NetworkCapabilities newNc = new NetworkCapabilities(nc);
        if (!this.checkSettingsPermission(callerPid, callerUid)) {
            newNc.setUids(null);
            newNc.setSSID(null);
        }
        if (newNc.getNetworkSpecifier() != null) {
            newNc.setNetworkSpecifier(newNc.getNetworkSpecifier().redact());
        }
        return newNc;
    }

    private void restrictRequestUidsForCaller(NetworkCapabilities nc) {
        if (!this.checkSettingsPermission()) {
            nc.setSingleUid(Binder.getCallingUid());
        }
    }

    private void restrictBackgroundRequestForCaller(NetworkCapabilities nc) {
        if (!this.mPermissionMonitor.hasUseBackgroundNetworksPermission(Binder.getCallingUid())) {
            nc.addCapability(19);
        }
    }

    @Override
    public NetworkState[] getAllNetworkState() {
        this.enforceConnectivityInternalPermission();
        ArrayList<NetworkState> result = Lists.newArrayList();
        for (Network network : this.getAllNetworks()) {
            NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
            if (nai == null) continue;
            result.add(nai.getNetworkState());
        }
        return result.toArray(new NetworkState[result.size()]);
    }

    @Override
    @Deprecated
    public NetworkQuotaInfo getActiveNetworkQuotaInfo() {
        Log.w(TAG, "Shame on UID " + Binder.getCallingUid() + " for calling the hidden API getNetworkQuotaInfo(). Shame!");
        return new NetworkQuotaInfo();
    }

    @Override
    public boolean isActiveNetworkMetered() {
        this.enforceAccessPermission();
        NetworkCapabilities caps = this.getNetworkCapabilities(this.getActiveNetwork());
        if (caps != null) {
            return !caps.hasCapability(11);
        }
        return true;
    }

    private boolean disallowedBecauseSystemCaller() {
        if (this.isSystem(Binder.getCallingUid()) && SystemProperties.getInt("ro.product.first_api_level", 0) > 28) {
            ConnectivityService.log("This method exists only for app backwards compatibility and must not be called by system services.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestRouteToHostAddress(int networkType, byte[] hostAddress) {
        NetworkInfo.DetailedState netState;
        InetAddress addr;
        if (this.disallowedBecauseSystemCaller()) {
            return false;
        }
        this.enforceChangePermission();
        if (this.mProtectedNetworks.contains(networkType)) {
            this.enforceConnectivityInternalPermission();
        }
        try {
            addr = InetAddress.getByAddress(hostAddress);
        }
        catch (UnknownHostException e) {
            ConnectivityService.log("requestRouteToHostAddress got " + e.toString());
            return false;
        }
        if (!ConnectivityManager.isNetworkTypeValid(networkType)) {
            ConnectivityService.log("requestRouteToHostAddress on invalid network: " + networkType);
            return false;
        }
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai == null) {
            if (!this.mLegacyTypeTracker.isTypeSupported(networkType)) {
                ConnectivityService.log("requestRouteToHostAddress on unsupported network: " + networkType);
            } else {
                ConnectivityService.log("requestRouteToHostAddress on down network: " + networkType);
            }
            return false;
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            netState = nai.networkInfo.getDetailedState();
        }
        if (netState != NetworkInfo.DetailedState.CONNECTED && netState != NetworkInfo.DetailedState.CAPTIVE_PORTAL_CHECK) {
            if (VDBG) {
                ConnectivityService.log("requestRouteToHostAddress on down network (" + networkType + ") - dropped netState=" + (Object)((Object)netState));
            }
            return false;
        }
        int uid = Binder.getCallingUid();
        long token = Binder.clearCallingIdentity();
        try {
            int netId;
            LinkProperties lp;
            NetworkAgentInfo networkAgentInfo2 = nai;
            synchronized (networkAgentInfo2) {
                lp = nai.linkProperties;
                netId = nai.network.netId;
            }
            boolean ok = this.addLegacyRouteToHost(lp, addr, netId, uid);
            ConnectivityService.log("requestRouteToHostAddress ok=" + ok);
            boolean bl = ok;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private boolean addLegacyRouteToHost(LinkProperties lp, InetAddress addr, int netId, int uid) {
        RouteInfo bestRoute = RouteInfo.selectBestRoute(lp.getAllRoutes(), addr);
        if (bestRoute == null) {
            bestRoute = RouteInfo.makeHostRoute(addr, lp.getInterfaceName());
        } else {
            String iface = bestRoute.getInterface();
            bestRoute = bestRoute.getGateway().equals(addr) ? RouteInfo.makeHostRoute(addr, iface) : RouteInfo.makeHostRoute(addr, bestRoute.getGateway(), iface);
        }
        ConnectivityService.log("Adding legacy route " + bestRoute + " for UID/PID " + uid + "/" + Binder.getCallingPid());
        try {
            this.mNMS.addLegacyRouteForNetId(netId, bestRoute, uid);
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception trying to add a route: " + e);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    protected void registerNetdEventCallback() {
        IIpConnectivityMetrics ipConnectivityMetrics = IIpConnectivityMetrics.Stub.asInterface(ServiceManager.getService("connmetrics"));
        if (ipConnectivityMetrics == null) {
            Slog.wtf(TAG, "Missing IIpConnectivityMetrics");
            return;
        }
        try {
            ipConnectivityMetrics.addNetdEventCallback(0, this.mNetdEventCallback);
        }
        catch (Exception e) {
            ConnectivityService.loge("Error registering netd callback: " + e);
        }
    }

    void handleUidRulesChanged(int uid, int newRules) {
        int oldRules = this.mUidRules.get(uid, 0);
        if (oldRules == newRules) {
            return;
        }
        this.maybeNotifyNetworkBlockedForNewUidRules(uid, newRules);
        if (newRules == 0) {
            this.mUidRules.delete(uid);
        } else {
            this.mUidRules.put(uid, newRules);
        }
    }

    void handleRestrictBackgroundChanged(boolean restrictBackground) {
        if (this.mRestrictBackground == restrictBackground) {
            return;
        }
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            boolean curMetered = nai.networkCapabilities.isMetered();
            this.maybeNotifyNetworkBlocked(nai, curMetered, curMetered, this.mRestrictBackground, restrictBackground);
        }
        this.mRestrictBackground = restrictBackground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUidNetworkingWithVpnBlocked(int uid, int uidRules, boolean isNetworkMetered, boolean isBackgroundRestricted) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(UserHandle.getUserId(uid));
            if (vpn != null && vpn.getLockdown() && vpn.isBlockingUid(uid)) {
                return true;
            }
        }
        return NetworkPolicyManagerInternal.isUidNetworkingBlocked(uid, uidRules, isNetworkMetered, isBackgroundRestricted);
    }

    private void enforceCrossUserPermission(int userId) {
        if (userId == UserHandle.getCallingUserId()) {
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "ConnectivityService");
    }

    private boolean checkAnyPermissionOf(String ... permissions) {
        for (String permission2 : permissions) {
            if (this.mContext.checkCallingOrSelfPermission(permission2) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkAnyPermissionOf(int pid, int uid, String ... permissions) {
        for (String permission2 : permissions) {
            if (this.mContext.checkPermission(permission2, pid, uid) != 0) continue;
            return true;
        }
        return false;
    }

    private void enforceAnyPermissionOf(String ... permissions) {
        if (!this.checkAnyPermissionOf(permissions)) {
            throw new SecurityException("Requires one of the following permissions: " + String.join((CharSequence)", ", permissions) + ".");
        }
    }

    private void enforceInternetPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERNET", "ConnectivityService");
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", "ConnectivityService");
    }

    private void enforceChangePermission() {
        ConnectivityManager.enforceChangePermission(this.mContext);
    }

    private void enforceSettingsPermission() {
        this.enforceAnyPermissionOf("android.permission.NETWORK_SETTINGS", "android.permission.MAINLINE_NETWORK_STACK");
    }

    private boolean checkSettingsPermission() {
        return this.checkAnyPermissionOf("android.permission.NETWORK_SETTINGS", "android.permission.MAINLINE_NETWORK_STACK");
    }

    private boolean checkSettingsPermission(int pid, int uid) {
        return 0 == this.mContext.checkPermission("android.permission.NETWORK_SETTINGS", pid, uid) || 0 == this.mContext.checkPermission("android.permission.MAINLINE_NETWORK_STACK", pid, uid);
    }

    private void enforceTetherAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", "ConnectivityService");
    }

    private void enforceConnectivityInternalPermission() {
        this.enforceAnyPermissionOf("android.permission.CONNECTIVITY_INTERNAL", "android.permission.MAINLINE_NETWORK_STACK");
    }

    private void enforceControlAlwaysOnVpnPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONTROL_ALWAYS_ON_VPN", "ConnectivityService");
    }

    private void enforceNetworkStackSettingsOrSetup() {
        this.enforceAnyPermissionOf("android.permission.NETWORK_SETTINGS", "android.permission.NETWORK_SETUP_WIZARD", "android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK");
    }

    private boolean checkNetworkStackPermission() {
        return this.checkAnyPermissionOf("android.permission.NETWORK_STACK", "android.permission.MAINLINE_NETWORK_STACK");
    }

    private boolean checkNetworkSignalStrengthWakeupPermission(int pid, int uid) {
        return this.checkAnyPermissionOf(pid, uid, "android.permission.NETWORK_SIGNAL_STRENGTH_WAKEUP", "android.permission.MAINLINE_NETWORK_STACK");
    }

    private void enforceConnectivityRestrictedNetworksPermission() {
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_USE_RESTRICTED_NETWORKS", "ConnectivityService");
            return;
        }
        catch (SecurityException securityException) {
            this.enforceConnectivityInternalPermission();
            return;
        }
    }

    private void enforceKeepalivePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKET_KEEPALIVE_OFFLOAD", "ConnectivityService");
    }

    public void sendConnectedBroadcast(NetworkInfo info) {
        this.enforceConnectivityInternalPermission();
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE");
    }

    private void sendInetConditionBroadcast(NetworkInfo info) {
        this.sendGeneralBroadcast(info, "android.net.conn.INET_CONDITION_ACTION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent makeGeneralIntent(NetworkInfo info, String bcastType) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (this.mLockdownTracker != null) {
                info = new NetworkInfo(info);
                this.mLockdownTracker.augmentNetworkInfo(info);
            }
        }
        Intent intent = new Intent(bcastType);
        intent.putExtra("networkInfo", new NetworkInfo(info));
        intent.putExtra("networkType", info.getType());
        if (info.isFailover()) {
            intent.putExtra("isFailover", true);
            info.setFailover(false);
        }
        if (info.getReason() != null) {
            intent.putExtra("reason", info.getReason());
        }
        if (info.getExtraInfo() != null) {
            intent.putExtra("extraInfo", info.getExtraInfo());
        }
        intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
        return intent;
    }

    private void sendGeneralBroadcast(NetworkInfo info, String bcastType) {
        this.sendStickyBroadcast(this.makeGeneralIntent(info, bcastType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDataActivityBroadcast(int deviceType, boolean active, long tsNanos) {
        Intent intent = new Intent("android.net.conn.DATA_ACTIVITY_CHANGE");
        intent.putExtra("deviceType", deviceType);
        intent.putExtra("isActive", active);
        intent.putExtra("tsNanos", tsNanos);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, "android.permission.RECEIVE_DATA_ACTIVITY_CHANGE", null, null, 0, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcast(Intent intent) {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (!this.mSystemReady && intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                this.mInitialBroadcast = new Intent(intent);
            }
            intent.addFlags(0x4000000);
            if (VDBG) {
                ConnectivityService.log("sendStickyBroadcast: action=" + intent.getAction());
            }
            Bundle options = null;
            long ident = Binder.clearCallingIdentity();
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                NetworkInfo ni = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                if (ni.getType() == 3) {
                    intent.setAction("android.net.conn.CONNECTIVITY_CHANGE_SUPL");
                    intent.addFlags(0x40000000);
                } else {
                    BroadcastOptions opts = BroadcastOptions.makeBasic();
                    opts.setMaxManifestReceiverApiLevel(23);
                    options = opts.toBundle();
                }
                IBatteryStats bs = BatteryStatsService.getService();
                try {
                    bs.noteConnectivityChanged(intent.getIntExtra("networkType", -1), ni.getState().toString());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                intent.addFlags(0x200000);
            }
            try {
                this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL, options);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        this.mProxyTracker.loadGlobalProxy();
        this.registerNetdEventCallback();
        this.mTethering.systemReady();
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            this.mSystemReady = true;
            if (this.mInitialBroadcast != null) {
                this.mContext.sendStickyBroadcastAsUser(this.mInitialBroadcast, UserHandle.ALL);
                this.mInitialBroadcast = null;
            }
        }
        this.updateLockdownVpn();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(30));
        this.mHandler.sendMessage(this.mHandler.obtainMessage(25));
        this.mPermissionMonitor.startMonitoring();
    }

    private void setupDataActivityTracking(NetworkAgentInfo networkAgent) {
        int timeout;
        String iface = networkAgent.linkProperties.getInterfaceName();
        int type = -1;
        if (networkAgent.networkCapabilities.hasTransport(0)) {
            timeout = Settings.Global.getInt(this.mContext.getContentResolver(), "data_activity_timeout_mobile", 10);
            type = 0;
        } else if (networkAgent.networkCapabilities.hasTransport(1)) {
            timeout = Settings.Global.getInt(this.mContext.getContentResolver(), "data_activity_timeout_wifi", 15);
            type = 1;
        } else {
            timeout = 0;
        }
        if (timeout > 0 && iface != null && type != -1) {
            try {
                this.mNMS.addIdleTimer(iface, timeout, type);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in setupDataActivityTracking " + e);
            }
        }
    }

    private void removeDataActivityTracking(NetworkAgentInfo networkAgent) {
        String iface = networkAgent.linkProperties.getInterfaceName();
        NetworkCapabilities caps = networkAgent.networkCapabilities;
        if (iface != null && (caps.hasTransport(0) || caps.hasTransport(1))) {
            try {
                this.mNMS.removeIdleTimer(iface);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in removeDataActivityTracking " + e);
            }
        }
    }

    private void updateDataActivityTracking(NetworkAgentInfo newNetwork, NetworkAgentInfo oldNetwork) {
        if (newNetwork != null) {
            this.setupDataActivityTracking(newNetwork);
        }
        if (oldNetwork != null) {
            this.removeDataActivityTracking(oldNetwork);
        }
    }

    private void updateMtu(LinkProperties newLp, LinkProperties oldLp) {
        String iface = newLp.getInterfaceName();
        int mtu = newLp.getMtu();
        if (oldLp == null && mtu == 0) {
            return;
        }
        if (oldLp != null && newLp.isIdenticalMtu(oldLp)) {
            if (VDBG) {
                ConnectivityService.log("identical MTU - not setting");
            }
            return;
        }
        if (!LinkProperties.isValidMtu(mtu, newLp.hasGlobalIpv6Address())) {
            if (mtu != 0) {
                ConnectivityService.loge("Unexpected mtu value: " + mtu + ", " + iface);
            }
            return;
        }
        if (TextUtils.isEmpty(iface)) {
            ConnectivityService.loge("Setting MTU size with null iface.");
            return;
        }
        try {
            if (VDBG || DDBG) {
                ConnectivityService.log("Setting MTU size: " + iface + ", " + mtu);
            }
            this.mNMS.setMtu(iface, mtu);
        }
        catch (Exception e) {
            Slog.e(TAG, "exception in setMtu()" + e);
        }
    }

    @VisibleForTesting
    protected MockableSystemProperties getSystemProperties() {
        return new MockableSystemProperties();
    }

    private void updateTcpBufferSizes(String tcpBufferSizes) {
        String[] values = null;
        if (tcpBufferSizes != null) {
            values = tcpBufferSizes.split(",");
        }
        if (values == null || values.length != 6) {
            ConnectivityService.log("Invalid tcpBufferSizes string: " + tcpBufferSizes + ", using defaults");
            tcpBufferSizes = DEFAULT_TCP_BUFFER_SIZES;
            values = tcpBufferSizes.split(",");
        }
        if (tcpBufferSizes.equals(this.mCurrentTcpBufferSizes)) {
            return;
        }
        try {
            if (VDBG || DDBG) {
                Slog.d(TAG, "Setting tx/rx TCP buffers to " + tcpBufferSizes);
            }
            String rmemValues = String.join((CharSequence)" ", values[0], values[1], values[2]);
            String wmemValues = String.join((CharSequence)" ", values[3], values[4], values[5]);
            this.mNetd.setTcpRWmemorySize(rmemValues, wmemValues);
            this.mCurrentTcpBufferSizes = tcpBufferSizes;
        }
        catch (RemoteException | ServiceSpecificException e) {
            ConnectivityService.loge("Can't set TCP buffer sizes:" + e);
        }
        Integer rwndValue = Settings.Global.getInt(this.mContext.getContentResolver(), "tcp_default_init_rwnd", this.mSystemProperties.getInt(DEFAULT_TCP_RWND_KEY, 0));
        String sysctlKey = "sys.sysctl.tcp_def_init_rwnd";
        if (rwndValue != 0) {
            this.mSystemProperties.set("sys.sysctl.tcp_def_init_rwnd", rwndValue.toString());
        }
    }

    @Override
    public int getRestoreDefaultNetworkDelay(int networkType) {
        String restoreDefaultNetworkDelayStr = this.mSystemProperties.get(NETWORK_RESTORE_DELAY_PROP_NAME);
        if (restoreDefaultNetworkDelayStr != null && restoreDefaultNetworkDelayStr.length() != 0) {
            try {
                return Integer.parseInt(restoreDefaultNetworkDelayStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int ret = 60000;
        if (networkType <= 18 && this.mNetConfigs[networkType] != null) {
            ret = this.mNetConfigs[networkType].restoreTime;
        }
        return ret;
    }

    private void dumpNetworkDiagnostics(IndentingPrintWriter pw) {
        ArrayList<NetworkDiagnostics> netDiags = new ArrayList<NetworkDiagnostics>();
        long DIAG_TIME_MS = 5000L;
        for (NetworkAgentInfo nai : this.networksSortedById()) {
            netDiags.add(new NetworkDiagnostics(nai.network, new LinkProperties(nai.linkProperties), 5000L));
        }
        for (NetworkDiagnostics netDiag : netDiags) {
            pw.println();
            netDiag.waitForMeasurements();
            netDiag.dump(pw);
        }
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        PriorityDump.dump(this.mPriorityDumper, fd, writer, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDump(FileDescriptor fd, PrintWriter writer, String[] args, boolean asProto) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        if (asProto) {
            return;
        }
        if (ArrayUtils.contains(args, DIAG_ARG)) {
            this.dumpNetworkDiagnostics(pw);
            return;
        }
        if (ArrayUtils.contains(args, TETHERING_ARG)) {
            this.mTethering.dump(fd, pw, args);
            return;
        }
        if (ArrayUtils.contains(args, NETWORK_ARG)) {
            this.dumpNetworks(pw);
            return;
        }
        if (ArrayUtils.contains(args, REQUEST_ARG)) {
            this.dumpNetworkRequests(pw);
            return;
        }
        pw.print("NetworkFactories for:");
        for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
            pw.print(" " + nfi.name);
        }
        pw.println();
        pw.println();
        NetworkAgentInfo defaultNai = this.getDefaultNetwork();
        pw.print("Active default network: ");
        if (defaultNai == null) {
            pw.println("none");
        } else {
            pw.println(defaultNai.network.netId);
        }
        pw.println();
        pw.println("Current Networks:");
        pw.increaseIndent();
        this.dumpNetworks(pw);
        pw.decreaseIndent();
        pw.println();
        pw.print("Restrict background: ");
        pw.println(this.mRestrictBackground);
        pw.println();
        pw.println("Status for known UIDs:");
        pw.increaseIndent();
        int size = this.mUidRules.size();
        for (int i = 0; i < size; ++i) {
            try {
                int uid = this.mUidRules.keyAt(i);
                int uidRules = this.mUidRules.get(uid, 0);
                pw.println("UID=" + uid + " rules=" + NetworkPolicyManager.uidRulesToString(uidRules));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                pw.println("  ArrayIndexOutOfBoundsException");
                continue;
            }
            catch (ConcurrentModificationException e) {
                pw.println("  ConcurrentModificationException");
            }
        }
        pw.println();
        pw.decreaseIndent();
        pw.println("Network Requests:");
        pw.increaseIndent();
        this.dumpNetworkRequests(pw);
        pw.decreaseIndent();
        pw.println();
        this.mLegacyTypeTracker.dump(pw);
        pw.println();
        this.mTethering.dump(fd, pw, args);
        pw.println();
        this.mKeepaliveTracker.dump(pw);
        pw.println();
        this.dumpAvoidBadWifiSettings(pw);
        pw.println();
        this.mMultipathPolicyTracker.dump(pw);
        if (!ArrayUtils.contains(args, SHORT_ARG)) {
            pw.println();
            pw.println("mNetworkRequestInfoLogs (most recent first):");
            pw.increaseIndent();
            this.mNetworkRequestInfoLogs.reverseDump(fd, pw, args);
            pw.decreaseIndent();
            pw.println();
            pw.println("mNetworkInfoBlockingLogs (most recent first):");
            pw.increaseIndent();
            this.mNetworkInfoBlockingLogs.reverseDump(fd, pw, args);
            pw.decreaseIndent();
            pw.println();
            pw.println("NetTransition WakeLock activity (most recent first):");
            pw.increaseIndent();
            pw.println("total acquisitions: " + this.mTotalWakelockAcquisitions);
            pw.println("total releases: " + this.mTotalWakelockReleases);
            pw.println("cumulative duration: " + this.mTotalWakelockDurationMs / 1000L + "s");
            pw.println("longest duration: " + this.mMaxWakelockDurationMs / 1000L + "s");
            if (this.mTotalWakelockAcquisitions > this.mTotalWakelockReleases) {
                long duration = SystemClock.elapsedRealtime() - this.mLastWakeLockAcquireTimestamp;
                pw.println("currently holding WakeLock for: " + duration / 1000L + "s");
            }
            this.mWakelockLogs.reverseDump(fd, pw, args);
            pw.println();
            pw.println("bandwidth update requests (by uid):");
            pw.increaseIndent();
            SparseArray<Integer> sparseArray = this.mBandwidthRequests;
            synchronized (sparseArray) {
                for (int i = 0; i < this.mBandwidthRequests.size(); ++i) {
                    pw.println("[" + this.mBandwidthRequests.keyAt(i) + "]: " + this.mBandwidthRequests.valueAt(i));
                }
            }
            pw.decreaseIndent();
            pw.decreaseIndent();
        }
        pw.println();
        pw.println("NetworkStackClient logs:");
        pw.increaseIndent();
        NetworkStackClient.getInstance().dump(pw);
        pw.decreaseIndent();
        pw.println();
        pw.println("Permission Monitor:");
        pw.increaseIndent();
        this.mPermissionMonitor.dump(pw);
        pw.decreaseIndent();
    }

    private void dumpNetworks(IndentingPrintWriter pw) {
        for (NetworkAgentInfo nai : this.networksSortedById()) {
            pw.println(nai.toString());
            pw.increaseIndent();
            pw.println(String.format("Requests: REQUEST:%d LISTEN:%d BACKGROUND_REQUEST:%d total:%d", nai.numForegroundNetworkRequests(), nai.numNetworkRequests() - nai.numRequestNetworkRequests(), nai.numBackgroundNetworkRequests(), nai.numNetworkRequests()));
            pw.increaseIndent();
            for (int i = 0; i < nai.numNetworkRequests(); ++i) {
                pw.println(nai.requestAt(i).toString());
            }
            pw.decreaseIndent();
            pw.println("Lingered:");
            pw.increaseIndent();
            nai.dumpLingerTimers(pw);
            pw.decreaseIndent();
            pw.decreaseIndent();
        }
    }

    private void dumpNetworkRequests(IndentingPrintWriter pw) {
        for (NetworkRequestInfo nri : this.requestsSortedById()) {
            pw.println(nri.toString());
        }
    }

    private NetworkAgentInfo[] networksSortedById() {
        NetworkAgentInfo[] networks = new NetworkAgentInfo[]{};
        networks = this.mNetworkAgentInfos.values().toArray(networks);
        Arrays.sort(networks, Comparator.comparingInt(nai -> nai.network.netId));
        return networks;
    }

    private NetworkRequestInfo[] requestsSortedById() {
        NetworkRequestInfo[] requests = new NetworkRequestInfo[]{};
        requests = this.mNetworkRequests.values().toArray(requests);
        Arrays.sort(requests, Comparator.comparingInt(nri -> nri.request.requestId));
        return requests;
    }

    private boolean isLiveNetworkAgent(NetworkAgentInfo nai, int what) {
        if (nai.network == null) {
            return false;
        }
        NetworkAgentInfo officialNai = this.getNetworkAgentInfoForNetwork(nai.network);
        if (officialNai != null && officialNai.equals(nai)) {
            return true;
        }
        if (officialNai != null || VDBG) {
            ConnectivityService.loge(ConnectivityService.eventName(what) + " - isLiveNetworkAgent found mismatched netId: " + officialNai + " - " + nai);
        }
        return false;
    }

    private boolean networkRequiresPrivateDnsValidation(NetworkAgentInfo nai) {
        return NetworkMonitorUtils.isPrivateDnsValidationRequired(nai.networkCapabilities);
    }

    private void handleFreshlyValidatedNetwork(NetworkAgentInfo nai) {
        if (nai == null) {
            return;
        }
        PrivateDnsConfig cfg = this.mDnsManager.getPrivateDnsConfig();
        if (cfg.useTls && TextUtils.isEmpty(cfg.hostname)) {
            this.updateDnses(nai.linkProperties, null, nai.network.netId);
        }
    }

    private void handlePrivateDnsSettingsChanged() {
        PrivateDnsConfig cfg = this.mDnsManager.getPrivateDnsConfig();
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            this.handlePerNetworkPrivateDnsConfig(nai, cfg);
            if (!this.networkRequiresPrivateDnsValidation(nai)) continue;
            this.handleUpdateLinkProperties(nai, new LinkProperties(nai.linkProperties));
        }
    }

    private void handlePerNetworkPrivateDnsConfig(NetworkAgentInfo nai, PrivateDnsConfig cfg) {
        if (!this.networkRequiresPrivateDnsValidation(nai)) {
            return;
        }
        nai.networkMonitor().notifyPrivateDnsChanged(cfg.toParcel());
        this.updatePrivateDns(nai, cfg);
    }

    private void updatePrivateDns(NetworkAgentInfo nai, PrivateDnsConfig newCfg) {
        this.mDnsManager.updatePrivateDns(nai.network, newCfg);
        this.updateDnses(nai.linkProperties, null, nai.network.netId);
    }

    private void handlePrivateDnsValidationUpdate(DnsManager.PrivateDnsValidationUpdate update) {
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetId(update.netId);
        if (nai == null) {
            return;
        }
        this.mDnsManager.updatePrivateDnsValidation(update);
        this.handleUpdateLinkProperties(nai, new LinkProperties(nai.linkProperties));
    }

    private void handleNat64PrefixEvent(int netId, boolean added, String prefixString, int prefixLength) {
        NetworkAgentInfo nai = this.mNetworkForNetId.get(netId);
        if (nai == null) {
            return;
        }
        ConnectivityService.log(String.format("NAT64 prefix %s on netId %d: %s/%d", added ? "added" : "removed", netId, prefixString, prefixLength));
        IpPrefix prefix = null;
        if (added) {
            try {
                prefix = new IpPrefix(InetAddresses.parseNumericAddress(prefixString), prefixLength);
            }
            catch (IllegalArgumentException e) {
                ConnectivityService.loge("Invalid NAT64 prefix " + prefixString + "/" + prefixLength);
                return;
            }
        }
        nai.clatd.setNat64Prefix(prefix);
        this.handleUpdateLinkProperties(nai, new LinkProperties(nai.linkProperties));
    }

    private void updateLingerState(NetworkAgentInfo nai, long now) {
        nai.updateLingerTimer();
        if (nai.isLingering() && nai.numForegroundNetworkRequests() > 0) {
            ConnectivityService.log("Unlingering " + nai.name());
            nai.unlinger();
            this.logNetworkEvent(nai, 6);
        } else if (this.unneeded(nai, UnneededFor.LINGER) && nai.getLingerExpiry() > 0L) {
            int lingerTime = (int)(nai.getLingerExpiry() - now);
            ConnectivityService.log("Lingering " + nai.name() + " for " + lingerTime + "ms");
            nai.linger();
            this.logNetworkEvent(nai, 5);
            this.notifyNetworkCallbacks(nai, 524291, lingerTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsyncChannelHalfConnect(Message msg) {
        AsyncChannel ac = (AsyncChannel)msg.obj;
        if (this.mNetworkFactoryInfos.containsKey(msg.replyTo)) {
            if (msg.arg1 == 0) {
                if (VDBG) {
                    ConnectivityService.log("NetworkFactory connected");
                }
                this.mNetworkFactoryInfos.get((Object)msg.replyTo).asyncChannel.sendMessage(69633);
                for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
                    int serial;
                    int score;
                    if (nri.request.isListen()) continue;
                    NetworkAgentInfo nai = this.getNetworkForRequest(nri.request.requestId);
                    if (nai != null) {
                        score = nai.getCurrentScore();
                        serial = nai.factorySerialNumber;
                    } else {
                        score = 0;
                        serial = -1;
                    }
                    ac.sendMessage(536576, score, serial, nri.request);
                }
            } else {
                ConnectivityService.loge("Error connecting NetworkFactory");
                this.mNetworkFactoryInfos.remove(msg.obj);
            }
        } else if (this.mNetworkAgentInfos.containsKey(msg.replyTo)) {
            if (msg.arg1 == 0) {
                if (VDBG) {
                    ConnectivityService.log("NetworkAgent connected");
                }
                this.mNetworkAgentInfos.get((Object)msg.replyTo).asyncChannel.sendMessage(69633);
            } else {
                ConnectivityService.loge("Error connecting NetworkAgent");
                NetworkAgentInfo nai = this.mNetworkAgentInfos.remove(msg.replyTo);
                if (nai != null) {
                    boolean wasDefault = this.isDefaultNetwork(nai);
                    SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
                    synchronized (sparseArray) {
                        this.mNetworkForNetId.remove(nai.network.netId);
                        this.mNetIdInUse.delete(nai.network.netId);
                    }
                    this.mLegacyTypeTracker.remove(nai, wasDefault);
                }
            }
        }
    }

    private void handleAsyncChannelDisconnected(Message msg) {
        NetworkAgentInfo nai = this.mNetworkAgentInfos.get(msg.replyTo);
        if (nai != null) {
            this.disconnectAndDestroyNetwork(nai);
        } else {
            NetworkFactoryInfo nfi = this.mNetworkFactoryInfos.remove(msg.replyTo);
            if (nfi != null) {
                ConnectivityService.log("unregisterNetworkFactory for " + nfi.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAndDestroyNetwork(NetworkAgentInfo nai) {
        boolean wasDefault;
        ConnectivityService.log(nai.name() + " got DISCONNECTED, was satisfying " + nai.numNetworkRequests());
        this.mNotifier.clearNotification(nai.network.netId);
        if (nai.networkInfo.isConnected()) {
            nai.networkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
        }
        if (wasDefault = this.isDefaultNetwork(nai)) {
            this.mDefaultInetConditionPublished = 0;
            long now = SystemClock.elapsedRealtime();
            this.metricsLogger().defaultNetworkMetrics().logDefaultNetworkEvent(now, null, nai);
        }
        this.notifyIfacesChangedForNetworkStats();
        this.notifyNetworkCallbacks(nai, 524292);
        this.mKeepaliveTracker.handleStopAllKeepalives(nai, -20);
        for (String iface : nai.linkProperties.getAllInterfaceNames()) {
            this.wakeupModifyInterface(iface, nai.networkCapabilities, false);
        }
        nai.networkMonitor().notifyNetworkDisconnected();
        this.mNetworkAgentInfos.remove(nai.messenger);
        nai.clatd.update();
        SparseArray<NetworkAgentInfo> now = this.mNetworkForNetId;
        synchronized (now) {
            this.mNetworkForNetId.remove(nai.network.netId);
        }
        for (int i = 0; i < nai.numNetworkRequests(); ++i) {
            NetworkRequest request = nai.requestAt(i);
            NetworkAgentInfo currentNetwork = this.getNetworkForRequest(request.requestId);
            if (currentNetwork == null || currentNetwork.network.netId != nai.network.netId) continue;
            this.clearNetworkForRequest(request.requestId);
            this.sendUpdatedScoreToFactories(request, null);
        }
        nai.clearLingerState();
        if (nai.isSatisfyingRequest(this.mDefaultRequest.requestId)) {
            this.updateDataActivityTracking(null, nai);
            this.notifyLockdownVpn(nai);
            this.ensureNetworkTransitionWakelock(nai.name());
        }
        this.mLegacyTypeTracker.remove(nai, wasDefault);
        if (!nai.networkCapabilities.hasTransport(4)) {
            this.updateAllVpnsCapabilities();
        }
        this.rematchAllNetworksAndRequests(null, 0);
        this.mLingerMonitor.noteDisconnect(nai);
        if (nai.created) {
            this.destroyNativeNetwork(nai);
            this.mDnsManager.removeNetwork(nai.network);
        }
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            this.mNetIdInUse.delete(nai.network.netId);
        }
    }

    private boolean createNativeNetwork(NetworkAgentInfo networkAgent) {
        try {
            if (networkAgent.isVPN()) {
                this.mNetd.networkCreateVpn(networkAgent.network.netId, networkAgent.networkMisc == null || !networkAgent.networkMisc.allowBypass);
            } else {
                this.mNetd.networkCreatePhysical(networkAgent.network.netId, this.getNetworkPermission(networkAgent.networkCapabilities));
            }
            this.mDnsResolver.createNetworkCache(networkAgent.network.netId);
            return true;
        }
        catch (RemoteException | ServiceSpecificException e) {
            ConnectivityService.loge("Error creating network " + networkAgent.network.netId + ": " + e.getMessage());
            return false;
        }
    }

    private void destroyNativeNetwork(NetworkAgentInfo networkAgent) {
        try {
            this.mNetd.networkDestroy(networkAgent.network.netId);
            this.mDnsResolver.destroyNetworkCache(networkAgent.network.netId);
        }
        catch (RemoteException | ServiceSpecificException e) {
            ConnectivityService.loge("Exception destroying network: " + e);
        }
    }

    private NetworkRequestInfo findExistingNetworkRequestInfo(PendingIntent pendingIntent) {
        Intent intent = pendingIntent.getIntent();
        for (Map.Entry<NetworkRequest, NetworkRequestInfo> entry : this.mNetworkRequests.entrySet()) {
            PendingIntent existingPendingIntent = entry.getValue().mPendingIntent;
            if (existingPendingIntent == null || !existingPendingIntent.getIntent().filterEquals(intent)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void handleRegisterNetworkRequestWithIntent(Message msg) {
        NetworkRequestInfo nri = (NetworkRequestInfo)msg.obj;
        NetworkRequestInfo existingRequest = this.findExistingNetworkRequestInfo(nri.mPendingIntent);
        if (existingRequest != null) {
            ConnectivityService.log("Replacing " + existingRequest.request + " with " + nri.request + " because their intents matched.");
            this.handleReleaseNetworkRequest(existingRequest.request, ConnectivityService.getCallingUid(), false);
        }
        this.handleRegisterNetworkRequest(nri);
    }

    private void handleRegisterNetworkRequest(NetworkRequestInfo nri) {
        this.mNetworkRequests.put(nri.request, nri);
        this.mNetworkRequestInfoLogs.log("REGISTER " + nri);
        if (nri.request.isListen()) {
            for (NetworkAgentInfo network : this.mNetworkAgentInfos.values()) {
                if (!nri.request.networkCapabilities.hasSignalStrength() || !network.satisfiesImmutableCapabilitiesOf(nri.request)) continue;
                this.updateSignalStrengthThresholds(network, "REGISTER", nri.request);
            }
        }
        this.rematchAllNetworksAndRequests(null, 0);
        if (nri.request.isRequest() && this.getNetworkForRequest(nri.request.requestId) == null) {
            this.sendUpdatedScoreToFactories(nri.request, null);
        }
    }

    private void handleReleaseNetworkRequestWithIntent(PendingIntent pendingIntent, int callingUid) {
        NetworkRequestInfo nri = this.findExistingNetworkRequestInfo(pendingIntent);
        if (nri != null) {
            this.handleReleaseNetworkRequest(nri.request, callingUid, false);
        }
    }

    private boolean unneeded(NetworkAgentInfo nai, UnneededFor reason) {
        int numRequests;
        switch (reason) {
            case TEARDOWN: {
                numRequests = nai.numRequestNetworkRequests();
                break;
            }
            case LINGER: {
                numRequests = nai.numForegroundNetworkRequests();
                break;
            }
            default: {
                Slog.wtf(TAG, "Invalid reason. Cannot happen.");
                return true;
            }
        }
        if (!nai.everConnected || nai.isVPN() || nai.isLingering() || numRequests > 0) {
            return false;
        }
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            if (reason == UnneededFor.LINGER && nri.request.isBackgroundRequest() || !nri.request.isRequest() || !nai.satisfies(nri.request) || !nai.isSatisfyingRequest(nri.request.requestId) && this.getNetworkForRequest(nri.request.requestId).getCurrentScore() >= nai.getCurrentScoreAsValidated()) continue;
            return false;
        }
        return true;
    }

    private NetworkRequestInfo getNriForAppRequest(NetworkRequest request, int callingUid, String requestedOperation) {
        NetworkRequestInfo nri = this.mNetworkRequests.get(request);
        if (nri != null && 1000 != callingUid && nri.mUid != callingUid) {
            ConnectivityService.log(String.format("UID %d attempted to %s for unowned request %s", callingUid, requestedOperation, nri));
            return null;
        }
        return nri;
    }

    private void handleTimedOutNetworkRequest(NetworkRequestInfo nri) {
        if (this.mNetworkRequests.get(nri.request) == null) {
            return;
        }
        if (this.getNetworkForRequest(nri.request.requestId) != null) {
            return;
        }
        if (VDBG || nri.request.isRequest()) {
            ConnectivityService.log("releasing " + nri.request + " (timeout)");
        }
        this.handleRemoveNetworkRequest(nri);
        this.callCallbackForRequest(nri, null, 524293, 0);
    }

    private void handleReleaseNetworkRequest(NetworkRequest request, int callingUid, boolean callOnUnavailable) {
        NetworkRequestInfo nri = this.getNriForAppRequest(request, callingUid, "release NetworkRequest");
        if (nri == null) {
            return;
        }
        if (VDBG || nri.request.isRequest()) {
            ConnectivityService.log("releasing " + nri.request + " (release request)");
        }
        this.handleRemoveNetworkRequest(nri);
        if (callOnUnavailable) {
            this.callCallbackForRequest(nri, null, 524293, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoveNetworkRequest(NetworkRequestInfo nri) {
        nri.unlinkDeathRecipient();
        this.mNetworkRequests.remove(nri.request);
        SparseIntArray sparseIntArray = this.mUidToNetworkRequestCount;
        synchronized (sparseIntArray) {
            int requests = this.mUidToNetworkRequestCount.get(nri.mUid, 0);
            if (requests < 1) {
                Slog.wtf(TAG, "BUG: too small request count " + requests + " for UID " + nri.mUid);
            } else if (requests == 1) {
                this.mUidToNetworkRequestCount.removeAt(this.mUidToNetworkRequestCount.indexOfKey(nri.mUid));
            } else {
                this.mUidToNetworkRequestCount.put(nri.mUid, requests - 1);
            }
        }
        this.mNetworkRequestInfoLogs.log("RELEASE " + nri);
        if (nri.request.isRequest()) {
            boolean wasKept = false;
            NetworkAgentInfo nai = this.getNetworkForRequest(nri.request.requestId);
            if (nai != null) {
                boolean wasBackgroundNetwork = nai.isBackgroundNetwork();
                nai.removeRequest(nri.request.requestId);
                if (VDBG || DDBG) {
                    ConnectivityService.log(" Removing from current network " + nai.name() + ", leaving " + nai.numNetworkRequests() + " requests.");
                }
                this.updateLingerState(nai, SystemClock.elapsedRealtime());
                if (this.unneeded(nai, UnneededFor.TEARDOWN)) {
                    ConnectivityService.log("no live requests for " + nai.name() + "; disconnecting");
                    this.teardownUnneededNetwork(nai);
                } else {
                    wasKept = true;
                }
                this.clearNetworkForRequest(nri.request.requestId);
                if (!wasBackgroundNetwork && nai.isBackgroundNetwork()) {
                    this.updateCapabilities(nai.getCurrentScore(), nai, nai.networkCapabilities);
                }
            }
            if (nri.request.legacyType != -1 && nai != null) {
                boolean doRemove = true;
                if (wasKept) {
                    for (int i = 0; i < nai.numNetworkRequests(); ++i) {
                        NetworkRequest otherRequest = nai.requestAt(i);
                        if (otherRequest.legacyType != nri.request.legacyType || !otherRequest.isRequest()) continue;
                        ConnectivityService.log(" still have other legacy request - leaving");
                        doRemove = false;
                    }
                }
                if (doRemove) {
                    this.mLegacyTypeTracker.remove(nri.request.legacyType, nai, false);
                }
            }
            for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
                nfi.asyncChannel.sendMessage(536577, nri.request);
            }
        } else {
            for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                nai.removeRequest(nri.request.requestId);
                if (!nri.request.networkCapabilities.hasSignalStrength() || !nai.satisfiesImmutableCapabilitiesOf(nri.request)) continue;
                this.updateSignalStrengthThresholds(nai, "RELEASE", nri.request);
            }
        }
    }

    @Override
    public void setAcceptUnvalidated(Network network, boolean accept, boolean always) {
        this.enforceNetworkStackSettingsOrSetup();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(28, ConnectivityService.encodeBool(accept), ConnectivityService.encodeBool(always), network));
    }

    @Override
    public void setAcceptPartialConnectivity(Network network, boolean accept, boolean always) {
        this.enforceNetworkStackSettingsOrSetup();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(45, ConnectivityService.encodeBool(accept), ConnectivityService.encodeBool(always), network));
    }

    @Override
    public void setAvoidUnvalidated(Network network) {
        this.enforceNetworkStackSettingsOrSetup();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(35, network));
    }

    private void handleSetAcceptUnvalidated(Network network, boolean accept, boolean always) {
        ConnectivityService.log("handleSetAcceptUnvalidated network=" + network + " accept=" + accept + " always=" + always);
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null) {
            return;
        }
        if (nai.everValidated) {
            return;
        }
        if (!nai.networkMisc.explicitlySelected) {
            Slog.wtf(TAG, "BUG: setAcceptUnvalidated non non-explicitly selected network");
        }
        if (accept != nai.networkMisc.acceptUnvalidated) {
            int oldScore = nai.getCurrentScore();
            nai.networkMisc.acceptUnvalidated = accept;
            nai.networkMisc.acceptPartialConnectivity = accept;
            this.rematchAllNetworksAndRequests(nai, oldScore);
            this.sendUpdatedScoreToFactories(nai);
        }
        if (always) {
            nai.asyncChannel.sendMessage(528393, ConnectivityService.encodeBool(accept));
        }
        if (!accept) {
            nai.asyncChannel.sendMessage(528399);
            this.teardownUnneededNetwork(nai);
        }
    }

    private void handleSetAcceptPartialConnectivity(Network network, boolean accept, boolean always) {
        ConnectivityService.log("handleSetAcceptPartialConnectivity network=" + network + " accept=" + accept + " always=" + always);
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null) {
            return;
        }
        if (nai.lastValidated) {
            return;
        }
        if (accept != nai.networkMisc.acceptPartialConnectivity) {
            nai.networkMisc.acceptPartialConnectivity = accept;
        }
        if (always) {
            nai.asyncChannel.sendMessage(528393, ConnectivityService.encodeBool(accept));
        }
        if (!accept) {
            nai.asyncChannel.sendMessage(528399);
            this.teardownUnneededNetwork(nai);
        } else {
            nai.networkMonitor().setAcceptPartialConnectivity();
        }
    }

    private void handleSetAvoidUnvalidated(Network network) {
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null || nai.lastValidated) {
            return;
        }
        if (!nai.avoidUnvalidated) {
            int oldScore = nai.getCurrentScore();
            nai.avoidUnvalidated = true;
            this.rematchAllNetworksAndRequests(nai, oldScore);
            this.sendUpdatedScoreToFactories(nai);
        }
    }

    private void scheduleUnvalidatedPrompt(NetworkAgentInfo nai) {
        if (VDBG) {
            ConnectivityService.log("scheduleUnvalidatedPrompt " + nai.network);
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(29, nai.network), 8000L);
    }

    @Override
    public void startCaptivePortalApp(Network network) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.post(() -> {
            NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
            if (nai == null) {
                return;
            }
            if (!nai.networkCapabilities.hasCapability(17)) {
                return;
            }
            nai.networkMonitor().launchCaptivePortalApp();
        });
    }

    @Override
    public void startCaptivePortalAppInternal(Network network, Bundle appExtras) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MAINLINE_NETWORK_STACK", "ConnectivityService");
        Intent appIntent = new Intent("android.net.conn.CAPTIVE_PORTAL");
        appIntent.putExtras(appExtras);
        appIntent.putExtra("android.net.extra.CAPTIVE_PORTAL", new CaptivePortal(new CaptivePortalImpl(network).asBinder()));
        appIntent.setFlags(0x10400000);
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai != null) {
            nai.captivePortalValidationPending = true;
        }
        Binder.withCleanCallingIdentity(() -> this.mContext.startActivityAsUser(appIntent, UserHandle.CURRENT));
    }

    public boolean avoidBadWifi() {
        return this.mMultinetworkPolicyTracker.getAvoidBadWifi();
    }

    @Override
    public boolean shouldAvoidBadWifi() {
        if (!this.checkNetworkStackPermission()) {
            throw new SecurityException("avoidBadWifi requires NETWORK_STACK permission");
        }
        return this.avoidBadWifi();
    }

    private void rematchForAvoidBadWifiUpdate() {
        this.rematchAllNetworksAndRequests(null, 0);
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            if (!nai.networkCapabilities.hasTransport(1)) continue;
            this.sendUpdatedScoreToFactories(nai);
        }
    }

    private void dumpAvoidBadWifiSettings(IndentingPrintWriter pw) {
        boolean configRestrict = this.mMultinetworkPolicyTracker.configRestrictsAvoidBadWifi();
        if (!configRestrict) {
            pw.println("Bad Wi-Fi avoidance: unrestricted");
            return;
        }
        pw.println("Bad Wi-Fi avoidance: " + this.avoidBadWifi());
        pw.increaseIndent();
        pw.println("Config restrict:   " + configRestrict);
        String value = this.mMultinetworkPolicyTracker.getAvoidBadWifiSetting();
        String description = "0".equals(value) ? "get stuck" : (value == null ? "prompt" : ("1".equals(value) ? "avoid" : value + " (?)"));
        pw.println("User setting:      " + description);
        pw.println("Network overrides:");
        pw.increaseIndent();
        for (NetworkAgentInfo nai : this.networksSortedById()) {
            if (!nai.avoidUnvalidated) continue;
            pw.println(nai.name());
        }
        pw.decreaseIndent();
        pw.decreaseIndent();
    }

    private void showNetworkNotification(NetworkAgentInfo nai, NetworkNotificationManager.NotificationType type) {
        boolean highPriority;
        String action;
        switch (type) {
            case LOGGED_IN: {
                action = "android.settings.WIFI_SETTINGS";
                this.mHandler.removeMessages(44);
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(44, nai.network.netId, 0), 20000L);
                highPriority = true;
                break;
            }
            case NO_INTERNET: {
                action = "android.net.conn.PROMPT_UNVALIDATED";
                highPriority = true;
                break;
            }
            case LOST_INTERNET: {
                action = "android.net.conn.PROMPT_LOST_VALIDATION";
                highPriority = true;
                break;
            }
            case PARTIAL_CONNECTIVITY: {
                action = "android.net.conn.PROMPT_PARTIAL_CONNECTIVITY";
                highPriority = nai.networkMisc.explicitlySelected;
                break;
            }
            default: {
                Slog.wtf(TAG, "Unknown notification type " + (Object)((Object)type));
                return;
            }
        }
        Intent intent = new Intent(action);
        if (type != NetworkNotificationManager.NotificationType.LOGGED_IN) {
            intent.setData(Uri.fromParts("netId", Integer.toString(nai.network.netId), null));
            intent.addFlags(0x10000000);
            intent.setClassName("com.android.settings", "com.android.settings.wifi.WifiNoInternetDialog");
        }
        PendingIntent pendingIntent = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x10000000, null, UserHandle.CURRENT);
        this.mNotifier.showNotification(nai.network.netId, type, nai, null, pendingIntent, highPriority);
    }

    private boolean shouldPromptUnvalidated(NetworkAgentInfo nai) {
        if (nai.everValidated || nai.everCaptivePortalDetected) {
            return false;
        }
        if (nai.partialConnectivity && !nai.networkMisc.acceptPartialConnectivity) {
            return true;
        }
        return nai.networkMisc.explicitlySelected && !nai.networkMisc.acceptUnvalidated;
    }

    private void handlePromptUnvalidated(Network network) {
        NetworkAgentInfo nai;
        if (VDBG || DDBG) {
            ConnectivityService.log("handlePromptUnvalidated " + network);
        }
        if ((nai = this.getNetworkAgentInfoForNetwork(network)) == null || !this.shouldPromptUnvalidated(nai)) {
            return;
        }
        nai.asyncChannel.sendMessage(528399);
        if (nai.partialConnectivity) {
            this.showNetworkNotification(nai, NetworkNotificationManager.NotificationType.PARTIAL_CONNECTIVITY);
        } else {
            this.showNetworkNotification(nai, NetworkNotificationManager.NotificationType.NO_INTERNET);
        }
    }

    private void handleNetworkUnvalidated(NetworkAgentInfo nai) {
        NetworkCapabilities nc = nai.networkCapabilities;
        ConnectivityService.log("handleNetworkUnvalidated " + nai.name() + " cap=" + nc);
        if (!nc.hasTransport(1)) {
            return;
        }
        if (this.mMultinetworkPolicyTracker.shouldNotifyWifiUnvalidated()) {
            this.showNetworkNotification(nai, NetworkNotificationManager.NotificationType.LOST_INTERNET);
        }
    }

    @Override
    public int getMultipathPreference(Network network) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai != null && nai.networkCapabilities.hasCapability(11)) {
            return 7;
        }
        Integer networkPreference = this.mMultipathPolicyTracker.getMultipathPreference(network);
        if (networkPreference != null) {
            return networkPreference;
        }
        return this.mMultinetworkPolicyTracker.getMeteredMultipathPreference();
    }

    @Override
    public NetworkRequest getDefaultRequest() {
        return this.mDefaultRequest;
    }

    @Override
    public int tether(String iface, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        if (this.isTetheringSupported()) {
            return this.mTethering.tether(iface);
        }
        return 3;
    }

    @Override
    public int untether(String iface, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        if (this.isTetheringSupported()) {
            return this.mTethering.untether(iface);
        }
        return 3;
    }

    @Override
    public int getLastTetherError(String iface) {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getLastTetherError(iface);
        }
        return 3;
    }

    @Override
    public String[] getTetherableUsbRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableUsbRegexs();
        }
        return new String[0];
    }

    @Override
    public String[] getTetherableWifiRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableWifiRegexs();
        }
        return new String[0];
    }

    @Override
    public String[] getTetherableBluetoothRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableBluetoothRegexs();
        }
        return new String[0];
    }

    @Override
    public int setUsbTethering(boolean enable, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        if (this.isTetheringSupported()) {
            return this.mTethering.setUsbTethering(enable);
        }
        return 3;
    }

    @Override
    public String[] getTetherableIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetherableIfaces();
    }

    @Override
    public String[] getTetheredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetheredIfaces();
    }

    @Override
    public String[] getTetheringErroredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getErroredIfaces();
    }

    @Override
    public String[] getTetheredDhcpRanges() {
        this.enforceConnectivityInternalPermission();
        return this.mTethering.getTetheredDhcpRanges();
    }

    @Override
    public boolean isTetheringSupported(String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        return this.isTetheringSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTetheringSupported() {
        int defaultVal = ConnectivityService.encodeBool(!this.mSystemProperties.get("ro.tether.denied").equals("true"));
        boolean tetherSupported = ConnectivityService.toBool(Settings.Global.getInt(this.mContext.getContentResolver(), "tether_supported", defaultVal));
        boolean tetherEnabledInSettings = tetherSupported && !this.mUserManager.hasUserRestriction("no_config_tethering");
        boolean adminUser = false;
        long token = Binder.clearCallingIdentity();
        try {
            adminUser = this.mUserManager.isAdminUser();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return tetherEnabledInSettings && adminUser && this.mTethering.hasTetherableConfiguration();
    }

    @Override
    public void startTethering(int type, ResultReceiver receiver, boolean showProvisioningUi, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        if (!this.isTetheringSupported()) {
            receiver.send(3, null);
            return;
        }
        this.mTethering.startTethering(type, receiver, showProvisioningUi);
    }

    @Override
    public void stopTethering(int type, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        this.mTethering.stopTethering(type);
    }

    @Override
    public void getLatestTetheringEntitlementResult(int type, ResultReceiver receiver, boolean showEntitlementUi, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        this.mTethering.getLatestTetheringEntitlementResult(type, receiver, showEntitlementUi);
    }

    @Override
    public void registerTetheringEventCallback(ITetheringEventCallback callback, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        this.mTethering.registerTetheringEventCallback(callback);
    }

    @Override
    public void unregisterTetheringEventCallback(ITetheringEventCallback callback, String callerPkg) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext, callerPkg);
        this.mTethering.unregisterTetheringEventCallback(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNetworkTransitionWakelock(String forWhom) {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (this.mNetTransitionWakeLock.isHeld()) {
                return;
            }
            this.mNetTransitionWakeLock.acquire();
            this.mLastWakeLockAcquireTimestamp = SystemClock.elapsedRealtime();
            ++this.mTotalWakelockAcquisitions;
        }
        this.mWakelockLogs.log("ACQUIRE for " + forWhom);
        Message msg = this.mHandler.obtainMessage(24);
        this.mHandler.sendMessageDelayed(msg, this.mNetTransitionWakeLockTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReleaseNetworkTransitionWakelock() {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (!this.mNetTransitionWakeLock.isHeld()) {
                return;
            }
        }
        this.mHandler.removeMessages(24);
        Message msg = this.mHandler.obtainMessage(8);
        this.mHandler.sendMessageDelayed(msg, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReleaseNetworkTransitionWakelock(int eventId) {
        String event = ConnectivityService.eventName(eventId);
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (!this.mNetTransitionWakeLock.isHeld()) {
                this.mWakelockLogs.log(String.format("RELEASE: already released (%s)", event));
                Slog.w(TAG, "expected Net Transition WakeLock to be held");
                return;
            }
            this.mNetTransitionWakeLock.release();
            long lockDuration = SystemClock.elapsedRealtime() - this.mLastWakeLockAcquireTimestamp;
            this.mTotalWakelockDurationMs += lockDuration;
            this.mMaxWakelockDurationMs = Math.max(this.mMaxWakelockDurationMs, lockDuration);
            ++this.mTotalWakelockReleases;
        }
        this.mWakelockLogs.log(String.format("RELEASE (%s)", event));
    }

    @Override
    public void reportInetCondition(int networkType, int percentage) {
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai == null) {
            return;
        }
        this.reportNetworkConnectivity(nai.network, percentage > 50);
    }

    @Override
    public void reportNetworkConnectivity(Network network, boolean hasConnectivity) {
        this.enforceAccessPermission();
        this.enforceInternetPermission();
        int uid = Binder.getCallingUid();
        int connectivityInfo = ConnectivityService.encodeBool(hasConnectivity);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(36, uid, connectivityInfo, network));
    }

    private void handleReportNetworkConnectivity(Network network, int uid, boolean hasConnectivity) {
        NetworkAgentInfo nai = network == null ? this.getDefaultNetwork() : this.getNetworkAgentInfoForNetwork(network);
        if (nai == null || nai.networkInfo.getState() == NetworkInfo.State.DISCONNECTING || nai.networkInfo.getState() == NetworkInfo.State.DISCONNECTED) {
            return;
        }
        if (hasConnectivity == nai.lastValidated) {
            return;
        }
        int netid = nai.network.netId;
        ConnectivityService.log("reportNetworkConnectivity(" + netid + ", " + hasConnectivity + ") by " + uid);
        if (!nai.everConnected) {
            return;
        }
        LinkProperties lp = this.getLinkProperties(nai);
        if (this.isNetworkWithLinkPropertiesBlocked(lp, uid, false)) {
            return;
        }
        nai.networkMonitor().forceReevaluation(uid);
    }

    @Override
    public ProxyInfo getProxyForNetwork(Network network) {
        ProxyInfo globalProxy = this.mProxyTracker.getGlobalProxy();
        if (globalProxy != null) {
            return globalProxy;
        }
        if (network == null) {
            Network activeNetwork = this.getActiveNetworkForUidInternal(Binder.getCallingUid(), true);
            if (activeNetwork == null) {
                return null;
            }
            return this.getLinkPropertiesProxyInfo(activeNetwork);
        }
        if (this.queryUserAccess(Binder.getCallingUid(), network.netId)) {
            return this.getLinkPropertiesProxyInfo(network);
        }
        return null;
    }

    @VisibleForTesting
    protected boolean queryUserAccess(int uid, int netId) {
        return NetworkUtils.queryUserAccess(uid, netId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyInfo getLinkPropertiesProxyInfo(Network network) {
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null) {
            return null;
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            ProxyInfo linkHttpProxy = nai.linkProperties.getHttpProxy();
            return linkHttpProxy == null ? null : new ProxyInfo(linkHttpProxy);
        }
    }

    @Override
    public void setGlobalProxy(ProxyInfo proxyProperties) {
        this.enforceConnectivityInternalPermission();
        this.mProxyTracker.setGlobalProxy(proxyProperties);
    }

    @Override
    public ProxyInfo getGlobalProxy() {
        return this.mProxyTracker.getGlobalProxy();
    }

    private void handleApplyDefaultProxy(ProxyInfo proxy) {
        if (proxy != null && TextUtils.isEmpty(proxy.getHost()) && Uri.EMPTY.equals(proxy.getPacFileUrl())) {
            proxy = null;
        }
        this.mProxyTracker.setDefaultProxy(proxy);
    }

    private void updateProxy(LinkProperties newLp, LinkProperties oldLp) {
        ProxyInfo oldProxyInfo;
        ProxyInfo newProxyInfo = newLp == null ? null : newLp.getHttpProxy();
        ProxyInfo proxyInfo = oldProxyInfo = oldLp == null ? null : oldLp.getHttpProxy();
        if (!ProxyTracker.proxyInfoEqual(newProxyInfo, oldProxyInfo)) {
            this.mProxyTracker.sendProxyBroadcast();
        }
    }

    private static void log(String s) {
        Slog.d(TAG, s);
    }

    private static void loge(String s) {
        Slog.e(TAG, s);
    }

    private static void loge(String s, Throwable t) {
        Slog.e(TAG, s, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareVpn(String oldPackage, String newPackage, int userId) {
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            Vpn vpn = this.mVpns.get(userId);
            if (vpn != null) {
                return vpn.prepare(oldPackage, newPackage);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVpnPackageAuthorization(String packageName, int userId, boolean authorized) {
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn != null) {
                vpn.setPackageAuthorization(packageName, authorized);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor establishVpn(VpnConfig config) {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            return this.mVpns.get(user).establish(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLegacyVpn(VpnProfile profile) {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        LinkProperties egress = this.getActiveLinkProperties();
        if (egress == null) {
            throw new IllegalStateException("Missing active network connection");
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            this.mVpns.get(user).startLegacyVpn(profile, this.mKeyStore, egress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LegacyVpnInfo getLegacyVpnInfo(int userId) {
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(userId).getLegacyVpnInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VpnInfo[] getAllVpnInfo() {
        this.ensureRunningOnConnectivityServiceThread();
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (this.mLockdownEnabled) {
                return new VpnInfo[0];
            }
            ArrayList<VpnInfo> infoList = new ArrayList<VpnInfo>();
            for (int i = 0; i < this.mVpns.size(); ++i) {
                VpnInfo info = this.createVpnInfo(this.mVpns.valueAt(i));
                if (info == null) continue;
                infoList.add(info);
            }
            return infoList.toArray(new VpnInfo[infoList.size()]);
        }
    }

    private VpnInfo createVpnInfo(Vpn vpn) {
        LinkProperties linkProperties;
        VpnInfo info = vpn.getVpnInfo();
        if (info == null) {
            return null;
        }
        Network[] underlyingNetworks = vpn.getUnderlyingNetworks();
        if (underlyingNetworks == null) {
            NetworkAgentInfo defaultNetwork = this.getDefaultNetwork();
            if (defaultNetwork != null && defaultNetwork.linkProperties != null) {
                info.primaryUnderlyingIface = this.getDefaultNetwork().linkProperties.getInterfaceName();
            }
        } else if (underlyingNetworks.length > 0 && (linkProperties = this.getLinkProperties(underlyingNetworks[0])) != null) {
            info.primaryUnderlyingIface = linkProperties.getInterfaceName();
        }
        return info.primaryUnderlyingIface == null ? null : info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VpnConfig getVpnConfig(int userId) {
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn != null) {
                return vpn.getVpnConfig();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllVpnsCapabilities() {
        Network defaultNetwork = this.getNetwork(this.getDefaultNetwork());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mVpns.size(); ++i) {
                Vpn vpn = this.mVpns.valueAt(i);
                NetworkCapabilities nc = vpn.updateCapabilities(defaultNetwork);
                this.updateVpnCapabilities(vpn, nc);
            }
        }
    }

    private void updateVpnCapabilities(Vpn vpn, NetworkCapabilities nc) {
        this.ensureRunningOnConnectivityServiceThread();
        NetworkAgentInfo vpnNai = this.getNetworkAgentInfoForNetId(vpn.getNetId());
        if (vpnNai == null || nc == null) {
            return;
        }
        this.updateCapabilities(vpnNai.getCurrentScore(), vpnNai, nc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLockdownVpn() {
        if (Binder.getCallingUid() != 1000) {
            Slog.w(TAG, "Lockdown VPN only available to AID_SYSTEM");
            return false;
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.mLockdownEnabled = LockdownVpnTracker.isEnabled();
            if (this.mLockdownEnabled) {
                byte[] profileTag = this.mKeyStore.get("LOCKDOWN_VPN");
                if (profileTag == null) {
                    Slog.e(TAG, "Lockdown VPN configured but cannot be read from keystore");
                    return false;
                }
                String profileName = new String(profileTag);
                VpnProfile profile = VpnProfile.decode(profileName, this.mKeyStore.get("VPN_" + profileName));
                if (profile == null) {
                    Slog.e(TAG, "Lockdown VPN configured invalid profile " + profileName);
                    this.setLockdownTracker(null);
                    return true;
                }
                int user = UserHandle.getUserId(Binder.getCallingUid());
                Vpn vpn = this.mVpns.get(user);
                if (vpn == null) {
                    Slog.w(TAG, "VPN for user " + user + " not ready yet. Skipping lockdown");
                    return false;
                }
                this.setLockdownTracker(new LockdownVpnTracker(this.mContext, this.mNMS, this, vpn, profile));
            } else {
                this.setLockdownTracker(null);
            }
        }
        return true;
    }

    @GuardedBy(value={"mVpns"})
    private void setLockdownTracker(LockdownVpnTracker tracker) {
        LockdownVpnTracker existing = this.mLockdownTracker;
        this.mLockdownTracker = null;
        if (existing != null) {
            existing.shutdown();
        }
        if (tracker != null) {
            this.mLockdownTracker = tracker;
            this.mLockdownTracker.init();
        }
    }

    @GuardedBy(value={"mVpns"})
    private void throwIfLockdownEnabled() {
        if (this.mLockdownEnabled) {
            throw new IllegalStateException("Unavailable in lockdown mode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startAlwaysOnVpn(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                Slog.wtf(TAG, "User " + userId + " has no Vpn configuration");
                return false;
            }
            return vpn.startAlwaysOnVpn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlwaysOnVpnPackageSupported(int userId, String packageName) {
        this.enforceSettingsPermission();
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                Slog.w(TAG, "User " + userId + " has no Vpn configuration");
                return false;
            }
            return vpn.isAlwaysOnPackageSupported(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAlwaysOnVpnPackage(int userId, String packageName, boolean lockdown, List<String> lockdownWhitelist) {
        this.enforceControlAlwaysOnVpnPermission();
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (LockdownVpnTracker.isEnabled()) {
                return false;
            }
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                Slog.w(TAG, "User " + userId + " has no Vpn configuration");
                return false;
            }
            if (!vpn.setAlwaysOnPackage(packageName, lockdown, lockdownWhitelist)) {
                return false;
            }
            if (!this.startAlwaysOnVpn(userId)) {
                vpn.setAlwaysOnPackage(null, false, null);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlwaysOnVpnPackage(int userId) {
        this.enforceControlAlwaysOnVpnPermission();
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                Slog.w(TAG, "User " + userId + " has no Vpn configuration");
                return null;
            }
            return vpn.getAlwaysOnPackage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isVpnLockdownEnabled(int userId) {
        this.enforceControlAlwaysOnVpnPermission();
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                Slog.w(TAG, "User " + userId + " has no Vpn configuration");
                return false;
            }
            return vpn.getLockdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getVpnLockdownWhitelist(int userId) {
        this.enforceControlAlwaysOnVpnPermission();
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                Slog.w(TAG, "User " + userId + " has no Vpn configuration");
                return null;
            }
            return vpn.getLockdownWhitelist();
        }
    }

    @Override
    public int checkMobileProvisioning(int suggestedTimeOutMs) {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProvisioningUrlBaseFromFile() {
        block28: {
            String element;
            FileReader fileReader = null;
            XmlPullParser parser = null;
            Configuration config = this.mContext.getResources().getConfiguration();
            try {
                fileReader = new FileReader(this.mProvisioningUrlFile);
                parser = Xml.newPullParser();
                parser.setInput(fileReader);
                XmlUtils.beginDocument(parser, TAG_PROVISIONING_URLS);
                while (true) {
                    XmlUtils.nextElement(parser);
                    element = parser.getName();
                    if (element == null) break;
                    if (!element.equals(TAG_PROVISIONING_URL)) continue;
                    String mcc = parser.getAttributeValue(null, ATTR_MCC);
                    try {
                        String mnc;
                        if (mcc != null && Integer.parseInt(mcc) == config.mcc && (mnc = parser.getAttributeValue(null, ATTR_MNC)) != null && Integer.parseInt(mnc) == config.mnc) {
                            parser.next();
                            if (parser.getEventType() == 4) {
                                String string2 = parser.getText();
                                return string2;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        ConnectivityService.loge("NumberFormatException in getProvisioningUrlBaseFromFile: " + e);
                    }
                }
                element = null;
            }
            catch (FileNotFoundException e) {
                ConnectivityService.loge("Carrier Provisioning Urls file not found");
                break block28;
            }
            catch (XmlPullParserException e) {
                ConnectivityService.loge("Xml parser exception reading Carrier Provisioning Urls file: " + e);
                break block28;
            }
            catch (IOException e) {
                ConnectivityService.loge("I/O exception reading Carrier Provisioning Urls file: " + e);
                break block28;
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {}
                }
            }
            return element;
        }
        return null;
    }

    @Override
    public String getMobileProvisioningUrl() {
        this.enforceConnectivityInternalPermission();
        String url = this.getProvisioningUrlBaseFromFile();
        if (TextUtils.isEmpty(url)) {
            url = this.mContext.getResources().getString(0x1040440);
            ConnectivityService.log("getMobileProvisioningUrl: mobile_provisioining_url from resource =" + url);
        } else {
            ConnectivityService.log("getMobileProvisioningUrl: mobile_provisioning_url from File =" + url);
        }
        if (!TextUtils.isEmpty(url)) {
            String phoneNumber = this.mTelephonyManager.getLine1Number();
            if (TextUtils.isEmpty(phoneNumber)) {
                phoneNumber = "0000000000";
            }
            url = String.format(url, this.mTelephonyManager.getSimSerialNumber(), this.mTelephonyManager.getDeviceId(), phoneNumber);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProvisioningNotificationVisible(boolean visible, int networkType, String action) {
        this.enforceConnectivityInternalPermission();
        if (!ConnectivityManager.isNetworkTypeValid(networkType)) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            int id2 = 64512 + (networkType - -1);
            this.mNotifier.setProvNotificationVisible(visible, id2, action);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAirplaneMode(boolean enable) {
        this.enforceNetworkStackSettingsOrSetup();
        long ident = Binder.clearCallingIdentity();
        try {
            ContentResolver cr = this.mContext.getContentResolver();
            Settings.Global.putInt(cr, "airplane_mode_on", ConnectivityService.encodeBool(enable));
            Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
            intent.putExtra("state", enable);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStart(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn userVpn = this.mVpns.get(userId);
            if (userVpn != null) {
                ConnectivityService.loge("Starting user already has a VPN");
                return;
            }
            userVpn = new Vpn(this.mHandler.getLooper(), this.mContext, this.mNMS, userId);
            this.mVpns.put(userId, userVpn);
            if (this.mUserManager.getUserInfo(userId).isPrimary() && LockdownVpnTracker.isEnabled()) {
                this.updateLockdownVpn();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStop(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn userVpn = this.mVpns.get(userId);
            if (userVpn == null) {
                ConnectivityService.loge("Stopped user has no VPN");
                return;
            }
            userVpn.onUserStopped();
            this.mVpns.delete(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserAdded(int userId) {
        this.mPermissionMonitor.onUserAdded(userId);
        Network defaultNetwork = this.getNetwork(this.getDefaultNetwork());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            int vpnsSize = this.mVpns.size();
            for (int i = 0; i < vpnsSize; ++i) {
                Vpn vpn = this.mVpns.valueAt(i);
                vpn.onUserAdded(userId);
                NetworkCapabilities nc = vpn.updateCapabilities(defaultNetwork);
                this.updateVpnCapabilities(vpn, nc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserRemoved(int userId) {
        this.mPermissionMonitor.onUserRemoved(userId);
        Network defaultNetwork = this.getNetwork(this.getDefaultNetwork());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            int vpnsSize = this.mVpns.size();
            for (int i = 0; i < vpnsSize; ++i) {
                Vpn vpn = this.mVpns.valueAt(i);
                vpn.onUserRemoved(userId);
                NetworkCapabilities nc = vpn.updateCapabilities(defaultNetwork);
                this.updateVpnCapabilities(vpn, nc);
            }
        }
    }

    private void onPackageAdded(String packageName, int uid) {
        if (TextUtils.isEmpty(packageName) || uid < 0) {
            Slog.wtf(TAG, "Invalid package in onPackageAdded: " + packageName + " | " + uid);
            return;
        }
        this.mPermissionMonitor.onPackageAdded(packageName, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPackageReplaced(String packageName, int uid) {
        if (TextUtils.isEmpty(packageName) || uid < 0) {
            Slog.wtf(TAG, "Invalid package in onPackageReplaced: " + packageName + " | " + uid);
            return;
        }
        int userId = UserHandle.getUserId(uid);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                return;
            }
            if (TextUtils.equals(vpn.getAlwaysOnPackage(), packageName)) {
                Slog.d(TAG, "Restarting always-on VPN package " + packageName + " for user " + userId);
                vpn.startAlwaysOnVpn();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPackageRemoved(String packageName, int uid, boolean isReplacing) {
        if (TextUtils.isEmpty(packageName) || uid < 0) {
            Slog.wtf(TAG, "Invalid package in onPackageRemoved: " + packageName + " | " + uid);
            return;
        }
        this.mPermissionMonitor.onPackageRemoved(uid);
        int userId = UserHandle.getUserId(uid);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn == null) {
                return;
            }
            if (TextUtils.equals(vpn.getAlwaysOnPackage(), packageName) && !isReplacing) {
                Slog.d(TAG, "Removing always-on VPN package " + packageName + " for user " + userId);
                vpn.setAlwaysOnPackage(null, false, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserUnlocked(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (this.mUserManager.getUserInfo(userId).isPrimary() && LockdownVpnTracker.isEnabled()) {
                this.updateLockdownVpn();
            } else {
                this.startAlwaysOnVpn(userId);
            }
        }
    }

    private void ensureNetworkRequestHasType(NetworkRequest request) {
        if (request.type == NetworkRequest.Type.NONE) {
            throw new IllegalArgumentException("All NetworkRequests in ConnectivityService must have a type");
        }
    }

    private void ensureRequestableCapabilities(NetworkCapabilities networkCapabilities) {
        String badCapability = networkCapabilities.describeFirstNonRequestableCapability();
        if (badCapability != null) {
            throw new IllegalArgumentException("Cannot request network with " + badCapability);
        }
    }

    private void ensureSufficientPermissionsForRequest(NetworkCapabilities nc, int callerPid, int callerUid) {
        if (null != nc.getSSID() && !this.checkSettingsPermission(callerPid, callerUid)) {
            throw new SecurityException("Insufficient permissions to request a specific SSID");
        }
        if (nc.hasSignalStrength() && !this.checkNetworkSignalStrengthWakeupPermission(callerPid, callerUid)) {
            throw new SecurityException("Insufficient permissions to request a specific signal strength");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Integer> getSignalStrengthThresholds(NetworkAgentInfo nai) {
        TreeSet<Integer> thresholds = new TreeSet<Integer>();
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
                if (!nri.request.networkCapabilities.hasSignalStrength() || !nai.satisfiesImmutableCapabilitiesOf(nri.request)) continue;
                thresholds.add(nri.request.networkCapabilities.getSignalStrength());
            }
        }
        return new ArrayList<Integer>(thresholds);
    }

    private void updateSignalStrengthThresholds(NetworkAgentInfo nai, String reason, NetworkRequest request) {
        ArrayList<Integer> thresholdsArray = this.getSignalStrengthThresholds(nai);
        Bundle thresholds = new Bundle();
        thresholds.putIntegerArrayList("thresholds", thresholdsArray);
        if (VDBG || !"CONNECT".equals(reason)) {
            String detail = request != null && request.networkCapabilities.hasSignalStrength() ? reason + " " + request.networkCapabilities.getSignalStrength() : reason;
            ConnectivityService.log(String.format("updateSignalStrengthThresholds: %s, sending %s to %s", detail, Arrays.toString(thresholdsArray.toArray()), nai.name()));
        }
        nai.asyncChannel.sendMessage(528398, 0, 0, thresholds);
    }

    private void ensureValidNetworkSpecifier(NetworkCapabilities nc) {
        if (nc == null) {
            return;
        }
        NetworkSpecifier ns = nc.getNetworkSpecifier();
        if (ns == null) {
            return;
        }
        MatchAllNetworkSpecifier.checkNotMatchAllNetworkSpecifier(ns);
        ns.assertValidFromUid(Binder.getCallingUid());
    }

    @Override
    public NetworkRequest requestNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, int timeoutMs, IBinder binder, int legacyType) {
        NetworkRequest.Type type;
        NetworkRequest.Type type2 = type = networkCapabilities == null ? NetworkRequest.Type.TRACK_DEFAULT : NetworkRequest.Type.REQUEST;
        if (type == NetworkRequest.Type.TRACK_DEFAULT) {
            networkCapabilities = ConnectivityService.createDefaultNetworkCapabilitiesForUid(Binder.getCallingUid());
            this.enforceAccessPermission();
        } else {
            networkCapabilities = new NetworkCapabilities(networkCapabilities);
            this.enforceNetworkRequestPermissions(networkCapabilities);
            this.enforceMeteredApnPolicy(networkCapabilities);
        }
        this.ensureRequestableCapabilities(networkCapabilities);
        this.ensureSufficientPermissionsForRequest(networkCapabilities, Binder.getCallingPid(), Binder.getCallingUid());
        this.restrictRequestUidsForCaller(networkCapabilities);
        if (timeoutMs < 0) {
            throw new IllegalArgumentException("Bad timeout specified");
        }
        this.ensureValidNetworkSpecifier(networkCapabilities);
        NetworkRequest networkRequest = new NetworkRequest(networkCapabilities, legacyType, this.nextNetworkRequestId(), type);
        NetworkRequestInfo nri = new NetworkRequestInfo(messenger, networkRequest, binder);
        ConnectivityService.log("requestNetwork for " + nri);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(19, nri));
        if (timeoutMs > 0) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(20, nri), timeoutMs);
        }
        return networkRequest;
    }

    private void enforceNetworkRequestPermissions(NetworkCapabilities networkCapabilities) {
        if (!networkCapabilities.hasCapability(13)) {
            this.enforceConnectivityRestrictedNetworksPermission();
        } else {
            this.enforceChangePermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestBandwidthUpdate(Network network) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = null;
        if (network == null) {
            return false;
        }
        SparseArray<Comparable<NetworkAgentInfo>> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            nai = this.mNetworkForNetId.get(network.netId);
        }
        if (nai != null) {
            nai.asyncChannel.sendMessage(528394);
            sparseArray = this.mBandwidthRequests;
            synchronized (sparseArray) {
                int uid = Binder.getCallingUid();
                Integer uidReqs = this.mBandwidthRequests.get(uid);
                if (uidReqs == null) {
                    uidReqs = new Integer(0);
                }
                uidReqs = uidReqs + 1;
                this.mBandwidthRequests.put(uid, uidReqs);
            }
            return true;
        }
        return false;
    }

    private boolean isSystem(int uid) {
        return uid < 10000;
    }

    private void enforceMeteredApnPolicy(NetworkCapabilities networkCapabilities) {
        int uid = Binder.getCallingUid();
        if (this.isSystem(uid)) {
            return;
        }
        if (networkCapabilities.hasCapability(11)) {
            return;
        }
        if (this.mPolicyManagerInternal.isUidRestrictedOnMeteredNetworks(uid)) {
            networkCapabilities.addCapability(11);
        }
    }

    @Override
    public NetworkRequest pendingRequestForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation) {
        Preconditions.checkNotNull(operation, "PendingIntent cannot be null.");
        networkCapabilities = new NetworkCapabilities(networkCapabilities);
        this.enforceNetworkRequestPermissions(networkCapabilities);
        this.enforceMeteredApnPolicy(networkCapabilities);
        this.ensureRequestableCapabilities(networkCapabilities);
        this.ensureSufficientPermissionsForRequest(networkCapabilities, Binder.getCallingPid(), Binder.getCallingUid());
        this.ensureValidNetworkSpecifier(networkCapabilities);
        this.restrictRequestUidsForCaller(networkCapabilities);
        NetworkRequest networkRequest = new NetworkRequest(networkCapabilities, -1, this.nextNetworkRequestId(), NetworkRequest.Type.REQUEST);
        NetworkRequestInfo nri = new NetworkRequestInfo(networkRequest, operation);
        ConnectivityService.log("pendingRequest for " + nri);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(26, nri));
        return networkRequest;
    }

    private void releasePendingNetworkRequestWithDelay(PendingIntent operation) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(27, ConnectivityService.getCallingUid(), 0, operation), this.mReleasePendingIntentDelayMs);
    }

    @Override
    public void releasePendingNetworkRequest(PendingIntent operation) {
        Preconditions.checkNotNull(operation, "PendingIntent cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(27, ConnectivityService.getCallingUid(), 0, operation));
    }

    private boolean hasWifiNetworkListenPermission(NetworkCapabilities nc) {
        if (nc == null) {
            return false;
        }
        int[] transportTypes = nc.getTransportTypes();
        if (transportTypes.length != 1 || transportTypes[0] != 1) {
            return false;
        }
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE", "ConnectivityService");
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    @Override
    public NetworkRequest listenForNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, IBinder binder) {
        if (!this.hasWifiNetworkListenPermission(networkCapabilities)) {
            this.enforceAccessPermission();
        }
        NetworkCapabilities nc = new NetworkCapabilities(networkCapabilities);
        this.ensureSufficientPermissionsForRequest(networkCapabilities, Binder.getCallingPid(), Binder.getCallingUid());
        this.restrictRequestUidsForCaller(nc);
        this.restrictBackgroundRequestForCaller(nc);
        this.ensureValidNetworkSpecifier(nc);
        NetworkRequest networkRequest = new NetworkRequest(nc, -1, this.nextNetworkRequestId(), NetworkRequest.Type.LISTEN);
        NetworkRequestInfo nri = new NetworkRequestInfo(messenger, networkRequest, binder);
        if (VDBG) {
            ConnectivityService.log("listenForNetwork for " + nri);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(21, nri));
        return networkRequest;
    }

    @Override
    public void pendingListenForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation) {
        Preconditions.checkNotNull(operation, "PendingIntent cannot be null.");
        if (!this.hasWifiNetworkListenPermission(networkCapabilities)) {
            this.enforceAccessPermission();
        }
        this.ensureValidNetworkSpecifier(networkCapabilities);
        this.ensureSufficientPermissionsForRequest(networkCapabilities, Binder.getCallingPid(), Binder.getCallingUid());
        NetworkCapabilities nc = new NetworkCapabilities(networkCapabilities);
        this.restrictRequestUidsForCaller(nc);
        NetworkRequest networkRequest = new NetworkRequest(nc, -1, this.nextNetworkRequestId(), NetworkRequest.Type.LISTEN);
        NetworkRequestInfo nri = new NetworkRequestInfo(networkRequest, operation);
        if (VDBG) {
            ConnectivityService.log("pendingListenForNetwork for " + nri);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(21, nri));
    }

    @Override
    public void releaseNetworkRequest(NetworkRequest networkRequest) {
        this.ensureNetworkRequestHasType(networkRequest);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(22, ConnectivityService.getCallingUid(), 0, networkRequest));
    }

    @Override
    public int registerNetworkFactory(Messenger messenger, String name) {
        this.enforceConnectivityInternalPermission();
        NetworkFactoryInfo nfi = new NetworkFactoryInfo(name, messenger, new AsyncChannel(), NetworkFactory.SerialNumber.nextSerialNumber());
        this.mHandler.sendMessage(this.mHandler.obtainMessage(17, nfi));
        return nfi.factorySerialNumber;
    }

    private void handleRegisterNetworkFactory(NetworkFactoryInfo nfi) {
        ConnectivityService.log("Got NetworkFactory Messenger for " + nfi.name);
        this.mNetworkFactoryInfos.put(nfi.messenger, nfi);
        nfi.asyncChannel.connect(this.mContext, (Handler)this.mTrackerHandler, nfi.messenger);
    }

    @Override
    public void unregisterNetworkFactory(Messenger messenger) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(23, messenger));
    }

    private void handleUnregisterNetworkFactory(Messenger messenger) {
        NetworkFactoryInfo nfi = this.mNetworkFactoryInfos.remove(messenger);
        if (nfi == null) {
            ConnectivityService.loge("Failed to find Messenger in unregisterNetworkFactory");
            return;
        }
        ConnectivityService.log("unregisterNetworkFactory for " + nfi.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkAgentInfo getNetworkForRequest(int requestId) {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForRequestId;
        synchronized (sparseArray) {
            return this.mNetworkForRequestId.get(requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearNetworkForRequest(int requestId) {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForRequestId;
        synchronized (sparseArray) {
            this.mNetworkForRequestId.remove(requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNetworkForRequest(int requestId, NetworkAgentInfo nai) {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForRequestId;
        synchronized (sparseArray) {
            this.mNetworkForRequestId.put(requestId, nai);
        }
    }

    private NetworkAgentInfo getDefaultNetwork() {
        return this.getNetworkForRequest(this.mDefaultRequest.requestId);
    }

    private Network getNetwork(NetworkAgentInfo nai) {
        return nai != null ? nai.network : null;
    }

    private void ensureRunningOnConnectivityServiceThread() {
        if (this.mHandler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Not running on ConnectivityService thread: " + Thread.currentThread().getName());
        }
    }

    @VisibleForTesting
    protected boolean isDefaultNetwork(NetworkAgentInfo nai) {
        return nai == this.getDefaultNetwork();
    }

    private boolean isDefaultRequest(NetworkRequestInfo nri) {
        return nri.request.requestId == this.mDefaultRequest.requestId;
    }

    public int registerNetworkAgent(Messenger messenger, NetworkInfo networkInfo, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int currentScore, NetworkMisc networkMisc) {
        return this.registerNetworkAgent(messenger, networkInfo, linkProperties, networkCapabilities, currentScore, networkMisc, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerNetworkAgent(Messenger messenger, NetworkInfo networkInfo, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int currentScore, NetworkMisc networkMisc, int factorySerialNumber) {
        this.enforceConnectivityInternalPermission();
        LinkProperties lp = new LinkProperties(linkProperties);
        lp.ensureDirectlyConnectedRoutes();
        NetworkCapabilities nc = new NetworkCapabilities(networkCapabilities);
        NetworkAgentInfo nai = new NetworkAgentInfo(messenger, new AsyncChannel(), new Network(this.reserveNetId()), new NetworkInfo(networkInfo), lp, nc, currentScore, this.mContext, this.mTrackerHandler, new NetworkMisc(networkMisc), this, this.mNetd, this.mDnsResolver, this.mNMS, factorySerialNumber);
        nai.setNetworkCapabilities(this.mixInCapabilities(nai, nc));
        String extraInfo = networkInfo.getExtraInfo();
        String name = TextUtils.isEmpty(extraInfo) ? nai.networkCapabilities.getSSID() : extraInfo;
        ConnectivityService.log("registerNetworkAgent " + nai);
        long token = Binder.clearCallingIdentity();
        try {
            this.getNetworkStack().makeNetworkMonitor(nai.network, name, new NetworkMonitorCallbacks(nai));
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return nai.network.netId;
    }

    @VisibleForTesting
    protected NetworkStackClient getNetworkStack() {
        return NetworkStackClient.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegisterNetworkAgent(NetworkAgentInfo nai, INetworkMonitor networkMonitor) {
        nai.onNetworkMonitorCreated(networkMonitor);
        if (VDBG) {
            ConnectivityService.log("Got NetworkAgent Messenger");
        }
        this.mNetworkAgentInfos.put(nai.messenger, nai);
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            this.mNetworkForNetId.put(nai.network.netId, nai);
        }
        try {
            networkMonitor.start();
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
        nai.asyncChannel.connect(this.mContext, (Handler)this.mTrackerHandler, nai.messenger);
        NetworkInfo networkInfo = nai.networkInfo;
        nai.networkInfo = null;
        this.updateNetworkInfo(nai, networkInfo);
        this.updateUids(nai, null, nai.networkCapabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkProperties(NetworkAgentInfo networkAgent, LinkProperties newLp, LinkProperties oldLp) {
        int netId = networkAgent.network.netId;
        networkAgent.clatd.fixupLinkProperties(oldLp, newLp);
        this.updateInterfaces(newLp, oldLp, netId, networkAgent.networkCapabilities);
        this.updateVpnFiltering(newLp, oldLp, networkAgent);
        this.updateMtu(newLp, oldLp);
        if (this.isDefaultNetwork(networkAgent)) {
            this.updateTcpBufferSizes(newLp.getTcpBufferSizes());
        }
        this.updateRoutes(newLp, oldLp, netId);
        this.updateDnses(newLp, oldLp, netId);
        this.mDnsManager.updatePrivateDnsStatus(netId, newLp);
        if (this.isDefaultNetwork(networkAgent)) {
            this.handleApplyDefaultProxy(newLp.getHttpProxy());
        } else {
            this.updateProxy(newLp, oldLp);
        }
        if (!Objects.equals(newLp, oldLp)) {
            NetworkAgentInfo networkAgentInfo = networkAgent;
            synchronized (networkAgentInfo) {
                networkAgent.linkProperties = newLp;
            }
            networkAgent.clatd.update();
            this.notifyIfacesChangedForNetworkStats();
            networkAgent.networkMonitor().notifyLinkPropertiesChanged(newLp);
            if (networkAgent.everConnected) {
                this.notifyNetworkCallbacks(networkAgent, 524295);
            }
        }
        this.mKeepaliveTracker.handleCheckKeepalivesStillValid(networkAgent);
    }

    private void wakeupModifyInterface(String iface, NetworkCapabilities caps, boolean add) {
        if (!caps.hasTransport(1)) {
            return;
        }
        int mark = this.mContext.getResources().getInteger(17694855);
        int mask = this.mContext.getResources().getInteger(17694856);
        if (mark == 0 || mask == 0) {
            return;
        }
        String prefix = "iface:" + iface;
        try {
            if (add) {
                this.mNetd.wakeupAddInterface(iface, prefix, mark, mask);
            } else {
                this.mNetd.wakeupDelInterface(iface, prefix, mark, mask);
            }
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception modifying wakeup packet monitoring: " + e);
        }
    }

    private void updateInterfaces(LinkProperties newLp, LinkProperties oldLp, int netId, NetworkCapabilities caps) {
        LinkProperties.CompareResult<String> interfaceDiff = new LinkProperties.CompareResult<String>(oldLp != null ? oldLp.getAllInterfaceNames() : null, newLp != null ? newLp.getAllInterfaceNames() : null);
        for (String iface : interfaceDiff.added) {
            try {
                ConnectivityService.log("Adding iface " + iface + " to network " + netId);
                this.mNMS.addInterfaceToNetwork(iface, netId);
                this.wakeupModifyInterface(iface, caps, true);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception adding interface: " + e);
            }
        }
        for (String iface : interfaceDiff.removed) {
            try {
                ConnectivityService.log("Removing iface " + iface + " from network " + netId);
                this.wakeupModifyInterface(iface, caps, false);
                this.mNMS.removeInterfaceFromNetwork(iface, netId);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception removing interface: " + e);
            }
        }
    }

    private boolean updateRoutes(LinkProperties newLp, LinkProperties oldLp, int netId) {
        LinkProperties.CompareResult<RouteInfo> routeDiff = new LinkProperties.CompareResult<RouteInfo>(oldLp != null ? oldLp.getAllRoutes() : null, newLp != null ? newLp.getAllRoutes() : null);
        for (RouteInfo route : routeDiff.added) {
            if (route.hasGateway()) continue;
            if (VDBG || DDBG) {
                ConnectivityService.log("Adding Route [" + route + "] to network " + netId);
            }
            try {
                this.mNMS.addRoute(netId, route);
            }
            catch (Exception e) {
                if (!(route.getDestination().getAddress() instanceof Inet4Address) && !VDBG) continue;
                ConnectivityService.loge("Exception in addRoute for non-gateway: " + e);
            }
        }
        for (RouteInfo route : routeDiff.added) {
            if (!route.hasGateway()) continue;
            if (VDBG || DDBG) {
                ConnectivityService.log("Adding Route [" + route + "] to network " + netId);
            }
            try {
                this.mNMS.addRoute(netId, route);
            }
            catch (Exception e) {
                if (!(route.getGateway() instanceof Inet4Address) && !VDBG) continue;
                ConnectivityService.loge("Exception in addRoute for gateway: " + e);
            }
        }
        for (RouteInfo route : routeDiff.removed) {
            if (VDBG || DDBG) {
                ConnectivityService.log("Removing Route [" + route + "] from network " + netId);
            }
            try {
                this.mNMS.removeRoute(netId, route);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in removeRoute: " + e);
            }
        }
        return !routeDiff.added.isEmpty() || !routeDiff.removed.isEmpty();
    }

    private void updateDnses(LinkProperties newLp, LinkProperties oldLp, int netId) {
        if (oldLp != null && newLp.isIdenticalDnses(oldLp)) {
            return;
        }
        NetworkAgentInfo defaultNai = this.getDefaultNetwork();
        boolean isDefaultNetwork = defaultNai != null && defaultNai.network.netId == netId;
        List<InetAddress> dnses = newLp.getDnsServers();
        ConnectivityService.log("Setting DNS servers for network " + netId + " to " + dnses);
        try {
            this.mDnsManager.setDnsConfigurationForNetwork(netId, newLp, isDefaultNetwork);
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception in setDnsConfigurationForNetwork: " + e);
        }
    }

    private void updateVpnFiltering(LinkProperties newLp, LinkProperties oldLp, NetworkAgentInfo nai) {
        String oldIface = oldLp != null ? oldLp.getInterfaceName() : null;
        String newIface = newLp != null ? newLp.getInterfaceName() : null;
        boolean wasFiltering = this.requiresVpnIsolation(nai, nai.networkCapabilities, oldLp);
        boolean needsFiltering = this.requiresVpnIsolation(nai, nai.networkCapabilities, newLp);
        if (!wasFiltering && !needsFiltering) {
            return;
        }
        if (Objects.equals(oldIface, newIface) && wasFiltering == needsFiltering) {
            return;
        }
        Set<UidRange> ranges = nai.networkCapabilities.getUids();
        int vpnAppUid = nai.networkCapabilities.getEstablishingVpnAppUid();
        if (wasFiltering) {
            this.mPermissionMonitor.onVpnUidRangesRemoved(oldIface, ranges, vpnAppUid);
        }
        if (needsFiltering) {
            this.mPermissionMonitor.onVpnUidRangesAdded(newIface, ranges, vpnAppUid);
        }
    }

    private int getNetworkPermission(NetworkCapabilities nc) {
        if (!nc.hasCapability(13)) {
            return 2;
        }
        if (!nc.hasCapability(19)) {
            return 1;
        }
        return 0;
    }

    private NetworkCapabilities mixInCapabilities(NetworkAgentInfo nai, NetworkCapabilities nc) {
        String diff;
        if (nai.everConnected && !nai.isVPN() && !nai.networkCapabilities.satisfiedByImmutableNetworkCapabilities(nc) && !TextUtils.isEmpty(diff = nai.networkCapabilities.describeImmutableDifferences(nc))) {
            Slog.wtf(TAG, "BUG: " + nai + " lost immutable capabilities:" + diff);
        }
        NetworkCapabilities newNc = new NetworkCapabilities(nc);
        if (nai.lastValidated) {
            newNc.addCapability(16);
        } else {
            newNc.removeCapability(16);
        }
        if (nai.lastCaptivePortalDetected) {
            newNc.addCapability(17);
        } else {
            newNc.removeCapability(17);
        }
        if (nai.isBackgroundNetwork()) {
            newNc.removeCapability(19);
        } else {
            newNc.addCapability(19);
        }
        if (nai.isSuspended()) {
            newNc.removeCapability(21);
        } else {
            newNc.addCapability(21);
        }
        if (nai.partialConnectivity) {
            newNc.addCapability(24);
        } else {
            newNc.removeCapability(24);
        }
        return newNc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCapabilities(int oldScore, NetworkAgentInfo nai, NetworkCapabilities nc) {
        NetworkCapabilities prevNc;
        int newPermission;
        NetworkCapabilities newNc = this.mixInCapabilities(nai, nc);
        if (Objects.equals(nai.networkCapabilities, newNc)) {
            return;
        }
        int oldPermission = this.getNetworkPermission(nai.networkCapabilities);
        if (oldPermission != (newPermission = this.getNetworkPermission(newNc)) && nai.created && !nai.isVPN()) {
            try {
                this.mNMS.setNetworkPermission(nai.network.netId, newPermission);
            }
            catch (RemoteException e) {
                ConnectivityService.loge("Exception in setNetworkPermission: " + e);
            }
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            prevNc = nai.networkCapabilities;
            nai.setNetworkCapabilities(newNc);
        }
        this.updateUids(nai, prevNc, newNc);
        if (nai.getCurrentScore() == oldScore && newNc.equalRequestableCapabilities(prevNc)) {
            this.processListenRequests(nai, true);
        } else {
            this.rematchAllNetworksAndRequests(nai, oldScore);
            this.notifyNetworkCallbacks(nai, 524294);
        }
        if (prevNc != null) {
            boolean roamingChanged;
            boolean newMetered;
            boolean meteredChanged;
            boolean oldMetered = prevNc.isMetered();
            boolean bl = meteredChanged = oldMetered != (newMetered = newNc.isMetered());
            if (meteredChanged) {
                this.maybeNotifyNetworkBlocked(nai, oldMetered, newMetered, this.mRestrictBackground, this.mRestrictBackground);
            }
            boolean bl2 = roamingChanged = prevNc.hasCapability(18) != newNc.hasCapability(18);
            if (meteredChanged || roamingChanged) {
                this.notifyIfacesChangedForNetworkStats();
            }
        }
        if (!newNc.hasTransport(4)) {
            this.updateAllVpnsCapabilities();
        }
    }

    private boolean requiresVpnIsolation(NetworkAgentInfo nai, NetworkCapabilities nc, LinkProperties lp) {
        if (nc == null || lp == null) {
            return false;
        }
        return nai.isVPN() && !nai.networkMisc.allowBypass && nc.getEstablishingVpnAppUid() != 1000 && lp.getInterfaceName() != null && (lp.hasIPv4DefaultRoute() || lp.hasIPv6DefaultRoute());
    }

    private void updateUids(NetworkAgentInfo nai, NetworkCapabilities prevNc, NetworkCapabilities newNc) {
        Set<UidRange> newRanges;
        Set<UidRange> prevRanges = null == prevNc ? null : prevNc.getUids();
        Set<UidRange> set = newRanges = null == newNc ? null : newNc.getUids();
        if (null == prevRanges) {
            prevRanges = new ArraySet<UidRange>();
        }
        if (null == newRanges) {
            newRanges = new ArraySet<UidRange>();
        }
        ArraySet<UidRange> prevRangesCopy = new ArraySet<UidRange>(prevRanges);
        prevRanges.removeAll(newRanges);
        newRanges.removeAll(prevRangesCopy);
        try {
            if (!newRanges.isEmpty()) {
                UidRange[] addedRangesArray = new UidRange[newRanges.size()];
                newRanges.toArray(addedRangesArray);
                this.mNMS.addVpnUidRanges(nai.network.netId, addedRangesArray);
            }
            if (!prevRanges.isEmpty()) {
                UidRange[] removedRangesArray = new UidRange[prevRanges.size()];
                prevRanges.toArray(removedRangesArray);
                this.mNMS.removeVpnUidRanges(nai.network.netId, removedRangesArray);
            }
            boolean wasFiltering = this.requiresVpnIsolation(nai, prevNc, nai.linkProperties);
            boolean shouldFilter = this.requiresVpnIsolation(nai, newNc, nai.linkProperties);
            String iface = nai.linkProperties.getInterfaceName();
            if (wasFiltering && !prevRanges.isEmpty()) {
                this.mPermissionMonitor.onVpnUidRangesRemoved(iface, prevRanges, prevNc.getEstablishingVpnAppUid());
            }
            if (shouldFilter && !newRanges.isEmpty()) {
                this.mPermissionMonitor.onVpnUidRangesAdded(iface, newRanges, newNc.getEstablishingVpnAppUid());
            }
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception in updateUids: ", e);
        }
    }

    public void handleUpdateLinkProperties(NetworkAgentInfo nai, LinkProperties newLp) {
        this.ensureRunningOnConnectivityServiceThread();
        if (this.getNetworkAgentInfoForNetId(nai.network.netId) != nai) {
            return;
        }
        newLp.ensureDirectlyConnectedRoutes();
        if (VDBG || DDBG) {
            ConnectivityService.log("Update of LinkProperties for " + nai.name() + "; created=" + nai.created + "; everConnected=" + nai.everConnected);
        }
        this.updateLinkProperties(nai, newLp, new LinkProperties(nai.linkProperties));
    }

    private void sendUpdatedScoreToFactories(NetworkAgentInfo nai) {
        for (int i = 0; i < nai.numNetworkRequests(); ++i) {
            NetworkRequest nr = nai.requestAt(i);
            if (nr.isListen()) continue;
            this.sendUpdatedScoreToFactories(nr, nai);
        }
    }

    private void sendUpdatedScoreToFactories(NetworkRequest networkRequest, NetworkAgentInfo nai) {
        int score = 0;
        int serial = 0;
        if (nai != null) {
            score = nai.getCurrentScore();
            serial = nai.factorySerialNumber;
        }
        if (VDBG || DDBG) {
            ConnectivityService.log("sending new Min Network Score(" + score + "): " + networkRequest.toString());
        }
        for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
            nfi.asyncChannel.sendMessage(536576, score, serial, networkRequest);
        }
    }

    private void sendPendingIntentForRequest(NetworkRequestInfo nri, NetworkAgentInfo networkAgent, int notificationType) {
        if (notificationType == 524290 && !nri.mPendingIntentSent) {
            Intent intent = new Intent();
            intent.putExtra("android.net.extra.NETWORK", networkAgent.network);
            intent.putExtra("android.net.extra.NETWORK_REQUEST", nri.request);
            nri.mPendingIntentSent = true;
            this.sendIntent(nri.mPendingIntent, intent);
        }
    }

    private void sendIntent(PendingIntent pendingIntent, Intent intent) {
        this.mPendingIntentWakeLock.acquire();
        try {
            ConnectivityService.log("Sending " + pendingIntent);
            pendingIntent.send(this.mContext, 0, intent, this, null);
        }
        catch (PendingIntent.CanceledException e) {
            ConnectivityService.log(pendingIntent + " was not sent, it had been canceled.");
            this.mPendingIntentWakeLock.release();
            this.releasePendingNetworkRequest(pendingIntent);
        }
    }

    @Override
    public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
        ConnectivityService.log("Finished sending " + pendingIntent);
        this.mPendingIntentWakeLock.release();
        this.releasePendingNetworkRequestWithDelay(pendingIntent);
    }

    private void callCallbackForRequest(NetworkRequestInfo nri, NetworkAgentInfo networkAgent, int notificationType, int arg1) {
        if (nri.messenger == null) {
            return;
        }
        Bundle bundle = new Bundle();
        ConnectivityService.putParcelable(bundle, new NetworkRequest(nri.request));
        Message msg = Message.obtain();
        if (notificationType != 524293) {
            ConnectivityService.putParcelable(bundle, networkAgent.network);
        }
        switch (notificationType) {
            case 524290: {
                ConnectivityService.putParcelable(bundle, this.networkCapabilitiesRestrictedForCallerPermissions(networkAgent.networkCapabilities, nri.mPid, nri.mUid));
                ConnectivityService.putParcelable(bundle, new LinkProperties(networkAgent.linkProperties));
                msg.arg1 = arg1;
                break;
            }
            case 524291: {
                msg.arg1 = arg1;
                break;
            }
            case 524294: {
                NetworkCapabilities nc = this.networkCapabilitiesRestrictedForCallerPermissions(networkAgent.networkCapabilities, nri.mPid, nri.mUid);
                ConnectivityService.putParcelable(bundle, nc);
                break;
            }
            case 524295: {
                ConnectivityService.putParcelable(bundle, new LinkProperties(networkAgent.linkProperties));
                break;
            }
            case 524299: {
                this.maybeLogBlockedStatusChanged(nri, networkAgent.network, arg1 != 0);
                msg.arg1 = arg1;
            }
        }
        msg.what = notificationType;
        msg.setData(bundle);
        try {
            if (VDBG) {
                String notification = ConnectivityManager.getCallbackName(notificationType);
                ConnectivityService.log("sending notification " + notification + " for " + nri.request);
            }
            nri.messenger.send(msg);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("RemoteException caught trying to send a callback msg for " + nri.request);
        }
    }

    private static <T extends Parcelable> void putParcelable(Bundle bundle, T t) {
        bundle.putParcelable(t.getClass().getSimpleName(), t);
    }

    private void teardownUnneededNetwork(NetworkAgentInfo nai) {
        if (nai.numRequestNetworkRequests() != 0) {
            for (int i = 0; i < nai.numNetworkRequests(); ++i) {
                NetworkRequest nr = nai.requestAt(i);
                if (nr.isListen()) continue;
                ConnectivityService.loge("Dead network still had at least " + nr);
                break;
            }
        }
        nai.asyncChannel.disconnect();
    }

    private void handleLingerComplete(NetworkAgentInfo oldNetwork) {
        if (oldNetwork == null) {
            ConnectivityService.loge("Unknown NetworkAgentInfo in handleLingerComplete");
            return;
        }
        ConnectivityService.log("handleLingerComplete for " + oldNetwork.name());
        oldNetwork.clearLingerState();
        if (this.unneeded(oldNetwork, UnneededFor.TEARDOWN)) {
            this.teardownUnneededNetwork(oldNetwork);
        } else {
            this.updateCapabilities(oldNetwork.getCurrentScore(), oldNetwork, oldNetwork.networkCapabilities);
        }
    }

    private void makeDefault(NetworkAgentInfo newNetwork) {
        ConnectivityService.log("Switching to new default network: " + newNetwork);
        try {
            this.mNMS.setDefaultNetId(newNetwork.network.netId);
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception setting default network :" + e);
        }
        this.notifyLockdownVpn(newNetwork);
        this.handleApplyDefaultProxy(newNetwork.linkProperties.getHttpProxy());
        this.updateTcpBufferSizes(newNetwork.linkProperties.getTcpBufferSizes());
        this.mDnsManager.setDefaultDnsSystemProperties(newNetwork.linkProperties.getDnsServers());
        this.notifyIfacesChangedForNetworkStats();
        this.updateAllVpnsCapabilities();
    }

    private void processListenRequests(NetworkAgentInfo nai, boolean capabilitiesChanged) {
        NetworkRequest nr;
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            nr = nri.request;
            if (!nr.isListen() || !nai.isSatisfyingRequest(nr.requestId) || nai.satisfies(nr)) continue;
            nai.removeRequest(nri.request.requestId);
            this.callCallbackForRequest(nri, nai, 524292, 0);
        }
        if (capabilitiesChanged) {
            this.notifyNetworkCallbacks(nai, 524294);
        }
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            nr = nri.request;
            if (!nr.isListen() || !nai.satisfies(nr) || nai.isSatisfyingRequest(nr.requestId)) continue;
            nai.addRequest(nr);
            this.notifyNetworkAvailable(nai, nri);
        }
    }

    private void rematchNetworkAndRequests(NetworkAgentInfo newNetwork, ReapUnvalidatedNetworks reapUnvalidatedNetworks, long now) {
        if (!newNetwork.everConnected) {
            return;
        }
        boolean keep = newNetwork.isVPN();
        boolean isNewDefault = false;
        NetworkAgentInfo oldDefaultNetwork = null;
        boolean wasBackgroundNetwork = newNetwork.isBackgroundNetwork();
        int score = newNetwork.getCurrentScore();
        if (VDBG || DDBG) {
            ConnectivityService.log("rematching " + newNetwork.name());
        }
        ArrayList<NetworkAgentInfo> affectedNetworks = new ArrayList<NetworkAgentInfo>();
        ArrayList<NetworkRequestInfo> addedRequests = new ArrayList<NetworkRequestInfo>();
        NetworkCapabilities nc = newNetwork.networkCapabilities;
        if (VDBG) {
            ConnectivityService.log(" network has: " + nc);
        }
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            if (nri.request.isListen()) continue;
            NetworkAgentInfo currentNetwork = this.getNetworkForRequest(nri.request.requestId);
            boolean satisfies = newNetwork.satisfies(nri.request);
            if (newNetwork == currentNetwork && satisfies) {
                if (VDBG) {
                    ConnectivityService.log("Network " + newNetwork.name() + " was already satisfying request " + nri.request.requestId + ". No change.");
                }
                keep = true;
                continue;
            }
            if (VDBG) {
                ConnectivityService.log("  checking if request is satisfied: " + nri.request);
            }
            if (satisfies) {
                if (VDBG || DDBG) {
                    ConnectivityService.log("currentScore = " + (currentNetwork != null ? currentNetwork.getCurrentScore() : 0) + ", newScore = " + score);
                }
                if (currentNetwork != null && currentNetwork.getCurrentScore() >= score) continue;
                if (VDBG) {
                    ConnectivityService.log("rematch for " + newNetwork.name());
                }
                if (currentNetwork != null) {
                    if (VDBG || DDBG) {
                        ConnectivityService.log("   accepting network in place of " + currentNetwork.name());
                    }
                    currentNetwork.removeRequest(nri.request.requestId);
                    currentNetwork.lingerRequest(nri.request, now, this.mLingerDelayMs);
                    affectedNetworks.add(currentNetwork);
                } else if (VDBG || DDBG) {
                    ConnectivityService.log("   accepting network in place of null");
                }
                newNetwork.unlingerRequest(nri.request);
                this.setNetworkForRequest(nri.request.requestId, newNetwork);
                if (!newNetwork.addRequest(nri.request)) {
                    Slog.wtf(TAG, "BUG: " + newNetwork.name() + " already has " + nri.request);
                }
                addedRequests.add(nri);
                keep = true;
                this.sendUpdatedScoreToFactories(nri.request, newNetwork);
                if (!this.isDefaultRequest(nri)) continue;
                isNewDefault = true;
                oldDefaultNetwork = currentNetwork;
                if (currentNetwork == null) continue;
                this.mLingerMonitor.noteLingerDefaultNetwork(currentNetwork, newNetwork);
                continue;
            }
            if (!newNetwork.isSatisfyingRequest(nri.request.requestId)) continue;
            ConnectivityService.log("Network " + newNetwork.name() + " stopped satisfying request " + nri.request.requestId);
            newNetwork.removeRequest(nri.request.requestId);
            if (currentNetwork == newNetwork) {
                this.clearNetworkForRequest(nri.request.requestId);
                this.sendUpdatedScoreToFactories(nri.request, null);
            } else {
                Slog.wtf(TAG, "BUG: Removing request " + nri.request.requestId + " from " + newNetwork.name() + " without updating mNetworkForRequestId or factories!");
            }
            this.callCallbackForRequest(nri, newNetwork, 524292, 0);
        }
        if (isNewDefault) {
            this.updateDataActivityTracking(newNetwork, oldDefaultNetwork);
            this.makeDefault(newNetwork);
            this.metricsLogger().defaultNetworkMetrics().logDefaultNetworkEvent(now, newNetwork, oldDefaultNetwork);
            this.scheduleReleaseNetworkTransitionWakelock();
        }
        if (!newNetwork.networkCapabilities.equalRequestableCapabilities(nc)) {
            Slog.wtf(TAG, String.format("BUG: %s changed requestable capabilities during rematch: %s -> %s", newNetwork.name(), nc, newNetwork.networkCapabilities));
        }
        if (newNetwork.getCurrentScore() != score) {
            Slog.wtf(TAG, String.format("BUG: %s changed score during rematch: %d -> %d", newNetwork.name(), score, newNetwork.getCurrentScore()));
        }
        if (wasBackgroundNetwork != newNetwork.isBackgroundNetwork()) {
            this.updateCapabilities(score, newNetwork, newNetwork.networkCapabilities);
        } else {
            this.processListenRequests(newNetwork, false);
        }
        for (NetworkRequestInfo nri : addedRequests) {
            this.notifyNetworkAvailable(newNetwork, nri);
        }
        for (NetworkAgentInfo nai : affectedNetworks) {
            this.updateLingerState(nai, now);
        }
        this.updateLingerState(newNetwork, now);
        if (isNewDefault) {
            if (oldDefaultNetwork != null) {
                this.mLegacyTypeTracker.remove(oldDefaultNetwork.networkInfo.getType(), oldDefaultNetwork, true);
            }
            this.mDefaultInetConditionPublished = newNetwork.lastValidated ? 100 : 0;
            this.mLegacyTypeTracker.add(newNetwork.networkInfo.getType(), newNetwork);
            this.notifyLockdownVpn(newNetwork);
        }
        if (keep) {
            try {
                IBatteryStats bs = BatteryStatsService.getService();
                int type = newNetwork.networkInfo.getType();
                String baseIface = newNetwork.linkProperties.getInterfaceName();
                bs.noteNetworkInterfaceType(baseIface, type);
                for (LinkProperties stacked : newNetwork.linkProperties.getStackedLinks()) {
                    String stackedIface = stacked.getInterfaceName();
                    bs.noteNetworkInterfaceType(stackedIface, type);
                }
            }
            catch (RemoteException bs) {
                // empty catch block
            }
            for (int i = 0; i < newNetwork.numNetworkRequests(); ++i) {
                NetworkRequest nr = newNetwork.requestAt(i);
                if (nr.legacyType == -1 || !nr.isRequest()) continue;
                this.mLegacyTypeTracker.add(nr.legacyType, newNetwork);
            }
            if (newNetwork.isVPN()) {
                this.mLegacyTypeTracker.add(17, newNetwork);
            }
        }
        if (reapUnvalidatedNetworks == ReapUnvalidatedNetworks.REAP) {
            for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                if (!this.unneeded(nai, UnneededFor.TEARDOWN)) continue;
                if (nai.getLingerExpiry() > 0L) {
                    this.updateLingerState(nai, now);
                    continue;
                }
                ConnectivityService.log("Reaping " + nai.name());
                this.teardownUnneededNetwork(nai);
            }
        }
    }

    private void rematchAllNetworksAndRequests(NetworkAgentInfo changed, int oldScore) {
        long now = SystemClock.elapsedRealtime();
        if (changed != null && oldScore < changed.getCurrentScore()) {
            this.rematchNetworkAndRequests(changed, ReapUnvalidatedNetworks.REAP, now);
        } else {
            Object[] nais = this.mNetworkAgentInfos.values().toArray(new NetworkAgentInfo[this.mNetworkAgentInfos.size()]);
            Arrays.sort(nais);
            for (Object nai : nais) {
                this.rematchNetworkAndRequests((NetworkAgentInfo)nai, nai != nais[nais.length - 1] ? ReapUnvalidatedNetworks.DONT_REAP : ReapUnvalidatedNetworks.REAP, now);
            }
        }
    }

    private void updateInetCondition(NetworkAgentInfo nai) {
        int newInetCondition;
        if (!nai.everValidated) {
            return;
        }
        if (!this.isDefaultNetwork(nai)) {
            return;
        }
        int n = newInetCondition = nai.lastValidated ? 100 : 0;
        if (newInetCondition == this.mDefaultInetConditionPublished) {
            return;
        }
        this.mDefaultInetConditionPublished = newInetCondition;
        this.sendInetConditionBroadcast(nai.networkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLockdownVpn(NetworkAgentInfo nai) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            if (this.mLockdownTracker != null) {
                if (nai != null && nai.isVPN()) {
                    this.mLockdownTracker.onVpnStateChanged(nai.networkInfo);
                } else {
                    this.mLockdownTracker.onNetworkInfoChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNetworkInfo(NetworkAgentInfo networkAgent, NetworkInfo newInfo) {
        NetworkInfo.State state = newInfo.getState();
        NetworkInfo oldInfo = null;
        int oldScore = networkAgent.getCurrentScore();
        NetworkAgentInfo networkAgentInfo = networkAgent;
        synchronized (networkAgentInfo) {
            oldInfo = networkAgent.networkInfo;
            networkAgent.networkInfo = newInfo;
        }
        this.notifyLockdownVpn(networkAgent);
        ConnectivityService.log(networkAgent.name() + " EVENT_NETWORK_INFO_CHANGED, going from " + (oldInfo == null ? "null" : oldInfo.getState()) + " to " + (Object)((Object)state));
        if (!networkAgent.created && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING && networkAgent.isVPN())) {
            networkAgent.networkCapabilities.addCapability(19);
            if (!this.createNativeNetwork(networkAgent)) {
                return;
            }
            networkAgent.created = true;
        }
        if (!networkAgent.everConnected && state == NetworkInfo.State.CONNECTED) {
            networkAgent.everConnected = true;
            if (networkAgent.linkProperties == null) {
                Slog.wtf(TAG, networkAgent.name() + " connected with null LinkProperties");
            }
            networkAgentInfo = networkAgent;
            synchronized (networkAgentInfo) {
                networkAgent.setNetworkCapabilities(networkAgent.networkCapabilities);
            }
            this.handlePerNetworkPrivateDnsConfig(networkAgent, this.mDnsManager.getPrivateDnsConfig());
            this.updateLinkProperties(networkAgent, new LinkProperties(networkAgent.linkProperties), null);
            if (networkAgent.networkMisc.acceptPartialConnectivity) {
                networkAgent.networkMonitor().setAcceptPartialConnectivity();
            }
            networkAgent.networkMonitor().notifyNetworkConnected(networkAgent.linkProperties, networkAgent.networkCapabilities);
            this.scheduleUnvalidatedPrompt(networkAgent);
            this.updateSignalStrengthThresholds(networkAgent, "CONNECT", null);
            if (networkAgent.isVPN()) {
                this.updateAllVpnsCapabilities();
            }
            long now = SystemClock.elapsedRealtime();
            this.rematchNetworkAndRequests(networkAgent, ReapUnvalidatedNetworks.REAP, now);
            this.notifyNetworkCallbacks(networkAgent, 524289);
        } else if (state == NetworkInfo.State.DISCONNECTED) {
            networkAgent.asyncChannel.disconnect();
            if (networkAgent.isVPN()) {
                this.updateUids(networkAgent, networkAgent.networkCapabilities, null);
            }
            this.disconnectAndDestroyNetwork(networkAgent);
            if (networkAgent.isVPN()) {
                this.mProxyTracker.sendProxyBroadcast();
            }
        } else if (oldInfo != null && oldInfo.getState() == NetworkInfo.State.SUSPENDED || state == NetworkInfo.State.SUSPENDED) {
            if (networkAgent.getCurrentScore() != oldScore) {
                this.rematchAllNetworksAndRequests(networkAgent, oldScore);
            }
            this.updateCapabilities(networkAgent.getCurrentScore(), networkAgent, networkAgent.networkCapabilities);
            this.notifyNetworkCallbacks(networkAgent, state == NetworkInfo.State.SUSPENDED ? 524297 : 524298);
            this.mLegacyTypeTracker.update(networkAgent);
        }
    }

    private void updateNetworkScore(NetworkAgentInfo nai, int score) {
        if (VDBG || DDBG) {
            ConnectivityService.log("updateNetworkScore for " + nai.name() + " to " + score);
        }
        if (score < 0) {
            ConnectivityService.loge("updateNetworkScore for " + nai.name() + " got a negative score (" + score + ").  Bumping score to min of 0");
            score = 0;
        }
        int oldScore = nai.getCurrentScore();
        nai.setCurrentScore(score);
        this.rematchAllNetworksAndRequests(nai, oldScore);
        this.sendUpdatedScoreToFactories(nai);
    }

    protected void notifyNetworkAvailable(NetworkAgentInfo nai, NetworkRequestInfo nri) {
        this.mHandler.removeMessages(20, nri);
        if (nri.mPendingIntent != null) {
            this.sendPendingIntentForRequest(nri, nai, 524290);
            return;
        }
        boolean metered = nai.networkCapabilities.isMetered();
        boolean blocked = this.isUidNetworkingWithVpnBlocked(nri.mUid, this.mUidRules.get(nri.mUid), metered, this.mRestrictBackground);
        this.callCallbackForRequest(nri, nai, 524290, blocked ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeNotifyNetworkBlocked(NetworkAgentInfo nai, boolean oldMetered, boolean newMetered, boolean oldRestrictBackground, boolean newRestrictBackground) {
        for (int i = 0; i < nai.numNetworkRequests(); ++i) {
            boolean newBlocked;
            boolean oldBlocked;
            NetworkRequest nr = nai.requestAt(i);
            NetworkRequestInfo nri = this.mNetworkRequests.get(nr);
            int uidRules = this.mUidRules.get(nri.mUid);
            SparseArray<Vpn> sparseArray = this.mVpns;
            synchronized (sparseArray) {
                oldBlocked = this.isUidNetworkingWithVpnBlocked(nri.mUid, uidRules, oldMetered, oldRestrictBackground);
                newBlocked = this.isUidNetworkingWithVpnBlocked(nri.mUid, uidRules, newMetered, newRestrictBackground);
            }
            if (oldBlocked == newBlocked) continue;
            this.callCallbackForRequest(nri, nai, 524299, ConnectivityService.encodeBool(newBlocked));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeNotifyNetworkBlockedForNewUidRules(int uid, int newRules) {
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            boolean newBlocked;
            boolean oldBlocked;
            boolean metered = nai.networkCapabilities.isMetered();
            SparseArray<Vpn> sparseArray = this.mVpns;
            synchronized (sparseArray) {
                oldBlocked = this.isUidNetworkingWithVpnBlocked(uid, this.mUidRules.get(uid), metered, this.mRestrictBackground);
                newBlocked = this.isUidNetworkingWithVpnBlocked(uid, newRules, metered, this.mRestrictBackground);
            }
            if (oldBlocked == newBlocked) continue;
            int arg = ConnectivityService.encodeBool(newBlocked);
            for (int i = 0; i < nai.numNetworkRequests(); ++i) {
                NetworkRequest nr = nai.requestAt(i);
                NetworkRequestInfo nri = this.mNetworkRequests.get(nr);
                if (nri == null || nri.mUid != uid) continue;
                this.callCallbackForRequest(nri, nai, 524299, arg);
            }
        }
    }

    @VisibleForTesting
    protected void sendLegacyNetworkBroadcast(NetworkAgentInfo nai, NetworkInfo.DetailedState state, int type) {
        NetworkInfo info = new NetworkInfo(nai.networkInfo);
        info.setType(type);
        if (state != NetworkInfo.DetailedState.DISCONNECTED) {
            info.setDetailedState(state, null, info.getExtraInfo());
            this.sendConnectedBroadcast(info);
        } else {
            info.setDetailedState(state, info.getReason(), info.getExtraInfo());
            Intent intent = new Intent("android.net.conn.CONNECTIVITY_CHANGE");
            intent.putExtra("networkInfo", info);
            intent.putExtra("networkType", info.getType());
            if (info.isFailover()) {
                intent.putExtra("isFailover", true);
                nai.networkInfo.setFailover(false);
            }
            if (info.getReason() != null) {
                intent.putExtra("reason", info.getReason());
            }
            if (info.getExtraInfo() != null) {
                intent.putExtra("extraInfo", info.getExtraInfo());
            }
            NetworkAgentInfo newDefaultAgent = null;
            if (nai.isSatisfyingRequest(this.mDefaultRequest.requestId)) {
                newDefaultAgent = this.getDefaultNetwork();
                if (newDefaultAgent != null) {
                    intent.putExtra("otherNetwork", newDefaultAgent.networkInfo);
                } else {
                    intent.putExtra("noConnectivity", true);
                }
            }
            intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
            this.sendStickyBroadcast(intent);
            if (newDefaultAgent != null) {
                this.sendConnectedBroadcast(newDefaultAgent.networkInfo);
            }
        }
    }

    protected void notifyNetworkCallbacks(NetworkAgentInfo networkAgent, int notifyType, int arg1) {
        if (VDBG || DDBG) {
            String notification = ConnectivityManager.getCallbackName(notifyType);
            ConnectivityService.log("notifyType " + notification + " for " + networkAgent.name());
        }
        for (int i = 0; i < networkAgent.numNetworkRequests(); ++i) {
            NetworkRequest nr = networkAgent.requestAt(i);
            NetworkRequestInfo nri = this.mNetworkRequests.get(nr);
            if (VDBG) {
                ConnectivityService.log(" sending notification for " + nr);
            }
            if (nri.mPendingIntent == null) {
                this.callCallbackForRequest(nri, networkAgent, notifyType, arg1);
                continue;
            }
            this.sendPendingIntentForRequest(nri, networkAgent, notifyType);
        }
    }

    protected void notifyNetworkCallbacks(NetworkAgentInfo networkAgent, int notifyType) {
        this.notifyNetworkCallbacks(networkAgent, notifyType, 0);
    }

    private Network[] getDefaultNetworks() {
        this.ensureRunningOnConnectivityServiceThread();
        ArrayList<Network> defaultNetworks = new ArrayList<Network>();
        NetworkAgentInfo defaultNetwork = this.getDefaultNetwork();
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            if (!nai.everConnected || nai != defaultNetwork && !nai.isVPN()) continue;
            defaultNetworks.add(nai.network);
        }
        return defaultNetworks.toArray(new Network[0]);
    }

    private void notifyIfacesChangedForNetworkStats() {
        this.ensureRunningOnConnectivityServiceThread();
        String activeIface = null;
        LinkProperties activeLinkProperties = this.getActiveLinkProperties();
        if (activeLinkProperties != null) {
            activeIface = activeLinkProperties.getInterfaceName();
        }
        try {
            this.mStatsService.forceUpdateIfaces(this.getDefaultNetworks(), this.getAllVpnInfo(), this.getAllNetworkState(), activeIface);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addVpnAddress(String address, int prefixLength) {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            return this.mVpns.get(user).addAddress(address, prefixLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeVpnAddress(String address, int prefixLength) {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            return this.mVpns.get(user).removeAddress(address, prefixLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setUnderlyingNetworksForVpn(Network[] networks) {
        boolean success;
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.throwIfLockdownEnabled();
            success = this.mVpns.get(user).setUnderlyingNetworks(networks);
        }
        if (success) {
            this.mHandler.post(() -> {
                this.updateAllVpnsCapabilities();
                this.notifyIfacesChangedForNetworkStats();
            });
        }
        return success;
    }

    @Override
    public String getCaptivePortalServerUrl() {
        this.enforceConnectivityInternalPermission();
        String settingUrl = this.mContext.getResources().getString(17039758);
        if (!TextUtils.isEmpty(settingUrl)) {
            return settingUrl;
        }
        settingUrl = Settings.Global.getString(this.mContext.getContentResolver(), "captive_portal_http_url");
        if (!TextUtils.isEmpty(settingUrl)) {
            return settingUrl;
        }
        return DEFAULT_CAPTIVE_PORTAL_HTTP_URL;
    }

    @Override
    public void startNattKeepalive(Network network, int intervalSeconds, ISocketKeepaliveCallback cb, String srcAddr, int srcPort, String dstAddr) {
        this.enforceKeepalivePermission();
        this.mKeepaliveTracker.startNattKeepalive(this.getNetworkAgentInfoForNetwork(network), null, intervalSeconds, cb, srcAddr, srcPort, dstAddr, 4500);
    }

    @Override
    public void startNattKeepaliveWithFd(Network network, FileDescriptor fd, int resourceId, int intervalSeconds, ISocketKeepaliveCallback cb, String srcAddr, String dstAddr) {
        this.mKeepaliveTracker.startNattKeepalive(this.getNetworkAgentInfoForNetwork(network), fd, resourceId, intervalSeconds, cb, srcAddr, dstAddr, 4500);
    }

    @Override
    public void startTcpKeepalive(Network network, FileDescriptor fd, int intervalSeconds, ISocketKeepaliveCallback cb) {
        this.enforceKeepalivePermission();
        this.mKeepaliveTracker.startTcpKeepalive(this.getNetworkAgentInfoForNetwork(network), fd, intervalSeconds, cb);
    }

    @Override
    public void stopKeepalive(Network network, int slot) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(528396, slot, 0, network));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void factoryReset() {
        this.enforceConnectivityInternalPermission();
        if (this.mUserManager.hasUserRestriction("no_network_reset")) {
            return;
        }
        int userId = UserHandle.getCallingUserId();
        Binder.withCleanCallingIdentity(() -> {
            IpMemoryStore ipMemoryStore = IpMemoryStore.getMemoryStore(this.mContext);
            ipMemoryStore.factoryReset();
        });
        this.setAirplaneMode(false);
        if (!this.mUserManager.hasUserRestriction("no_config_tethering")) {
            String pkgName = this.mContext.getOpPackageName();
            for (String tether : this.getTetheredIfaces()) {
                this.untether(tether, pkgName);
            }
        }
        if (!this.mUserManager.hasUserRestriction("no_config_vpn")) {
            SparseArray<Vpn> sparseArray = this.mVpns;
            synchronized (sparseArray) {
                VpnConfig vpnConfig;
                String alwaysOnPackage = this.getAlwaysOnVpnPackage(userId);
                if (alwaysOnPackage != null) {
                    this.setAlwaysOnVpnPackage(userId, null, false, null);
                    this.setVpnPackageAuthorization(alwaysOnPackage, userId, false);
                }
                if (this.mLockdownEnabled && userId == 0) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mKeyStore.delete("LOCKDOWN_VPN");
                        this.mLockdownEnabled = false;
                        this.setLockdownTracker(null);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                if ((vpnConfig = this.getVpnConfig(userId)) != null) {
                    if (vpnConfig.legacy) {
                        this.prepareVpn("[Legacy VPN]", "[Legacy VPN]", userId);
                    } else {
                        this.setVpnPackageAuthorization(vpnConfig.user, userId, false);
                        this.prepareVpn(null, "[Legacy VPN]", userId);
                    }
                }
            }
        }
        if (!this.mUserManager.hasUserRestriction("disallow_config_private_dns")) {
            Settings.Global.putString(this.mContext.getContentResolver(), "private_dns_mode", "opportunistic");
        }
        Settings.Global.putString(this.mContext.getContentResolver(), "network_avoid_bad_wifi", null);
    }

    @Override
    public byte[] getNetworkWatchlistConfigHash() {
        NetworkWatchlistManager nwm = this.mContext.getSystemService(NetworkWatchlistManager.class);
        if (nwm == null) {
            ConnectivityService.loge("Unable to get NetworkWatchlistManager");
            return null;
        }
        return nwm.getWatchlistConfigHash();
    }

    @VisibleForTesting
    MultinetworkPolicyTracker createMultinetworkPolicyTracker(Context c, Handler h, Runnable r) {
        return new MultinetworkPolicyTracker(c, h, r);
    }

    @VisibleForTesting
    public WakeupMessage makeWakeupMessage(Context c, Handler h, String s, int cmd, Object obj) {
        return new WakeupMessage(c, h, s, cmd, 0, 0, obj);
    }

    @VisibleForTesting
    public boolean hasService(String name) {
        return ServiceManager.checkService(name) != null;
    }

    @VisibleForTesting
    protected IpConnectivityMetrics.Logger metricsLogger() {
        return Preconditions.checkNotNull(LocalServices.getService(IpConnectivityMetrics.Logger.class), "no IpConnectivityMetrics service");
    }

    private void logNetworkEvent(NetworkAgentInfo nai, int evtype) {
        int[] transports = nai.networkCapabilities.getTransportTypes();
        this.mMetricsLog.log(nai.network.netId, transports, (IpConnectivityLog.Event)new NetworkEvent(evtype));
    }

    private static boolean toBool(int encodedBoolean) {
        return encodedBoolean != 0;
    }

    private static int encodeBool(boolean b) {
        return b ? 1 : 0;
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new ShellCmd().exec(this, in, out, err, args, callback, resultReceiver);
    }

    @GuardedBy(value={"mVpns"})
    private Vpn getVpnIfOwner() {
        int uid = Binder.getCallingUid();
        int user = UserHandle.getUserId(uid);
        Vpn vpn = this.mVpns.get(user);
        if (vpn == null) {
            return null;
        }
        VpnInfo info = vpn.getVpnInfo();
        return info == null || info.ownerUid != uid ? null : vpn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vpn enforceActiveVpnOrNetworkStackPermission() {
        if (this.checkNetworkStackPermission()) {
            return null;
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.getVpnIfOwner();
            if (vpn != null) {
                return vpn;
            }
        }
        throw new SecurityException("App must either be an active VPN or have the NETWORK_STACK permission");
    }

    @Override
    public int getConnectionOwnerUid(ConnectionInfo connectionInfo) {
        Vpn vpn = this.enforceActiveVpnOrNetworkStackPermission();
        if (connectionInfo.protocol != OsConstants.IPPROTO_TCP && connectionInfo.protocol != OsConstants.IPPROTO_UDP) {
            throw new IllegalArgumentException("Unsupported protocol " + connectionInfo.protocol);
        }
        int uid = InetDiagMessage.getConnectionOwnerUid(connectionInfo.protocol, connectionInfo.local, connectionInfo.remote);
        if (vpn != null && !vpn.appliesToUid(uid)) {
            return -1;
        }
        return uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCallerCurrentAlwaysOnVpnApp() {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.getVpnIfOwner();
            return vpn != null && vpn.getAlwaysOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCallerCurrentAlwaysOnVpnLockdownApp() {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.getVpnIfOwner();
            return vpn != null && vpn.getLockdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder startOrGetTestNetworkService() {
        Object object = this.mTNSLock;
        synchronized (object) {
            TestNetworkService.enforceTestNetworkPermissions(this.mContext);
            if (this.mTNS == null) {
                this.mTNS = new TestNetworkService(this.mContext, this.mNMS);
            }
            return this.mTNS;
        }
    }

    private class ShellCmd
    extends ShellCommand {
        private ShellCmd() {
        }

        @Override
        public int onCommand(String cmd) {
            if (cmd == null) {
                return this.handleDefaultCommands(cmd);
            }
            PrintWriter pw = this.getOutPrintWriter();
            try {
                switch (cmd) {
                    case "airplane-mode": {
                        String action = this.getNextArg();
                        if ("enable".equals(action)) {
                            ConnectivityService.this.setAirplaneMode(true);
                            return 0;
                        }
                        if ("disable".equals(action)) {
                            ConnectivityService.this.setAirplaneMode(false);
                            return 0;
                        }
                        if (action == null) {
                            ContentResolver cr = ConnectivityService.this.mContext.getContentResolver();
                            int enabled = Settings.Global.getInt(cr, "airplane_mode_on");
                            pw.println(enabled == 0 ? "disabled" : "enabled");
                            return 0;
                        }
                        this.onHelp();
                        return -1;
                    }
                }
                return this.handleDefaultCommands(cmd);
            }
            catch (Exception e) {
                pw.println(e);
                return -1;
            }
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("Connectivity service commands:");
            pw.println("  help");
            pw.println("    Print this help text.");
            pw.println("  airplane-mode [enable|disable]");
            pw.println("    Turn airplane mode on or off.");
            pw.println("  airplane-mode");
            pw.println("    Get airplane mode.");
        }
    }

    private class NetworkRequestInfo
    implements IBinder.DeathRecipient {
        final NetworkRequest request;
        final PendingIntent mPendingIntent;
        boolean mPendingIntentSent;
        private final IBinder mBinder;
        final int mPid;
        final int mUid;
        final Messenger messenger;

        NetworkRequestInfo(NetworkRequest r, PendingIntent pi) {
            this.request = r;
            ConnectivityService.this.ensureNetworkRequestHasType(this.request);
            this.mPendingIntent = pi;
            this.messenger = null;
            this.mBinder = null;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.enforceRequestCountLimit();
        }

        NetworkRequestInfo(Messenger m, NetworkRequest r, IBinder binder) {
            this.messenger = m;
            this.request = r;
            ConnectivityService.this.ensureNetworkRequestHasType(this.request);
            this.mBinder = binder;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.mPendingIntent = null;
            this.enforceRequestCountLimit();
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enforceRequestCountLimit() {
            SparseIntArray sparseIntArray = ConnectivityService.this.mUidToNetworkRequestCount;
            synchronized (sparseIntArray) {
                int networkRequests = ConnectivityService.this.mUidToNetworkRequestCount.get(this.mUid, 0) + 1;
                if (networkRequests >= 100) {
                    throw new ServiceSpecificException(1);
                }
                ConnectivityService.this.mUidToNetworkRequestCount.put(this.mUid, networkRequests);
            }
        }

        void unlinkDeathRecipient() {
            if (this.mBinder != null) {
                this.mBinder.unlinkToDeath(this, 0);
            }
        }

        @Override
        public void binderDied() {
            ConnectivityService.log("ConnectivityService NetworkRequestInfo binderDied(" + this.request + ", " + this.mBinder + ")");
            ConnectivityService.this.releaseNetworkRequest(this.request);
        }

        public String toString() {
            return "uid/pid:" + this.mUid + "/" + this.mPid + " " + this.request + (this.mPendingIntent == null ? "" : " to trigger " + this.mPendingIntent);
        }
    }

    private static class NetworkFactoryInfo {
        public final String name;
        public final Messenger messenger;
        public final AsyncChannel asyncChannel;
        public final int factorySerialNumber;

        NetworkFactoryInfo(String name, Messenger messenger, AsyncChannel asyncChannel, int factorySerialNumber) {
            this.name = name;
            this.messenger = messenger;
            this.asyncChannel = asyncChannel;
            this.factorySerialNumber = factorySerialNumber;
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private final HashMap<Uri, Integer> mUriEventMap = new HashMap();
        private final Context mContext;
        private final Handler mHandler;

        SettingsObserver(Context context, Handler handler) {
            super(null);
            this.mContext = context;
            this.mHandler = handler;
        }

        void observe(Uri uri, int what) {
            this.mUriEventMap.put(uri, what);
            ContentResolver resolver = this.mContext.getContentResolver();
            resolver.registerContentObserver(uri, false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            Slog.wtf(TAG, "Should never be reached.");
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Integer what = this.mUriEventMap.get(uri);
            if (what != null) {
                this.mHandler.obtainMessage(what).sendToTarget();
            } else {
                ConnectivityService.loge("No matching event to send for URI=" + uri);
            }
        }
    }

    private class InternalHandler
    extends Handler {
        public InternalHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 8: 
                case 24: {
                    ConnectivityService.this.handleReleaseNetworkTransitionWakelock(msg.what);
                    break;
                }
                case 9: {
                    ConnectivityService.this.mProxyTracker.loadDeprecatedGlobalHttpProxy();
                    break;
                }
                case 16: {
                    ConnectivityService.this.handleApplyDefaultProxy((ProxyInfo)msg.obj);
                    break;
                }
                case 17: {
                    ConnectivityService.this.handleRegisterNetworkFactory((NetworkFactoryInfo)msg.obj);
                    break;
                }
                case 23: {
                    ConnectivityService.this.handleUnregisterNetworkFactory((Messenger)msg.obj);
                    break;
                }
                case 18: {
                    Pair arg = (Pair)msg.obj;
                    ConnectivityService.this.handleRegisterNetworkAgent((NetworkAgentInfo)arg.first, (INetworkMonitor)arg.second);
                    break;
                }
                case 19: 
                case 21: {
                    ConnectivityService.this.handleRegisterNetworkRequest((NetworkRequestInfo)msg.obj);
                    break;
                }
                case 26: 
                case 31: {
                    ConnectivityService.this.handleRegisterNetworkRequestWithIntent(msg);
                    break;
                }
                case 20: {
                    NetworkRequestInfo nri = (NetworkRequestInfo)msg.obj;
                    ConnectivityService.this.handleTimedOutNetworkRequest(nri);
                    break;
                }
                case 27: {
                    ConnectivityService.this.handleReleaseNetworkRequestWithIntent((PendingIntent)msg.obj, msg.arg1);
                    break;
                }
                case 22: {
                    ConnectivityService.this.handleReleaseNetworkRequest((NetworkRequest)msg.obj, msg.arg1, false);
                    break;
                }
                case 28: {
                    Network network = (Network)msg.obj;
                    ConnectivityService.this.handleSetAcceptUnvalidated(network, ConnectivityService.toBool(msg.arg1), ConnectivityService.toBool(msg.arg2));
                    break;
                }
                case 45: {
                    Network network = (Network)msg.obj;
                    ConnectivityService.this.handleSetAcceptPartialConnectivity(network, ConnectivityService.toBool(msg.arg1), ConnectivityService.toBool(msg.arg2));
                    break;
                }
                case 35: {
                    ConnectivityService.this.handleSetAvoidUnvalidated((Network)msg.obj);
                    break;
                }
                case 29: {
                    ConnectivityService.this.handlePromptUnvalidated((Network)msg.obj);
                    break;
                }
                case 30: {
                    ConnectivityService.this.handleConfigureAlwaysOnNetworks();
                    break;
                }
                case 528395: {
                    ConnectivityService.this.mKeepaliveTracker.handleStartKeepalive(msg);
                    break;
                }
                case 528396: {
                    NetworkAgentInfo nai = ConnectivityService.this.getNetworkAgentInfoForNetwork((Network)msg.obj);
                    int slot = msg.arg1;
                    int reason = msg.arg2;
                    ConnectivityService.this.mKeepaliveTracker.handleStopKeepalive(nai, slot, reason);
                    break;
                }
                case 25: {
                    ConnectivityService.this.mMultipathPolicyTracker.start();
                    break;
                }
                case 36: {
                    ConnectivityService.this.handleReportNetworkConnectivity((Network)msg.obj, msg.arg1, ConnectivityService.toBool(msg.arg2));
                    break;
                }
                case 37: {
                    ConnectivityService.this.handlePrivateDnsSettingsChanged();
                    break;
                }
                case 38: {
                    ConnectivityService.this.handlePrivateDnsValidationUpdate((DnsManager.PrivateDnsValidationUpdate)msg.obj);
                    break;
                }
                case 39: {
                    ConnectivityService.this.handleUidRulesChanged(msg.arg1, msg.arg2);
                    break;
                }
                case 40: {
                    ConnectivityService.this.handleRestrictBackgroundChanged(ConnectivityService.toBool(msg.arg1));
                    break;
                }
                case 44: {
                    ConnectivityService.this.mNotifier.clearNotification(msg.arg1, NetworkNotificationManager.NotificationType.LOGGED_IN);
                }
            }
        }
    }

    private class CaptivePortalImpl
    extends ICaptivePortal.Stub {
        private final Network mNetwork;

        private CaptivePortalImpl(Network network) {
            this.mNetwork = network;
        }

        @Override
        public void appResponse(int response) {
            NetworkAgentInfo nai;
            if (response == 2) {
                ConnectivityService.this.enforceSettingsPermission();
            }
            if ((nai = ConnectivityService.this.getNetworkAgentInfoForNetwork(this.mNetwork)) == null) {
                return;
            }
            NetworkMonitorManager nm = nai.networkMonitor();
            if (nm == null) {
                return;
            }
            nm.notifyCaptivePortalAppFinished(response);
        }

        @Override
        public void logEvent(int eventId, String packageName) {
            ConnectivityService.this.enforceSettingsPermission();
            new MetricsLogger().action(eventId, packageName);
        }
    }

    private class NetworkMonitorCallbacks
    extends INetworkMonitorCallbacks.Stub {
        private final int mNetId;
        private final AutodestructReference<NetworkAgentInfo> mNai;

        private NetworkMonitorCallbacks(NetworkAgentInfo nai) {
            this.mNetId = nai.network.netId;
            this.mNai = new AutodestructReference<NetworkAgentInfo>(nai);
        }

        @Override
        public void onNetworkMonitorCreated(INetworkMonitor networkMonitor) {
            ConnectivityService.this.mHandler.sendMessage(ConnectivityService.this.mHandler.obtainMessage(18, new Pair<NetworkAgentInfo, INetworkMonitor>(this.mNai.getAndDestroy(), networkMonitor)));
        }

        @Override
        public void notifyNetworkTested(int testResult, String redirectUrl) {
            ConnectivityService.this.mTrackerHandler.sendMessage(ConnectivityService.this.mTrackerHandler.obtainMessage(41, testResult, this.mNetId, redirectUrl));
        }

        @Override
        public void notifyPrivateDnsConfigResolved(PrivateDnsConfigParcel config) {
            ConnectivityService.this.mTrackerHandler.sendMessage(ConnectivityService.this.mTrackerHandler.obtainMessage(42, 0, this.mNetId, PrivateDnsConfig.fromParcel(config)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void showProvisioningNotification(String action, String packageName) {
            PendingIntent pendingIntent;
            Intent intent = new Intent(action);
            intent.setPackage(packageName);
            long token = Binder.clearCallingIdentity();
            try {
                pendingIntent = PendingIntent.getBroadcast(ConnectivityService.this.mContext, 0, intent, 0);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            ConnectivityService.this.mTrackerHandler.sendMessage(ConnectivityService.this.mTrackerHandler.obtainMessage(43, 1, this.mNetId, pendingIntent));
        }

        @Override
        public void hideProvisioningNotification() {
            ConnectivityService.this.mTrackerHandler.sendMessage(ConnectivityService.this.mTrackerHandler.obtainMessage(43, 0, this.mNetId));
        }

        @Override
        public int getInterfaceVersion() {
            return 3;
        }
    }

    private class NetworkStateTrackerHandler
    extends Handler {
        public NetworkStateTrackerHandler(Looper looper) {
            super(looper);
        }

        private boolean maybeHandleAsyncChannelMessage(Message msg) {
            switch (msg.what) {
                default: {
                    return false;
                }
                case 69632: {
                    ConnectivityService.this.handleAsyncChannelHalfConnect(msg);
                    break;
                }
                case 69635: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) break;
                    nai.asyncChannel.disconnect();
                    break;
                }
                case 69636: {
                    ConnectivityService.this.handleAsyncChannelDisconnected(msg);
                }
            }
            return true;
        }

        private void maybeHandleNetworkAgentMessage(Message msg) {
            NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
            if (nai == null) {
                if (VDBG) {
                    ConnectivityService.log(String.format("%s from unknown NetworkAgent", ConnectivityService.eventName(msg.what)));
                }
                return;
            }
            switch (msg.what) {
                case 528386: {
                    NetworkCapabilities networkCapabilities = (NetworkCapabilities)msg.obj;
                    if (networkCapabilities.hasConnectivityManagedCapability()) {
                        Slog.wtf(TAG, "BUG: " + nai + " has CS-managed capability.");
                    }
                    ConnectivityService.this.updateCapabilities(nai.getCurrentScore(), nai, networkCapabilities);
                    break;
                }
                case 528387: {
                    ConnectivityService.this.handleUpdateLinkProperties(nai, (LinkProperties)msg.obj);
                    break;
                }
                case 528385: {
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    ConnectivityService.this.updateNetworkInfo(nai, info);
                    break;
                }
                case 528388: {
                    ConnectivityService.this.updateNetworkScore(nai, msg.arg1);
                    break;
                }
                case 528392: {
                    if (nai.everConnected) {
                        ConnectivityService.loge("ERROR: cannot call explicitlySelected on already-connected network");
                    }
                    nai.networkMisc.explicitlySelected = msg.arg1 == 1;
                    nai.networkMisc.acceptUnvalidated = msg.arg1 == 1 && msg.arg2 == 1;
                    nai.networkMisc.acceptPartialConnectivity = msg.arg2 == 1;
                    break;
                }
                case 528397: {
                    ConnectivityService.this.mKeepaliveTracker.handleEventSocketKeepalive(nai, msg);
                }
            }
        }

        private boolean maybeHandleNetworkMonitorMessage(Message msg) {
            switch (msg.what) {
                default: {
                    return false;
                }
                case 41: {
                    NetworkAgentInfo nai = ConnectivityService.this.getNetworkAgentInfoForNetId(msg.arg2);
                    if (nai == null) break;
                    boolean wasPartial = nai.partialConnectivity;
                    nai.partialConnectivity = (msg.arg1 & 2) != 0;
                    boolean partialConnectivityChanged = wasPartial != nai.partialConnectivity;
                    boolean valid = (msg.arg1 & 1) != 0;
                    boolean wasValidated = nai.lastValidated;
                    boolean wasDefault = ConnectivityService.this.isDefaultNetwork(nai);
                    if (nai.captivePortalValidationPending && valid) {
                        nai.captivePortalValidationPending = false;
                        ConnectivityService.this.showNetworkNotification(nai, NetworkNotificationManager.NotificationType.LOGGED_IN);
                    }
                    String redirectUrl = msg.obj instanceof String ? (String)msg.obj : "";
                    String logMsg = !TextUtils.isEmpty(redirectUrl) ? " with redirect to " + redirectUrl : "";
                    ConnectivityService.log(nai.name() + " validation " + (valid ? "passed" : "failed") + logMsg);
                    if (valid != nai.lastValidated) {
                        if (wasDefault) {
                            ConnectivityService.this.metricsLogger().defaultNetworkMetrics().logDefaultNetworkValidity(SystemClock.elapsedRealtime(), valid);
                        }
                        int oldScore = nai.getCurrentScore();
                        nai.lastValidated = valid;
                        nai.everValidated |= valid;
                        ConnectivityService.this.updateCapabilities(oldScore, nai, nai.networkCapabilities);
                        if (oldScore != nai.getCurrentScore()) {
                            ConnectivityService.this.sendUpdatedScoreToFactories(nai);
                        }
                        if (valid) {
                            ConnectivityService.this.handleFreshlyValidatedNetwork(nai);
                            ConnectivityService.this.mNotifier.clearNotification(nai.network.netId, NetworkNotificationManager.NotificationType.NO_INTERNET);
                            ConnectivityService.this.mNotifier.clearNotification(nai.network.netId, NetworkNotificationManager.NotificationType.LOST_INTERNET);
                            ConnectivityService.this.mNotifier.clearNotification(nai.network.netId, NetworkNotificationManager.NotificationType.PARTIAL_CONNECTIVITY);
                        }
                    } else if (partialConnectivityChanged) {
                        ConnectivityService.this.updateCapabilities(nai.getCurrentScore(), nai, nai.networkCapabilities);
                    }
                    ConnectivityService.this.updateInetCondition(nai);
                    Bundle redirectUrlBundle = new Bundle();
                    redirectUrlBundle.putString(NetworkAgent.REDIRECT_URL_KEY, redirectUrl);
                    nai.asyncChannel.sendMessage(528391, valid ? 1 : 2, 0, redirectUrlBundle);
                    if (!wasPartial && nai.partialConnectivity) {
                        ConnectivityService.this.mHandler.removeMessages(29, nai.network);
                        ConnectivityService.this.handlePromptUnvalidated(nai.network);
                    }
                    if (!wasValidated || nai.lastValidated) break;
                    ConnectivityService.this.handleNetworkUnvalidated(nai);
                    break;
                }
                case 43: {
                    int netId = msg.arg2;
                    boolean visible = ConnectivityService.toBool(msg.arg1);
                    NetworkAgentInfo nai = ConnectivityService.this.getNetworkAgentInfoForNetId(netId);
                    if (nai != null && visible != nai.lastCaptivePortalDetected) {
                        int oldScore = nai.getCurrentScore();
                        nai.lastCaptivePortalDetected = visible;
                        nai.everCaptivePortalDetected |= visible;
                        if (nai.lastCaptivePortalDetected && 2 == this.getCaptivePortalMode()) {
                            ConnectivityService.log("Avoiding captive portal network: " + nai.name());
                            nai.asyncChannel.sendMessage(528399);
                            ConnectivityService.this.teardownUnneededNetwork(nai);
                            break;
                        }
                        ConnectivityService.this.updateCapabilities(oldScore, nai, nai.networkCapabilities);
                    }
                    if (!visible) {
                        ConnectivityService.this.mNotifier.clearNotification(netId, NetworkNotificationManager.NotificationType.SIGN_IN);
                        ConnectivityService.this.mNotifier.clearNotification(netId, NetworkNotificationManager.NotificationType.NETWORK_SWITCH);
                        break;
                    }
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_PROVISIONING_NOTIFICATION from unknown NetworkMonitor");
                        break;
                    }
                    if (nai.networkMisc.provisioningNotificationDisabled) break;
                    ConnectivityService.this.mNotifier.showNotification(netId, NetworkNotificationManager.NotificationType.SIGN_IN, nai, null, (PendingIntent)msg.obj, nai.networkMisc.explicitlySelected);
                    break;
                }
                case 42: {
                    NetworkAgentInfo nai = ConnectivityService.this.getNetworkAgentInfoForNetId(msg.arg2);
                    if (nai == null) break;
                    ConnectivityService.this.updatePrivateDns(nai, (PrivateDnsConfig)msg.obj);
                    break;
                }
            }
            return true;
        }

        private int getCaptivePortalMode() {
            return Settings.Global.getInt(ConnectivityService.this.mContext.getContentResolver(), "captive_portal_mode", 1);
        }

        private boolean maybeHandleNetworkAgentInfoMessage(Message msg) {
            block3: {
                switch (msg.what) {
                    default: {
                        return false;
                    }
                    case 1001: 
                }
                NetworkAgentInfo nai = (NetworkAgentInfo)msg.obj;
                if (nai == null || !ConnectivityService.this.isLiveNetworkAgent(nai, msg.what)) break block3;
                ConnectivityService.this.handleLingerComplete(nai);
            }
            return true;
        }

        private boolean maybeHandleNetworkFactoryMessage(Message msg) {
            switch (msg.what) {
                default: {
                    return false;
                }
                case 536580: 
            }
            ConnectivityService.this.handleReleaseNetworkRequest((NetworkRequest)msg.obj, msg.sendingUid, true);
            return true;
        }

        @Override
        public void handleMessage(Message msg) {
            if (!(this.maybeHandleAsyncChannelMessage(msg) || this.maybeHandleNetworkMonitorMessage(msg) || this.maybeHandleNetworkAgentInfoMessage(msg) || this.maybeHandleNetworkFactoryMessage(msg))) {
                this.maybeHandleNetworkAgentMessage(msg);
            }
        }
    }

    @VisibleForTesting
    static class LegacyTypeTracker {
        private static final boolean DBG = true;
        private static final boolean VDBG = false;
        private final ArrayList<NetworkAgentInfo>[] mTypeLists;
        private final ConnectivityService mService;

        LegacyTypeTracker(ConnectivityService service) {
            this.mService = service;
            this.mTypeLists = new ArrayList[19];
        }

        public void addSupportedType(int type) {
            if (this.mTypeLists[type] != null) {
                throw new IllegalStateException("legacy list for type " + type + "already initialized");
            }
            this.mTypeLists[type] = new ArrayList();
        }

        public boolean isTypeSupported(int type) {
            return ConnectivityManager.isNetworkTypeValid(type) && this.mTypeLists[type] != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NetworkAgentInfo getNetworkForType(int type) {
            ArrayList<NetworkAgentInfo>[] arrayListArray = this.mTypeLists;
            synchronized (this.mTypeLists) {
                if (this.isTypeSupported(type) && !this.mTypeLists[type].isEmpty()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.mTypeLists[type].get(0);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        private void maybeLogBroadcast(NetworkAgentInfo nai, NetworkInfo.DetailedState state, int type, boolean isDefaultNetwork) {
            ConnectivityService.log("Sending " + (Object)((Object)state) + " broadcast for type " + type + " " + nai.name() + " isDefaultNetwork=" + isDefaultNetwork);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int type, NetworkAgentInfo nai) {
            if (!this.isTypeSupported(type)) {
                return;
            }
            ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
            if (list.contains(nai)) {
                return;
            }
            ArrayList<NetworkAgentInfo>[] arrayListArray = this.mTypeLists;
            synchronized (this.mTypeLists) {
                list.add(nai);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                boolean isDefaultNetwork = this.mService.isDefaultNetwork(nai);
                if (list.size() == 1 || isDefaultNetwork) {
                    this.maybeLogBroadcast(nai, NetworkInfo.DetailedState.CONNECTED, type, isDefaultNetwork);
                    this.mService.sendLegacyNetworkBroadcast(nai, NetworkInfo.DetailedState.CONNECTED, type);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(int type, NetworkAgentInfo nai, boolean wasDefault) {
            ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
            if (list == null || list.isEmpty()) {
                return;
            }
            boolean wasFirstNetwork = list.get(0).equals(nai);
            ArrayList<NetworkAgentInfo>[] arrayListArray = this.mTypeLists;
            synchronized (this.mTypeLists) {
                block7: {
                    if (!list.remove(nai)) {
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return;
                    }
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    if (wasFirstNetwork || wasDefault) {
                        this.maybeLogBroadcast(nai, NetworkInfo.DetailedState.DISCONNECTED, type, wasDefault);
                        this.mService.sendLegacyNetworkBroadcast(nai, NetworkInfo.DetailedState.DISCONNECTED, type);
                    }
                    if (list.isEmpty() || !wasFirstNetwork) break block7;
                    ConnectivityService.log("Other network available for type " + type + ", sending connected broadcast");
                    NetworkAgentInfo replacement = list.get(0);
                    this.maybeLogBroadcast(replacement, NetworkInfo.DetailedState.CONNECTED, type, this.mService.isDefaultNetwork(replacement));
                    this.mService.sendLegacyNetworkBroadcast(replacement, NetworkInfo.DetailedState.CONNECTED, type);
                }
                return;
            }
        }

        public void remove(NetworkAgentInfo nai, boolean wasDefault) {
            for (int type = 0; type < this.mTypeLists.length; ++type) {
                this.remove(type, nai, wasDefault);
            }
        }

        public void update(NetworkAgentInfo nai) {
            boolean isDefault = this.mService.isDefaultNetwork(nai);
            NetworkInfo.DetailedState state = nai.networkInfo.getDetailedState();
            for (int type = 0; type < this.mTypeLists.length; ++type) {
                boolean isFirst;
                ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
                boolean contains = list != null && list.contains(nai);
                boolean bl = isFirst = contains && nai == list.get(0);
                if (!isFirst && (!contains || !isDefault)) continue;
                this.maybeLogBroadcast(nai, state, type, isDefault);
                this.mService.sendLegacyNetworkBroadcast(nai, state, type);
            }
        }

        private String naiToString(NetworkAgentInfo nai) {
            String name = nai.name();
            String state = nai.networkInfo != null ? (Object)((Object)nai.networkInfo.getState()) + "/" + (Object)((Object)nai.networkInfo.getDetailedState()) : "???/???";
            return name + " " + state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(IndentingPrintWriter pw) {
            pw.println("mLegacyTypeTracker:");
            pw.increaseIndent();
            pw.print("Supported types:");
            for (int type = 0; type < this.mTypeLists.length; ++type) {
                if (this.mTypeLists[type] == null) continue;
                pw.print(" " + type);
            }
            pw.println();
            pw.println("Current state:");
            pw.increaseIndent();
            ArrayList<NetworkAgentInfo>[] arrayListArray = this.mTypeLists;
            synchronized (this.mTypeLists) {
                for (int type = 0; type < this.mTypeLists.length; ++type) {
                    if (this.mTypeLists[type] == null || this.mTypeLists[type].isEmpty()) continue;
                    for (NetworkAgentInfo nai : this.mTypeLists[type]) {
                        pw.println(type + " " + this.naiToString(nai));
                    }
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                pw.decreaseIndent();
                pw.decreaseIndent();
                pw.println();
                return;
            }
        }
    }

    private static enum UnneededFor {
        LINGER,
        TEARDOWN;

    }

    private static enum ReapUnvalidatedNetworks {
        REAP,
        DONT_REAP;

    }
}

