/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.util.Log;
import com.android.internal.util.ConcurrentUtils;
import com.android.server.SystemServerInitThreadPool;
import com.android.server.SystemService;
import com.android.server.location.ContextHubService;
import java.util.concurrent.Future;

class ContextHubSystemService
extends SystemService {
    private static final String TAG = "ContextHubSystemService";
    private ContextHubService mContextHubService;
    private Future<?> mInit = SystemServerInitThreadPool.get().submit(() -> {
        this.mContextHubService = new ContextHubService(context);
    }, "Init ContextHubSystemService");

    public ContextHubSystemService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            Log.d(TAG, "onBootPhase: PHASE_SYSTEM_SERVICES_READY");
            ConcurrentUtils.waitForFutureNoInterrupt(this.mInit, "Wait for ContextHubSystemService init");
            this.mInit = null;
            this.publishBinderService("contexthub", this.mContextHubService);
        }
    }
}

