/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AlarmManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationRequest;
import android.net.INetworkPolicyManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IDeviceIdleController;
import android.os.IMaintenanceActivityListener;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.KeyValueListParser;
import android.util.MutableLong;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.AtomicFile;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.AlarmManagerInternal;
import com.android.server.AnyMotionDetector;
import com.android.server.AppStateTracker;
import com.android.server.ConnectivityService;
import com.android.server.EventLogTags;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.SystemConfig;
import com.android.server.SystemService;
import com.android.server.am.BatteryStatsService;
import com.android.server.deviceidle.ConstraintController;
import com.android.server.deviceidle.DeviceIdleConstraintTracker;
import com.android.server.deviceidle.IDeviceIdleConstraint;
import com.android.server.deviceidle.TvConstraintController;
import com.android.server.net.NetworkPolicyManagerInternal;
import com.android.server.wm.ActivityTaskManagerInternal;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class DeviceIdleController
extends SystemService
implements AnyMotionDetector.DeviceIdleCallback {
    private static final String TAG = "DeviceIdleController";
    private static final boolean DEBUG = false;
    private static final boolean COMPRESS_TIME = false;
    private static final int EVENT_BUFFER_SIZE = 100;
    private AlarmManager mAlarmManager;
    private AlarmManagerInternal mLocalAlarmManager;
    private IBatteryStats mBatteryStats;
    private ActivityManagerInternal mLocalActivityManager;
    private ActivityTaskManagerInternal mLocalActivityTaskManager;
    private PowerManagerInternal mLocalPowerManager;
    private PowerManager mPowerManager;
    private INetworkPolicyManager mNetworkPolicyManager;
    private SensorManager mSensorManager;
    private final boolean mUseMotionSensor;
    private Sensor mMotionSensor;
    private LocationRequest mLocationRequest;
    private Intent mIdleIntent;
    private Intent mLightIdleIntent;
    private AnyMotionDetector mAnyMotionDetector;
    private final AppStateTracker mAppStateTracker;
    private boolean mLightEnabled;
    private boolean mDeepEnabled;
    private boolean mQuickDozeActivated;
    private boolean mForceIdle;
    private boolean mNetworkConnected;
    private boolean mScreenOn;
    private boolean mCharging;
    private boolean mNotMoving;
    private boolean mLocating;
    private boolean mLocated;
    private boolean mHasGps;
    private boolean mHasNetworkLocation;
    private Location mLastGenericLocation;
    private Location mLastGpsLocation;
    private boolean mScreenLocked;
    private int mNumBlockingConstraints = 0;
    private final ArrayMap<IDeviceIdleConstraint, DeviceIdleConstraintTracker> mConstraints = new ArrayMap();
    private ConstraintController mConstraintController;
    @VisibleForTesting
    static final int STATE_ACTIVE = 0;
    @VisibleForTesting
    static final int STATE_INACTIVE = 1;
    @VisibleForTesting
    static final int STATE_IDLE_PENDING = 2;
    @VisibleForTesting
    static final int STATE_SENSING = 3;
    @VisibleForTesting
    static final int STATE_LOCATING = 4;
    @VisibleForTesting
    static final int STATE_IDLE = 5;
    @VisibleForTesting
    static final int STATE_IDLE_MAINTENANCE = 6;
    @VisibleForTesting
    static final int STATE_QUICK_DOZE_DELAY = 7;
    private static final int ACTIVE_REASON_UNKNOWN = 0;
    private static final int ACTIVE_REASON_MOTION = 1;
    private static final int ACTIVE_REASON_SCREEN = 2;
    private static final int ACTIVE_REASON_CHARGING = 3;
    private static final int ACTIVE_REASON_UNLOCKED = 4;
    private static final int ACTIVE_REASON_FROM_BINDER_CALL = 5;
    private static final int ACTIVE_REASON_FORCED = 6;
    private static final int ACTIVE_REASON_ALARM = 7;
    @VisibleForTesting
    static final int SET_IDLE_FACTOR_RESULT_UNINIT = -1;
    @VisibleForTesting
    static final int SET_IDLE_FACTOR_RESULT_IGNORED = 0;
    @VisibleForTesting
    static final int SET_IDLE_FACTOR_RESULT_OK = 1;
    @VisibleForTesting
    static final int SET_IDLE_FACTOR_RESULT_NOT_SUPPORT = 2;
    @VisibleForTesting
    static final int SET_IDLE_FACTOR_RESULT_INVALID = 3;
    @VisibleForTesting
    static final long MIN_STATE_STEP_ALARM_CHANGE = 60000L;
    @VisibleForTesting
    static final float MIN_PRE_IDLE_FACTOR_CHANGE = 0.05f;
    @VisibleForTesting
    static final int LIGHT_STATE_ACTIVE = 0;
    @VisibleForTesting
    static final int LIGHT_STATE_INACTIVE = 1;
    @VisibleForTesting
    static final int LIGHT_STATE_PRE_IDLE = 3;
    @VisibleForTesting
    static final int LIGHT_STATE_IDLE = 4;
    @VisibleForTesting
    static final int LIGHT_STATE_WAITING_FOR_NETWORK = 5;
    @VisibleForTesting
    static final int LIGHT_STATE_IDLE_MAINTENANCE = 6;
    @VisibleForTesting
    static final int LIGHT_STATE_OVERRIDE = 7;
    private int mState;
    private int mLightState;
    private long mInactiveTimeout;
    private long mNextAlarmTime;
    private long mNextIdlePendingDelay;
    private long mNextIdleDelay;
    private long mNextLightIdleDelay;
    private long mNextLightAlarmTime;
    private long mNextSensingTimeoutAlarmTime;
    private long mCurIdleBudget;
    private long mMaintenanceStartTime;
    private long mIdleStartTime;
    private int mActiveIdleOpCount;
    private PowerManager.WakeLock mActiveIdleWakeLock;
    private PowerManager.WakeLock mGoingIdleWakeLock;
    private boolean mJobsActive;
    private boolean mAlarmsActive;
    private boolean mReportedMaintenanceActivity;
    private float mPreIdleFactor;
    private float mLastPreIdleFactor;
    private int mActiveReason;
    public final AtomicFile mConfigFile;
    private final RemoteCallbackList<IMaintenanceActivityListener> mMaintenanceActivityListeners = new RemoteCallbackList();
    private final ArrayMap<String, Integer> mPowerSaveWhitelistAppsExceptIdle = new ArrayMap();
    private final ArraySet<String> mPowerSaveWhitelistUserAppsExceptIdle = new ArraySet();
    private final ArrayMap<String, Integer> mPowerSaveWhitelistApps = new ArrayMap();
    private final ArrayMap<String, Integer> mPowerSaveWhitelistUserApps = new ArrayMap();
    private final SparseBooleanArray mPowerSaveWhitelistSystemAppIdsExceptIdle = new SparseBooleanArray();
    private final SparseBooleanArray mPowerSaveWhitelistSystemAppIds = new SparseBooleanArray();
    private final SparseBooleanArray mPowerSaveWhitelistExceptIdleAppIds = new SparseBooleanArray();
    private int[] mPowerSaveWhitelistExceptIdleAppIdArray = new int[0];
    private final SparseBooleanArray mPowerSaveWhitelistAllAppIds = new SparseBooleanArray();
    private int[] mPowerSaveWhitelistAllAppIdArray = new int[0];
    private final SparseBooleanArray mPowerSaveWhitelistUserAppIds = new SparseBooleanArray();
    private int[] mPowerSaveWhitelistUserAppIdArray = new int[0];
    private final SparseArray<Pair<MutableLong, String>> mTempWhitelistAppIdEndTimes = new SparseArray();
    private NetworkPolicyManagerInternal mNetworkPolicyManagerInternal;
    private int[] mTempWhitelistAppIdArray = new int[0];
    private ArrayMap<String, Integer> mRemovedFromSystemWhitelistApps = new ArrayMap();
    private static final int EVENT_NULL = 0;
    private static final int EVENT_NORMAL = 1;
    private static final int EVENT_LIGHT_IDLE = 2;
    private static final int EVENT_LIGHT_MAINTENANCE = 3;
    private static final int EVENT_DEEP_IDLE = 4;
    private static final int EVENT_DEEP_MAINTENANCE = 5;
    private final int[] mEventCmds = new int[100];
    private final long[] mEventTimes = new long[100];
    private final String[] mEventReasons = new String[100];
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.net.conn.CONNECTIVITY_CHANGE": {
                    DeviceIdleController.this.updateConnectivityState(intent);
                    break;
                }
                case "android.intent.action.BATTERY_CHANGED": {
                    boolean present = intent.getBooleanExtra("present", true);
                    boolean plugged = intent.getIntExtra("plugged", 0) != 0;
                    DeviceIdleController deviceIdleController = DeviceIdleController.this;
                    synchronized (deviceIdleController) {
                        DeviceIdleController.this.updateChargingLocked(present && plugged);
                        break;
                    }
                }
                case "android.intent.action.PACKAGE_REMOVED": {
                    String ssp;
                    Uri data;
                    if (intent.getBooleanExtra("android.intent.extra.REPLACING", false) || (data = intent.getData()) == null || (ssp = data.getSchemeSpecificPart()) == null) break;
                    DeviceIdleController.this.removePowerSaveWhitelistAppInternal(ssp);
                }
            }
        }
    };
    private final AlarmManager.OnAlarmListener mLightAlarmListener = new AlarmManager.OnAlarmListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.stepLightIdleStateLocked("s:alarm");
            }
        }
    };
    private final AlarmManager.OnAlarmListener mSensingTimeoutAlarmListener = new AlarmManager.OnAlarmListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            if (DeviceIdleController.this.mState == 3) {
                DeviceIdleController deviceIdleController = DeviceIdleController.this;
                synchronized (deviceIdleController) {
                    DeviceIdleController.this.becomeInactiveIfAppropriateLocked();
                }
            }
        }
    };
    @VisibleForTesting
    final AlarmManager.OnAlarmListener mDeepAlarmListener = new AlarmManager.OnAlarmListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.stepIdleStateLocked("s:alarm");
            }
        }
    };
    private final BroadcastReceiver mIdleStartedDoneReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.os.action.DEVICE_IDLE_MODE_CHANGED".equals(intent.getAction())) {
                DeviceIdleController.this.mHandler.sendEmptyMessageDelayed(8, ((DeviceIdleController)DeviceIdleController.this).mConstants.MIN_DEEP_MAINTENANCE_TIME);
            } else {
                DeviceIdleController.this.mHandler.sendEmptyMessageDelayed(8, ((DeviceIdleController)DeviceIdleController.this).mConstants.MIN_LIGHT_MAINTENANCE_TIME);
            }
        }
    };
    private final BroadcastReceiver mInteractivityReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.updateInteractivityLocked();
            }
        }
    };
    @VisibleForTesting
    final MotionListener mMotionListener = new MotionListener();
    private final LocationListener mGenericLocationListener = new LocationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationChanged(Location location) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.receivedGenericLocationLocked(location);
            }
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }
    };
    private final LocationListener mGpsLocationListener = new LocationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationChanged(Location location) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.receivedGpsLocationLocked(location);
            }
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }
    };
    private Constants mConstants;
    private static final int MSG_WRITE_CONFIG = 1;
    private static final int MSG_REPORT_IDLE_ON = 2;
    private static final int MSG_REPORT_IDLE_ON_LIGHT = 3;
    private static final int MSG_REPORT_IDLE_OFF = 4;
    private static final int MSG_REPORT_ACTIVE = 5;
    private static final int MSG_TEMP_APP_WHITELIST_TIMEOUT = 6;
    private static final int MSG_REPORT_MAINTENANCE_ACTIVITY = 7;
    private static final int MSG_FINISH_IDLE_OP = 8;
    private static final int MSG_REPORT_TEMP_APP_WHITELIST_CHANGED = 9;
    private static final int MSG_SEND_CONSTRAINT_MONITORING = 10;
    private static final int MSG_UPDATE_PRE_IDLE_TIMEOUT_FACTOR = 11;
    private static final int MSG_RESET_PRE_IDLE_TIMEOUT_FACTOR = 12;
    final MyHandler mHandler;
    BinderService mBinderService;
    private final Injector mInjector;
    private ActivityTaskManagerInternal.ScreenObserver mScreenObserver = new ActivityTaskManagerInternal.ScreenObserver(){

        @Override
        public void onAwakeStateChanged(boolean isAwake) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onKeyguardStateChanged(boolean isShowing) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.keyguardShowingLocked(isShowing);
            }
        }
    };

    @VisibleForTesting
    static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "ACTIVE";
            }
            case 1: {
                return "INACTIVE";
            }
            case 2: {
                return "IDLE_PENDING";
            }
            case 3: {
                return "SENSING";
            }
            case 4: {
                return "LOCATING";
            }
            case 5: {
                return "IDLE";
            }
            case 6: {
                return "IDLE_MAINTENANCE";
            }
            case 7: {
                return "QUICK_DOZE_DELAY";
            }
        }
        return Integer.toString(state);
    }

    @VisibleForTesting
    static String lightStateToString(int state) {
        switch (state) {
            case 0: {
                return "ACTIVE";
            }
            case 1: {
                return "INACTIVE";
            }
            case 3: {
                return "PRE_IDLE";
            }
            case 4: {
                return "IDLE";
            }
            case 5: {
                return "WAITING_FOR_NETWORK";
            }
            case 6: {
                return "IDLE_MAINTENANCE";
            }
            case 7: {
                return "OVERRIDE";
            }
        }
        return Integer.toString(state);
    }

    private void addEvent(int cmd, String reason) {
        if (this.mEventCmds[0] != cmd) {
            System.arraycopy(this.mEventCmds, 0, this.mEventCmds, 1, 99);
            System.arraycopy(this.mEventTimes, 0, this.mEventTimes, 1, 99);
            System.arraycopy(this.mEventReasons, 0, this.mEventReasons, 1, 99);
            this.mEventCmds[0] = cmd;
            this.mEventTimes[0] = SystemClock.elapsedRealtime();
            this.mEventReasons[0] = reason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAnyMotionResult(int result) {
        DeviceIdleController deviceIdleController;
        if (result != -1) {
            deviceIdleController = this;
            synchronized (deviceIdleController) {
                this.cancelSensingTimeoutAlarmLocked();
            }
        }
        if (result == 1 || result == -1) {
            deviceIdleController = this;
            synchronized (deviceIdleController) {
                this.handleMotionDetectedLocked(this.mConstants.INACTIVE_TIMEOUT, "non_stationary");
            }
        }
        if (result == 0) {
            if (this.mState == 3) {
                deviceIdleController = this;
                synchronized (deviceIdleController) {
                    this.mNotMoving = true;
                    this.stepIdleStateLocked("s:stationary");
                }
            }
            if (this.mState == 4) {
                deviceIdleController = this;
                synchronized (deviceIdleController) {
                    this.mNotMoving = true;
                    if (this.mLocated) {
                        this.stepIdleStateLocked("s:stationary");
                    }
                }
            }
        }
    }

    @VisibleForTesting
    DeviceIdleController(Context context, Injector injector) {
        super(context);
        this.mInjector = injector;
        this.mConfigFile = new AtomicFile(new File(DeviceIdleController.getSystemDir(), "deviceidle.xml"));
        this.mHandler = this.mInjector.getHandler(this);
        this.mAppStateTracker = this.mInjector.getAppStateTracker(context, FgThread.get().getLooper());
        LocalServices.addService(AppStateTracker.class, this.mAppStateTracker);
        this.mUseMotionSensor = this.mInjector.useMotionSensor();
    }

    public DeviceIdleController(Context context) {
        this(context, new Injector(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAppOnWhitelistInternal(int appid) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return Arrays.binarySearch(this.mPowerSaveWhitelistAllAppIdArray, appid) >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getPowerSaveWhitelistUserAppIds() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistUserAppIdArray;
        }
    }

    private static File getSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        PackageManager pm = this.getContext().getPackageManager();
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mLightEnabled = this.mDeepEnabled = this.getContext().getResources().getBoolean(17891432);
            SystemConfig sysConfig = SystemConfig.getInstance();
            ArraySet<String> allowPowerExceptIdle = sysConfig.getAllowInPowerSaveExceptIdle();
            for (int i = 0; i < allowPowerExceptIdle.size(); ++i) {
                String pkg = allowPowerExceptIdle.valueAt(i);
                try {
                    ApplicationInfo ai = pm.getApplicationInfo(pkg, 0x100000);
                    int appid = UserHandle.getAppId(ai.uid);
                    this.mPowerSaveWhitelistAppsExceptIdle.put(ai.packageName, appid);
                    this.mPowerSaveWhitelistSystemAppIdsExceptIdle.put(appid, true);
                    continue;
                }
                catch (PackageManager.NameNotFoundException ai) {
                    // empty catch block
                }
            }
            ArraySet<String> allowPower = sysConfig.getAllowInPowerSave();
            for (int i = 0; i < allowPower.size(); ++i) {
                String pkg = allowPower.valueAt(i);
                try {
                    ApplicationInfo ai = pm.getApplicationInfo(pkg, 0x100000);
                    int appid = UserHandle.getAppId(ai.uid);
                    this.mPowerSaveWhitelistAppsExceptIdle.put(ai.packageName, appid);
                    this.mPowerSaveWhitelistSystemAppIdsExceptIdle.put(appid, true);
                    this.mPowerSaveWhitelistApps.put(ai.packageName, appid);
                    this.mPowerSaveWhitelistSystemAppIds.put(appid, true);
                    continue;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            this.mConstants = this.mInjector.getConstants(this, this.mHandler, this.getContext().getContentResolver());
            this.readConfigFileLocked();
            this.updateWhitelistAppIdsLocked();
            this.mNetworkConnected = true;
            this.mScreenOn = true;
            this.mScreenLocked = false;
            this.mCharging = true;
            this.mActiveReason = 0;
            this.mState = 0;
            this.mLightState = 0;
            this.mInactiveTimeout = this.mConstants.INACTIVE_TIMEOUT;
            this.mPreIdleFactor = 1.0f;
            this.mLastPreIdleFactor = 1.0f;
        }
        this.mBinderService = new BinderService();
        this.publishBinderService("deviceidle", this.mBinderService);
        this.publishLocalService(LocalService.class, new LocalService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            DeviceIdleController deviceIdleController = this;
            synchronized (deviceIdleController) {
                this.mAlarmManager = this.mInjector.getAlarmManager();
                this.mLocalAlarmManager = this.getLocalService(AlarmManagerInternal.class);
                this.mBatteryStats = BatteryStatsService.getService();
                this.mLocalActivityManager = this.getLocalService(ActivityManagerInternal.class);
                this.mLocalActivityTaskManager = this.getLocalService(ActivityTaskManagerInternal.class);
                this.mLocalPowerManager = this.getLocalService(PowerManagerInternal.class);
                this.mPowerManager = this.mInjector.getPowerManager();
                this.mActiveIdleWakeLock = this.mPowerManager.newWakeLock(1, "deviceidle_maint");
                this.mActiveIdleWakeLock.setReferenceCounted(false);
                this.mGoingIdleWakeLock = this.mPowerManager.newWakeLock(1, "deviceidle_going_idle");
                this.mGoingIdleWakeLock.setReferenceCounted(true);
                this.mNetworkPolicyManager = INetworkPolicyManager.Stub.asInterface(ServiceManager.getService("netpolicy"));
                this.mNetworkPolicyManagerInternal = this.getLocalService(NetworkPolicyManagerInternal.class);
                this.mSensorManager = this.mInjector.getSensorManager();
                if (this.mUseMotionSensor) {
                    int sigMotionSensorId = this.getContext().getResources().getInteger(17694742);
                    if (sigMotionSensorId > 0) {
                        this.mMotionSensor = this.mSensorManager.getDefaultSensor(sigMotionSensorId, true);
                    }
                    if (this.mMotionSensor == null && this.getContext().getResources().getBoolean(17891363)) {
                        this.mMotionSensor = this.mSensorManager.getDefaultSensor(26, true);
                    }
                    if (this.mMotionSensor == null) {
                        this.mMotionSensor = this.mSensorManager.getDefaultSensor(17, true);
                    }
                }
                if (this.getContext().getResources().getBoolean(17891364)) {
                    this.mLocationRequest = new LocationRequest().setQuality(100).setInterval(0L).setFastestInterval(0L).setNumUpdates(1);
                }
                this.mConstraintController = this.mInjector.getConstraintController(this.mHandler, this.getLocalService(LocalService.class));
                if (this.mConstraintController != null) {
                    this.mConstraintController.start();
                }
                float angleThreshold = (float)this.getContext().getResources().getInteger(17694743) / 100.0f;
                this.mAnyMotionDetector = this.mInjector.getAnyMotionDetector(this.mHandler, this.mSensorManager, this, angleThreshold);
                this.mAppStateTracker.onSystemServicesReady();
                this.mIdleIntent = new Intent("android.os.action.DEVICE_IDLE_MODE_CHANGED");
                this.mIdleIntent.addFlags(0x50000000);
                this.mLightIdleIntent = new Intent("android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED");
                this.mLightIdleIntent.addFlags(0x50000000);
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.intent.action.BATTERY_CHANGED");
                this.getContext().registerReceiver(this.mReceiver, filter);
                filter = new IntentFilter();
                filter.addAction("android.intent.action.PACKAGE_REMOVED");
                filter.addDataScheme("package");
                this.getContext().registerReceiver(this.mReceiver, filter);
                filter = new IntentFilter();
                filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                this.getContext().registerReceiver(this.mReceiver, filter);
                filter = new IntentFilter();
                filter.addAction("android.intent.action.SCREEN_OFF");
                filter.addAction("android.intent.action.SCREEN_ON");
                this.getContext().registerReceiver(this.mInteractivityReceiver, filter);
                this.mLocalActivityManager.setDeviceIdleWhitelist(this.mPowerSaveWhitelistAllAppIdArray, this.mPowerSaveWhitelistExceptIdleAppIdArray);
                this.mLocalPowerManager.setDeviceIdleWhitelist(this.mPowerSaveWhitelistAllAppIdArray);
                this.mLocalPowerManager.registerLowPowerModeObserver(15, state -> {
                    DeviceIdleController deviceIdleController = this;
                    synchronized (deviceIdleController) {
                        this.updateQuickDozeFlagLocked(state.batterySaverEnabled);
                    }
                });
                this.updateQuickDozeFlagLocked(this.mLocalPowerManager.getLowPowerState((int)15).batterySaverEnabled);
                this.mLocalActivityTaskManager.registerScreenObserver(this.mScreenObserver);
                this.passWhiteListsToForceAppStandbyTrackerLocked();
                this.updateInteractivityLocked();
            }
            this.updateConnectivityState(null);
        }
    }

    @VisibleForTesting
    boolean hasMotionSensor() {
        return this.mUseMotionSensor && this.mMotionSensor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDeviceIdleConstraintInternal(IDeviceIdleConstraint constraint, String name, int type) {
        int minState;
        switch (type) {
            case 0: {
                minState = 0;
                break;
            }
            case 1: {
                minState = 3;
                break;
            }
            default: {
                Slog.wtf(TAG, "Registering device-idle constraint with invalid type: " + type);
                return;
            }
        }
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            if (this.mConstraints.containsKey(constraint)) {
                Slog.e(TAG, "Re-registering device-idle constraint: " + constraint + ".");
                return;
            }
            DeviceIdleConstraintTracker tracker = new DeviceIdleConstraintTracker(name, minState);
            this.mConstraints.put(constraint, tracker);
            this.updateActiveConstraintsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterDeviceIdleConstraintInternal(IDeviceIdleConstraint constraint) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.onConstraintStateChangedLocked(constraint, false);
            this.setConstraintMonitoringLocked(constraint, false);
            this.mConstraints.remove(constraint);
        }
    }

    @GuardedBy(value={"this"})
    private void onConstraintStateChangedLocked(IDeviceIdleConstraint constraint, boolean active) {
        DeviceIdleConstraintTracker tracker = this.mConstraints.get(constraint);
        if (tracker == null) {
            Slog.e(TAG, "device-idle constraint " + constraint + " has not been registered.");
            return;
        }
        if (active != tracker.active && tracker.monitoring) {
            tracker.active = active;
            this.mNumBlockingConstraints += tracker.active ? 1 : -1;
            if (this.mNumBlockingConstraints == 0) {
                if (this.mState == 0) {
                    this.becomeInactiveIfAppropriateLocked();
                } else if (this.mNextAlarmTime == 0L || this.mNextAlarmTime < SystemClock.elapsedRealtime()) {
                    this.stepIdleStateLocked("s:" + tracker.name);
                }
            }
        }
    }

    @GuardedBy(value={"this"})
    private void setConstraintMonitoringLocked(IDeviceIdleConstraint constraint, boolean monitor) {
        DeviceIdleConstraintTracker tracker = this.mConstraints.get(constraint);
        if (tracker.monitoring != monitor) {
            tracker.monitoring = monitor;
            this.updateActiveConstraintsLocked();
            this.mHandler.obtainMessage(10, monitor ? 1 : 0, -1, constraint).sendToTarget();
        }
    }

    @GuardedBy(value={"this"})
    private void updateActiveConstraintsLocked() {
        this.mNumBlockingConstraints = 0;
        for (int i = 0; i < this.mConstraints.size(); ++i) {
            boolean monitoring;
            IDeviceIdleConstraint constraint = this.mConstraints.keyAt(i);
            DeviceIdleConstraintTracker tracker = this.mConstraints.valueAt(i);
            boolean bl = monitoring = tracker.minState == this.mState;
            if (monitoring != tracker.monitoring) {
                this.setConstraintMonitoringLocked(constraint, monitoring);
                tracker.active = monitoring;
            }
            if (!tracker.monitoring || !tracker.active) continue;
            ++this.mNumBlockingConstraints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPowerSaveWhitelistAppInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            try {
                ApplicationInfo ai = this.getContext().getPackageManager().getApplicationInfo(name, 0x400000);
                if (this.mPowerSaveWhitelistUserApps.put(name, UserHandle.getAppId(ai.uid)) == null) {
                    this.reportPowerSaveWhitelistChangedLocked();
                    this.updateWhitelistAppIdsLocked();
                    this.writeConfigFileLocked();
                }
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePowerSaveWhitelistAppInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            if (this.mPowerSaveWhitelistUserApps.remove(name) != null) {
                this.reportPowerSaveWhitelistChangedLocked();
                this.updateWhitelistAppIdsLocked();
                this.writeConfigFileLocked();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPowerSaveWhitelistAppInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistUserApps.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetSystemPowerWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mPowerSaveWhitelistApps.putAll(this.mRemovedFromSystemWhitelistApps);
            this.mRemovedFromSystemWhitelistApps.clear();
            this.reportPowerSaveWhitelistChangedLocked();
            this.updateWhitelistAppIdsLocked();
            this.writeConfigFileLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restoreSystemPowerWhitelistAppInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            if (!this.mRemovedFromSystemWhitelistApps.containsKey(name)) {
                return false;
            }
            this.mPowerSaveWhitelistApps.put(name, this.mRemovedFromSystemWhitelistApps.remove(name));
            this.reportPowerSaveWhitelistChangedLocked();
            this.updateWhitelistAppIdsLocked();
            this.writeConfigFileLocked();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSystemPowerWhitelistAppInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            if (!this.mPowerSaveWhitelistApps.containsKey(name)) {
                return false;
            }
            this.mRemovedFromSystemWhitelistApps.put(name, this.mPowerSaveWhitelistApps.remove(name));
            this.reportPowerSaveWhitelistChangedLocked();
            this.updateWhitelistAppIdsLocked();
            this.writeConfigFileLocked();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPowerSaveWhitelistExceptIdleInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            try {
                ApplicationInfo ai = this.getContext().getPackageManager().getApplicationInfo(name, 0x400000);
                if (this.mPowerSaveWhitelistAppsExceptIdle.put(name, UserHandle.getAppId(ai.uid)) == null) {
                    this.mPowerSaveWhitelistUserAppsExceptIdle.add(name);
                    this.reportPowerSaveWhitelistChangedLocked();
                    this.mPowerSaveWhitelistExceptIdleAppIdArray = DeviceIdleController.buildAppIdArray(this.mPowerSaveWhitelistAppsExceptIdle, this.mPowerSaveWhitelistUserApps, this.mPowerSaveWhitelistExceptIdleAppIds);
                    this.passWhiteListsToForceAppStandbyTrackerLocked();
                }
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPowerSaveWhitelistExceptIdleInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            if (this.mPowerSaveWhitelistAppsExceptIdle.removeAll(this.mPowerSaveWhitelistUserAppsExceptIdle)) {
                this.reportPowerSaveWhitelistChangedLocked();
                this.mPowerSaveWhitelistExceptIdleAppIdArray = DeviceIdleController.buildAppIdArray(this.mPowerSaveWhitelistAppsExceptIdle, this.mPowerSaveWhitelistUserApps, this.mPowerSaveWhitelistExceptIdleAppIds);
                this.mPowerSaveWhitelistUserAppsExceptIdle.clear();
                this.passWhiteListsToForceAppStandbyTrackerLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPowerSaveWhitelistExceptIdleInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistAppsExceptIdle.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSystemPowerWhitelistExceptIdleInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size = this.mPowerSaveWhitelistAppsExceptIdle.size();
            String[] apps = new String[size];
            for (int i = 0; i < size; ++i) {
                apps[i] = this.mPowerSaveWhitelistAppsExceptIdle.keyAt(i);
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSystemPowerWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size = this.mPowerSaveWhitelistApps.size();
            String[] apps = new String[size];
            for (int i = 0; i < size; ++i) {
                apps[i] = this.mPowerSaveWhitelistApps.keyAt(i);
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRemovedSystemPowerWhitelistAppsInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size = this.mRemovedFromSystemWhitelistApps.size();
            String[] apps = new String[size];
            for (int i = 0; i < size; ++i) {
                apps[i] = this.mRemovedFromSystemWhitelistApps.keyAt(i);
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUserPowerWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size = this.mPowerSaveWhitelistUserApps.size();
            String[] apps = new String[size];
            for (int i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
                apps[i] = this.mPowerSaveWhitelistUserApps.keyAt(i);
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFullPowerWhitelistExceptIdleInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int i;
            int size = this.mPowerSaveWhitelistAppsExceptIdle.size() + this.mPowerSaveWhitelistUserApps.size();
            String[] apps = new String[size];
            int cur = 0;
            for (i = 0; i < this.mPowerSaveWhitelistAppsExceptIdle.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistAppsExceptIdle.keyAt(i);
                ++cur;
            }
            for (i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistUserApps.keyAt(i);
                ++cur;
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFullPowerWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int i;
            int size = this.mPowerSaveWhitelistApps.size() + this.mPowerSaveWhitelistUserApps.size();
            String[] apps = new String[size];
            int cur = 0;
            for (i = 0; i < this.mPowerSaveWhitelistApps.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistApps.keyAt(i);
                ++cur;
            }
            for (i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistUserApps.keyAt(i);
                ++cur;
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPowerSaveWhitelistExceptIdleAppInternal(String packageName) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistAppsExceptIdle.containsKey(packageName) || this.mPowerSaveWhitelistUserApps.containsKey(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPowerSaveWhitelistAppInternal(String packageName) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistApps.containsKey(packageName) || this.mPowerSaveWhitelistUserApps.containsKey(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdWhitelistExceptIdleInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistExceptIdleAppIdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistAllAppIdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdUserWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistUserAppIdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdTempWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mTempWhitelistAppIdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPowerSaveTempWhitelistAppChecked(String packageName, long duration, int userId, String reason) throws RemoteException {
        this.getContext().enforceCallingPermission("android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", "No permission to change device idle whitelist");
        int callingUid = Binder.getCallingUid();
        userId = ActivityManager.getService().handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, false, "addPowerSaveTempWhitelistApp", null);
        long token = Binder.clearCallingIdentity();
        try {
            this.addPowerSaveTempWhitelistAppInternal(callingUid, packageName, duration, userId, true, reason);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePowerSaveTempWhitelistAppChecked(String packageName, int userId) throws RemoteException {
        this.getContext().enforceCallingPermission("android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", "No permission to change device idle whitelist");
        int callingUid = Binder.getCallingUid();
        userId = ActivityManager.getService().handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, false, "removePowerSaveTempWhitelistApp", null);
        long token = Binder.clearCallingIdentity();
        try {
            this.removePowerSaveTempWhitelistAppInternal(packageName, userId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void addPowerSaveTempWhitelistAppInternal(int callingUid, String packageName, long duration, int userId, boolean sync, String reason) {
        try {
            int uid = this.getContext().getPackageManager().getPackageUidAsUser(packageName, userId);
            this.addPowerSaveTempWhitelistAppDirectInternal(callingUid, uid, duration, sync, reason);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPowerSaveTempWhitelistAppDirectInternal(int callingUid, int uid, long duration, boolean sync, String reason) {
        long timeNow = SystemClock.elapsedRealtime();
        boolean informWhitelistChanged = false;
        int appId = UserHandle.getAppId(uid);
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            boolean newEntry;
            int callingAppId = UserHandle.getAppId(callingUid);
            if (callingAppId >= 10000 && !this.mPowerSaveWhitelistSystemAppIds.get(callingAppId)) {
                throw new SecurityException("Calling app " + UserHandle.formatUid(callingUid) + " is not on whitelist");
            }
            duration = Math.min(duration, this.mConstants.MAX_TEMP_APP_WHITELIST_DURATION);
            Pair<MutableLong, String> entry = this.mTempWhitelistAppIdEndTimes.get(appId);
            boolean bl = newEntry = entry == null;
            if (newEntry) {
                entry = new Pair<MutableLong, String>(new MutableLong(0L), reason);
                this.mTempWhitelistAppIdEndTimes.put(appId, entry);
            }
            ((MutableLong)entry.first).value = timeNow + duration;
            if (newEntry) {
                try {
                    this.mBatteryStats.noteEvent(32785, reason, uid);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.postTempActiveTimeoutMessage(appId, duration);
                this.updateTempWhitelistAppIdsLocked(appId, true);
                if (sync) {
                    informWhitelistChanged = true;
                } else {
                    this.mHandler.obtainMessage(9, appId, 1).sendToTarget();
                }
                this.reportTempWhitelistChangedLocked();
            }
        }
        if (informWhitelistChanged) {
            this.mNetworkPolicyManagerInternal.onTempPowerSaveWhitelistChange(appId, true);
        }
    }

    private void removePowerSaveTempWhitelistAppInternal(String packageName, int userId) {
        try {
            int uid = this.getContext().getPackageManager().getPackageUidAsUser(packageName, userId);
            int appId = UserHandle.getAppId(uid);
            this.removePowerSaveTempWhitelistAppDirectInternal(appId);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePowerSaveTempWhitelistAppDirectInternal(int appId) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int idx = this.mTempWhitelistAppIdEndTimes.indexOfKey(appId);
            if (idx < 0) {
                return;
            }
            String reason = (String)this.mTempWhitelistAppIdEndTimes.valueAt((int)idx).second;
            this.mTempWhitelistAppIdEndTimes.removeAt(idx);
            this.onAppRemovedFromTempWhitelistLocked(appId, reason);
        }
    }

    private void postTempActiveTimeoutMessage(int appId, long delay) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(6, appId, 0), delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTempAppWhitelistTimeout(int appId) {
        long timeNow = SystemClock.elapsedRealtime();
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            Pair<MutableLong, String> entry = this.mTempWhitelistAppIdEndTimes.get(appId);
            if (entry == null) {
                return;
            }
            if (timeNow >= ((MutableLong)entry.first).value) {
                this.mTempWhitelistAppIdEndTimes.delete(appId);
                this.onAppRemovedFromTempWhitelistLocked(appId, (String)entry.second);
            } else {
                this.postTempActiveTimeoutMessage(appId, ((MutableLong)entry.first).value - timeNow);
            }
        }
    }

    @GuardedBy(value={"this"})
    private void onAppRemovedFromTempWhitelistLocked(int appId, String reason) {
        this.updateTempWhitelistAppIdsLocked(appId, false);
        this.mHandler.obtainMessage(9, appId, 0).sendToTarget();
        this.reportTempWhitelistChangedLocked();
        try {
            this.mBatteryStats.noteEvent(16401, reason, appId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitIdleInternal(String reason) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mActiveReason = 5;
            this.becomeActiveLocked(reason, Binder.getCallingUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isNetworkConnected() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mNetworkConnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConnectivityState(Intent connIntent) {
        ConnectivityService cm;
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            cm = this.mInjector.getConnectivityService();
        }
        if (cm == null) {
            return;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        DeviceIdleController deviceIdleController2 = this;
        synchronized (deviceIdleController2) {
            boolean conn;
            if (ni == null) {
                conn = false;
            } else if (connIntent == null) {
                conn = ni.isConnected();
            } else {
                int networkType = connIntent.getIntExtra("networkType", -1);
                if (ni.getType() != networkType) {
                    return;
                }
                boolean bl = conn = !connIntent.getBooleanExtra("noConnectivity", false);
            }
            if (conn != this.mNetworkConnected) {
                this.mNetworkConnected = conn;
                if (conn && this.mLightState == 5) {
                    this.stepLightIdleStateLocked("network");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isScreenOn() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mScreenOn;
        }
    }

    void updateInteractivityLocked() {
        boolean screenOn = this.mPowerManager.isInteractive();
        if (!screenOn && this.mScreenOn) {
            this.mScreenOn = false;
            if (!this.mForceIdle) {
                this.becomeInactiveIfAppropriateLocked();
            }
        } else if (screenOn) {
            this.mScreenOn = true;
            if (!(this.mForceIdle || this.mScreenLocked && this.mConstants.WAIT_FOR_UNLOCK)) {
                this.mActiveReason = 2;
                this.becomeActiveLocked("screen", Process.myUid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isCharging() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mCharging;
        }
    }

    void updateChargingLocked(boolean charging) {
        if (!charging && this.mCharging) {
            this.mCharging = false;
            if (!this.mForceIdle) {
                this.becomeInactiveIfAppropriateLocked();
            }
        } else if (charging) {
            this.mCharging = charging;
            if (!this.mForceIdle) {
                this.mActiveReason = 3;
                this.becomeActiveLocked("charging", Process.myUid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isQuickDozeEnabled() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mQuickDozeActivated;
        }
    }

    @VisibleForTesting
    void updateQuickDozeFlagLocked(boolean enabled) {
        this.mQuickDozeActivated = enabled;
        if (enabled) {
            this.becomeInactiveIfAppropriateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isKeyguardShowing() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mScreenLocked;
        }
    }

    @VisibleForTesting
    void keyguardShowingLocked(boolean showing) {
        if (this.mScreenLocked != showing) {
            this.mScreenLocked = showing;
            if (this.mScreenOn && !this.mForceIdle && !this.mScreenLocked) {
                this.mActiveReason = 4;
                this.becomeActiveLocked("unlocked", Process.myUid());
            }
        }
    }

    @VisibleForTesting
    void scheduleReportActiveLocked(String activeReason, int activeUid) {
        Message msg = this.mHandler.obtainMessage(5, activeUid, 0, activeReason);
        this.mHandler.sendMessage(msg);
    }

    void becomeActiveLocked(String activeReason, int activeUid) {
        this.becomeActiveLocked(activeReason, activeUid, this.mConstants.INACTIVE_TIMEOUT, true);
    }

    private void becomeActiveLocked(String activeReason, int activeUid, long newInactiveTimeout, boolean changeLightIdle) {
        if (this.mState != 0 || this.mLightState != 0) {
            EventLogTags.writeDeviceIdle(0, activeReason);
            this.mState = 0;
            this.mInactiveTimeout = newInactiveTimeout;
            this.mCurIdleBudget = 0L;
            this.mMaintenanceStartTime = 0L;
            this.resetIdleManagementLocked();
            if (changeLightIdle) {
                EventLogTags.writeDeviceIdleLight(0, activeReason);
                this.mLightState = 0;
                this.resetLightIdleManagementLocked();
                this.scheduleReportActiveLocked(activeReason, activeUid);
                this.addEvent(1, activeReason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setDeepEnabledForTest(boolean enabled) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mDeepEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setLightEnabledForTest(boolean enabled) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mLightEnabled = enabled;
        }
    }

    private void verifyAlarmStateLocked() {
        if (this.mState == 0 && this.mNextAlarmTime != 0L) {
            Slog.wtf(TAG, "mState=ACTIVE but mNextAlarmTime=" + this.mNextAlarmTime);
        }
        if (this.mState != 5 && this.mLocalAlarmManager.isIdling()) {
            Slog.wtf(TAG, "mState=" + DeviceIdleController.stateToString(this.mState) + " but AlarmManager is idling");
        }
        if (this.mState == 5 && !this.mLocalAlarmManager.isIdling()) {
            Slog.wtf(TAG, "mState=IDLE but AlarmManager is not idling");
        }
        if (this.mLightState == 0 && this.mNextLightAlarmTime != 0L) {
            Slog.wtf(TAG, "mLightState=ACTIVE but mNextLightAlarmTime is " + TimeUtils.formatDuration(this.mNextLightAlarmTime - SystemClock.elapsedRealtime()) + " from now");
        }
    }

    void becomeInactiveIfAppropriateLocked() {
        boolean isScreenBlockingInactive;
        this.verifyAlarmStateLocked();
        boolean bl = isScreenBlockingInactive = this.mScreenOn && (!this.mConstants.WAIT_FOR_UNLOCK || !this.mScreenLocked);
        if (!this.mForceIdle && (this.mCharging || isScreenBlockingInactive)) {
            return;
        }
        if (this.mDeepEnabled) {
            if (this.mQuickDozeActivated) {
                if (this.mState == 7 || this.mState == 5 || this.mState == 6) {
                    return;
                }
                this.mState = 7;
                this.resetIdleManagementLocked();
                this.scheduleAlarmLocked(this.mConstants.QUICK_DOZE_DELAY_TIMEOUT, false);
                EventLogTags.writeDeviceIdle(this.mState, "no activity");
            } else if (this.mState == 0) {
                this.mState = 1;
                this.resetIdleManagementLocked();
                long delay = this.mInactiveTimeout;
                if (this.shouldUseIdleTimeoutFactorLocked()) {
                    delay = (long)(this.mPreIdleFactor * (float)delay);
                }
                this.scheduleAlarmLocked(delay, false);
                EventLogTags.writeDeviceIdle(this.mState, "no activity");
            }
        }
        if (this.mLightState == 0 && this.mLightEnabled) {
            this.mLightState = 1;
            this.resetLightIdleManagementLocked();
            this.scheduleLightAlarmLocked(this.mConstants.LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT);
            EventLogTags.writeDeviceIdleLight(this.mLightState, "no activity");
        }
    }

    private void resetIdleManagementLocked() {
        this.mNextIdlePendingDelay = 0L;
        this.mNextIdleDelay = 0L;
        this.mNextLightIdleDelay = 0L;
        this.mIdleStartTime = 0L;
        this.cancelAlarmLocked();
        this.cancelSensingTimeoutAlarmLocked();
        this.cancelLocatingLocked();
        this.stopMonitoringMotionLocked();
        this.mAnyMotionDetector.stop();
        this.updateActiveConstraintsLocked();
    }

    private void resetLightIdleManagementLocked() {
        this.cancelLightAlarmLocked();
    }

    void exitForceIdleLocked() {
        if (this.mForceIdle) {
            this.mForceIdle = false;
            if (this.mScreenOn || this.mCharging) {
                this.mActiveReason = 6;
                this.becomeActiveLocked("exit-force", Process.myUid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setLightStateForTest(int lightState) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mLightState = lightState;
        }
    }

    @VisibleForTesting
    int getLightState() {
        return this.mLightState;
    }

    void stepLightIdleStateLocked(String reason) {
        if (this.mLightState == 7) {
            return;
        }
        EventLogTags.writeDeviceIdleLightStep();
        switch (this.mLightState) {
            case 1: {
                this.mCurIdleBudget = this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET;
                this.mNextLightIdleDelay = this.mConstants.LIGHT_IDLE_TIMEOUT;
                this.mMaintenanceStartTime = 0L;
                if (!this.isOpsInactiveLocked()) {
                    this.mLightState = 3;
                    EventLogTags.writeDeviceIdleLight(this.mLightState, reason);
                    this.scheduleLightAlarmLocked(this.mConstants.LIGHT_PRE_IDLE_TIMEOUT);
                    break;
                }
            }
            case 3: 
            case 6: {
                if (this.mMaintenanceStartTime != 0L) {
                    long duration = SystemClock.elapsedRealtime() - this.mMaintenanceStartTime;
                    this.mCurIdleBudget = duration < this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET ? (this.mCurIdleBudget += this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET - duration) : (this.mCurIdleBudget -= duration - this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET);
                }
                this.mMaintenanceStartTime = 0L;
                this.scheduleLightAlarmLocked(this.mNextLightIdleDelay);
                this.mNextLightIdleDelay = Math.min(this.mConstants.LIGHT_MAX_IDLE_TIMEOUT, (long)((float)this.mNextLightIdleDelay * this.mConstants.LIGHT_IDLE_FACTOR));
                if (this.mNextLightIdleDelay < this.mConstants.LIGHT_IDLE_TIMEOUT) {
                    this.mNextLightIdleDelay = this.mConstants.LIGHT_IDLE_TIMEOUT;
                }
                this.mLightState = 4;
                EventLogTags.writeDeviceIdleLight(this.mLightState, reason);
                this.addEvent(2, null);
                this.mGoingIdleWakeLock.acquire();
                this.mHandler.sendEmptyMessage(3);
                break;
            }
            case 4: 
            case 5: {
                if (this.mNetworkConnected || this.mLightState == 5) {
                    this.mActiveIdleOpCount = 1;
                    this.mActiveIdleWakeLock.acquire();
                    this.mMaintenanceStartTime = SystemClock.elapsedRealtime();
                    if (this.mCurIdleBudget < this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET) {
                        this.mCurIdleBudget = this.mConstants.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET;
                    } else if (this.mCurIdleBudget > this.mConstants.LIGHT_IDLE_MAINTENANCE_MAX_BUDGET) {
                        this.mCurIdleBudget = this.mConstants.LIGHT_IDLE_MAINTENANCE_MAX_BUDGET;
                    }
                    this.scheduleLightAlarmLocked(this.mCurIdleBudget);
                    this.mLightState = 6;
                    EventLogTags.writeDeviceIdleLight(this.mLightState, reason);
                    this.addEvent(3, null);
                    this.mHandler.sendEmptyMessage(4);
                    break;
                }
                this.scheduleLightAlarmLocked(this.mNextLightIdleDelay);
                this.mLightState = 5;
                EventLogTags.writeDeviceIdleLight(this.mLightState, reason);
            }
        }
    }

    @VisibleForTesting
    int getState() {
        return this.mState;
    }

    @VisibleForTesting
    void stepIdleStateLocked(String reason) {
        EventLogTags.writeDeviceIdleStep();
        long now = SystemClock.elapsedRealtime();
        if (now + this.mConstants.MIN_TIME_TO_ALARM > this.mAlarmManager.getNextWakeFromIdleTime()) {
            if (this.mState != 0) {
                this.mActiveReason = 7;
                this.becomeActiveLocked("alarm", Process.myUid());
                this.becomeInactiveIfAppropriateLocked();
            }
            return;
        }
        if (this.mNumBlockingConstraints != 0 && !this.mForceIdle) {
            return;
        }
        switch (this.mState) {
            case 1: {
                this.startMonitoringMotionLocked();
                long delay = this.mConstants.IDLE_AFTER_INACTIVE_TIMEOUT;
                if (this.shouldUseIdleTimeoutFactorLocked()) {
                    delay = (long)(this.mPreIdleFactor * (float)delay);
                }
                this.scheduleAlarmLocked(delay, false);
                this.moveToStateLocked(2, reason);
                break;
            }
            case 2: {
                this.moveToStateLocked(3, reason);
                this.cancelLocatingLocked();
                this.mLocated = false;
                this.mLastGenericLocation = null;
                this.mLastGpsLocation = null;
                this.updateActiveConstraintsLocked();
                if (this.mUseMotionSensor && this.mAnyMotionDetector.hasSensor()) {
                    this.scheduleSensingTimeoutAlarmLocked(this.mConstants.SENSING_TIMEOUT);
                    this.mNotMoving = false;
                    this.mAnyMotionDetector.checkForAnyMotion();
                    break;
                }
                if (this.mNumBlockingConstraints != 0) {
                    this.cancelAlarmLocked();
                    break;
                }
                this.mNotMoving = true;
            }
            case 3: {
                this.cancelSensingTimeoutAlarmLocked();
                this.moveToStateLocked(4, reason);
                this.scheduleAlarmLocked(this.mConstants.LOCATING_TIMEOUT, false);
                LocationManager locationManager = this.mInjector.getLocationManager();
                if (locationManager != null && locationManager.getProvider("network") != null) {
                    locationManager.requestLocationUpdates(this.mLocationRequest, this.mGenericLocationListener, this.mHandler.getLooper());
                    this.mLocating = true;
                } else {
                    this.mHasNetworkLocation = false;
                }
                if (locationManager != null && locationManager.getProvider("gps") != null) {
                    this.mHasGps = true;
                    locationManager.requestLocationUpdates("gps", 1000L, 5.0f, this.mGpsLocationListener, this.mHandler.getLooper());
                    this.mLocating = true;
                } else {
                    this.mHasGps = false;
                }
                if (this.mLocating) break;
            }
            case 4: {
                this.cancelAlarmLocked();
                this.cancelLocatingLocked();
                this.mAnyMotionDetector.stop();
            }
            case 7: {
                this.mNextIdlePendingDelay = this.mConstants.IDLE_PENDING_TIMEOUT;
                this.mNextIdleDelay = this.mConstants.IDLE_TIMEOUT;
            }
            case 6: {
                this.scheduleAlarmLocked(this.mNextIdleDelay, true);
                this.mNextIdleDelay = (long)((float)this.mNextIdleDelay * this.mConstants.IDLE_FACTOR);
                this.mIdleStartTime = SystemClock.elapsedRealtime();
                this.mNextIdleDelay = Math.min(this.mNextIdleDelay, this.mConstants.MAX_IDLE_TIMEOUT);
                if (this.mNextIdleDelay < this.mConstants.IDLE_TIMEOUT) {
                    this.mNextIdleDelay = this.mConstants.IDLE_TIMEOUT;
                }
                this.moveToStateLocked(5, reason);
                if (this.mLightState != 7) {
                    this.mLightState = 7;
                    this.cancelLightAlarmLocked();
                }
                this.addEvent(4, null);
                this.mGoingIdleWakeLock.acquire();
                this.mHandler.sendEmptyMessage(2);
                break;
            }
            case 5: {
                this.mActiveIdleOpCount = 1;
                this.mActiveIdleWakeLock.acquire();
                this.scheduleAlarmLocked(this.mNextIdlePendingDelay, false);
                this.mMaintenanceStartTime = SystemClock.elapsedRealtime();
                this.mNextIdlePendingDelay = Math.min(this.mConstants.MAX_IDLE_PENDING_TIMEOUT, (long)((float)this.mNextIdlePendingDelay * this.mConstants.IDLE_PENDING_FACTOR));
                if (this.mNextIdlePendingDelay < this.mConstants.IDLE_PENDING_TIMEOUT) {
                    this.mNextIdlePendingDelay = this.mConstants.IDLE_PENDING_TIMEOUT;
                }
                this.moveToStateLocked(6, reason);
                this.addEvent(5, null);
                this.mHandler.sendEmptyMessage(4);
            }
        }
    }

    private void moveToStateLocked(int state, String reason) {
        int oldState = this.mState;
        this.mState = state;
        EventLogTags.writeDeviceIdle(this.mState, reason);
        this.updateActiveConstraintsLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incActiveIdleOps() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            ++this.mActiveIdleOpCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decActiveIdleOps() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            --this.mActiveIdleOpCount;
            if (this.mActiveIdleOpCount <= 0) {
                this.exitMaintenanceEarlyIfNeededLocked();
                this.mActiveIdleWakeLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setActiveIdleOpsForTest(int count) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mActiveIdleOpCount = count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJobsActive(boolean active) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mJobsActive = active;
            this.reportMaintenanceActivityIfNeededLocked();
            if (!active) {
                this.exitMaintenanceEarlyIfNeededLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAlarmsActive(boolean active) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mAlarmsActive = active;
            if (!active) {
                this.exitMaintenanceEarlyIfNeededLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerMaintenanceActivityListener(IMaintenanceActivityListener listener) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mMaintenanceActivityListeners.register(listener);
            return this.mReportedMaintenanceActivity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterMaintenanceActivityListener(IMaintenanceActivityListener listener) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mMaintenanceActivityListeners.unregister(listener);
        }
    }

    @VisibleForTesting
    int setPreIdleTimeoutMode(int mode) {
        return this.setPreIdleTimeoutFactor(this.getPreIdleTimeoutByMode(mode));
    }

    @VisibleForTesting
    float getPreIdleTimeoutByMode(int mode) {
        switch (mode) {
            case 1: {
                return this.mConstants.PRE_IDLE_FACTOR_LONG;
            }
            case 2: {
                return this.mConstants.PRE_IDLE_FACTOR_SHORT;
            }
            case 0: {
                return 1.0f;
            }
        }
        Slog.w(TAG, "Invalid time out factor mode: " + mode);
        return 1.0f;
    }

    @VisibleForTesting
    float getPreIdleTimeoutFactor() {
        return this.mPreIdleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int setPreIdleTimeoutFactor(float ratio) {
        if (!this.mDeepEnabled) {
            return 2;
        }
        if (ratio <= 0.05f) {
            return 3;
        }
        if (Math.abs(ratio - this.mPreIdleFactor) < 0.05f) {
            return 0;
        }
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mLastPreIdleFactor = this.mPreIdleFactor;
            this.mPreIdleFactor = ratio;
        }
        this.postUpdatePreIdleFactor();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void resetPreIdleTimeoutMode() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mLastPreIdleFactor = this.mPreIdleFactor;
            this.mPreIdleFactor = 1.0f;
        }
        this.postResetPreIdleTimeoutFactor();
    }

    private void postUpdatePreIdleFactor() {
        this.mHandler.sendEmptyMessage(11);
    }

    private void postResetPreIdleTimeoutFactor() {
        this.mHandler.sendEmptyMessage(12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updatePreIdleFactor() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            if (!this.shouldUseIdleTimeoutFactorLocked()) {
                return;
            }
            if (this.mState == 1 || this.mState == 2) {
                if (this.mNextAlarmTime == 0L) {
                    return;
                }
                long delay = this.mNextAlarmTime - SystemClock.elapsedRealtime();
                if (delay < 60000L) {
                    return;
                }
                long newDelay = (long)((float)delay / this.mLastPreIdleFactor * this.mPreIdleFactor);
                if (Math.abs(delay - newDelay) < 60000L) {
                    return;
                }
                this.scheduleAlarmLocked(newDelay, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void maybeDoImmediateMaintenance() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            long duration;
            if (this.mState == 5 && (duration = SystemClock.elapsedRealtime() - this.mIdleStartTime) > this.mConstants.IDLE_TIMEOUT) {
                this.scheduleAlarmLocked(0L, false);
            }
        }
    }

    private boolean shouldUseIdleTimeoutFactorLocked() {
        return this.mActiveReason != 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setIdleStartTimeForTest(long idleStartTime) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mIdleStartTime = idleStartTime;
        }
    }

    void reportMaintenanceActivityIfNeededLocked() {
        boolean active = this.mJobsActive;
        if (active == this.mReportedMaintenanceActivity) {
            return;
        }
        this.mReportedMaintenanceActivity = active;
        Message msg = this.mHandler.obtainMessage(7, this.mReportedMaintenanceActivity ? 1 : 0, 0);
        this.mHandler.sendMessage(msg);
    }

    @VisibleForTesting
    long getNextAlarmTime() {
        return this.mNextAlarmTime;
    }

    boolean isOpsInactiveLocked() {
        return this.mActiveIdleOpCount <= 0 && !this.mJobsActive && !this.mAlarmsActive;
    }

    void exitMaintenanceEarlyIfNeededLocked() {
        if ((this.mState == 6 || this.mLightState == 6 || this.mLightState == 3) && this.isOpsInactiveLocked()) {
            long now = SystemClock.elapsedRealtime();
            if (this.mState == 6) {
                this.stepIdleStateLocked("s:early");
            } else if (this.mLightState == 3) {
                this.stepLightIdleStateLocked("s:predone");
            } else {
                this.stepLightIdleStateLocked("s:early");
            }
        }
    }

    void motionLocked() {
        this.handleMotionDetectedLocked(this.mConstants.MOTION_INACTIVE_TIMEOUT, "motion");
    }

    void handleMotionDetectedLocked(long timeout, String type) {
        boolean becomeInactive = this.mState != 0 || this.mLightState == 7;
        this.becomeActiveLocked(type, Process.myUid(), timeout, this.mLightState == 7);
        if (becomeInactive) {
            this.becomeInactiveIfAppropriateLocked();
        }
    }

    void receivedGenericLocationLocked(Location location) {
        if (this.mState != 4) {
            this.cancelLocatingLocked();
            return;
        }
        this.mLastGenericLocation = new Location(location);
        if (location.getAccuracy() > this.mConstants.LOCATION_ACCURACY && this.mHasGps) {
            return;
        }
        this.mLocated = true;
        if (this.mNotMoving) {
            this.stepIdleStateLocked("s:location");
        }
    }

    void receivedGpsLocationLocked(Location location) {
        if (this.mState != 4) {
            this.cancelLocatingLocked();
            return;
        }
        this.mLastGpsLocation = new Location(location);
        if (location.getAccuracy() > this.mConstants.LOCATION_ACCURACY) {
            return;
        }
        this.mLocated = true;
        if (this.mNotMoving) {
            this.stepIdleStateLocked("s:gps");
        }
    }

    void startMonitoringMotionLocked() {
        if (this.mMotionSensor != null && !this.mMotionListener.active) {
            this.mMotionListener.registerLocked();
        }
    }

    void stopMonitoringMotionLocked() {
        if (this.mMotionSensor != null && this.mMotionListener.active) {
            this.mMotionListener.unregisterLocked();
        }
    }

    void cancelAlarmLocked() {
        if (this.mNextAlarmTime != 0L) {
            this.mNextAlarmTime = 0L;
            this.mAlarmManager.cancel(this.mDeepAlarmListener);
        }
    }

    void cancelLightAlarmLocked() {
        if (this.mNextLightAlarmTime != 0L) {
            this.mNextLightAlarmTime = 0L;
            this.mAlarmManager.cancel(this.mLightAlarmListener);
        }
    }

    void cancelLocatingLocked() {
        if (this.mLocating) {
            LocationManager locationManager = this.mInjector.getLocationManager();
            locationManager.removeUpdates(this.mGenericLocationListener);
            locationManager.removeUpdates(this.mGpsLocationListener);
            this.mLocating = false;
        }
    }

    void cancelSensingTimeoutAlarmLocked() {
        if (this.mNextSensingTimeoutAlarmTime != 0L) {
            this.mNextSensingTimeoutAlarmTime = 0L;
            this.mAlarmManager.cancel(this.mSensingTimeoutAlarmListener);
        }
    }

    void scheduleAlarmLocked(long delay, boolean idleUntil) {
        if (this.mUseMotionSensor && this.mMotionSensor == null && this.mState != 7 && this.mState != 5 && this.mState != 6) {
            return;
        }
        this.mNextAlarmTime = SystemClock.elapsedRealtime() + delay;
        if (idleUntil) {
            this.mAlarmManager.setIdleUntil(2, this.mNextAlarmTime, "DeviceIdleController.deep", this.mDeepAlarmListener, this.mHandler);
        } else {
            this.mAlarmManager.set(2, this.mNextAlarmTime, "DeviceIdleController.deep", this.mDeepAlarmListener, this.mHandler);
        }
    }

    void scheduleLightAlarmLocked(long delay) {
        this.mNextLightAlarmTime = SystemClock.elapsedRealtime() + delay;
        this.mAlarmManager.set(2, this.mNextLightAlarmTime, "DeviceIdleController.light", this.mLightAlarmListener, this.mHandler);
    }

    void scheduleSensingTimeoutAlarmLocked(long delay) {
        this.mNextSensingTimeoutAlarmTime = SystemClock.elapsedRealtime() + delay;
        this.mAlarmManager.set(2, this.mNextSensingTimeoutAlarmTime, "DeviceIdleController.sensing", this.mSensingTimeoutAlarmListener, this.mHandler);
    }

    private static int[] buildAppIdArray(ArrayMap<String, Integer> systemApps, ArrayMap<String, Integer> userApps, SparseBooleanArray outAppIds) {
        int i;
        outAppIds.clear();
        if (systemApps != null) {
            for (i = 0; i < systemApps.size(); ++i) {
                outAppIds.put(systemApps.valueAt(i), true);
            }
        }
        if (userApps != null) {
            for (i = 0; i < userApps.size(); ++i) {
                outAppIds.put(userApps.valueAt(i), true);
            }
        }
        int size = outAppIds.size();
        int[] appids = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            appids[i2] = outAppIds.keyAt(i2);
        }
        return appids;
    }

    private void updateWhitelistAppIdsLocked() {
        this.mPowerSaveWhitelistExceptIdleAppIdArray = DeviceIdleController.buildAppIdArray(this.mPowerSaveWhitelistAppsExceptIdle, this.mPowerSaveWhitelistUserApps, this.mPowerSaveWhitelistExceptIdleAppIds);
        this.mPowerSaveWhitelistAllAppIdArray = DeviceIdleController.buildAppIdArray(this.mPowerSaveWhitelistApps, this.mPowerSaveWhitelistUserApps, this.mPowerSaveWhitelistAllAppIds);
        this.mPowerSaveWhitelistUserAppIdArray = DeviceIdleController.buildAppIdArray(null, this.mPowerSaveWhitelistUserApps, this.mPowerSaveWhitelistUserAppIds);
        if (this.mLocalActivityManager != null) {
            this.mLocalActivityManager.setDeviceIdleWhitelist(this.mPowerSaveWhitelistAllAppIdArray, this.mPowerSaveWhitelistExceptIdleAppIdArray);
        }
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.setDeviceIdleWhitelist(this.mPowerSaveWhitelistAllAppIdArray);
        }
        this.passWhiteListsToForceAppStandbyTrackerLocked();
    }

    private void updateTempWhitelistAppIdsLocked(int appId, boolean adding) {
        int size = this.mTempWhitelistAppIdEndTimes.size();
        if (this.mTempWhitelistAppIdArray.length != size) {
            this.mTempWhitelistAppIdArray = new int[size];
        }
        for (int i = 0; i < size; ++i) {
            this.mTempWhitelistAppIdArray[i] = this.mTempWhitelistAppIdEndTimes.keyAt(i);
        }
        if (this.mLocalActivityManager != null) {
            this.mLocalActivityManager.updateDeviceIdleTempWhitelist(this.mTempWhitelistAppIdArray, appId, adding);
        }
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.setDeviceIdleTempWhitelist(this.mTempWhitelistAppIdArray);
        }
        this.passWhiteListsToForceAppStandbyTrackerLocked();
    }

    private void reportPowerSaveWhitelistChangedLocked() {
        Intent intent = new Intent("android.os.action.POWER_SAVE_WHITELIST_CHANGED");
        intent.addFlags(0x40000000);
        this.getContext().sendBroadcastAsUser(intent, UserHandle.SYSTEM);
    }

    private void reportTempWhitelistChangedLocked() {
        Intent intent = new Intent("android.os.action.POWER_SAVE_TEMP_WHITELIST_CHANGED");
        intent.addFlags(0x40000000);
        this.getContext().sendBroadcastAsUser(intent, UserHandle.SYSTEM);
    }

    private void passWhiteListsToForceAppStandbyTrackerLocked() {
        this.mAppStateTracker.setPowerSaveWhitelistAppIds(this.mPowerSaveWhitelistExceptIdleAppIdArray, this.mPowerSaveWhitelistUserAppIdArray, this.mTempWhitelistAppIdArray);
    }

    void readConfigFileLocked() {
        FileInputStream stream;
        this.mPowerSaveWhitelistUserApps.clear();
        try {
            stream = this.mConfigFile.openRead();
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            this.readConfigFileLocked(parser);
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void readConfigFileLocked(XmlPullParser parser) {
        PackageManager pm = this.getContext().getPackageManager();
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new IllegalStateException("no start tag found");
            }
            int outerDepth = parser.getDepth();
            block18: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                String tagName;
                if (type == 3 || type == 4) continue;
                switch (tagName = parser.getName()) {
                    case "wl": {
                        String name = parser.getAttributeValue(null, "n");
                        if (name == null) continue block18;
                        try {
                            ApplicationInfo ai = pm.getApplicationInfo(name, 0x400000);
                            this.mPowerSaveWhitelistUserApps.put(ai.packageName, UserHandle.getAppId(ai.uid));
                        }
                        catch (PackageManager.NameNotFoundException ai) {}
                        continue block18;
                    }
                    case "un-wl": {
                        String packageName = parser.getAttributeValue(null, "n");
                        if (!this.mPowerSaveWhitelistApps.containsKey(packageName)) continue block18;
                        this.mRemovedFromSystemWhitelistApps.put(packageName, this.mPowerSaveWhitelistApps.remove(packageName));
                        continue block18;
                    }
                }
                Slog.w(TAG, "Unknown element under <config>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
    }

    void writeConfigFileLocked() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWriteConfigFile() {
        Object object;
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        try {
            object = this;
            synchronized (object) {
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(memStream, StandardCharsets.UTF_8.name());
                this.writeConfigFileLocked(out);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = this.mConfigFile;
        synchronized (object) {
            FileOutputStream stream = null;
            try {
                stream = this.mConfigFile.startWrite();
                memStream.writeTo(stream);
                stream.flush();
                FileUtils.sync(stream);
                stream.close();
                this.mConfigFile.finishWrite(stream);
            }
            catch (IOException e) {
                Slog.w(TAG, "Error writing config file", e);
                this.mConfigFile.failWrite(stream);
            }
        }
    }

    void writeConfigFileLocked(XmlSerializer out) throws IOException {
        int i;
        out.startDocument(null, true);
        out.startTag(null, "config");
        for (i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
            String name = this.mPowerSaveWhitelistUserApps.keyAt(i);
            out.startTag(null, "wl");
            out.attribute(null, "n", name);
            out.endTag(null, "wl");
        }
        for (i = 0; i < this.mRemovedFromSystemWhitelistApps.size(); ++i) {
            out.startTag(null, "un-wl");
            out.attribute(null, "n", this.mRemovedFromSystemWhitelistApps.keyAt(i));
            out.endTag(null, "un-wl");
        }
        out.endTag(null, "config");
        out.endDocument();
    }

    static void dumpHelp(PrintWriter pw) {
        pw.println("Device idle controller (deviceidle) commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("  step [light|deep]");
        pw.println("    Immediately step to next state, without waiting for alarm.");
        pw.println("  force-idle [light|deep]");
        pw.println("    Force directly into idle mode, regardless of other device state.");
        pw.println("  force-inactive");
        pw.println("    Force to be inactive, ready to freely step idle states.");
        pw.println("  unforce");
        pw.println("    Resume normal functioning after force-idle or force-inactive.");
        pw.println("  get [light|deep|force|screen|charging|network]");
        pw.println("    Retrieve the current given state.");
        pw.println("  disable [light|deep|all]");
        pw.println("    Completely disable device idle mode.");
        pw.println("  enable [light|deep|all]");
        pw.println("    Re-enable device idle mode after it had previously been disabled.");
        pw.println("  enabled [light|deep|all]");
        pw.println("    Print 1 if device idle mode is currently enabled, else 0.");
        pw.println("  whitelist");
        pw.println("    Print currently whitelisted apps.");
        pw.println("  whitelist [package ...]");
        pw.println("    Add (prefix with +) or remove (prefix with -) packages.");
        pw.println("  sys-whitelist [package ...|reset]");
        pw.println("    Prefix the package with '-' to remove it from the system whitelist or '+' to put it back in the system whitelist.");
        pw.println("    Note that only packages that were earlier removed from the system whitelist can be added back.");
        pw.println("    reset will reset the whitelist to the original state");
        pw.println("    Prints the system whitelist if no arguments are specified");
        pw.println("  except-idle-whitelist [package ...|reset]");
        pw.println("    Prefix the package with '+' to add it to whitelist or '=' to check if it is already whitelisted");
        pw.println("    [reset] will reset the whitelist to it's original state");
        pw.println("    Note that unlike <whitelist> cmd, changes made using this won't be persisted across boots");
        pw.println("  tempwhitelist");
        pw.println("    Print packages that are temporarily whitelisted.");
        pw.println("  tempwhitelist [-u USER] [-d DURATION] [-r] [package]");
        pw.println("    Temporarily place package in whitelist for DURATION milliseconds.");
        pw.println("    If no DURATION is specified, 10 seconds is used");
        pw.println("    If [-r] option is used, then the package is removed from temp whitelist and any [-d] is ignored");
        pw.println("  motion");
        pw.println("    Simulate a motion event to bring the device out of deep doze");
        pw.println("  pre-idle-factor [0|1|2]");
        pw.println("    Set a new factor to idle time before step to idle(inactive_to and idle_after_inactive_to)");
        pw.println("  reset-pre-idle-factor");
        pw.println("    Reset factor to idle time to default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    int onShellCommand(Shell shell, String cmd) {
        block176: {
            block179: {
                block178: {
                    block180: {
                        block177: {
                            pw = shell.getOutPrintWriter();
                            if ("step".equals(cmd)) {
                                this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                                var4_4 = this;
                                // MONITORENTER : var4_4
                                token = Binder.clearCallingIdentity();
                                arg = shell.getNextArg();
                                try {
                                    if (arg == null || "deep".equals(arg)) {
                                        this.stepIdleStateLocked("s:shell");
                                        pw.print("Stepped to deep: ");
                                        pw.println(DeviceIdleController.stateToString(this.mState));
                                        return 0;
                                    }
                                    if ("light".equals(arg)) {
                                        this.stepLightIdleStateLocked("s:shell");
                                        pw.print("Stepped to light: ");
                                        pw.println(DeviceIdleController.lightStateToString(this.mLightState));
                                        return 0;
                                    }
                                    pw.println("Unknown idle mode: " + arg);
                                    return 0;
                                }
                                finally {
                                    Binder.restoreCallingIdentity(token);
                                }
                            }
                            if (!"force-idle".equals(cmd)) ** GOTO lbl44
                            this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                            var4_5 = this;
                            // MONITORENTER : var4_5
                            token = Binder.clearCallingIdentity();
                            arg = shell.getNextArg();
                            if (arg != null && !"deep".equals(arg)) break block177;
                            if (!this.mDeepEnabled) {
                                pw.println("Unable to go deep idle; not enabled");
                                var8_45 = -1;
                                return var8_45;
                            }
                            break block178;
                        }
                        if (!"light".equals(arg)) {
                            pw.println("Unknown idle mode: " + arg);
                            return 0;
                        }
                        break block179;
                        finally {
                            Binder.restoreCallingIdentity(token);
                        }
lbl44:
                        // 1 sources

                        if ("force-inactive".equals(cmd)) {
                            this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                            var4_6 = this;
                            // MONITORENTER : var4_6
                            token = Binder.clearCallingIdentity();
                            try {
                                this.mForceIdle = true;
                                this.becomeInactiveIfAppropriateLocked();
                                pw.print("Light state: ");
                                pw.print(DeviceIdleController.lightStateToString(this.mLightState));
                                pw.print(", deep state: ");
                                pw.println(DeviceIdleController.stateToString(this.mState));
                                return 0;
                            }
                            finally {
                                Binder.restoreCallingIdentity(token);
                            }
                        }
                        if ("unforce".equals(cmd)) {
                            this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                            var4_7 = this;
                            // MONITORENTER : var4_7
                            token = Binder.clearCallingIdentity();
                            try {
                                this.exitForceIdleLocked();
                                pw.print("Light state: ");
                                pw.print(DeviceIdleController.lightStateToString(this.mLightState));
                                pw.print(", deep state: ");
                                pw.println(DeviceIdleController.stateToString(this.mState));
                                return 0;
                            }
                            finally {
                                Binder.restoreCallingIdentity(token);
                            }
                        }
                        if ("get".equals(cmd)) {
                            this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                            var4_8 = this;
                            // MONITORENTER : var4_8
                            arg = shell.getNextArg();
                            if (arg == null) {
                                pw.println("Argument required");
                                // MONITOREXIT : var4_8
                                return 0;
                            }
                            token = Binder.clearCallingIdentity();
                            try {
                                curLightState = arg;
                                var9_59 = -1;
                                switch (curLightState.hashCode()) {
                                    case 102970646: {
                                        if (!curLightState.equals("light")) break;
                                        var9_59 = 0;
                                        break;
                                    }
                                    case 3079404: {
                                        if (!curLightState.equals("deep")) break;
                                        var9_59 = 1;
                                        break;
                                    }
                                    case 97618667: {
                                        if (!curLightState.equals("force")) break;
                                        var9_59 = 2;
                                        break;
                                    }
                                    case 107947501: {
                                        if (!curLightState.equals("quick")) break;
                                        var9_59 = 3;
                                        break;
                                    }
                                    case -907689876: {
                                        if (!curLightState.equals("screen")) break;
                                        var9_59 = 4;
                                        break;
                                    }
                                    case 1436115569: {
                                        if (!curLightState.equals("charging")) break;
                                        var9_59 = 5;
                                        break;
                                    }
                                    case 1843485230: {
                                        if (!curLightState.equals("network")) break;
                                        var9_59 = 6;
                                        break;
                                    }
                                }
                                switch (var9_59) {
                                    case 0: {
                                        pw.println(DeviceIdleController.lightStateToString(this.mLightState));
                                        return 0;
                                    }
                                    case 1: {
                                        pw.println(DeviceIdleController.stateToString(this.mState));
                                        return 0;
                                    }
                                    case 2: {
                                        pw.println(this.mForceIdle);
                                        return 0;
                                    }
                                    case 3: {
                                        pw.println(this.mQuickDozeActivated);
                                        return 0;
                                    }
                                    case 4: {
                                        pw.println(this.mScreenOn);
                                        return 0;
                                    }
                                    case 5: {
                                        pw.println(this.mCharging);
                                        return 0;
                                    }
                                    case 6: {
                                        pw.println(this.mNetworkConnected);
                                        return 0;
                                    }
                                }
                                pw.println("Unknown get option: " + arg);
                                return 0;
                            }
                            finally {
                                Binder.restoreCallingIdentity(token);
                            }
                        }
                        if ("disable".equals(cmd)) {
                            this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                            var4_9 = this;
                            // MONITORENTER : var4_9
                            token = Binder.clearCallingIdentity();
                            arg = shell.getNextArg();
                            try {
                                becomeActive = false;
                                valid = false;
                                if (arg == null || "deep".equals(arg) || "all".equals(arg)) {
                                    valid = true;
                                    if (this.mDeepEnabled) {
                                        this.mDeepEnabled = false;
                                        becomeActive = true;
                                        pw.println("Deep idle mode disabled");
                                    }
                                }
                                if (arg == null || "light".equals(arg) || "all".equals(arg)) {
                                    valid = true;
                                    if (this.mLightEnabled) {
                                        this.mLightEnabled = false;
                                        becomeActive = true;
                                        pw.println("Light idle mode disabled");
                                    }
                                }
                                if (becomeActive) {
                                    this.mActiveReason = 6;
                                    this.becomeActiveLocked((arg == null ? "all" : arg) + "-disabled", Process.myUid());
                                }
                                if (valid) return 0;
                                pw.println("Unknown idle mode: " + arg);
                                return 0;
                            }
                            finally {
                                Binder.restoreCallingIdentity(token);
                            }
                        }
                        if ("enable".equals(cmd)) {
                            this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                            var4_10 = this;
                            // MONITORENTER : var4_10
                            token = Binder.clearCallingIdentity();
                            arg = shell.getNextArg();
                            try {
                                becomeInactive = false;
                                valid = false;
                                if (arg == null || "deep".equals(arg) || "all".equals(arg)) {
                                    valid = true;
                                    if (!this.mDeepEnabled) {
                                        this.mDeepEnabled = true;
                                        becomeInactive = true;
                                        pw.println("Deep idle mode enabled");
                                    }
                                }
                                if (arg == null || "light".equals(arg) || "all".equals(arg)) {
                                    valid = true;
                                    if (!this.mLightEnabled) {
                                        this.mLightEnabled = true;
                                        becomeInactive = true;
                                        pw.println("Light idle mode enable");
                                    }
                                }
                                if (becomeInactive) {
                                    this.becomeInactiveIfAppropriateLocked();
                                }
                                if (valid) return 0;
                                pw.println("Unknown idle mode: " + arg);
                                return 0;
                            }
                            finally {
                                Binder.restoreCallingIdentity(token);
                            }
                        }
                        if ("enabled".equals(cmd)) {
                            var4_11 = this;
                            // MONITORENTER : var4_11
                            arg = shell.getNextArg();
                            if (arg == null || "all".equals(arg)) {
                                pw.println(this.mDeepEnabled != false && this.mLightEnabled != false ? "1" : Integer.valueOf(0));
                                return 0;
                            }
                            if ("deep".equals(arg)) {
                                pw.println(this.mDeepEnabled != false ? "1" : Integer.valueOf(0));
                                return 0;
                            }
                            if (!"light".equals(arg)) {
                                pw.println("Unknown idle mode: " + arg);
                                // MONITOREXIT : var4_11
                                return 0;
                            }
                            pw.println(this.mLightEnabled != false ? "1" : Integer.valueOf(0));
                            return 0;
                        }
                        if (!"whitelist".equals(cmd)) break block180;
                        arg = shell.getNextArg();
                        if (arg != null) {
                            this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                            token = Binder.clearCallingIdentity();
                            ** try [egrp 18[TRYBLOCK] [38 : 1873->1943)] { 
lbl225:
                            // 1 sources

                        } else {
                            token = this;
                            // MONITORENTER : token
                            for (j = 0; j < this.mPowerSaveWhitelistAppsExceptIdle.size(); ++j) {
                                pw.print("system-excidle,");
                                pw.print(this.mPowerSaveWhitelistAppsExceptIdle.keyAt(j));
                                pw.print(",");
                                pw.println(this.mPowerSaveWhitelistAppsExceptIdle.valueAt(j));
                            }
                            for (j = 0; j < this.mPowerSaveWhitelistApps.size(); ++j) {
                                pw.print("system,");
                                pw.print(this.mPowerSaveWhitelistApps.keyAt(j));
                                pw.print(",");
                                pw.println(this.mPowerSaveWhitelistApps.valueAt(j));
                            }
                            j = 0;
                            while (true) {
                                if (j >= this.mPowerSaveWhitelistUserApps.size()) {
                                    // MONITOREXIT : token
                                    return 0;
                                }
                                pw.print("user,");
                                pw.print(this.mPowerSaveWhitelistUserApps.keyAt(j));
                                pw.print(",");
                                pw.println(this.mPowerSaveWhitelistUserApps.valueAt(j));
                                ++j;
                            }
                        }
                    }
                    if ("tempwhitelist".equals(cmd)) {
                        duration = 10000L;
                        removePkg = false;
                        break block176;
                    }
                    if ("except-idle-whitelist".equals(cmd)) {
                        this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                        token = Binder.clearCallingIdentity();
                        try {
                            arg = shell.getNextArg();
                            if (arg == null) {
                                pw.println("No arguments given");
                                opt = -1;
                                return opt;
                            }
                            if ("reset".equals(arg)) {
                                this.resetPowerSaveWhitelistExceptIdleInternal();
                                return 0;
                            }
                            do {
                                if (arg.length() < 1 || arg.charAt(0) != '-' && arg.charAt(0) != '+' && arg.charAt(0) != '=') {
                                    pw.println("Package must be prefixed with +, -, or =: " + arg);
                                    opt = -1;
                                    return opt;
                                }
                                op = arg.charAt(0);
                                pkg = arg.substring(1);
                                if (op == '+') {
                                    if (this.addPowerSaveWhitelistExceptIdleInternal(pkg)) {
                                        pw.println("Added: " + pkg);
                                        continue;
                                    }
                                    pw.println("Unknown package: " + pkg);
                                    continue;
                                }
                                if (op != '=') {
                                    pw.println("Unknown argument: " + arg);
                                    e = -1;
                                    return e;
                                }
                                pw.println(this.getPowerSaveWhitelistExceptIdleInternal(pkg));
                            } while ((arg = shell.getNextArg()) != null);
                            return 0;
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                        }
                    }
                    if ("sys-whitelist".equals(cmd)) {
                        arg = shell.getNextArg();
                        if (arg != null) {
                            this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                            token = Binder.clearCallingIdentity();
                            try {
                                if ("reset".equals(arg)) {
                                    this.resetSystemPowerWhitelistInternal();
                                    return 0;
                                }
                                block103: do {
                                    if (arg.length() < 1 || arg.charAt(0) != '-' && arg.charAt(0) != '+') {
                                        pw.println("Package must be prefixed with + or - " + arg);
                                        op = -1;
                                        return op;
                                    }
                                    op = arg.charAt(0);
                                    pkg = arg.substring(1);
                                    switch (op) {
                                        case 43: {
                                            if (!this.restoreSystemPowerWhitelistAppInternal(pkg)) continue block103;
                                            pw.println("Restored " + pkg);
                                            break;
                                        }
                                        case 45: {
                                            if (!this.removeSystemPowerWhitelistAppInternal(pkg)) continue block103;
                                            pw.println("Removed " + pkg);
                                            break;
                                        }
                                    }
                                } while ((arg = shell.getNextArg()) != null);
                                return 0;
                            }
                            finally {
                                Binder.restoreCallingIdentity(token);
                            }
                        }
                        token = this;
                        // MONITORENTER : token
                        j = 0;
                        while (true) {
                            if (j >= this.mPowerSaveWhitelistApps.size()) {
                                // MONITOREXIT : token
                                return 0;
                            }
                            pw.print(this.mPowerSaveWhitelistApps.keyAt(j));
                            pw.print(",");
                            pw.println(this.mPowerSaveWhitelistApps.valueAt(j));
                            ++j;
                        }
                    }
                    if ("motion".equals(cmd)) {
                        this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                        var4_16 = this;
                        // MONITORENTER : var4_16
                        token = Binder.clearCallingIdentity();
                        try {
                            this.motionLocked();
                            pw.print("Light state: ");
                            pw.print(DeviceIdleController.lightStateToString(this.mLightState));
                            pw.print(", deep state: ");
                            pw.println(DeviceIdleController.stateToString(this.mState));
                            return 0;
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                        }
                    }
                    if ("pre-idle-factor".equals(cmd)) {
                        this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                        var4_17 = this;
                        // MONITORENTER : var4_17
                        token = Binder.clearCallingIdentity();
                        ret = -1;
                        try {
                            arg = shell.getNextArg();
                            valid = false;
                            mode = 0;
                            if (arg != null) {
                                mode = Integer.parseInt(arg);
                                ret = this.setPreIdleTimeoutMode(mode);
                                if (ret == 1) {
                                    pw.println("pre-idle-factor: " + mode);
                                    valid = true;
                                } else if (ret == 2) {
                                    valid = true;
                                    pw.println("Deep idle not supported");
                                } else if (ret == 0) {
                                    valid = true;
                                    pw.println("Idle timeout factor not changed");
                                }
                            }
                            if (valid) return 0;
                            pw.println("Unknown idle timeout factor: " + arg + ",(error code: " + ret + ")");
                            return 0;
                        }
                        catch (NumberFormatException e) {
                            pw.println("Unknown idle timeout factor,(error code: " + ret + ")");
                            return 0;
                        }
                        finally {
                            Binder.restoreCallingIdentity(token);
                        }
                    }
                    if ("reset-pre-idle-factor".equals(cmd) == false) return shell.handleDefaultCommands(cmd);
                    this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                    var4_18 = this;
                    // MONITORENTER : var4_18
                    token = Binder.clearCallingIdentity();
                    try {
                        this.resetPreIdleTimeoutMode();
                        return 0;
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
                this.mForceIdle = true;
                this.becomeInactiveIfAppropriateLocked();
                curState = this.mState;
                while (true) {
                    if (curState == 5) {
                        pw.println("Now forced in to deep idle mode");
                        return 0;
                    }
                    this.stepIdleStateLocked("s:shell");
                    if (curState == this.mState) {
                        pw.print("Unable to go deep idle; stopped at ");
                        pw.println(DeviceIdleController.stateToString(this.mState));
                        this.exitForceIdleLocked();
                        var9_57 = -1;
                        return var9_57;
                    }
                    curState = this.mState;
                }
            }
            this.mForceIdle = true;
            this.becomeInactiveIfAppropriateLocked();
            curLightState = this.mLightState;
            while (true) {
                if (curLightState == 4) {
                    pw.println("Now forced in to light idle mode");
                    return 0;
                }
                this.stepLightIdleStateLocked("s:shell");
                if (curLightState == this.mLightState) {
                    pw.print("Unable to go light idle; stopped at ");
                    pw.println(DeviceIdleController.lightStateToString(this.mLightState));
                    this.exitForceIdleLocked();
                    var9_58 = -1;
                    return var9_58;
                }
                curLightState = this.mLightState;
            }
            {
                do {
                    if (arg.length() < 1 || arg.charAt(0) != '-' && arg.charAt(0) != '+' && arg.charAt(0) != '=') {
                        pw.println("Package must be prefixed with +, -, or =: " + arg);
                        arg = -1;
                        return arg;
                    }
                    op = arg.charAt(0);
                    pkg = arg.substring(1);
                    if (op == '+') {
                        if (this.addPowerSaveWhitelistAppInternal(pkg)) {
                            pw.println("Added: " + pkg);
                            continue;
                        }
                        pw.println("Unknown package: " + pkg);
                        continue;
                    }
                    if (op == '-') {
                        if (!this.removePowerSaveWhitelistAppInternal(pkg)) continue;
                        pw.println("Removed: " + pkg);
                        continue;
                    }
                    pw.println(this.getPowerSaveWhitelistAppInternal(pkg));
                } while ((arg = shell.getNextArg()) != null);
                return 0;
            }
lbl446:
            // 1 sources

            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
        while ((opt = shell.getNextOption()) != null) {
            if ("-u".equals(opt)) {
                opt = shell.getNextArg();
                if (opt == null) {
                    pw.println("-u requires a user number");
                    return -1;
                }
                shell.userId = Integer.parseInt(opt);
                continue;
            }
            if ("-d".equals(opt)) {
                opt = shell.getNextArg();
                if (opt == null) {
                    pw.println("-d requires a duration");
                    return -1;
                }
                duration = Long.parseLong(opt);
                continue;
            }
            if (!"-r".equals(opt)) continue;
            removePkg = true;
        }
        arg = shell.getNextArg();
        if (arg != null) {
            try {
                if (removePkg) {
                    this.removePowerSaveTempWhitelistAppChecked(arg, shell.userId);
                    return 0;
                }
                this.addPowerSaveTempWhitelistAppChecked(arg, duration, shell.userId, "shell");
                return 0;
            }
            catch (Exception e) {
                pw.println("Failed: " + e);
                return -1;
            }
        }
        if (removePkg) {
            pw.println("[-r] requires a package name");
            return -1;
        }
        this.dumpTempWhitelistSchedule(pw, false);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.getContext(), TAG, pw)) {
            return;
        }
        if (args != null) {
            int userId = 0;
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("-h".equals(arg)) {
                    DeviceIdleController.dumpHelp(pw);
                    return;
                }
                if ("-u".equals(arg)) {
                    if (++i >= args.length) continue;
                    arg = args[i];
                    userId = Integer.parseInt(arg);
                    continue;
                }
                if ("-a".equals(arg)) continue;
                if (arg.length() > 0 && arg.charAt(0) == '-') {
                    pw.println("Unknown option: " + arg);
                    return;
                }
                Shell shell = new Shell();
                shell.userId = userId;
                String[] newArgs = new String[args.length - i];
                System.arraycopy(args, i, newArgs, 0, args.length - i);
                shell.exec(this.mBinderService, null, fd, null, newArgs, null, new ResultReceiver(null));
                return;
            }
        }
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size;
            this.mConstants.dump(pw);
            if (this.mEventCmds[0] != 0) {
                pw.println("  Idling history:");
                long now = SystemClock.elapsedRealtime();
                for (int i = 99; i >= 0; --i) {
                    String label;
                    int cmd = this.mEventCmds[i];
                    if (cmd == 0) continue;
                    switch (this.mEventCmds[i]) {
                        case 1: {
                            label = "     normal";
                            break;
                        }
                        case 2: {
                            label = " light-idle";
                            break;
                        }
                        case 3: {
                            label = "light-maint";
                            break;
                        }
                        case 4: {
                            label = "  deep-idle";
                            break;
                        }
                        case 5: {
                            label = " deep-maint";
                            break;
                        }
                        default: {
                            label = "         ??";
                        }
                    }
                    pw.print("    ");
                    pw.print(label);
                    pw.print(": ");
                    TimeUtils.formatDuration(this.mEventTimes[i], now, pw);
                    if (this.mEventReasons[i] != null) {
                        pw.print(" (");
                        pw.print(this.mEventReasons[i]);
                        pw.print(")");
                    }
                    pw.println();
                }
            }
            if ((size = this.mPowerSaveWhitelistAppsExceptIdle.size()) > 0) {
                pw.println("  Whitelist (except idle) system apps:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.println(this.mPowerSaveWhitelistAppsExceptIdle.keyAt(i));
                }
            }
            if ((size = this.mPowerSaveWhitelistApps.size()) > 0) {
                pw.println("  Whitelist system apps:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.println(this.mPowerSaveWhitelistApps.keyAt(i));
                }
            }
            if ((size = this.mRemovedFromSystemWhitelistApps.size()) > 0) {
                pw.println("  Removed from whitelist system apps:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.println(this.mRemovedFromSystemWhitelistApps.keyAt(i));
                }
            }
            if ((size = this.mPowerSaveWhitelistUserApps.size()) > 0) {
                pw.println("  Whitelist user apps:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.println(this.mPowerSaveWhitelistUserApps.keyAt(i));
                }
            }
            if ((size = this.mPowerSaveWhitelistExceptIdleAppIds.size()) > 0) {
                pw.println("  Whitelist (except idle) all app ids:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.print(this.mPowerSaveWhitelistExceptIdleAppIds.keyAt(i));
                    pw.println();
                }
            }
            if ((size = this.mPowerSaveWhitelistUserAppIds.size()) > 0) {
                pw.println("  Whitelist user app ids:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.print(this.mPowerSaveWhitelistUserAppIds.keyAt(i));
                    pw.println();
                }
            }
            if ((size = this.mPowerSaveWhitelistAllAppIds.size()) > 0) {
                pw.println("  Whitelist all app ids:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.print(this.mPowerSaveWhitelistAllAppIds.keyAt(i));
                    pw.println();
                }
            }
            this.dumpTempWhitelistSchedule(pw, true);
            int n = size = this.mTempWhitelistAppIdArray != null ? this.mTempWhitelistAppIdArray.length : 0;
            if (size > 0) {
                pw.println("  Temp whitelist app ids:");
                for (int i = 0; i < size; ++i) {
                    pw.print("    ");
                    pw.print(this.mTempWhitelistAppIdArray[i]);
                    pw.println();
                }
            }
            pw.print("  mLightEnabled=");
            pw.print(this.mLightEnabled);
            pw.print("  mDeepEnabled=");
            pw.println(this.mDeepEnabled);
            pw.print("  mForceIdle=");
            pw.println(this.mForceIdle);
            pw.print("  mUseMotionSensor=");
            pw.print(this.mUseMotionSensor);
            if (this.mUseMotionSensor) {
                pw.print(" mMotionSensor=");
                pw.println(this.mMotionSensor);
            } else {
                pw.println();
            }
            pw.print("  mScreenOn=");
            pw.println(this.mScreenOn);
            pw.print("  mScreenLocked=");
            pw.println(this.mScreenLocked);
            pw.print("  mNetworkConnected=");
            pw.println(this.mNetworkConnected);
            pw.print("  mCharging=");
            pw.println(this.mCharging);
            if (this.mConstraints.size() != 0) {
                pw.println("  mConstraints={");
                for (int i = 0; i < this.mConstraints.size(); ++i) {
                    DeviceIdleConstraintTracker tracker = this.mConstraints.valueAt(i);
                    pw.print("    \"");
                    pw.print(tracker.name);
                    pw.print("\"=");
                    if (tracker.minState == this.mState) {
                        pw.println(tracker.active);
                        continue;
                    }
                    pw.print("ignored <mMinState=");
                    pw.print(DeviceIdleController.stateToString(tracker.minState));
                    pw.println(">");
                }
                pw.println("  }");
            }
            if (this.mUseMotionSensor) {
                pw.print("  mMotionActive=");
                pw.println(this.mMotionListener.active);
                pw.print("  mNotMoving=");
                pw.println(this.mNotMoving);
            }
            pw.print("  mLocating=");
            pw.print(this.mLocating);
            pw.print(" mHasGps=");
            pw.print(this.mHasGps);
            pw.print(" mHasNetwork=");
            pw.print(this.mHasNetworkLocation);
            pw.print(" mLocated=");
            pw.println(this.mLocated);
            if (this.mLastGenericLocation != null) {
                pw.print("  mLastGenericLocation=");
                pw.println(this.mLastGenericLocation);
            }
            if (this.mLastGpsLocation != null) {
                pw.print("  mLastGpsLocation=");
                pw.println(this.mLastGpsLocation);
            }
            pw.print("  mState=");
            pw.print(DeviceIdleController.stateToString(this.mState));
            pw.print(" mLightState=");
            pw.println(DeviceIdleController.lightStateToString(this.mLightState));
            pw.print("  mInactiveTimeout=");
            TimeUtils.formatDuration(this.mInactiveTimeout, pw);
            pw.println();
            if (this.mActiveIdleOpCount != 0) {
                pw.print("  mActiveIdleOpCount=");
                pw.println(this.mActiveIdleOpCount);
            }
            if (this.mNextAlarmTime != 0L) {
                pw.print("  mNextAlarmTime=");
                TimeUtils.formatDuration(this.mNextAlarmTime, SystemClock.elapsedRealtime(), pw);
                pw.println();
            }
            if (this.mNextIdlePendingDelay != 0L) {
                pw.print("  mNextIdlePendingDelay=");
                TimeUtils.formatDuration(this.mNextIdlePendingDelay, pw);
                pw.println();
            }
            if (this.mNextIdleDelay != 0L) {
                pw.print("  mNextIdleDelay=");
                TimeUtils.formatDuration(this.mNextIdleDelay, pw);
                pw.println();
            }
            if (this.mNextLightIdleDelay != 0L) {
                pw.print("  mNextIdleDelay=");
                TimeUtils.formatDuration(this.mNextLightIdleDelay, pw);
                pw.println();
            }
            if (this.mNextLightAlarmTime != 0L) {
                pw.print("  mNextLightAlarmTime=");
                TimeUtils.formatDuration(this.mNextLightAlarmTime, SystemClock.elapsedRealtime(), pw);
                pw.println();
            }
            if (this.mCurIdleBudget != 0L) {
                pw.print("  mCurIdleBudget=");
                TimeUtils.formatDuration(this.mCurIdleBudget, pw);
                pw.println();
            }
            if (this.mMaintenanceStartTime != 0L) {
                pw.print("  mMaintenanceStartTime=");
                TimeUtils.formatDuration(this.mMaintenanceStartTime, SystemClock.elapsedRealtime(), pw);
                pw.println();
            }
            if (this.mJobsActive) {
                pw.print("  mJobsActive=");
                pw.println(this.mJobsActive);
            }
            if (this.mAlarmsActive) {
                pw.print("  mAlarmsActive=");
                pw.println(this.mAlarmsActive);
            }
            if (Math.abs(this.mPreIdleFactor - 1.0f) > 0.05f) {
                pw.print("  mPreIdleFactor=");
                pw.println(this.mPreIdleFactor);
            }
        }
    }

    void dumpTempWhitelistSchedule(PrintWriter pw, boolean printTitle) {
        int size = this.mTempWhitelistAppIdEndTimes.size();
        if (size > 0) {
            String prefix = "";
            if (printTitle) {
                pw.println("  Temp whitelist schedule:");
                prefix = "    ";
            }
            long timeNow = SystemClock.elapsedRealtime();
            for (int i = 0; i < size; ++i) {
                pw.print(prefix);
                pw.print("UID=");
                pw.print(this.mTempWhitelistAppIdEndTimes.keyAt(i));
                pw.print(": ");
                Pair<MutableLong, String> entry = this.mTempWhitelistAppIdEndTimes.valueAt(i);
                TimeUtils.formatDuration(((MutableLong)entry.first).value, timeNow, pw);
                pw.print(" - ");
                pw.println((String)entry.second);
            }
        }
    }

    private static /* synthetic */ String lambda$stepIdleStateLocked$2(DeviceIdleConstraintTracker x) {
        return x.name;
    }

    private static /* synthetic */ boolean lambda$stepIdleStateLocked$1(DeviceIdleConstraintTracker x) {
        return x.active;
    }

    class Shell
    extends ShellCommand {
        int userId = 0;

        Shell() {
        }

        @Override
        public int onCommand(String cmd) {
            return DeviceIdleController.this.onShellCommand(this, cmd);
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            DeviceIdleController.dumpHelp(pw);
        }
    }

    static class Injector {
        private final Context mContext;
        private ConnectivityService mConnectivityService;
        private Constants mConstants;
        private LocationManager mLocationManager;

        Injector(Context ctx) {
            this.mContext = ctx;
        }

        AlarmManager getAlarmManager() {
            return this.mContext.getSystemService(AlarmManager.class);
        }

        AnyMotionDetector getAnyMotionDetector(Handler handler, SensorManager sm, AnyMotionDetector.DeviceIdleCallback callback, float angleThreshold) {
            return new AnyMotionDetector(this.getPowerManager(), handler, sm, callback, angleThreshold);
        }

        AppStateTracker getAppStateTracker(Context ctx, Looper looper) {
            return new AppStateTracker(ctx, looper);
        }

        ConnectivityService getConnectivityService() {
            if (this.mConnectivityService == null) {
                this.mConnectivityService = (ConnectivityService)ServiceManager.getService("connectivity");
            }
            return this.mConnectivityService;
        }

        Constants getConstants(DeviceIdleController controller, Handler handler, ContentResolver resolver) {
            if (this.mConstants == null) {
                DeviceIdleController deviceIdleController = controller;
                Objects.requireNonNull(deviceIdleController);
                this.mConstants = deviceIdleController.new Constants(handler, resolver);
            }
            return this.mConstants;
        }

        LocationManager getLocationManager() {
            if (this.mLocationManager == null) {
                this.mLocationManager = this.mContext.getSystemService(LocationManager.class);
            }
            return this.mLocationManager;
        }

        MyHandler getHandler(DeviceIdleController controller) {
            DeviceIdleController deviceIdleController = controller;
            Objects.requireNonNull(deviceIdleController);
            return deviceIdleController.new MyHandler(BackgroundThread.getHandler().getLooper());
        }

        PowerManager getPowerManager() {
            return this.mContext.getSystemService(PowerManager.class);
        }

        SensorManager getSensorManager() {
            return this.mContext.getSystemService(SensorManager.class);
        }

        ConstraintController getConstraintController(Handler handler, LocalService localService) {
            if (this.mContext.getPackageManager().hasSystemFeature("android.software.leanback_only")) {
                return new TvConstraintController(this.mContext, handler);
            }
            return null;
        }

        boolean useMotionSensor() {
            return this.mContext.getResources().getBoolean(17891365);
        }
    }

    public class LocalService {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConstraintStateChanged(IDeviceIdleConstraint constraint, boolean active) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.onConstraintStateChangedLocked(constraint, active);
            }
        }

        public void registerDeviceIdleConstraint(IDeviceIdleConstraint constraint, String name, int minState) {
            DeviceIdleController.this.registerDeviceIdleConstraintInternal(constraint, name, minState);
        }

        public void unregisterDeviceIdleConstraint(IDeviceIdleConstraint constraint) {
            DeviceIdleController.this.unregisterDeviceIdleConstraintInternal(constraint);
        }

        public void exitIdle(String reason) {
            DeviceIdleController.this.exitIdleInternal(reason);
        }

        public void addPowerSaveTempWhitelistApp(int callingUid, String packageName, long duration, int userId, boolean sync, String reason) {
            DeviceIdleController.this.addPowerSaveTempWhitelistAppInternal(callingUid, packageName, duration, userId, sync, reason);
        }

        public void addPowerSaveTempWhitelistAppDirect(int uid, long duration, boolean sync, String reason) {
            DeviceIdleController.this.addPowerSaveTempWhitelistAppDirectInternal(0, uid, duration, sync, reason);
        }

        public long getNotificationWhitelistDuration() {
            return ((DeviceIdleController)DeviceIdleController.this).mConstants.NOTIFICATION_WHITELIST_DURATION;
        }

        public void setJobsActive(boolean active) {
            DeviceIdleController.this.setJobsActive(active);
        }

        public void setAlarmsActive(boolean active) {
            DeviceIdleController.this.setAlarmsActive(active);
        }

        public boolean isAppOnWhitelist(int appid) {
            return DeviceIdleController.this.isAppOnWhitelistInternal(appid);
        }

        public int[] getPowerSaveWhitelistUserAppIds() {
            return DeviceIdleController.this.getPowerSaveWhitelistUserAppIds();
        }

        public int[] getPowerSaveTempWhitelistAppIds() {
            return DeviceIdleController.this.getAppIdTempWhitelistInternal();
        }
    }

    private final class BinderService
    extends IDeviceIdleController.Stub {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPowerSaveWhitelistApp(String name) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                DeviceIdleController.this.addPowerSaveWhitelistAppInternal(name);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePowerSaveWhitelistApp(String name) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                DeviceIdleController.this.removePowerSaveWhitelistAppInternal(name);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeSystemPowerWhitelistApp(String name) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                DeviceIdleController.this.removeSystemPowerWhitelistAppInternal(name);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void restoreSystemPowerWhitelistApp(String name) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                DeviceIdleController.this.restoreSystemPowerWhitelistAppInternal(name);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public String[] getRemovedSystemPowerWhitelistApps() {
            return DeviceIdleController.this.getRemovedSystemPowerWhitelistAppsInternal();
        }

        @Override
        public String[] getSystemPowerWhitelistExceptIdle() {
            return DeviceIdleController.this.getSystemPowerWhitelistExceptIdleInternal();
        }

        @Override
        public String[] getSystemPowerWhitelist() {
            return DeviceIdleController.this.getSystemPowerWhitelistInternal();
        }

        @Override
        public String[] getUserPowerWhitelist() {
            return DeviceIdleController.this.getUserPowerWhitelistInternal();
        }

        @Override
        public String[] getFullPowerWhitelistExceptIdle() {
            return DeviceIdleController.this.getFullPowerWhitelistExceptIdleInternal();
        }

        @Override
        public String[] getFullPowerWhitelist() {
            return DeviceIdleController.this.getFullPowerWhitelistInternal();
        }

        @Override
        public int[] getAppIdWhitelistExceptIdle() {
            return DeviceIdleController.this.getAppIdWhitelistExceptIdleInternal();
        }

        @Override
        public int[] getAppIdWhitelist() {
            return DeviceIdleController.this.getAppIdWhitelistInternal();
        }

        @Override
        public int[] getAppIdUserWhitelist() {
            return DeviceIdleController.this.getAppIdUserWhitelistInternal();
        }

        @Override
        public int[] getAppIdTempWhitelist() {
            return DeviceIdleController.this.getAppIdTempWhitelistInternal();
        }

        @Override
        public boolean isPowerSaveWhitelistExceptIdleApp(String name) {
            return DeviceIdleController.this.isPowerSaveWhitelistExceptIdleAppInternal(name);
        }

        @Override
        public boolean isPowerSaveWhitelistApp(String name) {
            return DeviceIdleController.this.isPowerSaveWhitelistAppInternal(name);
        }

        @Override
        public void addPowerSaveTempWhitelistApp(String packageName, long duration, int userId, String reason) throws RemoteException {
            DeviceIdleController.this.addPowerSaveTempWhitelistAppChecked(packageName, duration, userId, reason);
        }

        @Override
        public long addPowerSaveTempWhitelistAppForMms(String packageName, int userId, String reason) throws RemoteException {
            long duration = ((DeviceIdleController)DeviceIdleController.this).mConstants.MMS_TEMP_APP_WHITELIST_DURATION;
            DeviceIdleController.this.addPowerSaveTempWhitelistAppChecked(packageName, duration, userId, reason);
            return duration;
        }

        @Override
        public long addPowerSaveTempWhitelistAppForSms(String packageName, int userId, String reason) throws RemoteException {
            long duration = ((DeviceIdleController)DeviceIdleController.this).mConstants.SMS_TEMP_APP_WHITELIST_DURATION;
            DeviceIdleController.this.addPowerSaveTempWhitelistAppChecked(packageName, duration, userId, reason);
            return duration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exitIdle(String reason) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                DeviceIdleController.this.exitIdleInternal(reason);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public boolean registerMaintenanceActivityListener(IMaintenanceActivityListener listener) {
            return DeviceIdleController.this.registerMaintenanceActivityListener(listener);
        }

        @Override
        public void unregisterMaintenanceActivityListener(IMaintenanceActivityListener listener) {
            DeviceIdleController.this.unregisterMaintenanceActivityListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int setPreIdleTimeoutMode(int mode) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                int n = DeviceIdleController.this.setPreIdleTimeoutMode(mode);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public void resetPreIdleTimeoutMode() {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                DeviceIdleController.this.resetPreIdleTimeoutMode();
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            DeviceIdleController.this.dump(fd, pw, args);
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new Shell().exec(this, in, out, err, args, callback, resultReceiver);
        }
    }

    final class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DeviceIdleController.this.handleWriteConfigFile();
                    break;
                }
                case 2: 
                case 3: {
                    boolean lightChanged;
                    boolean deepChanged;
                    EventLogTags.writeDeviceIdleOnStart();
                    if (msg.what == 2) {
                        deepChanged = DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(true);
                        lightChanged = DeviceIdleController.this.mLocalPowerManager.setLightDeviceIdleMode(false);
                    } else {
                        deepChanged = DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(false);
                        lightChanged = DeviceIdleController.this.mLocalPowerManager.setLightDeviceIdleMode(true);
                    }
                    try {
                        DeviceIdleController.this.mNetworkPolicyManager.setDeviceIdleMode(true);
                        DeviceIdleController.this.mBatteryStats.noteDeviceIdleMode(msg.what == 2 ? 2 : 1, null, Process.myUid());
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (deepChanged) {
                        DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mIdleIntent, UserHandle.ALL);
                    }
                    if (lightChanged) {
                        DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mLightIdleIntent, UserHandle.ALL);
                    }
                    EventLogTags.writeDeviceIdleOnComplete();
                    DeviceIdleController.this.mGoingIdleWakeLock.release();
                    break;
                }
                case 4: {
                    EventLogTags.writeDeviceIdleOffStart("unknown");
                    boolean deepChanged = DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(false);
                    boolean lightChanged = DeviceIdleController.this.mLocalPowerManager.setLightDeviceIdleMode(false);
                    try {
                        DeviceIdleController.this.mNetworkPolicyManager.setDeviceIdleMode(false);
                        DeviceIdleController.this.mBatteryStats.noteDeviceIdleMode(0, null, Process.myUid());
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (deepChanged) {
                        DeviceIdleController.this.incActiveIdleOps();
                        DeviceIdleController.this.getContext().sendOrderedBroadcastAsUser(DeviceIdleController.this.mIdleIntent, UserHandle.ALL, null, DeviceIdleController.this.mIdleStartedDoneReceiver, null, 0, null, null);
                    }
                    if (lightChanged) {
                        DeviceIdleController.this.incActiveIdleOps();
                        DeviceIdleController.this.getContext().sendOrderedBroadcastAsUser(DeviceIdleController.this.mLightIdleIntent, UserHandle.ALL, null, DeviceIdleController.this.mIdleStartedDoneReceiver, null, 0, null, null);
                    }
                    DeviceIdleController.this.decActiveIdleOps();
                    EventLogTags.writeDeviceIdleOffComplete();
                    break;
                }
                case 5: {
                    String activeReason = (String)msg.obj;
                    int activeUid = msg.arg1;
                    EventLogTags.writeDeviceIdleOffStart(activeReason != null ? activeReason : "unknown");
                    boolean deepChanged = DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(false);
                    boolean lightChanged = DeviceIdleController.this.mLocalPowerManager.setLightDeviceIdleMode(false);
                    try {
                        DeviceIdleController.this.mNetworkPolicyManager.setDeviceIdleMode(false);
                        DeviceIdleController.this.mBatteryStats.noteDeviceIdleMode(0, activeReason, activeUid);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (deepChanged) {
                        DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mIdleIntent, UserHandle.ALL);
                    }
                    if (lightChanged) {
                        DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mLightIdleIntent, UserHandle.ALL);
                    }
                    EventLogTags.writeDeviceIdleOffComplete();
                    break;
                }
                case 6: {
                    int appId = msg.arg1;
                    DeviceIdleController.this.checkTempAppWhitelistTimeout(appId);
                    break;
                }
                case 7: {
                    boolean active = msg.arg1 == 1;
                    int size = DeviceIdleController.this.mMaintenanceActivityListeners.beginBroadcast();
                    try {
                        for (int i = 0; i < size; ++i) {
                            try {
                                ((IMaintenanceActivityListener)DeviceIdleController.this.mMaintenanceActivityListeners.getBroadcastItem(i)).onMaintenanceActivityChanged(active);
                                continue;
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    finally {
                        DeviceIdleController.this.mMaintenanceActivityListeners.finishBroadcast();
                    }
                }
                case 8: {
                    DeviceIdleController.this.decActiveIdleOps();
                    break;
                }
                case 9: {
                    int appId = msg.arg1;
                    boolean added = msg.arg2 == 1;
                    DeviceIdleController.this.mNetworkPolicyManagerInternal.onTempPowerSaveWhitelistChange(appId, added);
                    break;
                }
                case 10: {
                    boolean monitoring;
                    IDeviceIdleConstraint constraint = (IDeviceIdleConstraint)msg.obj;
                    boolean bl = monitoring = msg.arg1 == 1;
                    if (monitoring) {
                        constraint.startMonitoring();
                        break;
                    }
                    constraint.stopMonitoring();
                    break;
                }
                case 11: {
                    DeviceIdleController.this.updatePreIdleFactor();
                    break;
                }
                case 12: {
                    DeviceIdleController.this.updatePreIdleFactor();
                    DeviceIdleController.this.maybeDoImmediateMaintenance();
                }
            }
        }
    }

    public final class Constants
    extends ContentObserver {
        private static final String KEY_LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT = "light_after_inactive_to";
        private static final String KEY_LIGHT_PRE_IDLE_TIMEOUT = "light_pre_idle_to";
        private static final String KEY_LIGHT_IDLE_TIMEOUT = "light_idle_to";
        private static final String KEY_LIGHT_IDLE_FACTOR = "light_idle_factor";
        private static final String KEY_LIGHT_MAX_IDLE_TIMEOUT = "light_max_idle_to";
        private static final String KEY_LIGHT_IDLE_MAINTENANCE_MIN_BUDGET = "light_idle_maintenance_min_budget";
        private static final String KEY_LIGHT_IDLE_MAINTENANCE_MAX_BUDGET = "light_idle_maintenance_max_budget";
        private static final String KEY_MIN_LIGHT_MAINTENANCE_TIME = "min_light_maintenance_time";
        private static final String KEY_MIN_DEEP_MAINTENANCE_TIME = "min_deep_maintenance_time";
        private static final String KEY_INACTIVE_TIMEOUT = "inactive_to";
        private static final String KEY_SENSING_TIMEOUT = "sensing_to";
        private static final String KEY_LOCATING_TIMEOUT = "locating_to";
        private static final String KEY_LOCATION_ACCURACY = "location_accuracy";
        private static final String KEY_MOTION_INACTIVE_TIMEOUT = "motion_inactive_to";
        private static final String KEY_IDLE_AFTER_INACTIVE_TIMEOUT = "idle_after_inactive_to";
        private static final String KEY_IDLE_PENDING_TIMEOUT = "idle_pending_to";
        private static final String KEY_MAX_IDLE_PENDING_TIMEOUT = "max_idle_pending_to";
        private static final String KEY_IDLE_PENDING_FACTOR = "idle_pending_factor";
        private static final String KEY_QUICK_DOZE_DELAY_TIMEOUT = "quick_doze_delay_to";
        private static final String KEY_IDLE_TIMEOUT = "idle_to";
        private static final String KEY_MAX_IDLE_TIMEOUT = "max_idle_to";
        private static final String KEY_IDLE_FACTOR = "idle_factor";
        private static final String KEY_MIN_TIME_TO_ALARM = "min_time_to_alarm";
        private static final String KEY_MAX_TEMP_APP_WHITELIST_DURATION = "max_temp_app_whitelist_duration";
        private static final String KEY_MMS_TEMP_APP_WHITELIST_DURATION = "mms_temp_app_whitelist_duration";
        private static final String KEY_SMS_TEMP_APP_WHITELIST_DURATION = "sms_temp_app_whitelist_duration";
        private static final String KEY_NOTIFICATION_WHITELIST_DURATION = "notification_whitelist_duration";
        private static final String KEY_WAIT_FOR_UNLOCK = "wait_for_unlock";
        private static final String KEY_PRE_IDLE_FACTOR_LONG = "pre_idle_factor_long";
        private static final String KEY_PRE_IDLE_FACTOR_SHORT = "pre_idle_factor_short";
        public long LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT;
        public long LIGHT_PRE_IDLE_TIMEOUT;
        public long LIGHT_IDLE_TIMEOUT;
        public float LIGHT_IDLE_FACTOR;
        public long LIGHT_MAX_IDLE_TIMEOUT;
        public long LIGHT_IDLE_MAINTENANCE_MIN_BUDGET;
        public long LIGHT_IDLE_MAINTENANCE_MAX_BUDGET;
        public long MIN_LIGHT_MAINTENANCE_TIME;
        public long MIN_DEEP_MAINTENANCE_TIME;
        public long INACTIVE_TIMEOUT;
        public long SENSING_TIMEOUT;
        public long LOCATING_TIMEOUT;
        public float LOCATION_ACCURACY;
        public long MOTION_INACTIVE_TIMEOUT;
        public long IDLE_AFTER_INACTIVE_TIMEOUT;
        public long IDLE_PENDING_TIMEOUT;
        public long MAX_IDLE_PENDING_TIMEOUT;
        public float IDLE_PENDING_FACTOR;
        public long QUICK_DOZE_DELAY_TIMEOUT;
        public long IDLE_TIMEOUT;
        public long MAX_IDLE_TIMEOUT;
        public float IDLE_FACTOR;
        public long MIN_TIME_TO_ALARM;
        public long MAX_TEMP_APP_WHITELIST_DURATION;
        public long MMS_TEMP_APP_WHITELIST_DURATION;
        public long SMS_TEMP_APP_WHITELIST_DURATION;
        public long NOTIFICATION_WHITELIST_DURATION;
        public float PRE_IDLE_FACTOR_LONG;
        public float PRE_IDLE_FACTOR_SHORT;
        public boolean WAIT_FOR_UNLOCK;
        private final ContentResolver mResolver;
        private final boolean mSmallBatteryDevice;
        private final KeyValueListParser mParser;

        public Constants(Handler handler, ContentResolver resolver) {
            super(handler);
            this.mParser = new KeyValueListParser(',');
            this.mResolver = resolver;
            this.mSmallBatteryDevice = ActivityManager.isSmallBatteryDevice();
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("device_idle_constants"), false, this);
            this.updateConstants();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConstants() {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                try {
                    this.mParser.setString(Settings.Global.getString(this.mResolver, "device_idle_constants"));
                }
                catch (IllegalArgumentException e) {
                    Slog.e(DeviceIdleController.TAG, "Bad device idle settings", e);
                }
                this.LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT = this.mParser.getDurationMillis(KEY_LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT, 180000L);
                this.LIGHT_PRE_IDLE_TIMEOUT = this.mParser.getDurationMillis(KEY_LIGHT_PRE_IDLE_TIMEOUT, 180000L);
                this.LIGHT_IDLE_TIMEOUT = this.mParser.getDurationMillis(KEY_LIGHT_IDLE_TIMEOUT, 300000L);
                this.LIGHT_IDLE_FACTOR = this.mParser.getFloat(KEY_LIGHT_IDLE_FACTOR, 2.0f);
                this.LIGHT_MAX_IDLE_TIMEOUT = this.mParser.getDurationMillis(KEY_LIGHT_MAX_IDLE_TIMEOUT, 900000L);
                this.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET = this.mParser.getDurationMillis(KEY_LIGHT_IDLE_MAINTENANCE_MIN_BUDGET, 60000L);
                this.LIGHT_IDLE_MAINTENANCE_MAX_BUDGET = this.mParser.getDurationMillis(KEY_LIGHT_IDLE_MAINTENANCE_MAX_BUDGET, 300000L);
                this.MIN_LIGHT_MAINTENANCE_TIME = this.mParser.getDurationMillis(KEY_MIN_LIGHT_MAINTENANCE_TIME, 5000L);
                this.MIN_DEEP_MAINTENANCE_TIME = this.mParser.getDurationMillis(KEY_MIN_DEEP_MAINTENANCE_TIME, 30000L);
                long inactiveTimeoutDefault = (long)((this.mSmallBatteryDevice ? 15 : 30) * 60) * 1000L;
                this.INACTIVE_TIMEOUT = this.mParser.getDurationMillis(KEY_INACTIVE_TIMEOUT, inactiveTimeoutDefault);
                this.SENSING_TIMEOUT = this.mParser.getDurationMillis(KEY_SENSING_TIMEOUT, 240000L);
                this.LOCATING_TIMEOUT = this.mParser.getDurationMillis(KEY_LOCATING_TIMEOUT, 30000L);
                this.LOCATION_ACCURACY = this.mParser.getFloat(KEY_LOCATION_ACCURACY, 20.0f);
                this.MOTION_INACTIVE_TIMEOUT = this.mParser.getDurationMillis(KEY_MOTION_INACTIVE_TIMEOUT, 600000L);
                long idleAfterInactiveTimeout = (long)((this.mSmallBatteryDevice ? 15 : 30) * 60) * 1000L;
                this.IDLE_AFTER_INACTIVE_TIMEOUT = this.mParser.getDurationMillis(KEY_IDLE_AFTER_INACTIVE_TIMEOUT, idleAfterInactiveTimeout);
                this.IDLE_PENDING_TIMEOUT = this.mParser.getDurationMillis(KEY_IDLE_PENDING_TIMEOUT, 300000L);
                this.MAX_IDLE_PENDING_TIMEOUT = this.mParser.getDurationMillis(KEY_MAX_IDLE_PENDING_TIMEOUT, 600000L);
                this.IDLE_PENDING_FACTOR = this.mParser.getFloat(KEY_IDLE_PENDING_FACTOR, 2.0f);
                this.QUICK_DOZE_DELAY_TIMEOUT = this.mParser.getDurationMillis(KEY_QUICK_DOZE_DELAY_TIMEOUT, 60000L);
                this.IDLE_TIMEOUT = this.mParser.getDurationMillis(KEY_IDLE_TIMEOUT, 3600000L);
                this.MAX_IDLE_TIMEOUT = this.mParser.getDurationMillis(KEY_MAX_IDLE_TIMEOUT, 21600000L);
                this.IDLE_FACTOR = this.mParser.getFloat(KEY_IDLE_FACTOR, 2.0f);
                this.MIN_TIME_TO_ALARM = this.mParser.getDurationMillis(KEY_MIN_TIME_TO_ALARM, 3600000L);
                this.MAX_TEMP_APP_WHITELIST_DURATION = this.mParser.getDurationMillis(KEY_MAX_TEMP_APP_WHITELIST_DURATION, 300000L);
                this.MMS_TEMP_APP_WHITELIST_DURATION = this.mParser.getDurationMillis(KEY_MMS_TEMP_APP_WHITELIST_DURATION, 60000L);
                this.SMS_TEMP_APP_WHITELIST_DURATION = this.mParser.getDurationMillis(KEY_SMS_TEMP_APP_WHITELIST_DURATION, 20000L);
                this.NOTIFICATION_WHITELIST_DURATION = this.mParser.getDurationMillis(KEY_NOTIFICATION_WHITELIST_DURATION, 30000L);
                this.WAIT_FOR_UNLOCK = this.mParser.getBoolean(KEY_WAIT_FOR_UNLOCK, true);
                this.PRE_IDLE_FACTOR_LONG = this.mParser.getFloat(KEY_PRE_IDLE_FACTOR_LONG, 1.67f);
                this.PRE_IDLE_FACTOR_SHORT = this.mParser.getFloat(KEY_PRE_IDLE_FACTOR_SHORT, 0.33f);
            }
        }

        void dump(PrintWriter pw) {
            pw.println("  Settings:");
            pw.print("    ");
            pw.print(KEY_LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_IDLE_AFTER_INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_PRE_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_PRE_IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_IDLE_FACTOR);
            pw.print("=");
            pw.print(this.LIGHT_IDLE_FACTOR);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_MAX_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_MAX_IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_IDLE_MAINTENANCE_MIN_BUDGET);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_IDLE_MAINTENANCE_MIN_BUDGET, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LIGHT_IDLE_MAINTENANCE_MAX_BUDGET);
            pw.print("=");
            TimeUtils.formatDuration(this.LIGHT_IDLE_MAINTENANCE_MAX_BUDGET, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MIN_LIGHT_MAINTENANCE_TIME);
            pw.print("=");
            TimeUtils.formatDuration(this.MIN_LIGHT_MAINTENANCE_TIME, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MIN_DEEP_MAINTENANCE_TIME);
            pw.print("=");
            TimeUtils.formatDuration(this.MIN_DEEP_MAINTENANCE_TIME, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_SENSING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.SENSING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LOCATING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LOCATING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LOCATION_ACCURACY);
            pw.print("=");
            pw.print(this.LOCATION_ACCURACY);
            pw.print("m");
            pw.println();
            pw.print("    ");
            pw.print(KEY_MOTION_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.MOTION_INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_AFTER_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.IDLE_AFTER_INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_PENDING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.IDLE_PENDING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MAX_IDLE_PENDING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.MAX_IDLE_PENDING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_PENDING_FACTOR);
            pw.print("=");
            pw.println(this.IDLE_PENDING_FACTOR);
            pw.print("    ");
            pw.print(KEY_QUICK_DOZE_DELAY_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.QUICK_DOZE_DELAY_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MAX_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.MAX_IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_FACTOR);
            pw.print("=");
            pw.println(this.IDLE_FACTOR);
            pw.print("    ");
            pw.print(KEY_MIN_TIME_TO_ALARM);
            pw.print("=");
            TimeUtils.formatDuration(this.MIN_TIME_TO_ALARM, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MAX_TEMP_APP_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.MAX_TEMP_APP_WHITELIST_DURATION, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MMS_TEMP_APP_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.MMS_TEMP_APP_WHITELIST_DURATION, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_SMS_TEMP_APP_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.SMS_TEMP_APP_WHITELIST_DURATION, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_NOTIFICATION_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.NOTIFICATION_WHITELIST_DURATION, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_WAIT_FOR_UNLOCK);
            pw.print("=");
            pw.println(this.WAIT_FOR_UNLOCK);
            pw.print("    ");
            pw.print(KEY_PRE_IDLE_FACTOR_LONG);
            pw.print("=");
            pw.println(this.PRE_IDLE_FACTOR_LONG);
            pw.print("    ");
            pw.print(KEY_PRE_IDLE_FACTOR_SHORT);
            pw.print("=");
            pw.println(this.PRE_IDLE_FACTOR_SHORT);
        }
    }

    @VisibleForTesting
    final class MotionListener
    extends TriggerEventListener
    implements SensorEventListener {
        boolean active = false;

        MotionListener() {
        }

        public boolean isActive() {
            return this.active;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTrigger(TriggerEvent event) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                this.active = false;
                DeviceIdleController.this.motionLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSensorChanged(SensorEvent event) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.mSensorManager.unregisterListener(this, DeviceIdleController.this.mMotionSensor);
                this.active = false;
                DeviceIdleController.this.motionLocked();
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        public boolean registerLocked() {
            boolean success = DeviceIdleController.this.mMotionSensor.getReportingMode() == 2 ? DeviceIdleController.this.mSensorManager.requestTriggerSensor(DeviceIdleController.this.mMotionListener, DeviceIdleController.this.mMotionSensor) : DeviceIdleController.this.mSensorManager.registerListener(DeviceIdleController.this.mMotionListener, DeviceIdleController.this.mMotionSensor, 3);
            if (success) {
                this.active = true;
            } else {
                Slog.e(DeviceIdleController.TAG, "Unable to register for " + DeviceIdleController.this.mMotionSensor);
            }
            return success;
        }

        public void unregisterLocked() {
            if (DeviceIdleController.this.mMotionSensor.getReportingMode() == 2) {
                DeviceIdleController.this.mSensorManager.cancelTriggerSensor(DeviceIdleController.this.mMotionListener, DeviceIdleController.this.mMotionSensor);
            } else {
                DeviceIdleController.this.mSensorManager.unregisterListener(DeviceIdleController.this.mMotionListener);
            }
            this.active = false;
        }
    }
}

