/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import android.util.Slog;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemService;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;

final class DockObserver
extends SystemService {
    private static final String TAG = "DockObserver";
    private static final String DOCK_UEVENT_MATCH = "DEVPATH=/devices/virtual/switch/dock";
    private static final String DOCK_STATE_PATH = "/sys/class/switch/dock/state";
    private static final int MSG_DOCK_STATE_CHANGED = 0;
    private final PowerManager mPowerManager;
    private final PowerManager.WakeLock mWakeLock;
    private final Object mLock = new Object();
    private boolean mSystemReady;
    private int mActualDockState = 0;
    private int mReportedDockState = 0;
    private int mPreviousDockState = 0;
    private boolean mUpdatesStopped;
    private final boolean mAllowTheaterModeWakeFromDock;
    private final Handler mHandler = new Handler(true){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    DockObserver.this.handleDockStateChange();
                    DockObserver.this.mWakeLock.release();
                }
            }
        }
    };
    private final UEventObserver mObserver = new UEventObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUEvent(UEventObserver.UEvent event) {
            if (Log.isLoggable(DockObserver.TAG, 2)) {
                Slog.v(DockObserver.TAG, "Dock UEVENT: " + event.toString());
            }
            try {
                Object object = DockObserver.this.mLock;
                synchronized (object) {
                    DockObserver.this.setActualDockStateLocked(Integer.parseInt(event.get("SWITCH_STATE")));
                }
            }
            catch (NumberFormatException e) {
                Slog.e(DockObserver.TAG, "Could not parse switch state from event " + event);
            }
        }
    };

    public DockObserver(Context context) {
        super(context);
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = this.mPowerManager.newWakeLock(1, TAG);
        this.mAllowTheaterModeWakeFromDock = context.getResources().getBoolean(0x1110015);
        this.init();
        this.mObserver.startObserving(DOCK_UEVENT_MATCH);
    }

    @Override
    public void onStart() {
        this.publishBinderService(TAG, new BinderService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 550) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSystemReady = true;
                if (this.mReportedDockState != 0) {
                    this.updateLocked();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                char[] buffer = new char[1024];
                try (FileReader file = new FileReader(DOCK_STATE_PATH);){
                    int len = file.read(buffer, 0, 1024);
                    this.setActualDockStateLocked(Integer.parseInt(new String(buffer, 0, len).trim()));
                    this.mPreviousDockState = this.mActualDockState;
                }
            }
            catch (FileNotFoundException e) {
                Slog.w(TAG, "This kernel does not have dock station support");
            }
            catch (Exception e) {
                Slog.e(TAG, "", e);
            }
        }
    }

    private void setActualDockStateLocked(int newState) {
        this.mActualDockState = newState;
        if (!this.mUpdatesStopped) {
            this.setDockStateLocked(newState);
        }
    }

    private void setDockStateLocked(int newState) {
        if (newState != this.mReportedDockState) {
            this.mReportedDockState = newState;
            if (this.mSystemReady) {
                if (this.mAllowTheaterModeWakeFromDock || Settings.Global.getInt(this.getContext().getContentResolver(), "theater_mode_on", 0) == 0) {
                    this.mPowerManager.wakeUp(SystemClock.uptimeMillis(), "android.server:DOCK");
                }
                this.updateLocked();
            }
        }
    }

    private void updateLocked() {
        this.mWakeLock.acquire();
        this.mHandler.sendEmptyMessage(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDockStateChange() {
        Object object = this.mLock;
        synchronized (object) {
            boolean accessibilityEnabled;
            Slog.i(TAG, "Dock state changed from " + this.mPreviousDockState + " to " + this.mReportedDockState);
            int previousDockState = this.mPreviousDockState;
            this.mPreviousDockState = this.mReportedDockState;
            ContentResolver cr = this.getContext().getContentResolver();
            if (Settings.Global.getInt(cr, "device_provisioned", 0) == 0) {
                Slog.i(TAG, "Device not provisioned, skipping dock broadcast");
                return;
            }
            Intent intent = new Intent("android.intent.action.DOCK_EVENT");
            intent.addFlags(0x20000000);
            intent.putExtra("android.intent.extra.DOCK_STATE", this.mReportedDockState);
            boolean dockSoundsEnabled = Settings.Global.getInt(cr, "dock_sounds_enabled", 1) == 1;
            boolean dockSoundsEnabledWhenAccessibility = Settings.Global.getInt(cr, "dock_sounds_enabled_when_accessbility", 1) == 1;
            boolean bl = accessibilityEnabled = Settings.Secure.getInt(cr, "accessibility_enabled", 0) == 1;
            if (dockSoundsEnabled || accessibilityEnabled && dockSoundsEnabledWhenAccessibility) {
                Ringtone sfx;
                Uri soundUri;
                String soundPath;
                String whichSound = null;
                if (this.mReportedDockState == 0) {
                    if (previousDockState == 1 || previousDockState == 3 || previousDockState == 4) {
                        whichSound = "desk_undock_sound";
                    } else if (previousDockState == 2) {
                        whichSound = "car_undock_sound";
                    }
                } else if (this.mReportedDockState == 1 || this.mReportedDockState == 3 || this.mReportedDockState == 4) {
                    whichSound = "desk_dock_sound";
                } else if (this.mReportedDockState == 2) {
                    whichSound = "car_dock_sound";
                }
                if (whichSound != null && (soundPath = Settings.Global.getString(cr, whichSound)) != null && (soundUri = Uri.parse("file://" + soundPath)) != null && (sfx = RingtoneManager.getRingtone(this.getContext(), soundUri)) != null) {
                    sfx.setStreamType(1);
                    sfx.play();
                }
            }
            this.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    private final class BinderService
    extends Binder {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(DockObserver.this.getContext(), DockObserver.TAG, pw)) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Object object = DockObserver.this.mLock;
                synchronized (object) {
                    block17: {
                        if (args == null || args.length == 0 || "-a".equals(args[0])) {
                            pw.println("Current Dock Observer Service state:");
                            if (DockObserver.this.mUpdatesStopped) {
                                pw.println("  (UPDATES STOPPED -- use 'reset' to restart)");
                            }
                            pw.println("  reported state: " + DockObserver.this.mReportedDockState);
                            pw.println("  previous state: " + DockObserver.this.mPreviousDockState);
                            pw.println("  actual state: " + DockObserver.this.mActualDockState);
                        } else if (args.length == 3 && "set".equals(args[0])) {
                            String key = args[1];
                            String value = args[2];
                            try {
                                if ("state".equals(key)) {
                                    DockObserver.this.mUpdatesStopped = true;
                                    DockObserver.this.setDockStateLocked(Integer.parseInt(value));
                                    break block17;
                                }
                                pw.println("Unknown set option: " + key);
                            }
                            catch (NumberFormatException ex) {
                                pw.println("Bad value: " + value);
                            }
                        } else if (args.length == 1 && "reset".equals(args[0])) {
                            DockObserver.this.mUpdatesStopped = false;
                            DockObserver.this.setDockStateLocked(DockObserver.this.mActualDockState);
                        } else {
                            pw.println("Dump current dock state, or:");
                            pw.println("  set state <value>");
                            pw.println("  reset");
                        }
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }
}

