/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.gsi.GsiInstallParams;
import android.gsi.GsiProgress;
import android.gsi.IGsiService;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.image.IDynamicSystemService;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.util.Slog;
import java.io.File;

public class DynamicSystemService
extends IDynamicSystemService.Stub
implements IBinder.DeathRecipient {
    private static final String TAG = "DynamicSystemService";
    private static final String NO_SERVICE_ERROR = "no gsiservice";
    private static final int GSID_ROUGH_TIMEOUT_MS = 8192;
    private static final String PATH_DEFAULT = "/data/gsi";
    private Context mContext;
    private volatile IGsiService mGsiService;

    DynamicSystemService(Context context) {
        this.mContext = context;
    }

    private static IGsiService connect(IBinder.DeathRecipient recipient) throws RemoteException {
        IBinder binder = ServiceManager.getService("gsiservice");
        if (binder == null) {
            return null;
        }
        binder.linkToDeath(recipient, 0);
        return IGsiService.Stub.asInterface(binder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binderDied() {
        Slog.w(TAG, "gsiservice died; reconnecting");
        DynamicSystemService dynamicSystemService = this;
        synchronized (dynamicSystemService) {
            this.mGsiService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IGsiService getGsiService() throws RemoteException {
        this.checkPermission();
        if (!"running".equals(SystemProperties.get("init.svc.gsid"))) {
            SystemProperties.set("ctl.start", "gsid");
        }
        for (int sleepMs = 64; sleepMs <= 16384; sleepMs <<= 1) {
            DynamicSystemService dynamicSystemService = this;
            synchronized (dynamicSystemService) {
                if (this.mGsiService == null) {
                    this.mGsiService = DynamicSystemService.connect(this);
                }
                if (this.mGsiService != null) {
                    return this.mGsiService;
                }
            }
            try {
                Slog.d(TAG, "GsiService is not ready, wait for " + sleepMs + "ms");
                Thread.sleep(sleepMs);
                continue;
            }
            catch (InterruptedException e) {
                Slog.e(TAG, "Interrupted when waiting for GSID");
                return null;
            }
        }
        throw new RemoteException(NO_SERVICE_ERROR);
    }

    private void checkPermission() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MANAGE_DYNAMIC_SYSTEM") != 0) {
            throw new SecurityException("Requires MANAGE_DYNAMIC_SYSTEM permission");
        }
    }

    @Override
    public boolean startInstallation(long systemSize, long userdataSize) throws RemoteException {
        String path = SystemProperties.get("os.aot.path");
        if (path.isEmpty()) {
            StorageVolume[] volumes;
            int userId = UserHandle.myUserId();
            for (StorageVolume volume : volumes = StorageManager.getVolumeList(userId, 256)) {
                File sdCard;
                if (volume.isEmulated() || !volume.isRemovable() || !"mounted".equals(volume.getState()) || !(sdCard = volume.getPathFile()).isDirectory()) continue;
                path = sdCard.getPath();
                break;
            }
            if (path.isEmpty()) {
                path = PATH_DEFAULT;
            }
            Slog.i(TAG, "startInstallation -> " + path);
        }
        GsiInstallParams installParams = new GsiInstallParams();
        installParams.installDir = path;
        installParams.gsiSize = systemSize;
        installParams.userdataSize = userdataSize;
        return this.getGsiService().beginGsiInstall(installParams) == 0;
    }

    @Override
    public GsiProgress getInstallationProgress() throws RemoteException {
        return this.getGsiService().getInstallProgress();
    }

    @Override
    public boolean abort() throws RemoteException {
        return this.getGsiService().cancelGsiInstall();
    }

    @Override
    public boolean isInUse() throws RemoteException {
        boolean gsidWasRunning = "running".equals(SystemProperties.get("init.svc.gsid"));
        boolean isInUse = false;
        try {
            isInUse = this.getGsiService().isGsiRunning();
        }
        finally {
            if (!gsidWasRunning && !isInUse) {
                SystemProperties.set("ctl.stop", "gsid");
            }
        }
        return isInUse;
    }

    @Override
    public boolean isInstalled() throws RemoteException {
        return this.getGsiService().isGsiInstalled();
    }

    @Override
    public boolean isEnabled() throws RemoteException {
        return this.getGsiService().isGsiEnabled();
    }

    @Override
    public boolean remove() throws RemoteException {
        return this.getGsiService().removeGsiInstall();
    }

    @Override
    public boolean setEnable(boolean enable) throws RemoteException {
        IGsiService gsiService = this.getGsiService();
        if (enable) {
            int status = gsiService.getGsiBootStatus();
            boolean singleBoot = status == 2;
            return gsiService.setGsiBootable(singleBoot) == 0;
        }
        return gsiService.disableGsiInstall();
    }

    @Override
    public boolean write(byte[] buf) throws RemoteException {
        return this.getGsiService().commitGsiChunkFromMemory(buf);
    }

    @Override
    public boolean commit() throws RemoteException {
        return this.getGsiService().setGsiBootable(true) == 0;
    }
}

