/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.IBinder;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.watchdog.ExplicitHealthCheckService;
import android.service.watchdog.IExplicitHealthCheckService;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

class ExplicitHealthCheckController {
    private static final String TAG = "ExplicitHealthCheckController";
    private final Object mLock = new Object();
    private final Context mContext;
    @GuardedBy(value={"mLock"})
    private Consumer<String> mPassedConsumer;
    @GuardedBy(value={"mLock"})
    private Consumer<List<ExplicitHealthCheckService.PackageConfig>> mSupportedConsumer;
    @GuardedBy(value={"mLock"})
    private Runnable mNotifySyncRunnable;
    @GuardedBy(value={"mLock"})
    private IExplicitHealthCheckService mRemoteService;
    @GuardedBy(value={"mLock"})
    private ServiceConnection mConnection;
    @GuardedBy(value={"mLock"})
    private boolean mEnabled;

    ExplicitHealthCheckController(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            Slog.i(TAG, "Explicit health checks " + (enabled ? "enabled." : "disabled."));
            this.mEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallbacks(Consumer<String> passedConsumer, Consumer<List<ExplicitHealthCheckService.PackageConfig>> supportedConsumer, Runnable notifySyncRunnable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPassedConsumer != null || this.mSupportedConsumer != null || this.mNotifySyncRunnable != null) {
                Slog.wtf(TAG, "Resetting health check controller callbacks");
            }
            this.mPassedConsumer = Preconditions.checkNotNull(passedConsumer);
            this.mSupportedConsumer = Preconditions.checkNotNull(supportedConsumer);
            this.mNotifySyncRunnable = Preconditions.checkNotNull(notifySyncRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRequests(Set<String> newRequestedPackages) {
        boolean enabled;
        Object object = this.mLock;
        synchronized (object) {
            enabled = this.mEnabled;
        }
        if (!enabled) {
            Slog.i(TAG, "Health checks disabled, no supported packages");
            this.mSupportedConsumer.accept(Collections.emptyList());
            return;
        }
        this.getSupportedPackages(supportedPackageConfigs -> {
            this.mSupportedConsumer.accept((List<ExplicitHealthCheckService.PackageConfig>)supportedPackageConfigs);
            this.getRequestedPackages(previousRequestedPackages -> {
                Object object = this.mLock;
                synchronized (object) {
                    ArraySet<String> supportedPackages = new ArraySet<String>();
                    for (ExplicitHealthCheckService.PackageConfig config : supportedPackageConfigs) {
                        supportedPackages.add(config.getPackageName());
                    }
                    newRequestedPackages.retainAll(supportedPackages);
                    this.actOnDifference((Collection<String>)previousRequestedPackages, newRequestedPackages, p -> this.cancel((String)p));
                    this.actOnDifference(newRequestedPackages, (Collection<String>)previousRequestedPackages, p -> this.request((String)p));
                    if (newRequestedPackages.isEmpty()) {
                        Slog.i(TAG, "No more health check requests, unbinding...");
                        this.unbindService();
                        return;
                    }
                    return;
                }
            });
        });
    }

    private void actOnDifference(Collection<String> collection1, Collection<String> collection2, Consumer<String> action) {
        for (String packageName : collection1) {
            if (collection2.contains(packageName)) continue;
            action.accept(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void request(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.prepareServiceLocked("request health check for " + packageName)) {
                return;
            }
            Slog.i(TAG, "Requesting health check for package " + packageName);
            try {
                this.mRemoteService.request(packageName);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to request health check for package " + packageName, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.prepareServiceLocked("cancel health check for " + packageName)) {
                return;
            }
            Slog.i(TAG, "Cancelling health check for package " + packageName);
            try {
                this.mRemoteService.cancel(packageName);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to cancel health check for package " + packageName, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSupportedPackages(Consumer<List<ExplicitHealthCheckService.PackageConfig>> consumer) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.prepareServiceLocked("get health check supported packages")) {
                return;
            }
            Slog.d(TAG, "Getting health check supported packages");
            try {
                this.mRemoteService.getSupportedPackages(new RemoteCallback(result -> {
                    ArrayList packages = result.getParcelableArrayList("android.service.watchdog.extra.supported_packages");
                    Slog.i(TAG, "Explicit health check supported packages " + packages);
                    consumer.accept(packages);
                }));
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to get health check supported packages", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRequestedPackages(Consumer<List<String>> consumer) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.prepareServiceLocked("get health check requested packages")) {
                return;
            }
            Slog.d(TAG, "Getting health check requested packages");
            try {
                this.mRemoteService.getRequestedPackages(new RemoteCallback(result -> {
                    ArrayList<String> packages = result.getStringArrayList("android.service.watchdog.extra.requested_packages");
                    Slog.i(TAG, "Explicit health check requested packages " + packages);
                    consumer.accept(packages);
                }));
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to get health check requested packages", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindService() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled || this.mConnection != null || this.mRemoteService != null) {
                if (!this.mEnabled) {
                    Slog.i(TAG, "Not binding to service, service disabled");
                } else if (this.mRemoteService != null) {
                    Slog.i(TAG, "Not binding to service, service already connected");
                } else {
                    Slog.i(TAG, "Not binding to service, service already connecting");
                }
                return;
            }
            ComponentName component = this.getServiceComponentNameLocked();
            if (component == null) {
                Slog.wtf(TAG, "Explicit health check service not found");
                return;
            }
            Intent intent = new Intent();
            intent.setComponent(component);
            this.mConnection = new ServiceConnection(){

                @Override
                public void onServiceConnected(ComponentName name, IBinder service) {
                    Slog.i(ExplicitHealthCheckController.TAG, "Explicit health check service is connected " + name);
                    ExplicitHealthCheckController.this.initState(service);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceDisconnected(ComponentName name) {
                    Slog.i(ExplicitHealthCheckController.TAG, "Explicit health check service is disconnected " + name);
                    Object object = ExplicitHealthCheckController.this.mLock;
                    synchronized (object) {
                        ExplicitHealthCheckController.this.mRemoteService = null;
                    }
                }

                @Override
                public void onBindingDied(ComponentName name) {
                    Slog.i(ExplicitHealthCheckController.TAG, "Explicit health check service binding is dead. Rebind: " + name);
                    ExplicitHealthCheckController.this.unbindService();
                    ExplicitHealthCheckController.this.bindService();
                }

                @Override
                public void onNullBinding(ComponentName name) {
                    Slog.wtf(ExplicitHealthCheckController.TAG, "Explicit health check service binding is null?? " + name);
                }
            };
            this.mContext.bindServiceAsUser(intent, this.mConnection, 1, UserHandle.of(0));
            Slog.i(TAG, "Explicit health check service is bound");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRemoteService != null) {
                this.mContext.unbindService(this.mConnection);
                this.mRemoteService = null;
                this.mConnection = null;
            }
            Slog.i(TAG, "Explicit health check service is unbound");
        }
    }

    @GuardedBy(value={"mLock"})
    private ServiceInfo getServiceInfoLocked() {
        String packageName = this.mContext.getPackageManager().getServicesSystemSharedLibraryPackageName();
        if (packageName == null) {
            Slog.w(TAG, "no external services package!");
            return null;
        }
        Intent intent = new Intent("android.service.watchdog.ExplicitHealthCheckService");
        intent.setPackage(packageName);
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveService(intent, 132);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Slog.w(TAG, "No valid components found.");
            return null;
        }
        return resolveInfo.serviceInfo;
    }

    @GuardedBy(value={"mLock"})
    private ComponentName getServiceComponentNameLocked() {
        ServiceInfo serviceInfo = this.getServiceInfoLocked();
        if (serviceInfo == null) {
            return null;
        }
        ComponentName name = new ComponentName(serviceInfo.packageName, serviceInfo.name);
        if (!"android.permission.BIND_EXPLICIT_HEALTH_CHECK_SERVICE".equals(serviceInfo.permission)) {
            Slog.w(TAG, name.flattenToShortString() + " does not require permission " + "android.permission.BIND_EXPLICIT_HEALTH_CHECK_SERVICE");
            return null;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initState(IBinder service) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                Slog.w(TAG, "Attempting to connect disabled service?? Unbinding...");
                this.unbindService();
                return;
            }
            this.mRemoteService = IExplicitHealthCheckService.Stub.asInterface(service);
            try {
                this.mRemoteService.setCallback(new RemoteCallback(result -> {
                    String packageName = result.getString("android.service.watchdog.extra.health_check_passed_package");
                    if (!TextUtils.isEmpty(packageName)) {
                        if (this.mPassedConsumer == null) {
                            Slog.wtf(TAG, "Health check passed for package " + packageName + "but no consumer registered.");
                        } else {
                            this.mPassedConsumer.accept(packageName);
                        }
                    } else {
                        Slog.wtf(TAG, "Empty package passed explicit health check?");
                    }
                }));
                Slog.i(TAG, "Service initialized, syncing requests");
            }
            catch (RemoteException e) {
                Slog.wtf(TAG, "Could not setCallback on explicit health check service");
            }
        }
        this.mNotifySyncRunnable.run();
    }

    @GuardedBy(value={"mLock"})
    private boolean prepareServiceLocked(String action) {
        if (this.mRemoteService != null && this.mEnabled) {
            return true;
        }
        Slog.i(TAG, "Service not ready to " + action + (this.mEnabled ? ". Binding..." : ". Disabled"));
        if (this.mEnabled) {
            this.bindService();
        }
        return false;
    }
}

