/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.net.Uri;
import android.os.Handler;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.provider.Settings;
import android.util.MutableBoolean;
import android.util.Slog;
import android.view.KeyEvent;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.wm.WindowManagerInternal;

public class GestureLauncherService
extends SystemService {
    private static final boolean DBG = false;
    private static final boolean DBG_CAMERA_LIFT = false;
    private static final String TAG = "GestureLauncherService";
    @VisibleForTesting
    static final long CAMERA_POWER_DOUBLE_TAP_MAX_TIME_MS = 300L;
    @VisibleForTesting
    static final long POWER_SHORT_TAP_SEQUENCE_MAX_INTERVAL_MS = 500L;
    private final GestureEventListener mGestureListener = new GestureEventListener();
    private final CameraLiftTriggerEventListener mCameraLiftTriggerListener = new CameraLiftTriggerEventListener();
    private Sensor mCameraLaunchSensor;
    private Sensor mCameraLiftTriggerSensor;
    private Context mContext;
    private final MetricsLogger mMetricsLogger;
    private PowerManager mPowerManager;
    private WindowManagerInternal mWindowManagerInternal;
    private PowerManager.WakeLock mWakeLock;
    private boolean mCameraLaunchRegistered;
    private boolean mCameraLiftRegistered;
    private int mUserId;
    private long mCameraGestureOnTimeMs = 0L;
    private long mCameraGestureLastEventTime = 0L;
    private long mCameraGestureSensor1LastOnTimeMs = 0L;
    private long mCameraGestureSensor2LastOnTimeMs = 0L;
    private int mCameraLaunchLastEventExtra = 0;
    private boolean mCameraDoubleTapPowerEnabled;
    private long mLastPowerDown;
    private int mPowerButtonConsecutiveTaps;
    private final BroadcastReceiver mUserReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_SWITCHED".equals(intent.getAction())) {
                GestureLauncherService.this.mUserId = intent.getIntExtra("android.intent.extra.user_handle", 0);
                GestureLauncherService.this.mContext.getContentResolver().unregisterContentObserver(GestureLauncherService.this.mSettingObserver);
                GestureLauncherService.this.registerContentObservers();
                GestureLauncherService.this.updateCameraRegistered();
                GestureLauncherService.this.updateCameraDoubleTapPowerEnabled();
            }
        }
    };
    private final ContentObserver mSettingObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            if (userId == GestureLauncherService.this.mUserId) {
                GestureLauncherService.this.updateCameraRegistered();
                GestureLauncherService.this.updateCameraDoubleTapPowerEnabled();
            }
        }
    };

    public GestureLauncherService(Context context) {
        this(context, new MetricsLogger());
    }

    @VisibleForTesting
    GestureLauncherService(Context context, MetricsLogger metricsLogger) {
        super(context);
        this.mContext = context;
        this.mMetricsLogger = metricsLogger;
    }

    @Override
    public void onStart() {
        LocalServices.addService(GestureLauncherService.class, this);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 600) {
            Resources resources = this.mContext.getResources();
            if (!GestureLauncherService.isGestureLauncherEnabled(resources)) {
                return;
            }
            this.mWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
            this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
            this.mWakeLock = this.mPowerManager.newWakeLock(1, TAG);
            this.updateCameraRegistered();
            this.updateCameraDoubleTapPowerEnabled();
            this.mUserId = ActivityManager.getCurrentUser();
            this.mContext.registerReceiver(this.mUserReceiver, new IntentFilter("android.intent.action.USER_SWITCHED"));
            this.registerContentObservers();
        }
    }

    private void registerContentObservers() {
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("camera_gesture_disabled"), false, this.mSettingObserver, this.mUserId);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("camera_double_tap_power_gesture_disabled"), false, this.mSettingObserver, this.mUserId);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("camera_lift_trigger_enabled"), false, this.mSettingObserver, this.mUserId);
    }

    private void updateCameraRegistered() {
        Resources resources = this.mContext.getResources();
        if (GestureLauncherService.isCameraLaunchSettingEnabled(this.mContext, this.mUserId)) {
            this.registerCameraLaunchGesture(resources);
        } else {
            this.unregisterCameraLaunchGesture();
        }
        if (GestureLauncherService.isCameraLiftTriggerSettingEnabled(this.mContext, this.mUserId)) {
            this.registerCameraLiftTrigger(resources);
        } else {
            this.unregisterCameraLiftTrigger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateCameraDoubleTapPowerEnabled() {
        boolean enabled = GestureLauncherService.isCameraDoubleTapPowerSettingEnabled(this.mContext, this.mUserId);
        GestureLauncherService gestureLauncherService = this;
        synchronized (gestureLauncherService) {
            this.mCameraDoubleTapPowerEnabled = enabled;
        }
    }

    private void unregisterCameraLaunchGesture() {
        if (this.mCameraLaunchRegistered) {
            this.mCameraLaunchRegistered = false;
            this.mCameraGestureOnTimeMs = 0L;
            this.mCameraGestureLastEventTime = 0L;
            this.mCameraGestureSensor1LastOnTimeMs = 0L;
            this.mCameraGestureSensor2LastOnTimeMs = 0L;
            this.mCameraLaunchLastEventExtra = 0;
            SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
            sensorManager.unregisterListener(this.mGestureListener);
        }
    }

    private void registerCameraLaunchGesture(Resources resources) {
        if (this.mCameraLaunchRegistered) {
            return;
        }
        this.mCameraGestureLastEventTime = this.mCameraGestureOnTimeMs = SystemClock.elapsedRealtime();
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        int cameraLaunchGestureId = resources.getInteger(17694758);
        if (cameraLaunchGestureId != -1) {
            this.mCameraLaunchRegistered = false;
            String sensorName = resources.getString(17039682);
            this.mCameraLaunchSensor = sensorManager.getDefaultSensor(cameraLaunchGestureId, true);
            if (this.mCameraLaunchSensor != null) {
                if (sensorName.equals(this.mCameraLaunchSensor.getStringType())) {
                    this.mCameraLaunchRegistered = sensorManager.registerListener(this.mGestureListener, this.mCameraLaunchSensor, 0);
                } else {
                    String message = String.format("Wrong configuration. Sensor type and sensor string type don't match: %s in resources, %s in the sensor.", sensorName, this.mCameraLaunchSensor.getStringType());
                    throw new RuntimeException(message);
                }
            }
        }
    }

    private void unregisterCameraLiftTrigger() {
        if (this.mCameraLiftRegistered) {
            this.mCameraLiftRegistered = false;
            SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
            sensorManager.cancelTriggerSensor(this.mCameraLiftTriggerListener, this.mCameraLiftTriggerSensor);
        }
    }

    private void registerCameraLiftTrigger(Resources resources) {
        if (this.mCameraLiftRegistered) {
            return;
        }
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        int cameraLiftTriggerId = resources.getInteger(17694759);
        if (cameraLiftTriggerId != -1) {
            this.mCameraLiftRegistered = false;
            String sensorName = resources.getString(17039683);
            this.mCameraLiftTriggerSensor = sensorManager.getDefaultSensor(cameraLiftTriggerId, true);
            if (this.mCameraLiftTriggerSensor != null) {
                if (sensorName.equals(this.mCameraLiftTriggerSensor.getStringType())) {
                    this.mCameraLiftRegistered = sensorManager.requestTriggerSensor(this.mCameraLiftTriggerListener, this.mCameraLiftTriggerSensor);
                } else {
                    String message = String.format("Wrong configuration. Sensor type and sensor string type don't match: %s in resources, %s in the sensor.", sensorName, this.mCameraLiftTriggerSensor.getStringType());
                    throw new RuntimeException(message);
                }
            }
        }
    }

    public static boolean isCameraLaunchSettingEnabled(Context context, int userId) {
        return GestureLauncherService.isCameraLaunchEnabled(context.getResources()) && Settings.Secure.getIntForUser(context.getContentResolver(), "camera_gesture_disabled", 0, userId) == 0;
    }

    public static boolean isCameraDoubleTapPowerSettingEnabled(Context context, int userId) {
        return GestureLauncherService.isCameraDoubleTapPowerEnabled(context.getResources()) && Settings.Secure.getIntForUser(context.getContentResolver(), "camera_double_tap_power_gesture_disabled", 0, userId) == 0;
    }

    public static boolean isCameraLiftTriggerSettingEnabled(Context context, int userId) {
        return GestureLauncherService.isCameraLiftTriggerEnabled(context.getResources()) && Settings.Secure.getIntForUser(context.getContentResolver(), "camera_lift_trigger_enabled", 1, userId) != 0;
    }

    public static boolean isCameraLaunchEnabled(Resources resources) {
        boolean configSet = resources.getInteger(17694758) != -1;
        return configSet && !SystemProperties.getBoolean("gesture.disable_camera_launch", false);
    }

    public static boolean isCameraDoubleTapPowerEnabled(Resources resources) {
        return resources.getBoolean(17891384);
    }

    public static boolean isCameraLiftTriggerEnabled(Resources resources) {
        boolean configSet = resources.getInteger(17694759) != -1;
        return configSet;
    }

    public static boolean isGestureLauncherEnabled(Resources resources) {
        return GestureLauncherService.isCameraLaunchEnabled(resources) || GestureLauncherService.isCameraDoubleTapPowerEnabled(resources) || GestureLauncherService.isCameraLiftTriggerEnabled(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean interceptPowerKeyDown(KeyEvent event, boolean interactive, MutableBoolean outLaunched) {
        long powerTapInterval;
        if (event.isLongPress()) {
            return false;
        }
        boolean launched = false;
        boolean intercept = false;
        GestureLauncherService gestureLauncherService = this;
        synchronized (gestureLauncherService) {
            powerTapInterval = event.getEventTime() - this.mLastPowerDown;
            if (this.mCameraDoubleTapPowerEnabled && powerTapInterval < 300L) {
                launched = true;
                intercept = interactive;
                ++this.mPowerButtonConsecutiveTaps;
            } else {
                this.mPowerButtonConsecutiveTaps = powerTapInterval < 500L ? ++this.mPowerButtonConsecutiveTaps : 1;
            }
            this.mLastPowerDown = event.getEventTime();
        }
        if (launched) {
            Slog.i(TAG, "Power button double tap gesture detected, launching camera. Interval=" + powerTapInterval + "ms");
            launched = this.handleCameraGesture(false, 1);
            if (launched) {
                this.mMetricsLogger.action(255, (int)powerTapInterval);
            }
        }
        this.mMetricsLogger.histogram("power_consecutive_short_tap_count", this.mPowerButtonConsecutiveTaps);
        this.mMetricsLogger.histogram("power_double_tap_interval", (int)powerTapInterval);
        outLaunched.value = launched;
        return intercept && launched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean handleCameraGesture(boolean useWakelock, int source) {
        Trace.traceBegin(64L, "GestureLauncher:handleCameraGesture");
        try {
            boolean userSetupComplete;
            boolean bl = userSetupComplete = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "user_setup_complete", 0, -2) != 0;
            if (!userSetupComplete) {
                boolean bl2 = false;
                return bl2;
            }
            if (useWakelock) {
                this.mWakeLock.acquire(500L);
            }
            StatusBarManagerInternal service = LocalServices.getService(StatusBarManagerInternal.class);
            service.onCameraLaunchGestureDetected(source);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            Trace.traceEnd(64L);
        }
    }

    private final class CameraLiftTriggerEventListener
    extends TriggerEventListener {
        private CameraLiftTriggerEventListener() {
        }

        @Override
        public void onTrigger(TriggerEvent event) {
            if (!GestureLauncherService.this.mCameraLiftRegistered) {
                return;
            }
            if (event.sensor == GestureLauncherService.this.mCameraLiftTriggerSensor) {
                Resources resources = GestureLauncherService.this.mContext.getResources();
                SensorManager sensorManager = (SensorManager)GestureLauncherService.this.mContext.getSystemService("sensor");
                boolean keyguardShowingAndNotOccluded = GestureLauncherService.this.mWindowManagerInternal.isKeyguardShowingAndNotOccluded();
                boolean interactive = GestureLauncherService.this.mPowerManager.isInteractive();
                if ((keyguardShowingAndNotOccluded || !interactive) && GestureLauncherService.this.handleCameraGesture(true, 2)) {
                    MetricsLogger.action(GestureLauncherService.this.mContext, 989);
                }
                GestureLauncherService.this.mCameraLiftRegistered = sensorManager.requestTriggerSensor(GestureLauncherService.this.mCameraLiftTriggerListener, GestureLauncherService.this.mCameraLiftTriggerSensor);
                return;
            }
        }
    }

    private final class GestureEventListener
    implements SensorEventListener {
        private GestureEventListener() {
        }

        @Override
        public void onSensorChanged(SensorEvent event) {
            if (!GestureLauncherService.this.mCameraLaunchRegistered) {
                return;
            }
            if (event.sensor == GestureLauncherService.this.mCameraLaunchSensor) {
                if (GestureLauncherService.this.handleCameraGesture(true, 0)) {
                    GestureLauncherService.this.mMetricsLogger.action(256);
                    this.trackCameraLaunchEvent(event);
                }
                return;
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        private void trackCameraLaunchEvent(SensorEvent event) {
            long now = SystemClock.elapsedRealtime();
            long totalDuration = now - GestureLauncherService.this.mCameraGestureOnTimeMs;
            float[] values = event.values;
            long sensor1OnTime = (long)((double)totalDuration * (double)values[0]);
            long sensor2OnTime = (long)((double)totalDuration * (double)values[1]);
            int extra = (int)values[2];
            long gestureOnTimeDiff = now - GestureLauncherService.this.mCameraGestureLastEventTime;
            long sensor1OnTimeDiff = sensor1OnTime - GestureLauncherService.this.mCameraGestureSensor1LastOnTimeMs;
            long sensor2OnTimeDiff = sensor2OnTime - GestureLauncherService.this.mCameraGestureSensor2LastOnTimeMs;
            int extraDiff = extra - GestureLauncherService.this.mCameraLaunchLastEventExtra;
            if (gestureOnTimeDiff < 0L || sensor1OnTimeDiff < 0L || sensor2OnTimeDiff < 0L) {
                return;
            }
            EventLogTags.writeCameraGestureTriggered(gestureOnTimeDiff, sensor1OnTimeDiff, sensor2OnTimeDiff, extraDiff);
            GestureLauncherService.this.mCameraGestureLastEventTime = now;
            GestureLauncherService.this.mCameraGestureSensor1LastOnTimeMs = sensor1OnTime;
            GestureLauncherService.this.mCameraGestureSensor2LastOnTimeMs = sensor2OnTime;
            GestureLauncherService.this.mCameraLaunchLastEventExtra = extra;
        }
    }
}

