/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AppOpsManager;
import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.os.Binder;
import android.os.CpuUsageInfo;
import android.os.IHardwarePropertiesManager;
import android.os.UserHandle;
import com.android.internal.util.DumpUtils;
import com.android.server.LocalServices;
import com.android.server.vr.VrManagerInternal;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;

public class HardwarePropertiesManagerService
extends IHardwarePropertiesManager.Stub {
    private static final String TAG = "HardwarePropertiesManagerService";
    private final Context mContext;
    private final Object mLock = new Object();
    private final AppOpsManager mAppOps;

    private static native void nativeInit();

    private static native float[] nativeGetFanSpeeds();

    private static native float[] nativeGetDeviceTemperatures(int var0, int var1);

    private static native CpuUsageInfo[] nativeGetCpuUsages();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardwarePropertiesManagerService(Context context) {
        this.mContext = context;
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        Object object = this.mLock;
        synchronized (object) {
            HardwarePropertiesManagerService.nativeInit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getDeviceTemperatures(String callingPackage, int type, int source) throws SecurityException {
        this.enforceHardwarePropertiesRetrievalAllowed(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            return HardwarePropertiesManagerService.nativeGetDeviceTemperatures(type, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CpuUsageInfo[] getCpuUsages(String callingPackage) throws SecurityException {
        this.enforceHardwarePropertiesRetrievalAllowed(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            return HardwarePropertiesManagerService.nativeGetCpuUsages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getFanSpeeds(String callingPackage) throws SecurityException {
        this.enforceHardwarePropertiesRetrievalAllowed(callingPackage);
        Object object = this.mLock;
        synchronized (object) {
            return HardwarePropertiesManagerService.nativeGetFanSpeeds();
        }
    }

    private String getCallingPackageName() {
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(Binder.getCallingUid());
        if (packages != null && packages.length > 0) {
            return packages[0];
        }
        return "unknown";
    }

    private void dumpTempValues(String pkg, PrintWriter pw, int type, String typeLabel) {
        this.dumpTempValues(pkg, pw, type, typeLabel, "temperatures: ", 0);
        this.dumpTempValues(pkg, pw, type, typeLabel, "throttling temperatures: ", 1);
        this.dumpTempValues(pkg, pw, type, typeLabel, "shutdown temperatures: ", 2);
        this.dumpTempValues(pkg, pw, type, typeLabel, "vr throttling temperatures: ", 3);
    }

    private void dumpTempValues(String pkg, PrintWriter pw, int type, String typeLabel, String subLabel, int valueType) {
        pw.println(typeLabel + subLabel + Arrays.toString(this.getDeviceTemperatures(pkg, type, valueType)));
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        pw.println("****** Dump of HardwarePropertiesManagerService ******");
        String PKG = this.getCallingPackageName();
        this.dumpTempValues(PKG, pw, 0, "CPU ");
        this.dumpTempValues(PKG, pw, 1, "GPU ");
        this.dumpTempValues(PKG, pw, 2, "Battery ");
        this.dumpTempValues(PKG, pw, 3, "Skin ");
        float[] fanSpeeds = this.getFanSpeeds(PKG);
        pw.println("Fan speed: " + Arrays.toString(fanSpeeds) + "\n");
        CpuUsageInfo[] cpuUsageInfos = this.getCpuUsages(PKG);
        boolean core = false;
        for (int i = 0; i < cpuUsageInfos.length; ++i) {
            pw.println("Cpu usage of core: " + i + ", active = " + cpuUsageInfos[i].getActive() + ", total = " + cpuUsageInfos[i].getTotal());
        }
        pw.println("****** End of HardwarePropertiesManagerService dump ******");
    }

    private void enforceHardwarePropertiesRetrievalAllowed(String callingPackage) throws SecurityException {
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        int userId = UserHandle.getUserId(Binder.getCallingUid());
        VrManagerInternal vrService = LocalServices.getService(VrManagerInternal.class);
        DevicePolicyManager dpm = this.mContext.getSystemService(DevicePolicyManager.class);
        if (!(dpm.isDeviceOwnerApp(callingPackage) || this.mContext.checkCallingOrSelfPermission("android.permission.DEVICE_POWER") == 0 || vrService != null && vrService.isCurrentVrListener(callingPackage, userId))) {
            throw new SecurityException("The caller is neither a device owner, nor holding the DEVICE_POWER permission, nor the current VrListener.");
        }
    }
}

