/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.location.ActivityRecognitionHardware;
import android.location.Address;
import android.location.Criteria;
import android.location.GeocoderParams;
import android.location.Geofence;
import android.location.GnssMeasurementCorrections;
import android.location.IBatchedLocationCallback;
import android.location.IGnssMeasurementsListener;
import android.location.IGnssNavigationMessageListener;
import android.location.IGnssStatusListener;
import android.location.IGpsGeofenceHardware;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.INetInitiatedListener;
import android.location.Location;
import android.location.LocationRequest;
import android.location.LocationTime;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.location.ProviderProperties;
import com.android.internal.location.ProviderRequest;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.Preconditions;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.LocationUsageLogger;
import com.android.server.PendingIntentUtils;
import com.android.server.ServiceWatcher;
import com.android.server.SystemConfig;
import com.android.server.location.AbstractLocationProvider;
import com.android.server.location.ActivityRecognitionProxy;
import com.android.server.location.CallerIdentity;
import com.android.server.location.GeocoderProxy;
import com.android.server.location.GeofenceManager;
import com.android.server.location.GeofenceProxy;
import com.android.server.location.GnssBatchingProvider;
import com.android.server.location.GnssCapabilitiesProvider;
import com.android.server.location.GnssLocationProvider;
import com.android.server.location.GnssMeasurementCorrectionsProvider;
import com.android.server.location.GnssMeasurementsProvider;
import com.android.server.location.GnssNavigationMessageProvider;
import com.android.server.location.GnssStatusListenerHelper;
import com.android.server.location.LocationBlacklist;
import com.android.server.location.LocationFudger;
import com.android.server.location.LocationProviderProxy;
import com.android.server.location.LocationRequestStatistics;
import com.android.server.location.MockProvider;
import com.android.server.location.PassiveProvider;
import com.android.server.location.RemoteListenerHelper;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;

public class LocationManagerService
extends ILocationManager.Stub {
    private static final String TAG = "LocationManagerService";
    public static final boolean D = Log.isLoggable("LocationManagerService", 3);
    private static final String WAKELOCK_KEY = "*location*";
    private static final int RESOLUTION_LEVEL_NONE = 0;
    private static final int RESOLUTION_LEVEL_COARSE = 1;
    private static final int RESOLUTION_LEVEL_FINE = 2;
    private static final String ACCESS_LOCATION_EXTRA_COMMANDS = "android.permission.ACCESS_LOCATION_EXTRA_COMMANDS";
    private static final String NETWORK_LOCATION_SERVICE_ACTION = "com.android.location.service.v3.NetworkLocationProvider";
    private static final String FUSED_LOCATION_SERVICE_ACTION = "com.android.location.service.FusedLocationProvider";
    private static final long NANOS_PER_MILLI = 1000000L;
    private static final long HIGH_POWER_INTERVAL_MS = 300000L;
    private static final int FOREGROUND_IMPORTANCE_CUTOFF = 125;
    private static final long DEFAULT_BACKGROUND_THROTTLE_INTERVAL_MS = 1800000L;
    private static final long DEFAULT_LAST_LOCATION_MAX_AGE_MS = 1200000L;
    private static final int MAX_PROVIDER_SCHEDULING_JITTER_MS = 100;
    private static final LocationRequest DEFAULT_LOCATION_REQUEST = new LocationRequest();
    private final Object mLock = new Object();
    private final Context mContext;
    private final Handler mHandler;
    private AppOpsManager mAppOps;
    private PackageManager mPackageManager;
    private PowerManager mPowerManager;
    private ActivityManager mActivityManager;
    private UserManager mUserManager;
    private GeofenceManager mGeofenceManager;
    private LocationFudger mLocationFudger;
    private GeocoderProxy mGeocodeProvider;
    private GnssStatusListenerHelper mGnssStatusProvider;
    private INetInitiatedListener mNetInitiatedListener;
    private PassiveProvider mPassiveProvider;
    private LocationBlacklist mBlacklist;
    private GnssMeasurementsProvider mGnssMeasurementsProvider;
    private GnssMeasurementCorrectionsProvider mGnssMeasurementCorrectionsProvider;
    private GnssNavigationMessageProvider mGnssNavigationMessageProvider;
    @GuardedBy(value={"mLock"})
    private String mExtraLocationControllerPackage;
    private boolean mExtraLocationControllerPackageEnabled;
    private IGpsGeofenceHardware mGpsGeofenceProxy;
    @GuardedBy(value={"mLock"})
    private final ArrayList<LocationProvider> mProviders = new ArrayList();
    @GuardedBy(value={"mLock"})
    private final ArrayList<LocationProvider> mRealProviders = new ArrayList();
    @GuardedBy(value={"mLock"})
    private final HashMap<Object, Receiver> mReceivers = new HashMap();
    private final HashMap<String, ArrayList<UpdateRecord>> mRecordsByProvider = new HashMap();
    private final LocationRequestStatistics mRequestStatistics = new LocationRequestStatistics();
    @GuardedBy(value={"mLock"})
    private final HashMap<String, Location> mLastLocation = new HashMap();
    @GuardedBy(value={"mLock"})
    private final HashMap<String, Location> mLastLocationCoarseInterval = new HashMap();
    private final ArraySet<String> mBackgroundThrottlePackageWhitelist = new ArraySet();
    private final ArraySet<String> mIgnoreSettingsPackageWhitelist = new ArraySet();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<IBinder, LinkedListener<IGnssMeasurementsListener>> mGnssMeasurementsListeners = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<IBinder, LinkedListener<IGnssNavigationMessageListener>> mGnssNavigationMessageListeners = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<IBinder, LinkedListener<IGnssStatusListener>> mGnssStatusListeners = new ArrayMap();
    private int mCurrentUserId = 0;
    private int[] mCurrentUserProfiles = new int[]{0};
    private GnssLocationProvider.GnssSystemInfoProvider mGnssSystemInfoProvider;
    private GnssLocationProvider.GnssMetricsProvider mGnssMetricsProvider;
    private GnssCapabilitiesProvider mGnssCapabilitiesProvider;
    private GnssBatchingProvider mGnssBatchingProvider;
    @GuardedBy(value={"mLock"})
    private IBatchedLocationCallback mGnssBatchingCallback;
    @GuardedBy(value={"mLock"})
    private LinkedListener<IBatchedLocationCallback> mGnssBatchingDeathCallback;
    @GuardedBy(value={"mLock"})
    private boolean mGnssBatchingInProgress = false;
    @GuardedBy(value={"mLock"})
    private int mBatterySaverMode;
    @GuardedBy(value={"mLock"})
    private final LocationUsageLogger mLocationUsageLogger;

    public LocationManagerService(Context context) {
        this.mContext = context;
        this.mHandler = FgThread.getHandler();
        this.mLocationUsageLogger = new LocationUsageLogger();
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        packageManagerInternal.setLocationPackagesProvider(userId -> this.mContext.getResources().getStringArray(17236033));
        packageManagerInternal.setLocationExtraPackagesProvider(userId -> this.mContext.getResources().getStringArray(17236032));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemRunning() {
        Object object = this.mLock;
        synchronized (object) {
            this.initializeLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private void initializeLocked() {
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mPackageManager = this.mContext.getPackageManager();
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mActivityManager = (ActivityManager)this.mContext.getSystemService("activity");
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mLocationFudger = new LocationFudger(this.mContext, this.mHandler);
        this.mBlacklist = new LocationBlacklist(this.mContext, this.mHandler);
        this.mBlacklist.init();
        this.mGeofenceManager = new GeofenceManager(this.mContext, this.mBlacklist);
        this.initializeProvidersLocked();
        this.mAppOps.startWatchingMode(0, null, 1, (AppOpsManager.OnOpChangedListener)new AppOpsManager.OnOpChangedInternalListener(){

            @Override
            public void onOpChanged(int op, String packageName) {
                LocationManagerService.this.mHandler.post(() -> {
                    Object object = LocationManagerService.this.mLock;
                    synchronized (object) {
                        LocationManagerService.this.onAppOpChangedLocked();
                    }
                });
            }
        });
        this.mPackageManager.addOnPermissionsChangeListener(uid -> this.mHandler.post(() -> {
            Object object = this.mLock;
            synchronized (object) {
                this.onPermissionsChangedLocked();
            }
        }));
        this.mActivityManager.addOnUidImportanceListener((uid, importance) -> this.mHandler.post(() -> {
            Object object = this.mLock;
            synchronized (object) {
                this.onUidImportanceChangedLocked(uid, importance);
            }
        }), 125);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("location_mode"), true, new ContentObserver(this.mHandler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(boolean selfChange) {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    LocationManagerService.this.onLocationModeChangedLocked(true);
                }
            }
        }, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("location_providers_allowed"), true, new ContentObserver(this.mHandler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(boolean selfChange) {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    LocationManagerService.this.onProviderAllowedChangedLocked();
                }
            }
        }, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("location_background_throttle_interval_ms"), true, new ContentObserver(this.mHandler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(boolean selfChange) {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    LocationManagerService.this.onBackgroundThrottleIntervalChangedLocked();
                }
            }
        }, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("location_background_throttle_package_whitelist"), true, new ContentObserver(this.mHandler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(boolean selfChange) {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    LocationManagerService.this.onBackgroundThrottleWhitelistChangedLocked();
                }
            }
        }, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("location_ignore_settings_package_whitelist"), true, new ContentObserver(this.mHandler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(boolean selfChange) {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    LocationManagerService.this.onIgnoreSettingsWhitelistChangedLocked();
                }
            }
        }, -1);
        PowerManagerInternal localPowerManager = LocalServices.getService(PowerManagerInternal.class);
        localPowerManager.registerLowPowerModeObserver(1, state -> this.mHandler.post(() -> {
            Object object = this.mLock;
            synchronized (object) {
                this.onBatterySaverModeChangedLocked(state.locationMode);
            }
        }));
        new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageDisappeared(String packageName, int reason) {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    LocationManagerService.this.onPackageDisappearedLocked(packageName);
                }
            }
        }.register(this.mContext, this.mHandler.getLooper(), true);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.MANAGED_PROFILE_ADDED");
        intentFilter.addAction("android.intent.action.MANAGED_PROFILE_REMOVED");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action == null) {
                    return;
                }
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    switch (action) {
                        case "android.intent.action.USER_SWITCHED": {
                            LocationManagerService.this.onUserChangedLocked(intent.getIntExtra("android.intent.extra.user_handle", 0));
                            break;
                        }
                        case "android.intent.action.MANAGED_PROFILE_ADDED": 
                        case "android.intent.action.MANAGED_PROFILE_REMOVED": {
                            LocationManagerService.this.onUserProfilesChangedLocked();
                            break;
                        }
                        case "android.intent.action.SCREEN_ON": 
                        case "android.intent.action.SCREEN_OFF": {
                            LocationManagerService.this.onScreenStateChangedLocked();
                        }
                    }
                }
            }
        }, UserHandle.ALL, intentFilter, null, this.mHandler);
        this.mCurrentUserId = -10000;
        this.onUserChangedLocked(0);
        this.onBackgroundThrottleWhitelistChangedLocked();
        this.onIgnoreSettingsWhitelistChangedLocked();
        this.onBatterySaverModeChangedLocked(this.mPowerManager.getLocationPowerSaveMode());
    }

    @GuardedBy(value={"mLock"})
    private void onAppOpChangedLocked() {
        for (Receiver receiver : this.mReceivers.values()) {
            receiver.updateMonitoring(true);
        }
        for (LocationProvider p : this.mProviders) {
            this.applyRequirementsLocked(p);
        }
    }

    @GuardedBy(value={"mLock"})
    private void onPermissionsChangedLocked() {
        for (LocationProvider p : this.mProviders) {
            this.applyRequirementsLocked(p);
        }
    }

    @GuardedBy(value={"mLock"})
    private void onBatterySaverModeChangedLocked(int newLocationMode) {
        if (D) {
            Slog.d(TAG, "Battery Saver location mode changed from " + PowerManager.locationPowerSaveModeToString(this.mBatterySaverMode) + " to " + PowerManager.locationPowerSaveModeToString(newLocationMode));
        }
        if (this.mBatterySaverMode == newLocationMode) {
            return;
        }
        this.mBatterySaverMode = newLocationMode;
        for (LocationProvider p : this.mProviders) {
            this.applyRequirementsLocked(p);
        }
    }

    @GuardedBy(value={"mLock"})
    private void onScreenStateChangedLocked() {
        if (this.mBatterySaverMode == 4) {
            for (LocationProvider p : this.mProviders) {
                this.applyRequirementsLocked(p);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void onLocationModeChangedLocked(boolean broadcast) {
        if (D) {
            Log.d(TAG, "location enabled is now " + this.isLocationEnabled());
        }
        for (LocationProvider p : this.mProviders) {
            p.onLocationModeChangedLocked();
        }
        if (broadcast) {
            this.mContext.sendBroadcastAsUser(new Intent("android.location.MODE_CHANGED"), UserHandle.ALL);
        }
    }

    @GuardedBy(value={"mLock"})
    private void onProviderAllowedChangedLocked() {
        for (LocationProvider p : this.mProviders) {
            p.onAllowedChangedLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private void onPackageDisappearedLocked(String packageName) {
        ArrayList<Receiver> deadReceivers = null;
        for (Receiver receiver : this.mReceivers.values()) {
            if (!receiver.mCallerIdentity.mPackageName.equals(packageName)) continue;
            if (deadReceivers == null) {
                deadReceivers = new ArrayList<Receiver>();
            }
            deadReceivers.add(receiver);
        }
        if (deadReceivers != null) {
            for (Receiver receiver : deadReceivers) {
                this.removeUpdatesLocked(receiver);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void onUidImportanceChangedLocked(int uid, int importance) {
        boolean foreground = LocationManagerService.isImportanceForeground(importance);
        HashSet<String> affectedProviders = new HashSet<String>(this.mRecordsByProvider.size());
        for (Map.Entry<String, ArrayList<UpdateRecord>> entry : this.mRecordsByProvider.entrySet()) {
            String provider = entry.getKey();
            for (UpdateRecord record : entry.getValue()) {
                if (((UpdateRecord)record).mReceiver.mCallerIdentity.mUid != uid || record.mIsForegroundUid == foreground) continue;
                if (D) {
                    Log.d(TAG, "request from uid " + uid + " is now " + LocationManagerService.foregroundAsString(foreground));
                }
                record.updateForeground(foreground);
                if (this.isThrottlingExemptLocked(((UpdateRecord)record).mReceiver.mCallerIdentity)) continue;
                affectedProviders.add(provider);
            }
        }
        for (String provider : affectedProviders) {
            this.applyRequirementsLocked(provider);
        }
        this.updateGnssDataProviderOnUidImportanceChangedLocked(this.mGnssMeasurementsListeners, this.mGnssMeasurementsProvider, IGnssMeasurementsListener.Stub::asInterface, uid, foreground);
        this.updateGnssDataProviderOnUidImportanceChangedLocked(this.mGnssNavigationMessageListeners, this.mGnssNavigationMessageProvider, IGnssNavigationMessageListener.Stub::asInterface, uid, foreground);
        this.updateGnssDataProviderOnUidImportanceChangedLocked(this.mGnssStatusListeners, this.mGnssStatusProvider, IGnssStatusListener.Stub::asInterface, uid, foreground);
    }

    @GuardedBy(value={"mLock"})
    private <TListener extends IInterface> void updateGnssDataProviderOnUidImportanceChangedLocked(ArrayMap<IBinder, ? extends LinkedListenerBase> gnssDataListeners, RemoteListenerHelper<TListener> gnssDataProvider, Function<IBinder, TListener> mapBinderToListener, int uid, boolean foreground) {
        for (Map.Entry<IBinder, ? extends LinkedListenerBase> entry : gnssDataListeners.entrySet()) {
            LinkedListenerBase linkedListener = entry.getValue();
            CallerIdentity callerIdentity = linkedListener.mCallerIdentity;
            if (callerIdentity.mUid != uid) continue;
            if (D) {
                Log.d(TAG, linkedListener.mListenerName + " from uid " + uid + " is now " + LocationManagerService.foregroundAsString(foreground));
            }
            IInterface listener = (IInterface)mapBinderToListener.apply(entry.getKey());
            if (foreground || this.isThrottlingExemptLocked(callerIdentity)) {
                gnssDataProvider.addListener(listener, callerIdentity);
                continue;
            }
            gnssDataProvider.removeListener(listener);
        }
    }

    private static String foregroundAsString(boolean foreground) {
        return foreground ? "foreground" : "background";
    }

    private static boolean isImportanceForeground(int importance) {
        return importance <= 125;
    }

    @GuardedBy(value={"mLock"})
    private void onBackgroundThrottleIntervalChangedLocked() {
        for (LocationProvider provider : this.mProviders) {
            this.applyRequirementsLocked(provider);
        }
    }

    @GuardedBy(value={"mLock"})
    private void onBackgroundThrottleWhitelistChangedLocked() {
        this.mBackgroundThrottlePackageWhitelist.clear();
        this.mBackgroundThrottlePackageWhitelist.addAll(SystemConfig.getInstance().getAllowUnthrottledLocation());
        String setting = Settings.Global.getString(this.mContext.getContentResolver(), "location_background_throttle_package_whitelist");
        if (!TextUtils.isEmpty(setting)) {
            this.mBackgroundThrottlePackageWhitelist.addAll(Arrays.asList(setting.split(",")));
        }
        for (LocationProvider p : this.mProviders) {
            this.applyRequirementsLocked(p);
        }
    }

    @GuardedBy(value={"lock"})
    private void onIgnoreSettingsWhitelistChangedLocked() {
        this.mIgnoreSettingsPackageWhitelist.clear();
        this.mIgnoreSettingsPackageWhitelist.addAll(SystemConfig.getInstance().getAllowIgnoreLocationSettings());
        String setting = Settings.Global.getString(this.mContext.getContentResolver(), "location_ignore_settings_package_whitelist");
        if (!TextUtils.isEmpty(setting)) {
            this.mIgnoreSettingsPackageWhitelist.addAll(Arrays.asList(setting.split(",")));
        }
        for (LocationProvider p : this.mProviders) {
            this.applyRequirementsLocked(p);
        }
    }

    @GuardedBy(value={"mLock"})
    private void onUserProfilesChangedLocked() {
        this.mCurrentUserProfiles = this.mUserManager.getProfileIdsWithDisabled(this.mCurrentUserId);
    }

    @GuardedBy(value={"mLock"})
    private boolean isCurrentProfileLocked(int userId) {
        return ArrayUtils.contains(this.mCurrentUserProfiles, userId);
    }

    @GuardedBy(value={"mLock"})
    private void ensureFallbackFusedProviderPresentLocked(String[] pkgs) {
        PackageManager pm = this.mContext.getPackageManager();
        String systemPackageName = this.mContext.getPackageName();
        ArrayList<HashSet<Signature>> sigSets = ServiceWatcher.getSignatureSets(this.mContext, pkgs);
        List<ResolveInfo> rInfos = pm.queryIntentServicesAsUser(new Intent(FUSED_LOCATION_SERVICE_ACTION), 128, this.mCurrentUserId);
        for (ResolveInfo rInfo : rInfos) {
            String packageName;
            block9: {
                packageName = rInfo.serviceInfo.packageName;
                try {
                    PackageInfo pInfo = pm.getPackageInfo(packageName, 64);
                    if (!ServiceWatcher.isSignatureMatch(pInfo.signatures, sigSets)) {
                        Log.w(TAG, packageName + " resolves service " + FUSED_LOCATION_SERVICE_ACTION + ", but has wrong signature, ignoring");
                    }
                    break block9;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(TAG, "missing package: " + packageName);
                }
                continue;
            }
            if (rInfo.serviceInfo.metaData == null) {
                Log.w(TAG, "Found fused provider without metadata: " + packageName);
                continue;
            }
            int version = rInfo.serviceInfo.metaData.getInt("serviceVersion", -1);
            if (version == 0) {
                if ((rInfo.serviceInfo.applicationInfo.flags & 1) == 0) {
                    if (!D) continue;
                    Log.d(TAG, "Fallback candidate not in /system: " + packageName);
                    continue;
                }
                if (pm.checkSignatures(systemPackageName, packageName) != 0) {
                    if (!D) continue;
                    Log.d(TAG, "Fallback candidate not signed the same as system: " + packageName);
                    continue;
                }
                if (D) {
                    Log.d(TAG, "Found fallback provider: " + packageName);
                }
                return;
            }
            if (!D) continue;
            Log.d(TAG, "Fallback candidate not version 0: " + packageName);
        }
        throw new IllegalStateException("Unable to find a fused location provider that is in the system partition with version 0 and signed with the platform certificate. Such a package is needed to provide a default fused location provider in the event that no other fused location provider has been installed or is currently available. For example, coreOnly boot mode when decrypting the data partition. The fallback must also be marked coreApp=\"true\" in the manifest");
    }

    @GuardedBy(value={"mLock"})
    private void initializeProvidersLocked() {
        String[] testProviderStrings;
        GeofenceProxy provider;
        LocationProvider passiveProviderManager = new LocationProvider("passive");
        this.addProviderLocked(passiveProviderManager);
        this.mPassiveProvider = new PassiveProvider(this.mContext, passiveProviderManager);
        passiveProviderManager.attachLocked(this.mPassiveProvider);
        if (GnssLocationProvider.isSupported()) {
            LocationProvider gnssProviderManager = new LocationProvider("gps", true);
            this.mRealProviders.add(gnssProviderManager);
            this.addProviderLocked(gnssProviderManager);
            GnssLocationProvider gnssProvider = new GnssLocationProvider(this.mContext, gnssProviderManager, this.mHandler.getLooper());
            gnssProviderManager.attachLocked(gnssProvider);
            this.mGnssSystemInfoProvider = gnssProvider.getGnssSystemInfoProvider();
            this.mGnssBatchingProvider = gnssProvider.getGnssBatchingProvider();
            this.mGnssMetricsProvider = gnssProvider.getGnssMetricsProvider();
            this.mGnssCapabilitiesProvider = gnssProvider.getGnssCapabilitiesProvider();
            this.mGnssStatusProvider = gnssProvider.getGnssStatusProvider();
            this.mNetInitiatedListener = gnssProvider.getNetInitiatedListener();
            this.mGnssMeasurementsProvider = gnssProvider.getGnssMeasurementsProvider();
            this.mGnssMeasurementCorrectionsProvider = gnssProvider.getGnssMeasurementCorrectionsProvider();
            this.mGnssNavigationMessageProvider = gnssProvider.getGnssNavigationMessageProvider();
            this.mGpsGeofenceProxy = gnssProvider.getGpsGeofenceProxy();
        }
        Resources resources = this.mContext.getResources();
        Object[] pkgs = resources.getStringArray(17236033);
        if (D) {
            Log.d(TAG, "certificates for location providers pulled from: " + Arrays.toString(pkgs));
        }
        this.ensureFallbackFusedProviderPresentLocked((String[])pkgs);
        LocationProvider networkProviderManager = new LocationProvider("network", true);
        LocationProviderProxy networkProvider = LocationProviderProxy.createAndBind(this.mContext, networkProviderManager, NETWORK_LOCATION_SERVICE_ACTION, 17891444, 17039759, 17236033);
        if (networkProvider != null) {
            this.mRealProviders.add(networkProviderManager);
            this.addProviderLocked(networkProviderManager);
            networkProviderManager.attachLocked(networkProvider);
        } else {
            Slog.w(TAG, "no network location provider found");
        }
        LocationProvider fusedProviderManager = new LocationProvider("fused");
        LocationProviderProxy fusedProvider = LocationProviderProxy.createAndBind(this.mContext, fusedProviderManager, FUSED_LOCATION_SERVICE_ACTION, 17891436, 17039733, 17236033);
        if (fusedProvider != null) {
            this.mRealProviders.add(fusedProviderManager);
            this.addProviderLocked(fusedProviderManager);
            fusedProviderManager.attachLocked(fusedProvider);
        } else {
            Slog.e(TAG, "no fused location provider found", new IllegalStateException("Location service needs a fused location provider"));
        }
        this.mGeocodeProvider = GeocoderProxy.createAndBind(this.mContext, 17891437, 17039734, 17236033);
        if (this.mGeocodeProvider == null) {
            Slog.e(TAG, "no geocoder provider found");
        }
        if ((provider = GeofenceProxy.createAndBind(this.mContext, 17891438, 17039735, 17236033, this.mGpsGeofenceProxy, null)) == null) {
            Slog.d(TAG, "Unable to bind FLP Geofence proxy.");
        }
        boolean activityRecognitionHardwareIsSupported = ActivityRecognitionHardware.isSupported();
        ActivityRecognitionHardware activityRecognitionHardware = null;
        if (activityRecognitionHardwareIsSupported) {
            activityRecognitionHardware = ActivityRecognitionHardware.getInstance(this.mContext);
        } else {
            Slog.d(TAG, "Hardware Activity-Recognition not supported.");
        }
        ActivityRecognitionProxy proxy = ActivityRecognitionProxy.createAndBind(this.mContext, activityRecognitionHardwareIsSupported, activityRecognitionHardware, 0x1110066, 17039670, 17236033);
        if (proxy == null) {
            Slog.d(TAG, "Unable to bind ActivityRecognitionProxy.");
        }
        for (String testProviderString : testProviderStrings = resources.getStringArray(17236066)) {
            String[] fragments = testProviderString.split(",");
            String name = fragments[0].trim();
            ProviderProperties properties = new ProviderProperties(Boolean.parseBoolean(fragments[1]), Boolean.parseBoolean(fragments[2]), Boolean.parseBoolean(fragments[3]), Boolean.parseBoolean(fragments[4]), Boolean.parseBoolean(fragments[5]), Boolean.parseBoolean(fragments[6]), Boolean.parseBoolean(fragments[7]), Integer.parseInt(fragments[8]), Integer.parseInt(fragments[9]));
            LocationProvider testProviderManager = new LocationProvider(name);
            this.addProviderLocked(testProviderManager);
            new MockProvider(this.mContext, testProviderManager, properties);
        }
    }

    @GuardedBy(value={"mLock"})
    private void onUserChangedLocked(int userId) {
        if (this.mCurrentUserId == userId) {
            return;
        }
        if (D) {
            Log.d(TAG, "foreground user is changing to " + userId);
        }
        for (LocationProvider p : this.mProviders) {
            p.onUserChangingLocked();
        }
        this.mCurrentUserId = userId;
        this.onUserProfilesChangedLocked();
        this.mBlacklist.switchUser(userId);
        this.onLocationModeChangedLocked(false);
        this.onProviderAllowedChangedLocked();
        for (LocationProvider p : this.mProviders) {
            p.onUseableChangedLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locationCallbackFinished(ILocationListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            Receiver receiver = this.mReceivers.get(listener.asBinder());
            if (receiver != null) {
                receiver.decrementPendingBroadcastsLocked();
            }
        }
    }

    @Override
    public int getGnssYearOfHardware() {
        if (this.mGnssSystemInfoProvider != null) {
            return this.mGnssSystemInfoProvider.getGnssYearOfHardware();
        }
        return 0;
    }

    @Override
    public String getGnssHardwareModelName() {
        if (this.mGnssSystemInfoProvider != null) {
            return this.mGnssSystemInfoProvider.getGnssHardwareModelName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasGnssPermissions(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
            this.checkResolutionLevelIsSufficientForProviderUseLocked(allowedResolutionLevel, "gps");
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long identity = Binder.clearCallingIdentity();
            try {
                bl = this.checkLocationAccess(pid, uid, packageName, allowedResolutionLevel);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(identity);
                throw throwable;
            }
            Binder.restoreCallingIdentity(identity);
            return bl;
        }
    }

    @Override
    public int getGnssBatchSize(String packageName) {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "Location Hardware permission not granted to access hardware batching");
        if (this.hasGnssPermissions(packageName) && this.mGnssBatchingProvider != null) {
            return this.mGnssBatchingProvider.getBatchSize();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addGnssBatchingCallback(IBatchedLocationCallback callback, String packageName) {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "Location Hardware permission not granted to access hardware batching");
        if (!this.hasGnssPermissions(packageName) || this.mGnssBatchingProvider == null) {
            return false;
        }
        CallerIdentity callerIdentity = new CallerIdentity(Binder.getCallingUid(), Binder.getCallingPid(), packageName);
        Object object = this.mLock;
        synchronized (object) {
            this.mGnssBatchingCallback = callback;
            this.mGnssBatchingDeathCallback = new LinkedListener(callback, "BatchedLocationCallback", callerIdentity, listener -> {
                this.stopGnssBatch();
                this.removeGnssBatchingCallback();
            });
            return this.linkToListenerDeathNotificationLocked(callback.asBinder(), this.mGnssBatchingDeathCallback);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGnssBatchingCallback() {
        Object object = this.mLock;
        synchronized (object) {
            this.unlinkFromListenerDeathNotificationLocked(this.mGnssBatchingCallback.asBinder(), this.mGnssBatchingDeathCallback);
            this.mGnssBatchingCallback = null;
            this.mGnssBatchingDeathCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startGnssBatch(long periodNanos, boolean wakeOnFifoFull, String packageName) {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "Location Hardware permission not granted to access hardware batching");
        if (!this.hasGnssPermissions(packageName) || this.mGnssBatchingProvider == null) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mGnssBatchingInProgress) {
                Log.e(TAG, "startGnssBatch unexpectedly called w/o stopping prior batch");
                this.stopGnssBatch();
            }
            this.mGnssBatchingInProgress = true;
            return this.mGnssBatchingProvider.start(periodNanos, wakeOnFifoFull);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushGnssBatch(String packageName) {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "Location Hardware permission not granted to access hardware batching");
        if (!this.hasGnssPermissions(packageName)) {
            Log.e(TAG, "flushGnssBatch called without GNSS permissions");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mGnssBatchingInProgress) {
                Log.w(TAG, "flushGnssBatch called with no batch in progress");
            }
            if (this.mGnssBatchingProvider != null) {
                this.mGnssBatchingProvider.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopGnssBatch() {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "Location Hardware permission not granted to access hardware batching");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mGnssBatchingProvider != null) {
                this.mGnssBatchingInProgress = false;
                return this.mGnssBatchingProvider.stop();
            }
            return false;
        }
    }

    @GuardedBy(value={"mLock"})
    private void addProviderLocked(LocationProvider provider) {
        Preconditions.checkState(this.getLocationProviderLocked(provider.getName()) == null);
        this.mProviders.add(provider);
        provider.onAllowedChangedLocked();
        provider.onUseableChangedLocked(false);
    }

    @GuardedBy(value={"mLock"})
    private void removeProviderLocked(LocationProvider provider) {
        if (this.mProviders.remove(provider)) {
            provider.onUseableChangedLocked(false);
        }
    }

    @GuardedBy(value={"mLock"})
    private LocationProvider getLocationProviderLocked(String providerName) {
        for (LocationProvider provider : this.mProviders) {
            if (!providerName.equals(provider.getName())) continue;
            return provider;
        }
        return null;
    }

    private String getResolutionPermission(int resolutionLevel) {
        switch (resolutionLevel) {
            case 2: {
                return "android.permission.ACCESS_FINE_LOCATION";
            }
            case 1: {
                return "android.permission.ACCESS_COARSE_LOCATION";
            }
        }
        return null;
    }

    private int getAllowedResolutionLevel(int pid, int uid) {
        if (this.mContext.checkPermission("android.permission.ACCESS_FINE_LOCATION", pid, uid) == 0) {
            return 2;
        }
        if (this.mContext.checkPermission("android.permission.ACCESS_COARSE_LOCATION", pid, uid) == 0) {
            return 1;
        }
        return 0;
    }

    private int getCallerAllowedResolutionLevel() {
        return this.getAllowedResolutionLevel(Binder.getCallingPid(), Binder.getCallingUid());
    }

    private void checkResolutionLevelIsSufficientForGeofenceUse(int allowedResolutionLevel) {
        if (allowedResolutionLevel < 2) {
            throw new SecurityException("Geofence usage requires ACCESS_FINE_LOCATION permission");
        }
    }

    @GuardedBy(value={"mLock"})
    private int getMinimumResolutionLevelForProviderUseLocked(String provider) {
        if ("gps".equals(provider) || "passive".equals(provider)) {
            return 2;
        }
        if ("network".equals(provider) || "fused".equals(provider)) {
            return 1;
        }
        for (LocationProvider lp : this.mProviders) {
            ProviderProperties properties;
            if (!lp.getName().equals(provider) || (properties = lp.getPropertiesLocked()) == null) continue;
            if (properties.mRequiresSatellite) {
                return 2;
            }
            if (!properties.mRequiresNetwork && !properties.mRequiresCell) continue;
            return 1;
        }
        return 2;
    }

    @GuardedBy(value={"mLock"})
    private void checkResolutionLevelIsSufficientForProviderUseLocked(int allowedResolutionLevel, String providerName) {
        int requiredResolutionLevel = this.getMinimumResolutionLevelForProviderUseLocked(providerName);
        if (allowedResolutionLevel < requiredResolutionLevel) {
            switch (requiredResolutionLevel) {
                case 2: {
                    throw new SecurityException("\"" + providerName + "\" location provider requires ACCESS_FINE_LOCATION permission.");
                }
                case 1: {
                    throw new SecurityException("\"" + providerName + "\" location provider requires ACCESS_COARSE_LOCATION or ACCESS_FINE_LOCATION permission.");
                }
            }
            throw new SecurityException("Insufficient permission for \"" + providerName + "\" location provider.");
        }
    }

    public static int resolutionLevelToOp(int allowedResolutionLevel) {
        if (allowedResolutionLevel != 0) {
            if (allowedResolutionLevel == 1) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    private static String resolutionLevelToOpStr(int allowedResolutionLevel) {
        switch (allowedResolutionLevel) {
            case 1: {
                return "android:coarse_location";
            }
            case 2: {
                return "android:fine_location";
            }
            case 0: {
                return "android:fine_location";
            }
        }
        return "android:fine_location";
    }

    private boolean reportLocationAccessNoThrow(int pid, int uid, String packageName, int allowedResolutionLevel) {
        int op = LocationManagerService.resolutionLevelToOp(allowedResolutionLevel);
        if (op >= 0 && this.mAppOps.noteOpNoThrow(op, uid, packageName) != 0) {
            return false;
        }
        return this.getAllowedResolutionLevel(pid, uid) >= allowedResolutionLevel;
    }

    private boolean checkLocationAccess(int pid, int uid, String packageName, int allowedResolutionLevel) {
        int op = LocationManagerService.resolutionLevelToOp(allowedResolutionLevel);
        if (op >= 0 && this.mAppOps.checkOp(op, uid, packageName) != 0) {
            return false;
        }
        return this.getAllowedResolutionLevel(pid, uid) >= allowedResolutionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllProviders() {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<String> providers = new ArrayList<String>(this.mProviders.size());
            for (LocationProvider provider : this.mProviders) {
                String name = provider.getName();
                if ("fused".equals(name)) continue;
                providers.add(name);
            }
            return providers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getProviders(Criteria criteria, boolean enabledOnly) {
        int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<String> providers = new ArrayList<String>(this.mProviders.size());
            for (LocationProvider provider : this.mProviders) {
                String name = provider.getName();
                if ("fused".equals(name) || allowedResolutionLevel < this.getMinimumResolutionLevelForProviderUseLocked(name) || enabledOnly && !provider.isUseableLocked() || criteria != null && !android.location.LocationProvider.propertiesMeetCriteria(name, provider.getPropertiesLocked(), criteria)) continue;
                providers.add(name);
            }
            return providers;
        }
    }

    @Override
    public String getBestProvider(Criteria criteria, boolean enabledOnly) {
        List<String> providers = this.getProviders(criteria, enabledOnly);
        if (providers.isEmpty()) {
            providers = this.getProviders(null, enabledOnly);
        }
        if (!providers.isEmpty()) {
            if (providers.contains("gps")) {
                return "gps";
            }
            if (providers.contains("network")) {
                return "network";
            }
            return providers.get(0);
        }
        return null;
    }

    @GuardedBy(value={"mLock"})
    private void updateProviderUseableLocked(LocationProvider provider) {
        boolean useable = provider.isUseableLocked();
        ArrayList<Receiver> deadReceivers = null;
        ArrayList<UpdateRecord> records = this.mRecordsByProvider.get(provider.getName());
        if (records != null) {
            for (UpdateRecord record : records) {
                if (!this.isCurrentProfileLocked(UserHandle.getUserId(((UpdateRecord)record).mReceiver.mCallerIdentity.mUid)) || this.isSettingsExemptLocked(record) || record.mReceiver.callProviderEnabledLocked(provider.getName(), useable)) continue;
                if (deadReceivers == null) {
                    deadReceivers = new ArrayList<Receiver>();
                }
                deadReceivers.add(record.mReceiver);
            }
        }
        if (deadReceivers != null) {
            for (int i = deadReceivers.size() - 1; i >= 0; --i) {
                this.removeUpdatesLocked((Receiver)deadReceivers.get(i));
            }
        }
        this.applyRequirementsLocked(provider);
    }

    @GuardedBy(value={"mLock"})
    private void applyRequirementsLocked(String providerName) {
        LocationProvider provider = this.getLocationProviderLocked(providerName);
        if (provider != null) {
            this.applyRequirementsLocked(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mLock"})
    private void applyRequirementsLocked(LocationProvider provider) {
        ArrayList<UpdateRecord> records = this.mRecordsByProvider.get(provider.getName());
        WorkSource worksource = new WorkSource();
        ProviderRequest providerRequest = new ProviderRequest();
        if (this.mProviders.contains(provider) && records != null && !records.isEmpty()) {
            long backgroundThrottleInterval;
            long identity = Binder.clearCallingIdentity();
            try {
                backgroundThrottleInterval = Settings.Global.getLong(this.mContext.getContentResolver(), "location_background_throttle_interval_ms", 1800000L);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            boolean isForegroundOnlyMode = this.mBatterySaverMode == 3;
            boolean shouldThrottleRequests = this.mBatterySaverMode == 4 && !this.mPowerManager.isInteractive();
            providerRequest.lowPowerMode = true;
            for (UpdateRecord record : records) {
                boolean isBatterySaverDisablingLocation;
                if (!this.isCurrentProfileLocked(UserHandle.getUserId(((UpdateRecord)record).mReceiver.mCallerIdentity.mUid)) || !this.checkLocationAccess(((UpdateRecord)record).mReceiver.mCallerIdentity.mPid, ((UpdateRecord)record).mReceiver.mCallerIdentity.mUid, ((UpdateRecord)record).mReceiver.mCallerIdentity.mPackageName, record.mReceiver.mAllowedResolutionLevel)) continue;
                boolean bl = isBatterySaverDisablingLocation = shouldThrottleRequests || isForegroundOnlyMode && !record.mIsForegroundUid;
                if (!provider.isUseableLocked() || isBatterySaverDisablingLocation) {
                    if (!this.isSettingsExemptLocked(record)) continue;
                    providerRequest.locationSettingsIgnored = true;
                    providerRequest.lowPowerMode = false;
                }
                LocationRequest locationRequest = record.mRealRequest;
                long interval = locationRequest.getInterval();
                if (!providerRequest.locationSettingsIgnored && !this.isThrottlingExemptLocked(((UpdateRecord)record).mReceiver.mCallerIdentity)) {
                    if (!record.mIsForegroundUid) {
                        interval = Math.max(interval, backgroundThrottleInterval);
                    }
                    if (interval != locationRequest.getInterval()) {
                        locationRequest = new LocationRequest(locationRequest);
                        locationRequest.setInterval(interval);
                    }
                }
                record.mRequest = locationRequest;
                providerRequest.locationRequests.add(locationRequest);
                if (!locationRequest.isLowPowerMode()) {
                    providerRequest.lowPowerMode = false;
                }
                if (interval >= providerRequest.interval) continue;
                providerRequest.reportLocation = true;
                providerRequest.interval = interval;
            }
            if (providerRequest.reportLocation) {
                long thresholdInterval = (providerRequest.interval + 1000L) * 3L / 2L;
                for (UpdateRecord record : records) {
                    LocationRequest locationRequest;
                    if (!this.isCurrentProfileLocked(UserHandle.getUserId(((UpdateRecord)record).mReceiver.mCallerIdentity.mUid)) || !providerRequest.locationRequests.contains(locationRequest = record.mRequest) || locationRequest.getInterval() > thresholdInterval) continue;
                    if (((UpdateRecord)record).mReceiver.mWorkSource != null && LocationManagerService.isValidWorkSource(((UpdateRecord)record).mReceiver.mWorkSource)) {
                        worksource.add(((UpdateRecord)record).mReceiver.mWorkSource);
                        continue;
                    }
                    worksource.add(((UpdateRecord)record).mReceiver.mCallerIdentity.mUid, ((UpdateRecord)record).mReceiver.mCallerIdentity.mPackageName);
                }
            }
        }
        provider.setRequestLocked(providerRequest, worksource);
    }

    private static boolean isValidWorkSource(WorkSource workSource) {
        if (workSource.size() > 0) {
            return workSource.getName(0) != null;
        }
        ArrayList<WorkSource.WorkChain> workChains = workSource.getWorkChains();
        return workChains != null && !workChains.isEmpty() && workChains.get(0).getAttributionTag() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getBackgroundThrottlingWhitelist() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBackgroundThrottlePackageWhitelist.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getIgnoreSettingsWhitelist() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIgnoreSettingsPackageWhitelist.toArray(new String[0]);
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean isThrottlingExemptLocked(CallerIdentity callerIdentity) {
        if (callerIdentity.mUid == 1000) {
            return true;
        }
        if (this.mBackgroundThrottlePackageWhitelist.contains(callerIdentity.mPackageName)) {
            return true;
        }
        return this.isProviderPackage(callerIdentity.mPackageName);
    }

    @GuardedBy(value={"mLock"})
    private boolean isSettingsExemptLocked(UpdateRecord record) {
        if (!record.mRealRequest.isLocationSettingsIgnored()) {
            return false;
        }
        if (this.mIgnoreSettingsPackageWhitelist.contains(((UpdateRecord)record).mReceiver.mCallerIdentity.mPackageName)) {
            return true;
        }
        return this.isProviderPackage(((UpdateRecord)record).mReceiver.mCallerIdentity.mPackageName);
    }

    @GuardedBy(value={"mLock"})
    private Receiver getReceiverLocked(ILocationListener listener, int pid, int uid, String packageName, WorkSource workSource, boolean hideFromAppOps) {
        IBinder binder = listener.asBinder();
        Receiver receiver = this.mReceivers.get(binder);
        if (receiver == null) {
            receiver = new Receiver(listener, null, pid, uid, packageName, workSource, hideFromAppOps);
            if (!this.linkToListenerDeathNotificationLocked(receiver.getListener().asBinder(), receiver)) {
                return null;
            }
            this.mReceivers.put(binder, receiver);
        }
        return receiver;
    }

    @GuardedBy(value={"mLock"})
    private Receiver getReceiverLocked(PendingIntent intent, int pid, int uid, String packageName, WorkSource workSource, boolean hideFromAppOps) {
        Receiver receiver = this.mReceivers.get(intent);
        if (receiver == null) {
            receiver = new Receiver(null, intent, pid, uid, packageName, workSource, hideFromAppOps);
            this.mReceivers.put(intent, receiver);
        }
        return receiver;
    }

    private LocationRequest createSanitizedRequest(LocationRequest request, int resolutionLevel, boolean callerHasLocationHardwarePermission) {
        LocationRequest sanitizedRequest = new LocationRequest(request);
        if (!callerHasLocationHardwarePermission) {
            sanitizedRequest.setLowPowerMode(false);
        }
        if (resolutionLevel < 2) {
            switch (sanitizedRequest.getQuality()) {
                case 100: {
                    sanitizedRequest.setQuality(102);
                    break;
                }
                case 203: {
                    sanitizedRequest.setQuality(201);
                }
            }
            if (sanitizedRequest.getInterval() < 600000L) {
                sanitizedRequest.setInterval(600000L);
            }
            if (sanitizedRequest.getFastestInterval() < 600000L) {
                sanitizedRequest.setFastestInterval(600000L);
            }
        }
        if (sanitizedRequest.getFastestInterval() > sanitizedRequest.getInterval()) {
            sanitizedRequest.setFastestInterval(request.getInterval());
        }
        return sanitizedRequest;
    }

    private void checkPackageName(String packageName) {
        if (packageName == null) {
            throw new SecurityException("invalid package name: " + null);
        }
        int uid = Binder.getCallingUid();
        String[] packages = this.mPackageManager.getPackagesForUid(uid);
        if (packages == null) {
            throw new SecurityException("invalid UID " + uid);
        }
        for (String pkg : packages) {
            if (!packageName.equals(pkg)) continue;
            return;
        }
        throw new SecurityException("invalid package name: " + packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestLocationUpdates(LocationRequest request, ILocationListener listener, PendingIntent intent, String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            boolean hideFromAppOps;
            if (request == null) {
                request = DEFAULT_LOCATION_REQUEST;
            }
            this.checkPackageName(packageName);
            int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
            this.checkResolutionLevelIsSufficientForProviderUseLocked(allowedResolutionLevel, request.getProvider());
            WorkSource workSource = request.getWorkSource();
            if (workSource != null && !workSource.isEmpty()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_DEVICE_STATS", null);
            }
            if (hideFromAppOps = request.getHideFromAppOps()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_APP_OPS_STATS", null);
            }
            if (request.isLocationSettingsIgnored()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", null);
            }
            boolean callerHasLocationHardwarePermission = this.mContext.checkCallingPermission("android.permission.LOCATION_HARDWARE") == 0;
            LocationRequest sanitizedRequest = this.createSanitizedRequest(request, allowedResolutionLevel, callerHasLocationHardwarePermission);
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long identity = Binder.clearCallingIdentity();
            try {
                this.checkLocationAccess(pid, uid, packageName, allowedResolutionLevel);
                if (intent == null && listener == null) {
                    throw new IllegalArgumentException("need either listener or intent");
                }
                if (intent != null && listener != null) {
                    throw new IllegalArgumentException("cannot register both listener and intent");
                }
                this.mLocationUsageLogger.logLocationApiUsage(0, 1, packageName, request, listener != null, intent != null, null, this.mActivityManager.getPackageImportance(packageName));
                Receiver receiver = intent != null ? this.getReceiverLocked(intent, pid, uid, packageName, workSource, hideFromAppOps) : this.getReceiverLocked(listener, pid, uid, packageName, workSource, hideFromAppOps);
                this.requestLocationUpdatesLocked(sanitizedRequest, receiver, uid, packageName);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void requestLocationUpdatesLocked(LocationRequest request, Receiver receiver, int uid, String packageName) {
        UpdateRecord oldRecord;
        String name;
        if (request == null) {
            request = DEFAULT_LOCATION_REQUEST;
        }
        if ((name = request.getProvider()) == null) {
            throw new IllegalArgumentException("provider name must not be null");
        }
        LocationProvider provider = this.getLocationProviderLocked(name);
        if (provider == null) {
            throw new IllegalArgumentException("provider doesn't exist: " + name);
        }
        UpdateRecord record = new UpdateRecord(name, request, receiver);
        if (D) {
            Log.d(TAG, "request " + Integer.toHexString(System.identityHashCode(receiver)) + " " + name + " " + request + " from " + packageName + "(" + uid + " " + (record.mIsForegroundUid ? "foreground" : "background") + (this.isThrottlingExemptLocked(receiver.mCallerIdentity) ? " [whitelisted]" : "") + ")");
        }
        if ((oldRecord = receiver.mUpdateRecords.put(name, record)) != null) {
            oldRecord.disposeLocked(false);
        }
        if (!provider.isUseableLocked() && !this.isSettingsExemptLocked(record)) {
            receiver.callProviderEnabledLocked(name, false);
        }
        this.applyRequirementsLocked(name);
        receiver.updateMonitoring(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdates(ILocationListener listener, PendingIntent intent, String packageName) {
        this.checkPackageName(packageName);
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        if (intent == null && listener == null) {
            throw new IllegalArgumentException("need either listener or intent");
        }
        if (intent != null && listener != null) {
            throw new IllegalArgumentException("cannot register both listener and intent");
        }
        Object object = this.mLock;
        synchronized (object) {
            Receiver receiver = intent != null ? this.getReceiverLocked(intent, pid, uid, packageName, null, false) : this.getReceiverLocked(listener, pid, uid, packageName, null, false);
            long identity = Binder.clearCallingIdentity();
            try {
                this.removeUpdatesLocked(receiver);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void removeUpdatesLocked(Receiver receiver) {
        if (D) {
            Log.i(TAG, "remove " + Integer.toHexString(System.identityHashCode(receiver)));
        }
        if (this.mReceivers.remove(receiver.mKey) != null && receiver.isListener()) {
            this.unlinkFromListenerDeathNotificationLocked(receiver.getListener().asBinder(), receiver);
            receiver.clearPendingBroadcastsLocked();
        }
        receiver.updateMonitoring(false);
        HashSet<String> providers = new HashSet<String>();
        HashMap<String, UpdateRecord> oldRecords = receiver.mUpdateRecords;
        if (oldRecords != null) {
            for (UpdateRecord record : oldRecords.values()) {
                record.disposeLocked(false);
            }
            providers.addAll(oldRecords.keySet());
        }
        for (String provider : providers) {
            this.applyRequirementsLocked(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Location getLastLocation(LocationRequest r, String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            LocationRequest request = r != null ? r : DEFAULT_LOCATION_REQUEST;
            int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
            this.checkPackageName(packageName);
            this.checkResolutionLevelIsSufficientForProviderUseLocked(allowedResolutionLevel, request.getProvider());
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long identity = Binder.clearCallingIdentity();
            try {
                LocationProvider provider;
                if (this.mBlacklist.isBlacklisted(packageName)) {
                    if (D) {
                        Log.d(TAG, "not returning last loc for blacklisted app: " + packageName);
                    }
                    Location location = null;
                    return location;
                }
                String name = request.getProvider();
                if (name == null) {
                    name = "fused";
                }
                if ((provider = this.getLocationProviderLocked(name)) == null) {
                    Location location = null;
                    return location;
                }
                if (!this.isCurrentProfileLocked(UserHandle.getUserId(uid)) && !this.isProviderPackage(packageName)) {
                    Location location = null;
                    return location;
                }
                if (!provider.isUseableLocked()) {
                    Location location = null;
                    return location;
                }
                Location location = allowedResolutionLevel < 2 ? this.mLastLocationCoarseInterval.get(name) : this.mLastLocation.get(name);
                if (location == null) {
                    Location location2 = null;
                    return location2;
                }
                String op = LocationManagerService.resolutionLevelToOpStr(allowedResolutionLevel);
                long locationAgeMs = SystemClock.elapsedRealtime() - location.getElapsedRealtimeNanos() / 1000000L;
                if (locationAgeMs > Settings.Global.getLong(this.mContext.getContentResolver(), "location_last_location_max_age_millis", 1200000L) && this.mAppOps.unsafeCheckOp(op, uid, packageName) == 4) {
                    Location location3 = null;
                    return location3;
                }
                Location lastLocation = null;
                if (allowedResolutionLevel < 2) {
                    Location noGPSLocation = location.getExtraLocation("noGPSLocation");
                    if (noGPSLocation != null) {
                        lastLocation = new Location(this.mLocationFudger.getOrCreate(noGPSLocation));
                    }
                } else {
                    lastLocation = new Location(location);
                }
                if (lastLocation != null && !this.reportLocationAccessNoThrow(pid, uid, packageName, allowedResolutionLevel)) {
                    if (D) {
                        Log.d(TAG, "not returning last loc for no op app: " + packageName);
                    }
                    lastLocation = null;
                }
                Location location4 = lastLocation;
                return location4;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocationTime getGnssTimeMillis() {
        Object object = this.mLock;
        synchronized (object) {
            Location location = this.mLastLocation.get("gps");
            if (location == null) {
                return null;
            }
            long currentNanos = SystemClock.elapsedRealtimeNanos();
            long deltaMs = (currentNanos - location.getElapsedRealtimeNanos()) / 1000000L;
            return new LocationTime(location.getTime() + deltaMs, currentNanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean injectLocation(Location location) {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "Location Hardware permission not granted to inject location");
        this.mContext.enforceCallingPermission("android.permission.ACCESS_FINE_LOCATION", "Access Fine Location permission not granted to inject Location");
        if (location == null) {
            if (D) {
                Log.d(TAG, "injectLocation(): called with null location");
            }
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            LocationProvider provider = this.getLocationProviderLocked(location.getProvider());
            if (provider == null || !provider.isUseableLocked()) {
                return false;
            }
            if (this.mLastLocation.get(provider.getName()) != null) {
                return false;
            }
            this.updateLastLocationLocked(location, provider.getName());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestGeofence(LocationRequest request, Geofence geofence, PendingIntent intent, String packageName) {
        int uid;
        if (request == null) {
            request = DEFAULT_LOCATION_REQUEST;
        }
        int allowedResolutionLevel = this.getCallerAllowedResolutionLevel();
        this.checkResolutionLevelIsSufficientForGeofenceUse(allowedResolutionLevel);
        if (intent == null) {
            throw new IllegalArgumentException("invalid pending intent: " + null);
        }
        this.checkPackageName(packageName);
        Object object = this.mLock;
        synchronized (object) {
            this.checkResolutionLevelIsSufficientForProviderUseLocked(allowedResolutionLevel, request.getProvider());
        }
        boolean callerHasLocationHardwarePermission = this.mContext.checkCallingPermission("android.permission.LOCATION_HARDWARE") == 0;
        LocationRequest sanitizedRequest = this.createSanitizedRequest(request, allowedResolutionLevel, callerHasLocationHardwarePermission);
        if (D) {
            Log.d(TAG, "requestGeofence: " + sanitizedRequest + " " + geofence + " " + intent);
        }
        if (UserHandle.getUserId(uid = Binder.getCallingUid()) != 0) {
            Log.w(TAG, "proximity alerts are currently available only to the primary user");
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.mLocationUsageLogger.logLocationApiUsage(0, 4, packageName, request, false, intent != null, geofence, this.mActivityManager.getPackageImportance(packageName));
            }
            this.mGeofenceManager.addFence(sanitizedRequest, geofence, intent, allowedResolutionLevel, uid, packageName);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGeofence(Geofence geofence, PendingIntent intent, String packageName) {
        if (intent == null) {
            throw new IllegalArgumentException("invalid pending intent: " + null);
        }
        this.checkPackageName(packageName);
        if (D) {
            Log.d(TAG, "removeGeofence: " + geofence + " " + intent);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mLocationUsageLogger.logLocationApiUsage(1, 4, packageName, null, false, intent != null, geofence, this.mActivityManager.getPackageImportance(packageName));
            }
            this.mGeofenceManager.removeFence(geofence, intent);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @Override
    public boolean registerGnssStatusCallback(IGnssStatusListener listener, String packageName) {
        return this.addGnssDataListener(listener, packageName, "GnssStatusListener", this.mGnssStatusProvider, this.mGnssStatusListeners, this::unregisterGnssStatusCallback);
    }

    @Override
    public void unregisterGnssStatusCallback(IGnssStatusListener listener) {
        this.removeGnssDataListener(listener, this.mGnssStatusProvider, this.mGnssStatusListeners);
    }

    @Override
    public boolean addGnssMeasurementsListener(IGnssMeasurementsListener listener, String packageName) {
        return this.addGnssDataListener(listener, packageName, "GnssMeasurementsListener", this.mGnssMeasurementsProvider, this.mGnssMeasurementsListeners, this::removeGnssMeasurementsListener);
    }

    @Override
    public void removeGnssMeasurementsListener(IGnssMeasurementsListener listener) {
        this.removeGnssDataListener(listener, this.mGnssMeasurementsProvider, this.mGnssMeasurementsListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TListener extends IInterface> boolean addGnssDataListener(TListener listener, String packageName, String listenerName, RemoteListenerHelper<TListener> gnssDataProvider, ArrayMap<IBinder, LinkedListener<TListener>> gnssDataListeners, Consumer<TListener> binderDeathCallback) {
        if (!this.hasGnssPermissions(packageName) || gnssDataProvider == null) {
            return false;
        }
        CallerIdentity callerIdentity = new CallerIdentity(Binder.getCallingUid(), Binder.getCallingPid(), packageName);
        LinkedListener linkedListener = new LinkedListener(listener, listenerName, callerIdentity, binderDeathCallback);
        IBinder binder = listener.asBinder();
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            if (!this.linkToListenerDeathNotificationLocked(binder, linkedListener)) {
                return false;
            }
            gnssDataListeners.put(binder, linkedListener);
            long identity = Binder.clearCallingIdentity();
            try {
                if (gnssDataProvider == this.mGnssMeasurementsProvider || gnssDataProvider == this.mGnssStatusProvider) {
                    this.mLocationUsageLogger.logLocationApiUsage(0, gnssDataProvider == this.mGnssMeasurementsProvider ? 2 : 3, packageName, null, true, false, null, this.mActivityManager.getPackageImportance(packageName));
                }
                if (this.isThrottlingExemptLocked(callerIdentity) || LocationManagerService.isImportanceForeground(this.mActivityManager.getPackageImportance(packageName))) {
                    gnssDataProvider.addListener(listener, callerIdentity);
                }
                bl = true;
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(identity);
                throw throwable;
            }
            Binder.restoreCallingIdentity(identity);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TListener extends IInterface> void removeGnssDataListener(TListener listener, RemoteListenerHelper<TListener> gnssDataProvider, ArrayMap<IBinder, LinkedListener<TListener>> gnssDataListeners) {
        if (gnssDataProvider == null) {
            return;
        }
        IBinder binder = listener.asBinder();
        Object object = this.mLock;
        synchronized (object) {
            LinkedListener<TListener> linkedListener = gnssDataListeners.remove(binder);
            if (linkedListener == null) {
                return;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                if (gnssDataProvider == this.mGnssMeasurementsProvider || gnssDataProvider == this.mGnssStatusProvider) {
                    this.mLocationUsageLogger.logLocationApiUsage(1, gnssDataProvider == this.mGnssMeasurementsProvider ? 2 : 3, linkedListener.mCallerIdentity.mPackageName, null, true, false, null, this.mActivityManager.getPackageImportance(linkedListener.mCallerIdentity.mPackageName));
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            this.unlinkFromListenerDeathNotificationLocked(binder, linkedListener);
            gnssDataProvider.removeListener(listener);
        }
    }

    private boolean linkToListenerDeathNotificationLocked(IBinder binder, LinkedListenerBase linkedListener) {
        try {
            binder.linkToDeath(linkedListener, 0);
            return true;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Could not link " + linkedListener.mListenerName + " death callback.", e);
            return false;
        }
    }

    private boolean unlinkFromListenerDeathNotificationLocked(IBinder binder, LinkedListenerBase linkedListener) {
        try {
            binder.unlinkToDeath(linkedListener, 0);
            return true;
        }
        catch (NoSuchElementException e) {
            Log.w(TAG, "Could not unlink " + linkedListener.mListenerName + " death callback.", e);
            return false;
        }
    }

    @Override
    public void injectGnssMeasurementCorrections(GnssMeasurementCorrections measurementCorrections, String packageName) {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "Location Hardware permission not granted to inject GNSS measurement corrections.");
        if (!this.hasGnssPermissions(packageName)) {
            Slog.e(TAG, "Can not inject GNSS corrections due to no permission.");
            return;
        }
        if (this.mGnssMeasurementCorrectionsProvider == null) {
            Slog.e(TAG, "Can not inject GNSS corrections. GNSS measurement corrections provider not available.");
            return;
        }
        this.mGnssMeasurementCorrectionsProvider.injectGnssMeasurementCorrections(measurementCorrections);
    }

    @Override
    public long getGnssCapabilities(String packageName) {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "Location Hardware permission not granted to obtain GNSS chipset capabilities.");
        if (!this.hasGnssPermissions(packageName) || this.mGnssCapabilitiesProvider == null) {
            return -1L;
        }
        return this.mGnssCapabilitiesProvider.getGnssCapabilities();
    }

    @Override
    public boolean addGnssNavigationMessageListener(IGnssNavigationMessageListener listener, String packageName) {
        return this.addGnssDataListener(listener, packageName, "GnssNavigationMessageListener", this.mGnssNavigationMessageProvider, this.mGnssNavigationMessageListeners, this::removeGnssNavigationMessageListener);
    }

    @Override
    public void removeGnssNavigationMessageListener(IGnssNavigationMessageListener listener) {
        this.removeGnssDataListener(listener, this.mGnssNavigationMessageProvider, this.mGnssNavigationMessageListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendExtraCommand(String providerName, String command, Bundle extras) {
        if (providerName == null) {
            throw new NullPointerException();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkResolutionLevelIsSufficientForProviderUseLocked(this.getCallerAllowedResolutionLevel(), providerName);
            this.mLocationUsageLogger.logLocationApiUsage(0, 5, providerName);
            if (this.mContext.checkCallingOrSelfPermission(ACCESS_LOCATION_EXTRA_COMMANDS) != 0) {
                throw new SecurityException("Requires ACCESS_LOCATION_EXTRA_COMMANDS permission");
            }
            LocationProvider provider = this.getLocationProviderLocked(providerName);
            if (provider != null) {
                provider.sendExtraCommandLocked(command, extras);
            }
            this.mLocationUsageLogger.logLocationApiUsage(1, 5, providerName);
            return true;
        }
    }

    @Override
    public boolean sendNiResponse(int notifId, int userResponse) {
        if (Binder.getCallingUid() != Process.myUid()) {
            throw new SecurityException("calling sendNiResponse from outside of the system is not allowed");
        }
        try {
            return this.mNetInitiatedListener.sendNiResponse(notifId, userResponse);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "RemoteException in LocationManagerService.sendNiResponse");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderProperties getProviderProperties(String providerName) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkResolutionLevelIsSufficientForProviderUseLocked(this.getCallerAllowedResolutionLevel(), providerName);
            LocationProvider provider = this.getLocationProviderLocked(providerName);
            if (provider == null) {
                return null;
            }
            return provider.getPropertiesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isProviderPackage(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            LocationProvider provider;
            Iterator<LocationProvider> iterator = this.mProviders.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(provider = iterator.next()).getPackagesLocked().contains(packageName));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExtraLocationControllerPackage(String packageName) {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "android.permission.LOCATION_HARDWARE permission required");
        Object object = this.mLock;
        synchronized (object) {
            this.mExtraLocationControllerPackage = packageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getExtraLocationControllerPackage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mExtraLocationControllerPackage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExtraLocationControllerPackageEnabled(boolean enabled) {
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", "android.permission.LOCATION_HARDWARE permission required");
        Object object = this.mLock;
        synchronized (object) {
            this.mExtraLocationControllerPackageEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExtraLocationControllerPackageEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mExtraLocationControllerPackageEnabled && this.mExtraLocationControllerPackage != null;
        }
    }

    private boolean isLocationEnabled() {
        return this.isLocationEnabledForUser(this.mCurrentUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocationEnabledForUser(int userId) {
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", "Requires INTERACT_ACROSS_USERS permission");
        }
        long identity = Binder.clearCallingIdentity();
        try {
            boolean bl = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "location_mode", 0, userId) != 0;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProviderEnabledForUser(String providerName, int userId) {
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", "Requires INTERACT_ACROSS_USERS permission");
        }
        if ("fused".equals(providerName)) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            LocationProvider provider = this.getLocationProviderLocked(providerName);
            return provider != null && provider.isUseableForUserLocked(userId);
        }
    }

    @GuardedBy(value={"mLock"})
    private static boolean shouldBroadcastSafeLocked(Location loc, Location lastLoc, UpdateRecord record, long now) {
        if (lastLoc == null) {
            return true;
        }
        long minTime = record.mRealRequest.getFastestInterval();
        long delta = (loc.getElapsedRealtimeNanos() - lastLoc.getElapsedRealtimeNanos()) / 1000000L;
        if (delta < minTime - 100L) {
            return false;
        }
        double minDistance = record.mRealRequest.getSmallestDisplacement();
        if (minDistance > 0.0 && (double)loc.distanceTo(lastLoc) <= minDistance) {
            return false;
        }
        if (record.mRealRequest.getNumUpdates() <= 0) {
            return false;
        }
        return record.mRealRequest.getExpireAt() >= now;
    }

    @GuardedBy(value={"mLock"})
    private void handleLocationChangedLocked(Location location, LocationProvider provider) {
        long timeDiffNanos;
        Location lastLocationCoarseInterval;
        if (!this.mProviders.contains(provider)) {
            return;
        }
        if (!location.isComplete()) {
            Log.w(TAG, "Dropping incomplete location: " + location);
            return;
        }
        if (provider.isUseableLocked() && !provider.isPassiveLocked()) {
            this.mPassiveProvider.updateLocation(location);
        }
        if (D) {
            Log.d(TAG, "incoming location: " + location);
        }
        long now = SystemClock.elapsedRealtime();
        if (provider.isUseableLocked()) {
            this.updateLastLocationLocked(location, provider.getName());
        }
        if ((lastLocationCoarseInterval = this.mLastLocationCoarseInterval.get(provider.getName())) == null) {
            lastLocationCoarseInterval = new Location(location);
            if (provider.isUseableLocked()) {
                this.mLastLocationCoarseInterval.put(provider.getName(), lastLocationCoarseInterval);
            }
        }
        if ((timeDiffNanos = location.getElapsedRealtimeNanos() - lastLocationCoarseInterval.getElapsedRealtimeNanos()) > 600000000000L) {
            lastLocationCoarseInterval.set(location);
        }
        Location noGPSLocation = lastLocationCoarseInterval.getExtraLocation("noGPSLocation");
        ArrayList<UpdateRecord> records = this.mRecordsByProvider.get(provider.getName());
        if (records == null || records.size() == 0) {
            return;
        }
        Location coarseLocation = null;
        if (noGPSLocation != null) {
            coarseLocation = this.mLocationFudger.getOrCreate(noGPSLocation);
        }
        ArrayList<Receiver> deadReceivers = null;
        ArrayList<UpdateRecord> deadUpdateRecords = null;
        for (UpdateRecord r : records) {
            Location lastLoc;
            Receiver receiver = r.mReceiver;
            boolean receiverDead = false;
            if (!provider.isUseableLocked() && !this.isSettingsExemptLocked(r)) continue;
            int receiverUserId = UserHandle.getUserId(receiver.mCallerIdentity.mUid);
            if (!this.isCurrentProfileLocked(receiverUserId) && !this.isProviderPackage(receiver.mCallerIdentity.mPackageName)) {
                if (!D) continue;
                Log.d(TAG, "skipping loc update for background user " + receiverUserId + " (current user: " + this.mCurrentUserId + ", app: " + receiver.mCallerIdentity.mPackageName + ")");
                continue;
            }
            if (this.mBlacklist.isBlacklisted(receiver.mCallerIdentity.mPackageName)) {
                if (!D) continue;
                Log.d(TAG, "skipping loc update for blacklisted app: " + receiver.mCallerIdentity.mPackageName);
                continue;
            }
            Location notifyLocation = receiver.mAllowedResolutionLevel < 2 ? coarseLocation : location;
            if (notifyLocation != null && ((lastLoc = r.mLastFixBroadcast) == null || LocationManagerService.shouldBroadcastSafeLocked(notifyLocation, lastLoc, r, now))) {
                if (lastLoc == null) {
                    lastLoc = new Location(notifyLocation);
                    r.mLastFixBroadcast = lastLoc;
                } else {
                    lastLoc.set(notifyLocation);
                }
                if (!this.reportLocationAccessNoThrow(receiver.mCallerIdentity.mPid, receiver.mCallerIdentity.mUid, receiver.mCallerIdentity.mPackageName, receiver.mAllowedResolutionLevel)) {
                    if (!D) continue;
                    Log.d(TAG, "skipping loc update for no op app: " + receiver.mCallerIdentity.mPackageName);
                    continue;
                }
                if (!receiver.callLocationChangedLocked(notifyLocation)) {
                    Slog.w(TAG, "RemoteException calling onLocationChanged on " + receiver);
                    receiverDead = true;
                }
                r.mRealRequest.decrementNumUpdates();
            }
            if (Settings.Global.getInt(this.mContext.getContentResolver(), "location_disable_status_callbacks", 1) == 0) {
                long newStatusUpdateTime = provider.getStatusUpdateTimeLocked();
                Bundle extras = new Bundle();
                int status = provider.getStatusLocked(extras);
                long prevStatusUpdateTime = r.mLastStatusBroadcast;
                if (newStatusUpdateTime > prevStatusUpdateTime && (prevStatusUpdateTime != 0L || status != 2)) {
                    r.mLastStatusBroadcast = newStatusUpdateTime;
                    if (!receiver.callStatusChangedLocked(provider.getName(), status, extras)) {
                        receiverDead = true;
                        Slog.w(TAG, "RemoteException calling onStatusChanged on " + receiver);
                    }
                }
            }
            if (r.mRealRequest.getNumUpdates() <= 0 || r.mRealRequest.getExpireAt() < now) {
                if (deadUpdateRecords == null) {
                    deadUpdateRecords = new ArrayList<UpdateRecord>();
                }
                deadUpdateRecords.add(r);
            }
            if (!receiverDead) continue;
            if (deadReceivers == null) {
                deadReceivers = new ArrayList<Receiver>();
            }
            if (deadReceivers.contains(receiver)) continue;
            deadReceivers.add(receiver);
        }
        if (deadReceivers != null) {
            for (Receiver receiver : deadReceivers) {
                this.removeUpdatesLocked(receiver);
            }
        }
        if (deadUpdateRecords != null) {
            for (UpdateRecord r : deadUpdateRecords) {
                r.disposeLocked(true);
            }
            this.applyRequirementsLocked(provider);
        }
    }

    @GuardedBy(value={"mLock"})
    private void updateLastLocationLocked(Location location, String provider) {
        Location noGPSLocation = location.getExtraLocation("noGPSLocation");
        Location lastLocation = this.mLastLocation.get(provider);
        if (lastLocation == null) {
            lastLocation = new Location(provider);
            this.mLastLocation.put(provider, lastLocation);
        } else {
            Location lastNoGPSLocation = lastLocation.getExtraLocation("noGPSLocation");
            if (noGPSLocation == null && lastNoGPSLocation != null) {
                location.setExtraLocation("noGPSLocation", lastNoGPSLocation);
            }
        }
        lastLocation.set(location);
    }

    @Override
    public boolean geocoderIsPresent() {
        return this.mGeocodeProvider != null;
    }

    @Override
    public String getFromLocation(double latitude, double longitude, int maxResults, GeocoderParams params, List<Address> addrs) {
        if (this.mGeocodeProvider != null) {
            return this.mGeocodeProvider.getFromLocation(latitude, longitude, maxResults, params, addrs);
        }
        return null;
    }

    @Override
    public String getFromLocationName(String locationName, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, int maxResults, GeocoderParams params, List<Address> addrs) {
        if (this.mGeocodeProvider != null) {
            return this.mGeocodeProvider.getFromLocationName(locationName, lowerLeftLatitude, lowerLeftLongitude, upperRightLatitude, upperRightLongitude, maxResults, params, addrs);
        }
        return null;
    }

    private boolean canCallerAccessMockLocation(String opPackageName) {
        return this.mAppOps.checkOp(58, Binder.getCallingUid(), opPackageName) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTestProvider(String name, ProviderProperties properties, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        if ("passive".equals(name)) {
            throw new IllegalArgumentException("Cannot mock the passive location provider");
        }
        Object object = this.mLock;
        synchronized (object) {
            long identity = Binder.clearCallingIdentity();
            try {
                LocationProvider oldProvider = this.getLocationProviderLocked(name);
                if (oldProvider != null) {
                    if (oldProvider.isMock()) {
                        throw new IllegalArgumentException("Provider \"" + name + "\" already exists");
                    }
                    this.removeProviderLocked(oldProvider);
                }
                MockLocationProvider mockProviderManager = new MockLocationProvider(name);
                this.addProviderLocked(mockProviderManager);
                mockProviderManager.attachLocked(new MockProvider(this.mContext, mockProviderManager, properties));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTestProvider(String name, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            long identity = Binder.clearCallingIdentity();
            try {
                LocationProvider testProvider = this.getLocationProviderLocked(name);
                if (testProvider == null || !testProvider.isMock()) {
                    throw new IllegalArgumentException("Provider \"" + name + "\" unknown");
                }
                this.removeProviderLocked(testProvider);
                LocationProvider realProvider = null;
                for (LocationProvider provider : this.mRealProviders) {
                    if (!name.equals(provider.getName())) continue;
                    realProvider = provider;
                    break;
                }
                if (realProvider != null) {
                    this.addProviderLocked(realProvider);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTestProviderLocation(String providerName, Location location, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            LocationProvider testProvider = this.getLocationProviderLocked(providerName);
            if (testProvider == null || !testProvider.isMock()) {
                throw new IllegalArgumentException("Provider \"" + providerName + "\" unknown");
            }
            String locationProvider = location.getProvider();
            if (!TextUtils.isEmpty(locationProvider) && !providerName.equals(locationProvider)) {
                EventLog.writeEvent(1397638484, "33091107", Binder.getCallingUid(), providerName + "!=" + location.getProvider());
            }
            ((MockLocationProvider)testProvider).setLocationLocked(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTestProviderEnabled(String providerName, boolean enabled, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            LocationProvider testProvider = this.getLocationProviderLocked(providerName);
            if (testProvider == null || !testProvider.isMock()) {
                throw new IllegalArgumentException("Provider \"" + providerName + "\" unknown");
            }
            ((MockLocationProvider)testProvider).setEnabledLocked(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTestProviderStatus(String providerName, int status, Bundle extras, long updateTime, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            LocationProvider testProvider = this.getLocationProviderLocked(providerName);
            if (testProvider == null || !testProvider.isMock()) {
                throw new IllegalArgumentException("Provider \"" + providerName + "\" unknown");
            }
            ((MockLocationProvider)testProvider).setStatusLocked(status, extras, updateTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LocationRequest> getTestProviderCurrentRequests(String providerName, String opPackageName) {
        if (!this.canCallerAccessMockLocation(opPackageName)) {
            return Collections.emptyList();
        }
        Object object = this.mLock;
        synchronized (object) {
            LocationProvider testProvider = this.getLocationProviderLocked(providerName);
            if (testProvider == null || !testProvider.isMock()) {
                throw new IllegalArgumentException("Provider \"" + providerName + "\" unknown");
            }
            MockLocationProvider provider = (MockLocationProvider)testProvider;
            if (provider.mCurrentRequest == null) {
                return Collections.emptyList();
            }
            ArrayList<LocationRequest> requests = new ArrayList<LocationRequest>();
            for (LocationRequest request : ((MockLocationProvider)provider).mCurrentRequest.locationRequests) {
                requests.add(new LocationRequest(request));
            }
            return requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            Location location;
            String provider;
            if (args.length > 0 && args[0].equals("--gnssmetrics")) {
                if (this.mGnssMetricsProvider != null) {
                    pw.append(this.mGnssMetricsProvider.getGnssMetricsAsProtoString());
                }
                return;
            }
            pw.println("Current Location Manager state:");
            pw.print("  Current System Time: " + TimeUtils.logTimeOfDay(System.currentTimeMillis()));
            pw.println(", Current Elapsed Time: " + TimeUtils.formatDuration(SystemClock.elapsedRealtime()));
            pw.println("  Current user: " + this.mCurrentUserId + " " + Arrays.toString(this.mCurrentUserProfiles));
            pw.println("  Location mode: " + this.isLocationEnabled());
            pw.println("  Battery Saver Location Mode: " + PowerManager.locationPowerSaveModeToString(this.mBatterySaverMode));
            pw.println("  Location Listeners:");
            for (Receiver receiver : this.mReceivers.values()) {
                pw.println("    " + receiver);
            }
            pw.println("  Active Records by Provider:");
            for (Map.Entry entry : this.mRecordsByProvider.entrySet()) {
                pw.println("    " + (String)entry.getKey() + ":");
                for (UpdateRecord record : (ArrayList)entry.getValue()) {
                    pw.println("      " + record);
                }
            }
            pw.println("  Active GnssMeasurement Listeners:");
            this.dumpGnssDataListenersLocked(pw, this.mGnssMeasurementsListeners);
            pw.println("  Active GnssNavigationMessage Listeners:");
            this.dumpGnssDataListenersLocked(pw, this.mGnssNavigationMessageListeners);
            pw.println("  Active GnssStatus Listeners:");
            this.dumpGnssDataListenersLocked(pw, this.mGnssStatusListeners);
            pw.println("  Historical Records by Provider:");
            for (Map.Entry entry : this.mRequestStatistics.statistics.entrySet()) {
                LocationRequestStatistics.PackageProviderKey key = (LocationRequestStatistics.PackageProviderKey)entry.getKey();
                LocationRequestStatistics.PackageStatistics stats = (LocationRequestStatistics.PackageStatistics)entry.getValue();
                pw.println("    " + key.packageName + ": " + key.providerName + ": " + stats);
            }
            pw.println("  Last Known Locations:");
            for (Map.Entry entry : this.mLastLocation.entrySet()) {
                provider = (String)entry.getKey();
                location = (Location)entry.getValue();
                pw.println("    " + provider + ": " + location);
            }
            pw.println("  Last Known Locations Coarse Intervals:");
            for (Map.Entry entry : this.mLastLocationCoarseInterval.entrySet()) {
                provider = (String)entry.getKey();
                location = (Location)entry.getValue();
                pw.println("    " + provider + ": " + location);
            }
            if (this.mGeofenceManager != null) {
                this.mGeofenceManager.dump(pw);
            } else {
                pw.println("  Geofences: null");
            }
            if (this.mBlacklist != null) {
                pw.append("  ");
                this.mBlacklist.dump(pw);
            } else {
                pw.println("  mBlacklist=null");
            }
            if (this.mExtraLocationControllerPackage != null) {
                pw.println(" Location controller extra package: " + this.mExtraLocationControllerPackage + " enabled: " + this.mExtraLocationControllerPackageEnabled);
            }
            if (!this.mBackgroundThrottlePackageWhitelist.isEmpty()) {
                pw.println("  Throttling Whitelisted Packages:");
                for (String string2 : this.mBackgroundThrottlePackageWhitelist) {
                    pw.println("    " + string2);
                }
            }
            if (!this.mIgnoreSettingsPackageWhitelist.isEmpty()) {
                pw.println("  Bypass Whitelisted Packages:");
                for (String string3 : this.mIgnoreSettingsPackageWhitelist) {
                    pw.println("    " + string3);
                }
            }
            if (this.mLocationFudger != null) {
                pw.append("  fudger: ");
                this.mLocationFudger.dump(fd, pw, args);
            } else {
                pw.println("  fudger: null");
            }
            if (args.length > 0 && "short".equals(args[0])) {
                return;
            }
            for (LocationProvider locationProvider : this.mProviders) {
                locationProvider.dumpLocked(fd, pw, args);
            }
            if (this.mGnssBatchingInProgress) {
                pw.println("  GNSS batching in progress");
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void dumpGnssDataListenersLocked(PrintWriter pw, ArrayMap<IBinder, ? extends LinkedListenerBase> gnssDataListeners) {
        for (LinkedListenerBase linkedListenerBase : gnssDataListeners.values()) {
            CallerIdentity callerIdentity = linkedListenerBase.mCallerIdentity;
            pw.println("    " + callerIdentity.mPid + " " + callerIdentity.mUid + " " + callerIdentity.mPackageName + ": " + this.isThrottlingExemptLocked(callerIdentity));
        }
    }

    private static class LinkedListener<TListener>
    extends LinkedListenerBase {
        private final TListener mListener;
        private final Consumer<TListener> mBinderDeathCallback;

        private LinkedListener(TListener listener, String listenerName, CallerIdentity callerIdentity, Consumer<TListener> binderDeathCallback) {
            super(callerIdentity, listenerName);
            this.mListener = listener;
            this.mBinderDeathCallback = binderDeathCallback;
        }

        @Override
        public void binderDied() {
            if (D) {
                Log.d(LocationManagerService.TAG, "Remote " + this.mListenerName + " died.");
            }
            this.mBinderDeathCallback.accept(this.mListener);
        }
    }

    private static abstract class LinkedListenerBase
    implements IBinder.DeathRecipient {
        protected final CallerIdentity mCallerIdentity;
        protected final String mListenerName;

        private LinkedListenerBase(CallerIdentity callerIdentity, String listenerName) {
            this.mCallerIdentity = callerIdentity;
            this.mListenerName = listenerName;
        }
    }

    private class UpdateRecord {
        final String mProvider;
        private final LocationRequest mRealRequest;
        LocationRequest mRequest;
        private final Receiver mReceiver;
        private boolean mIsForegroundUid;
        private Location mLastFixBroadcast;
        private long mLastStatusBroadcast;
        private Throwable mStackTrace;

        private UpdateRecord(String provider, LocationRequest request, Receiver receiver) {
            ArrayList<UpdateRecord> records;
            this.mProvider = provider;
            this.mRealRequest = request;
            this.mRequest = request;
            this.mReceiver = receiver;
            this.mIsForegroundUid = LocationManagerService.isImportanceForeground(LocationManagerService.this.mActivityManager.getPackageImportance(this.mReceiver.mCallerIdentity.mPackageName));
            if (D && receiver.mCallerIdentity.mPid == Process.myPid()) {
                this.mStackTrace = new Throwable();
            }
            if ((records = (ArrayList<UpdateRecord>)LocationManagerService.this.mRecordsByProvider.get(provider)) == null) {
                records = new ArrayList<UpdateRecord>();
                LocationManagerService.this.mRecordsByProvider.put(provider, records);
            }
            if (!records.contains(this)) {
                records.add(this);
            }
            LocationManagerService.this.mRequestStatistics.startRequesting(this.mReceiver.mCallerIdentity.mPackageName, provider, request.getInterval(), this.mIsForegroundUid);
        }

        private void updateForeground(boolean isForeground) {
            this.mIsForegroundUid = isForeground;
            LocationManagerService.this.mRequestStatistics.updateForeground(this.mReceiver.mCallerIdentity.mPackageName, this.mProvider, isForeground);
        }

        private void disposeLocked(boolean removeReceiver) {
            String packageName = this.mReceiver.mCallerIdentity.mPackageName;
            LocationManagerService.this.mRequestStatistics.stopRequesting(packageName, this.mProvider);
            LocationManagerService.this.mLocationUsageLogger.logLocationApiUsage(1, 1, packageName, this.mRealRequest, this.mReceiver.isListener(), this.mReceiver.isPendingIntent(), null, LocationManagerService.this.mActivityManager.getPackageImportance(packageName));
            ArrayList globalRecords = (ArrayList)LocationManagerService.this.mRecordsByProvider.get(this.mProvider);
            if (globalRecords != null) {
                globalRecords.remove(this);
            }
            if (!removeReceiver) {
                return;
            }
            HashMap<String, UpdateRecord> receiverRecords = this.mReceiver.mUpdateRecords;
            receiverRecords.remove(this.mProvider);
            if (receiverRecords.size() == 0) {
                LocationManagerService.this.removeUpdatesLocked(this.mReceiver);
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder("UpdateRecord[");
            b.append(this.mProvider).append(" ");
            b.append(this.mReceiver.mCallerIdentity.mPackageName);
            b.append("(").append(this.mReceiver.mCallerIdentity.mUid);
            if (this.mIsForegroundUid) {
                b.append(" foreground");
            } else {
                b.append(" background");
            }
            b.append(") ");
            b.append(this.mRealRequest).append(" ").append(this.mReceiver.mWorkSource);
            if (this.mStackTrace != null) {
                ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                this.mStackTrace.printStackTrace(new PrintStream(tmp));
                b.append("\n\n").append(tmp.toString()).append("\n");
            }
            b.append("]");
            return b.toString();
        }
    }

    private final class Receiver
    extends LinkedListenerBase
    implements PendingIntent.OnFinished {
        private static final long WAKELOCK_TIMEOUT_MILLIS = 60000L;
        private final int mAllowedResolutionLevel;
        private final ILocationListener mListener;
        final PendingIntent mPendingIntent;
        final WorkSource mWorkSource;
        private final boolean mHideFromAppOps;
        private final Object mKey;
        final HashMap<String, UpdateRecord> mUpdateRecords;
        private boolean mOpMonitoring;
        private boolean mOpHighPowerMonitoring;
        private int mPendingBroadcasts;
        PowerManager.WakeLock mWakeLock;

        private Receiver(ILocationListener listener, PendingIntent intent, int pid, int uid, String packageName, WorkSource workSource, boolean hideFromAppOps) {
            super(new CallerIdentity(uid, pid, packageName), "LocationListener");
            this.mUpdateRecords = new HashMap();
            this.mListener = listener;
            this.mPendingIntent = intent;
            this.mKey = listener != null ? listener.asBinder() : intent;
            this.mAllowedResolutionLevel = LocationManagerService.this.getAllowedResolutionLevel(pid, uid);
            if (workSource != null && workSource.isEmpty()) {
                workSource = null;
            }
            this.mWorkSource = workSource;
            this.mHideFromAppOps = hideFromAppOps;
            this.updateMonitoring(true);
            this.mWakeLock = LocationManagerService.this.mPowerManager.newWakeLock(1, LocationManagerService.WAKELOCK_KEY);
            if (workSource == null) {
                workSource = new WorkSource(this.mCallerIdentity.mUid, this.mCallerIdentity.mPackageName);
            }
            this.mWakeLock.setWorkSource(workSource);
            this.mWakeLock.setReferenceCounted(false);
        }

        public boolean equals(Object otherObj) {
            return otherObj instanceof Receiver && this.mKey.equals(((Receiver)otherObj).mKey);
        }

        public int hashCode() {
            return this.mKey.hashCode();
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("Reciever[");
            s.append(Integer.toHexString(System.identityHashCode(this)));
            if (this.mListener != null) {
                s.append(" listener");
            } else {
                s.append(" intent");
            }
            for (String p : this.mUpdateRecords.keySet()) {
                s.append(" ").append(this.mUpdateRecords.get(p).toString());
            }
            s.append(" monitoring location: ").append(this.mOpMonitoring);
            s.append("]");
            return s.toString();
        }

        public void updateMonitoring(boolean allow) {
            if (this.mHideFromAppOps) {
                return;
            }
            boolean requestingLocation = false;
            boolean requestingHighPowerLocation = false;
            if (allow) {
                for (UpdateRecord updateRecord : this.mUpdateRecords.values()) {
                    LocationProvider provider = LocationManagerService.this.getLocationProviderLocked(updateRecord.mProvider);
                    if (provider == null || !provider.isUseableLocked() && !LocationManagerService.this.isSettingsExemptLocked(updateRecord)) continue;
                    requestingLocation = true;
                    ProviderProperties properties = provider.getPropertiesLocked();
                    if (properties == null || properties.mPowerRequirement != 3 || updateRecord.mRequest.getInterval() >= 300000L) continue;
                    requestingHighPowerLocation = true;
                    break;
                }
            }
            this.mOpMonitoring = this.updateMonitoring(requestingLocation, this.mOpMonitoring, 41);
            boolean wasHighPowerMonitoring = this.mOpHighPowerMonitoring;
            this.mOpHighPowerMonitoring = this.updateMonitoring(requestingHighPowerLocation, this.mOpHighPowerMonitoring, 42);
            if (this.mOpHighPowerMonitoring != wasHighPowerMonitoring) {
                Intent intent = new Intent("android.location.HIGH_POWER_REQUEST_CHANGE");
                LocationManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            }
        }

        private boolean updateMonitoring(boolean allowMonitoring, boolean currentlyMonitoring, int op) {
            if (!currentlyMonitoring) {
                if (allowMonitoring) {
                    return LocationManagerService.this.mAppOps.startOpNoThrow(op, this.mCallerIdentity.mUid, this.mCallerIdentity.mPackageName) == 0;
                }
            } else if (!allowMonitoring || LocationManagerService.this.mAppOps.checkOpNoThrow(op, this.mCallerIdentity.mUid, this.mCallerIdentity.mPackageName) != 0) {
                LocationManagerService.this.mAppOps.finishOp(op, this.mCallerIdentity.mUid, this.mCallerIdentity.mPackageName);
                return false;
            }
            return currentlyMonitoring;
        }

        public boolean isListener() {
            return this.mListener != null;
        }

        public boolean isPendingIntent() {
            return this.mPendingIntent != null;
        }

        public ILocationListener getListener() {
            if (this.mListener != null) {
                return this.mListener;
            }
            throw new IllegalStateException("Request for non-existent listener");
        }

        public boolean callStatusChangedLocked(String provider, int status, Bundle extras) {
            if (this.mListener != null) {
                try {
                    this.mListener.onStatusChanged(provider, status, extras);
                    this.incrementPendingBroadcastsLocked();
                }
                catch (RemoteException e) {
                    return false;
                }
            }
            Intent statusChanged = new Intent();
            statusChanged.putExtras(new Bundle(extras));
            statusChanged.putExtra("status", status);
            try {
                this.mPendingIntent.send(LocationManagerService.this.mContext, 0, statusChanged, this, LocationManagerService.this.mHandler, LocationManagerService.this.getResolutionPermission(this.mAllowedResolutionLevel), PendingIntentUtils.createDontSendToRestrictedAppsBundle(null));
                this.incrementPendingBroadcastsLocked();
            }
            catch (PendingIntent.CanceledException e) {
                return false;
            }
            return true;
        }

        public boolean callLocationChangedLocked(Location location) {
            if (this.mListener != null) {
                try {
                    this.mListener.onLocationChanged(new Location(location));
                    this.incrementPendingBroadcastsLocked();
                }
                catch (RemoteException e) {
                    return false;
                }
            }
            Intent locationChanged = new Intent();
            locationChanged.putExtra("location", new Location(location));
            try {
                this.mPendingIntent.send(LocationManagerService.this.mContext, 0, locationChanged, this, LocationManagerService.this.mHandler, LocationManagerService.this.getResolutionPermission(this.mAllowedResolutionLevel), PendingIntentUtils.createDontSendToRestrictedAppsBundle(null));
                this.incrementPendingBroadcastsLocked();
            }
            catch (PendingIntent.CanceledException e) {
                return false;
            }
            return true;
        }

        private boolean callProviderEnabledLocked(String provider, boolean enabled) {
            this.updateMonitoring(true);
            if (this.mListener != null) {
                try {
                    if (enabled) {
                        this.mListener.onProviderEnabled(provider);
                    } else {
                        this.mListener.onProviderDisabled(provider);
                    }
                    this.incrementPendingBroadcastsLocked();
                }
                catch (RemoteException e) {
                    return false;
                }
            }
            Intent providerIntent = new Intent();
            providerIntent.putExtra("providerEnabled", enabled);
            try {
                this.mPendingIntent.send(LocationManagerService.this.mContext, 0, providerIntent, this, LocationManagerService.this.mHandler, LocationManagerService.this.getResolutionPermission(this.mAllowedResolutionLevel), PendingIntentUtils.createDontSendToRestrictedAppsBundle(null));
                this.incrementPendingBroadcastsLocked();
            }
            catch (PendingIntent.CanceledException e) {
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            if (D) {
                Log.d(LocationManagerService.TAG, "Remote " + this.mListenerName + " died.");
            }
            Object object = LocationManagerService.this.mLock;
            synchronized (object) {
                LocationManagerService.this.removeUpdatesLocked(this);
                this.clearPendingBroadcastsLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
            Object object = LocationManagerService.this.mLock;
            synchronized (object) {
                this.decrementPendingBroadcastsLocked();
            }
        }

        private void incrementPendingBroadcastsLocked() {
            ++this.mPendingBroadcasts;
            long identity = Binder.clearCallingIdentity();
            try {
                this.mWakeLock.acquire(60000L);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private void decrementPendingBroadcastsLocked() {
            if (--this.mPendingBroadcasts == 0) {
                long identity = Binder.clearCallingIdentity();
                try {
                    if (this.mWakeLock.isHeld()) {
                        this.mWakeLock.release();
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        public void clearPendingBroadcastsLocked() {
            if (this.mPendingBroadcasts > 0) {
                this.mPendingBroadcasts = 0;
                long identity = Binder.clearCallingIdentity();
                try {
                    if (this.mWakeLock.isHeld()) {
                        this.mWakeLock.release();
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    private class MockLocationProvider
    extends LocationProvider {
        private ProviderRequest mCurrentRequest;

        private MockLocationProvider(String name) {
            super(name);
        }

        @Override
        public void attachLocked(AbstractLocationProvider provider) {
            Preconditions.checkState(provider instanceof MockProvider);
            super.attachLocked(provider);
        }

        @Override
        public boolean isMock() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value={"mLock"})
        public void setEnabledLocked(boolean enabled) {
            if (this.mProvider != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    ((MockProvider)this.mProvider).setEnabled(enabled);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value={"mLock"})
        public void setLocationLocked(Location location) {
            if (this.mProvider != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    ((MockProvider)this.mProvider).setLocation(location);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        @Override
        @GuardedBy(value={"mLock"})
        public void setRequestLocked(ProviderRequest request, WorkSource workSource) {
            super.setRequestLocked(request, workSource);
            this.mCurrentRequest = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value={"mLock"})
        public void setStatusLocked(int status, Bundle extras, long updateTime) {
            if (this.mProvider != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    ((MockProvider)this.mProvider).setStatus(status, extras, updateTime);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    private class LocationProvider
    implements AbstractLocationProvider.LocationProviderManager {
        private final String mName;
        private final boolean mIsManagedBySettings;
        @GuardedBy(value={"mLock"})
        protected AbstractLocationProvider mProvider;
        @GuardedBy(value={"mLock"})
        private boolean mUseable;
        @GuardedBy(value={"mLock"})
        private boolean mAllowed;
        @GuardedBy(value={"mLock"})
        private boolean mEnabled;
        @GuardedBy(value={"mLock"})
        private ProviderProperties mProperties;

        private LocationProvider(String name) {
            this(name, false);
        }

        private LocationProvider(String name, boolean isManagedBySettings) {
            this.mName = name;
            this.mIsManagedBySettings = isManagedBySettings;
            this.mProvider = null;
            this.mUseable = false;
            this.mAllowed = !this.mIsManagedBySettings;
            this.mEnabled = false;
            this.mProperties = null;
            if (this.mIsManagedBySettings) {
                Settings.Secure.putStringForUser(LocationManagerService.this.mContext.getContentResolver(), "location_providers_allowed", "-" + this.mName, LocationManagerService.this.mCurrentUserId);
            }
        }

        @GuardedBy(value={"mLock"})
        public void attachLocked(AbstractLocationProvider provider) {
            Preconditions.checkNotNull(provider);
            Preconditions.checkState(this.mProvider == null);
            if (D) {
                Log.d(LocationManagerService.TAG, this.mName + " provider attached");
            }
            this.mProvider = provider;
            this.onUseableChangedLocked(false);
        }

        public String getName() {
            return this.mName;
        }

        @GuardedBy(value={"mLock"})
        public List<String> getPackagesLocked() {
            if (this.mProvider == null) {
                return Collections.emptyList();
            }
            return this.mProvider.getProviderPackages();
        }

        public boolean isMock() {
            return false;
        }

        @GuardedBy(value={"mLock"})
        public boolean isPassiveLocked() {
            return this.mProvider == LocationManagerService.this.mPassiveProvider;
        }

        @GuardedBy(value={"mLock"})
        public ProviderProperties getPropertiesLocked() {
            return this.mProperties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value={"mLock"})
        public void setRequestLocked(ProviderRequest request, WorkSource workSource) {
            if (this.mProvider != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mProvider.setRequest(request, workSource);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value={"mLock"})
        public void dumpLocked(FileDescriptor fd, PrintWriter pw, String[] args) {
            pw.print("  " + this.mName + " provider");
            if (this.isMock()) {
                pw.print(" [mock]");
            }
            pw.println(":");
            pw.println("    useable=" + this.mUseable);
            if (!this.mUseable) {
                pw.println("    attached=" + (this.mProvider != null));
                if (this.mIsManagedBySettings) {
                    pw.println("    allowed=" + this.mAllowed);
                }
                pw.println("    enabled=" + this.mEnabled);
            }
            pw.println("    properties=" + this.mProperties);
            if (this.mProvider != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mProvider.dump(fd, pw, args);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value={"mLock"})
        public long getStatusUpdateTimeLocked() {
            if (this.mProvider != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    long l = this.mProvider.getStatusUpdateTime();
                    return l;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value={"mLock"})
        public int getStatusLocked(Bundle extras) {
            if (this.mProvider != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    int n = this.mProvider.getStatus(extras);
                    return n;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value={"mLock"})
        public void sendExtraCommandLocked(String command, Bundle extras) {
            if (this.mProvider != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mProvider.sendExtraCommand(command, extras);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        @Override
        public void onReportLocation(Location location) {
            LocationManagerService.this.mHandler.post(() -> {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    LocationManagerService.this.handleLocationChangedLocked(location, this);
                }
            });
        }

        @Override
        public void onReportLocation(List<Location> locations) {
            LocationManagerService.this.mHandler.post(() -> {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    LocationProvider gpsProvider = LocationManagerService.this.getLocationProviderLocked("gps");
                    if (gpsProvider == null || !gpsProvider.isUseableLocked()) {
                        Slog.w(LocationManagerService.TAG, "reportLocationBatch() called without user permission");
                        return;
                    }
                    if (LocationManagerService.this.mGnssBatchingCallback == null) {
                        Slog.e(LocationManagerService.TAG, "reportLocationBatch() called without active Callback");
                        return;
                    }
                    try {
                        LocationManagerService.this.mGnssBatchingCallback.onLocationBatch(locations);
                    }
                    catch (RemoteException e) {
                        Slog.e(LocationManagerService.TAG, "mGnssBatchingCallback.onLocationBatch failed", e);
                    }
                }
            });
        }

        @Override
        public void onSetEnabled(boolean enabled) {
            LocationManagerService.this.mHandler.post(() -> {
                Object object = LocationManagerService.this.mLock;
                synchronized (object) {
                    if (enabled == this.mEnabled) {
                        return;
                    }
                    if (D) {
                        Log.d(LocationManagerService.TAG, this.mName + " provider enabled is now " + this.mEnabled);
                    }
                    this.mEnabled = enabled;
                    this.onUseableChangedLocked(false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSetProperties(ProviderProperties properties) {
            Object object = LocationManagerService.this.mLock;
            synchronized (object) {
                this.mProperties = properties;
            }
        }

        @GuardedBy(value={"mLock"})
        public void onLocationModeChangedLocked() {
            this.onUseableChangedLocked(false);
        }

        @GuardedBy(value={"mLock"})
        public void onAllowedChangedLocked() {
            if (this.mIsManagedBySettings) {
                String allowedProviders = Settings.Secure.getStringForUser(LocationManagerService.this.mContext.getContentResolver(), "location_providers_allowed", LocationManagerService.this.mCurrentUserId);
                boolean allowed = TextUtils.delimitedStringContains(allowedProviders, ',', this.mName);
                if (allowed == this.mAllowed) {
                    return;
                }
                if (D) {
                    Log.d(LocationManagerService.TAG, this.mName + " provider allowed is now " + this.mAllowed);
                }
                this.mAllowed = allowed;
                this.onUseableChangedLocked(true);
            }
        }

        @GuardedBy(value={"mLock"})
        public boolean isUseableLocked() {
            return this.isUseableForUserLocked(LocationManagerService.this.mCurrentUserId);
        }

        @GuardedBy(value={"mLock"})
        public boolean isUseableForUserLocked(int userId) {
            return LocationManagerService.this.isCurrentProfileLocked(userId) && this.mUseable;
        }

        @GuardedBy(value={"mLock"})
        private boolean isUseableIgnoringAllowedLocked() {
            return this.mProvider != null && LocationManagerService.this.mProviders.contains(this) && LocationManagerService.this.isLocationEnabled() && this.mEnabled;
        }

        @GuardedBy(value={"mLock"})
        public void onUseableChangedLocked(boolean isAllowedChanged) {
            boolean useable;
            boolean useableIgnoringAllowed = this.isUseableIgnoringAllowedLocked();
            boolean bl = useable = useableIgnoringAllowed && this.mAllowed;
            if (this.mIsManagedBySettings) {
                if (useableIgnoringAllowed && !isAllowedChanged) {
                    Settings.Secure.putStringForUser(LocationManagerService.this.mContext.getContentResolver(), "location_providers_allowed", "+" + this.mName, LocationManagerService.this.mCurrentUserId);
                } else if (!useableIgnoringAllowed) {
                    Settings.Secure.putStringForUser(LocationManagerService.this.mContext.getContentResolver(), "location_providers_allowed", "-" + this.mName, LocationManagerService.this.mCurrentUserId);
                }
                Intent intent = new Intent("android.location.PROVIDERS_CHANGED");
                intent.putExtra("android.location.extra.PROVIDER_NAME", this.mName);
                LocationManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            }
            if (useable == this.mUseable) {
                return;
            }
            this.mUseable = useable;
            if (D) {
                Log.d(LocationManagerService.TAG, this.mName + " provider useable is now " + this.mUseable);
            }
            if (!this.mUseable) {
                LocationManagerService.this.mLastLocation.clear();
                LocationManagerService.this.mLastLocationCoarseInterval.clear();
            }
            LocationManagerService.this.updateProviderUseableLocked(this);
        }

        @GuardedBy(value={"mLock"})
        public void onUserChangingLocked() {
            this.mUseable = false;
            LocationManagerService.this.updateProviderUseableLocked(this);
        }
    }
}

