/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.location.Geofence;
import android.location.LocationRequest;
import android.os.SystemClock;
import android.util.Log;
import android.util.StatsLog;
import java.time.Instant;

class LocationUsageLogger {
    private static final String TAG = "LocationUsageLogger";
    private static final boolean D = Log.isLoggable("LocationUsageLogger", 3);
    private static final int ONE_SEC_IN_MILLIS = 1000;
    private static final int ONE_MINUTE_IN_MILLIS = 60000;
    private static final int ONE_HOUR_IN_MILLIS = 3600000;
    private long mLastApiUsageLogHour = 0L;
    private int mApiUsageLogHourlyCount = 0;
    private static final int API_USAGE_LOG_HOURLY_CAP = 60;

    LocationUsageLogger() {
    }

    private static int providerNameToStatsdEnum(String provider) {
        if ("network".equals(provider)) {
            return 1;
        }
        if ("gps".equals(provider)) {
            return 2;
        }
        if ("passive".equals(provider)) {
            return 3;
        }
        if ("fused".equals(provider)) {
            return 4;
        }
        return 0;
    }

    private static int bucketizeIntervalToStatsdEnum(long interval) {
        if (interval < 1000L) {
            return 1;
        }
        if (interval < 5000L) {
            return 2;
        }
        if (interval < 60000L) {
            return 3;
        }
        if (interval < 600000L) {
            return 4;
        }
        if (interval < 3600000L) {
            return 5;
        }
        return 6;
    }

    private static int bucketizeSmallestDisplacementToStatsdEnum(float smallestDisplacement) {
        if (smallestDisplacement == 0.0f) {
            return 1;
        }
        if (smallestDisplacement > 0.0f && smallestDisplacement <= 100.0f) {
            return 2;
        }
        return 3;
    }

    private static int bucketizeRadiusToStatsdEnum(float radius) {
        if (radius < 0.0f) {
            return 7;
        }
        if (radius < 100.0f) {
            return 1;
        }
        if (radius < 200.0f) {
            return 2;
        }
        if (radius < 300.0f) {
            return 3;
        }
        if (radius < 1000.0f) {
            return 4;
        }
        if (radius < 10000.0f) {
            return 5;
        }
        return 6;
    }

    private static int getBucketizedExpireIn(long expireAt) {
        if (expireAt == Long.MAX_VALUE) {
            return 6;
        }
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long expireIn = Math.max(0L, expireAt - elapsedRealtime);
        if (expireIn < 20000L) {
            return 1;
        }
        if (expireIn < 60000L) {
            return 2;
        }
        if (expireIn < 600000L) {
            return 3;
        }
        if (expireIn < 3600000L) {
            return 4;
        }
        return 5;
    }

    private static int categorizeActivityImportance(int importance) {
        if (importance == 100) {
            return 1;
        }
        if (importance == 125) {
            return 2;
        }
        return 3;
    }

    private static int getCallbackType(int apiType, boolean hasListener, boolean hasIntent) {
        if (apiType == 5) {
            return 1;
        }
        if (hasIntent) {
            return 3;
        }
        if (hasListener) {
            return 2;
        }
        return 0;
    }

    private boolean checkApiUsageLogCap() {
        long currentHour;
        if (D) {
            Log.d(TAG, "checking APIUsage log cap.");
        }
        if ((currentHour = Instant.now().toEpochMilli() / 3600000L) > this.mLastApiUsageLogHour) {
            this.mLastApiUsageLogHour = currentHour;
            this.mApiUsageLogHourlyCount = 0;
            return true;
        }
        this.mApiUsageLogHourlyCount = Math.min(this.mApiUsageLogHourlyCount + 1, 60);
        return this.mApiUsageLogHourlyCount < 60;
    }

    public void logLocationApiUsage(int usageType, int apiInUse, String packageName, LocationRequest locationRequest, boolean hasListener, boolean hasIntent, Geofence geofence, int activityImportance) {
        try {
            boolean isGeofenceNull;
            if (!this.checkApiUsageLogCap()) {
                return;
            }
            boolean isLocationRequestNull = locationRequest == null;
            boolean bl = isGeofenceNull = geofence == null;
            if (D) {
                Log.d(TAG, "log API Usage to statsd. usageType: " + usageType + ", apiInUse: " + apiInUse + ", packageName: " + (packageName == null ? "" : packageName) + ", locationRequest: " + (isLocationRequestNull ? "" : locationRequest.toString()) + ", hasListener: " + hasListener + ", hasIntent: " + hasIntent + ", geofence: " + (isGeofenceNull ? "" : geofence.toString()) + ", importance: " + activityImportance);
            }
            StatsLog.write(210, usageType, apiInUse, packageName, isLocationRequestNull ? 0 : LocationUsageLogger.providerNameToStatsdEnum(locationRequest.getProvider()), isLocationRequestNull ? 0 : locationRequest.getQuality(), isLocationRequestNull ? 0 : LocationUsageLogger.bucketizeIntervalToStatsdEnum(locationRequest.getInterval()), isLocationRequestNull ? 0 : LocationUsageLogger.bucketizeSmallestDisplacementToStatsdEnum(locationRequest.getSmallestDisplacement()), isLocationRequestNull ? 0L : (long)locationRequest.getNumUpdates(), isLocationRequestNull || usageType == 1 ? 0 : LocationUsageLogger.getBucketizedExpireIn(locationRequest.getExpireAt()), LocationUsageLogger.getCallbackType(apiInUse, hasListener, hasIntent), isGeofenceNull ? 0 : LocationUsageLogger.bucketizeRadiusToStatsdEnum(geofence.getRadius()), LocationUsageLogger.categorizeActivityImportance(activityImportance));
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to log API usage to statsd.", e);
        }
    }

    public void logLocationApiUsage(int usageType, int apiInUse, String providerName) {
        try {
            if (!this.checkApiUsageLogCap()) {
                return;
            }
            if (D) {
                Log.d(TAG, "log API Usage to statsd. usageType: " + usageType + ", apiInUse: " + apiInUse + ", providerName: " + providerName);
            }
            StatsLog.write(210, usageType, apiInUse, null, LocationUsageLogger.providerNameToStatsdEnum(providerName), 0, 0, 0, 0L, 0, LocationUsageLogger.getCallbackType(apiInUse, true, true), 0, 0);
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to log API usage to statsd.", e);
        }
    }
}

