/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class LockGuard {
    private static final String TAG = "LockGuard";
    public static final int INDEX_APP_OPS = 0;
    public static final int INDEX_POWER = 1;
    public static final int INDEX_USER = 2;
    public static final int INDEX_PACKAGES = 3;
    public static final int INDEX_STORAGE = 4;
    public static final int INDEX_WINDOW = 5;
    public static final int INDEX_ACTIVITY = 6;
    public static final int INDEX_DPMS = 7;
    private static Object[] sKnownFixed = new Object[8];
    private static ArrayMap<Object, LockInfo> sKnown = new ArrayMap(0, true);

    private static LockInfo findOrCreateLockInfo(Object lock) {
        LockInfo info = sKnown.get(lock);
        if (info == null) {
            info = new LockInfo();
            info.label = "0x" + Integer.toHexString(System.identityHashCode(lock)) + " [" + new Throwable().getStackTrace()[2].toString() + "]";
            sKnown.put(lock, info);
        }
        return info;
    }

    public static Object guard(Object lock) {
        int i;
        if (lock == null || Thread.holdsLock(lock)) {
            return lock;
        }
        boolean triggered = false;
        LockInfo info = LockGuard.findOrCreateLockInfo(lock);
        for (i = 0; i < info.children.size(); ++i) {
            Object child = info.children.valueAt(i);
            if (child == null || !Thread.holdsLock(child)) continue;
            LockGuard.doLog(lock, "Calling thread " + Thread.currentThread().getName() + " is holding " + LockGuard.lockToString(child) + " while trying to acquire " + LockGuard.lockToString(lock));
            triggered = true;
        }
        if (!triggered) {
            for (i = 0; i < sKnown.size(); ++i) {
                Object test = sKnown.keyAt(i);
                if (test == null || test == lock || !Thread.holdsLock(test)) continue;
                LockGuard.sKnown.valueAt((int)i).children.add(lock);
            }
        }
        return lock;
    }

    public static void guard(int index) {
        for (int i = 0; i < index; ++i) {
            Object lock = sKnownFixed[i];
            if (lock == null || !Thread.holdsLock(lock)) continue;
            Object targetMayBeNull = sKnownFixed[index];
            LockGuard.doLog(targetMayBeNull, "Calling thread " + Thread.currentThread().getName() + " is holding " + LockGuard.lockToString(i) + " while trying to acquire " + LockGuard.lockToString(index));
        }
    }

    private static void doLog(Object lock, String message) {
        if (lock != null && LockGuard.findOrCreateLockInfo((Object)lock).doWtf) {
            RuntimeException stackTrace = new RuntimeException(message);
            new Thread(() -> Slog.wtf(TAG, stackTrace)).start();
            return;
        }
        Slog.w(TAG, message, new Throwable());
    }

    public static Object installLock(Object lock, String label) {
        LockInfo info = LockGuard.findOrCreateLockInfo(lock);
        info.label = label;
        return lock;
    }

    public static Object installLock(Object lock, int index) {
        return LockGuard.installLock(lock, index, false);
    }

    public static Object installLock(Object lock, int index, boolean doWtf) {
        LockGuard.sKnownFixed[index] = lock;
        LockInfo info = LockGuard.findOrCreateLockInfo(lock);
        info.doWtf = doWtf;
        info.label = "Lock-" + LockGuard.lockToString(index);
        return lock;
    }

    public static Object installNewLock(int index) {
        return LockGuard.installNewLock(index, false);
    }

    public static Object installNewLock(int index, boolean doWtf) {
        Object lock = new Object();
        LockGuard.installLock(lock, index, doWtf);
        return lock;
    }

    private static String lockToString(Object lock) {
        LockInfo info = sKnown.get(lock);
        if (info != null && !TextUtils.isEmpty(info.label)) {
            return info.label;
        }
        return "0x" + Integer.toHexString(System.identityHashCode(lock));
    }

    private static String lockToString(int index) {
        switch (index) {
            case 0: {
                return "APP_OPS";
            }
            case 1: {
                return "POWER";
            }
            case 2: {
                return "USER";
            }
            case 3: {
                return "PACKAGES";
            }
            case 4: {
                return "STORAGE";
            }
            case 5: {
                return "WINDOW";
            }
            case 6: {
                return "ACTIVITY";
            }
            case 7: {
                return "DPMS";
            }
        }
        return Integer.toString(index);
    }

    public static void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        for (int i = 0; i < sKnown.size(); ++i) {
            Object lock = sKnown.keyAt(i);
            LockInfo info = sKnown.valueAt(i);
            pw.println("Lock " + LockGuard.lockToString(lock) + ":");
            for (int j = 0; j < info.children.size(); ++j) {
                pw.println("  Child " + LockGuard.lockToString(info.children.valueAt(j)));
            }
            pw.println();
        }
    }

    private static class LockInfo {
        public String label;
        public ArraySet<Object> children = new ArraySet(0, true);
        public boolean doWtf;

        private LockInfo() {
        }
    }
}

