/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Looper;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemProperties;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.KeyValueListParser;
import android.util.Slog;
import com.android.internal.os.AppIdToPackageMap;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.CachedDeviceState;
import com.android.internal.os.LooperStats;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class LooperStatsService
extends Binder {
    private static final String TAG = "LooperStatsService";
    private static final String LOOPER_STATS_SERVICE_NAME = "looper_stats";
    private static final String SETTINGS_ENABLED_KEY = "enabled";
    private static final String SETTINGS_SAMPLING_INTERVAL_KEY = "sampling_interval";
    private static final String SETTINGS_TRACK_SCREEN_INTERACTIVE_KEY = "track_screen_state";
    private static final String DEBUG_SYS_LOOPER_STATS_ENABLED = "debug.sys.looper_stats_enabled";
    private static final int DEFAULT_SAMPLING_INTERVAL = 1000;
    private static final int DEFAULT_ENTRIES_SIZE_CAP = 1500;
    private static final boolean DEFAULT_ENABLED = true;
    private static final boolean DEFAULT_TRACK_SCREEN_INTERACTIVE = false;
    private final Context mContext;
    private final LooperStats mStats;
    private boolean mEnabled = false;
    private boolean mTrackScreenInteractive = false;

    private LooperStatsService(Context context, LooperStats stats) {
        this.mContext = context;
        this.mStats = stats;
    }

    private void initFromSettings() {
        KeyValueListParser parser = new KeyValueListParser(',');
        try {
            parser.setString(Settings.Global.getString(this.mContext.getContentResolver(), LOOPER_STATS_SERVICE_NAME));
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "Bad looper_stats settings", e);
        }
        this.setSamplingInterval(parser.getInt(SETTINGS_SAMPLING_INTERVAL_KEY, 1000));
        this.setTrackScreenInteractive(parser.getBoolean(SETTINGS_TRACK_SCREEN_INTERACTIVE_KEY, false));
        this.setEnabled(SystemProperties.getBoolean(DEBUG_SYS_LOOPER_STATS_ENABLED, parser.getBoolean(SETTINGS_ENABLED_KEY, true)));
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new LooperShellCommand().exec(this, in, out, err, args, callback, resultReceiver);
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        AppIdToPackageMap packageMap = AppIdToPackageMap.getSnapshot();
        pw.print("Start time: ");
        pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", this.mStats.getStartTimeMillis()));
        pw.print("On battery time (ms): ");
        pw.println(this.mStats.getBatteryTimeMillis());
        List<LooperStats.ExportedEntry> entries = this.mStats.getEntries();
        entries.sort(Comparator.comparing(entry -> entry.workSourceUid).thenComparing(entry -> entry.threadName).thenComparing(entry -> entry.handlerClassName).thenComparing(entry -> entry.messageName));
        String header = String.join((CharSequence)",", Arrays.asList("work_source_uid", "thread_name", "handler_class", "message_name", "is_interactive", "message_count", "recorded_message_count", "total_latency_micros", "max_latency_micros", "total_cpu_micros", "max_cpu_micros", "recorded_delay_message_count", "total_delay_millis", "max_delay_millis", "exception_count"));
        pw.println(header);
        for (LooperStats.ExportedEntry entry2 : entries) {
            if (entry2.messageName.startsWith("__DEBUG_")) continue;
            pw.printf("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n", packageMap.mapUid(entry2.workSourceUid), entry2.threadName, entry2.handlerClassName, entry2.messageName, entry2.isInteractive, entry2.messageCount, entry2.recordedMessageCount, entry2.totalLatencyMicros, entry2.maxLatencyMicros, entry2.cpuUsageMicros, entry2.maxCpuUsageMicros, entry2.recordedDelayMessageCount, entry2.delayMillis, entry2.maxDelayMillis, entry2.exceptionCount);
        }
    }

    private void setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            this.mStats.reset();
            this.mStats.setAddDebugEntries(enabled);
            Looper.setObserver(enabled ? this.mStats : null);
        }
    }

    private void setTrackScreenInteractive(boolean enabled) {
        if (this.mTrackScreenInteractive != enabled) {
            this.mTrackScreenInteractive = enabled;
            this.mStats.reset();
        }
    }

    private void setSamplingInterval(int samplingInterval) {
        if (samplingInterval > 0) {
            this.mStats.setSamplingInterval(samplingInterval);
        } else {
            Slog.w(TAG, "Ignored invalid sampling interval (value must be positive): " + samplingInterval);
        }
    }

    private class LooperShellCommand
    extends ShellCommand {
        private LooperShellCommand() {
        }

        @Override
        public int onCommand(String cmd) {
            if ("enable".equals(cmd)) {
                LooperStatsService.this.setEnabled(true);
                return 0;
            }
            if ("disable".equals(cmd)) {
                LooperStatsService.this.setEnabled(false);
                return 0;
            }
            if ("reset".equals(cmd)) {
                LooperStatsService.this.mStats.reset();
                return 0;
            }
            if (LooperStatsService.SETTINGS_SAMPLING_INTERVAL_KEY.equals(cmd)) {
                int sampling = Integer.parseUnsignedInt(this.getNextArgRequired());
                LooperStatsService.this.setSamplingInterval(sampling);
                return 0;
            }
            return this.handleDefaultCommands(cmd);
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("looper_stats commands:");
            pw.println("  enable: Enable collecting stats.");
            pw.println("  disable: Disable collecting stats.");
            pw.println("  sampling_interval: Change the sampling interval.");
            pw.println("  reset: Reset stats.");
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private final LooperStatsService mService;

        SettingsObserver(LooperStatsService service) {
            super(BackgroundThread.getHandler());
            this.mService = service;
        }

        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            this.mService.initFromSettings();
        }
    }

    public static class Lifecycle
    extends SystemService {
        private final SettingsObserver mSettingsObserver;
        private final LooperStatsService mService;
        private final LooperStats mStats = new LooperStats(1000, 1500);

        public Lifecycle(Context context) {
            super(context);
            this.mService = new LooperStatsService(this.getContext(), this.mStats);
            this.mSettingsObserver = new SettingsObserver(this.mService);
        }

        @Override
        public void onStart() {
            this.publishLocalService(LooperStats.class, this.mStats);
            this.publishBinderService(LooperStatsService.LOOPER_STATS_SERVICE_NAME, this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (500 == phase) {
                this.mService.initFromSettings();
                Uri settingsUri = Settings.Global.getUriFor(LooperStatsService.LOOPER_STATS_SERVICE_NAME);
                this.getContext().getContentResolver().registerContentObserver(settingsUri, false, this.mSettingsObserver, 0);
                this.mStats.setDeviceState(this.getLocalService(CachedDeviceState.Readonly.class));
            }
        }
    }
}

