/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.INetd;
import android.net.INetdUnsolicitedEventListener;
import android.net.INetworkManagementEventObserver;
import android.net.ITetheringStatsProvider;
import android.net.InetAddresses;
import android.net.InterfaceConfiguration;
import android.net.InterfaceConfigurationParcel;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.Network;
import android.net.NetworkStats;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.TetherStatsParcel;
import android.net.UidRange;
import android.net.UidRangeParcel;
import android.net.util.NetdService;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.INetworkActivityListener;
import android.os.INetworkManagementService;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.StatsLog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.HexDump;
import com.android.internal.util.Preconditions;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.NetworkManagementInternal;
import com.android.server.net.NetworkStatsFactory;
import com.google.android.collect.Maps;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NetworkManagementService
extends INetworkManagementService.Stub {
    private static final String TAG = "NetworkManagement";
    private static final boolean DBG = Log.isLoggable("NetworkManagement", 3);
    private static final int MAX_UID_RANGES_PER_COMMAND = 10;
    public static final String LIMIT_GLOBAL_ALERT = "globalAlert";
    static final int DAEMON_MSG_MOBILE_CONN_REAL_TIME_INFO = 1;
    static final boolean MODIFY_OPERATION_ADD = true;
    static final boolean MODIFY_OPERATION_REMOVE = false;
    private final Context mContext;
    private final Handler mDaemonHandler;
    private final SystemServices mServices;
    private INetd mNetdService;
    private final NetdUnsolicitedEventListener mNetdUnsolicitedEventListener;
    private IBatteryStats mBatteryStats;
    private final RemoteCallbackList<INetworkManagementEventObserver> mObservers = new RemoteCallbackList();
    private final NetworkStatsFactory mStatsFactory = new NetworkStatsFactory();
    @GuardedBy(value={"mTetheringStatsProviders"})
    private final HashMap<ITetheringStatsProvider, String> mTetheringStatsProviders = Maps.newHashMap();
    private final Object mQuotaLock = new Object();
    private final Object mRulesLock = new Object();
    @GuardedBy(value={"mQuotaLock"})
    private HashMap<String, Long> mActiveQuotas = Maps.newHashMap();
    @GuardedBy(value={"mQuotaLock"})
    private HashMap<String, Long> mActiveAlerts = Maps.newHashMap();
    @GuardedBy(value={"mRulesLock"})
    private SparseBooleanArray mUidRejectOnMetered = new SparseBooleanArray();
    @GuardedBy(value={"mRulesLock"})
    private SparseBooleanArray mUidAllowOnMetered = new SparseBooleanArray();
    @GuardedBy(value={"mQuotaLock"})
    private SparseIntArray mUidCleartextPolicy = new SparseIntArray();
    @GuardedBy(value={"mRulesLock"})
    private SparseIntArray mUidFirewallRules = new SparseIntArray();
    @GuardedBy(value={"mRulesLock"})
    private SparseIntArray mUidFirewallStandbyRules = new SparseIntArray();
    @GuardedBy(value={"mRulesLock"})
    private SparseIntArray mUidFirewallDozableRules = new SparseIntArray();
    @GuardedBy(value={"mRulesLock"})
    private SparseIntArray mUidFirewallPowerSaveRules = new SparseIntArray();
    @GuardedBy(value={"mRulesLock"})
    final SparseBooleanArray mFirewallChainStates = new SparseBooleanArray();
    @GuardedBy(value={"mQuotaLock"})
    private volatile boolean mDataSaverMode;
    private final Object mIdleTimerLock = new Object();
    private HashMap<String, IdleTimerParams> mActiveIdleTimers = Maps.newHashMap();
    private volatile boolean mFirewallEnabled;
    private volatile boolean mStrictEnabled;
    private boolean mMobileActivityFromRadio = false;
    private int mLastPowerStateFromRadio = 1;
    private int mLastPowerStateFromWifi = 1;
    private final RemoteCallbackList<INetworkActivityListener> mNetworkActivityListeners = new RemoteCallbackList();
    private boolean mNetworkActive;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkManagementService(Context context, SystemServices services) {
        this.mContext = context;
        this.mServices = services;
        this.mDaemonHandler = new Handler(FgThread.get().getLooper());
        this.mNetdUnsolicitedEventListener = new NetdUnsolicitedEventListener();
        this.mServices.registerLocalService(new LocalService());
        HashMap<ITetheringStatsProvider, String> hashMap = this.mTetheringStatsProviders;
        synchronized (hashMap) {
            this.mTetheringStatsProviders.put(new NetdTetheringStatsProvider(), "netd");
        }
    }

    @VisibleForTesting
    NetworkManagementService() {
        this.mContext = null;
        this.mDaemonHandler = null;
        this.mServices = null;
        this.mNetdUnsolicitedEventListener = null;
    }

    static NetworkManagementService create(Context context, SystemServices services) throws InterruptedException {
        NetworkManagementService service = new NetworkManagementService(context, services);
        if (DBG) {
            Slog.d(TAG, "Creating NetworkManagementService");
        }
        if (DBG) {
            Slog.d(TAG, "Connecting native netd service");
        }
        service.connectNativeNetdService();
        if (DBG) {
            Slog.d(TAG, "Connected");
        }
        return service;
    }

    public static NetworkManagementService create(Context context) throws InterruptedException {
        return NetworkManagementService.create(context, new SystemServices());
    }

    public void systemReady() {
        if (DBG) {
            long start = System.currentTimeMillis();
            this.prepareNativeDaemon();
            long delta = System.currentTimeMillis() - start;
            Slog.d(TAG, "Prepared in " + delta + "ms");
            return;
        }
        this.prepareNativeDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBatteryStats getBatteryStats() {
        NetworkManagementService networkManagementService = this;
        synchronized (networkManagementService) {
            if (this.mBatteryStats != null) {
                return this.mBatteryStats;
            }
            this.mBatteryStats = IBatteryStats.Stub.asInterface(this.mServices.getService("batterystats"));
            return this.mBatteryStats;
        }
    }

    @Override
    public void registerObserver(INetworkManagementEventObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mObservers.register(observer);
    }

    @Override
    public void unregisterObserver(INetworkManagementEventObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mObservers.unregister(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeForAllObservers(NetworkManagementEventCallback eventCallback) {
        int length = this.mObservers.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    eventCallback.sendCallback(this.mObservers.getBroadcastItem(i));
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mObservers.finishBroadcast();
        }
    }

    private void notifyInterfaceStatusChanged(String iface, boolean up) {
        this.invokeForAllObservers(o -> o.interfaceStatusChanged(iface, up));
    }

    private void notifyInterfaceLinkStateChanged(String iface, boolean up) {
        this.invokeForAllObservers(o -> o.interfaceLinkStateChanged(iface, up));
    }

    private void notifyInterfaceAdded(String iface) {
        this.invokeForAllObservers(o -> o.interfaceAdded(iface));
    }

    private void notifyInterfaceRemoved(String iface) {
        this.mActiveAlerts.remove(iface);
        this.mActiveQuotas.remove(iface);
        this.invokeForAllObservers(o -> o.interfaceRemoved(iface));
    }

    private void notifyLimitReached(String limitName, String iface) {
        this.invokeForAllObservers(o -> o.limitReached(limitName, iface));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInterfaceClassActivity(int type, boolean isActive, long tsNanos, int uid, boolean fromRadio) {
        int powerState;
        boolean isMobile = ConnectivityManager.isNetworkTypeMobile(type);
        int n = powerState = isActive ? 3 : 1;
        if (isMobile) {
            if (!fromRadio) {
                if (this.mMobileActivityFromRadio) {
                    powerState = this.mLastPowerStateFromRadio;
                }
            } else {
                this.mMobileActivityFromRadio = true;
            }
            if (this.mLastPowerStateFromRadio != powerState) {
                this.mLastPowerStateFromRadio = powerState;
                try {
                    this.getBatteryStats().noteMobileRadioPowerState(powerState, tsNanos, uid);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                StatsLog.write_non_chained(12, uid, null, powerState);
            }
        }
        if (ConnectivityManager.isNetworkTypeWifi(type) && this.mLastPowerStateFromWifi != powerState) {
            this.mLastPowerStateFromWifi = powerState;
            try {
                this.getBatteryStats().noteWifiRadioPowerState(powerState, tsNanos, uid);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            StatsLog.write_non_chained(13, uid, null, powerState);
        }
        if (!isMobile || fromRadio || !this.mMobileActivityFromRadio) {
            boolean active = isActive;
            this.invokeForAllObservers(o -> o.interfaceClassDataActivityChanged(Integer.toString(type), active, tsNanos));
        }
        boolean report = false;
        Object object = this.mIdleTimerLock;
        synchronized (object) {
            if (this.mActiveIdleTimers.isEmpty()) {
                isActive = true;
            }
            if (this.mNetworkActive != isActive) {
                this.mNetworkActive = isActive;
                report = isActive;
            }
        }
        if (report) {
            this.reportNetworkActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTetheringStatsProvider(ITetheringStatsProvider provider, String name) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.NETWORK_STACK", TAG);
        Preconditions.checkNotNull(provider);
        HashMap<ITetheringStatsProvider, String> hashMap = this.mTetheringStatsProviders;
        synchronized (hashMap) {
            this.mTetheringStatsProviders.put(provider, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTetheringStatsProvider(ITetheringStatsProvider provider) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.NETWORK_STACK", TAG);
        HashMap<ITetheringStatsProvider, String> hashMap = this.mTetheringStatsProviders;
        synchronized (hashMap) {
            this.mTetheringStatsProviders.remove(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tetherLimitReached(ITetheringStatsProvider provider) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.NETWORK_STACK", TAG);
        HashMap<ITetheringStatsProvider, String> hashMap = this.mTetheringStatsProviders;
        synchronized (hashMap) {
            if (!this.mTetheringStatsProviders.containsKey(provider)) {
                return;
            }
            this.mDaemonHandler.post(() -> this.notifyLimitReached(LIMIT_GLOBAL_ALERT, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFirewallChainLocked(int chain, String name) {
        SparseIntArray rules;
        Object object = this.mRulesLock;
        synchronized (object) {
            SparseIntArray uidFirewallRules = this.getUidFirewallRulesLR(chain);
            rules = uidFirewallRules.clone();
            uidFirewallRules.clear();
        }
        if (rules.size() > 0) {
            if (DBG) {
                Slog.d(TAG, "Pushing " + rules.size() + " active firewall " + name + "UID rules");
            }
            for (int i = 0; i < rules.size(); ++i) {
                this.setFirewallUidRuleLocked(chain, rules.keyAt(i), rules.valueAt(i));
            }
        }
    }

    private void connectNativeNetdService() {
        this.mNetdService = this.mServices.getNetd();
        try {
            this.mNetdService.registerUnsolicitedEventListener(this.mNetdUnsolicitedEventListener);
            if (DBG) {
                Slog.d(TAG, "Register unsolicited event listener");
            }
        }
        catch (RemoteException | ServiceSpecificException e) {
            Slog.e(TAG, "Failed to set Netd unsolicited event listener " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNativeDaemon() {
        Object object = this.mQuotaLock;
        synchronized (object) {
            int[] chains;
            Map.Entry<String, Long> entry2;
            SystemProperties.set("net.qtaguid_enabled", "1");
            this.mStrictEnabled = true;
            this.setDataSaverModeEnabled(this.mDataSaverMode);
            int size = this.mActiveQuotas.size();
            if (size > 0) {
                if (DBG) {
                    Slog.d(TAG, "Pushing " + size + " active quota rules");
                }
                HashMap<String, Long> activeQuotas = this.mActiveQuotas;
                this.mActiveQuotas = Maps.newHashMap();
                for (Map.Entry<String, Long> entry2 : activeQuotas.entrySet()) {
                    this.setInterfaceQuota(entry2.getKey(), entry2.getValue());
                }
            }
            if ((size = this.mActiveAlerts.size()) > 0) {
                if (DBG) {
                    Slog.d(TAG, "Pushing " + size + " active alert rules");
                }
                HashMap<String, Long> activeAlerts = this.mActiveAlerts;
                this.mActiveAlerts = Maps.newHashMap();
                for (Map.Entry<String, Long> entry2 : activeAlerts.entrySet()) {
                    this.setInterfaceAlert(entry2.getKey(), entry2.getValue());
                }
            }
            SparseBooleanArray uidRejectOnQuota = null;
            SparseBooleanArray uidAcceptOnQuota = null;
            entry2 = this.mRulesLock;
            synchronized (entry2) {
                size = this.mUidRejectOnMetered.size();
                if (size > 0) {
                    if (DBG) {
                        Slog.d(TAG, "Pushing " + size + " UIDs to metered blacklist rules");
                    }
                    uidRejectOnQuota = this.mUidRejectOnMetered;
                    this.mUidRejectOnMetered = new SparseBooleanArray();
                }
                if ((size = this.mUidAllowOnMetered.size()) > 0) {
                    if (DBG) {
                        Slog.d(TAG, "Pushing " + size + " UIDs to metered whitelist rules");
                    }
                    uidAcceptOnQuota = this.mUidAllowOnMetered;
                    this.mUidAllowOnMetered = new SparseBooleanArray();
                }
            }
            if (uidRejectOnQuota != null) {
                for (int i = 0; i < uidRejectOnQuota.size(); ++i) {
                    this.setUidMeteredNetworkBlacklist(uidRejectOnQuota.keyAt(i), uidRejectOnQuota.valueAt(i));
                }
            }
            if (uidAcceptOnQuota != null) {
                for (int i = 0; i < uidAcceptOnQuota.size(); ++i) {
                    this.setUidMeteredNetworkWhitelist(uidAcceptOnQuota.keyAt(i), uidAcceptOnQuota.valueAt(i));
                }
            }
            if ((size = this.mUidCleartextPolicy.size()) > 0) {
                if (DBG) {
                    Slog.d(TAG, "Pushing " + size + " active UID cleartext policies");
                }
                SparseIntArray local = this.mUidCleartextPolicy;
                this.mUidCleartextPolicy = new SparseIntArray();
                for (int i = 0; i < local.size(); ++i) {
                    this.setUidCleartextNetworkPolicy(local.keyAt(i), local.valueAt(i));
                }
            }
            this.setFirewallEnabled(this.mFirewallEnabled);
            this.syncFirewallChainLocked(0, "");
            this.syncFirewallChainLocked(2, "standby ");
            this.syncFirewallChainLocked(1, "dozable ");
            this.syncFirewallChainLocked(3, "powersave ");
            for (int chain : chains = new int[]{2, 1, 3}) {
                if (!this.getFirewallChainState(chain)) continue;
                this.setFirewallChainEnabled(chain, true);
            }
        }
        try {
            this.getBatteryStats().noteNetworkStatsEnabled();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void notifyAddressUpdated(String iface, LinkAddress address) {
        this.invokeForAllObservers(o -> o.addressUpdated(iface, address));
    }

    private void notifyAddressRemoved(String iface, LinkAddress address) {
        this.invokeForAllObservers(o -> o.addressRemoved(iface, address));
    }

    private void notifyInterfaceDnsServerInfo(String iface, long lifetime, String[] addresses) {
        this.invokeForAllObservers(o -> o.interfaceDnsServerInfo(iface, lifetime, addresses));
    }

    private void notifyRouteChange(boolean updated, RouteInfo route) {
        if (updated) {
            this.invokeForAllObservers(o -> o.routeUpdated(route));
        } else {
            this.invokeForAllObservers(o -> o.routeRemoved(route));
        }
    }

    @Override
    public String[] listInterfaces() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mNetdService.interfaceGetList();
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    private static InterfaceConfigurationParcel toStableParcel(InterfaceConfiguration cfg, String iface) {
        InterfaceConfigurationParcel cfgParcel = new InterfaceConfigurationParcel();
        cfgParcel.ifName = iface;
        String hwAddr = cfg.getHardwareAddress();
        cfgParcel.hwAddr = !TextUtils.isEmpty(hwAddr) ? hwAddr : "";
        cfgParcel.ipv4Addr = cfg.getLinkAddress().getAddress().getHostAddress();
        cfgParcel.prefixLength = cfg.getLinkAddress().getPrefixLength();
        ArrayList<String> flags = new ArrayList<String>();
        for (String flag : cfg.getFlags()) {
            flags.add(flag);
        }
        cfgParcel.flags = flags.toArray(new String[0]);
        return cfgParcel;
    }

    public static InterfaceConfiguration fromStableParcel(InterfaceConfigurationParcel p) {
        InterfaceConfiguration cfg = new InterfaceConfiguration();
        cfg.setHardwareAddress(p.hwAddr);
        InetAddress addr = NetworkUtils.numericToInetAddress(p.ipv4Addr);
        cfg.setLinkAddress(new LinkAddress(addr, p.prefixLength));
        for (String flag : p.flags) {
            cfg.setFlag(flag);
        }
        return cfg;
    }

    @Override
    public InterfaceConfiguration getInterfaceConfig(String iface) {
        InterfaceConfigurationParcel result;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            result = this.mNetdService.interfaceGetCfg(iface);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
        try {
            InterfaceConfiguration cfg = NetworkManagementService.fromStableParcel(result);
            return cfg;
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalStateException("Invalid InterfaceConfigurationParcel", iae);
        }
    }

    @Override
    public void setInterfaceConfig(String iface, InterfaceConfiguration cfg) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        LinkAddress linkAddr = cfg.getLinkAddress();
        if (linkAddr == null || linkAddr.getAddress() == null) {
            throw new IllegalStateException("Null LinkAddress given");
        }
        InterfaceConfigurationParcel cfgParcel = NetworkManagementService.toStableParcel(cfg, iface);
        try {
            this.mNetdService.interfaceSetCfg(cfgParcel);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setInterfaceDown(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        InterfaceConfiguration ifcg = this.getInterfaceConfig(iface);
        ifcg.setInterfaceDown();
        this.setInterfaceConfig(iface, ifcg);
    }

    @Override
    public void setInterfaceUp(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        InterfaceConfiguration ifcg = this.getInterfaceConfig(iface);
        ifcg.setInterfaceUp();
        this.setInterfaceConfig(iface, ifcg);
    }

    @Override
    public void setInterfaceIpv6PrivacyExtensions(String iface, boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.interfaceSetIPv6PrivacyExtensions(iface, enable);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void clearInterfaceAddresses(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.interfaceClearAddrs(iface);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void enableIpv6(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.interfaceSetEnableIPv6(iface, true);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setIPv6AddrGenMode(String iface, int mode) throws ServiceSpecificException {
        try {
            this.mNetdService.setIPv6AddrGenMode(iface, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public void disableIpv6(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.interfaceSetEnableIPv6(iface, false);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void addRoute(int netId, RouteInfo route) {
        this.modifyRoute(true, netId, route);
    }

    @Override
    public void removeRoute(int netId, RouteInfo route) {
        this.modifyRoute(false, netId, route);
    }

    private void modifyRoute(boolean add, int netId, RouteInfo route) {
        String nextHop;
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        String ifName = route.getInterface();
        String dst = route.getDestination().toString();
        switch (route.getType()) {
            case 1: {
                if (route.hasGateway()) {
                    nextHop = route.getGateway().getHostAddress();
                    break;
                }
                nextHop = "";
                break;
            }
            case 7: {
                nextHop = "unreachable";
                break;
            }
            case 9: {
                nextHop = "throw";
                break;
            }
            default: {
                nextHop = "";
            }
        }
        try {
            if (add) {
                this.mNetdService.networkAddRoute(netId, ifName, dst, nextHop);
            } else {
                this.mNetdService.networkRemoveRoute(netId, ifName, dst, nextHop);
            }
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> readRouteList(String filename) {
        FileInputStream fstream = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            String s;
            fstream = new FileInputStream(filename);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((s = br.readLine()) != null && s.length() != 0) {
                list.add(s);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fstream != null) {
                try {
                    fstream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    @Override
    public void setMtu(String iface, int mtu) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.interfaceSetMtu(iface, mtu);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void shutdown() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SHUTDOWN", TAG);
        Slog.i(TAG, "Shutting down");
    }

    @Override
    public boolean getIpForwardingEnabled() throws IllegalStateException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            boolean isEnabled = this.mNetdService.ipfwdEnabled();
            return isEnabled;
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setIpForwardingEnabled(boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            if (enable) {
                this.mNetdService.ipfwdEnableForwarding("tethering");
            } else {
                this.mNetdService.ipfwdDisableForwarding("tethering");
            }
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void startTethering(String[] dhcpRange) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.tetherStart(dhcpRange);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void stopTethering() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.tetherStop();
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isTetheringStarted() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            boolean isEnabled = this.mNetdService.tetherIsEnabled();
            return isEnabled;
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void tetherInterface(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.tetherInterfaceAdd(iface);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>();
        routes.add(new RouteInfo(this.getInterfaceConfig(iface).getLinkAddress(), null, iface));
        this.addInterfaceToLocalNetwork(iface, routes);
    }

    @Override
    public void untetherInterface(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.tetherInterfaceRemove(iface);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.removeInterfaceFromLocalNetwork(iface);
        }
    }

    @Override
    public String[] listTetheredInterfaces() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mNetdService.tetherInterfaceList();
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setDnsForwarders(Network network, String[] dns) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        int netId = network != null ? network.netId : 0;
        try {
            this.mNetdService.tetherDnsSet(netId, dns);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String[] getDnsForwarders() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mNetdService.tetherDnsList();
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    private List<InterfaceAddress> excludeLinkLocal(List<InterfaceAddress> addresses) {
        ArrayList<InterfaceAddress> filtered = new ArrayList<InterfaceAddress>(addresses.size());
        for (InterfaceAddress ia : addresses) {
            if (ia.getAddress().isLinkLocalAddress()) continue;
            filtered.add(ia);
        }
        return filtered;
    }

    private void modifyInterfaceForward(boolean add, String fromIface, String toIface) {
        try {
            if (add) {
                this.mNetdService.ipfwdAddInterfaceForward(fromIface, toIface);
            } else {
                this.mNetdService.ipfwdRemoveInterfaceForward(fromIface, toIface);
            }
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void startInterfaceForwarding(String fromIface, String toIface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.modifyInterfaceForward(true, fromIface, toIface);
    }

    @Override
    public void stopInterfaceForwarding(String fromIface, String toIface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.modifyInterfaceForward(false, fromIface, toIface);
    }

    @Override
    public void enableNat(String internalInterface, String externalInterface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.tetherAddForward(internalInterface, externalInterface);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void disableNat(String internalInterface, String externalInterface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.tetherRemoveForward(internalInterface, externalInterface);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIdleTimer(String iface, int timeout, int type) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (DBG) {
            Slog.d(TAG, "Adding idletimer");
        }
        Object object = this.mIdleTimerLock;
        synchronized (object) {
            IdleTimerParams params = this.mActiveIdleTimers.get(iface);
            if (params != null) {
                ++params.networkCount;
                return;
            }
            try {
                this.mNetdService.idletimerAddInterface(iface, timeout, Integer.toString(type));
            }
            catch (RemoteException | ServiceSpecificException e) {
                throw new IllegalStateException(e);
            }
            this.mActiveIdleTimers.put(iface, new IdleTimerParams(timeout, type));
            if (ConnectivityManager.isNetworkTypeMobile(type)) {
                this.mNetworkActive = false;
            }
            this.mDaemonHandler.post(() -> this.notifyInterfaceClassActivity(type, true, SystemClock.elapsedRealtimeNanos(), -1, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdleTimer(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (DBG) {
            Slog.d(TAG, "Removing idletimer");
        }
        Object object = this.mIdleTimerLock;
        synchronized (object) {
            IdleTimerParams params = this.mActiveIdleTimers.get(iface);
            if (params == null || --params.networkCount > 0) {
                return;
            }
            try {
                this.mNetdService.idletimerRemoveInterface(iface, params.timeout, Integer.toString(params.type));
            }
            catch (RemoteException | ServiceSpecificException e) {
                throw new IllegalStateException(e);
            }
            this.mActiveIdleTimers.remove(iface);
            this.mDaemonHandler.post(() -> this.notifyInterfaceClassActivity(params.type, false, SystemClock.elapsedRealtimeNanos(), -1, false));
        }
    }

    @Override
    public NetworkStats getNetworkStatsSummaryDev() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsSummaryDev();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NetworkStats getNetworkStatsSummaryXt() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsSummaryXt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NetworkStats getNetworkStatsDetail() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsDetail(-1, null, -1, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterfaceQuota(String iface, long quotaBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (this.mActiveQuotas.containsKey(iface)) {
                throw new IllegalStateException("iface " + iface + " already has quota");
            }
            try {
                this.mNetdService.bandwidthSetInterfaceQuota(iface, quotaBytes);
                this.mActiveQuotas.put(iface, quotaBytes);
            }
            catch (RemoteException | ServiceSpecificException e) {
                throw new IllegalStateException(e);
            }
            HashMap<ITetheringStatsProvider, String> hashMap = this.mTetheringStatsProviders;
            synchronized (hashMap) {
                for (ITetheringStatsProvider provider : this.mTetheringStatsProviders.keySet()) {
                    try {
                        provider.setInterfaceQuota(iface, quotaBytes);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Problem setting tethering data limit on provider " + this.mTetheringStatsProviders.get(provider) + ": " + e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterfaceQuota(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (!this.mActiveQuotas.containsKey(iface)) {
                return;
            }
            this.mActiveQuotas.remove(iface);
            this.mActiveAlerts.remove(iface);
            try {
                this.mNetdService.bandwidthRemoveInterfaceQuota(iface);
            }
            catch (RemoteException | ServiceSpecificException e) {
                throw new IllegalStateException(e);
            }
            HashMap<ITetheringStatsProvider, String> hashMap = this.mTetheringStatsProviders;
            synchronized (hashMap) {
                for (ITetheringStatsProvider provider : this.mTetheringStatsProviders.keySet()) {
                    try {
                        provider.setInterfaceQuota(iface, -1L);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Problem removing tethering data limit on provider " + this.mTetheringStatsProviders.get(provider) + ": " + e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterfaceAlert(String iface, long alertBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (!this.mActiveQuotas.containsKey(iface)) {
            throw new IllegalStateException("setting alert requires existing quota on iface");
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (this.mActiveAlerts.containsKey(iface)) {
                throw new IllegalStateException("iface " + iface + " already has alert");
            }
            try {
                this.mNetdService.bandwidthSetInterfaceAlert(iface, alertBytes);
                this.mActiveAlerts.put(iface, alertBytes);
            }
            catch (RemoteException | ServiceSpecificException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterfaceAlert(String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object object = this.mQuotaLock;
        synchronized (object) {
            if (!this.mActiveAlerts.containsKey(iface)) {
                return;
            }
            try {
                this.mNetdService.bandwidthRemoveInterfaceAlert(iface);
                this.mActiveAlerts.remove(iface);
            }
            catch (RemoteException | ServiceSpecificException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void setGlobalAlert(long alertBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.bandwidthSetGlobalAlert(alertBytes);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUidOnMeteredNetworkList(int uid, boolean blacklist, boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        Object object = this.mQuotaLock;
        synchronized (object) {
            boolean oldEnable;
            SparseBooleanArray quotaList;
            Object object2 = this.mRulesLock;
            synchronized (object2) {
                quotaList = blacklist ? this.mUidRejectOnMetered : this.mUidAllowOnMetered;
                oldEnable = quotaList.get(uid, false);
            }
            if (oldEnable == enable) {
                return;
            }
            Trace.traceBegin(0x200000L, "inetd bandwidth");
            try {
                if (blacklist) {
                    if (enable) {
                        this.mNetdService.bandwidthAddNaughtyApp(uid);
                    } else {
                        this.mNetdService.bandwidthRemoveNaughtyApp(uid);
                    }
                } else if (enable) {
                    this.mNetdService.bandwidthAddNiceApp(uid);
                } else {
                    this.mNetdService.bandwidthRemoveNiceApp(uid);
                }
                object2 = this.mRulesLock;
                synchronized (object2) {
                    if (enable) {
                        quotaList.put(uid, true);
                    } else {
                        quotaList.delete(uid);
                    }
                }
            }
            catch (RemoteException | ServiceSpecificException e) {
                throw new IllegalStateException(e);
            }
            finally {
                Trace.traceEnd(0x200000L);
            }
        }
    }

    @Override
    public void setUidMeteredNetworkBlacklist(int uid, boolean enable) {
        this.setUidOnMeteredNetworkList(uid, true, enable);
    }

    @Override
    public void setUidMeteredNetworkWhitelist(int uid, boolean enable) {
        this.setUidOnMeteredNetworkList(uid, false, enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDataSaverModeEnabled(boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.NETWORK_SETTINGS", TAG);
        if (DBG) {
            Log.d(TAG, "setDataSaverMode: " + enable);
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            boolean bl;
            if (this.mDataSaverMode == enable) {
                Log.w(TAG, "setDataSaverMode(): already " + this.mDataSaverMode);
                return true;
            }
            Trace.traceBegin(0x200000L, "bandwidthEnableDataSaver");
            try {
                boolean changed = this.mNetdService.bandwidthEnableDataSaver(enable);
                if (changed) {
                    this.mDataSaverMode = enable;
                } else {
                    Log.w(TAG, "setDataSaverMode(" + enable + "): netd command silently failed");
                }
                bl = changed;
            }
            catch (RemoteException e) {
                boolean bl2;
                try {
                    Log.w(TAG, "setDataSaverMode(" + enable + "): netd command failed", e);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    Trace.traceEnd(0x200000L);
                    throw throwable;
                }
                Trace.traceEnd(0x200000L);
                return bl2;
            }
            Trace.traceEnd(0x200000L);
            return bl;
        }
    }

    private static UidRangeParcel makeUidRangeParcel(int start, int stop) {
        UidRangeParcel range = new UidRangeParcel();
        range.start = start;
        range.stop = stop;
        return range;
    }

    private static UidRangeParcel[] toStableParcels(UidRange[] ranges) {
        UidRangeParcel[] stableRanges = new UidRangeParcel[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            stableRanges[i] = NetworkManagementService.makeUidRangeParcel(ranges[i].start, ranges[i].stop);
        }
        return stableRanges;
    }

    @Override
    public void setAllowOnlyVpnForUids(boolean add, UidRange[] uidRanges) throws ServiceSpecificException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.NETWORK_STACK", TAG);
        try {
            this.mNetdService.networkRejectNonSecureVpn(add, NetworkManagementService.toStableParcels(uidRanges));
        }
        catch (ServiceSpecificException e) {
            Log.w(TAG, "setAllowOnlyVpnForUids(" + add + ", " + Arrays.toString(uidRanges) + "): netd command failed", e);
            throw e;
        }
        catch (RemoteException e) {
            Log.w(TAG, "setAllowOnlyVpnForUids(" + add + ", " + Arrays.toString(uidRanges) + "): netd command failed", e);
            throw e.rethrowAsRuntimeException();
        }
    }

    private void applyUidCleartextNetworkPolicy(int uid, int policy) {
        int policyValue;
        switch (policy) {
            case 0: {
                policyValue = 1;
                break;
            }
            case 1: {
                policyValue = 2;
                break;
            }
            case 2: {
                policyValue = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown policy " + policy);
            }
        }
        try {
            this.mNetdService.strictUidCleartextPenalty(uid, policyValue);
            this.mUidCleartextPolicy.put(uid, policy);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUidCleartextNetworkPolicy(int uid, int policy) {
        if (Binder.getCallingUid() != uid) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        }
        Object object = this.mQuotaLock;
        synchronized (object) {
            int oldPolicy = this.mUidCleartextPolicy.get(uid, 0);
            if (oldPolicy == policy) {
                return;
            }
            if (!this.mStrictEnabled) {
                this.mUidCleartextPolicy.put(uid, policy);
                return;
            }
            if (oldPolicy != 0 && policy != 0) {
                this.applyUidCleartextNetworkPolicy(uid, 0);
            }
            this.applyUidCleartextNetworkPolicy(uid, policy);
        }
    }

    @Override
    public boolean isBandwidthControlEnabled() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        return true;
    }

    @Override
    public NetworkStats getNetworkStatsUidDetail(int uid, String[] ifaces) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            return this.mStatsFactory.readNetworkStatsDetail(uid, ifaces, -1, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkStats getNetworkStatsTethering(int how) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 1);
        HashMap<ITetheringStatsProvider, String> hashMap = this.mTetheringStatsProviders;
        synchronized (hashMap) {
            for (ITetheringStatsProvider provider : this.mTetheringStatsProviders.keySet()) {
                try {
                    stats.combineAllValues(provider.getTetherStats(how));
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Problem reading tethering stats from " + this.mTetheringStatsProviders.get(provider) + ": " + e);
                }
            }
        }
        return stats;
    }

    @Override
    public void addVpnUidRanges(int netId, UidRange[] ranges) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.networkAddUidRanges(netId, NetworkManagementService.toStableParcels(ranges));
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void removeVpnUidRanges(int netId, UidRange[] ranges) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.networkRemoveUidRanges(netId, NetworkManagementService.toStableParcels(ranges));
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setFirewallEnabled(boolean enabled) {
        NetworkManagementService.enforceSystemUid();
        try {
            this.mNetdService.firewallSetFirewallType(enabled ? 0 : 1);
            this.mFirewallEnabled = enabled;
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isFirewallEnabled() {
        NetworkManagementService.enforceSystemUid();
        return this.mFirewallEnabled;
    }

    @Override
    public void setFirewallInterfaceRule(String iface, boolean allow) {
        NetworkManagementService.enforceSystemUid();
        Preconditions.checkState(this.mFirewallEnabled);
        try {
            this.mNetdService.firewallSetInterfaceRule(iface, allow ? 1 : 2);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocketsForFirewallChainLocked(int chain, String chainName) {
        int[] exemptUids;
        Object object;
        UidRangeParcel[] ranges;
        int numUids = 0;
        if (DBG) {
            Slog.d(TAG, "Closing sockets after enabling chain " + chainName);
        }
        if (this.getFirewallType(chain) == 0) {
            ranges = new UidRangeParcel[]{NetworkManagementService.makeUidRangeParcel(10000, Integer.MAX_VALUE)};
            object = this.mRulesLock;
            synchronized (object) {
                SparseIntArray rules = this.getUidFirewallRulesLR(chain);
                exemptUids = new int[rules.size()];
                for (int i = 0; i < exemptUids.length; ++i) {
                    if (rules.valueAt(i) != 1) continue;
                    exemptUids[numUids] = rules.keyAt(i);
                    ++numUids;
                }
            }
            if (numUids != exemptUids.length) {
                exemptUids = Arrays.copyOf(exemptUids, numUids);
            }
        } else {
            object = this.mRulesLock;
            synchronized (object) {
                SparseIntArray rules = this.getUidFirewallRulesLR(chain);
                ranges = new UidRangeParcel[rules.size()];
                for (int i = 0; i < ranges.length; ++i) {
                    if (rules.valueAt(i) != 2) continue;
                    int uid = rules.keyAt(i);
                    ranges[numUids] = NetworkManagementService.makeUidRangeParcel(uid, uid);
                    ++numUids;
                }
            }
            if (numUids != ranges.length) {
                ranges = Arrays.copyOf(ranges, numUids);
            }
            exemptUids = new int[]{};
        }
        try {
            this.mNetdService.socketDestroy(ranges, exemptUids);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Slog.e(TAG, "Error closing sockets after enabling chain " + chainName + ": " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFirewallChainEnabled(int chain, boolean enable) {
        NetworkManagementService.enforceSystemUid();
        Object object = this.mQuotaLock;
        synchronized (object) {
            Object object2 = this.mRulesLock;
            synchronized (object2) {
                if (this.getFirewallChainState(chain) == enable) {
                    return;
                }
                this.setFirewallChainState(chain, enable);
            }
            String chainName = this.getFirewallChainName(chain);
            if (chain == 0) {
                throw new IllegalArgumentException("Bad child chain: " + chainName);
            }
            try {
                this.mNetdService.firewallEnableChildChain(chain, enable);
            }
            catch (RemoteException | ServiceSpecificException e) {
                throw new IllegalStateException(e);
            }
            if (enable) {
                this.closeSocketsForFirewallChainLocked(chain, chainName);
            }
        }
    }

    private String getFirewallChainName(int chain) {
        switch (chain) {
            case 2: {
                return "standby";
            }
            case 1: {
                return "dozable";
            }
            case 3: {
                return "powersave";
            }
        }
        throw new IllegalArgumentException("Bad child chain: " + chain);
    }

    private int getFirewallType(int chain) {
        switch (chain) {
            case 2: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 3: {
                return 0;
            }
        }
        return this.isFirewallEnabled() ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFirewallUidRules(int chain, int[] uids, int[] rules) {
        NetworkManagementService.enforceSystemUid();
        Object object = this.mQuotaLock;
        synchronized (object) {
            Object object2 = this.mRulesLock;
            synchronized (object2) {
                int uid;
                int index;
                SparseIntArray uidFirewallRules = this.getUidFirewallRulesLR(chain);
                SparseIntArray newRules = new SparseIntArray();
                for (int index2 = uids.length - 1; index2 >= 0; --index2) {
                    int uid2 = uids[index2];
                    int rule = rules[index2];
                    this.updateFirewallUidRuleLocked(chain, uid2, rule);
                    newRules.put(uid2, rule);
                }
                SparseIntArray rulesToRemove = new SparseIntArray();
                for (index = uidFirewallRules.size() - 1; index >= 0; --index) {
                    uid = uidFirewallRules.keyAt(index);
                    if (newRules.indexOfKey(uid) >= 0) continue;
                    rulesToRemove.put(uid, 0);
                }
                for (index = rulesToRemove.size() - 1; index >= 0; --index) {
                    uid = rulesToRemove.keyAt(index);
                    this.updateFirewallUidRuleLocked(chain, uid, 0);
                }
            }
            try {
                switch (chain) {
                    case 1: {
                        this.mNetdService.firewallReplaceUidChain("fw_dozable", true, uids);
                        break;
                    }
                    case 2: {
                        this.mNetdService.firewallReplaceUidChain("fw_standby", false, uids);
                        break;
                    }
                    case 3: {
                        this.mNetdService.firewallReplaceUidChain("fw_powersave", true, uids);
                        break;
                    }
                    default: {
                        Slog.d(TAG, "setFirewallUidRules() called on invalid chain: " + chain);
                        break;
                    }
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Error flushing firewall chain " + chain, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFirewallUidRule(int chain, int uid, int rule) {
        NetworkManagementService.enforceSystemUid();
        Object object = this.mQuotaLock;
        synchronized (object) {
            this.setFirewallUidRuleLocked(chain, uid, rule);
        }
    }

    private void setFirewallUidRuleLocked(int chain, int uid, int rule) {
        if (this.updateFirewallUidRuleLocked(chain, uid, rule)) {
            int ruleType = this.getFirewallRuleType(chain, rule);
            try {
                this.mNetdService.firewallSetUidRule(chain, uid, ruleType);
            }
            catch (RemoteException | ServiceSpecificException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateFirewallUidRuleLocked(int chain, int uid, int rule) {
        Object object = this.mRulesLock;
        synchronized (object) {
            SparseIntArray uidFirewallRules = this.getUidFirewallRulesLR(chain);
            int oldUidFirewallRule = uidFirewallRules.get(uid, 0);
            if (DBG) {
                Slog.d(TAG, "oldRule = " + oldUidFirewallRule + ", newRule=" + rule + " for uid=" + uid + " on chain " + chain);
            }
            if (oldUidFirewallRule == rule) {
                if (DBG) {
                    Slog.d(TAG, "!!!!! Skipping change");
                }
                return false;
            }
            String ruleName = this.getFirewallRuleName(chain, rule);
            String oldRuleName = this.getFirewallRuleName(chain, oldUidFirewallRule);
            if (rule == 0) {
                uidFirewallRules.delete(uid);
            } else {
                uidFirewallRules.put(uid, rule);
            }
            return !ruleName.equals(oldRuleName);
        }
    }

    private String getFirewallRuleName(int chain, int rule) {
        String ruleName = this.getFirewallType(chain) == 0 ? (rule == 1 ? "allow" : "deny") : (rule == 2 ? "deny" : "allow");
        return ruleName;
    }

    @GuardedBy(value={"mRulesLock"})
    private SparseIntArray getUidFirewallRulesLR(int chain) {
        switch (chain) {
            case 2: {
                return this.mUidFirewallStandbyRules;
            }
            case 1: {
                return this.mUidFirewallDozableRules;
            }
            case 3: {
                return this.mUidFirewallPowerSaveRules;
            }
            case 0: {
                return this.mUidFirewallRules;
            }
        }
        throw new IllegalArgumentException("Unknown chain:" + chain);
    }

    private int getFirewallRuleType(int chain, int rule) {
        if (rule == 0) {
            return this.getFirewallType(chain) == 0 ? 2 : 1;
        }
        return rule;
    }

    private static void enforceSystemUid() {
        int uid = Binder.getCallingUid();
        if (uid != 1000) {
            throw new SecurityException("Only available to AID_SYSTEM");
        }
    }

    @Override
    public void registerNetworkActivityListener(INetworkActivityListener listener) {
        this.mNetworkActivityListeners.register(listener);
    }

    @Override
    public void unregisterNetworkActivityListener(INetworkActivityListener listener) {
        this.mNetworkActivityListeners.unregister(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNetworkActive() {
        RemoteCallbackList<INetworkActivityListener> remoteCallbackList = this.mNetworkActivityListeners;
        synchronized (remoteCallbackList) {
            return this.mNetworkActive || this.mActiveIdleTimers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportNetworkActive() {
        int length = this.mNetworkActivityListeners.beginBroadcast();
        try {
            for (int i = 0; i < length; ++i) {
                try {
                    this.mNetworkActivityListeners.getBroadcastItem(i).onNetworkActive();
                    continue;
                }
                catch (RemoteException | RuntimeException exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.mNetworkActivityListeners.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        pw.print("mMobileActivityFromRadio=");
        pw.print(this.mMobileActivityFromRadio);
        pw.print(" mLastPowerStateFromRadio=");
        pw.println(this.mLastPowerStateFromRadio);
        pw.print("mNetworkActive=");
        pw.println(this.mNetworkActive);
        Object object = this.mQuotaLock;
        synchronized (object) {
            pw.print("Active quota ifaces: ");
            pw.println(this.mActiveQuotas.toString());
            pw.print("Active alert ifaces: ");
            pw.println(this.mActiveAlerts.toString());
            pw.print("Data saver mode: ");
            pw.println(this.mDataSaverMode);
            Iterator<Map.Entry<String, IdleTimerParams>> iterator = this.mRulesLock;
            synchronized (iterator) {
                this.dumpUidRuleOnQuotaLocked(pw, "blacklist", this.mUidRejectOnMetered);
                this.dumpUidRuleOnQuotaLocked(pw, "whitelist", this.mUidAllowOnMetered);
            }
        }
        object = this.mRulesLock;
        synchronized (object) {
            this.dumpUidFirewallRule(pw, "", this.mUidFirewallRules);
            pw.print("UID firewall standby chain enabled: ");
            pw.println(this.getFirewallChainState(2));
            this.dumpUidFirewallRule(pw, "standby", this.mUidFirewallStandbyRules);
            pw.print("UID firewall dozable chain enabled: ");
            pw.println(this.getFirewallChainState(1));
            this.dumpUidFirewallRule(pw, "dozable", this.mUidFirewallDozableRules);
            pw.println("UID firewall powersave chain enabled: " + this.getFirewallChainState(3));
            this.dumpUidFirewallRule(pw, "powersave", this.mUidFirewallPowerSaveRules);
        }
        object = this.mIdleTimerLock;
        synchronized (object) {
            pw.println("Idle timers:");
            for (Map.Entry<String, IdleTimerParams> ent : this.mActiveIdleTimers.entrySet()) {
                pw.print("  ");
                pw.print(ent.getKey());
                pw.println(":");
                IdleTimerParams params = ent.getValue();
                pw.print("    timeout=");
                pw.print(params.timeout);
                pw.print(" type=");
                pw.print(params.type);
                pw.print(" networkCount=");
                pw.println(params.networkCount);
            }
        }
        pw.print("Firewall enabled: ");
        pw.println(this.mFirewallEnabled);
        pw.print("Netd service status: ");
        if (this.mNetdService == null) {
            pw.println("disconnected");
        } else {
            try {
                boolean alive = this.mNetdService.isAlive();
                pw.println(alive ? "alive" : "dead");
            }
            catch (RemoteException e) {
                pw.println("unreachable");
            }
        }
    }

    private void dumpUidRuleOnQuotaLocked(PrintWriter pw, String name, SparseBooleanArray list) {
        pw.print("UID bandwith control ");
        pw.print(name);
        pw.print(" rule: [");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            pw.print(list.keyAt(i));
            if (i >= size - 1) continue;
            pw.print(",");
        }
        pw.println("]");
    }

    private void dumpUidFirewallRule(PrintWriter pw, String name, SparseIntArray rules) {
        pw.print("UID firewall ");
        pw.print(name);
        pw.print(" rule: [");
        int size = rules.size();
        for (int i = 0; i < size; ++i) {
            pw.print(rules.keyAt(i));
            pw.print(":");
            pw.print(rules.valueAt(i));
            if (i >= size - 1) continue;
            pw.print(",");
        }
        pw.println("]");
    }

    @Override
    public void addInterfaceToNetwork(String iface, int netId) {
        this.modifyInterfaceInNetwork(true, netId, iface);
    }

    @Override
    public void removeInterfaceFromNetwork(String iface, int netId) {
        this.modifyInterfaceInNetwork(false, netId, iface);
    }

    private void modifyInterfaceInNetwork(boolean add, int netId, String iface) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            if (add) {
                this.mNetdService.networkAddInterface(netId, iface);
            } else {
                this.mNetdService.networkRemoveInterface(netId, iface);
            }
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void addLegacyRouteForNetId(int netId, RouteInfo routeInfo, int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        LinkAddress la = routeInfo.getDestinationLinkAddress();
        String ifName = routeInfo.getInterface();
        String dst = la.toString();
        String nextHop = routeInfo.hasGateway() ? routeInfo.getGateway().getHostAddress() : "";
        try {
            this.mNetdService.networkAddLegacyRoute(netId, ifName, dst, nextHop, uid);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setDefaultNetId(int netId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.networkSetDefault(netId);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void clearDefaultNetId() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.networkClearDefault();
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setNetworkPermission(int netId, int permission2) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.networkSetPermissionForNetwork(netId, permission2);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void allowProtect(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.networkSetProtectAllow(uid);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void denyProtect(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        try {
            this.mNetdService.networkSetProtectDeny(uid);
        }
        catch (RemoteException | ServiceSpecificException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void addInterfaceToLocalNetwork(String iface, List<RouteInfo> routes) {
        this.modifyInterfaceInNetwork(true, 99, iface);
        for (RouteInfo route : routes) {
            if (route.isDefaultRoute()) continue;
            this.modifyRoute(true, 99, route);
        }
        this.modifyRoute(true, 99, new RouteInfo(new IpPrefix("fe80::/64"), null, iface));
    }

    @Override
    public void removeInterfaceFromLocalNetwork(String iface) {
        this.modifyInterfaceInNetwork(false, 99, iface);
    }

    @Override
    public int removeRoutesFromLocalNetwork(List<RouteInfo> routes) {
        int failures = 0;
        for (RouteInfo route : routes) {
            try {
                this.modifyRoute(false, 99, route);
            }
            catch (IllegalStateException e) {
                ++failures;
            }
        }
        return failures;
    }

    @Override
    public boolean isNetworkRestricted(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        return this.isNetworkRestrictedInternal(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNetworkRestrictedInternal(int uid) {
        Object object = this.mRulesLock;
        synchronized (object) {
            if (this.getFirewallChainState(2) && this.mUidFirewallStandbyRules.get(uid) == 2) {
                if (DBG) {
                    Slog.d(TAG, "Uid " + uid + " restricted because of app standby mode");
                }
                return true;
            }
            if (this.getFirewallChainState(1) && this.mUidFirewallDozableRules.get(uid) != 1) {
                if (DBG) {
                    Slog.d(TAG, "Uid " + uid + " restricted because of device idle mode");
                }
                return true;
            }
            if (this.getFirewallChainState(3) && this.mUidFirewallPowerSaveRules.get(uid) != 1) {
                if (DBG) {
                    Slog.d(TAG, "Uid " + uid + " restricted because of power saver mode");
                }
                return true;
            }
            if (this.mUidRejectOnMetered.get(uid)) {
                if (DBG) {
                    Slog.d(TAG, "Uid " + uid + " restricted because of no metered data in the background");
                }
                return true;
            }
            if (this.mDataSaverMode && !this.mUidAllowOnMetered.get(uid)) {
                if (DBG) {
                    Slog.d(TAG, "Uid " + uid + " restricted because of data saver mode");
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFirewallChainState(int chain, boolean state) {
        Object object = this.mRulesLock;
        synchronized (object) {
            this.mFirewallChainStates.put(chain, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getFirewallChainState(int chain) {
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mFirewallChainStates.get(chain);
        }
    }

    @VisibleForTesting
    Injector getInjector() {
        return new Injector();
    }

    @VisibleForTesting
    class Injector {
        Injector() {
        }

        void setDataSaverMode(boolean dataSaverMode) {
            NetworkManagementService.this.mDataSaverMode = dataSaverMode;
        }

        void setFirewallChainState(int chain, boolean state) {
            NetworkManagementService.this.setFirewallChainState(chain, state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFirewallRule(int chain, int uid, int rule) {
            Object object = NetworkManagementService.this.mRulesLock;
            synchronized (object) {
                NetworkManagementService.this.getUidFirewallRulesLR(chain).put(uid, rule);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setUidOnMeteredNetworkList(boolean blacklist, int uid, boolean enable) {
            Object object = NetworkManagementService.this.mRulesLock;
            synchronized (object) {
                if (blacklist) {
                    NetworkManagementService.this.mUidRejectOnMetered.put(uid, enable);
                } else {
                    NetworkManagementService.this.mUidAllowOnMetered.put(uid, enable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            Object object = NetworkManagementService.this.mRulesLock;
            synchronized (object) {
                int[] chains;
                this.setDataSaverMode(false);
                for (int chain : chains = new int[]{1, 2, 3}) {
                    this.setFirewallChainState(chain, false);
                    NetworkManagementService.this.getUidFirewallRulesLR(chain).clear();
                }
                NetworkManagementService.this.mUidAllowOnMetered.clear();
                NetworkManagementService.this.mUidRejectOnMetered.clear();
            }
        }
    }

    @VisibleForTesting
    class LocalService
    extends NetworkManagementInternal {
        LocalService() {
        }

        @Override
        public boolean isNetworkRestrictedForUid(int uid) {
            return NetworkManagementService.this.isNetworkRestrictedInternal(uid);
        }
    }

    private class NetdTetheringStatsProvider
    extends ITetheringStatsProvider.Stub {
        private NetdTetheringStatsProvider() {
        }

        @Override
        public NetworkStats getTetherStats(int how) {
            TetherStatsParcel[] tetherStatsVec;
            if (how != 1) {
                return new NetworkStats(SystemClock.elapsedRealtime(), 0);
            }
            try {
                tetherStatsVec = NetworkManagementService.this.mNetdService.tetherGetStats();
            }
            catch (RemoteException | ServiceSpecificException e) {
                throw new IllegalStateException("problem parsing tethering stats: ", e);
            }
            NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), tetherStatsVec.length);
            NetworkStats.Entry entry = new NetworkStats.Entry();
            for (TetherStatsParcel tetherStats : tetherStatsVec) {
                try {
                    entry.iface = tetherStats.iface;
                    entry.uid = -5;
                    entry.set = 0;
                    entry.tag = 0;
                    entry.rxBytes = tetherStats.rxBytes;
                    entry.rxPackets = tetherStats.rxPackets;
                    entry.txBytes = tetherStats.txBytes;
                    entry.txPackets = tetherStats.txPackets;
                    stats.combineValues(entry);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalStateException("invalid tethering stats " + e);
                }
            }
            return stats;
        }

        @Override
        public void setInterfaceQuota(String iface, long quotaBytes) {
        }
    }

    private class NetdUnsolicitedEventListener
    extends INetdUnsolicitedEventListener.Stub {
        private NetdUnsolicitedEventListener() {
        }

        @Override
        public void onInterfaceClassActivityChanged(boolean isActive, int label, long timestamp, int uid) throws RemoteException {
            long timestampNanos = timestamp <= 0L ? SystemClock.elapsedRealtimeNanos() : timestamp;
            NetworkManagementService.this.mDaemonHandler.post(() -> NetworkManagementService.this.notifyInterfaceClassActivity(label, isActive, timestampNanos, uid, false));
        }

        @Override
        public void onQuotaLimitReached(String alertName, String ifName) throws RemoteException {
            NetworkManagementService.this.mDaemonHandler.post(() -> NetworkManagementService.this.notifyLimitReached(alertName, ifName));
        }

        @Override
        public void onInterfaceDnsServerInfo(String ifName, long lifetime, String[] servers) throws RemoteException {
            NetworkManagementService.this.mDaemonHandler.post(() -> NetworkManagementService.this.notifyInterfaceDnsServerInfo(ifName, lifetime, servers));
        }

        @Override
        public void onInterfaceAddressUpdated(String addr, String ifName, int flags, int scope) throws RemoteException {
            LinkAddress address = new LinkAddress(addr, flags, scope);
            NetworkManagementService.this.mDaemonHandler.post(() -> NetworkManagementService.this.notifyAddressUpdated(ifName, address));
        }

        @Override
        public void onInterfaceAddressRemoved(String addr, String ifName, int flags, int scope) throws RemoteException {
            LinkAddress address = new LinkAddress(addr, flags, scope);
            NetworkManagementService.this.mDaemonHandler.post(() -> NetworkManagementService.this.notifyAddressRemoved(ifName, address));
        }

        @Override
        public void onInterfaceAdded(String ifName) throws RemoteException {
            NetworkManagementService.this.mDaemonHandler.post(() -> NetworkManagementService.this.notifyInterfaceAdded(ifName));
        }

        @Override
        public void onInterfaceRemoved(String ifName) throws RemoteException {
            NetworkManagementService.this.mDaemonHandler.post(() -> NetworkManagementService.this.notifyInterfaceRemoved(ifName));
        }

        @Override
        public void onInterfaceChanged(String ifName, boolean up) throws RemoteException {
            NetworkManagementService.this.mDaemonHandler.post(() -> NetworkManagementService.this.notifyInterfaceStatusChanged(ifName, up));
        }

        @Override
        public void onInterfaceLinkStateChanged(String ifName, boolean up) throws RemoteException {
            NetworkManagementService.this.mDaemonHandler.post(() -> NetworkManagementService.this.notifyInterfaceLinkStateChanged(ifName, up));
        }

        @Override
        public void onRouteChanged(boolean updated, String route, String gateway, String ifName) throws RemoteException {
            RouteInfo processRoute = new RouteInfo(new IpPrefix(route), "".equals(gateway) ? null : InetAddresses.parseNumericAddress(gateway), ifName);
            NetworkManagementService.this.mDaemonHandler.post(() -> NetworkManagementService.this.notifyRouteChange(updated, processRoute));
        }

        @Override
        public void onStrictCleartextDetected(int uid, String hex) throws RemoteException {
            ActivityManager.getService().notifyCleartextNetwork(uid, HexDump.hexStringToByteArray(hex));
        }

        @Override
        public int getInterfaceVersion() {
            return 2;
        }
    }

    @FunctionalInterface
    private static interface NetworkManagementEventCallback {
        public void sendCallback(INetworkManagementEventObserver var1) throws RemoteException;
    }

    private static class IdleTimerParams {
        public final int timeout;
        public final int type;
        public int networkCount;

        IdleTimerParams(int timeout, int type) {
            this.timeout = timeout;
            this.type = type;
            this.networkCount = 1;
        }
    }

    static class SystemServices {
        SystemServices() {
        }

        public IBinder getService(String name) {
            return ServiceManager.getService(name);
        }

        public void registerLocalService(NetworkManagementInternal nmi) {
            LocalServices.addService(NetworkManagementInternal.class, nmi);
        }

        public INetd getNetd() {
            return NetdService.get();
        }
    }
}

