/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.VersionedPackage;
import android.net.NetworkStackClient;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.provider.DeviceConfig;
import android.service.watchdog.ExplicitHealthCheckService;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.ExplicitHealthCheckController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PackageWatchdog {
    private static final String TAG = "PackageWatchdog";
    static final String PROPERTY_WATCHDOG_TRIGGER_DURATION_MILLIS = "watchdog_trigger_failure_duration_millis";
    static final String PROPERTY_WATCHDOG_TRIGGER_FAILURE_COUNT = "watchdog_trigger_failure_count";
    static final String PROPERTY_WATCHDOG_EXPLICIT_HEALTH_CHECK_ENABLED = "watchdog_explicit_health_check_enabled";
    private static final int DEFAULT_TRIGGER_FAILURE_DURATION_MS = (int)TimeUnit.MINUTES.toMillis(1L);
    private static final int DEFAULT_TRIGGER_FAILURE_COUNT = 5;
    private static final boolean DEFAULT_EXPLICIT_HEALTH_CHECK_ENABLED = true;
    private static final int DB_VERSION = 1;
    private static final String TAG_PACKAGE_WATCHDOG = "package-watchdog";
    private static final String TAG_PACKAGE = "package";
    private static final String TAG_OBSERVER = "observer";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DURATION = "duration";
    private static final String ATTR_EXPLICIT_HEALTH_CHECK_DURATION = "health-check-duration";
    private static final String ATTR_PASSED_HEALTH_CHECK = "passed-health-check";
    @GuardedBy(value={"PackageWatchdog.class"})
    private static PackageWatchdog sPackageWatchdog;
    private final Object mLock = new Object();
    private final Context mContext;
    private final Handler mShortTaskHandler;
    private final Handler mLongTaskHandler;
    @GuardedBy(value={"mLock"})
    private final ArrayMap<String, ObserverInternal> mAllObservers = new ArrayMap();
    private final AtomicFile mPolicyFile;
    private final ExplicitHealthCheckController mHealthCheckController;
    private final NetworkStackClient mNetworkStackClient;
    @GuardedBy(value={"mLock"})
    private boolean mIsPackagesReady;
    @GuardedBy(value={"mLock"})
    private boolean mIsHealthCheckEnabled = true;
    @GuardedBy(value={"mLock"})
    private int mTriggerFailureDurationMs = DEFAULT_TRIGGER_FAILURE_DURATION_MS;
    @GuardedBy(value={"mLock"})
    private int mTriggerFailureCount = 5;
    @GuardedBy(value={"mLock"})
    private long mUptimeAtLastStateSync;

    private PackageWatchdog(Context context) {
        this(context, new AtomicFile(new File(new File(Environment.getDataDirectory(), "system"), "package-watchdog.xml")), new Handler(Looper.myLooper()), BackgroundThread.getHandler(), new ExplicitHealthCheckController(context), NetworkStackClient.getInstance());
    }

    @VisibleForTesting
    PackageWatchdog(Context context, AtomicFile policyFile, Handler shortTaskHandler, Handler longTaskHandler, ExplicitHealthCheckController controller, NetworkStackClient networkStackClient) {
        this.mContext = context;
        this.mPolicyFile = policyFile;
        this.mShortTaskHandler = shortTaskHandler;
        this.mLongTaskHandler = longTaskHandler;
        this.mHealthCheckController = controller;
        this.mNetworkStackClient = networkStackClient;
        this.loadFromFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackageWatchdog getInstance(Context context) {
        Class<PackageWatchdog> clazz = PackageWatchdog.class;
        synchronized (PackageWatchdog.class) {
            if (sPackageWatchdog == null) {
                sPackageWatchdog = new PackageWatchdog(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sPackageWatchdog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPackagesReady() {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsPackagesReady = true;
            this.mHealthCheckController.setCallbacks(packageName -> this.onHealthCheckPassed((String)packageName), packages -> this.onSupportedPackages((List<ExplicitHealthCheckService.PackageConfig>)packages), () -> this.syncRequestsAsync());
            this.setPropertyChangedListenerLocked();
            this.updateConfigs();
            this.registerNetworkStackHealthListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHealthObserver(PackageHealthObserver observer) {
        Object object = this.mLock;
        synchronized (object) {
            ObserverInternal internalObserver = this.mAllObservers.get(observer.getName());
            if (internalObserver != null) {
                internalObserver.mRegisteredObserver = observer;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startObservingHealth(PackageHealthObserver observer, List<String> packageNames, long durationMs) {
        if (packageNames.isEmpty()) {
            Slog.wtf(TAG, "No packages to observe, " + observer.getName());
            return;
        }
        if (durationMs < 1L) {
            throw new IllegalArgumentException("Invalid duration " + durationMs + "ms for observer " + observer.getName() + ". Not observing packages " + packageNames);
        }
        ArrayList<MonitoredPackage> packages = new ArrayList<MonitoredPackage>();
        for (int i = 0; i < packageNames.size(); ++i) {
            packages.add(new MonitoredPackage(packageNames.get(i), durationMs, false));
        }
        this.syncState("observing new packages");
        Object object = this.mLock;
        synchronized (object) {
            ObserverInternal oldObserver = this.mAllObservers.get(observer.getName());
            if (oldObserver == null) {
                Slog.d(TAG, observer.getName() + " started monitoring health of packages " + packageNames);
                this.mAllObservers.put(observer.getName(), new ObserverInternal(observer.getName(), packages));
            } else {
                Slog.d(TAG, observer.getName() + " added the following packages to monitor " + packageNames);
                oldObserver.updatePackagesLocked(packages);
            }
        }
        this.registerHealthObserver(observer);
        this.syncState("updated observers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHealthObserver(PackageHealthObserver observer) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAllObservers.remove(observer.getName());
        }
        this.syncState("unregistering observer: " + observer.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPackages(PackageHealthObserver observer) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mAllObservers.size(); ++i) {
                if (!observer.getName().equals(this.mAllObservers.keyAt(i))) continue;
                if (observer.equals(this.mAllObservers.valueAt((int)i).mRegisteredObserver)) {
                    return this.mAllObservers.valueAt((int)i).mPackages.keySet();
                }
                return Collections.emptySet();
            }
        }
        return null;
    }

    public void onPackageFailure(List<VersionedPackage> packages) {
        this.mLongTaskHandler.post(() -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mAllObservers.isEmpty()) {
                    return;
                }
                for (int pIndex = 0; pIndex < packages.size(); ++pIndex) {
                    VersionedPackage versionedPackage = (VersionedPackage)packages.get(pIndex);
                    PackageHealthObserver currentObserverToNotify = null;
                    int currentObserverImpact = Integer.MAX_VALUE;
                    for (int oIndex = 0; oIndex < this.mAllObservers.size(); ++oIndex) {
                        int impact;
                        ObserverInternal observer = this.mAllObservers.valueAt(oIndex);
                        PackageHealthObserver registeredObserver = observer.mRegisteredObserver;
                        if (registeredObserver == null || !observer.onPackageFailureLocked(versionedPackage.getPackageName()) || (impact = registeredObserver.onHealthCheckFailed(versionedPackage)) == 0 || impact >= currentObserverImpact) continue;
                        currentObserverToNotify = registeredObserver;
                        currentObserverImpact = impact;
                    }
                    if (currentObserverToNotify == null) continue;
                    currentObserverToNotify.execute(versionedPackage);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNow() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAllObservers.isEmpty()) {
                this.mLongTaskHandler.removeCallbacks(this::saveToFileAsync);
                this.pruneObserversLocked();
                this.saveToFile();
                Slog.i(TAG, "Last write to update package durations");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExplicitHealthCheckEnabled(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsHealthCheckEnabled = enabled;
            this.mHealthCheckController.setEnabled(enabled);
            this.syncState("health check state " + (enabled ? "enabled" : "disabled"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getTriggerFailureCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTriggerFailureCount;
        }
    }

    private void syncRequestsAsync() {
        this.mShortTaskHandler.removeCallbacks(this::syncRequests);
        this.mShortTaskHandler.post(this::syncRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncRequests() {
        Set<String> packages = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsPackagesReady) {
                packages = this.getPackagesPendingHealthChecksLocked();
            }
        }
        if (packages != null) {
            Slog.i(TAG, "Syncing health check requests for packages: " + packages);
            this.mHealthCheckController.syncRequests(packages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHealthCheckPassed(String packageName) {
        Slog.i(TAG, "Health check passed for package: " + packageName);
        boolean isStateChanged = false;
        Object object = this.mLock;
        synchronized (object) {
            for (int observerIdx = 0; observerIdx < this.mAllObservers.size(); ++observerIdx) {
                int newState;
                ObserverInternal observer = this.mAllObservers.valueAt(observerIdx);
                MonitoredPackage monitoredPackage = observer.mPackages.get(packageName);
                if (monitoredPackage == null) continue;
                int oldState = monitoredPackage.getHealthCheckStateLocked();
                isStateChanged |= oldState != (newState = monitoredPackage.tryPassHealthCheckLocked());
            }
        }
        if (isStateChanged) {
            this.syncState("health check passed for " + packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSupportedPackages(List<ExplicitHealthCheckService.PackageConfig> supportedPackages) {
        boolean isStateChanged = false;
        ArrayMap<String, Long> supportedPackageTimeouts = new ArrayMap<String, Long>();
        for (ExplicitHealthCheckService.PackageConfig info : supportedPackages) {
            supportedPackageTimeouts.put(info.getPackageName(), info.getHealthCheckTimeoutMillis());
        }
        Object object = this.mLock;
        synchronized (object) {
            Slog.d(TAG, "Received supported packages " + supportedPackages);
            Iterator<ObserverInternal> oit = this.mAllObservers.values().iterator();
            while (oit.hasNext()) {
                for (MonitoredPackage monitoredPackage : oit.next().mPackages.values()) {
                    String packageName = monitoredPackage.getName();
                    int oldState = monitoredPackage.getHealthCheckStateLocked();
                    int newState = supportedPackageTimeouts.containsKey(packageName) ? monitoredPackage.setHealthCheckActiveLocked((Long)supportedPackageTimeouts.get(packageName)) : monitoredPackage.tryPassHealthCheckLocked();
                    isStateChanged |= oldState != newState;
                }
            }
        }
        if (isStateChanged) {
            this.syncState("updated health check supported packages " + supportedPackages);
        }
    }

    @GuardedBy(value={"mLock"})
    private Set<String> getPackagesPendingHealthChecksLocked() {
        Slog.d(TAG, "Getting all observed packages pending health checks");
        ArraySet<String> packages = new ArraySet<String>();
        for (ObserverInternal observer : this.mAllObservers.values()) {
            for (MonitoredPackage monitoredPackage : observer.mPackages.values()) {
                String packageName = monitoredPackage.getName();
                if (!monitoredPackage.isPendingHealthChecksLocked()) continue;
                packages.add(packageName);
            }
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncState(String reason) {
        Object object = this.mLock;
        synchronized (object) {
            Slog.i(TAG, "Syncing state, reason: " + reason);
            this.pruneObserversLocked();
            this.saveToFileAsync();
            this.syncRequestsAsync();
            this.scheduleNextSyncStateLocked();
        }
    }

    private void syncStateWithScheduledReason() {
        this.syncState("scheduled");
    }

    @GuardedBy(value={"mLock"})
    private void scheduleNextSyncStateLocked() {
        long durationMs = this.getNextStateSyncMillisLocked();
        this.mShortTaskHandler.removeCallbacks(this::syncStateWithScheduledReason);
        if (durationMs == Long.MAX_VALUE) {
            Slog.i(TAG, "Cancelling state sync, nothing to sync");
            this.mUptimeAtLastStateSync = 0L;
        } else {
            Slog.i(TAG, "Scheduling next state sync in " + durationMs + "ms");
            this.mUptimeAtLastStateSync = SystemClock.uptimeMillis();
            this.mShortTaskHandler.postDelayed(this::syncStateWithScheduledReason, durationMs);
        }
    }

    @GuardedBy(value={"mLock"})
    private long getNextStateSyncMillisLocked() {
        long shortestDurationMs = Long.MAX_VALUE;
        for (int oIndex = 0; oIndex < this.mAllObservers.size(); ++oIndex) {
            ArrayMap<String, MonitoredPackage> packages = this.mAllObservers.valueAt((int)oIndex).mPackages;
            for (int pIndex = 0; pIndex < packages.size(); ++pIndex) {
                MonitoredPackage mp = packages.valueAt(pIndex);
                long duration = mp.getShortestScheduleDurationMsLocked();
                if (duration >= shortestDurationMs) continue;
                shortestDurationMs = duration;
            }
        }
        return shortestDurationMs;
    }

    @GuardedBy(value={"mLock"})
    private void pruneObserversLocked() {
        long elapsedMs;
        long l = elapsedMs = this.mUptimeAtLastStateSync == 0L ? 0L : SystemClock.uptimeMillis() - this.mUptimeAtLastStateSync;
        if (elapsedMs <= 0L) {
            Slog.i(TAG, "Not pruning observers, elapsed time: " + elapsedMs + "ms");
            return;
        }
        Slog.i(TAG, "Removing " + elapsedMs + "ms from all packages on all observers");
        Iterator<ObserverInternal> it = this.mAllObservers.values().iterator();
        while (it.hasNext()) {
            ObserverInternal observer = it.next();
            Set failedPackages = observer.prunePackagesLocked(elapsedMs);
            if (!failedPackages.isEmpty()) {
                this.onHealthCheckFailed(observer, failedPackages);
            }
            if (!observer.mPackages.isEmpty()) continue;
            Slog.i(TAG, "Discarding observer " + observer.mName + ". All packages expired");
            it.remove();
        }
    }

    private void onHealthCheckFailed(ObserverInternal observer, Set<MonitoredPackage> failedPackages) {
        this.mLongTaskHandler.post(() -> {
            Object object = this.mLock;
            synchronized (object) {
                PackageHealthObserver registeredObserver = observer.mRegisteredObserver;
                if (registeredObserver != null) {
                    Iterator it = failedPackages.iterator();
                    while (it.hasNext()) {
                        String failedPackage = ((MonitoredPackage)it.next()).getName();
                        Slog.i(TAG, "Explicit health check failed for package " + failedPackage);
                        VersionedPackage versionedPkg = this.getVersionedPackage(failedPackage);
                        if (versionedPkg == null) {
                            Slog.w(TAG, "Explicit health check failed but could not find package " + failedPackage);
                            versionedPkg = new VersionedPackage(failedPackage, 0L);
                        }
                        registeredObserver.execute(versionedPkg);
                    }
                }
            }
        });
    }

    private VersionedPackage getVersionedPackage(String packageName) {
        PackageManager pm = this.mContext.getPackageManager();
        if (pm == null) {
            return null;
        }
        try {
            long versionCode = pm.getPackageInfo(packageName, 0).getLongVersionCode();
            return new VersionedPackage(packageName, versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile() {
        FileInputStream infile = null;
        this.mAllObservers.clear();
        try {
            infile = this.mPolicyFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(infile, StandardCharsets.UTF_8.name());
            XmlUtils.beginDocument(parser, TAG_PACKAGE_WATCHDOG);
            int outerDepth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                ObserverInternal observer = ObserverInternal.read(parser, this);
                if (observer == null) continue;
                this.mAllObservers.put(observer.mName, observer);
            }
        }
        catch (FileNotFoundException parser) {
        }
        catch (IOException | NumberFormatException | XmlPullParserException e) {
            Slog.wtf(TAG, "Unable to read monitored packages, deleting file", e);
            this.mPolicyFile.delete();
        }
        finally {
            IoUtils.closeQuietly(infile);
        }
    }

    private void setPropertyChangedListenerLocked() {
        DeviceConfig.addOnPropertiesChangedListener("rollback", this.mContext.getMainExecutor(), properties -> {
            if (!"rollback".equals(properties.getNamespace())) {
                return;
            }
            this.updateConfigs();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigs() {
        Object object = this.mLock;
        synchronized (object) {
            this.mTriggerFailureCount = DeviceConfig.getInt("rollback", PROPERTY_WATCHDOG_TRIGGER_FAILURE_COUNT, 5);
            if (this.mTriggerFailureCount <= 0) {
                this.mTriggerFailureCount = 5;
            }
            this.mTriggerFailureDurationMs = DeviceConfig.getInt("rollback", PROPERTY_WATCHDOG_TRIGGER_DURATION_MILLIS, DEFAULT_TRIGGER_FAILURE_DURATION_MS);
            if (this.mTriggerFailureDurationMs <= 0) {
                this.mTriggerFailureDurationMs = 5;
            }
            this.setExplicitHealthCheckEnabled(DeviceConfig.getBoolean("rollback", PROPERTY_WATCHDOG_EXPLICIT_HEALTH_CHECK_ENABLED, true));
        }
    }

    private void registerNetworkStackHealthListener() {
        this.mNetworkStackClient.registerHealthListener(packageName -> {
            VersionedPackage pkg = this.getVersionedPackage(packageName);
            if (pkg == null) {
                Slog.wtf(TAG, "NetworkStack failed but could not find its package");
                return;
            }
            List<VersionedPackage> pkgList = Collections.singletonList(pkg);
            long failureCount = this.getTriggerFailureCount();
            int i = 0;
            while ((long)i < failureCount) {
                this.onPackageFailure(pkgList);
                ++i;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveToFile() {
        Slog.i(TAG, "Saving observer state to file");
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            FileOutputStream stream;
            try {
                stream = this.mPolicyFile.startWrite();
            }
            catch (IOException e) {
                Slog.w(TAG, "Cannot update monitored packages", e);
                return false;
            }
            try {
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(stream, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, TAG_PACKAGE_WATCHDOG);
                out.attribute(null, ATTR_VERSION, Integer.toString(1));
                for (int oIndex = 0; oIndex < this.mAllObservers.size(); ++oIndex) {
                    this.mAllObservers.valueAt(oIndex).writeLocked(out);
                }
                out.endTag(null, TAG_PACKAGE_WATCHDOG);
                out.endDocument();
                this.mPolicyFile.finishWrite(stream);
                bl = true;
            }
            catch (IOException e) {
                boolean bl2;
                try {
                    Slog.w(TAG, "Failed to save monitored packages, restoring backup", e);
                    this.mPolicyFile.failWrite(stream);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(stream);
                    throw throwable;
                }
                IoUtils.closeQuietly(stream);
                return bl2;
            }
            IoUtils.closeQuietly(stream);
            return bl;
        }
    }

    private void saveToFileAsync() {
        if (!this.mLongTaskHandler.hasCallbacks(this::saveToFile)) {
            this.mLongTaskHandler.post(this::saveToFile);
        }
    }

    class MonitoredPackage {
        public static final int STATE_ACTIVE = 0;
        public static final int STATE_INACTIVE = 1;
        public static final int STATE_PASSED = 2;
        public static final int STATE_FAILED = 3;
        private final String mName;
        private int mHealthCheckState = 1;
        @GuardedBy(value={"mLock"})
        private boolean mHasPassedHealthCheck;
        @GuardedBy(value={"mLock"})
        private long mDurationMs;
        @GuardedBy(value={"mLock"})
        private long mHealthCheckDurationMs = Long.MAX_VALUE;
        @GuardedBy(value={"mLock"})
        private long mUptimeStartMs;
        @GuardedBy(value={"mLock"})
        private int mFailures;

        MonitoredPackage(String name, long durationMs, boolean hasPassedHealthCheck) {
            this(name, durationMs, Long.MAX_VALUE, hasPassedHealthCheck);
        }

        MonitoredPackage(String name, long durationMs, long healthCheckDurationMs, boolean hasPassedHealthCheck) {
            this.mName = name;
            this.mDurationMs = durationMs;
            this.mHealthCheckDurationMs = healthCheckDurationMs;
            this.mHasPassedHealthCheck = hasPassedHealthCheck;
            this.updateHealthCheckStateLocked();
        }

        @GuardedBy(value={"mLock"})
        public void writeLocked(XmlSerializer out) throws IOException {
            out.startTag(null, PackageWatchdog.TAG_PACKAGE);
            out.attribute(null, PackageWatchdog.ATTR_NAME, this.mName);
            out.attribute(null, PackageWatchdog.ATTR_DURATION, String.valueOf(this.mDurationMs));
            out.attribute(null, PackageWatchdog.ATTR_EXPLICIT_HEALTH_CHECK_DURATION, String.valueOf(this.mHealthCheckDurationMs));
            out.attribute(null, PackageWatchdog.ATTR_PASSED_HEALTH_CHECK, String.valueOf(this.mHasPassedHealthCheck));
            out.endTag(null, PackageWatchdog.TAG_PACKAGE);
        }

        @GuardedBy(value={"mLock"})
        public boolean onFailureLocked() {
            boolean failed;
            long now = SystemClock.uptimeMillis();
            long duration = now - this.mUptimeStartMs;
            if (duration > (long)PackageWatchdog.this.mTriggerFailureDurationMs) {
                this.mFailures = 1;
                this.mUptimeStartMs = now;
            } else {
                ++this.mFailures;
            }
            boolean bl = failed = this.mFailures >= PackageWatchdog.this.mTriggerFailureCount;
            if (failed) {
                this.mFailures = 0;
            }
            return failed;
        }

        @GuardedBy(value={"mLock"})
        public int setHealthCheckActiveLocked(long initialHealthCheckDurationMs) {
            if (initialHealthCheckDurationMs <= 0L) {
                Slog.wtf(PackageWatchdog.TAG, "Cannot set non-positive health check duration " + initialHealthCheckDurationMs + "ms for package " + this.mName + ". Using total duration " + this.mDurationMs + "ms instead");
                initialHealthCheckDurationMs = this.mDurationMs;
            }
            if (this.mHealthCheckState == 1) {
                this.mHealthCheckDurationMs = initialHealthCheckDurationMs;
            }
            return this.updateHealthCheckStateLocked();
        }

        @GuardedBy(value={"mLock"})
        public int handleElapsedTimeLocked(long elapsedMs) {
            if (elapsedMs <= 0L) {
                Slog.w(PackageWatchdog.TAG, "Cannot handle non-positive elapsed time for package " + this.mName);
                return this.mHealthCheckState;
            }
            this.mDurationMs -= elapsedMs;
            if (this.mHealthCheckState == 0) {
                this.mHealthCheckDurationMs -= elapsedMs;
            }
            return this.updateHealthCheckStateLocked();
        }

        @GuardedBy(value={"mLock"})
        public int tryPassHealthCheckLocked() {
            if (this.mHealthCheckState != 3) {
                this.mHasPassedHealthCheck = true;
            }
            return this.updateHealthCheckStateLocked();
        }

        private String getName() {
            return this.mName;
        }

        @GuardedBy(value={"mLock"})
        public int getHealthCheckStateLocked() {
            return this.mHealthCheckState;
        }

        @GuardedBy(value={"mLock"})
        public long getShortestScheduleDurationMsLocked() {
            return Math.min(this.toPositive(this.mDurationMs), this.isPendingHealthChecksLocked() ? this.toPositive(this.mHealthCheckDurationMs) : Long.MAX_VALUE);
        }

        @GuardedBy(value={"mLock"})
        public boolean isExpiredLocked() {
            return this.mDurationMs <= 0L;
        }

        @GuardedBy(value={"mLock"})
        public boolean isPendingHealthChecksLocked() {
            return this.mHealthCheckState == 0 || this.mHealthCheckState == 1;
        }

        @GuardedBy(value={"mLock"})
        private int updateHealthCheckStateLocked() {
            int oldState = this.mHealthCheckState;
            this.mHealthCheckState = this.mHasPassedHealthCheck ? 2 : (this.mHealthCheckDurationMs <= 0L || this.mDurationMs <= 0L ? 3 : (this.mHealthCheckDurationMs == Long.MAX_VALUE ? 1 : 0));
            Slog.i(PackageWatchdog.TAG, "Updated health check state for package " + this.mName + ": " + this.toString(oldState) + " -> " + this.toString(this.mHealthCheckState));
            return this.mHealthCheckState;
        }

        private String toString(int state) {
            switch (state) {
                case 0: {
                    return "ACTIVE";
                }
                case 1: {
                    return "INACTIVE";
                }
                case 2: {
                    return "PASSED";
                }
                case 3: {
                    return "FAILED";
                }
            }
            return "UNKNOWN";
        }

        private long toPositive(long value) {
            return value > 0L ? value : Long.MAX_VALUE;
        }
    }

    private static class ObserverInternal {
        public final String mName;
        @GuardedBy(value={"mLock"})
        public final ArrayMap<String, MonitoredPackage> mPackages = new ArrayMap();
        @GuardedBy(value={"mLock"})
        public PackageHealthObserver mRegisteredObserver;

        ObserverInternal(String name, List<MonitoredPackage> packages) {
            this.mName = name;
            this.updatePackagesLocked(packages);
        }

        @GuardedBy(value={"mLock"})
        public boolean writeLocked(XmlSerializer out) {
            try {
                out.startTag(null, PackageWatchdog.TAG_OBSERVER);
                out.attribute(null, PackageWatchdog.ATTR_NAME, this.mName);
                for (int i = 0; i < this.mPackages.size(); ++i) {
                    MonitoredPackage p = this.mPackages.valueAt(i);
                    p.writeLocked(out);
                }
                out.endTag(null, PackageWatchdog.TAG_OBSERVER);
                return true;
            }
            catch (IOException e) {
                Slog.w(PackageWatchdog.TAG, "Cannot save observer", e);
                return false;
            }
        }

        @GuardedBy(value={"mLock"})
        public void updatePackagesLocked(List<MonitoredPackage> packages) {
            for (int pIndex = 0; pIndex < packages.size(); ++pIndex) {
                MonitoredPackage p = packages.get(pIndex);
                this.mPackages.put(p.mName, p);
            }
        }

        @GuardedBy(value={"mLock"})
        private Set<MonitoredPackage> prunePackagesLocked(long elapsedMs) {
            ArraySet<MonitoredPackage> failedPackages = new ArraySet<MonitoredPackage>();
            Iterator<MonitoredPackage> it = this.mPackages.values().iterator();
            while (it.hasNext()) {
                MonitoredPackage p = it.next();
                int oldState = p.getHealthCheckStateLocked();
                int newState = p.handleElapsedTimeLocked(elapsedMs);
                if (oldState != 3 && newState == 3) {
                    Slog.i(PackageWatchdog.TAG, "Package " + p.mName + " failed health check");
                    failedPackages.add(p);
                }
                if (!p.isExpiredLocked()) continue;
                it.remove();
            }
            return failedPackages;
        }

        @GuardedBy(value={"mLock"})
        public boolean onPackageFailureLocked(String packageName) {
            MonitoredPackage p = this.mPackages.get(packageName);
            if (p != null) {
                return p.onFailureLocked();
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static ObserverInternal read(XmlPullParser parser, PackageWatchdog watchdog) {
            String observerName = null;
            if (PackageWatchdog.TAG_OBSERVER.equals(parser.getName()) && TextUtils.isEmpty(observerName = parser.getAttributeValue(null, PackageWatchdog.ATTR_NAME))) {
                Slog.wtf(PackageWatchdog.TAG, "Unable to read observer name");
                return null;
            }
            ArrayList<MonitoredPackage> packages = new ArrayList<MonitoredPackage>();
            int innerDepth = parser.getDepth();
            try {
                while (XmlUtils.nextElementWithin(parser, innerDepth)) {
                    if (!PackageWatchdog.TAG_PACKAGE.equals(parser.getName())) continue;
                    try {
                        String packageName = parser.getAttributeValue(null, PackageWatchdog.ATTR_NAME);
                        long duration = Long.parseLong(parser.getAttributeValue(null, PackageWatchdog.ATTR_DURATION));
                        long healthCheckDuration = Long.parseLong(parser.getAttributeValue(null, PackageWatchdog.ATTR_EXPLICIT_HEALTH_CHECK_DURATION));
                        boolean hasPassedHealthCheck = Boolean.parseBoolean(parser.getAttributeValue(null, PackageWatchdog.ATTR_PASSED_HEALTH_CHECK));
                        if (TextUtils.isEmpty(packageName)) continue;
                        PackageWatchdog packageWatchdog = watchdog;
                        Objects.requireNonNull(packageWatchdog);
                        packages.add(packageWatchdog.new MonitoredPackage(packageName, duration, healthCheckDuration, hasPassedHealthCheck));
                    }
                    catch (NumberFormatException e) {
                        Slog.wtf(PackageWatchdog.TAG, "Skipping package for observer " + observerName, e);
                    }
                }
            }
            catch (IOException | XmlPullParserException e) {
                Slog.wtf(PackageWatchdog.TAG, "Unable to read observer " + observerName, e);
                return null;
            }
            if (packages.isEmpty()) {
                return null;
            }
            return new ObserverInternal(observerName, packages);
        }
    }

    public static interface PackageHealthObserver {
        public int onHealthCheckFailed(VersionedPackage var1);

        public boolean execute(VersionedPackage var1);

        public String getName();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PackageHealthObserverImpact {
        public static final int USER_IMPACT_NONE = 0;
        public static final int USER_IMPACT_LOW = 1;
        public static final int USER_IMPACT_MEDIUM = 3;
        public static final int USER_IMPACT_HIGH = 5;
    }
}

