/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.annotation.UnsupportedAppUsage;
import android.os.ConditionVariable;
import android.os.SystemClock;

abstract class ResettableTimeout {
    @UnsupportedAppUsage
    private ConditionVariable mLock = new ConditionVariable();
    @UnsupportedAppUsage
    private volatile long mOffAt;
    private volatile boolean mOffCalled;
    private Thread mThread;

    ResettableTimeout() {
    }

    public abstract void on(boolean var1);

    public abstract void off();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(long milliseconds) {
        ResettableTimeout resettableTimeout = this;
        synchronized (resettableTimeout) {
            boolean alreadyOn;
            this.mOffAt = SystemClock.uptimeMillis() + milliseconds;
            if (this.mThread == null) {
                alreadyOn = false;
                this.mLock.close();
                this.mThread = new T();
                this.mThread.start();
                this.mLock.block();
                this.mOffCalled = false;
            } else {
                alreadyOn = true;
                this.mThread.interrupt();
            }
            this.on(alreadyOn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ResettableTimeout resettableTimeout = this;
        synchronized (resettableTimeout) {
            this.mOffAt = 0L;
            if (this.mThread != null) {
                this.mThread.interrupt();
                this.mThread = null;
            }
            if (!this.mOffCalled) {
                this.mOffCalled = true;
                this.off();
            }
        }
    }

    private class T
    extends Thread {
        private T() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ResettableTimeout.this.mLock.open();
            while (true) {
                long diff;
                T t = this;
                synchronized (t) {
                    diff = ResettableTimeout.this.mOffAt - SystemClock.uptimeMillis();
                    if (diff <= 0L) {
                        ResettableTimeout.this.mOffCalled = true;
                        ResettableTimeout.this.off();
                        ResettableTimeout.this.mThread = null;
                        break;
                    }
                }
                try {
                    T.sleep(diff);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

