/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.os.Binder;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.DumpUtils;
import com.android.timezone.distro.DistroException;
import com.android.timezone.distro.DistroVersion;
import com.android.timezone.distro.FileUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import libcore.timezone.TimeZoneDataFiles;
import libcore.util.CoreLibraryDebug;
import libcore.util.DebugInfo;

public class RuntimeService
extends Binder {
    private static final String TAG = "RuntimeService";
    private final Context mContext;

    public RuntimeService(Context context) {
        this.mContext = context;
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw)) {
            return;
        }
        boolean protoFormat = RuntimeService.hasOption(args, "--proto");
        ProtoOutputStream proto = null;
        DebugInfo coreLibraryDebugInfo = CoreLibraryDebug.getDebugInfo();
        RuntimeService.addTimeZoneApkDebugInfo(coreLibraryDebugInfo);
        if (protoFormat) {
            proto = new ProtoOutputStream(fd);
            RuntimeService.reportTimeZoneInfoProto(coreLibraryDebugInfo, proto);
        } else {
            RuntimeService.reportTimeZoneInfo(coreLibraryDebugInfo, pw);
        }
        if (protoFormat) {
            proto.flush();
        }
    }

    private static boolean hasOption(String[] args, String arg) {
        for (String opt : args) {
            if (!arg.equals(opt)) continue;
            return true;
        }
        return false;
    }

    private static void addTimeZoneApkDebugInfo(DebugInfo coreLibraryDebugInfo) {
        String debugKeyPrefix = "core_library.timezone.source.data_";
        String versionFileName = TimeZoneDataFiles.getDataTimeZoneFile("distro_version");
        RuntimeService.addDistroVersionDebugInfo(versionFileName, debugKeyPrefix, coreLibraryDebugInfo);
    }

    private static void reportTimeZoneInfo(DebugInfo coreLibraryDebugInfo, PrintWriter pw) {
        pw.println("Core Library Debug Info: ");
        for (DebugInfo.DebugEntry debugEntry : coreLibraryDebugInfo.getDebugEntries()) {
            pw.print(debugEntry.getKey());
            pw.print(": \"");
            pw.print(debugEntry.getStringValue());
            pw.println("\"");
        }
    }

    private static void reportTimeZoneInfoProto(DebugInfo coreLibraryDebugInfo, ProtoOutputStream protoStream) {
        for (DebugInfo.DebugEntry debugEntry : coreLibraryDebugInfo.getDebugEntries()) {
            long entryToken = protoStream.start(2246267895809L);
            protoStream.write(0x10900000001L, debugEntry.getKey());
            protoStream.write(1138166333442L, debugEntry.getStringValue());
            protoStream.end(entryToken);
        }
    }

    private static void addDistroVersionDebugInfo(String distroVersionFileName, String debugKeyPrefix, DebugInfo debugInfo) {
        File file = new File(distroVersionFileName);
        String statusKey = debugKeyPrefix + "status";
        if (file.exists()) {
            try {
                byte[] versionBytes = FileUtils.readBytes(file, DistroVersion.DISTRO_VERSION_FILE_LENGTH);
                DistroVersion distroVersion = DistroVersion.fromBytes(versionBytes);
                String formatVersionString = distroVersion.formatMajorVersion + "." + distroVersion.formatMinorVersion;
                debugInfo.addStringEntry(statusKey, "OK").addStringEntry(debugKeyPrefix + "formatVersion", formatVersionString).addStringEntry(debugKeyPrefix + "rulesVersion", distroVersion.rulesVersion).addStringEntry(debugKeyPrefix + "revision", distroVersion.revision);
            }
            catch (DistroException | IOException e) {
                debugInfo.addStringEntry(statusKey, "ERROR");
                debugInfo.addStringEntry(debugKeyPrefix + "exception_class", e.getClass().getName());
                debugInfo.addStringEntry(debugKeyPrefix + "exception_msg", e.getMessage());
                RuntimeService.logMessage("Error reading " + file, e);
            }
        } else {
            debugInfo.addStringEntry(statusKey, "NOT_FOUND");
        }
    }

    private static void logMessage(String msg, Throwable t) {
        Slog.v(TAG, msg, t);
    }
}

