/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.hardware.ISensorPrivacyListener;
import android.hardware.ISensorPrivacyManager;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.FgThread;
import com.android.server.SystemService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class SensorPrivacyService
extends SystemService {
    private static final String TAG = "SensorPrivacyService";
    private static final String SENSOR_PRIVACY_XML_FILE = "sensor_privacy.xml";
    private static final String XML_TAG_SENSOR_PRIVACY = "sensor-privacy";
    private static final String XML_ATTRIBUTE_ENABLED = "enabled";
    private final SensorPrivacyServiceImpl mSensorPrivacyServiceImpl;

    public SensorPrivacyService(Context context) {
        super(context);
        this.mSensorPrivacyServiceImpl = new SensorPrivacyServiceImpl(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("sensor_privacy", this.mSensorPrivacyServiceImpl);
    }

    private final class DeathRecipient
    implements IBinder.DeathRecipient {
        private ISensorPrivacyListener mListener;

        DeathRecipient(ISensorPrivacyListener listener) {
            this.mListener = listener;
            try {
                this.mListener.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public void binderDied() {
            SensorPrivacyService.this.mSensorPrivacyServiceImpl.removeSensorPrivacyListener(this.mListener);
        }

        public void destroy() {
            try {
                this.mListener.asBinder().unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    private final class SensorPrivacyHandler
    extends Handler {
        private static final int MESSAGE_SENSOR_PRIVACY_CHANGED = 1;
        private final Object mListenerLock;
        @GuardedBy(value={"mListenerLock"})
        private final RemoteCallbackList<ISensorPrivacyListener> mListeners;
        private final ArrayMap<ISensorPrivacyListener, DeathRecipient> mDeathRecipients;
        private final Context mContext;

        SensorPrivacyHandler(Looper looper, Context context) {
            super(looper);
            this.mListenerLock = new Object();
            this.mListeners = new RemoteCallbackList();
            this.mDeathRecipients = new ArrayMap();
            this.mContext = context;
        }

        public void onSensorPrivacyChanged(boolean enabled) {
            this.sendMessage(PooledLambda.obtainMessage(SensorPrivacyHandler::handleSensorPrivacyChanged, this, enabled));
            this.sendMessage(PooledLambda.obtainMessage(rec$ -> ((SensorPrivacyServiceImpl)rec$).persistSensorPrivacyState(), SensorPrivacyService.this.mSensorPrivacyServiceImpl));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(ISensorPrivacyListener listener) {
            Object object = this.mListenerLock;
            synchronized (object) {
                DeathRecipient deathRecipient = new DeathRecipient(listener);
                this.mDeathRecipients.put(listener, deathRecipient);
                this.mListeners.register(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(ISensorPrivacyListener listener) {
            Object object = this.mListenerLock;
            synchronized (object) {
                DeathRecipient deathRecipient = this.mDeathRecipients.remove(listener);
                if (deathRecipient != null) {
                    deathRecipient.destroy();
                }
                this.mListeners.unregister(listener);
            }
        }

        public void handleSensorPrivacyChanged(boolean enabled) {
            int count = this.mListeners.beginBroadcast();
            for (int i = 0; i < count; ++i) {
                ISensorPrivacyListener listener = this.mListeners.getBroadcastItem(i);
                try {
                    listener.onSensorPrivacyChanged(enabled);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(SensorPrivacyService.TAG, "Caught an exception notifying listener " + listener + ": ", e);
                }
            }
            this.mListeners.finishBroadcast();
        }
    }

    class SensorPrivacyServiceImpl
    extends ISensorPrivacyManager.Stub {
        private final SensorPrivacyHandler mHandler;
        private final Context mContext;
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private final AtomicFile mAtomicFile;
        @GuardedBy(value={"mLock"})
        private boolean mEnabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SensorPrivacyServiceImpl(Context context) {
            this.mContext = context;
            this.mHandler = new SensorPrivacyHandler(FgThread.get().getLooper(), this.mContext);
            File sensorPrivacyFile = new File(Environment.getDataSystemDirectory(), SensorPrivacyService.SENSOR_PRIVACY_XML_FILE);
            this.mAtomicFile = new AtomicFile(sensorPrivacyFile);
            Object object = this.mLock;
            synchronized (object) {
                this.mEnabled = this.readPersistedSensorPrivacyEnabledLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSensorPrivacy(boolean enable) {
            this.enforceSensorPrivacyPermission();
            Object object = this.mLock;
            synchronized (object) {
                this.mEnabled = enable;
                FileOutputStream outputStream = null;
                try {
                    FastXmlSerializer serializer = new FastXmlSerializer();
                    outputStream = this.mAtomicFile.startWrite();
                    serializer.setOutput(outputStream, StandardCharsets.UTF_8.name());
                    serializer.startDocument(null, true);
                    serializer.startTag(null, SensorPrivacyService.XML_TAG_SENSOR_PRIVACY);
                    serializer.attribute(null, SensorPrivacyService.XML_ATTRIBUTE_ENABLED, String.valueOf(enable));
                    serializer.endTag(null, SensorPrivacyService.XML_TAG_SENSOR_PRIVACY);
                    serializer.endDocument();
                    this.mAtomicFile.finishWrite(outputStream);
                }
                catch (IOException e) {
                    Log.e(SensorPrivacyService.TAG, "Caught an exception persisting the sensor privacy state: ", e);
                    this.mAtomicFile.failWrite(outputStream);
                }
            }
            this.mHandler.onSensorPrivacyChanged(enable);
        }

        private void enforceSensorPrivacyPermission() {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.MANAGE_SENSOR_PRIVACY") == 0) {
                return;
            }
            throw new SecurityException("Changing sensor privacy requires the following permission: android.permission.MANAGE_SENSOR_PRIVACY");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSensorPrivacyEnabled() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mEnabled;
            }
        }

        private boolean readPersistedSensorPrivacyEnabledLocked() {
            boolean enabled;
            if (!this.mAtomicFile.exists()) {
                return false;
            }
            try (FileInputStream inputStream = this.mAtomicFile.openRead();){
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(inputStream, StandardCharsets.UTF_8.name());
                XmlUtils.beginDocument(parser, SensorPrivacyService.XML_TAG_SENSOR_PRIVACY);
                parser.next();
                String tagName = parser.getName();
                enabled = Boolean.valueOf(parser.getAttributeValue(null, SensorPrivacyService.XML_ATTRIBUTE_ENABLED));
            }
            catch (IOException | XmlPullParserException e) {
                Log.e(SensorPrivacyService.TAG, "Caught an exception reading the state from storage: ", e);
                this.mAtomicFile.delete();
                enabled = false;
            }
            return enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void persistSensorPrivacyState() {
            Object object = this.mLock;
            synchronized (object) {
                FileOutputStream outputStream = null;
                try {
                    FastXmlSerializer serializer = new FastXmlSerializer();
                    outputStream = this.mAtomicFile.startWrite();
                    serializer.setOutput(outputStream, StandardCharsets.UTF_8.name());
                    serializer.startDocument(null, true);
                    serializer.startTag(null, SensorPrivacyService.XML_TAG_SENSOR_PRIVACY);
                    serializer.attribute(null, SensorPrivacyService.XML_ATTRIBUTE_ENABLED, String.valueOf(this.mEnabled));
                    serializer.endTag(null, SensorPrivacyService.XML_TAG_SENSOR_PRIVACY);
                    serializer.endDocument();
                    this.mAtomicFile.finishWrite(outputStream);
                }
                catch (IOException e) {
                    Log.e(SensorPrivacyService.TAG, "Caught an exception persisting the sensor privacy state: ", e);
                    this.mAtomicFile.failWrite(outputStream);
                }
            }
        }

        @Override
        public void addSensorPrivacyListener(ISensorPrivacyListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener cannot be null");
            }
            this.mHandler.addListener(listener);
        }

        @Override
        public void removeSensorPrivacyListener(ISensorPrivacyListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener cannot be null");
            }
            this.mHandler.removeListener(listener);
        }
    }
}

