/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class ServiceWatcher
implements ServiceConnection {
    private static final String TAG = "ServiceWatcher";
    private static final boolean D = false;
    public static final String EXTRA_SERVICE_VERSION = "serviceVersion";
    public static final String EXTRA_SERVICE_IS_MULTIUSER = "serviceIsMultiuser";
    private final Context mContext;
    private final String mTag;
    private final String mAction;
    private final String mServicePackageName;
    private final List<HashSet<Signature>> mSignatureSets;
    private final Handler mHandler;
    private IBinder mBestService;
    private int mCurrentUserId;
    private volatile ComponentName mBestComponent;
    private volatile int mBestVersion;
    private volatile int mBestUserId;

    public static ArrayList<HashSet<Signature>> getSignatureSets(Context context, String ... packageNames) {
        PackageManager pm = context.getPackageManager();
        ArrayList<HashSet<Signature>> signatureSets = new ArrayList<HashSet<Signature>>(packageNames.length);
        for (String packageName : packageNames) {
            try {
                Signature[] signatures = pm.getPackageInfo((String)packageName, (int)0x100040).signatures;
                HashSet set = new HashSet();
                Collections.addAll(set, signatures);
                signatureSets.add(set);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w(TAG, packageName + " not found");
            }
        }
        return signatureSets;
    }

    public static boolean isSignatureMatch(Signature[] signatures, List<HashSet<Signature>> sigSets) {
        if (signatures == null) {
            return false;
        }
        HashSet inputSet = new HashSet();
        Collections.addAll(inputSet, signatures);
        for (HashSet<Signature> referenceSet : sigSets) {
            if (!referenceSet.equals(inputSet)) continue;
            return true;
        }
        return false;
    }

    public ServiceWatcher(Context context, String logTag, String action, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId, Handler handler) {
        Resources resources = context.getResources();
        this.mContext = context;
        this.mTag = logTag;
        this.mAction = action;
        boolean enableOverlay = resources.getBoolean(overlaySwitchResId);
        if (enableOverlay) {
            String[] pkgs = resources.getStringArray(initialPackageNamesResId);
            this.mServicePackageName = null;
            this.mSignatureSets = ServiceWatcher.getSignatureSets(context, pkgs);
        } else {
            this.mServicePackageName = resources.getString(defaultServicePackageNameResId);
            this.mSignatureSets = ServiceWatcher.getSignatureSets(context, this.mServicePackageName);
        }
        this.mHandler = handler;
        this.mBestComponent = null;
        this.mBestVersion = Integer.MIN_VALUE;
        this.mBestUserId = -10000;
        this.mBestService = null;
    }

    protected void onBind() {
    }

    protected void onUnbind() {
    }

    public final boolean start() {
        if (this.isServiceMissing()) {
            return false;
        }
        if (this.mServicePackageName == null) {
            new PackageMonitor(){

                @Override
                public void onPackageUpdateFinished(String packageName, int uid) {
                    ServiceWatcher.this.bindBestPackage(Objects.equals(packageName, ServiceWatcher.this.getCurrentPackageName()));
                }

                @Override
                public void onPackageAdded(String packageName, int uid) {
                    ServiceWatcher.this.bindBestPackage(Objects.equals(packageName, ServiceWatcher.this.getCurrentPackageName()));
                }

                @Override
                public void onPackageRemoved(String packageName, int uid) {
                    ServiceWatcher.this.bindBestPackage(Objects.equals(packageName, ServiceWatcher.this.getCurrentPackageName()));
                }

                @Override
                public boolean onPackageChanged(String packageName, int uid, String[] components) {
                    ServiceWatcher.this.bindBestPackage(Objects.equals(packageName, ServiceWatcher.this.getCurrentPackageName()));
                    return super.onPackageChanged(packageName, uid, components);
                }
            }.register(this.mContext, UserHandle.ALL, true, this.mHandler);
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.USER_UNLOCKED");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                if ("android.intent.action.USER_SWITCHED".equals(action)) {
                    ServiceWatcher.this.mCurrentUserId = userId;
                    ServiceWatcher.this.bindBestPackage(false);
                } else if ("android.intent.action.USER_UNLOCKED".equals(action) && userId == ServiceWatcher.this.mCurrentUserId) {
                    ServiceWatcher.this.bindBestPackage(false);
                }
            }
        }, UserHandle.ALL, intentFilter, null, this.mHandler);
        this.mCurrentUserId = ActivityManager.getCurrentUser();
        this.mHandler.post(() -> this.bindBestPackage(false));
        return true;
    }

    public String getCurrentPackageName() {
        ComponentName bestComponent = this.mBestComponent;
        return bestComponent == null ? null : bestComponent.getPackageName();
    }

    private boolean isServiceMissing() {
        return this.mContext.getPackageManager().queryIntentServicesAsUser(new Intent(this.mAction), 786432, 0).isEmpty();
    }

    private void bindBestPackage(boolean forceRebind) {
        boolean alreadyBound;
        List<ResolveInfo> rInfos;
        Preconditions.checkState(Looper.myLooper() == this.mHandler.getLooper());
        Intent intent = new Intent(this.mAction);
        if (this.mServicePackageName != null) {
            intent.setPackage(this.mServicePackageName);
        }
        if ((rInfos = this.mContext.getPackageManager().queryIntentServicesAsUser(intent, 0x10000080, this.mCurrentUserId)) == null) {
            rInfos = Collections.emptyList();
        }
        ComponentName bestComponent = null;
        int bestVersion = Integer.MIN_VALUE;
        boolean bestIsMultiuser = false;
        for (ResolveInfo rInfo : rInfos) {
            ComponentName component;
            block9: {
                component = rInfo.serviceInfo.getComponentName();
                String packageName = component.getPackageName();
                try {
                    PackageInfo pInfo = this.mContext.getPackageManager().getPackageInfo(packageName, 0x10000040);
                    if (!ServiceWatcher.isSignatureMatch(pInfo.signatures, this.mSignatureSets)) {
                        Log.w(this.mTag, packageName + " resolves service " + this.mAction + ", but has wrong signature, ignoring");
                    }
                    break block9;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.wtf(this.mTag, e);
                }
                continue;
            }
            Bundle metadata = rInfo.serviceInfo.metaData;
            int version = Integer.MIN_VALUE;
            boolean isMultiuser = false;
            if (metadata != null) {
                version = metadata.getInt(EXTRA_SERVICE_VERSION, Integer.MIN_VALUE);
                isMultiuser = metadata.getBoolean(EXTRA_SERVICE_IS_MULTIUSER, false);
            }
            if (version <= bestVersion) continue;
            bestComponent = component;
            bestVersion = version;
            bestIsMultiuser = isMultiuser;
        }
        if (bestComponent == null) {
            Slog.w(this.mTag, "Odd, no component found for service " + this.mAction);
            this.unbind();
            return;
        }
        int userId = bestIsMultiuser ? 0 : this.mCurrentUserId;
        boolean bl = alreadyBound = Objects.equals(bestComponent, this.mBestComponent) && bestVersion == this.mBestVersion && userId == this.mBestUserId;
        if (forceRebind || !alreadyBound) {
            this.unbind();
            this.bind(bestComponent, bestVersion, userId);
        }
    }

    private void bind(ComponentName component, int version, int userId) {
        Preconditions.checkState(Looper.myLooper() == this.mHandler.getLooper());
        Intent intent = new Intent(this.mAction);
        intent.setComponent(component);
        this.mBestComponent = component;
        this.mBestVersion = version;
        this.mBestUserId = userId;
        this.mContext.bindServiceAsUser(intent, this, 0x40000005, UserHandle.of(userId));
    }

    private void unbind() {
        Preconditions.checkState(Looper.myLooper() == this.mHandler.getLooper());
        if (this.mBestComponent != null) {
            this.mContext.unbindService(this);
        }
        this.mBestComponent = null;
        this.mBestVersion = Integer.MIN_VALUE;
        this.mBestUserId = -10000;
    }

    public final void runOnBinder(BinderRunner runner) {
        this.runOnHandler(() -> {
            if (this.mBestService == null) {
                return;
            }
            try {
                runner.run(this.mBestService);
            }
            catch (RuntimeException e) {
                Log.e(TAG, "exception while while running " + runner + " on " + this.mBestService + " from " + this, e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        });
    }

    @Deprecated
    public final <T> T runOnBinderBlocking(BlockingBinderRunner<T> runner, T defaultValue) {
        try {
            return (T)this.runOnHandlerBlocking(() -> {
                if (this.mBestService == null) {
                    return defaultValue;
                }
                try {
                    return runner.run(this.mBestService);
                }
                catch (RemoteException e) {
                    return defaultValue;
                }
            });
        }
        catch (InterruptedException e) {
            return defaultValue;
        }
    }

    @Override
    public final void onServiceConnected(ComponentName component, IBinder binder) {
        this.runOnHandler(() -> {
            this.mBestService = binder;
            this.onBind();
        });
    }

    @Override
    public final void onServiceDisconnected(ComponentName component) {
        this.runOnHandler(() -> {
            this.mBestService = null;
            this.onUnbind();
        });
    }

    public String toString() {
        ComponentName bestComponent = this.mBestComponent;
        return bestComponent == null ? "null" : bestComponent.toShortString() + "@" + this.mBestVersion;
    }

    private void runOnHandler(Runnable r) {
        if (Looper.myLooper() == this.mHandler.getLooper()) {
            r.run();
        } else {
            this.mHandler.post(r);
        }
    }

    private <T> T runOnHandlerBlocking(Callable<T> c) throws InterruptedException {
        if (Looper.myLooper() == this.mHandler.getLooper()) {
            try {
                return c.call();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        FutureTask<T> task = new FutureTask<T>(c);
        this.mHandler.post(task);
        try {
            return task.get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public static interface BlockingBinderRunner<T> {
        public T run(IBinder var1) throws RemoteException;
    }

    public static interface BinderRunner {
        public void run(IBinder var1) throws RemoteException;
    }
}

