/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.os.Build;
import android.os.Process;
import android.util.Slog;
import com.android.internal.util.ConcurrentUtils;
import com.android.internal.util.Preconditions;
import com.android.server.Watchdog;
import com.android.server.am.ActivityManagerService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class SystemServerInitThreadPool {
    private static final String TAG = SystemServerInitThreadPool.class.getSimpleName();
    private static final int SHUTDOWN_TIMEOUT_MILLIS = 20000;
    private static final boolean IS_DEBUGGABLE = Build.IS_DEBUGGABLE;
    private static SystemServerInitThreadPool sInstance;
    private ExecutorService mService = ConcurrentUtils.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), "system-server-init-thread", -2);
    private List<String> mPendingTasks = new ArrayList<String>();

    public static synchronized SystemServerInitThreadPool get() {
        if (sInstance == null) {
            sInstance = new SystemServerInitThreadPool();
        }
        Preconditions.checkState(SystemServerInitThreadPool.sInstance.mService != null, "Cannot get " + TAG + " - it has been shut down");
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> submit(Runnable runnable, String description) {
        List<String> list = this.mPendingTasks;
        synchronized (list) {
            this.mPendingTasks.add(description);
        }
        return this.mService.submit(() -> {
            if (IS_DEBUGGABLE) {
                Slog.d(TAG, "Started executing " + description);
            }
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                Slog.e(TAG, "Failure in " + description + ": " + e, e);
                throw e;
            }
            List<String> list = this.mPendingTasks;
            synchronized (list) {
                this.mPendingTasks.remove(description);
            }
            if (IS_DEBUGGABLE) {
                Slog.d(TAG, "Finished executing " + description);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void shutdown() {
        if (sInstance != null && SystemServerInitThreadPool.sInstance.mService != null) {
            boolean terminated;
            SystemServerInitThreadPool.sInstance.mService.shutdown();
            try {
                terminated = SystemServerInitThreadPool.sInstance.mService.awaitTermination(20000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SystemServerInitThreadPool.dumpStackTraces();
                throw new IllegalStateException(TAG + " init interrupted");
            }
            if (!terminated) {
                SystemServerInitThreadPool.dumpStackTraces();
            }
            List<Runnable> unstartedRunnables = SystemServerInitThreadPool.sInstance.mService.shutdownNow();
            if (!terminated) {
                ArrayList<String> copy = new ArrayList<String>();
                List<String> list = SystemServerInitThreadPool.sInstance.mPendingTasks;
                synchronized (list) {
                    copy.addAll(SystemServerInitThreadPool.sInstance.mPendingTasks);
                }
                throw new IllegalStateException("Cannot shutdown. Unstarted tasks " + unstartedRunnables + " Unfinished tasks " + copy);
            }
            SystemServerInitThreadPool.sInstance.mService = null;
            SystemServerInitThreadPool.sInstance.mPendingTasks = null;
            Slog.d(TAG, "Shutdown successful");
        }
    }

    private static void dumpStackTraces() {
        ArrayList<Integer> pids = new ArrayList<Integer>();
        pids.add(Process.myPid());
        ActivityManagerService.dumpStackTraces(pids, null, null, Watchdog.getInterestingNativePids());
    }
}

