/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.CallAttributes;
import android.telephony.CallQuality;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.LocationAccessPolicy;
import android.telephony.PhoneCapability;
import android.telephony.PhysicalChannelConfig;
import android.telephony.PreciseCallState;
import android.telephony.PreciseDataConnectionState;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.data.ApnSetting;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.ims.ImsReasonInfo;
import android.util.LocalLog;
import android.util.StatsLog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.IPhoneStateListener;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.PhoneConstantConversions;
import com.android.internal.telephony.TelephonyPermissions;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.am.BatteryStatsService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class TelephonyRegistry
extends ITelephonyRegistry.Stub {
    private static final String TAG = "TelephonyRegistry";
    private static final boolean DBG = false;
    private static final boolean DBG_LOC = false;
    private static final boolean VDBG = false;
    private final Context mContext;
    private final ArrayList<IBinder> mRemoveList = new ArrayList();
    private final ArrayList<Record> mRecords = new ArrayList();
    private final IBatteryStats mBatteryStats;
    private final AppOpsManager mAppOps;
    private boolean mHasNotifySubscriptionInfoChangedOccurred = false;
    private boolean mHasNotifyOpportunisticSubscriptionInfoChangedOccurred = false;
    private int mNumPhones;
    private int[] mCallState;
    private String[] mCallIncomingNumber;
    private ServiceState[] mServiceState;
    private int[] mVoiceActivationState;
    private int[] mDataActivationState;
    private boolean[] mUserMobileDataState;
    private SignalStrength[] mSignalStrength;
    private boolean[] mMessageWaiting;
    private boolean[] mCallForwarding;
    private int[] mDataActivity;
    private int[] mDataConnectionState;
    private Bundle[] mCellLocation;
    private int[] mDataConnectionNetworkType;
    private int[] mOtaspMode;
    private ArrayList<List<CellInfo>> mCellInfo = null;
    private ArrayList<List<PhysicalChannelConfig>> mPhysicalChannelConfigs;
    private Map<Integer, List<EmergencyNumber>> mEmergencyNumberList;
    private CallQuality[] mCallQuality;
    private CallAttributes[] mCallAttributes;
    private int[] mCallNetworkType;
    private int[] mSrvccState;
    private int mDefaultSubId = -1;
    private int mDefaultPhoneId = -1;
    private int[] mRingingCallState;
    private int[] mForegroundCallState;
    private int[] mBackgroundCallState;
    private PreciseCallState[] mPreciseCallState;
    private int[] mCallDisconnectCause;
    private List<ImsReasonInfo> mImsReasonInfo = null;
    private int[] mCallPreciseDisconnectCause;
    private boolean mCarrierNetworkChangeState = false;
    private PhoneCapability mPhoneCapability = null;
    private int mActiveDataSubId = -1;
    private int mRadioPowerState = 2;
    private final LocalLog mLocalLog = new LocalLog(100);
    private final LocalLog mListenLog = new LocalLog(100);
    private PreciseDataConnectionState[] mPreciseDataConnectionState;
    static final int ENFORCE_COARSE_LOCATION_PERMISSION_MASK = 0;
    static final int ENFORCE_FINE_LOCATION_PERMISSION_MASK = 1040;
    static final int ENFORCE_PHONE_STATE_PERMISSION_MASK = 0x100000C;
    static final int PRECISE_PHONE_STATE_PERMISSION_MASK = 6144;
    private static final int MSG_USER_SWITCHED = 1;
    private static final int MSG_UPDATE_DEFAULT_SUB = 2;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int numPhones = TelephonyManager.getDefault().getPhoneCount();
                    for (int sub = 0; sub < numPhones; ++sub) {
                        TelephonyRegistry.this.notifyCellLocationForSubscriber(sub, TelephonyRegistry.this.mCellLocation[sub]);
                    }
                    break;
                }
                case 2: {
                    int newDefaultPhoneId = msg.arg1;
                    int newDefaultSubId = (Integer)msg.obj;
                    ArrayList arrayList = TelephonyRegistry.this.mRecords;
                    synchronized (arrayList) {
                        for (Record r : TelephonyRegistry.this.mRecords) {
                            if (r.subId != Integer.MAX_VALUE) continue;
                            TelephonyRegistry.this.checkPossibleMissNotify(r, newDefaultPhoneId);
                        }
                        TelephonyRegistry.this.handleRemoveListLocked();
                    }
                    TelephonyRegistry.this.mDefaultSubId = newDefaultSubId;
                    TelephonyRegistry.this.mDefaultPhoneId = newDefaultPhoneId;
                    TelephonyRegistry.this.mLocalLog.log("Default subscription updated: mDefaultPhoneId=" + TelephonyRegistry.this.mDefaultPhoneId + ", mDefaultSubId" + TelephonyRegistry.this.mDefaultSubId);
                }
            }
        }
    };
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.USER_SWITCHED".equals(action)) {
                int userHandle = intent.getIntExtra("android.intent.extra.user_handle", 0);
                TelephonyRegistry.this.mHandler.sendMessage(TelephonyRegistry.this.mHandler.obtainMessage(1, userHandle, 0));
            } else if (action.equals("android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED")) {
                Integer newDefaultSubIdObj = new Integer(intent.getIntExtra("subscription", SubscriptionManager.getDefaultSubscriptionId()));
                int newDefaultPhoneId = intent.getIntExtra("phone", SubscriptionManager.getPhoneId(TelephonyRegistry.this.mDefaultSubId));
                if (TelephonyRegistry.this.validatePhoneId(newDefaultPhoneId) && (!newDefaultSubIdObj.equals(TelephonyRegistry.this.mDefaultSubId) || newDefaultPhoneId != TelephonyRegistry.this.mDefaultPhoneId)) {
                    TelephonyRegistry.this.mHandler.sendMessage(TelephonyRegistry.this.mHandler.obtainMessage(2, newDefaultPhoneId, 0, newDefaultSubIdObj));
                }
            }
        }
    };

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public TelephonyRegistry(Context context) {
        int i;
        int numPhones;
        CellLocation location = CellLocation.getEmpty();
        this.mContext = context;
        this.mBatteryStats = BatteryStatsService.getService();
        this.mNumPhones = numPhones = TelephonyManager.getDefault().getPhoneCount();
        this.mCallState = new int[numPhones];
        this.mDataActivity = new int[numPhones];
        this.mDataConnectionState = new int[numPhones];
        this.mDataConnectionNetworkType = new int[numPhones];
        this.mCallIncomingNumber = new String[numPhones];
        this.mServiceState = new ServiceState[numPhones];
        this.mVoiceActivationState = new int[numPhones];
        this.mDataActivationState = new int[numPhones];
        this.mUserMobileDataState = new boolean[numPhones];
        this.mSignalStrength = new SignalStrength[numPhones];
        this.mMessageWaiting = new boolean[numPhones];
        this.mCallForwarding = new boolean[numPhones];
        this.mCellLocation = new Bundle[numPhones];
        this.mSrvccState = new int[numPhones];
        this.mOtaspMode = new int[numPhones];
        this.mPreciseCallState = new PreciseCallState[numPhones];
        this.mForegroundCallState = new int[numPhones];
        this.mBackgroundCallState = new int[numPhones];
        this.mRingingCallState = new int[numPhones];
        this.mCallDisconnectCause = new int[numPhones];
        this.mCallPreciseDisconnectCause = new int[numPhones];
        this.mCallQuality = new CallQuality[numPhones];
        this.mCallNetworkType = new int[numPhones];
        this.mCallAttributes = new CallAttributes[numPhones];
        this.mPreciseDataConnectionState = new PreciseDataConnectionState[numPhones];
        this.mCellInfo = new ArrayList();
        this.mImsReasonInfo = new ArrayList<ImsReasonInfo>();
        this.mPhysicalChannelConfigs = new ArrayList();
        this.mEmergencyNumberList = new HashMap<Integer, List<EmergencyNumber>>();
        for (i = 0; i < numPhones; ++i) {
            this.mCallState[i] = 0;
            this.mDataActivity[i] = 0;
            this.mDataConnectionState[i] = -1;
            this.mVoiceActivationState[i] = 0;
            this.mDataActivationState[i] = 0;
            this.mCallIncomingNumber[i] = "";
            this.mServiceState[i] = new ServiceState();
            this.mSignalStrength[i] = new SignalStrength();
            this.mUserMobileDataState[i] = false;
            this.mMessageWaiting[i] = false;
            this.mCallForwarding[i] = false;
            this.mCellLocation[i] = new Bundle();
            this.mCellInfo.add(i, null);
            this.mImsReasonInfo.add(i, null);
            this.mSrvccState[i] = -1;
            this.mPhysicalChannelConfigs.add(i, new ArrayList());
            this.mOtaspMode[i] = 1;
            this.mCallDisconnectCause[i] = -1;
            this.mCallPreciseDisconnectCause[i] = -1;
            this.mCallQuality[i] = new CallQuality();
            this.mCallAttributes[i] = new CallAttributes(new PreciseCallState(), 0, new CallQuality());
            this.mCallNetworkType[i] = 0;
            this.mPreciseCallState[i] = new PreciseCallState();
            this.mRingingCallState[i] = 0;
            this.mForegroundCallState[i] = 0;
            this.mBackgroundCallState[i] = 0;
            this.mPreciseDataConnectionState[i] = new PreciseDataConnectionState();
        }
        if (location != null) {
            for (i = 0; i < numPhones; ++i) {
                location.fillInNotifierBundle(this.mCellLocation[i]);
            }
        }
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
    }

    public void systemRunning() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_SWITCHED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED");
        TelephonyRegistry.log("systemRunning register for intents");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnSubscriptionsChangedListener(String callingPackage, IOnSubscriptionsChangedListener callback) {
        int callerUserId = UserHandle.getCallingUserId();
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            IBinder b = callback.asBinder();
            Record r = this.add(b);
            if (r == null) {
                return;
            }
            r.context = this.mContext;
            r.onSubscriptionsChangedListenerCallback = callback;
            r.callingPackage = callingPackage;
            r.callerUid = Binder.getCallingUid();
            r.callerPid = Binder.getCallingPid();
            r.events = 0;
            if (this.mHasNotifySubscriptionInfoChangedOccurred) {
                try {
                    r.onSubscriptionsChangedListenerCallback.onSubscriptionsChanged();
                }
                catch (RemoteException e) {
                    this.remove(r.binder);
                }
            } else {
                TelephonyRegistry.log("listen oscl: mHasNotifySubscriptionInfoChangedOccurred==false no callback");
            }
        }
    }

    @Override
    public void removeOnSubscriptionsChangedListener(String pkgForDebug, IOnSubscriptionsChangedListener callback) {
        this.remove(callback.asBinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnOpportunisticSubscriptionsChangedListener(String callingPackage, IOnSubscriptionsChangedListener callback) {
        int callerUserId = UserHandle.getCallingUserId();
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            IBinder b = callback.asBinder();
            Record r = this.add(b);
            if (r == null) {
                return;
            }
            r.context = this.mContext;
            r.onOpportunisticSubscriptionsChangedListenerCallback = callback;
            r.callingPackage = callingPackage;
            r.callerUid = Binder.getCallingUid();
            r.callerPid = Binder.getCallingPid();
            r.events = 0;
            if (this.mHasNotifyOpportunisticSubscriptionInfoChangedOccurred) {
                try {
                    r.onOpportunisticSubscriptionsChangedListenerCallback.onSubscriptionsChanged();
                }
                catch (RemoteException e) {
                    this.remove(r.binder);
                }
            } else {
                TelephonyRegistry.log("listen ooscl: hasNotifyOpptSubInfoChangedOccurred==false no callback");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySubscriptionInfoChanged() {
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (!this.mHasNotifySubscriptionInfoChangedOccurred) {
                TelephonyRegistry.log("notifySubscriptionInfoChanged: first invocation mRecords.size=" + this.mRecords.size());
            }
            this.mHasNotifySubscriptionInfoChangedOccurred = true;
            this.mRemoveList.clear();
            for (Record r : this.mRecords) {
                if (!r.matchOnSubscriptionsChangedListener()) continue;
                try {
                    r.onSubscriptionsChangedListenerCallback.onSubscriptionsChanged();
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOpportunisticSubscriptionInfoChanged() {
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (!this.mHasNotifyOpportunisticSubscriptionInfoChangedOccurred) {
                TelephonyRegistry.log("notifyOpptSubscriptionInfoChanged: first invocation mRecords.size=" + this.mRecords.size());
            }
            this.mHasNotifyOpportunisticSubscriptionInfoChangedOccurred = true;
            this.mRemoveList.clear();
            for (Record r : this.mRecords) {
                if (!r.matchOnOpportunisticSubscriptionsChangedListener()) continue;
                try {
                    r.onOpportunisticSubscriptionsChangedListenerCallback.onSubscriptionsChanged();
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void listen(String pkgForDebug, IPhoneStateListener callback, int events, boolean notifyNow) {
        this.listenForSubscriber(Integer.MAX_VALUE, pkgForDebug, callback, events, notifyNow);
    }

    @Override
    public void listenForSubscriber(int subId, String pkgForDebug, IPhoneStateListener callback, int events, boolean notifyNow) {
        this.listen(pkgForDebug, callback, events, notifyNow, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen(String callingPackage, IPhoneStateListener callback, int events, boolean notifyNow, int subId) {
        int callerUserId = UserHandle.getCallingUserId();
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        String str = "listen: E pkg=" + callingPackage + " events=0x" + Integer.toHexString(events) + " notifyNow=" + notifyNow + " subId=" + subId + " myUserId=" + UserHandle.myUserId() + " callerUserId=" + callerUserId;
        this.mListenLog.log(str);
        if (events != 0) {
            if (!this.checkListenerPermission(events, subId, callingPackage, "listen")) {
                return;
            }
            int phoneId = SubscriptionManager.getPhoneId(subId);
            ArrayList<Record> arrayList = this.mRecords;
            synchronized (arrayList) {
                IBinder b = callback.asBinder();
                Record r = this.add(b);
                if (r == null) {
                    return;
                }
                r.context = this.mContext;
                r.callback = callback;
                r.callingPackage = callingPackage;
                r.callerUid = Binder.getCallingUid();
                r.callerPid = Binder.getCallingPid();
                r.subId = !SubscriptionManager.isValidSubscriptionId(subId) ? Integer.MAX_VALUE : subId;
                r.phoneId = phoneId;
                r.events = events;
                if (notifyNow && this.validatePhoneId(phoneId)) {
                    if ((events & 1) != 0) {
                        try {
                            ServiceState rawSs = new ServiceState(this.mServiceState[phoneId]);
                            if (this.checkFineLocationAccess(r, 29)) {
                                r.callback.onServiceStateChanged(rawSs);
                            } else if (this.checkCoarseLocationAccess(r, 29)) {
                                r.callback.onServiceStateChanged(rawSs.sanitizeLocationInfo(false));
                            } else {
                                r.callback.onServiceStateChanged(rawSs.sanitizeLocationInfo(true));
                            }
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 2) != 0) {
                        try {
                            int gsmSignalStrength = this.mSignalStrength[phoneId].getGsmSignalStrength();
                            r.callback.onSignalStrengthChanged(gsmSignalStrength == 99 ? -1 : gsmSignalStrength);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 4) != 0) {
                        try {
                            r.callback.onMessageWaitingIndicatorChanged(this.mMessageWaiting[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 8) != 0) {
                        try {
                            r.callback.onCallForwardingIndicatorChanged(this.mCallForwarding[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if (this.validateEventsAndUserLocked(r, 16)) {
                        try {
                            if (this.checkFineLocationAccess(r, 29)) {
                                r.callback.onCellLocationChanged(new Bundle(this.mCellLocation[phoneId]));
                            }
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x20) != 0) {
                        try {
                            r.callback.onCallStateChanged(this.mCallState[phoneId], this.getCallIncomingNumber(r, phoneId));
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x40) != 0) {
                        try {
                            r.callback.onDataConnectionStateChanged(this.mDataConnectionState[phoneId], this.mDataConnectionNetworkType[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x80) != 0) {
                        try {
                            r.callback.onDataActivity(this.mDataActivity[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x100) != 0) {
                        try {
                            r.callback.onSignalStrengthsChanged(this.mSignalStrength[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x200) != 0) {
                        try {
                            r.callback.onOtaspChanged(this.mOtaspMode[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if (this.validateEventsAndUserLocked(r, 1024)) {
                        try {
                            if (this.checkFineLocationAccess(r, 29)) {
                                r.callback.onCellInfoChanged(this.mCellInfo.get(phoneId));
                            }
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x800) != 0) {
                        try {
                            r.callback.onPreciseCallStateChanged(this.mPreciseCallState[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x2000000) != 0) {
                        try {
                            r.callback.onCallDisconnectCauseChanged(this.mCallDisconnectCause[phoneId], this.mCallPreciseDisconnectCause[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x8000000) != 0) {
                        try {
                            r.callback.onImsCallDisconnectCauseChanged(this.mImsReasonInfo.get(phoneId));
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x1000) != 0) {
                        try {
                            r.callback.onPreciseDataConnectionStateChanged(this.mPreciseDataConnectionState[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x10000) != 0) {
                        try {
                            r.callback.onCarrierNetworkChange(this.mCarrierNetworkChangeState);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x20000) != 0) {
                        try {
                            r.callback.onVoiceActivationStateChanged(this.mVoiceActivationState[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x40000) != 0) {
                        try {
                            r.callback.onDataActivationStateChanged(this.mDataActivationState[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x80000) != 0) {
                        try {
                            r.callback.onUserMobileDataStateChanged(this.mUserMobileDataState[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x100000) != 0) {
                        try {
                            r.callback.onPhysicalChannelConfigurationChanged(this.mPhysicalChannelConfigs.get(phoneId));
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x1000000) != 0) {
                        try {
                            r.callback.onEmergencyNumberListChanged(this.mEmergencyNumberList);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x200000) != 0) {
                        try {
                            r.callback.onPhoneCapabilityChanged(this.mPhoneCapability);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x400000) != 0 && TelephonyPermissions.checkReadPhoneStateOnAnyActiveSub(r.context, r.callerPid, r.callerUid, r.callingPackage, "listen_active_data_subid_change")) {
                        try {
                            r.callback.onActiveDataSubIdChanged(this.mActiveDataSubId);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x800000) != 0) {
                        try {
                            r.callback.onRadioPowerStateChanged(this.mRadioPowerState);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x4000) != 0) {
                        try {
                            r.callback.onSrvccStateChanged(this.mSrvccState[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x4000000) != 0) {
                        try {
                            r.callback.onCallAttributesChanged(this.mCallAttributes[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                }
            }
        }
        this.remove(callback.asBinder());
    }

    private String getCallIncomingNumber(Record record, int phoneId) {
        return record.canReadCallLog() ? this.mCallIncomingNumber[phoneId] : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Record add(IBinder binder) {
        Record r;
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int N = this.mRecords.size();
            for (int i = 0; i < N; ++i) {
                r = this.mRecords.get(i);
                if (binder != r.binder) continue;
                return r;
            }
            r = new Record();
            r.binder = binder;
            r.deathRecipient = new TelephonyRegistryDeathRecipient(binder);
            try {
                binder.linkToDeath(r.deathRecipient, 0);
            }
            catch (RemoteException e) {
                return null;
            }
            this.mRecords.add(r);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(IBinder binder) {
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int recordCount = this.mRecords.size();
            for (int i = 0; i < recordCount; ++i) {
                Record r = this.mRecords.get(i);
                if (r.binder != binder) continue;
                if (r.deathRecipient != null) {
                    try {
                        binder.unlinkToDeath(r.deathRecipient, 0);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
                this.mRecords.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCallState(int state, String phoneNumber) {
        if (!this.checkNotifyPermission("notifyCallState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(32) || r.subId != Integer.MAX_VALUE) continue;
                try {
                    String phoneNumberOrEmpty = r.canReadCallLog() ? phoneNumber : "";
                    r.callback.onCallStateChanged(state, phoneNumberOrEmpty);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastCallStateChanged(state, phoneNumber, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCallStateForPhoneId(int phoneId, int subId, int state, String incomingNumber) {
        if (!this.checkNotifyPermission("notifyCallState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mCallState[phoneId] = state;
                this.mCallIncomingNumber[phoneId] = incomingNumber;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(32) || r.subId != subId || r.subId == Integer.MAX_VALUE) continue;
                    try {
                        String incomingNumberOrEmpty = this.getCallIncomingNumber(r, phoneId);
                        r.callback.onCallStateChanged(state, incomingNumberOrEmpty);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastCallStateChanged(state, incomingNumber, phoneId, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyServiceStateForPhoneId(int phoneId, int subId, ServiceState state) {
        if (!this.checkNotifyPermission("notifyServiceState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            String str = "notifyServiceStateForSubscriber: subId=" + subId + " phoneId=" + phoneId + " state=" + state;
            this.mLocalLog.log(str);
            if (this.validatePhoneId(phoneId)) {
                this.mServiceState[phoneId] = state;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(1) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        ServiceState stateToSend = this.checkFineLocationAccess(r, 29) ? new ServiceState(state) : (this.checkCoarseLocationAccess(r, 29) ? state.sanitizeLocationInfo(false) : state.sanitizeLocationInfo(true));
                        r.callback.onServiceStateChanged(stateToSend);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            } else {
                TelephonyRegistry.log("notifyServiceStateForSubscriber: INVALID phoneId=" + phoneId);
            }
            this.handleRemoveListLocked();
        }
        this.broadcastServiceStateChanged(state, phoneId, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySimActivationStateChangedForPhoneId(int phoneId, int subId, int activationType, int activationState) {
        if (!this.checkNotifyPermission("notifySimActivationState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                switch (activationType) {
                    case 0: {
                        this.mVoiceActivationState[phoneId] = activationState;
                        break;
                    }
                    case 1: {
                        this.mDataActivationState[phoneId] = activationState;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                for (Record r : this.mRecords) {
                    try {
                        if (activationType == 0 && r.matchPhoneStateListenerEvent(131072) && this.idMatch(r.subId, subId, phoneId)) {
                            r.callback.onVoiceActivationStateChanged(activationState);
                        }
                        if (activationType != 1 || !r.matchPhoneStateListenerEvent(262144) || !this.idMatch(r.subId, subId, phoneId)) continue;
                        r.callback.onDataActivationStateChanged(activationState);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            } else {
                TelephonyRegistry.log("notifySimActivationStateForPhoneId: INVALID phoneId=" + phoneId);
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySignalStrengthForPhoneId(int phoneId, int subId, SignalStrength signalStrength) {
        if (!this.checkNotifyPermission("notifySignalStrength()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mSignalStrength[phoneId] = signalStrength;
                for (Record r : this.mRecords) {
                    if (r.matchPhoneStateListenerEvent(256) && this.idMatch(r.subId, subId, phoneId)) {
                        try {
                            r.callback.onSignalStrengthsChanged(new SignalStrength(signalStrength));
                        }
                        catch (RemoteException ex) {
                            this.mRemoveList.add(r.binder);
                        }
                    }
                    if (!r.matchPhoneStateListenerEvent(2) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        int gsmSignalStrength = signalStrength.getGsmSignalStrength();
                        int ss = gsmSignalStrength == 99 ? -1 : gsmSignalStrength;
                        r.callback.onSignalStrengthChanged(ss);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            } else {
                TelephonyRegistry.log("notifySignalStrengthForPhoneId: invalid phoneId=" + phoneId);
            }
            this.handleRemoveListLocked();
        }
        this.broadcastSignalStrengthChanged(signalStrength, phoneId, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCarrierNetworkChange(boolean active) {
        int[] subIds = Arrays.stream(SubscriptionManager.from(this.mContext).getActiveSubscriptionIdList()).filter(i -> TelephonyPermissions.checkCarrierPrivilegeForSubId(i)).toArray();
        if (ArrayUtils.isEmpty(subIds)) {
            TelephonyRegistry.loge("notifyCarrierNetworkChange without carrier privilege");
            throw new SecurityException("notifyCarrierNetworkChange without carrier privilege");
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mCarrierNetworkChangeState = active;
            for (int subId : subIds) {
                int phoneId = SubscriptionManager.getPhoneId(subId);
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(65536) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onCarrierNetworkChange(active);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void notifyCellInfo(List<CellInfo> cellInfo) {
        this.notifyCellInfoForSubscriber(Integer.MAX_VALUE, cellInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCellInfoForSubscriber(int subId, List<CellInfo> cellInfo) {
        if (!this.checkNotifyPermission("notifyCellInfo()")) {
            return;
        }
        int phoneId = SubscriptionManager.getPhoneId(subId);
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mCellInfo.set(phoneId, cellInfo);
                for (Record r : this.mRecords) {
                    if (!this.validateEventsAndUserLocked(r, 1024) || !this.idMatch(r.subId, subId, phoneId) || !this.checkFineLocationAccess(r, 29)) continue;
                    try {
                        r.callback.onCellInfoChanged(cellInfo);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void notifyPhysicalChannelConfiguration(List<PhysicalChannelConfig> configs) {
        this.notifyPhysicalChannelConfigurationForSubscriber(Integer.MAX_VALUE, configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPhysicalChannelConfigurationForSubscriber(int subId, List<PhysicalChannelConfig> configs) {
        if (!this.checkNotifyPermission("notifyPhysicalChannelConfiguration()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int phoneId = SubscriptionManager.getPhoneId(subId);
            if (this.validatePhoneId(phoneId)) {
                this.mPhysicalChannelConfigs.set(phoneId, configs);
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(0x100000) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onPhysicalChannelConfigurationChanged(configs);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMessageWaitingChangedForPhoneId(int phoneId, int subId, boolean mwi) {
        if (!this.checkNotifyPermission("notifyMessageWaitingChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mMessageWaiting[phoneId] = mwi;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(4) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onMessageWaitingIndicatorChanged(mwi);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyUserMobileDataStateChangedForPhoneId(int phoneId, int subId, boolean state) {
        if (!this.checkNotifyPermission("notifyUserMobileDataStateChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mUserMobileDataState[phoneId] = state;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(524288) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onUserMobileDataStateChanged(state);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void notifyCallForwardingChanged(boolean cfi) {
        this.notifyCallForwardingChangedForSubscriber(Integer.MAX_VALUE, cfi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCallForwardingChangedForSubscriber(int subId, boolean cfi) {
        if (!this.checkNotifyPermission("notifyCallForwardingChanged()")) {
            return;
        }
        int phoneId = SubscriptionManager.getPhoneId(subId);
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mCallForwarding[phoneId] = cfi;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(8) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onCallForwardingIndicatorChanged(cfi);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void notifyDataActivity(int state) {
        this.notifyDataActivityForSubscriber(Integer.MAX_VALUE, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDataActivityForSubscriber(int subId, int state) {
        if (!this.checkNotifyPermission("notifyDataActivity()")) {
            return;
        }
        int phoneId = SubscriptionManager.getPhoneId(subId);
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mDataActivity[phoneId] = state;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(128) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onDataActivity(state);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void notifyDataConnection(int state, boolean isDataAllowed, String apn, String apnType, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int networkType, boolean roaming) {
        this.notifyDataConnectionForSubscriber(Integer.MAX_VALUE, Integer.MAX_VALUE, state, isDataAllowed, apn, apnType, linkProperties, networkCapabilities, networkType, roaming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDataConnectionForSubscriber(int phoneId, int subId, int state, boolean isDataAllowed, String apn, String apnType, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int networkType, boolean roaming) {
        if (!this.checkNotifyPermission("notifyDataConnection()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                if ("default".equals(apnType) && (this.mDataConnectionState[phoneId] != state || this.mDataConnectionNetworkType[phoneId] != networkType)) {
                    String str = "onDataConnectionStateChanged(" + TelephonyManager.dataStateToString(state) + ", " + TelephonyManager.getNetworkTypeName(networkType) + ") subId=" + subId + ", phoneId=" + phoneId;
                    TelephonyRegistry.log(str);
                    this.mLocalLog.log(str);
                    for (Record r : this.mRecords) {
                        if (!r.matchPhoneStateListenerEvent(64) || !this.idMatch(r.subId, subId, phoneId)) continue;
                        try {
                            r.callback.onDataConnectionStateChanged(state, networkType);
                        }
                        catch (RemoteException ex) {
                            this.mRemoveList.add(r.binder);
                        }
                    }
                    this.handleRemoveListLocked();
                    this.mDataConnectionState[phoneId] = state;
                    this.mDataConnectionNetworkType[phoneId] = networkType;
                }
                this.mPreciseDataConnectionState[phoneId] = new PreciseDataConnectionState(state, networkType, ApnSetting.getApnTypesBitmaskFromString(apnType), apn, linkProperties, 0);
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(4096) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onPreciseDataConnectionStateChanged(this.mPreciseDataConnectionState[phoneId]);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastDataConnectionStateChanged(state, isDataAllowed, apn, apnType, linkProperties, networkCapabilities, roaming, subId);
        this.broadcastPreciseDataConnectionStateChanged(state, networkType, apnType, apn, linkProperties, 0);
    }

    @Override
    public void notifyDataConnectionFailed(String apnType) {
        this.notifyDataConnectionFailedForSubscriber(Integer.MAX_VALUE, Integer.MAX_VALUE, apnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDataConnectionFailedForSubscriber(int phoneId, int subId, String apnType) {
        if (!this.checkNotifyPermission("notifyDataConnectionFailed()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mPreciseDataConnectionState[phoneId] = new PreciseDataConnectionState(-1, 0, ApnSetting.getApnTypesBitmaskFromString(apnType), null, null, 0);
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(4096) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onPreciseDataConnectionStateChanged(this.mPreciseDataConnectionState[phoneId]);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastDataConnectionFailed(apnType, subId);
        this.broadcastPreciseDataConnectionStateChanged(-1, 0, apnType, null, null, 0);
    }

    @Override
    public void notifyCellLocation(Bundle cellLocation) {
        this.notifyCellLocationForSubscriber(Integer.MAX_VALUE, cellLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCellLocationForSubscriber(int subId, Bundle cellLocation) {
        TelephonyRegistry.log("notifyCellLocationForSubscriber: subId=" + subId + " cellLocation=" + cellLocation);
        if (!this.checkNotifyPermission("notifyCellLocation()")) {
            return;
        }
        int phoneId = SubscriptionManager.getPhoneId(subId);
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mCellLocation[phoneId] = cellLocation;
                for (Record r : this.mRecords) {
                    if (!this.validateEventsAndUserLocked(r, 16) || !this.idMatch(r.subId, subId, phoneId) || !this.checkFineLocationAccess(r, 29)) continue;
                    try {
                        r.callback.onCellLocationChanged(new Bundle(cellLocation));
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOtaspChanged(int subId, int otaspMode) {
        if (!this.checkNotifyPermission("notifyOtaspChanged()")) {
            return;
        }
        int phoneId = SubscriptionManager.getPhoneId(subId);
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mOtaspMode[phoneId] = otaspMode;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(512) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onOtaspChanged(otaspMode);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPreciseCallState(int phoneId, int subId, int ringingCallState, int foregroundCallState, int backgroundCallState) {
        if (!this.checkNotifyPermission("notifyPreciseCallState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mRingingCallState[phoneId] = ringingCallState;
                this.mForegroundCallState[phoneId] = foregroundCallState;
                this.mBackgroundCallState[phoneId] = backgroundCallState;
                this.mPreciseCallState[phoneId] = new PreciseCallState(ringingCallState, foregroundCallState, backgroundCallState, -1, -1);
                boolean notifyCallAttributes = true;
                if (this.mCallQuality == null) {
                    TelephonyRegistry.log("notifyPreciseCallState: mCallQuality is null, skipping call attributes");
                    notifyCallAttributes = false;
                } else {
                    if (this.mPreciseCallState[phoneId].getForegroundCallState() != 1) {
                        this.mCallNetworkType[phoneId] = 0;
                        this.mCallQuality[phoneId] = new CallQuality();
                    }
                    this.mCallAttributes[phoneId] = new CallAttributes(this.mPreciseCallState[phoneId], this.mCallNetworkType[phoneId], this.mCallQuality[phoneId]);
                }
                for (Record r : this.mRecords) {
                    if (r.matchPhoneStateListenerEvent(2048) && this.idMatch(r.subId, subId, phoneId)) {
                        try {
                            r.callback.onPreciseCallStateChanged(this.mPreciseCallState[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.mRemoveList.add(r.binder);
                        }
                    }
                    if (!notifyCallAttributes || !r.matchPhoneStateListenerEvent(0x4000000) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onCallAttributesChanged(this.mCallAttributes[phoneId]);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastPreciseCallStateChanged(ringingCallState, foregroundCallState, backgroundCallState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDisconnectCause(int phoneId, int subId, int disconnectCause, int preciseDisconnectCause) {
        if (!this.checkNotifyPermission("notifyDisconnectCause()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mCallDisconnectCause[phoneId] = disconnectCause;
                this.mCallPreciseDisconnectCause[phoneId] = preciseDisconnectCause;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(0x2000000) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onCallDisconnectCauseChanged(this.mCallDisconnectCause[phoneId], this.mCallPreciseDisconnectCause[phoneId]);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyImsDisconnectCause(int subId, ImsReasonInfo imsReasonInfo) {
        if (!this.checkNotifyPermission("notifyImsCallDisconnectCause()")) {
            return;
        }
        int phoneId = SubscriptionManager.getPhoneId(subId);
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mImsReasonInfo.set(phoneId, imsReasonInfo);
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(0x8000000) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onImsCallDisconnectCauseChanged(this.mImsReasonInfo.get(phoneId));
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPreciseDataConnectionFailed(int phoneId, int subId, String apnType, String apn, int failCause) {
        if (!this.checkNotifyPermission("notifyPreciseDataConnectionFailed()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mPreciseDataConnectionState[phoneId] = new PreciseDataConnectionState(-1, 0, ApnSetting.getApnTypesBitmaskFromString(apnType), apn, null, failCause);
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(4096) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onPreciseDataConnectionStateChanged(this.mPreciseDataConnectionState[phoneId]);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastPreciseDataConnectionStateChanged(-1, 0, apnType, apn, null, failCause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySrvccStateChanged(int subId, int state) {
        if (!this.checkNotifyPermission("notifySrvccStateChanged()")) {
            return;
        }
        int phoneId = SubscriptionManager.getPhoneId(subId);
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mSrvccState[phoneId] = state;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(16384) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onSrvccStateChanged(state);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOemHookRawEventForSubscriber(int phoneId, int subId, byte[] rawData) {
        if (!this.checkNotifyPermission("notifyOemHookRawEventForSubscriber")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(32768) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onOemHookRawEvent(rawData);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPhoneCapabilityChanged(PhoneCapability capability) {
        if (!this.checkNotifyPermission("notifyPhoneCapabilityChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mPhoneCapability = capability;
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(0x200000)) continue;
                try {
                    r.callback.onPhoneCapabilityChanged(capability);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActiveDataSubIdChanged(int activeDataSubId) {
        List<Record> copiedRecords;
        if (!this.checkNotifyPermission("notifyActiveDataSubIdChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            copiedRecords = new ArrayList<Record>(this.mRecords);
        }
        this.mActiveDataSubId = activeDataSubId;
        copiedRecords = copiedRecords.stream().filter(r -> r.matchPhoneStateListenerEvent(0x400000) && TelephonyPermissions.checkReadPhoneStateOnAnyActiveSub(this.mContext, r.callerPid, r.callerUid, r.callingPackage, "notifyActiveDataSubIdChanged")).collect(Collectors.toCollection(ArrayList::new));
        arrayList = this.mRecords;
        synchronized (arrayList) {
            for (Record r2 : copiedRecords) {
                if (!this.mRecords.contains(r2)) continue;
                try {
                    r2.callback.onActiveDataSubIdChanged(activeDataSubId);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r2.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRadioPowerStateChanged(int phoneId, int subId, int state) {
        if (!this.checkNotifyPermission("notifyRadioPowerStateChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mRadioPowerState = state;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(0x800000) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onRadioPowerStateChanged(state);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEmergencyNumberList(int phoneId, int subId) {
        if (!this.checkNotifyPermission("notifyEmergencyNumberList()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
                this.mEmergencyNumberList = tm.getEmergencyNumberList();
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(0x1000000) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onEmergencyNumberListChanged(this.mEmergencyNumberList);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCallQualityChanged(CallQuality callQuality, int phoneId, int subId, int callNetworkType) {
        if (!this.checkNotifyPermission("notifyCallQualityChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mCallQuality[phoneId] = callQuality;
                this.mCallNetworkType[phoneId] = callNetworkType;
                this.mCallAttributes[phoneId] = new CallAttributes(this.mPreciseCallState[phoneId], callNetworkType, callQuality);
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(0x4000000) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onCallAttributesChanged(this.mCallAttributes[phoneId]);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int recordCount = this.mRecords.size();
            pw.println("last known state:");
            pw.increaseIndent();
            for (int i = 0; i < TelephonyManager.getDefault().getPhoneCount(); ++i) {
                pw.println("Phone Id=" + i);
                pw.increaseIndent();
                pw.println("mCallState=" + this.mCallState[i]);
                pw.println("mRingingCallState=" + this.mRingingCallState[i]);
                pw.println("mForegroundCallState=" + this.mForegroundCallState[i]);
                pw.println("mBackgroundCallState=" + this.mBackgroundCallState[i]);
                pw.println("mPreciseCallState=" + this.mPreciseCallState[i]);
                pw.println("mCallDisconnectCause=" + this.mCallDisconnectCause[i]);
                pw.println("mCallIncomingNumber=" + this.mCallIncomingNumber[i]);
                pw.println("mServiceState=" + this.mServiceState[i]);
                pw.println("mVoiceActivationState= " + this.mVoiceActivationState[i]);
                pw.println("mDataActivationState= " + this.mDataActivationState[i]);
                pw.println("mUserMobileDataState= " + this.mUserMobileDataState[i]);
                pw.println("mSignalStrength=" + this.mSignalStrength[i]);
                pw.println("mMessageWaiting=" + this.mMessageWaiting[i]);
                pw.println("mCallForwarding=" + this.mCallForwarding[i]);
                pw.println("mDataActivity=" + this.mDataActivity[i]);
                pw.println("mDataConnectionState=" + this.mDataConnectionState[i]);
                pw.println("mCellLocation=" + this.mCellLocation[i]);
                pw.println("mCellInfo=" + this.mCellInfo.get(i));
                pw.println("mImsCallDisconnectCause=" + this.mImsReasonInfo.get(i));
                pw.println("mSrvccState=" + this.mSrvccState[i]);
                pw.println("mOtaspMode=" + this.mOtaspMode[i]);
                pw.println("mCallPreciseDisconnectCause=" + this.mCallPreciseDisconnectCause[i]);
                pw.println("mCallQuality=" + this.mCallQuality[i]);
                pw.println("mCallAttributes=" + this.mCallAttributes[i]);
                pw.println("mCallNetworkType=" + this.mCallNetworkType[i]);
                pw.println("mPreciseDataConnectionState=" + this.mPreciseDataConnectionState[i]);
                pw.decreaseIndent();
            }
            pw.println("mCarrierNetworkChangeState=" + this.mCarrierNetworkChangeState);
            pw.println("mPhoneCapability=" + this.mPhoneCapability);
            pw.println("mActiveDataSubId=" + this.mActiveDataSubId);
            pw.println("mRadioPowerState=" + this.mRadioPowerState);
            pw.println("mEmergencyNumberList=" + this.mEmergencyNumberList);
            pw.println("mDefaultPhoneId=" + this.mDefaultPhoneId);
            pw.println("mDefaultSubId=" + this.mDefaultSubId);
            pw.decreaseIndent();
            pw.println("local logs:");
            pw.increaseIndent();
            this.mLocalLog.dump(fd, pw, args);
            pw.println("listen logs:");
            this.mListenLog.dump(fd, pw, args);
            pw.decreaseIndent();
            pw.println("registrations: count=" + recordCount);
            pw.increaseIndent();
            for (Record r : this.mRecords) {
                pw.println(r);
            }
            pw.decreaseIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastServiceStateChanged(ServiceState state, int phoneId, int subId) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mBatteryStats.notePhoneState(state.getState());
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        Intent intent = new Intent("android.intent.action.SERVICE_STATE");
        intent.addFlags(0x1000000);
        Bundle data = new Bundle();
        state.fillInNotifierBundle(data);
        intent.putExtras(data);
        intent.putExtra("subscription", subId);
        intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
        intent.putExtra("slot", phoneId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastSignalStrengthChanged(SignalStrength signalStrength, int phoneId, int subId) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mBatteryStats.notePhoneSignalStrength(signalStrength);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        Intent intent = new Intent("android.intent.action.SIG_STR");
        Bundle data = new Bundle();
        signalStrength.fillInNotifierBundle(data);
        intent.putExtras(data);
        intent.putExtra("subscription", subId);
        intent.putExtra("slot", phoneId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastCallStateChanged(int state, String incomingNumber, int phoneId, int subId) {
        long ident = Binder.clearCallingIdentity();
        try {
            if (state == 0) {
                this.mBatteryStats.notePhoneOff();
                StatsLog.write(95, 0);
            } else {
                this.mBatteryStats.notePhoneOn();
                StatsLog.write(95, 1);
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        Intent intent = new Intent("android.intent.action.PHONE_STATE");
        intent.putExtra("state", PhoneConstantConversions.convertCallState(state).toString());
        if (subId != -1) {
            intent.setAction("android.intent.action.SUBSCRIPTION_PHONE_STATE");
            intent.putExtra("subscription", subId);
            intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
        }
        if (phoneId != -1) {
            intent.putExtra("slot", phoneId);
        }
        intent.addFlags(0x1000000);
        Intent intentWithPhoneNumber = new Intent(intent);
        intentWithPhoneNumber.putExtra("incoming_number", incomingNumber);
        this.mContext.sendBroadcastAsUser(intentWithPhoneNumber, UserHandle.ALL, "android.permission.READ_PRIVILEGED_PHONE_STATE");
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.READ_PHONE_STATE", 51);
        this.mContext.sendBroadcastAsUserMultiplePermissions(intentWithPhoneNumber, UserHandle.ALL, new String[]{"android.permission.READ_PHONE_STATE", "android.permission.READ_CALL_LOG"});
    }

    private void broadcastDataConnectionStateChanged(int state, boolean isDataAllowed, String apn, String apnType, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, boolean roaming, int subId) {
        Intent intent = new Intent("android.intent.action.ANY_DATA_STATE");
        intent.putExtra("state", PhoneConstantConversions.convertDataState(state).toString());
        if (!isDataAllowed) {
            intent.putExtra("networkUnvailable", true);
        }
        if (linkProperties != null) {
            intent.putExtra("linkProperties", linkProperties);
            String iface = linkProperties.getInterfaceName();
            if (iface != null) {
                intent.putExtra("iface", iface);
            }
        }
        if (networkCapabilities != null) {
            intent.putExtra("networkCapabilities", networkCapabilities);
        }
        if (roaming) {
            intent.putExtra("networkRoaming", true);
        }
        intent.putExtra("apn", apn);
        intent.putExtra("apnType", apnType);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void broadcastDataConnectionFailed(String apnType, int subId) {
        Intent intent = new Intent("android.intent.action.DATA_CONNECTION_FAILED");
        intent.putExtra("apnType", apnType);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void broadcastPreciseCallStateChanged(int ringingCallState, int foregroundCallState, int backgroundCallState) {
        Intent intent = new Intent("android.intent.action.PRECISE_CALL_STATE");
        intent.putExtra("ringing_state", ringingCallState);
        intent.putExtra("foreground_state", foregroundCallState);
        intent.putExtra("background_state", backgroundCallState);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.READ_PRECISE_PHONE_STATE");
    }

    private void broadcastPreciseDataConnectionStateChanged(int state, int networkType, String apnType, String apn, LinkProperties linkProperties, int failCause) {
        Intent intent = new Intent("android.intent.action.PRECISE_DATA_CONNECTION_STATE_CHANGED");
        intent.putExtra("state", state);
        intent.putExtra("networkType", networkType);
        if (apnType != null) {
            intent.putExtra("apnType", apnType);
        }
        if (apn != null) {
            intent.putExtra("apn", apn);
        }
        if (linkProperties != null) {
            intent.putExtra("linkProperties", linkProperties);
        }
        intent.putExtra("failCause", failCause);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.READ_PRECISE_PHONE_STATE");
    }

    private void enforceNotifyPermissionOrCarrierPrivilege(String method) {
        if (this.checkNotifyPermission()) {
            return;
        }
        TelephonyPermissions.enforceCallingOrSelfCarrierPrivilege(SubscriptionManager.getDefaultSubscriptionId(), method);
    }

    private boolean checkNotifyPermission(String method) {
        if (this.checkNotifyPermission()) {
            return true;
        }
        String msg = "Modify Phone State Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        return false;
    }

    private boolean checkNotifyPermission() {
        return this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") == 0;
    }

    private boolean checkListenerPermission(int events, int subId, String callingPackage, String message) {
        LocationAccessPolicy.LocationPermissionQuery.Builder locationQueryBuilder = new LocationAccessPolicy.LocationPermissionQuery.Builder().setCallingPackage(callingPackage).setMethod(message + " events: " + events).setCallingPid(Binder.getCallingPid()).setCallingUid(Binder.getCallingUid());
        boolean shouldCheckLocationPermissions = false;
        if ((events & 0) != 0) {
            locationQueryBuilder.setMinSdkVersionForCoarse(0);
            shouldCheckLocationPermissions = true;
        }
        if ((events & 0x410) != 0) {
            locationQueryBuilder.setMinSdkVersionForFine(29);
            shouldCheckLocationPermissions = true;
        }
        if (shouldCheckLocationPermissions) {
            LocationAccessPolicy.LocationPermissionResult result = LocationAccessPolicy.checkLocationPermission(this.mContext, locationQueryBuilder.build());
            switch (result) {
                case DENIED_HARD: {
                    throw new SecurityException("Unable to listen for events " + events + " due to insufficient location permissions.");
                }
                case DENIED_SOFT: {
                    return false;
                }
            }
        }
        if ((events & 0x100000C) != 0 && !TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, subId, callingPackage, message)) {
            return false;
        }
        if ((events & 0x1800) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRECISE_PHONE_STATE", null);
        }
        if ((events & 0x8000) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", null);
        }
        if ((events & 0x4000) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", null);
        }
        if ((events & 0x2000000) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRECISE_PHONE_STATE", null);
        }
        if ((events & 0x4000000) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRECISE_PHONE_STATE", null);
        }
        if ((events & 0x800000) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", null);
        }
        if ((events & 0x20000) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", null);
        }
        if ((events & 0x8000000) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRECISE_PHONE_STATE", null);
        }
        return true;
    }

    private void handleRemoveListLocked() {
        int size = this.mRemoveList.size();
        if (size > 0) {
            for (IBinder b : this.mRemoveList) {
                this.remove(b);
            }
            this.mRemoveList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateEventsAndUserLocked(Record r, int events) {
        long callingIdentity = Binder.clearCallingIdentity();
        boolean valid = false;
        try {
            int foregroundUser = ActivityManager.getCurrentUser();
            valid = UserHandle.getUserId(r.callerUid) == foregroundUser && r.matchPhoneStateListenerEvent(events);
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return valid;
    }

    private boolean validatePhoneId(int phoneId) {
        boolean valid = phoneId >= 0 && phoneId < this.mNumPhones;
        return valid;
    }

    private static void log(String s) {
        Rlog.d(TAG, s);
    }

    private static void loge(String s) {
        Rlog.e(TAG, s);
    }

    boolean idMatch(int rSubId, int subId, int phoneId) {
        if (subId < 0) {
            return this.mDefaultPhoneId == phoneId;
        }
        if (rSubId == Integer.MAX_VALUE) {
            return subId == this.mDefaultSubId;
        }
        return rSubId == subId;
    }

    private boolean checkFineLocationAccess(Record r, int minSdk) {
        LocationAccessPolicy.LocationPermissionQuery query = new LocationAccessPolicy.LocationPermissionQuery.Builder().setCallingPackage(r.callingPackage).setCallingPid(r.callerPid).setCallingUid(r.callerUid).setMethod("TelephonyRegistry push").setLogAsInfo(true).setMinSdkVersionForFine(minSdk).build();
        return Binder.withCleanCallingIdentity(() -> {
            LocationAccessPolicy.LocationPermissionResult locationResult = LocationAccessPolicy.checkLocationPermission(this.mContext, query);
            return locationResult == LocationAccessPolicy.LocationPermissionResult.ALLOWED;
        });
    }

    private boolean checkCoarseLocationAccess(Record r, int minSdk) {
        LocationAccessPolicy.LocationPermissionQuery query = new LocationAccessPolicy.LocationPermissionQuery.Builder().setCallingPackage(r.callingPackage).setCallingPid(r.callerPid).setCallingUid(r.callerUid).setMethod("TelephonyRegistry push").setLogAsInfo(true).setMinSdkVersionForCoarse(minSdk).build();
        return Binder.withCleanCallingIdentity(() -> {
            LocationAccessPolicy.LocationPermissionResult locationResult = LocationAccessPolicy.checkLocationPermission(this.mContext, query);
            return locationResult == LocationAccessPolicy.LocationPermissionResult.ALLOWED;
        });
    }

    private void checkPossibleMissNotify(Record r, int phoneId) {
        int events = r.events;
        if ((events & 1) != 0) {
            try {
                r.callback.onServiceStateChanged(new ServiceState(this.mServiceState[phoneId]));
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 0x100) != 0) {
            try {
                SignalStrength signalStrength = this.mSignalStrength[phoneId];
                r.callback.onSignalStrengthsChanged(new SignalStrength(signalStrength));
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 2) != 0) {
            try {
                int gsmSignalStrength = this.mSignalStrength[phoneId].getGsmSignalStrength();
                r.callback.onSignalStrengthChanged(gsmSignalStrength == 99 ? -1 : gsmSignalStrength);
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if (this.validateEventsAndUserLocked(r, 1024)) {
            try {
                if (this.checkFineLocationAccess(r, 29)) {
                    r.callback.onCellInfoChanged(this.mCellInfo.get(phoneId));
                }
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 0x80000) != 0) {
            try {
                r.callback.onUserMobileDataStateChanged(this.mUserMobileDataState[phoneId]);
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 4) != 0) {
            try {
                r.callback.onMessageWaitingIndicatorChanged(this.mMessageWaiting[phoneId]);
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 8) != 0) {
            try {
                r.callback.onCallForwardingIndicatorChanged(this.mCallForwarding[phoneId]);
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if (this.validateEventsAndUserLocked(r, 16)) {
            try {
                if (this.checkFineLocationAccess(r, 29)) {
                    r.callback.onCellLocationChanged(new Bundle(this.mCellLocation[phoneId]));
                }
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 0x40) != 0) {
            try {
                r.callback.onDataConnectionStateChanged(this.mDataConnectionState[phoneId], this.mDataConnectionNetworkType[phoneId]);
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
    }

    private class TelephonyRegistryDeathRecipient
    implements IBinder.DeathRecipient {
        private final IBinder binder;

        TelephonyRegistryDeathRecipient(IBinder binder) {
            this.binder = binder;
        }

        @Override
        public void binderDied() {
            TelephonyRegistry.this.remove(this.binder);
        }
    }

    private static class Record {
        Context context;
        String callingPackage;
        IBinder binder;
        TelephonyRegistryDeathRecipient deathRecipient;
        IPhoneStateListener callback;
        IOnSubscriptionsChangedListener onSubscriptionsChangedListenerCallback;
        IOnSubscriptionsChangedListener onOpportunisticSubscriptionsChangedListenerCallback;
        int callerUid;
        int callerPid;
        int events;
        int subId = -1;
        int phoneId = -1;

        private Record() {
        }

        boolean matchPhoneStateListenerEvent(int events) {
            return this.callback != null && (events & this.events) != 0;
        }

        boolean matchOnSubscriptionsChangedListener() {
            return this.onSubscriptionsChangedListenerCallback != null;
        }

        boolean matchOnOpportunisticSubscriptionsChangedListener() {
            return this.onOpportunisticSubscriptionsChangedListenerCallback != null;
        }

        boolean canReadCallLog() {
            try {
                return TelephonyPermissions.checkReadCallLog(this.context, this.subId, this.callerPid, this.callerUid, this.callingPackage);
            }
            catch (SecurityException e) {
                return false;
            }
        }

        public String toString() {
            return "{callingPackage=" + this.callingPackage + " binder=" + this.binder + " callback=" + this.callback + " onSubscriptionsChangedListenererCallback=" + this.onSubscriptionsChangedListenerCallback + " onOpportunisticSubscriptionsChangedListenererCallback=" + this.onOpportunisticSubscriptionsChangedListenerCallback + " callerUid=" + this.callerUid + " subId=" + this.subId + " phoneId=" + this.phoneId + " events=" + Integer.toHexString(this.events) + "}";
        }
    }
}

