/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.net.INetd;
import android.net.ITestNetworkManager;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkAgent;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.RouteInfo;
import android.net.StringNetworkSpecifier;
import android.net.TestNetworkInterface;
import android.net.util.NetdService;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.io.UncheckedIOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicInteger;

class TestNetworkService
extends ITestNetworkManager.Stub {
    private static final String TAG = TestNetworkService.class.getSimpleName();
    private static final String TEST_NETWORK_TYPE = "TEST_NETWORK";
    private static final String TEST_TUN_PREFIX = "testtun";
    private static final String TEST_TAP_PREFIX = "testtap";
    private static final AtomicInteger sTestTunIndex = new AtomicInteger();
    private final Context mContext;
    private final INetworkManagementService mNMS;
    private final INetd mNetd;
    private final HandlerThread mHandlerThread;
    private final Handler mHandler;
    @GuardedBy(value={"mTestNetworkTracker"})
    private final SparseArray<TestNetworkAgent> mTestNetworkTracker = new SparseArray();
    private static final String PERMISSION_NAME = "android.permission.MANAGE_TEST_NETWORKS";

    private static native int jniCreateTunTap(boolean var0, String var1);

    @VisibleForTesting
    protected TestNetworkService(Context context, INetworkManagementService netManager) {
        this.mHandlerThread = new HandlerThread("TestNetworkServiceThread");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mContext = Preconditions.checkNotNull(context, "missing Context");
        this.mNMS = Preconditions.checkNotNull(netManager, "missing INetworkManagementService");
        this.mNetd = Preconditions.checkNotNull(NetdService.getInstance(), "could not get netd instance");
    }

    private TestNetworkInterface createInterface(boolean isTun, LinkAddress[] linkAddrs) {
        TestNetworkService.enforceTestNetworkPermissions(this.mContext);
        Preconditions.checkNotNull(linkAddrs, "missing linkAddrs");
        String ifacePrefix = isTun ? TEST_TUN_PREFIX : TEST_TAP_PREFIX;
        String iface = ifacePrefix + sTestTunIndex.getAndIncrement();
        return Binder.withCleanCallingIdentity(() -> {
            try {
                ParcelFileDescriptor tunIntf = ParcelFileDescriptor.adoptFd(TestNetworkService.jniCreateTunTap(isTun, iface));
                for (LinkAddress addr : linkAddrs) {
                    this.mNetd.interfaceAddAddress(iface, addr.getAddress().getHostAddress(), addr.getPrefixLength());
                }
                return new TestNetworkInterface(tunIntf, iface);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        });
    }

    @Override
    public TestNetworkInterface createTunInterface(LinkAddress[] linkAddrs) {
        return this.createInterface(true, linkAddrs);
    }

    @Override
    public TestNetworkInterface createTapInterface() {
        return this.createInterface(false, new LinkAddress[0]);
    }

    private TestNetworkAgent registerTestNetworkAgent(Looper looper, Context context, String iface, int callingUid, IBinder binder) throws RemoteException, SocketException {
        Preconditions.checkNotNull(looper, "missing Looper");
        Preconditions.checkNotNull(context, "missing Context");
        NetworkInfo ni = new NetworkInfo(18, 0, TEST_NETWORK_TYPE, "");
        ni.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, null);
        ni.setIsAvailable(true);
        NetworkCapabilities nc = new NetworkCapabilities();
        nc.clearAll();
        nc.addTransportType(7);
        nc.addCapability(21);
        nc.addCapability(13);
        nc.setNetworkSpecifier(new StringNetworkSpecifier(iface));
        LinkProperties lp = new LinkProperties();
        lp.setInterfaceName(iface);
        boolean allowIPv4 = false;
        boolean allowIPv6 = false;
        NetworkInterface netIntf = NetworkInterface.getByName(iface);
        Preconditions.checkNotNull(netIntf, "No such network interface found: " + netIntf);
        for (InterfaceAddress intfAddr : netIntf.getInterfaceAddresses()) {
            lp.addLinkAddress(new LinkAddress(intfAddr.getAddress(), intfAddr.getNetworkPrefixLength()));
            if (intfAddr.getAddress() instanceof Inet6Address) {
                allowIPv6 |= !intfAddr.getAddress().isLinkLocalAddress();
                continue;
            }
            if (!(intfAddr.getAddress() instanceof Inet4Address)) continue;
            allowIPv4 = true;
        }
        if (allowIPv4) {
            lp.addRoute(new RouteInfo(new IpPrefix(Inet4Address.ANY, 0), null, iface));
        }
        if (allowIPv6) {
            lp.addRoute(new RouteInfo(new IpPrefix(Inet6Address.ANY, 0), null, iface));
        }
        return new TestNetworkAgent(looper, context, ni, nc, lp, callingUid, binder);
    }

    @Override
    public void setupTestNetwork(String iface, IBinder binder) {
        TestNetworkService.enforceTestNetworkPermissions(this.mContext);
        Preconditions.checkNotNull(iface, "missing Iface");
        Preconditions.checkNotNull(binder, "missing IBinder");
        if (!iface.startsWith("ipsec") && !iface.startsWith(TEST_TUN_PREFIX)) {
            throw new IllegalArgumentException("Cannot create network for non ipsec, non-testtun interface");
        }
        int callingUid = Binder.getCallingUid();
        Binder.withCleanCallingIdentity(() -> {
            try {
                this.mNMS.setInterfaceUp(iface);
                SparseArray<TestNetworkAgent> sparseArray = this.mTestNetworkTracker;
                synchronized (sparseArray) {
                    TestNetworkAgent agent = this.registerTestNetworkAgent(this.mHandler.getLooper(), this.mContext, iface, callingUid, binder);
                    this.mTestNetworkTracker.put(agent.netId, agent);
                }
            }
            catch (SocketException e) {
                throw new UncheckedIOException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teardownTestNetwork(int netId) {
        TestNetworkAgent agent;
        TestNetworkService.enforceTestNetworkPermissions(this.mContext);
        SparseArray<TestNetworkAgent> sparseArray = this.mTestNetworkTracker;
        synchronized (sparseArray) {
            agent = this.mTestNetworkTracker.get(netId);
        }
        if (agent == null) {
            return;
        }
        if (agent.mUid != Binder.getCallingUid()) {
            throw new SecurityException("Attempted to modify other user's test networks");
        }
        agent.teardown();
    }

    public static void enforceTestNetworkPermissions(Context context) {
        context.enforceCallingOrSelfPermission(PERMISSION_NAME, "TestNetworkService");
    }

    public class TestNetworkAgent
    extends NetworkAgent
    implements IBinder.DeathRecipient {
        private static final int NETWORK_SCORE = 1;
        private final int mUid;
        private final NetworkInfo mNi;
        private final NetworkCapabilities mNc;
        private final LinkProperties mLp;
        @GuardedBy(value={"mBinderLock"})
        private IBinder mBinder;
        private final Object mBinderLock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TestNetworkAgent(Looper looper, Context context, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int uid, IBinder binder) throws RemoteException {
            super(looper, context, TestNetworkService.TEST_NETWORK_TYPE, ni, nc, lp, 1);
            this.mBinderLock = new Object();
            this.mUid = uid;
            this.mNi = ni;
            this.mNc = nc;
            this.mLp = lp;
            Object object = this.mBinderLock;
            synchronized (object) {
                this.mBinder = binder;
                try {
                    this.mBinder.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.binderDied();
                    throw e;
                }
            }
        }

        @Override
        public void binderDied() {
            this.teardown();
        }

        @Override
        protected void unwanted() {
            this.teardown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void teardown() {
            this.mNi.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
            this.mNi.setIsAvailable(false);
            this.sendNetworkInfo(this.mNi);
            Object object = this.mBinderLock;
            synchronized (object) {
                if (this.mBinder == null) {
                    return;
                }
                this.mBinder.unlinkToDeath(this, 0);
                this.mBinder = null;
            }
            object = TestNetworkService.this.mTestNetworkTracker;
            synchronized (object) {
                TestNetworkService.this.mTestNetworkTracker.remove(this.netId);
            }
        }
    }
}

