/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.os.Process;

public class ThreadPriorityBooster {
    private static final boolean ENABLE_LOCK_GUARD = false;
    private static final int PRIORITY_NOT_ADJUSTED = Integer.MAX_VALUE;
    private volatile int mBoostToPriority;
    private final int mLockGuardIndex;
    private final ThreadLocal<PriorityState> mThreadState = new ThreadLocal<PriorityState>(){

        @Override
        protected PriorityState initialValue() {
            return new PriorityState();
        }
    };

    public ThreadPriorityBooster(int boostToPriority, int lockGuardIndex) {
        this.mBoostToPriority = boostToPriority;
        this.mLockGuardIndex = lockGuardIndex;
    }

    public void boost() {
        int prevPriority;
        PriorityState state = this.mThreadState.get();
        if (state.regionCounter == 0 && (prevPriority = Process.getThreadPriority(state.tid)) > this.mBoostToPriority) {
            Process.setThreadPriority(state.tid, this.mBoostToPriority);
            state.prevPriority = prevPriority;
        }
        ++state.regionCounter;
    }

    public void reset() {
        PriorityState state = this.mThreadState.get();
        --state.regionCounter;
        if (state.regionCounter == 0 && state.prevPriority != Integer.MAX_VALUE) {
            Process.setThreadPriority(state.tid, state.prevPriority);
            state.prevPriority = Integer.MAX_VALUE;
        }
    }

    protected void setBoostToPriority(int priority) {
        int prevPriority;
        this.mBoostToPriority = priority;
        PriorityState state = this.mThreadState.get();
        if (state.regionCounter != 0 && (prevPriority = Process.getThreadPriority(state.tid)) != priority) {
            Process.setThreadPriority(state.tid, priority);
        }
    }

    private static class PriorityState {
        final int tid = Process.myTid();
        int regionCounter;
        int prevPriority = Integer.MAX_VALUE;

        private PriorityState() {
        }
    }
}

