/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.IUidObserver;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.input.InputManager;
import android.icu.text.DateFormat;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.os.Binder;
import android.os.ExternalVibration;
import android.os.Handler;
import android.os.IBinder;
import android.os.IExternalVibratorService;
import android.os.IVibratorService;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.Trace;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.WorkSource;
import android.provider.DeviceConfig;
import android.provider.Settings;
import android.util.DebugUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.StatsLog;
import android.view.InputDevice;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.util.DumpUtils;
import com.android.server.LocalServices;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;

public class VibratorService
extends IVibratorService.Stub
implements InputManager.InputDeviceListener {
    private static final String TAG = "VibratorService";
    private static final boolean DEBUG = false;
    private static final String SYSTEM_UI_PACKAGE = "com.android.systemui";
    private static final String EXTERNAL_VIBRATOR_SERVICE = "external_vibrator_service";
    private static final String RAMPING_RINGER_ENABLED = "ramping_ringer_enabled";
    private static final long[] DOUBLE_CLICK_EFFECT_FALLBACK_TIMINGS = new long[]{0L, 30L, 100L, 30L};
    private static final int SCALE_MUTE = -100;
    private static final int SCALE_VERY_LOW = -2;
    private static final int SCALE_LOW = -1;
    private static final int SCALE_NONE = 0;
    private static final int SCALE_HIGH = 1;
    private static final int SCALE_VERY_HIGH = 2;
    private static final float SCALE_VERY_LOW_GAMMA = 2.0f;
    private static final float SCALE_LOW_GAMMA = 1.5f;
    private static final float SCALE_NONE_GAMMA = 1.0f;
    private static final float SCALE_HIGH_GAMMA = 0.5f;
    private static final float SCALE_VERY_HIGH_GAMMA = 0.25f;
    private static final int SCALE_VERY_LOW_MAX_AMPLITUDE = 168;
    private static final int SCALE_LOW_MAX_AMPLITUDE = 192;
    private static final long MAX_HAPTIC_FEEDBACK_DURATION = 5000L;
    private final SparseArray<ScaleLevel> mScaleLevels;
    private final LinkedList<VibrationInfo> mPreviousRingVibrations;
    private final LinkedList<VibrationInfo> mPreviousNotificationVibrations;
    private final LinkedList<VibrationInfo> mPreviousAlarmVibrations;
    private final LinkedList<ExternalVibration> mPreviousExternalVibrations;
    private final LinkedList<VibrationInfo> mPreviousVibrations;
    private final int mPreviousVibrationsLimit;
    private final boolean mAllowPriorityVibrationsInLowPowerMode;
    private final boolean mSupportsAmplitudeControl;
    private final boolean mSupportsExternalControl;
    private final int mDefaultVibrationAmplitude;
    private final SparseArray<VibrationEffect> mFallbackEffects;
    private final SparseArray<Integer> mProcStatesCache = new SparseArray();
    private final WorkSource mTmpWorkSource = new WorkSource();
    private final Handler mH = new Handler();
    private final Object mLock = new Object();
    private final Context mContext;
    private final PowerManager.WakeLock mWakeLock;
    private final AppOpsManager mAppOps;
    private final IBatteryStats mBatteryStatsService;
    private PowerManagerInternal mPowerManagerInternal;
    private InputManager mIm;
    private Vibrator mVibrator;
    private SettingsObserver mSettingObserver;
    private volatile VibrateThread mThread;
    private final ArrayList<Vibrator> mInputDeviceVibrators = new ArrayList();
    private boolean mVibrateInputDevicesSetting;
    private boolean mInputDeviceListenerRegistered;
    @GuardedBy(value={"mLock"})
    private Vibration mCurrentVibration;
    private int mCurVibUid = -1;
    private ExternalVibration mCurrentExternalVibration;
    private boolean mVibratorUnderExternalControl;
    private boolean mLowPowerMode;
    private int mHapticFeedbackIntensity;
    private int mNotificationIntensity;
    private int mRingIntensity;
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq) {
            VibratorService.this.mProcStatesCache.put(uid, procState);
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
            VibratorService.this.mProcStatesCache.delete(uid);
        }

        @Override
        public void onUidActive(int uid) {
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
        }
    };
    private final Runnable mVibrationEndRunnable = new Runnable(){

        @Override
        public void run() {
            VibratorService.this.onVibrationFinished();
        }
    };
    BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                Object object = VibratorService.this.mLock;
                synchronized (object) {
                    if (!(VibratorService.this.mCurrentVibration == null || VibratorService.this.mCurrentVibration.isHapticFeedback() && VibratorService.this.mCurrentVibration.isFromSystem())) {
                        VibratorService.this.doCancelVibrateLocked();
                    }
                }
            }
        }
    };

    static native boolean vibratorExists();

    static native void vibratorInit();

    static native void vibratorOn(long var0);

    static native void vibratorOff();

    static native boolean vibratorSupportsAmplitudeControl();

    static native void vibratorSetAmplitude(int var0);

    static native long vibratorPerformEffect(long var0, long var2);

    static native boolean vibratorSupportsExternalControl();

    static native void vibratorSetExternalControl(boolean var0);

    VibratorService(Context context) {
        VibratorService.vibratorInit();
        VibratorService.vibratorOff();
        this.mSupportsAmplitudeControl = VibratorService.vibratorSupportsAmplitudeControl();
        this.mSupportsExternalControl = VibratorService.vibratorSupportsExternalControl();
        this.mContext = context;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "*vibrator*");
        this.mWakeLock.setReferenceCounted(true);
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
        this.mBatteryStatsService = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mPreviousVibrationsLimit = this.mContext.getResources().getInteger(17694874);
        this.mDefaultVibrationAmplitude = this.mContext.getResources().getInteger(17694783);
        this.mAllowPriorityVibrationsInLowPowerMode = this.mContext.getResources().getBoolean(0x1110011);
        this.mPreviousRingVibrations = new LinkedList();
        this.mPreviousNotificationVibrations = new LinkedList();
        this.mPreviousAlarmVibrations = new LinkedList();
        this.mPreviousVibrations = new LinkedList();
        this.mPreviousExternalVibrations = new LinkedList();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        context.registerReceiver(this.mIntentReceiver, filter);
        VibrationEffect clickEffect = this.createEffectFromResource(17236075);
        VibrationEffect doubleClickEffect = VibrationEffect.createWaveform(DOUBLE_CLICK_EFFECT_FALLBACK_TIMINGS, -1);
        VibrationEffect heavyClickEffect = this.createEffectFromResource(17236034);
        VibrationEffect tickEffect = this.createEffectFromResource(17236000);
        this.mFallbackEffects = new SparseArray();
        this.mFallbackEffects.put(0, clickEffect);
        this.mFallbackEffects.put(1, doubleClickEffect);
        this.mFallbackEffects.put(2, tickEffect);
        this.mFallbackEffects.put(5, heavyClickEffect);
        this.mFallbackEffects.put(21, VibrationEffect.get(2, false));
        this.mScaleLevels = new SparseArray();
        this.mScaleLevels.put(-2, new ScaleLevel(2.0f, 168));
        this.mScaleLevels.put(-1, new ScaleLevel(1.5f, 192));
        this.mScaleLevels.put(0, new ScaleLevel(1.0f));
        this.mScaleLevels.put(1, new ScaleLevel(0.5f));
        this.mScaleLevels.put(2, new ScaleLevel(0.25f));
        ServiceManager.addService(EXTERNAL_VIBRATOR_SERVICE, new ExternalVibratorService());
    }

    private VibrationEffect createEffectFromResource(int resId) {
        long[] timings = VibratorService.getLongIntArray(this.mContext.getResources(), resId);
        return VibratorService.createEffectFromTimings(timings);
    }

    private static VibrationEffect createEffectFromTimings(long[] timings) {
        if (timings == null || timings.length == 0) {
            return null;
        }
        if (timings.length == 1) {
            return VibrationEffect.createOneShot(timings[0], -1);
        }
        return VibrationEffect.createWaveform(timings, -1);
    }

    public void systemReady() {
        Trace.traceBegin(0x800000L, "VibratorService#systemReady");
        try {
            this.mIm = this.mContext.getSystemService(InputManager.class);
            this.mVibrator = this.mContext.getSystemService(Vibrator.class);
            this.mSettingObserver = new SettingsObserver(this.mH);
            this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
            this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

                @Override
                public int getServiceType() {
                    return 2;
                }

                @Override
                public void onLowPowerModeChanged(PowerSaveState result) {
                    VibratorService.this.updateVibrators();
                }
            });
            this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("vibrate_input_devices"), true, this.mSettingObserver, -1);
            this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("haptic_feedback_intensity"), true, this.mSettingObserver, -1);
            this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("notification_vibration_intensity"), true, this.mSettingObserver, -1);
            this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("ring_vibration_intensity"), true, this.mSettingObserver, -1);
            this.mContext.registerReceiver(new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    VibratorService.this.updateVibrators();
                }
            }, new IntentFilter("android.intent.action.USER_SWITCHED"), null, this.mH);
            try {
                ActivityManager.getService().registerUidObserver(this.mUidObserver, 3, -1, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.updateVibrators();
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    @Override
    public boolean hasVibrator() {
        return this.doVibratorExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAmplitudeControl() {
        ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
        synchronized (arrayList) {
            return this.mSupportsAmplitudeControl && this.mInputDeviceVibrators.isEmpty();
        }
    }

    private void verifyIncomingUid(int uid) {
        if (uid == Binder.getCallingUid()) {
            return;
        }
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private static boolean verifyVibrationEffect(VibrationEffect effect) {
        if (effect == null) {
            Slog.wtf(TAG, "effect must not be null");
            return false;
        }
        try {
            effect.validate();
        }
        catch (Exception e) {
            Slog.wtf(TAG, "Encountered issue when verifying VibrationEffect.", e);
            return false;
        }
        return true;
    }

    private static long[] getLongIntArray(Resources r, int resid) {
        int[] ar = r.getIntArray(resid);
        if (ar == null) {
            return null;
        }
        long[] out = new long[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            out[i] = ar[i];
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void vibrate(int uid, String opPkg, VibrationEffect effect, int usageHint, String reason, IBinder token) {
        block21: {
            block20: {
                block19: {
                    Trace.traceBegin(0x800000L, "vibrate, reason = " + reason);
                    if (this.mContext.checkCallingOrSelfPermission("android.permission.VIBRATE") != 0) {
                        throw new SecurityException("Requires VIBRATE permission");
                    }
                    if (token != null) break block19;
                    Slog.e(TAG, "token must not be null");
                    Trace.traceEnd(0x800000L);
                    return;
                }
                this.verifyIncomingUid(uid);
                if (VibratorService.verifyVibrationEffect(effect)) break block20;
                Trace.traceEnd(0x800000L);
                return;
            }
            Object object = this.mLock;
            // MONITORENTER : object
            if (!(effect instanceof VibrationEffect.OneShot) || this.mCurrentVibration == null || !(this.mCurrentVibration.effect instanceof VibrationEffect.OneShot)) break block21;
            VibrationEffect.OneShot newOneShot = (VibrationEffect.OneShot)effect;
            VibrationEffect.OneShot currentOneShot = (VibrationEffect.OneShot)this.mCurrentVibration.effect;
            if (!this.mCurrentVibration.hasTimeoutLongerThan(newOneShot.getDuration()) || newOneShot.getAmplitude() != currentOneShot.getAmplitude()) break block21;
            // MONITOREXIT : object
            Trace.traceEnd(0x800000L);
            return;
        }
        if (this.mCurrentExternalVibration != null) {
            // MONITOREXIT : object
            Trace.traceEnd(0x800000L);
            return;
        }
        if (!VibratorService.isRepeatingVibration(effect) && this.mCurrentVibration != null && VibratorService.isRepeatingVibration(this.mCurrentVibration.effect)) {
            // MONITOREXIT : object
            Trace.traceEnd(0x800000L);
            return;
        }
        Vibration vib = new Vibration(token, effect, usageHint, uid, opPkg, reason);
        if (!(this.mProcStatesCache.get(uid, 7) <= 7 || vib.isNotification() || vib.isRingtone() || vib.isAlarm())) {
            Slog.e(TAG, "Ignoring incoming vibration as process with uid = " + uid + " is background, usage = " + AudioAttributes.usageToString(vib.usageHint));
            // MONITOREXIT : object
            Trace.traceEnd(0x800000L);
            return;
        }
        try {
            this.linkVibration(vib);
            long ident = Binder.clearCallingIdentity();
            try {
                this.doCancelVibrateLocked();
                this.startVibrationLocked(vib);
                this.addToPreviousVibrationsLocked(vib);
                return;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    private static boolean isRepeatingVibration(VibrationEffect effect) {
        return effect.getDuration() == Long.MAX_VALUE;
    }

    private void addToPreviousVibrationsLocked(Vibration vib) {
        LinkedList<VibrationInfo> previousVibrations = vib.isRingtone() ? this.mPreviousRingVibrations : (vib.isNotification() ? this.mPreviousNotificationVibrations : (vib.isAlarm() ? this.mPreviousAlarmVibrations : this.mPreviousVibrations));
        if (previousVibrations.size() > this.mPreviousVibrationsLimit) {
            previousVibrations.removeFirst();
        }
        previousVibrations.addLast(vib.toInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelVibrate(IBinder token) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.VIBRATE", "cancelVibrate");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentVibration != null && this.mCurrentVibration.token == token) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.doCancelVibrateLocked();
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void doCancelVibrateLocked() {
        Trace.asyncTraceEnd(0x800000L, "vibration", 0);
        Trace.traceBegin(0x800000L, "doCancelVibrateLocked");
        try {
            this.mH.removeCallbacks(this.mVibrationEndRunnable);
            if (this.mThread != null) {
                this.mThread.cancel();
                this.mThread = null;
            }
            if (this.mCurrentExternalVibration != null) {
                this.mCurrentExternalVibration.mute();
                this.mCurrentExternalVibration = null;
                this.setVibratorUnderExternalControl(false);
            }
            this.doVibratorOff();
            this.reportFinishVibrationLocked();
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVibrationFinished() {
        Object object = this.mLock;
        synchronized (object) {
            this.doCancelVibrateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mLock"})
    private void startVibrationLocked(Vibration vib) {
        Trace.traceBegin(0x800000L, "startVibrationLocked");
        try {
            if (!this.isAllowedToVibrateLocked(vib)) {
                return;
            }
            int intensity = this.getCurrentIntensityLocked(vib);
            if (intensity == 0) {
                return;
            }
            if (vib.isRingtone() && !this.shouldVibrateForRingtone()) {
                return;
            }
            int mode = this.getAppOpMode(vib);
            if (mode != 0) {
                if (mode == 2) {
                    Slog.w(TAG, "Would be an error: vibrate from uid " + vib.uid);
                }
                return;
            }
            this.applyVibrationIntensityScalingLocked(vib, intensity);
            this.startVibrationInnerLocked(vib);
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mLock"})
    private void startVibrationInnerLocked(Vibration vib) {
        Trace.traceBegin(0x800000L, "startVibrationInnerLocked");
        try {
            this.mCurrentVibration = vib;
            if (vib.effect instanceof VibrationEffect.OneShot) {
                Trace.asyncTraceBegin(0x800000L, "vibration", 0);
                VibrationEffect.OneShot oneShot = (VibrationEffect.OneShot)vib.effect;
                this.doVibratorOn(oneShot.getDuration(), oneShot.getAmplitude(), vib.uid, vib.usageHint);
                this.mH.postDelayed(this.mVibrationEndRunnable, oneShot.getDuration());
            } else if (vib.effect instanceof VibrationEffect.Waveform) {
                Trace.asyncTraceBegin(0x800000L, "vibration", 0);
                VibrationEffect.Waveform waveform = (VibrationEffect.Waveform)vib.effect;
                this.mThread = new VibrateThread(waveform, vib.uid, vib.usageHint);
                this.mThread.start();
            } else if (vib.effect instanceof VibrationEffect.Prebaked) {
                Trace.asyncTraceBegin(0x800000L, "vibration", 0);
                long timeout = this.doVibratorPrebakedEffectLocked(vib);
                if (timeout > 0L) {
                    this.mH.postDelayed(this.mVibrationEndRunnable, timeout);
                }
            } else {
                Slog.e(TAG, "Unknown vibration type, ignoring");
            }
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    private boolean isAllowedToVibrateLocked(Vibration vib) {
        if (!this.mLowPowerMode) {
            return true;
        }
        if (vib.usageHint == 6) {
            return true;
        }
        return vib.usageHint == 4 || vib.usageHint == 11 || vib.usageHint == 7;
    }

    private int getCurrentIntensityLocked(Vibration vib) {
        if (vib.isRingtone()) {
            return this.mRingIntensity;
        }
        if (vib.isNotification()) {
            return this.mNotificationIntensity;
        }
        if (vib.isHapticFeedback()) {
            return this.mHapticFeedbackIntensity;
        }
        if (vib.isAlarm()) {
            return 3;
        }
        return 2;
    }

    private void applyVibrationIntensityScalingLocked(Vibration vib, int intensity) {
        int defaultIntensity;
        if (vib.effect instanceof VibrationEffect.Prebaked) {
            VibrationEffect.Prebaked prebaked = (VibrationEffect.Prebaked)vib.effect;
            prebaked.setEffectStrength(VibratorService.intensityToEffectStrength(intensity));
            return;
        }
        if (vib.isRingtone()) {
            defaultIntensity = this.mVibrator.getDefaultRingVibrationIntensity();
        } else if (vib.isNotification()) {
            defaultIntensity = this.mVibrator.getDefaultNotificationVibrationIntensity();
        } else if (vib.isHapticFeedback()) {
            defaultIntensity = this.mVibrator.getDefaultHapticFeedbackIntensity();
        } else if (vib.isAlarm()) {
            defaultIntensity = 3;
        } else {
            return;
        }
        ScaleLevel scale = this.mScaleLevels.get(intensity - defaultIntensity);
        if (scale == null) {
            Slog.e(TAG, "No configured scaling level! (current=" + intensity + ", default= " + defaultIntensity + ")");
            return;
        }
        VibrationEffect scaledEffect = null;
        if (vib.effect instanceof VibrationEffect.OneShot) {
            VibrationEffect.OneShot oneShot = (VibrationEffect.OneShot)vib.effect;
            oneShot = oneShot.resolve(this.mDefaultVibrationAmplitude);
            scaledEffect = oneShot.scale(scale.gamma, scale.maxAmplitude);
        } else if (vib.effect instanceof VibrationEffect.Waveform) {
            VibrationEffect.Waveform waveform = (VibrationEffect.Waveform)vib.effect;
            waveform = waveform.resolve(this.mDefaultVibrationAmplitude);
            scaledEffect = waveform.scale(scale.gamma, scale.maxAmplitude);
        } else {
            Slog.w(TAG, "Unable to apply intensity scaling, unknown VibrationEffect type");
        }
        if (scaledEffect != null) {
            vib.originalEffect = vib.effect;
            vib.effect = scaledEffect;
        }
    }

    private boolean shouldVibrateForRingtone() {
        AudioManager audioManager = this.mContext.getSystemService(AudioManager.class);
        int ringerMode = audioManager.getRingerModeInternal();
        if (Settings.System.getInt(this.mContext.getContentResolver(), "vibrate_when_ringing", 0) != 0) {
            return ringerMode != 0;
        }
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "apply_ramping_ringer", 0) != 0 && DeviceConfig.getBoolean("telephony", RAMPING_RINGER_ENABLED, false)) {
            return ringerMode != 0;
        }
        return ringerMode == 1;
    }

    private int getAppOpMode(Vibration vib) {
        int mode = this.mAppOps.checkAudioOpNoThrow(3, vib.usageHint, vib.uid, vib.opPkg);
        if (mode == 0) {
            mode = this.mAppOps.startOpNoThrow(3, vib.uid, vib.opPkg);
        }
        return mode;
    }

    @GuardedBy(value={"mLock"})
    private void reportFinishVibrationLocked() {
        Trace.traceBegin(0x800000L, "reportFinishVibrationLocked");
        try {
            if (this.mCurrentVibration != null) {
                this.mAppOps.finishOp(3, this.mCurrentVibration.uid, this.mCurrentVibration.opPkg);
                this.unlinkVibration(this.mCurrentVibration);
                this.mCurrentVibration = null;
            }
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    private void linkVibration(Vibration vib) {
        if (vib.effect instanceof VibrationEffect.Waveform) {
            try {
                vib.token.linkToDeath(vib, 0);
            }
            catch (RemoteException e) {
                return;
            }
        }
    }

    private void unlinkVibration(Vibration vib) {
        if (vib.effect instanceof VibrationEffect.Waveform) {
            vib.token.unlinkToDeath(vib, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVibrators() {
        Object object = this.mLock;
        synchronized (object) {
            boolean devicesUpdated = this.updateInputDeviceVibratorsLocked();
            boolean lowPowerModeUpdated = this.updateLowPowerModeLocked();
            this.updateVibrationIntensityLocked();
            if (devicesUpdated || lowPowerModeUpdated) {
                this.doCancelVibrateLocked();
            }
        }
    }

    private boolean updateInputDeviceVibratorsLocked() {
        boolean changed = false;
        boolean vibrateInputDevices = false;
        try {
            vibrateInputDevices = Settings.System.getIntForUser(this.mContext.getContentResolver(), "vibrate_input_devices", -2) > 0;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        if (vibrateInputDevices != this.mVibrateInputDevicesSetting) {
            changed = true;
            this.mVibrateInputDevicesSetting = vibrateInputDevices;
        }
        if (this.mVibrateInputDevicesSetting) {
            if (!this.mInputDeviceListenerRegistered) {
                this.mInputDeviceListenerRegistered = true;
                this.mIm.registerInputDeviceListener(this, this.mH);
            }
        } else if (this.mInputDeviceListenerRegistered) {
            this.mInputDeviceListenerRegistered = false;
            this.mIm.unregisterInputDeviceListener(this);
        }
        this.mInputDeviceVibrators.clear();
        if (this.mVibrateInputDevicesSetting) {
            int[] ids = this.mIm.getInputDeviceIds();
            for (int i = 0; i < ids.length; ++i) {
                InputDevice device = this.mIm.getInputDevice(ids[i]);
                Vibrator vibrator = device.getVibrator();
                if (!vibrator.hasVibrator()) continue;
                this.mInputDeviceVibrators.add(vibrator);
            }
            return true;
        }
        return changed;
    }

    private boolean updateLowPowerModeLocked() {
        boolean lowPowerMode = this.mPowerManagerInternal.getLowPowerState((int)2).batterySaverEnabled;
        if (lowPowerMode != this.mLowPowerMode) {
            this.mLowPowerMode = lowPowerMode;
            return true;
        }
        return false;
    }

    private void updateVibrationIntensityLocked() {
        this.mHapticFeedbackIntensity = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_intensity", this.mVibrator.getDefaultHapticFeedbackIntensity(), -2);
        this.mNotificationIntensity = Settings.System.getIntForUser(this.mContext.getContentResolver(), "notification_vibration_intensity", this.mVibrator.getDefaultNotificationVibrationIntensity(), -2);
        this.mRingIntensity = Settings.System.getIntForUser(this.mContext.getContentResolver(), "ring_vibration_intensity", this.mVibrator.getDefaultRingVibrationIntensity(), -2);
    }

    @Override
    public void onInputDeviceAdded(int deviceId) {
        this.updateVibrators();
    }

    @Override
    public void onInputDeviceChanged(int deviceId) {
        this.updateVibrators();
    }

    @Override
    public void onInputDeviceRemoved(int deviceId) {
        this.updateVibrators();
    }

    private boolean doVibratorExists() {
        return VibratorService.vibratorExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVibratorOn(long millis, int amplitude, int uid, int usageHint) {
        Trace.traceBegin(0x800000L, "doVibratorOn");
        try {
            ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
            synchronized (arrayList) {
                if (amplitude == -1) {
                    amplitude = this.mDefaultVibrationAmplitude;
                }
                this.noteVibratorOnLocked(uid, millis);
                int vibratorCount = this.mInputDeviceVibrators.size();
                if (vibratorCount != 0) {
                    AudioAttributes attributes = new AudioAttributes.Builder().setUsage(usageHint).build();
                    for (int i = 0; i < vibratorCount; ++i) {
                        this.mInputDeviceVibrators.get(i).vibrate(millis, attributes);
                    }
                } else {
                    VibratorService.vibratorOn(millis);
                    this.doVibratorSetAmplitude(amplitude);
                }
            }
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    private void doVibratorSetAmplitude(int amplitude) {
        if (this.mSupportsAmplitudeControl) {
            VibratorService.vibratorSetAmplitude(amplitude);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVibratorOff() {
        Trace.traceBegin(0x800000L, "doVibratorOff");
        try {
            ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
            synchronized (arrayList) {
                this.noteVibratorOffLocked();
                int vibratorCount = this.mInputDeviceVibrators.size();
                if (vibratorCount != 0) {
                    for (int i = 0; i < vibratorCount; ++i) {
                        this.mInputDeviceVibrators.get(i).cancel();
                    }
                } else {
                    VibratorService.vibratorOff();
                }
            }
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mLock"})
    private long doVibratorPrebakedEffectLocked(Vibration vib) {
        Trace.traceBegin(0x800000L, "doVibratorPrebakedEffectLocked");
        try {
            long timeout;
            boolean usingInputDeviceVibrators;
            VibrationEffect.Prebaked prebaked = (VibrationEffect.Prebaked)vib.effect;
            ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
            synchronized (arrayList) {
                usingInputDeviceVibrators = !this.mInputDeviceVibrators.isEmpty();
            }
            if (!usingInputDeviceVibrators && (timeout = VibratorService.vibratorPerformEffect(prebaked.getId(), prebaked.getEffectStrength())) > 0L) {
                this.noteVibratorOnLocked(vib.uid, timeout);
                long l = timeout;
                return l;
            }
            if (!prebaked.shouldFallback()) {
                timeout = 0L;
                return timeout;
            }
            VibrationEffect effect = this.getFallbackEffect(prebaked.getId());
            if (effect == null) {
                Slog.w(TAG, "Failed to play prebaked effect, no fallback");
                long l = 0L;
                return l;
            }
            Vibration fallbackVib = new Vibration(vib.token, effect, vib.usageHint, vib.uid, vib.opPkg, vib.reason + " (fallback)");
            int intensity = this.getCurrentIntensityLocked(fallbackVib);
            this.linkVibration(fallbackVib);
            this.applyVibrationIntensityScalingLocked(fallbackVib, intensity);
            this.startVibrationInnerLocked(fallbackVib);
            long l = 0L;
            return l;
        }
        finally {
            Trace.traceEnd(0x800000L);
        }
    }

    private VibrationEffect getFallbackEffect(int effectId) {
        return this.mFallbackEffects.get(effectId);
    }

    private static int intensityToEffectStrength(int intensity) {
        switch (intensity) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        Slog.w(TAG, "Got unexpected vibration intensity: " + intensity);
        return 2;
    }

    private static boolean isNotification(int usageHint) {
        switch (usageHint) {
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRingtone(int usageHint) {
        return usageHint == 6;
    }

    private static boolean isHapticFeedback(int usageHint) {
        return usageHint == 13;
    }

    private static boolean isAlarm(int usageHint) {
        return usageHint == 4;
    }

    private void noteVibratorOnLocked(int uid, long millis) {
        try {
            this.mBatteryStatsService.noteVibratorOn(uid, millis);
            StatsLog.write_non_chained(84, uid, null, 1, millis);
            this.mCurVibUid = uid;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void noteVibratorOffLocked() {
        if (this.mCurVibUid >= 0) {
            try {
                this.mBatteryStatsService.noteVibratorOff(this.mCurVibUid);
                StatsLog.write_non_chained(84, this.mCurVibUid, null, 0, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mCurVibUid = -1;
        }
    }

    private void setVibratorUnderExternalControl(boolean externalControl) {
        this.mVibratorUnderExternalControl = externalControl;
        VibratorService.vibratorSetExternalControl(externalControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        pw.println("Vibrator Service:");
        Object object = this.mLock;
        synchronized (object) {
            pw.print("  mCurrentVibration=");
            if (this.mCurrentVibration != null) {
                pw.println(this.mCurrentVibration.toInfo().toString());
            } else {
                pw.println("null");
            }
            pw.print("  mCurrentExternalVibration=");
            if (this.mCurrentExternalVibration != null) {
                pw.println(this.mCurrentExternalVibration.toString());
            } else {
                pw.println("null");
            }
            pw.println("  mVibratorUnderExternalControl=" + this.mVibratorUnderExternalControl);
            pw.println("  mLowPowerMode=" + this.mLowPowerMode);
            pw.println("  mHapticFeedbackIntensity=" + this.mHapticFeedbackIntensity);
            pw.println("  mNotificationIntensity=" + this.mNotificationIntensity);
            pw.println("  mRingIntensity=" + this.mRingIntensity);
            pw.println("");
            pw.println("  Previous ring vibrations:");
            for (VibrationInfo info : this.mPreviousRingVibrations) {
                pw.print("    ");
                pw.println(info.toString());
            }
            pw.println("  Previous notification vibrations:");
            for (VibrationInfo info : this.mPreviousNotificationVibrations) {
                pw.print("    ");
                pw.println(info.toString());
            }
            pw.println("  Previous alarm vibrations:");
            for (VibrationInfo info : this.mPreviousAlarmVibrations) {
                pw.print("    ");
                pw.println(info.toString());
            }
            pw.println("  Previous vibrations:");
            for (VibrationInfo info : this.mPreviousVibrations) {
                pw.print("    ");
                pw.println(info.toString());
            }
            pw.println("  Previous external vibrations:");
            for (ExternalVibration vib : this.mPreviousExternalVibrations) {
                pw.print("    ");
                pw.println(vib.toString());
            }
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        new VibratorShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    private final class VibratorShellCommand
    extends ShellCommand {
        private final IBinder mToken;

        private VibratorShellCommand(IBinder token) {
            this.mToken = token;
        }

        @Override
        public int onCommand(String cmd) {
            if ("vibrate".equals(cmd)) {
                return this.runVibrate();
            }
            if ("waveform".equals(cmd)) {
                return this.runWaveform();
            }
            if ("prebaked".equals(cmd)) {
                return this.runPrebaked();
            }
            if ("cancel".equals(cmd)) {
                VibratorService.this.cancelVibrate(this.mToken);
                return 0;
            }
            return this.handleDefaultCommands(cmd);
        }

        private boolean checkDoNotDisturb(CommonOptions opts) {
            block8: {
                boolean bl;
                block9: {
                    int zenMode = Settings.Global.getInt(VibratorService.this.mContext.getContentResolver(), "zen_mode");
                    if (zenMode == 0 || opts.force) break block8;
                    PrintWriter pw = this.getOutPrintWriter();
                    Throwable throwable = null;
                    try {
                        pw.print("Ignoring because device is on DND mode ");
                        pw.println(DebugUtils.flagsToString(Settings.Global.class, "ZEN_MODE_", zenMode));
                        bl = true;
                        if (pw == null) break block9;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (pw != null) {
                                    VibratorShellCommand.$closeResource(throwable, pw);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Settings.SettingNotFoundException settingNotFoundException) {
                            // empty catch block
                        }
                    }
                    VibratorShellCommand.$closeResource(throwable, pw);
                }
                return bl;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int runVibrate() {
            Trace.traceBegin(0x800000L, "runVibrate");
            try {
                String opt;
                CommonOptions commonOptions = new CommonOptions();
                while ((opt = this.getNextOption()) != null) {
                    commonOptions.check(opt);
                }
                if (this.checkDoNotDisturb(commonOptions)) {
                    int n = 0;
                    return n;
                }
                long duration = Long.parseLong(this.getNextArgRequired());
                String description = this.getNextArg();
                if (description == null) {
                    description = "Shell command";
                }
                VibrationEffect effect = VibrationEffect.createOneShot(duration, -1);
                VibratorService.this.vibrate(Binder.getCallingUid(), description, effect, 0, "Shell Command", this.mToken);
                int n = 0;
                return n;
            }
            finally {
                Trace.traceEnd(0x800000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int runWaveform() {
            Trace.traceBegin(0x800000L, "runWaveform");
            try {
                VibrationEffect effect;
                String arg;
                String opt;
                String description = "Shell command";
                int repeat = -1;
                ArrayList<Integer> amplitudesList = null;
                CommonOptions commonOptions = new CommonOptions();
                block14: while ((opt = this.getNextOption()) != null) {
                    switch (opt) {
                        case "-d": {
                            description = this.getNextArgRequired();
                            continue block14;
                        }
                        case "-r": {
                            repeat = Integer.parseInt(this.getNextArgRequired());
                            continue block14;
                        }
                        case "-a": {
                            if (amplitudesList != null) continue block14;
                            amplitudesList = new ArrayList<Integer>();
                            continue block14;
                        }
                    }
                    commonOptions.check(opt);
                }
                if (this.checkDoNotDisturb(commonOptions)) {
                    int n = 0;
                    return n;
                }
                ArrayList<Long> timingsList = new ArrayList<Long>();
                while ((arg = this.getNextArg()) != null) {
                    if (amplitudesList != null && amplitudesList.size() < timingsList.size()) {
                        amplitudesList.add(Integer.parseInt(arg));
                        continue;
                    }
                    timingsList.add(Long.parseLong(arg));
                }
                long[] timings = timingsList.stream().mapToLong(Long::longValue).toArray();
                if (amplitudesList == null) {
                    effect = VibrationEffect.createWaveform(timings, repeat);
                } else {
                    int[] amplitudes = amplitudesList.stream().mapToInt(Integer::intValue).toArray();
                    effect = VibrationEffect.createWaveform(timings, amplitudes, repeat);
                }
                VibratorService.this.vibrate(Binder.getCallingUid(), description, effect, 0, "Shell Command", this.mToken);
                int n = 0;
                return n;
            }
            finally {
                Trace.traceEnd(0x800000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int runPrebaked() {
            Trace.traceBegin(0x800000L, "runPrebaked");
            try {
                String opt;
                CommonOptions commonOptions = new CommonOptions();
                while ((opt = this.getNextOption()) != null) {
                    commonOptions.check(opt);
                }
                if (this.checkDoNotDisturb(commonOptions)) {
                    int n = 0;
                    return n;
                }
                int id2 = Integer.parseInt(this.getNextArgRequired());
                String description = this.getNextArg();
                if (description == null) {
                    description = "Shell command";
                }
                VibrationEffect effect = VibrationEffect.get(id2, false);
                VibratorService.this.vibrate(Binder.getCallingUid(), description, effect, 0, "Shell Command", this.mToken);
                int n = 0;
                return n;
            }
            finally {
                Trace.traceEnd(0x800000L);
            }
        }

        @Override
        public void onHelp() {
            try (PrintWriter pw = this.getOutPrintWriter();){
                pw.println("Vibrator commands:");
                pw.println("  help");
                pw.println("    Prints this help text.");
                pw.println("");
                pw.println("  vibrate duration [description]");
                pw.println("    Vibrates for duration milliseconds; ignored when device is on DND ");
                pw.println("    (Do Not Disturb) mode.");
                pw.println("  waveform [-d description] [-r index] [-a] duration [amplitude] ...");
                pw.println("    Vibrates for durations and amplitudes in list;");
                pw.println("    ignored when device is on DND (Do Not Disturb) mode.");
                pw.println("    If -r is provided, the waveform loops back to the specified");
                pw.println("    index (e.g. 0 loops from the beginning)");
                pw.println("    If -a is provided, the command accepts duration-amplitude pairs;");
                pw.println("    otherwise, it accepts durations only and alternates off/on");
                pw.println("    Duration is in milliseconds; amplitude is a scale of 1-255.");
                pw.println("  prebaked effect-id [description]");
                pw.println("    Vibrates with prebaked effect; ignored when device is on DND ");
                pw.println("    (Do Not Disturb) mode.");
                pw.println("  cancel");
                pw.println("    Cancels any active vibration");
                pw.println("Common Options:");
                pw.println("  -f - Force. Ignore Do Not Disturb setting.");
                pw.println("");
            }
        }

        private final class CommonOptions {
            public boolean force = false;

            private CommonOptions() {
            }

            public void check(String opt) {
                switch (opt) {
                    case "-f": {
                        this.force = true;
                    }
                }
            }
        }
    }

    final class ExternalVibratorService
    extends IExternalVibratorService.Stub {
        ExternalVibrationDeathRecipient mCurrentExternalDeathRecipient;

        ExternalVibratorService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int onExternalVibrationStart(ExternalVibration vib) {
            int scaleLevel;
            if (!VibratorService.this.mSupportsExternalControl) {
                return -100;
            }
            if (ActivityManager.checkComponentPermission("android.permission.VIBRATE", vib.getUid(), -1, true) != 0) {
                Slog.w(VibratorService.TAG, "pkg=" + vib.getPackage() + ", uid=" + vib.getUid() + " tried to play externally controlled vibration without VIBRATE permission, ignoring.");
                return -100;
            }
            Object object = VibratorService.this.mLock;
            synchronized (object) {
                int currentIntensity;
                int defaultIntensity;
                int usage;
                if (!vib.equals(VibratorService.this.mCurrentExternalVibration)) {
                    if (VibratorService.this.mCurrentExternalVibration == null) {
                        VibratorService.this.doCancelVibrateLocked();
                        VibratorService.this.setVibratorUnderExternalControl(true);
                    }
                    VibratorService.this.mCurrentExternalVibration = vib;
                    this.mCurrentExternalDeathRecipient = new ExternalVibrationDeathRecipient();
                    VibratorService.this.mCurrentExternalVibration.linkToDeath(this.mCurrentExternalDeathRecipient);
                    if (VibratorService.this.mPreviousExternalVibrations.size() > VibratorService.this.mPreviousVibrationsLimit) {
                        VibratorService.this.mPreviousExternalVibrations.removeFirst();
                    }
                    VibratorService.this.mPreviousExternalVibrations.addLast(vib);
                }
                if (VibratorService.isRingtone(usage = vib.getAudioAttributes().getUsage())) {
                    defaultIntensity = VibratorService.this.mVibrator.getDefaultRingVibrationIntensity();
                    currentIntensity = VibratorService.this.mRingIntensity;
                } else if (VibratorService.isNotification(usage)) {
                    defaultIntensity = VibratorService.this.mVibrator.getDefaultNotificationVibrationIntensity();
                    currentIntensity = VibratorService.this.mNotificationIntensity;
                } else if (VibratorService.isHapticFeedback(usage)) {
                    defaultIntensity = VibratorService.this.mVibrator.getDefaultHapticFeedbackIntensity();
                    currentIntensity = VibratorService.this.mHapticFeedbackIntensity;
                } else if (VibratorService.isAlarm(usage)) {
                    defaultIntensity = 3;
                    currentIntensity = 3;
                } else {
                    defaultIntensity = 0;
                    currentIntensity = 0;
                }
                scaleLevel = currentIntensity - defaultIntensity;
            }
            if (scaleLevel >= -2 && scaleLevel <= 2) {
                return scaleLevel;
            }
            Slog.w(VibratorService.TAG, "Error in scaling calculations, ended up with invalid scale level " + scaleLevel + " for vibration " + vib);
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onExternalVibrationStop(ExternalVibration vib) {
            Object object = VibratorService.this.mLock;
            synchronized (object) {
                if (vib.equals(VibratorService.this.mCurrentExternalVibration)) {
                    VibratorService.this.mCurrentExternalVibration.unlinkToDeath(this.mCurrentExternalDeathRecipient);
                    this.mCurrentExternalDeathRecipient = null;
                    VibratorService.this.mCurrentExternalVibration = null;
                    VibratorService.this.setVibratorUnderExternalControl(false);
                }
            }
        }

        private class ExternalVibrationDeathRecipient
        implements IBinder.DeathRecipient {
            private ExternalVibrationDeathRecipient() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void binderDied() {
                Object object = VibratorService.this.mLock;
                synchronized (object) {
                    ExternalVibratorService.this.onExternalVibrationStop(VibratorService.this.mCurrentExternalVibration);
                }
            }
        }
    }

    private class VibrateThread
    extends Thread {
        private final VibrationEffect.Waveform mWaveform;
        private final int mUid;
        private final int mUsageHint;
        private boolean mForceStop;

        VibrateThread(VibrationEffect.Waveform waveform, int uid, int usageHint) {
            this.mWaveform = waveform;
            this.mUid = uid;
            this.mUsageHint = usageHint;
            VibratorService.this.mTmpWorkSource.set(uid);
            VibratorService.this.mWakeLock.setWorkSource(VibratorService.this.mTmpWorkSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long delayLocked(long duration) {
            Trace.traceBegin(0x800000L, "delayLocked");
            try {
                long durationRemaining = duration;
                if (duration > 0L) {
                    long bedtime = duration + SystemClock.uptimeMillis();
                    do {
                        try {
                            this.wait(durationRemaining);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!this.mForceStop && (durationRemaining = bedtime - SystemClock.uptimeMillis()) > 0L);
                    long l = duration - durationRemaining;
                    return l;
                }
                long l = 0L;
                return l;
            }
            finally {
                Trace.traceEnd(0x800000L);
            }
        }

        @Override
        public void run() {
            Process.setThreadPriority(-8);
            VibratorService.this.mWakeLock.acquire();
            try {
                boolean finished = this.playWaveform();
                if (finished) {
                    VibratorService.this.onVibrationFinished();
                }
            }
            finally {
                VibratorService.this.mWakeLock.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean playWaveform() {
            Trace.traceBegin(0x800000L, "playWaveform");
            try {
                VibrateThread vibrateThread = this;
                synchronized (vibrateThread) {
                    long[] timings = this.mWaveform.getTimings();
                    int[] amplitudes = this.mWaveform.getAmplitudes();
                    int len = timings.length;
                    int repeat = this.mWaveform.getRepeatIndex();
                    int index = 0;
                    long onDuration = 0L;
                    while (!this.mForceStop) {
                        if (index < len) {
                            long duration;
                            int amplitude = amplitudes[index];
                            if ((duration = timings[index++]) <= 0L) continue;
                            if (amplitude != 0) {
                                if (onDuration <= 0L) {
                                    onDuration = this.getTotalOnDuration(timings, amplitudes, index - 1, repeat);
                                    VibratorService.this.doVibratorOn(onDuration, amplitude, this.mUid, this.mUsageHint);
                                } else {
                                    VibratorService.this.doVibratorSetAmplitude(amplitude);
                                }
                            }
                            long waitTime = this.delayLocked(duration);
                            if (amplitude == 0) continue;
                            onDuration -= waitTime;
                            continue;
                        }
                        if (repeat < 0) break;
                        index = repeat;
                    }
                    boolean bl = !this.mForceStop;
                    return bl;
                }
            }
            finally {
                Trace.traceEnd(0x800000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            VibrateThread vibrateThread = this;
            synchronized (vibrateThread) {
                ((VibratorService)VibratorService.this).mThread.mForceStop = true;
                VibratorService.this.mThread.notify();
            }
        }

        private long getTotalOnDuration(long[] timings, int[] amplitudes, int startIndex, int repeatIndex) {
            int i = startIndex;
            long timing = 0L;
            while (amplitudes[i] != 0) {
                timing += timings[i++];
                if (i >= timings.length) {
                    if (repeatIndex < 0) break;
                    i = repeatIndex;
                    repeatIndex = -1;
                }
                if (i != startIndex) continue;
                return 1000L;
            }
            return timing;
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean SelfChange) {
            VibratorService.this.updateVibrators();
        }
    }

    private static final class ScaleLevel {
        public final float gamma;
        public final int maxAmplitude;

        public ScaleLevel(float gamma) {
            this(gamma, 255);
        }

        public ScaleLevel(float gamma, int maxAmplitude) {
            this.gamma = gamma;
            this.maxAmplitude = maxAmplitude;
        }

        public String toString() {
            return "ScaleLevel{gamma=" + this.gamma + ", maxAmplitude=" + this.maxAmplitude + "}";
        }
    }

    private static class VibrationInfo {
        private final long mStartTimeDebug;
        private final VibrationEffect mEffect;
        private final VibrationEffect mOriginalEffect;
        private final int mUsageHint;
        private final int mUid;
        private final String mOpPkg;
        private final String mReason;

        public VibrationInfo(long startTimeDebug, VibrationEffect effect, VibrationEffect originalEffect, int usageHint, int uid, String opPkg, String reason) {
            this.mStartTimeDebug = startTimeDebug;
            this.mEffect = effect;
            this.mOriginalEffect = originalEffect;
            this.mUsageHint = usageHint;
            this.mUid = uid;
            this.mOpPkg = opPkg;
            this.mReason = reason;
        }

        public String toString() {
            return "startTime: " + DateFormat.getDateTimeInstance().format(new Date(this.mStartTimeDebug)) + ", effect: " + this.mEffect + ", originalEffect: " + this.mOriginalEffect + ", usageHint: " + this.mUsageHint + ", uid: " + this.mUid + ", opPkg: " + this.mOpPkg + ", reason: " + this.mReason;
        }
    }

    private class Vibration
    implements IBinder.DeathRecipient {
        public final IBinder token;
        public final long startTime;
        public final long startTimeDebug;
        public final int usageHint;
        public final int uid;
        public final String opPkg;
        public final String reason;
        public VibrationEffect effect;
        public VibrationEffect originalEffect;

        private Vibration(IBinder token, VibrationEffect effect, int usageHint, int uid, String opPkg, String reason) {
            this.token = token;
            this.effect = effect;
            this.startTime = SystemClock.elapsedRealtime();
            this.startTimeDebug = System.currentTimeMillis();
            this.usageHint = usageHint;
            this.uid = uid;
            this.opPkg = opPkg;
            this.reason = reason;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = VibratorService.this.mLock;
            synchronized (object) {
                if (this == VibratorService.this.mCurrentVibration) {
                    VibratorService.this.doCancelVibrateLocked();
                }
            }
        }

        public boolean hasTimeoutLongerThan(long millis) {
            long duration = this.effect.getDuration();
            return duration >= 0L && duration > millis;
        }

        public boolean isHapticFeedback() {
            if (VibratorService.isHapticFeedback(this.usageHint)) {
                return true;
            }
            if (this.effect instanceof VibrationEffect.Prebaked) {
                VibrationEffect.Prebaked prebaked = (VibrationEffect.Prebaked)this.effect;
                switch (prebaked.getId()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 21: {
                        return true;
                    }
                }
                Slog.w(VibratorService.TAG, "Unknown prebaked vibration effect, assuming it isn't haptic feedback.");
                return false;
            }
            long duration = this.effect.getDuration();
            return duration >= 0L && duration < 5000L;
        }

        public boolean isNotification() {
            return VibratorService.isNotification(this.usageHint);
        }

        public boolean isRingtone() {
            return VibratorService.isRingtone(this.usageHint);
        }

        public boolean isAlarm() {
            return VibratorService.isAlarm(this.usageHint);
        }

        public boolean isFromSystem() {
            return this.uid == 1000 || this.uid == 0 || VibratorService.SYSTEM_UI_PACKAGE.equals(this.opPkg);
        }

        public VibrationInfo toInfo() {
            return new VibrationInfo(this.startTimeDebug, this.effect, this.originalEffect, this.usageHint, this.uid, this.opPkg, this.reason);
        }
    }
}

