/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityThread;
import android.app.ContextImpl;
import android.app.WallpaperManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.util.Slog;

public class WallpaperUpdateReceiver
extends BroadcastReceiver {
    private static final String TAG = "WallpaperUpdateReceiver";
    private static final boolean DEBUG = false;

    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent != null && "android.intent.action.DEVICE_CUSTOMIZATION_READY".equals(intent.getAction())) {
            AsyncTask.execute(this::updateWallpaper);
        }
    }

    private void updateWallpaper() {
        try {
            ActivityThread currentActivityThread = ActivityThread.currentActivityThread();
            ContextImpl uiContext = currentActivityThread.getSystemUiContext();
            WallpaperManager wallpaperManager = WallpaperManager.getInstance(uiContext);
            Bitmap blank = Bitmap.createBitmap(1, 1, Bitmap.Config.ALPHA_8);
            wallpaperManager.setBitmap(blank);
            wallpaperManager.setResource(17302138);
        }
        catch (Exception e) {
            Slog.w(TAG, "Failed to customize system wallpaper." + e);
        }
    }
}

