/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ParceledListSlice;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Slog;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.MagnificationSpec;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.DumpUtils;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accessibility.FingerprintGestureDispatcher;
import com.android.server.accessibility.GlobalActionPerformer;
import com.android.server.accessibility.KeyEventDispatcher;
import com.android.server.accessibility.MagnificationController;
import com.android.server.accessibility.MotionEventInjector;
import com.android.server.wm.WindowManagerInternal;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class AbstractAccessibilityServiceConnection
extends IAccessibilityServiceConnection.Stub
implements ServiceConnection,
IBinder.DeathRecipient,
KeyEventDispatcher.KeyEventFilter,
FingerprintGestureDispatcher.FingerprintGestureClient {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AbstractAccessibilityServiceConnection";
    protected final Context mContext;
    protected final SystemSupport mSystemSupport;
    private final WindowManagerInternal mWindowManagerService;
    private final GlobalActionPerformer mGlobalActionPerformer;
    public final InvocationHandler mInvocationHandler;
    final int mId;
    protected final AccessibilityServiceInfo mAccessibilityServiceInfo;
    protected final Object mLock;
    protected final AccessibilityManagerService.SecurityPolicy mSecurityPolicy;
    IBinder mService;
    IAccessibilityServiceClient mServiceInterface;
    int mEventTypes;
    int mFeedbackType;
    Set<String> mPackageNames = new HashSet<String>();
    boolean mIsDefault;
    boolean mRequestTouchExplorationMode;
    boolean mRequestFilterKeyEvents;
    boolean mRetrieveInteractiveWindows;
    boolean mCaptureFingerprintGestures;
    boolean mRequestAccessibilityButton;
    boolean mReceivedAccessibilityButtonCallbackSinceBind;
    boolean mLastAccessibilityButtonCallbackState;
    int mFetchFlags;
    long mNotificationTimeout;
    final ComponentName mComponentName;
    final SparseArray<AccessibilityEvent> mPendingEvents = new SparseArray();
    boolean mUsesAccessibilityCache = false;
    public Handler mEventDispatchHandler;
    final IBinder mOverlayWindowToken = new Binder();

    public AbstractAccessibilityServiceConnection(Context context, ComponentName componentName, AccessibilityServiceInfo accessibilityServiceInfo, int id2, Handler mainHandler, Object lock, AccessibilityManagerService.SecurityPolicy securityPolicy, SystemSupport systemSupport, WindowManagerInternal windowManagerInternal, GlobalActionPerformer globalActionPerfomer) {
        this.mContext = context;
        this.mWindowManagerService = windowManagerInternal;
        this.mId = id2;
        this.mComponentName = componentName;
        this.mAccessibilityServiceInfo = accessibilityServiceInfo;
        this.mLock = lock;
        this.mSecurityPolicy = securityPolicy;
        this.mGlobalActionPerformer = globalActionPerfomer;
        this.mSystemSupport = systemSupport;
        this.mInvocationHandler = new InvocationHandler(mainHandler.getLooper());
        this.mEventDispatchHandler = new Handler(mainHandler.getLooper()){

            @Override
            public void handleMessage(Message message) {
                int eventType = message.what;
                AccessibilityEvent event = (AccessibilityEvent)message.obj;
                boolean serviceWantsEvent = message.arg1 != 0;
                AbstractAccessibilityServiceConnection.this.notifyAccessibilityEventInternal(eventType, event, serviceWantsEvent);
            }
        };
        this.setDynamicallyConfigurableProperties(accessibilityServiceInfo);
    }

    @Override
    public boolean onKeyEvent(KeyEvent keyEvent, int sequenceNumber) {
        if (!this.mRequestFilterKeyEvents || this.mServiceInterface == null) {
            return false;
        }
        if ((this.mAccessibilityServiceInfo.getCapabilities() & 8) == 0) {
            return false;
        }
        if (!this.mSecurityPolicy.checkAccessibilityAccess(this)) {
            return false;
        }
        try {
            this.mServiceInterface.onKeyEvent(keyEvent, sequenceNumber);
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public void setDynamicallyConfigurableProperties(AccessibilityServiceInfo info) {
        this.mEventTypes = info.eventTypes;
        this.mFeedbackType = info.feedbackType;
        String[] packageNames = info.packageNames;
        if (packageNames != null) {
            this.mPackageNames.addAll(Arrays.asList(packageNames));
        }
        this.mNotificationTimeout = info.notificationTimeout;
        boolean bl = this.mIsDefault = (info.flags & 1) != 0;
        if (this.supportsFlagForNotImportantViews(info)) {
            this.mFetchFlags = (info.flags & 2) != 0 ? (this.mFetchFlags |= 8) : (this.mFetchFlags &= 0xFFFFFFF7);
        }
        this.mFetchFlags = (info.flags & 0x10) != 0 ? (this.mFetchFlags |= 0x10) : (this.mFetchFlags &= 0xFFFFFFEF);
        this.mRequestTouchExplorationMode = (info.flags & 4) != 0;
        this.mRequestFilterKeyEvents = (info.flags & 0x20) != 0;
        this.mRetrieveInteractiveWindows = (info.flags & 0x40) != 0;
        this.mCaptureFingerprintGestures = (info.flags & 0x200) != 0;
        this.mRequestAccessibilityButton = (info.flags & 0x100) != 0;
    }

    protected boolean supportsFlagForNotImportantViews(AccessibilityServiceInfo info) {
        return info.getResolveInfo().serviceInfo.applicationInfo.targetSdkVersion >= 16;
    }

    public boolean canReceiveEventsLocked() {
        return this.mEventTypes != 0 && this.mFeedbackType != 0 && this.mService != null;
    }

    @Override
    public void setOnKeyEventResult(boolean handled, int sequence) {
        this.mSystemSupport.getKeyEventDispatcher().setOnKeyEventResult(this, handled, sequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccessibilityServiceInfo getServiceInfo() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAccessibilityServiceInfo;
        }
    }

    public int getCapabilities() {
        return this.mAccessibilityServiceInfo.getCapabilities();
    }

    int getRelevantEventTypes() {
        return (this.mUsesAccessibilityCache ? 4307005 : 32) | this.mEventTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServiceInfo(AccessibilityServiceInfo info) {
        long identity = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                AccessibilityServiceInfo oldInfo = this.mAccessibilityServiceInfo;
                if (oldInfo != null) {
                    oldInfo.updateDynamicallyConfigurableProperties(info);
                    this.setDynamicallyConfigurableProperties(oldInfo);
                } else {
                    this.setDynamicallyConfigurableProperties(info);
                }
                this.mSystemSupport.onClientChangeLocked(true);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    protected abstract boolean isCalledForCurrentUserLocked();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccessibilityWindowInfo> getWindows() {
        this.mSystemSupport.ensureWindowsAvailableTimed();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledForCurrentUserLocked()) {
                return null;
            }
            boolean permissionGranted = this.mSecurityPolicy.canRetrieveWindowsLocked(this);
            if (!permissionGranted) {
                return null;
            }
            if (this.mSecurityPolicy.mWindows == null) {
                return null;
            }
            if (!this.mSecurityPolicy.checkAccessibilityAccess(this)) {
                return null;
            }
            ArrayList<AccessibilityWindowInfo> windows = new ArrayList<AccessibilityWindowInfo>();
            int windowCount = this.mSecurityPolicy.mWindows.size();
            for (int i = 0; i < windowCount; ++i) {
                AccessibilityWindowInfo window = this.mSecurityPolicy.mWindows.get(i);
                AccessibilityWindowInfo windowClone = AccessibilityWindowInfo.obtain(window);
                windowClone.setConnectionId(this.mId);
                windows.add(windowClone);
            }
            return windows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccessibilityWindowInfo getWindow(int windowId) {
        this.mSystemSupport.ensureWindowsAvailableTimed();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledForCurrentUserLocked()) {
                return null;
            }
            boolean permissionGranted = this.mSecurityPolicy.canRetrieveWindowsLocked(this);
            if (!permissionGranted) {
                return null;
            }
            if (!this.mSecurityPolicy.checkAccessibilityAccess(this)) {
                return null;
            }
            AccessibilityWindowInfo window = this.mSecurityPolicy.findA11yWindowInfoById(windowId);
            if (window != null) {
                AccessibilityWindowInfo windowClone = AccessibilityWindowInfo.obtain(window);
                windowClone.setConnectionId(this.mId);
                return windowClone;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findAccessibilityNodeInfosByViewId(int accessibilityWindowId, long accessibilityNodeId, String viewIdResName, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
        MagnificationSpec spec;
        AccessibilityManagerService.RemoteAccessibilityConnection connection;
        int resolvedWindowId;
        Region partialInteractiveRegion = Region.obtain();
        Object object = this.mLock;
        synchronized (object) {
            this.mUsesAccessibilityCache = true;
            if (!this.isCalledForCurrentUserLocked()) {
                return null;
            }
            resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
            boolean permissionGranted = this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
            if (!permissionGranted) {
                return null;
            }
            connection = this.mSystemSupport.getConnectionLocked(resolvedWindowId);
            if (connection == null) {
                return null;
            }
            if (!this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                partialInteractiveRegion.recycle();
                partialInteractiveRegion = null;
            }
            spec = this.mSystemSupport.getCompatibleMagnificationSpecLocked(resolvedWindowId);
        }
        if (!this.mSecurityPolicy.checkAccessibilityAccess(this)) {
            return null;
        }
        int interrogatingPid = Binder.getCallingPid();
        callback = this.mSystemSupport.replaceCallbackIfNeeded(callback, resolvedWindowId, interactionId, interrogatingPid, interrogatingTid);
        long identityToken = Binder.clearCallingIdentity();
        try {
            connection.getRemote().findAccessibilityNodeInfosByViewId(accessibilityNodeId, viewIdResName, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
            String[] stringArray = this.mSecurityPolicy.computeValidReportedPackages(connection.getPackageName(), connection.getUid());
            return stringArray;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
            if (partialInteractiveRegion != null && Binder.isProxy(connection.getRemote())) {
                partialInteractiveRegion.recycle();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findAccessibilityNodeInfosByText(int accessibilityWindowId, long accessibilityNodeId, String text, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
        MagnificationSpec spec;
        AccessibilityManagerService.RemoteAccessibilityConnection connection;
        int resolvedWindowId;
        Region partialInteractiveRegion = Region.obtain();
        Object object = this.mLock;
        synchronized (object) {
            this.mUsesAccessibilityCache = true;
            if (!this.isCalledForCurrentUserLocked()) {
                return null;
            }
            resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
            boolean permissionGranted = this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
            if (!permissionGranted) {
                return null;
            }
            connection = this.mSystemSupport.getConnectionLocked(resolvedWindowId);
            if (connection == null) {
                return null;
            }
            if (!this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                partialInteractiveRegion.recycle();
                partialInteractiveRegion = null;
            }
            spec = this.mSystemSupport.getCompatibleMagnificationSpecLocked(resolvedWindowId);
        }
        if (!this.mSecurityPolicy.checkAccessibilityAccess(this)) {
            return null;
        }
        int interrogatingPid = Binder.getCallingPid();
        callback = this.mSystemSupport.replaceCallbackIfNeeded(callback, resolvedWindowId, interactionId, interrogatingPid, interrogatingTid);
        long identityToken = Binder.clearCallingIdentity();
        try {
            connection.getRemote().findAccessibilityNodeInfosByText(accessibilityNodeId, text, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
            String[] stringArray = this.mSecurityPolicy.computeValidReportedPackages(connection.getPackageName(), connection.getUid());
            return stringArray;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
            if (partialInteractiveRegion != null && Binder.isProxy(connection.getRemote())) {
                partialInteractiveRegion.recycle();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findAccessibilityNodeInfoByAccessibilityId(int accessibilityWindowId, long accessibilityNodeId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, long interrogatingTid, Bundle arguments) throws RemoteException {
        MagnificationSpec spec;
        AccessibilityManagerService.RemoteAccessibilityConnection connection;
        int resolvedWindowId;
        Region partialInteractiveRegion = Region.obtain();
        Object object = this.mLock;
        synchronized (object) {
            this.mUsesAccessibilityCache = true;
            if (!this.isCalledForCurrentUserLocked()) {
                return null;
            }
            resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
            boolean permissionGranted = this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
            if (!permissionGranted) {
                return null;
            }
            connection = this.mSystemSupport.getConnectionLocked(resolvedWindowId);
            if (connection == null) {
                return null;
            }
            if (!this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                partialInteractiveRegion.recycle();
                partialInteractiveRegion = null;
            }
            spec = this.mSystemSupport.getCompatibleMagnificationSpecLocked(resolvedWindowId);
        }
        if (!this.mSecurityPolicy.checkAccessibilityAccess(this)) {
            return null;
        }
        int interrogatingPid = Binder.getCallingPid();
        callback = this.mSystemSupport.replaceCallbackIfNeeded(callback, resolvedWindowId, interactionId, interrogatingPid, interrogatingTid);
        long identityToken = Binder.clearCallingIdentity();
        try {
            connection.getRemote().findAccessibilityNodeInfoByAccessibilityId(accessibilityNodeId, partialInteractiveRegion, interactionId, callback, this.mFetchFlags | flags, interrogatingPid, interrogatingTid, spec, arguments);
            String[] stringArray = this.mSecurityPolicy.computeValidReportedPackages(connection.getPackageName(), connection.getUid());
            return stringArray;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
            if (partialInteractiveRegion != null && Binder.isProxy(connection.getRemote())) {
                partialInteractiveRegion.recycle();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findFocus(int accessibilityWindowId, long accessibilityNodeId, int focusType, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
        MagnificationSpec spec;
        AccessibilityManagerService.RemoteAccessibilityConnection connection;
        int resolvedWindowId;
        Region partialInteractiveRegion = Region.obtain();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledForCurrentUserLocked()) {
                return null;
            }
            resolvedWindowId = this.resolveAccessibilityWindowIdForFindFocusLocked(accessibilityWindowId, focusType);
            boolean permissionGranted = this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
            if (!permissionGranted) {
                return null;
            }
            connection = this.mSystemSupport.getConnectionLocked(resolvedWindowId);
            if (connection == null) {
                return null;
            }
            if (!this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                partialInteractiveRegion.recycle();
                partialInteractiveRegion = null;
            }
            spec = this.mSystemSupport.getCompatibleMagnificationSpecLocked(resolvedWindowId);
        }
        if (!this.mSecurityPolicy.checkAccessibilityAccess(this)) {
            return null;
        }
        int interrogatingPid = Binder.getCallingPid();
        callback = this.mSystemSupport.replaceCallbackIfNeeded(callback, resolvedWindowId, interactionId, interrogatingPid, interrogatingTid);
        long identityToken = Binder.clearCallingIdentity();
        try {
            connection.getRemote().findFocus(accessibilityNodeId, focusType, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
            String[] stringArray = this.mSecurityPolicy.computeValidReportedPackages(connection.getPackageName(), connection.getUid());
            return stringArray;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
            if (partialInteractiveRegion != null && Binder.isProxy(connection.getRemote())) {
                partialInteractiveRegion.recycle();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] focusSearch(int accessibilityWindowId, long accessibilityNodeId, int direction, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
        MagnificationSpec spec;
        AccessibilityManagerService.RemoteAccessibilityConnection connection;
        int resolvedWindowId;
        Region partialInteractiveRegion = Region.obtain();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledForCurrentUserLocked()) {
                return null;
            }
            resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
            boolean permissionGranted = this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
            if (!permissionGranted) {
                return null;
            }
            connection = this.mSystemSupport.getConnectionLocked(resolvedWindowId);
            if (connection == null) {
                return null;
            }
            if (!this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                partialInteractiveRegion.recycle();
                partialInteractiveRegion = null;
            }
            spec = this.mSystemSupport.getCompatibleMagnificationSpecLocked(resolvedWindowId);
        }
        if (!this.mSecurityPolicy.checkAccessibilityAccess(this)) {
            return null;
        }
        int interrogatingPid = Binder.getCallingPid();
        callback = this.mSystemSupport.replaceCallbackIfNeeded(callback, resolvedWindowId, interactionId, interrogatingPid, interrogatingTid);
        long identityToken = Binder.clearCallingIdentity();
        try {
            connection.getRemote().focusSearch(accessibilityNodeId, direction, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
            String[] stringArray = this.mSecurityPolicy.computeValidReportedPackages(connection.getPackageName(), connection.getUid());
            return stringArray;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
            if (partialInteractiveRegion != null && Binder.isProxy(connection.getRemote())) {
                partialInteractiveRegion.recycle();
            }
        }
        return null;
    }

    @Override
    public void sendGesture(int sequence, ParceledListSlice gestureSteps) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performAccessibilityAction(int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
        int resolvedWindowId;
        Object connection = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledForCurrentUserLocked()) {
                return false;
            }
            resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
            if (!this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId)) {
                return false;
            }
        }
        if (!this.mSecurityPolicy.checkAccessibilityAccess(this)) {
            return false;
        }
        boolean returnValue = this.mSystemSupport.performAccessibilityAction(resolvedWindowId, accessibilityNodeId, action, arguments, interactionId, callback, this.mFetchFlags, interrogatingTid);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performGlobalAction(int action) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledForCurrentUserLocked()) {
                return false;
            }
        }
        return this.mGlobalActionPerformer.performGlobalAction(action);
    }

    @Override
    public boolean isFingerprintGestureDetectionAvailable() {
        if (!this.mContext.getPackageManager().hasSystemFeature("android.hardware.fingerprint")) {
            return false;
        }
        if (this.isCapturingFingerprintGestures()) {
            FingerprintGestureDispatcher dispatcher = this.mSystemSupport.getFingerprintGestureDispatcher();
            return dispatcher != null && dispatcher.isFingerprintGestureDetectionAvailable();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getMagnificationScale(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledForCurrentUserLocked()) {
                return 1.0f;
            }
        }
        long identity = Binder.clearCallingIdentity();
        try {
            float f = this.mSystemSupport.getMagnificationController().getScale(displayId);
            return f;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getMagnificationRegion(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            Region region;
            Region region2 = Region.obtain();
            if (!this.isCalledForCurrentUserLocked()) {
                return region2;
            }
            MagnificationController magnificationController = this.mSystemSupport.getMagnificationController();
            boolean registeredJustForThisCall = this.registerMagnificationIfNeeded(displayId, magnificationController);
            long identity = Binder.clearCallingIdentity();
            try {
                magnificationController.getMagnificationRegion(displayId, region2);
                region = region2;
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(identity);
                if (registeredJustForThisCall) {
                    magnificationController.unregister(displayId);
                }
                throw throwable;
            }
            Binder.restoreCallingIdentity(identity);
            if (registeredJustForThisCall) {
                magnificationController.unregister(displayId);
            }
            return region;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getMagnificationCenterX(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            float f;
            if (!this.isCalledForCurrentUserLocked()) {
                return 0.0f;
            }
            MagnificationController magnificationController = this.mSystemSupport.getMagnificationController();
            boolean registeredJustForThisCall = this.registerMagnificationIfNeeded(displayId, magnificationController);
            long identity = Binder.clearCallingIdentity();
            try {
                f = magnificationController.getCenterX(displayId);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(identity);
                if (registeredJustForThisCall) {
                    magnificationController.unregister(displayId);
                }
                throw throwable;
            }
            Binder.restoreCallingIdentity(identity);
            if (registeredJustForThisCall) {
                magnificationController.unregister(displayId);
            }
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getMagnificationCenterY(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            float f;
            if (!this.isCalledForCurrentUserLocked()) {
                return 0.0f;
            }
            MagnificationController magnificationController = this.mSystemSupport.getMagnificationController();
            boolean registeredJustForThisCall = this.registerMagnificationIfNeeded(displayId, magnificationController);
            long identity = Binder.clearCallingIdentity();
            try {
                f = magnificationController.getCenterY(displayId);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(identity);
                if (registeredJustForThisCall) {
                    magnificationController.unregister(displayId);
                }
                throw throwable;
            }
            Binder.restoreCallingIdentity(identity);
            if (registeredJustForThisCall) {
                magnificationController.unregister(displayId);
            }
            return f;
        }
    }

    private boolean registerMagnificationIfNeeded(int displayId, MagnificationController magnificationController) {
        if (!magnificationController.isRegistered(displayId) && this.mSecurityPolicy.canControlMagnification(this)) {
            magnificationController.register(displayId);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetMagnification(int displayId, boolean animate) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isCalledForCurrentUserLocked()) {
                return false;
            }
            if (!this.mSecurityPolicy.canControlMagnification(this)) {
                return false;
            }
        }
        long identity = Binder.clearCallingIdentity();
        try {
            MagnificationController magnificationController = this.mSystemSupport.getMagnificationController();
            boolean bl = magnificationController.reset(displayId, animate) || !magnificationController.isMagnifying(displayId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setMagnificationScaleAndCenter(int displayId, float scale, float centerX, float centerY, boolean animate) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            if (!this.isCalledForCurrentUserLocked()) {
                return false;
            }
            if (!this.mSecurityPolicy.canControlMagnification(this)) {
                return false;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                MagnificationController magnificationController = this.mSystemSupport.getMagnificationController();
                if (!magnificationController.isRegistered(displayId)) {
                    magnificationController.register(displayId);
                }
                bl = magnificationController.setScaleAndCenter(displayId, scale, centerX, centerY, animate, this.mId);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(identity);
                throw throwable;
            }
            Binder.restoreCallingIdentity(identity);
            return bl;
        }
    }

    @Override
    public void setMagnificationCallbackEnabled(int displayId, boolean enabled) {
        this.mInvocationHandler.setMagnificationCallbackEnabled(displayId, enabled);
    }

    public boolean isMagnificationCallbackEnabled(int displayId) {
        return this.mInvocationHandler.isMagnificationCallbackEnabled(displayId);
    }

    @Override
    public void setSoftKeyboardCallbackEnabled(boolean enabled) {
        this.mInvocationHandler.setSoftKeyboardCallbackEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, LOG_TAG, pw)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.append("Service[label=" + this.mAccessibilityServiceInfo.getResolveInfo().loadLabel(this.mContext.getPackageManager()));
            pw.append(", feedbackType" + AccessibilityServiceInfo.feedbackTypeToString(this.mFeedbackType));
            pw.append(", capabilities=" + this.mAccessibilityServiceInfo.getCapabilities());
            pw.append(", eventTypes=" + AccessibilityEvent.eventTypeToString(this.mEventTypes));
            pw.append(", notificationTimeout=" + this.mNotificationTimeout);
            pw.append("]");
        }
    }

    public void onAdded() {
        long identity = Binder.clearCallingIdentity();
        try {
            this.mWindowManagerService.addWindowToken(this.mOverlayWindowToken, 2032, 0);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public void onRemoved() {
        long identity = Binder.clearCallingIdentity();
        try {
            this.mWindowManagerService.removeWindowToken(this.mOverlayWindowToken, true, 0);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public void resetLocked() {
        this.mSystemSupport.getKeyEventDispatcher().flush(this);
        try {
            if (this.mServiceInterface != null) {
                this.mServiceInterface.init(null, this.mId, null);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mService != null) {
            this.mService.unlinkToDeath(this, 0);
            this.mService = null;
        }
        this.mServiceInterface = null;
        this.mReceivedAccessibilityButtonCallbackSinceBind = false;
    }

    public boolean isConnectedLocked() {
        return this.mService != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAccessibilityEvent(AccessibilityEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            Message message;
            boolean requiredForCacheConsistency;
            int eventType = event.getEventType();
            boolean serviceWantsEvent = this.wantsEventLocked(event);
            boolean bl = requiredForCacheConsistency = this.mUsesAccessibilityCache && (0x41B83D & eventType) != 0;
            if (!serviceWantsEvent && !requiredForCacheConsistency) {
                return;
            }
            if (!this.mSecurityPolicy.checkAccessibilityAccess(this)) {
                return;
            }
            AccessibilityEvent newEvent = AccessibilityEvent.obtain(event);
            if (this.mNotificationTimeout > 0L && eventType != 2048) {
                AccessibilityEvent oldEvent = this.mPendingEvents.get(eventType);
                this.mPendingEvents.put(eventType, newEvent);
                if (oldEvent != null) {
                    this.mEventDispatchHandler.removeMessages(eventType);
                    oldEvent.recycle();
                }
                message = this.mEventDispatchHandler.obtainMessage(eventType);
            } else {
                message = this.mEventDispatchHandler.obtainMessage(eventType, newEvent);
            }
            message.arg1 = serviceWantsEvent ? 1 : 0;
            this.mEventDispatchHandler.sendMessageDelayed(message, this.mNotificationTimeout);
        }
    }

    private boolean wantsEventLocked(AccessibilityEvent event) {
        if (!this.canReceiveEventsLocked()) {
            return false;
        }
        if (event.getWindowId() != -1 && !event.isImportantForAccessibility() && (this.mFetchFlags & 8) == 0) {
            return false;
        }
        int eventType = event.getEventType();
        if ((this.mEventTypes & eventType) != eventType) {
            return false;
        }
        Set<String> packageNames = this.mPackageNames;
        String packageName = event.getPackageName() != null ? event.getPackageName().toString() : null;
        return packageNames.isEmpty() || packageNames.contains(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAccessibilityEventInternal(int eventType, AccessibilityEvent event, boolean serviceWantsEvent) {
        IAccessibilityServiceClient listener;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mServiceInterface;
            if (listener == null) {
                return;
            }
            if (event == null) {
                event = this.mPendingEvents.get(eventType);
                if (event == null) {
                    return;
                }
                this.mPendingEvents.remove(eventType);
            }
            if (this.mSecurityPolicy.canRetrieveWindowContentLocked(this)) {
                event.setConnectionId(this.mId);
            } else {
                event.setSource(null);
            }
            event.setSealed(true);
        }
        try {
            listener.onAccessibilityEvent(event, serviceWantsEvent);
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Error during sending " + event + " to " + listener, re);
        }
        finally {
            event.recycle();
        }
    }

    public void notifyGesture(int gestureId) {
        this.mInvocationHandler.obtainMessage(1, gestureId, 0).sendToTarget();
    }

    public void notifyClearAccessibilityNodeInfoCache() {
        this.mInvocationHandler.sendEmptyMessage(2);
    }

    public void notifyMagnificationChangedLocked(int displayId, Region region, float scale, float centerX, float centerY) {
        this.mInvocationHandler.notifyMagnificationChangedLocked(displayId, region, scale, centerX, centerY);
    }

    public void notifySoftKeyboardShowModeChangedLocked(int showState) {
        this.mInvocationHandler.notifySoftKeyboardShowModeChangedLocked(showState);
    }

    public void notifyAccessibilityButtonClickedLocked() {
        this.mInvocationHandler.notifyAccessibilityButtonClickedLocked();
    }

    public void notifyAccessibilityButtonAvailabilityChangedLocked(boolean available) {
        this.mInvocationHandler.notifyAccessibilityButtonAvailabilityChangedLocked(available);
    }

    private void notifyMagnificationChangedInternal(int displayId, Region region, float scale, float centerX, float centerY) {
        IAccessibilityServiceClient listener = this.getServiceInterfaceSafely();
        if (listener != null) {
            try {
                listener.onMagnificationChanged(displayId, region, scale, centerX, centerY);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error sending magnification changes to " + this.mService, re);
            }
        }
    }

    private void notifySoftKeyboardShowModeChangedInternal(int showState) {
        IAccessibilityServiceClient listener = this.getServiceInterfaceSafely();
        if (listener != null) {
            try {
                listener.onSoftKeyboardShowModeChanged(showState);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error sending soft keyboard show mode changes to " + this.mService, re);
            }
        }
    }

    private void notifyAccessibilityButtonClickedInternal() {
        IAccessibilityServiceClient listener = this.getServiceInterfaceSafely();
        if (listener != null) {
            try {
                listener.onAccessibilityButtonClicked();
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error sending accessibility button click to " + this.mService, re);
            }
        }
    }

    private void notifyAccessibilityButtonAvailabilityChangedInternal(boolean available) {
        if (this.mReceivedAccessibilityButtonCallbackSinceBind && this.mLastAccessibilityButtonCallbackState == available) {
            return;
        }
        this.mReceivedAccessibilityButtonCallbackSinceBind = true;
        this.mLastAccessibilityButtonCallbackState = available;
        IAccessibilityServiceClient listener = this.getServiceInterfaceSafely();
        if (listener != null) {
            try {
                listener.onAccessibilityButtonAvailabilityChanged(available);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error sending accessibility button availability change to " + this.mService, re);
            }
        }
    }

    private void notifyGestureInternal(int gestureId) {
        IAccessibilityServiceClient listener = this.getServiceInterfaceSafely();
        if (listener != null) {
            try {
                listener.onGesture(gestureId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error during sending gesture " + gestureId + " to " + this.mService, re);
            }
        }
    }

    private void notifyClearAccessibilityCacheInternal() {
        IAccessibilityServiceClient listener = this.getServiceInterfaceSafely();
        if (listener != null) {
            try {
                listener.clearAccessibilityCache();
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error during requesting accessibility info cache to be cleared.", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAccessibilityServiceClient getServiceInterfaceSafely() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mServiceInterface;
        }
    }

    private int resolveAccessibilityWindowIdLocked(int accessibilityWindowId) {
        if (accessibilityWindowId == Integer.MAX_VALUE) {
            return this.mSecurityPolicy.getActiveWindowId();
        }
        return accessibilityWindowId;
    }

    private int resolveAccessibilityWindowIdForFindFocusLocked(int windowId, int focusType) {
        if (windowId == Integer.MAX_VALUE) {
            return this.mSecurityPolicy.mActiveWindowId;
        }
        if (windowId == -2) {
            if (focusType == 1) {
                return this.mSecurityPolicy.mFocusedWindowId;
            }
            if (focusType == 2) {
                return this.mSecurityPolicy.mAccessibilityFocusedWindowId;
            }
        }
        return windowId;
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    private final class InvocationHandler
    extends Handler {
        public static final int MSG_ON_GESTURE = 1;
        public static final int MSG_CLEAR_ACCESSIBILITY_CACHE = 2;
        private static final int MSG_ON_MAGNIFICATION_CHANGED = 5;
        private static final int MSG_ON_SOFT_KEYBOARD_STATE_CHANGED = 6;
        private static final int MSG_ON_ACCESSIBILITY_BUTTON_CLICKED = 7;
        private static final int MSG_ON_ACCESSIBILITY_BUTTON_AVAILABILITY_CHANGED = 8;
        @GuardedBy(value={"mlock"})
        private final SparseArray<Boolean> mMagnificationCallbackState;
        private boolean mIsSoftKeyboardCallbackEnabled;

        public InvocationHandler(Looper looper) {
            super(looper, null, true);
            this.mMagnificationCallbackState = new SparseArray(0);
            this.mIsSoftKeyboardCallbackEnabled = false;
        }

        @Override
        public void handleMessage(Message message) {
            int type = message.what;
            switch (type) {
                case 1: {
                    int gestureId = message.arg1;
                    AbstractAccessibilityServiceConnection.this.notifyGestureInternal(gestureId);
                    break;
                }
                case 2: {
                    AbstractAccessibilityServiceConnection.this.notifyClearAccessibilityCacheInternal();
                    break;
                }
                case 5: {
                    SomeArgs args = (SomeArgs)message.obj;
                    Region region = (Region)args.arg1;
                    float scale = ((Float)args.arg2).floatValue();
                    float centerX = ((Float)args.arg3).floatValue();
                    float centerY = ((Float)args.arg4).floatValue();
                    int displayId = args.argi1;
                    AbstractAccessibilityServiceConnection.this.notifyMagnificationChangedInternal(displayId, region, scale, centerX, centerY);
                    args.recycle();
                    break;
                }
                case 6: {
                    int showState = message.arg1;
                    AbstractAccessibilityServiceConnection.this.notifySoftKeyboardShowModeChangedInternal(showState);
                    break;
                }
                case 7: {
                    AbstractAccessibilityServiceConnection.this.notifyAccessibilityButtonClickedInternal();
                    break;
                }
                case 8: {
                    boolean available = message.arg1 != 0;
                    AbstractAccessibilityServiceConnection.this.notifyAccessibilityButtonAvailabilityChangedInternal(available);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message: " + type);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyMagnificationChangedLocked(int displayId, Region region, float scale, float centerX, float centerY) {
            Object object = AbstractAccessibilityServiceConnection.this.mLock;
            synchronized (object) {
                if (this.mMagnificationCallbackState.get(displayId) == null) {
                    return;
                }
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = region;
            args.arg2 = Float.valueOf(scale);
            args.arg3 = Float.valueOf(centerX);
            args.arg4 = Float.valueOf(centerY);
            args.argi1 = displayId;
            Message msg = this.obtainMessage(5, args);
            msg.sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMagnificationCallbackEnabled(int displayId, boolean enabled) {
            Object object = AbstractAccessibilityServiceConnection.this.mLock;
            synchronized (object) {
                if (enabled) {
                    this.mMagnificationCallbackState.put(displayId, true);
                } else {
                    this.mMagnificationCallbackState.remove(displayId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMagnificationCallbackEnabled(int displayId) {
            Object object = AbstractAccessibilityServiceConnection.this.mLock;
            synchronized (object) {
                return this.mMagnificationCallbackState.get(displayId) != null;
            }
        }

        public void notifySoftKeyboardShowModeChangedLocked(int showState) {
            if (!this.mIsSoftKeyboardCallbackEnabled) {
                return;
            }
            Message msg = this.obtainMessage(6, showState, 0);
            msg.sendToTarget();
        }

        public void setSoftKeyboardCallbackEnabled(boolean enabled) {
            this.mIsSoftKeyboardCallbackEnabled = enabled;
        }

        public void notifyAccessibilityButtonClickedLocked() {
            Message msg = this.obtainMessage(7);
            msg.sendToTarget();
        }

        public void notifyAccessibilityButtonAvailabilityChangedLocked(boolean available) {
            Message msg = this.obtainMessage(8, available ? 1 : 0, 0);
            msg.sendToTarget();
        }
    }

    public static interface SystemSupport {
        public KeyEventDispatcher getKeyEventDispatcher();

        public MagnificationSpec getCompatibleMagnificationSpecLocked(int var1);

        public MotionEventInjector getMotionEventInjectorLocked();

        public FingerprintGestureDispatcher getFingerprintGestureDispatcher();

        public MagnificationController getMagnificationController();

        public AccessibilityManagerService.RemoteAccessibilityConnection getConnectionLocked(int var1);

        public boolean performAccessibilityAction(int var1, long var2, int var4, Bundle var5, int var6, IAccessibilityInteractionConnectionCallback var7, int var8, long var9);

        public IAccessibilityInteractionConnectionCallback replaceCallbackIfNeeded(IAccessibilityInteractionConnectionCallback var1, int var2, int var3, int var4, long var5);

        public void ensureWindowsAvailableTimed();

        public void onClientChangeLocked(boolean var1);

        public int getCurrentUserIdLocked();

        public boolean isAccessibilityButtonShown();

        public void persistComponentNamesToSettingLocked(String var1, Set<ComponentName> var2, int var3);

        public PendingIntent getPendingIntentActivity(Context var1, int var2, Intent var3, int var4);
    }
}

