/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.Context;
import android.gesture.GesturePoint;
import android.graphics.PointF;
import android.util.Slog;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import java.util.ArrayList;

class AccessibilityGestureDetector
extends GestureDetector.SimpleOnGestureListener {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityGestureDetector";
    private static final float MIN_INCHES_BETWEEN_SAMPLES = 0.1f;
    private final float mMinPixelsBetweenSamplesX;
    private final float mMinPixelsBetweenSamplesY;
    private static final float ANGLE_THRESHOLD = 0.0f;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int UP = 2;
    private static final int DOWN = 3;
    private static final int[][] DIRECTIONS_TO_GESTURE_ID = new int[][]{{3, 5, 9, 10}, {6, 4, 11, 12}, {13, 14, 1, 7}, {15, 16, 8, 2}};
    private final Listener mListener;
    private final Context mContext;
    private final GestureDetector mGestureDetector;
    private boolean mFirstTapDetected;
    private boolean mDoubleTapDetected;
    private boolean mRecognizingGesture;
    private boolean mGestureStarted;
    private boolean mSecondFingerDoubleTap;
    private long mSecondPointerDownTime;
    private int mPolicyFlags;
    private float mPreviousGestureX;
    private float mPreviousGestureY;
    private float mBaseX;
    private float mBaseY;
    private long mBaseTime;
    private final float mGestureDetectionThreshold;
    private final ArrayList<GesturePoint> mStrokeBuffer = new ArrayList(100);
    private static final int TOUCH_TOLERANCE = 3;
    private static final float MIN_PREDICTION_SCORE = 2.0f;
    private static final int GESTURE_CONFIRM_MM = 10;
    private static final long CANCEL_ON_PAUSE_THRESHOLD_NOT_STARTED_MS = 150L;
    private static final long CANCEL_ON_PAUSE_THRESHOLD_STARTED_MS = 300L;

    AccessibilityGestureDetector(Context context, Listener listener) {
        this(context, listener, null);
    }

    AccessibilityGestureDetector(Context context, Listener listener, GestureDetector detector) {
        this.mListener = listener;
        this.mContext = context;
        this.mGestureDetector = detector == null ? new GestureDetector(context, this) : detector;
        this.mGestureDetector.setOnDoubleTapListener(this);
        this.mGestureDetectionThreshold = TypedValue.applyDimension(5, 1.0f, context.getResources().getDisplayMetrics()) * 10.0f;
        float pixelsPerInchX = context.getResources().getDisplayMetrics().xdpi;
        float pixelsPerInchY = context.getResources().getDisplayMetrics().ydpi;
        this.mMinPixelsBetweenSamplesX = 0.1f * pixelsPerInchX;
        this.mMinPixelsBetweenSamplesY = 0.1f * pixelsPerInchY;
    }

    public boolean onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        float x = rawEvent.getX();
        float y = rawEvent.getY();
        long time = rawEvent.getEventTime();
        this.mPolicyFlags = policyFlags;
        switch (rawEvent.getActionMasked()) {
            case 0: {
                this.mDoubleTapDetected = false;
                this.mSecondFingerDoubleTap = false;
                this.mRecognizingGesture = true;
                this.mGestureStarted = false;
                this.mPreviousGestureX = x;
                this.mPreviousGestureY = y;
                this.mStrokeBuffer.clear();
                this.mStrokeBuffer.add(new GesturePoint(x, y, time));
                this.mBaseX = x;
                this.mBaseY = y;
                this.mBaseTime = time;
                break;
            }
            case 2: {
                if (!this.mRecognizingGesture) break;
                float deltaX = this.mBaseX - x;
                float deltaY = this.mBaseY - y;
                double moveDelta = Math.hypot(deltaX, deltaY);
                if (moveDelta > (double)this.mGestureDetectionThreshold) {
                    this.mBaseX = x;
                    this.mBaseY = y;
                    this.mBaseTime = time;
                    this.mFirstTapDetected = false;
                    this.mDoubleTapDetected = false;
                    if (!this.mGestureStarted) {
                        this.mGestureStarted = true;
                        return this.mListener.onGestureStarted();
                    }
                } else if (!this.mFirstTapDetected) {
                    long threshold;
                    long timeDelta = time - this.mBaseTime;
                    long l = threshold = this.mGestureStarted ? 300L : 150L;
                    if (timeDelta > threshold) {
                        this.cancelGesture();
                        return this.mListener.onGestureCancelled(rawEvent, policyFlags);
                    }
                }
                float dX = Math.abs(x - this.mPreviousGestureX);
                float dY = Math.abs(y - this.mPreviousGestureY);
                if (!(dX >= this.mMinPixelsBetweenSamplesX) && !(dY >= this.mMinPixelsBetweenSamplesY)) break;
                this.mPreviousGestureX = x;
                this.mPreviousGestureY = y;
                this.mStrokeBuffer.add(new GesturePoint(x, y, time));
                break;
            }
            case 1: {
                if (this.mDoubleTapDetected) {
                    return this.finishDoubleTap(rawEvent, policyFlags);
                }
                if (!this.mGestureStarted) break;
                float dX = Math.abs(x - this.mPreviousGestureX);
                float dY = Math.abs(y - this.mPreviousGestureY);
                if (dX >= this.mMinPixelsBetweenSamplesX || dY >= this.mMinPixelsBetweenSamplesY) {
                    this.mStrokeBuffer.add(new GesturePoint(x, y, time));
                }
                return this.recognizeGesture(rawEvent, policyFlags);
            }
            case 5: {
                this.cancelGesture();
                if (rawEvent.getPointerCount() == 2) {
                    this.mSecondFingerDoubleTap = true;
                    this.mSecondPointerDownTime = time;
                    break;
                }
                this.mSecondFingerDoubleTap = false;
                break;
            }
            case 6: {
                if (!this.mSecondFingerDoubleTap || !this.mDoubleTapDetected) break;
                return this.finishDoubleTap(rawEvent, policyFlags);
            }
            case 3: {
                this.clear();
            }
        }
        if (this.mSecondFingerDoubleTap) {
            MotionEvent newEvent = this.mapSecondPointerToFirstPointer(rawEvent);
            if (newEvent == null) {
                return false;
            }
            boolean handled = this.mGestureDetector.onTouchEvent(newEvent);
            newEvent.recycle();
            return handled;
        }
        if (!this.mRecognizingGesture) {
            return false;
        }
        return this.mGestureDetector.onTouchEvent(event);
    }

    public void clear() {
        this.mFirstTapDetected = false;
        this.mDoubleTapDetected = false;
        this.mSecondFingerDoubleTap = false;
        this.mGestureStarted = false;
        this.mGestureDetector.onTouchEvent(MotionEvent.obtain(0L, 0L, 3, 0.0f, 0.0f, 0));
        this.cancelGesture();
    }

    public boolean firstTapDetected() {
        return this.mFirstTapDetected;
    }

    @Override
    public void onLongPress(MotionEvent e) {
        this.maybeSendLongPress(e, this.mPolicyFlags);
    }

    @Override
    public boolean onSingleTapUp(MotionEvent event) {
        this.mFirstTapDetected = true;
        return false;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event) {
        this.clear();
        return false;
    }

    @Override
    public boolean onDoubleTap(MotionEvent event) {
        this.mDoubleTapDetected = true;
        return false;
    }

    private void maybeSendLongPress(MotionEvent event, int policyFlags) {
        if (!this.mDoubleTapDetected) {
            return;
        }
        this.clear();
        this.mListener.onDoubleTapAndHold(event, policyFlags);
    }

    private boolean finishDoubleTap(MotionEvent event, int policyFlags) {
        this.clear();
        return this.mListener.onDoubleTap(event, policyFlags);
    }

    private void cancelGesture() {
        this.mRecognizingGesture = false;
        this.mGestureStarted = false;
        this.mStrokeBuffer.clear();
    }

    private boolean recognizeGesture(MotionEvent event, int policyFlags) {
        if (this.mStrokeBuffer.size() < 2) {
            return this.mListener.onGestureCancelled(event, policyFlags);
        }
        ArrayList<PointF> path = new ArrayList<PointF>();
        PointF lastDelimiter = new PointF(this.mStrokeBuffer.get((int)0).x, this.mStrokeBuffer.get((int)0).y);
        path.add(lastDelimiter);
        float dX = 0.0f;
        float dY = 0.0f;
        int count = 0;
        float length = 0.0f;
        PointF next = new PointF();
        for (int i = 1; i < this.mStrokeBuffer.size(); ++i) {
            float currentDY;
            float currentDX;
            next = new PointF(this.mStrokeBuffer.get((int)i).x, this.mStrokeBuffer.get((int)i).y);
            if (count > 0) {
                float nextLength;
                float dot;
                currentDX = dX / (float)count;
                currentDY = dY / (float)count;
                PointF newDelimiter = new PointF(length * currentDX + lastDelimiter.x, length * currentDY + lastDelimiter.y);
                float nextDX = next.x - newDelimiter.x;
                float nextDY = next.y - newDelimiter.y;
                if ((dot = currentDX * (nextDX /= (nextLength = (float)Math.sqrt(nextDX * nextDX + nextDY * nextDY))) + currentDY * (nextDY /= nextLength)) < 0.0f) {
                    path.add(newDelimiter);
                    lastDelimiter = newDelimiter;
                    dX = 0.0f;
                    dY = 0.0f;
                    count = 0;
                }
            }
            currentDX = next.x - lastDelimiter.x;
            currentDY = next.y - lastDelimiter.y;
            length = (float)Math.sqrt(currentDX * currentDX + currentDY * currentDY);
            ++count;
            dX += currentDX / length;
            dY += currentDY / length;
        }
        path.add(next);
        Slog.i(LOG_TAG, "path=" + path.toString());
        return this.recognizeGesturePath(event, policyFlags, path);
    }

    private boolean recognizeGesturePath(MotionEvent event, int policyFlags, ArrayList<PointF> path) {
        if (path.size() == 2) {
            PointF start = path.get(0);
            PointF end = path.get(1);
            float dX = end.x - start.x;
            float dY = end.y - start.y;
            int direction = AccessibilityGestureDetector.toDirection(dX, dY);
            switch (direction) {
                case 0: {
                    return this.mListener.onGestureCompleted(3);
                }
                case 1: {
                    return this.mListener.onGestureCompleted(4);
                }
                case 2: {
                    return this.mListener.onGestureCompleted(1);
                }
                case 3: {
                    return this.mListener.onGestureCompleted(2);
                }
            }
        } else if (path.size() == 3) {
            PointF start = path.get(0);
            PointF mid = path.get(1);
            PointF end = path.get(2);
            float dX0 = mid.x - start.x;
            float dY0 = mid.y - start.y;
            float dX1 = end.x - mid.x;
            float dY1 = end.y - mid.y;
            int segmentDirection0 = AccessibilityGestureDetector.toDirection(dX0, dY0);
            int segmentDirection1 = AccessibilityGestureDetector.toDirection(dX1, dY1);
            int gestureId = DIRECTIONS_TO_GESTURE_ID[segmentDirection0][segmentDirection1];
            return this.mListener.onGestureCompleted(gestureId);
        }
        return this.mListener.onGestureCancelled(event, policyFlags);
    }

    private static int toDirection(float dX, float dY) {
        if (Math.abs(dX) > Math.abs(dY)) {
            return dX < 0.0f ? 0 : 1;
        }
        return dY < 0.0f ? 2 : 3;
    }

    private MotionEvent mapSecondPointerToFirstPointer(MotionEvent event) {
        if (event.getPointerCount() != 2 || event.getActionMasked() != 5 && event.getActionMasked() != 6 && event.getActionMasked() != 2) {
            return null;
        }
        int action = event.getActionMasked();
        if (action == 5) {
            action = 0;
        } else if (action == 6) {
            action = 1;
        }
        return MotionEvent.obtain(this.mSecondPointerDownTime, event.getEventTime(), action, event.getX(1), event.getY(1), event.getPressure(1), event.getSize(1), event.getMetaState(), event.getXPrecision(), event.getYPrecision(), event.getDeviceId(), event.getEdgeFlags());
    }

    public static interface Listener {
        public void onDoubleTapAndHold(MotionEvent var1, int var2);

        public boolean onDoubleTap(MotionEvent var1, int var2);

        public boolean onGestureStarted();

        public boolean onGestureCompleted(int var1);

        public boolean onGestureCancelled(MotionEvent var1, int var2);
    }
}

