/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.Context;
import android.os.PowerManager;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.Display;
import android.view.InputEvent;
import android.view.InputFilter;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityEvent;
import com.android.server.LocalServices;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accessibility.AutoclickController;
import com.android.server.accessibility.EventStreamTransformation;
import com.android.server.accessibility.KeyboardInterceptor;
import com.android.server.accessibility.MagnificationGestureHandler;
import com.android.server.accessibility.MotionEventInjector;
import com.android.server.accessibility.TouchExplorer;
import com.android.server.policy.WindowManagerPolicy;
import java.util.ArrayList;

class AccessibilityInputFilter
extends InputFilter
implements EventStreamTransformation {
    private static final String TAG = AccessibilityInputFilter.class.getSimpleName();
    private static final boolean DEBUG = false;
    static final int FLAG_FEATURE_SCREEN_MAGNIFIER = 1;
    static final int FLAG_FEATURE_TOUCH_EXPLORATION = 2;
    static final int FLAG_FEATURE_FILTER_KEY_EVENTS = 4;
    static final int FLAG_FEATURE_AUTOCLICK = 8;
    static final int FLAG_FEATURE_INJECT_MOTION_EVENTS = 16;
    static final int FLAG_FEATURE_CONTROL_SCREEN_MAGNIFIER = 32;
    static final int FLAG_FEATURE_TRIGGERED_SCREEN_MAGNIFIER = 64;
    static final int FEATURES_AFFECTING_MOTION_EVENTS = 91;
    private final Context mContext;
    private final PowerManager mPm;
    private final AccessibilityManagerService mAms;
    private final SparseArray<EventStreamTransformation> mEventHandler;
    private final SparseArray<TouchExplorer> mTouchExplorer = new SparseArray(0);
    private final SparseArray<MagnificationGestureHandler> mMagnificationGestureHandler = new SparseArray(0);
    private final SparseArray<MotionEventInjector> mMotionEventInjector = new SparseArray(0);
    private AutoclickController mAutoclickController;
    private KeyboardInterceptor mKeyboardInterceptor;
    private boolean mInstalled;
    private int mUserId;
    private int mEnabledFeatures;
    private EventStreamState mMouseStreamState;
    private EventStreamState mTouchScreenStreamState;
    private EventStreamState mKeyboardStreamState;

    AccessibilityInputFilter(Context context, AccessibilityManagerService service) {
        this(context, service, new SparseArray<EventStreamTransformation>(0));
    }

    AccessibilityInputFilter(Context context, AccessibilityManagerService service, SparseArray<EventStreamTransformation> eventHandler) {
        super(context.getMainLooper());
        this.mContext = context;
        this.mAms = service;
        this.mPm = (PowerManager)context.getSystemService("power");
        this.mEventHandler = eventHandler;
    }

    @Override
    public void onInstalled() {
        this.mInstalled = true;
        this.disableFeatures();
        this.enableFeatures();
        super.onInstalled();
    }

    @Override
    public void onUninstalled() {
        this.mInstalled = false;
        this.disableFeatures();
        super.onUninstalled();
    }

    void onDisplayChanged() {
        if (this.mInstalled) {
            this.disableFeatures();
            this.enableFeatures();
        }
    }

    @Override
    public void onInputEvent(InputEvent event, int policyFlags) {
        if (this.mEventHandler.size() == 0) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        EventStreamState state = this.getEventStreamState(event);
        if (state == null) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        int eventSource = event.getSource();
        if ((policyFlags & 0x40000000) == 0) {
            state.reset();
            this.clearEventsForAllEventHandlers(eventSource);
            super.onInputEvent(event, policyFlags);
            return;
        }
        if (state.updateInputSource(event.getSource())) {
            this.clearEventsForAllEventHandlers(eventSource);
        }
        if (!state.inputSourceValid()) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        if (event instanceof MotionEvent) {
            if ((this.mEnabledFeatures & 0x5B) != 0) {
                MotionEvent motionEvent = (MotionEvent)event;
                this.processMotionEvent(state, motionEvent, policyFlags);
                return;
            }
            super.onInputEvent(event, policyFlags);
        } else if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            this.processKeyEvent(state, keyEvent, policyFlags);
        }
    }

    private EventStreamState getEventStreamState(InputEvent event) {
        if (event instanceof MotionEvent) {
            if (event.isFromSource(4098)) {
                if (this.mTouchScreenStreamState == null) {
                    this.mTouchScreenStreamState = new TouchScreenEventStreamState();
                }
                return this.mTouchScreenStreamState;
            }
            if (event.isFromSource(8194)) {
                if (this.mMouseStreamState == null) {
                    this.mMouseStreamState = new MouseEventStreamState();
                }
                return this.mMouseStreamState;
            }
        } else if (event instanceof KeyEvent && event.isFromSource(257)) {
            if (this.mKeyboardStreamState == null) {
                this.mKeyboardStreamState = new KeyboardEventStreamState();
            }
            return this.mKeyboardStreamState;
        }
        return null;
    }

    private void clearEventsForAllEventHandlers(int eventSource) {
        for (int i = 0; i < this.mEventHandler.size(); ++i) {
            EventStreamTransformation eventHandler = this.mEventHandler.valueAt(i);
            if (eventHandler == null) continue;
            eventHandler.clearEvents(eventSource);
        }
    }

    private void processMotionEvent(EventStreamState state, MotionEvent event, int policyFlags) {
        if (!state.shouldProcessScroll() && event.getActionMasked() == 8) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        if (!state.shouldProcessMotionEvent(event)) {
            return;
        }
        this.handleMotionEvent(event, policyFlags);
    }

    private void processKeyEvent(EventStreamState state, KeyEvent event, int policyFlags) {
        if (!state.shouldProcessKeyEvent(event)) {
            super.onInputEvent(event, policyFlags);
            return;
        }
        this.mEventHandler.get(0).onKeyEvent(event, policyFlags);
    }

    private void handleMotionEvent(MotionEvent event, int policyFlags) {
        this.mPm.userActivity(event.getEventTime(), false);
        MotionEvent transformedEvent = MotionEvent.obtain(event);
        int displayId = event.getDisplayId();
        this.mEventHandler.get(this.isDisplayIdValid(displayId) ? displayId : 0).onMotionEvent(transformedEvent, event, policyFlags);
        transformedEvent.recycle();
    }

    private boolean isDisplayIdValid(int displayId) {
        return this.mEventHandler.get(displayId) != null;
    }

    @Override
    public void onMotionEvent(MotionEvent transformedEvent, MotionEvent rawEvent, int policyFlags) {
        this.sendInputEvent(transformedEvent, policyFlags);
    }

    @Override
    public void onKeyEvent(KeyEvent event, int policyFlags) {
        this.sendInputEvent(event, policyFlags);
    }

    @Override
    public void onAccessibilityEvent(AccessibilityEvent event) {
    }

    @Override
    public void setNext(EventStreamTransformation sink) {
    }

    @Override
    public EventStreamTransformation getNext() {
        return null;
    }

    @Override
    public void clearEvents(int inputSource) {
    }

    void setUserAndEnabledFeatures(int userId, int enabledFeatures) {
        if (this.mEnabledFeatures == enabledFeatures && this.mUserId == userId) {
            return;
        }
        if (this.mInstalled) {
            this.disableFeatures();
        }
        this.mUserId = userId;
        this.mEnabledFeatures = enabledFeatures;
        if (this.mInstalled) {
            this.enableFeatures();
        }
    }

    void notifyAccessibilityEvent(AccessibilityEvent event) {
        for (int i = 0; i < this.mEventHandler.size(); ++i) {
            EventStreamTransformation eventHandler = this.mEventHandler.valueAt(i);
            if (eventHandler == null) continue;
            eventHandler.onAccessibilityEvent(event);
        }
    }

    void notifyAccessibilityButtonClicked(int displayId) {
        MagnificationGestureHandler handler;
        if (this.mMagnificationGestureHandler.size() != 0 && (handler = this.mMagnificationGestureHandler.get(displayId)) != null) {
            handler.notifyShortcutTriggered();
        }
    }

    private void enableFeatures() {
        this.resetStreamState();
        ArrayList<Display> displaysList = this.mAms.getValidDisplayList();
        if ((this.mEnabledFeatures & 8) != 0) {
            this.mAutoclickController = new AutoclickController(this.mContext, this.mUserId);
            this.addFirstEventHandlerForAllDisplays(displaysList, this.mAutoclickController);
        }
        for (int i = displaysList.size() - 1; i >= 0; --i) {
            int displayId = displaysList.get(i).getDisplayId();
            if ((this.mEnabledFeatures & 2) != 0) {
                TouchExplorer explorer = new TouchExplorer(this.mContext, this.mAms);
                this.addFirstEventHandler(displayId, explorer);
                this.mTouchExplorer.put(displayId, explorer);
            }
            if ((this.mEnabledFeatures & 0x20) != 0 || (this.mEnabledFeatures & 1) != 0 || (this.mEnabledFeatures & 0x40) != 0) {
                boolean detectControlGestures = (this.mEnabledFeatures & 1) != 0;
                boolean triggerable = (this.mEnabledFeatures & 0x40) != 0;
                MagnificationGestureHandler magnificationGestureHandler = new MagnificationGestureHandler(this.mContext, this.mAms.getMagnificationController(), detectControlGestures, triggerable, displayId);
                this.addFirstEventHandler(displayId, magnificationGestureHandler);
                this.mMagnificationGestureHandler.put(displayId, magnificationGestureHandler);
            }
            if ((this.mEnabledFeatures & 0x10) == 0) continue;
            MotionEventInjector injector = new MotionEventInjector(this.mContext.getMainLooper());
            this.addFirstEventHandler(displayId, injector);
            this.mAms.setMotionEventInjector(injector);
            this.mMotionEventInjector.put(displayId, injector);
        }
        if ((this.mEnabledFeatures & 4) != 0) {
            this.mKeyboardInterceptor = new KeyboardInterceptor(this.mAms, LocalServices.getService(WindowManagerPolicy.class));
            this.addFirstEventHandler(0, this.mKeyboardInterceptor);
        }
    }

    private void addFirstEventHandler(int displayId, EventStreamTransformation handler) {
        EventStreamTransformation eventHandler = this.mEventHandler.get(displayId);
        if (eventHandler != null) {
            handler.setNext(eventHandler);
        } else {
            handler.setNext(this);
        }
        eventHandler = handler;
        this.mEventHandler.put(displayId, eventHandler);
    }

    private void addFirstEventHandlerForAllDisplays(ArrayList<Display> displayList, EventStreamTransformation handler) {
        for (int i = 0; i < displayList.size(); ++i) {
            int displayId = displayList.get(i).getDisplayId();
            this.addFirstEventHandler(displayId, handler);
        }
    }

    private void disableFeatures() {
        int i;
        for (i = this.mMotionEventInjector.size() - 1; i >= 0; --i) {
            MotionEventInjector injector = this.mMotionEventInjector.valueAt(i);
            this.mAms.setMotionEventInjector(null);
            if (injector == null) continue;
            injector.onDestroy();
        }
        this.mMotionEventInjector.clear();
        if (this.mAutoclickController != null) {
            this.mAutoclickController.onDestroy();
            this.mAutoclickController = null;
        }
        for (i = this.mTouchExplorer.size() - 1; i >= 0; --i) {
            TouchExplorer explorer = this.mTouchExplorer.valueAt(i);
            if (explorer == null) continue;
            explorer.onDestroy();
        }
        this.mTouchExplorer.clear();
        for (i = this.mMagnificationGestureHandler.size() - 1; i >= 0; --i) {
            MagnificationGestureHandler handler = this.mMagnificationGestureHandler.valueAt(i);
            if (handler == null) continue;
            handler.onDestroy();
        }
        this.mMagnificationGestureHandler.clear();
        if (this.mKeyboardInterceptor != null) {
            this.mKeyboardInterceptor.onDestroy();
            this.mKeyboardInterceptor = null;
        }
        this.mEventHandler.clear();
        this.resetStreamState();
    }

    void resetStreamState() {
        if (this.mTouchScreenStreamState != null) {
            this.mTouchScreenStreamState.reset();
        }
        if (this.mMouseStreamState != null) {
            this.mMouseStreamState.reset();
        }
        if (this.mKeyboardStreamState != null) {
            this.mKeyboardStreamState.reset();
        }
    }

    @Override
    public void onDestroy() {
    }

    private static class KeyboardEventStreamState
    extends EventStreamState {
        private SparseBooleanArray mEventSequenceStartedMap = new SparseBooleanArray();

        public KeyboardEventStreamState() {
            this.reset();
        }

        @Override
        public final void reset() {
            super.reset();
            this.mEventSequenceStartedMap.clear();
        }

        @Override
        public boolean updateInputSource(int deviceId) {
            return false;
        }

        @Override
        public boolean inputSourceValid() {
            return true;
        }

        @Override
        public final boolean shouldProcessKeyEvent(KeyEvent event) {
            int deviceId = event.getDeviceId();
            if (this.mEventSequenceStartedMap.get(deviceId, false)) {
                return true;
            }
            boolean shouldProcess = event.getAction() == 0;
            this.mEventSequenceStartedMap.put(deviceId, shouldProcess);
            return shouldProcess;
        }
    }

    private static class TouchScreenEventStreamState
    extends EventStreamState {
        private boolean mTouchSequenceStarted;
        private boolean mHoverSequenceStarted;

        public TouchScreenEventStreamState() {
            this.reset();
        }

        @Override
        public final void reset() {
            super.reset();
            this.mTouchSequenceStarted = false;
            this.mHoverSequenceStarted = false;
        }

        @Override
        public final boolean shouldProcessMotionEvent(MotionEvent event) {
            if (event.isTouchEvent()) {
                if (this.mTouchSequenceStarted) {
                    return true;
                }
                this.mTouchSequenceStarted = event.getActionMasked() == 0;
                return this.mTouchSequenceStarted;
            }
            if (this.mHoverSequenceStarted) {
                return true;
            }
            this.mHoverSequenceStarted = event.getActionMasked() == 9;
            return this.mHoverSequenceStarted;
        }
    }

    private static class MouseEventStreamState
    extends EventStreamState {
        private boolean mMotionSequenceStarted;

        public MouseEventStreamState() {
            this.reset();
        }

        @Override
        public final void reset() {
            super.reset();
            this.mMotionSequenceStarted = false;
        }

        @Override
        public final boolean shouldProcessScroll() {
            return true;
        }

        @Override
        public final boolean shouldProcessMotionEvent(MotionEvent event) {
            if (this.mMotionSequenceStarted) {
                return true;
            }
            int action = event.getActionMasked();
            this.mMotionSequenceStarted = action == 0 || action == 7;
            return this.mMotionSequenceStarted;
        }
    }

    private static class EventStreamState {
        private int mSource = -1;

        EventStreamState() {
        }

        public boolean updateInputSource(int source) {
            if (this.mSource == source) {
                return false;
            }
            this.reset();
            this.mSource = source;
            return true;
        }

        public boolean inputSourceValid() {
            return this.mSource >= 0;
        }

        public void reset() {
            this.mSource = -1;
        }

        public boolean shouldProcessScroll() {
            return false;
        }

        public boolean shouldProcessMotionEvent(MotionEvent event) {
            return false;
        }

        public boolean shouldProcessKeyEvent(KeyEvent event) {
            return false;
        }
    }
}

