/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.os.Binder;
import android.os.RemoteException;
import android.util.Slog;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.List;

public class ActionReplacingCallback
extends IAccessibilityInteractionConnectionCallback.Stub {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "ActionReplacingCallback";
    private final IAccessibilityInteractionConnectionCallback mServiceCallback;
    private final IAccessibilityInteractionConnection mConnectionWithReplacementActions;
    private final int mInteractionId;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    List<AccessibilityNodeInfo> mNodesWithReplacementActions;
    @GuardedBy(value={"mLock"})
    List<AccessibilityNodeInfo> mNodesFromOriginalWindow;
    @GuardedBy(value={"mLock"})
    AccessibilityNodeInfo mNodeFromOriginalWindow;
    @GuardedBy(value={"mLock"})
    boolean mSingleNodeCallbackHappened;
    @GuardedBy(value={"mLock"})
    boolean mMultiNodeCallbackHappened;
    @GuardedBy(value={"mLock"})
    boolean mDone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionReplacingCallback(IAccessibilityInteractionConnectionCallback serviceCallback, IAccessibilityInteractionConnection connectionWithReplacementActions, int interactionId, int interrogatingPid, long interrogatingTid) {
        this.mServiceCallback = serviceCallback;
        this.mConnectionWithReplacementActions = connectionWithReplacementActions;
        this.mInteractionId = interactionId;
        long identityToken = Binder.clearCallingIdentity();
        try {
            this.mConnectionWithReplacementActions.findAccessibilityNodeInfoByAccessibilityId(AccessibilityNodeInfo.ROOT_NODE_ID, null, interactionId + 1, this, 0, interrogatingPid, interrogatingTid, null, null);
        }
        catch (RemoteException re) {
            this.mMultiNodeCallbackHappened = true;
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFindAccessibilityNodeInfoResult(AccessibilityNodeInfo info, int interactionId) {
        boolean readyForCallback;
        Object object = this.mLock;
        synchronized (object) {
            if (interactionId != this.mInteractionId) {
                Slog.e(LOG_TAG, "Callback with unexpected interactionId");
                return;
            }
            this.mNodeFromOriginalWindow = info;
            this.mSingleNodeCallbackHappened = true;
            readyForCallback = this.mMultiNodeCallbackHappened;
        }
        if (readyForCallback) {
            this.replaceInfoActionsAndCallService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFindAccessibilityNodeInfosResult(List<AccessibilityNodeInfo> infos, int interactionId) {
        boolean callbackForMultipleNodes;
        boolean callbackForSingleNode;
        Object object = this.mLock;
        synchronized (object) {
            if (interactionId == this.mInteractionId) {
                this.mNodesFromOriginalWindow = infos;
            } else if (interactionId == this.mInteractionId + 1) {
                this.mNodesWithReplacementActions = infos;
            } else {
                Slog.e(LOG_TAG, "Callback with unexpected interactionId");
                return;
            }
            callbackForSingleNode = this.mSingleNodeCallbackHappened;
            callbackForMultipleNodes = this.mMultiNodeCallbackHappened;
            this.mMultiNodeCallbackHappened = true;
        }
        if (callbackForSingleNode) {
            this.replaceInfoActionsAndCallService();
        }
        if (callbackForMultipleNodes) {
            this.replaceInfosActionsAndCallService();
        }
    }

    @Override
    public void setPerformAccessibilityActionResult(boolean succeeded, int interactionId) throws RemoteException {
        this.mServiceCallback.setPerformAccessibilityActionResult(succeeded, interactionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceInfoActionsAndCallService() {
        AccessibilityNodeInfo nodeToReturn;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            if (this.mNodeFromOriginalWindow != null) {
                this.replaceActionsOnInfoLocked(this.mNodeFromOriginalWindow);
            }
            this.recycleReplaceActionNodesLocked();
            nodeToReturn = this.mNodeFromOriginalWindow;
            this.mDone = true;
        }
        try {
            this.mServiceCallback.setFindAccessibilityNodeInfoResult(nodeToReturn, this.mInteractionId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceInfosActionsAndCallService() {
        ArrayList<AccessibilityNodeInfo> nodesToReturn;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            if (this.mNodesFromOriginalWindow != null) {
                for (int i = 0; i < this.mNodesFromOriginalWindow.size(); ++i) {
                    this.replaceActionsOnInfoLocked(this.mNodesFromOriginalWindow.get(i));
                }
            }
            this.recycleReplaceActionNodesLocked();
            nodesToReturn = this.mNodesFromOriginalWindow == null ? null : new ArrayList<AccessibilityNodeInfo>(this.mNodesFromOriginalWindow);
            this.mDone = true;
        }
        try {
            this.mServiceCallback.setFindAccessibilityNodeInfosResult(nodesToReturn, this.mInteractionId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @GuardedBy(value={"mLock"})
    private void replaceActionsOnInfoLocked(AccessibilityNodeInfo info) {
        info.removeAllActions();
        info.setClickable(false);
        info.setFocusable(false);
        info.setContextClickable(false);
        info.setScrollable(false);
        info.setLongClickable(false);
        info.setDismissable(false);
        if (info.getSourceNodeId() == AccessibilityNodeInfo.ROOT_NODE_ID && this.mNodesWithReplacementActions != null) {
            for (int i = 0; i < this.mNodesWithReplacementActions.size(); ++i) {
                AccessibilityNodeInfo nodeWithReplacementActions = this.mNodesWithReplacementActions.get(i);
                if (nodeWithReplacementActions.getSourceNodeId() != AccessibilityNodeInfo.ROOT_NODE_ID) continue;
                List<AccessibilityNodeInfo.AccessibilityAction> actions = nodeWithReplacementActions.getActionList();
                if (actions != null) {
                    for (int j = 0; j < actions.size(); ++j) {
                        info.addAction(actions.get(j));
                    }
                    info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_ACCESSIBILITY_FOCUS);
                    info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLEAR_ACCESSIBILITY_FOCUS);
                }
                info.setClickable(nodeWithReplacementActions.isClickable());
                info.setFocusable(nodeWithReplacementActions.isFocusable());
                info.setContextClickable(nodeWithReplacementActions.isContextClickable());
                info.setScrollable(nodeWithReplacementActions.isScrollable());
                info.setLongClickable(nodeWithReplacementActions.isLongClickable());
                info.setDismissable(nodeWithReplacementActions.isDismissable());
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void recycleReplaceActionNodesLocked() {
        if (this.mNodesWithReplacementActions == null) {
            return;
        }
        for (int i = this.mNodesWithReplacementActions.size() - 1; i >= 0; --i) {
            AccessibilityNodeInfo nodeWithReplacementAction = this.mNodesWithReplacementActions.get(i);
            nodeWithReplacementAction.recycle();
        }
        this.mNodesWithReplacementActions = null;
    }
}

