/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.util.ArrayMap;
import android.util.Pools;
import android.util.Slog;
import android.view.InputEventConsistencyVerifier;
import android.view.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KeyEventDispatcher
implements Handler.Callback {
    private static final String LOG_TAG = "KeyEventDispatcher";
    private static final boolean DEBUG = false;
    private static final long ON_KEY_EVENT_TIMEOUT_MILLIS = 500L;
    public static final int MSG_ON_KEY_EVENT_TIMEOUT = 1;
    private static final int MAX_POOL_SIZE = 10;
    private final Pools.Pool<PendingKeyEvent> mPendingEventPool = new Pools.SimplePool<PendingKeyEvent>(10);
    private final Object mLock;
    private final Map<KeyEventFilter, ArrayList<PendingKeyEvent>> mPendingEventsMap = new ArrayMap<KeyEventFilter, ArrayList<PendingKeyEvent>>();
    private final InputEventConsistencyVerifier mSentEventsVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0, KeyEventDispatcher.class.getSimpleName()) : null;
    private final Handler mHandlerToSendKeyEventsToInputFilter;
    private final int mMessageTypeForSendKeyEvent;
    private final PowerManager mPowerManager;
    private Handler mKeyEventTimeoutHandler;

    public KeyEventDispatcher(Handler handlerToSendKeyEventsToInputFilter, int messageTypeForSendKeyEvent, Object lock, PowerManager powerManager) {
        this.mHandlerToSendKeyEventsToInputFilter = handlerToSendKeyEventsToInputFilter;
        this.mMessageTypeForSendKeyEvent = messageTypeForSendKeyEvent;
        this.mKeyEventTimeoutHandler = new Handler(handlerToSendKeyEventsToInputFilter.getLooper(), this);
        this.mLock = lock;
        this.mPowerManager = powerManager;
    }

    public KeyEventDispatcher(Handler handlerToSendKeyEventsToInputFilter, int messageTypeForSendKeyEvent, Object lock, PowerManager powerManager, Handler timeoutHandler) {
        this(handlerToSendKeyEventsToInputFilter, messageTypeForSendKeyEvent, lock, powerManager);
        this.mKeyEventTimeoutHandler = timeoutHandler;
    }

    public boolean notifyKeyEventLocked(KeyEvent event, int policyFlags, List<? extends KeyEventFilter> keyEventFilters) {
        PendingKeyEvent pendingKeyEvent = null;
        KeyEvent localClone = KeyEvent.obtain(event);
        for (int i = 0; i < keyEventFilters.size(); ++i) {
            ArrayList<PendingKeyEvent> pendingEventList;
            KeyEventFilter keyEventFilter = keyEventFilters.get(i);
            if (!keyEventFilter.onKeyEvent(localClone, localClone.getSequenceNumber())) continue;
            if (pendingKeyEvent == null) {
                pendingKeyEvent = this.obtainPendingEventLocked(localClone, policyFlags);
            }
            if ((pendingEventList = this.mPendingEventsMap.get(keyEventFilter)) == null) {
                pendingEventList = new ArrayList();
                this.mPendingEventsMap.put(keyEventFilter, pendingEventList);
            }
            pendingEventList.add(pendingKeyEvent);
            ++pendingKeyEvent.referenceCount;
        }
        if (pendingKeyEvent == null) {
            localClone.recycle();
            return false;
        }
        Message message = this.mKeyEventTimeoutHandler.obtainMessage(1, pendingKeyEvent);
        this.mKeyEventTimeoutHandler.sendMessageDelayed(message, 500L);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnKeyEventResult(KeyEventFilter keyEventFilter, boolean handled, int sequence) {
        Object object = this.mLock;
        synchronized (object) {
            PendingKeyEvent pendingEvent = KeyEventDispatcher.removeEventFromListLocked((List<PendingKeyEvent>)this.mPendingEventsMap.get(keyEventFilter), sequence);
            if (pendingEvent != null) {
                if (handled && !pendingEvent.handled) {
                    pendingEvent.handled = handled;
                    long identity = Binder.clearCallingIdentity();
                    try {
                        this.mPowerManager.userActivity(pendingEvent.event.getEventTime(), 3, 0);
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
                this.removeReferenceToPendingEventLocked(pendingEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(KeyEventFilter keyEventFilter) {
        Object object = this.mLock;
        synchronized (object) {
            List pendingEvents = this.mPendingEventsMap.get(keyEventFilter);
            if (pendingEvents != null) {
                for (int i = 0; i < pendingEvents.size(); ++i) {
                    PendingKeyEvent pendingEvent = (PendingKeyEvent)pendingEvents.get(i);
                    this.removeReferenceToPendingEventLocked(pendingEvent);
                }
                this.mPendingEventsMap.remove(keyEventFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(Message message) {
        if (message.what != 1) {
            Slog.w(LOG_TAG, "Unknown message: " + message.what);
            return false;
        }
        PendingKeyEvent pendingKeyEvent = (PendingKeyEvent)message.obj;
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<PendingKeyEvent> listForService;
            Iterator<ArrayList<PendingKeyEvent>> iterator = this.mPendingEventsMap.values().iterator();
            while (!(!iterator.hasNext() || (listForService = iterator.next()).remove(pendingKeyEvent) && this.removeReferenceToPendingEventLocked(pendingKeyEvent))) {
            }
        }
        return true;
    }

    private PendingKeyEvent obtainPendingEventLocked(KeyEvent event, int policyFlags) {
        PendingKeyEvent pendingEvent = this.mPendingEventPool.acquire();
        if (pendingEvent == null) {
            pendingEvent = new PendingKeyEvent();
        }
        pendingEvent.event = event;
        pendingEvent.policyFlags = policyFlags;
        pendingEvent.referenceCount = 0;
        pendingEvent.handled = false;
        return pendingEvent;
    }

    private static PendingKeyEvent removeEventFromListLocked(List<PendingKeyEvent> listOfEvents, int sequence) {
        for (int i = 0; i < listOfEvents.size(); ++i) {
            PendingKeyEvent pendingKeyEvent = listOfEvents.get(i);
            if (pendingKeyEvent.event.getSequenceNumber() != sequence) continue;
            listOfEvents.remove(pendingKeyEvent);
            return pendingKeyEvent;
        }
        return null;
    }

    private boolean removeReferenceToPendingEventLocked(PendingKeyEvent pendingEvent) {
        if (--pendingEvent.referenceCount > 0) {
            return false;
        }
        this.mKeyEventTimeoutHandler.removeMessages(1, pendingEvent);
        if (!pendingEvent.handled) {
            if (this.mSentEventsVerifier != null) {
                this.mSentEventsVerifier.onKeyEvent(pendingEvent.event, 0);
            }
            int policyFlags = pendingEvent.policyFlags | 0x40000000;
            this.mHandlerToSendKeyEventsToInputFilter.obtainMessage(this.mMessageTypeForSendKeyEvent, policyFlags, 0, pendingEvent.event).sendToTarget();
        } else {
            pendingEvent.event.recycle();
        }
        this.mPendingEventPool.release(pendingEvent);
        return true;
    }

    public static interface KeyEventFilter {
        public boolean onKeyEvent(KeyEvent var1, int var2);
    }

    private static final class PendingKeyEvent {
        KeyEvent event;
        int policyFlags;
        int referenceCount;
        boolean handled;

        private PendingKeyEvent() {
        }
    }
}

