/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.animation.ValueAnimator;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.MathUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.view.MagnificationSpec;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.LocalServices;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.wm.WindowManagerInternal;
import java.util.Locale;

public class MagnificationController {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "MagnificationController";
    public static final float MIN_SCALE = 1.0f;
    public static final float MAX_SCALE = 8.0f;
    private static final boolean DEBUG_SET_MAGNIFICATION_SPEC = false;
    private static final float DEFAULT_MAGNIFICATION_SCALE = 2.0f;
    private final Object mLock;
    private final ControllerContext mControllerCtx;
    private final ScreenStateObserver mScreenStateObserver;
    private int mUserId;
    private final long mMainThreadId;
    @GuardedBy(value={"mLock"})
    private final SparseArray<DisplayMagnification> mDisplays = new SparseArray(0);

    public MagnificationController(Context context, AccessibilityManagerService ams, Object lock) {
        this(new ControllerContext(context, ams, LocalServices.getService(WindowManagerInternal.class), new Handler(context.getMainLooper()), context.getResources().getInteger(17694722)), lock);
    }

    @VisibleForTesting
    public MagnificationController(ControllerContext ctx, Object lock) {
        this.mControllerCtx = ctx;
        this.mLock = lock;
        this.mMainThreadId = this.mControllerCtx.getContext().getMainLooper().getThread().getId();
        this.mScreenStateObserver = new ScreenStateObserver(this.mControllerCtx.getContext(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                display = new DisplayMagnification(displayId);
            }
            if (display.isRegistered()) {
                return;
            }
            if (display.register()) {
                this.mDisplays.put(displayId, display);
                this.mScreenStateObserver.registerIfNecessary();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            this.unregisterLocked(displayId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll() {
        Object object = this.mLock;
        synchronized (object) {
            Object displays = this.mDisplays.clone();
            for (int i = 0; i < ((SparseArray)displays).size(); ++i) {
                this.unregisterLocked(((SparseArray)displays).keyAt(i), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisplayRemoved(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            this.unregisterLocked(displayId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return false;
            }
            return display.isRegistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMagnifying(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return false;
            }
            return display.isMagnifying();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean magnificationRegionContains(int displayId, float x, float y) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return false;
            }
            return display.magnificationRegionContains(x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMagnificationBounds(int displayId, Rect outBounds) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return;
            }
            display.getMagnificationBounds(outBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMagnificationRegion(int displayId, Region outRegion) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return;
            }
            display.getMagnificationRegion(outRegion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getScale(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return 1.0f;
            }
            return display.getScale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getOffsetX(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return 0.0f;
            }
            return display.getOffsetX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCenterX(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return 0.0f;
            }
            return display.getCenterX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getOffsetY(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return 0.0f;
            }
            return display.getOffsetY();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCenterY(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return 0.0f;
            }
            return display.getCenterY();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reset(int displayId, boolean animate) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return false;
            }
            return display.reset(animate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScale(int displayId, float scale, float pivotX, float pivotY, boolean animate, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return false;
            }
            return display.setScale(scale, pivotX, pivotY, animate, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCenter(int displayId, float centerX, float centerY, boolean animate, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return false;
            }
            return display.setScaleAndCenter(Float.NaN, centerX, centerY, animate, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScaleAndCenter(int displayId, float scale, float centerX, float centerY, boolean animate, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return false;
            }
            return display.setScaleAndCenter(scale, centerX, centerY, animate, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offsetMagnifiedRegion(int displayId, float offsetX, float offsetY, int id2) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return;
            }
            display.offsetMagnifiedRegion(offsetX, offsetY, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdOfLastServiceToMagnify(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return -1;
            }
            return display.getIdOfLastServiceToMagnify();
        }
    }

    public void persistScale() {
        final float scale = this.getScale(0);
        final int userId = this.mUserId;
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                MagnificationController.this.mControllerCtx.putMagnificationScale(scale, userId);
                return null;
            }
        }.execute(new Void[0]);
    }

    public float getPersistedScale() {
        return this.mControllerCtx.getMagnificationScale(this.mUserId);
    }

    public void setUserId(int userId) {
        if (this.mUserId == userId) {
            return;
        }
        this.mUserId = userId;
        this.resetAllIfNeeded(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllIfNeeded(int connectionId) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mDisplays.size(); ++i) {
                this.resetIfNeeded(this.mDisplays.keyAt(i), connectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resetIfNeeded(int displayId, boolean animate) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null || !display.isMagnifying()) {
                return false;
            }
            display.reset(animate);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resetIfNeeded(int displayId, int connectionId) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null || !display.isMagnifying() || connectionId != display.getIdOfLastServiceToMagnify()) {
                return false;
            }
            display.reset(true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setForceShowMagnifiableBounds(int displayId, boolean show) {
        Object object = this.mLock;
        synchronized (object) {
            DisplayMagnification display = this.mDisplays.get(displayId);
            if (display == null) {
                return;
            }
            display.setForceShowMagnifiableBounds(show);
        }
    }

    private void onScreenTurnedOff() {
        Message m = PooledLambda.obtainMessage(MagnificationController::resetAllIfNeeded, this, false);
        this.mControllerCtx.getHandler().sendMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAllIfNeeded(boolean animate) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mDisplays.size(); ++i) {
                this.resetIfNeeded(this.mDisplays.keyAt(i), animate);
            }
        }
    }

    private void unregisterLocked(int displayId, boolean delete) {
        DisplayMagnification display = this.mDisplays.get(displayId);
        if (display == null) {
            return;
        }
        if (!display.isRegistered()) {
            if (delete) {
                this.mDisplays.remove(displayId);
            }
            return;
        }
        if (!display.isMagnifying()) {
            display.unregister(delete);
        } else {
            display.unregisterPending(delete);
        }
    }

    private void unregisterCallbackLocked(int displayId, boolean delete) {
        DisplayMagnification display;
        if (delete) {
            this.mDisplays.remove(displayId);
        }
        boolean hasRegister = false;
        for (int i = 0; i < this.mDisplays.size() && !(hasRegister = (display = this.mDisplays.valueAt(i)).isRegistered()); ++i) {
        }
        if (!hasRegister) {
            this.mScreenStateObserver.unregister();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MagnificationController[");
        builder.append("mUserId=").append(this.mUserId);
        builder.append(", mDisplays=").append(this.mDisplays);
        builder.append("]");
        return builder.toString();
    }

    @VisibleForTesting
    public static class ControllerContext {
        private final Context mContext;
        private final AccessibilityManagerService mAms;
        private final WindowManagerInternal mWindowManager;
        private final Handler mHandler;
        private final Long mAnimationDuration;

        public ControllerContext(Context context, AccessibilityManagerService ams, WindowManagerInternal windowManager, Handler handler, long animationDuration) {
            this.mContext = context;
            this.mAms = ams;
            this.mWindowManager = windowManager;
            this.mHandler = handler;
            this.mAnimationDuration = animationDuration;
        }

        public Context getContext() {
            return this.mContext;
        }

        public AccessibilityManagerService getAms() {
            return this.mAms;
        }

        public WindowManagerInternal getWindowManager() {
            return this.mWindowManager;
        }

        public Handler getHandler() {
            return this.mHandler;
        }

        public ValueAnimator newValueAnimator() {
            return new ValueAnimator();
        }

        public void putMagnificationScale(float value, int userId) {
            Settings.Secure.putFloatForUser(this.mContext.getContentResolver(), "accessibility_display_magnification_scale", value, userId);
        }

        public float getMagnificationScale(int userId) {
            return Settings.Secure.getFloatForUser(this.mContext.getContentResolver(), "accessibility_display_magnification_scale", 2.0f, userId);
        }

        public long getAnimationDuration() {
            return this.mAnimationDuration;
        }
    }

    private static class ScreenStateObserver
    extends BroadcastReceiver {
        private final Context mContext;
        private final MagnificationController mController;
        private boolean mRegistered = false;

        public ScreenStateObserver(Context context, MagnificationController controller) {
            this.mContext = context;
            this.mController = controller;
        }

        public void registerIfNecessary() {
            if (!this.mRegistered) {
                this.mContext.registerReceiver(this, new IntentFilter("android.intent.action.SCREEN_OFF"));
                this.mRegistered = true;
            }
        }

        public void unregister() {
            if (this.mRegistered) {
                this.mContext.unregisterReceiver(this);
                this.mRegistered = false;
            }
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            this.mController.onScreenTurnedOff();
        }
    }

    private static class SpecAnimationBridge
    implements ValueAnimator.AnimatorUpdateListener {
        private final ControllerContext mControllerCtx;
        private final MagnificationSpec mSentMagnificationSpec = MagnificationSpec.obtain();
        private final MagnificationSpec mStartMagnificationSpec = MagnificationSpec.obtain();
        private final MagnificationSpec mEndMagnificationSpec = MagnificationSpec.obtain();
        private final MagnificationSpec mTmpMagnificationSpec = MagnificationSpec.obtain();
        private final ValueAnimator mValueAnimator;
        private final Object mLock;
        private final int mDisplayId;
        @GuardedBy(value={"mLock"})
        private boolean mEnabled = false;

        private SpecAnimationBridge(ControllerContext ctx, Object lock, int displayId) {
            this.mControllerCtx = ctx;
            this.mLock = lock;
            this.mDisplayId = displayId;
            long animationDuration = this.mControllerCtx.getAnimationDuration();
            this.mValueAnimator = this.mControllerCtx.newValueAnimator();
            this.mValueAnimator.setDuration(animationDuration);
            this.mValueAnimator.setInterpolator(new DecelerateInterpolator(2.5f));
            this.mValueAnimator.setFloatValues(0.0f, 1.0f);
            this.mValueAnimator.addUpdateListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(boolean enabled) {
            Object object = this.mLock;
            synchronized (object) {
                if (enabled != this.mEnabled) {
                    this.mEnabled = enabled;
                    if (!this.mEnabled) {
                        this.mSentMagnificationSpec.clear();
                        this.mControllerCtx.getWindowManager().setMagnificationSpec(this.mDisplayId, this.mSentMagnificationSpec);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateSentSpecMainThread(MagnificationSpec spec, boolean animate) {
            if (this.mValueAnimator.isRunning()) {
                this.mValueAnimator.cancel();
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean changed;
                boolean bl = changed = !this.mSentMagnificationSpec.equals(spec);
                if (changed) {
                    if (animate) {
                        this.animateMagnificationSpecLocked(spec);
                    } else {
                        this.setMagnificationSpecLocked(spec);
                    }
                }
            }
        }

        @GuardedBy(value={"mLock"})
        private void setMagnificationSpecLocked(MagnificationSpec spec) {
            if (this.mEnabled) {
                this.mSentMagnificationSpec.setTo(spec);
                this.mControllerCtx.getWindowManager().setMagnificationSpec(this.mDisplayId, this.mSentMagnificationSpec);
            }
        }

        private void animateMagnificationSpecLocked(MagnificationSpec toSpec) {
            this.mEndMagnificationSpec.setTo(toSpec);
            this.mStartMagnificationSpec.setTo(this.mSentMagnificationSpec);
            this.mValueAnimator.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mEnabled) {
                    float fract = animation.getAnimatedFraction();
                    this.mTmpMagnificationSpec.scale = this.mStartMagnificationSpec.scale + (this.mEndMagnificationSpec.scale - this.mStartMagnificationSpec.scale) * fract;
                    this.mTmpMagnificationSpec.offsetX = this.mStartMagnificationSpec.offsetX + (this.mEndMagnificationSpec.offsetX - this.mStartMagnificationSpec.offsetX) * fract;
                    this.mTmpMagnificationSpec.offsetY = this.mStartMagnificationSpec.offsetY + (this.mEndMagnificationSpec.offsetY - this.mStartMagnificationSpec.offsetY) * fract;
                    this.setMagnificationSpecLocked(this.mTmpMagnificationSpec);
                }
            }
        }
    }

    private final class DisplayMagnification
    implements WindowManagerInternal.MagnificationCallbacks {
        private final MagnificationSpec mCurrentMagnificationSpec = MagnificationSpec.obtain();
        private final Region mMagnificationRegion = Region.obtain();
        private final Rect mMagnificationBounds = new Rect();
        private final Rect mTempRect = new Rect();
        private final Rect mTempRect1 = new Rect();
        private final SpecAnimationBridge mSpecAnimationBridge;
        private boolean mRegistered;
        private boolean mUnregisterPending;
        private boolean mDeleteAfterUnregister;
        private final int mDisplayId;
        private static final int INVALID_ID = -1;
        private int mIdOfLastServiceToMagnify = -1;

        DisplayMagnification(int displayId) {
            this.mDisplayId = displayId;
            this.mSpecAnimationBridge = new SpecAnimationBridge(MagnificationController.this.mControllerCtx, MagnificationController.this.mLock, this.mDisplayId);
        }

        @GuardedBy(value={"mLock"})
        boolean register() {
            this.mRegistered = MagnificationController.this.mControllerCtx.getWindowManager().setMagnificationCallbacks(this.mDisplayId, this);
            if (!this.mRegistered) {
                Slog.w(MagnificationController.LOG_TAG, "set magnification callbacks fail, displayId:" + this.mDisplayId);
                return false;
            }
            this.mSpecAnimationBridge.setEnabled(true);
            MagnificationController.this.mControllerCtx.getWindowManager().getMagnificationRegion(this.mDisplayId, this.mMagnificationRegion);
            this.mMagnificationRegion.getBounds(this.mMagnificationBounds);
            return true;
        }

        @GuardedBy(value={"mLock"})
        void unregister(boolean delete) {
            if (this.mRegistered) {
                this.mSpecAnimationBridge.setEnabled(false);
                MagnificationController.this.mControllerCtx.getWindowManager().setMagnificationCallbacks(this.mDisplayId, null);
                this.mMagnificationRegion.setEmpty();
                this.mRegistered = false;
                MagnificationController.this.unregisterCallbackLocked(this.mDisplayId, delete);
            }
            this.mUnregisterPending = false;
        }

        @GuardedBy(value={"mLock"})
        void unregisterPending(boolean delete) {
            this.mDeleteAfterUnregister = delete;
            this.mUnregisterPending = true;
            this.reset(true);
        }

        boolean isRegistered() {
            return this.mRegistered;
        }

        boolean isMagnifying() {
            return this.mCurrentMagnificationSpec.scale > 1.0f;
        }

        float getScale() {
            return this.mCurrentMagnificationSpec.scale;
        }

        float getOffsetX() {
            return this.mCurrentMagnificationSpec.offsetX;
        }

        float getOffsetY() {
            return this.mCurrentMagnificationSpec.offsetY;
        }

        @GuardedBy(value={"mLock"})
        float getCenterX() {
            return ((float)this.mMagnificationBounds.width() / 2.0f + (float)this.mMagnificationBounds.left - this.getOffsetX()) / this.getScale();
        }

        @GuardedBy(value={"mLock"})
        float getCenterY() {
            return ((float)this.mMagnificationBounds.height() / 2.0f + (float)this.mMagnificationBounds.top - this.getOffsetY()) / this.getScale();
        }

        float getSentScale() {
            return ((SpecAnimationBridge)this.mSpecAnimationBridge).mSentMagnificationSpec.scale;
        }

        float getSentOffsetX() {
            return ((SpecAnimationBridge)this.mSpecAnimationBridge).mSentMagnificationSpec.offsetX;
        }

        float getSentOffsetY() {
            return ((SpecAnimationBridge)this.mSpecAnimationBridge).mSentMagnificationSpec.offsetY;
        }

        @Override
        public void onMagnificationRegionChanged(Region magnificationRegion) {
            Message m = PooledLambda.obtainMessage(DisplayMagnification::updateMagnificationRegion, this, Region.obtain(magnificationRegion));
            MagnificationController.this.mControllerCtx.getHandler().sendMessage(m);
        }

        @Override
        public void onRectangleOnScreenRequested(int left, int top, int right, int bottom) {
            Message m = PooledLambda.obtainMessage(DisplayMagnification::requestRectangleOnScreen, this, left, top, right, bottom);
            MagnificationController.this.mControllerCtx.getHandler().sendMessage(m);
        }

        @Override
        public void onRotationChanged(int rotation) {
            Message m = PooledLambda.obtainMessage(MagnificationController::resetIfNeeded, MagnificationController.this, this.mDisplayId, true);
            MagnificationController.this.mControllerCtx.getHandler().sendMessage(m);
        }

        @Override
        public void onUserContextChanged() {
            Message m = PooledLambda.obtainMessage(MagnificationController::resetIfNeeded, MagnificationController.this, this.mDisplayId, true);
            MagnificationController.this.mControllerCtx.getHandler().sendMessage(m);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateMagnificationRegion(Region magnified) {
            Object object = MagnificationController.this.mLock;
            synchronized (object) {
                if (!this.mRegistered) {
                    return;
                }
                if (!this.mMagnificationRegion.equals(magnified)) {
                    this.mMagnificationRegion.set(magnified);
                    this.mMagnificationRegion.getBounds(this.mMagnificationBounds);
                    if (this.updateCurrentSpecWithOffsetsLocked(this.mCurrentMagnificationSpec.offsetX, this.mCurrentMagnificationSpec.offsetY)) {
                        this.sendSpecToAnimation(this.mCurrentMagnificationSpec, false);
                    }
                    this.onMagnificationChangedLocked();
                }
                magnified.recycle();
            }
        }

        void sendSpecToAnimation(MagnificationSpec spec, boolean animate) {
            if (Thread.currentThread().getId() == MagnificationController.this.mMainThreadId) {
                this.mSpecAnimationBridge.updateSentSpecMainThread(spec, animate);
            } else {
                Message m = PooledLambda.obtainMessage(SpecAnimationBridge::updateSentSpecMainThread, this.mSpecAnimationBridge, spec, animate);
                MagnificationController.this.mControllerCtx.getHandler().sendMessage(m);
            }
        }

        int getIdOfLastServiceToMagnify() {
            return this.mIdOfLastServiceToMagnify;
        }

        void onMagnificationChangedLocked() {
            MagnificationController.this.mControllerCtx.getAms().notifyMagnificationChanged(this.mDisplayId, this.mMagnificationRegion, this.getScale(), this.getCenterX(), this.getCenterY());
            if (this.mUnregisterPending && !this.isMagnifying()) {
                this.unregister(this.mDeleteAfterUnregister);
            }
        }

        @GuardedBy(value={"mLock"})
        boolean magnificationRegionContains(float x, float y) {
            return this.mMagnificationRegion.contains((int)x, (int)y);
        }

        @GuardedBy(value={"mLock"})
        void getMagnificationBounds(Rect outBounds) {
            outBounds.set(this.mMagnificationBounds);
        }

        @GuardedBy(value={"mLock"})
        void getMagnificationRegion(Region outRegion) {
            outRegion.set(this.mMagnificationRegion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestRectangleOnScreen(int left, int top, int right, int bottom) {
            Object object = MagnificationController.this.mLock;
            synchronized (object) {
                int direction;
                Rect magnifiedFrame = this.mTempRect;
                this.getMagnificationBounds(magnifiedFrame);
                if (!magnifiedFrame.intersects(left, top, right, bottom)) {
                    return;
                }
                Rect magnifFrameInScreenCoords = this.mTempRect1;
                this.getMagnifiedFrameInContentCoordsLocked(magnifFrameInScreenCoords);
                float scrollX = right - left > magnifFrameInScreenCoords.width() ? ((direction = TextUtils.getLayoutDirectionFromLocale(Locale.getDefault())) == 0 ? (float)(left - magnifFrameInScreenCoords.left) : (float)(right - magnifFrameInScreenCoords.right)) : (left < magnifFrameInScreenCoords.left ? (float)(left - magnifFrameInScreenCoords.left) : (right > magnifFrameInScreenCoords.right ? (float)(right - magnifFrameInScreenCoords.right) : 0.0f));
                float scrollY = bottom - top > magnifFrameInScreenCoords.height() ? (float)(top - magnifFrameInScreenCoords.top) : (top < magnifFrameInScreenCoords.top ? (float)(top - magnifFrameInScreenCoords.top) : (bottom > magnifFrameInScreenCoords.bottom ? (float)(bottom - magnifFrameInScreenCoords.bottom) : 0.0f));
                float scale = this.getScale();
                this.offsetMagnifiedRegion(scrollX * scale, scrollY * scale, -1);
            }
        }

        void getMagnifiedFrameInContentCoordsLocked(Rect outFrame) {
            float scale = this.getSentScale();
            float offsetX = this.getSentOffsetX();
            float offsetY = this.getSentOffsetY();
            this.getMagnificationBounds(outFrame);
            outFrame.offset((int)(-offsetX), (int)(-offsetY));
            outFrame.scale(1.0f / scale);
        }

        @GuardedBy(value={"mLock"})
        void setForceShowMagnifiableBounds(boolean show) {
            if (this.mRegistered) {
                MagnificationController.this.mControllerCtx.getWindowManager().setForceShowMagnifiableBounds(this.mDisplayId, show);
            }
        }

        @GuardedBy(value={"mLock"})
        boolean reset(boolean animate) {
            boolean changed;
            if (!this.mRegistered) {
                return false;
            }
            MagnificationSpec spec = this.mCurrentMagnificationSpec;
            boolean bl = changed = !spec.isNop();
            if (changed) {
                spec.clear();
                this.onMagnificationChangedLocked();
            }
            this.mIdOfLastServiceToMagnify = -1;
            this.sendSpecToAnimation(spec, animate);
            return changed;
        }

        @GuardedBy(value={"mLock"})
        boolean setScale(float scale, float pivotX, float pivotY, boolean animate, int id2) {
            if (!this.mRegistered) {
                return false;
            }
            scale = MathUtils.constrain(scale, 1.0f, 8.0f);
            Rect viewport = this.mTempRect;
            this.mMagnificationRegion.getBounds(viewport);
            MagnificationSpec spec = this.mCurrentMagnificationSpec;
            float oldScale = spec.scale;
            float oldCenterX = ((float)viewport.width() / 2.0f - spec.offsetX + (float)viewport.left) / oldScale;
            float oldCenterY = ((float)viewport.height() / 2.0f - spec.offsetY + (float)viewport.top) / oldScale;
            float normPivotX = (pivotX - spec.offsetX) / oldScale;
            float normPivotY = (pivotY - spec.offsetY) / oldScale;
            float offsetX = (oldCenterX - normPivotX) * (oldScale / scale);
            float offsetY = (oldCenterY - normPivotY) * (oldScale / scale);
            float centerX = normPivotX + offsetX;
            float centerY = normPivotY + offsetY;
            this.mIdOfLastServiceToMagnify = id2;
            return this.setScaleAndCenter(scale, centerX, centerY, animate, id2);
        }

        @GuardedBy(value={"mLock"})
        boolean setScaleAndCenter(float scale, float centerX, float centerY, boolean animate, int id2) {
            if (!this.mRegistered) {
                return false;
            }
            boolean changed = this.updateMagnificationSpecLocked(scale, centerX, centerY);
            this.sendSpecToAnimation(this.mCurrentMagnificationSpec, animate);
            if (this.isMagnifying() && id2 != -1) {
                this.mIdOfLastServiceToMagnify = id2;
            }
            return changed;
        }

        boolean updateMagnificationSpecLocked(float scale, float centerX, float centerY) {
            float nonNormOffsetY;
            float nonNormOffsetX;
            if (Float.isNaN(centerX)) {
                centerX = this.getCenterX();
            }
            if (Float.isNaN(centerY)) {
                centerY = this.getCenterY();
            }
            if (Float.isNaN(scale)) {
                scale = this.getScale();
            }
            boolean changed = false;
            float normScale = MathUtils.constrain(scale, 1.0f, 8.0f);
            if (Float.compare(this.mCurrentMagnificationSpec.scale, normScale) != 0) {
                this.mCurrentMagnificationSpec.scale = normScale;
                changed = true;
            }
            if (changed |= this.updateCurrentSpecWithOffsetsLocked(nonNormOffsetX = (float)this.mMagnificationBounds.width() / 2.0f + (float)this.mMagnificationBounds.left - centerX * normScale, nonNormOffsetY = (float)this.mMagnificationBounds.height() / 2.0f + (float)this.mMagnificationBounds.top - centerY * normScale)) {
                this.onMagnificationChangedLocked();
            }
            return changed;
        }

        @GuardedBy(value={"mLock"})
        void offsetMagnifiedRegion(float offsetX, float offsetY, int id2) {
            if (!this.mRegistered) {
                return;
            }
            float nonNormOffsetX = this.mCurrentMagnificationSpec.offsetX - offsetX;
            float nonNormOffsetY = this.mCurrentMagnificationSpec.offsetY - offsetY;
            if (this.updateCurrentSpecWithOffsetsLocked(nonNormOffsetX, nonNormOffsetY)) {
                this.onMagnificationChangedLocked();
            }
            if (id2 != -1) {
                this.mIdOfLastServiceToMagnify = id2;
            }
            this.sendSpecToAnimation(this.mCurrentMagnificationSpec, false);
        }

        boolean updateCurrentSpecWithOffsetsLocked(float nonNormOffsetX, float nonNormOffsetY) {
            float offsetY;
            boolean changed = false;
            float offsetX = MathUtils.constrain(nonNormOffsetX, this.getMinOffsetXLocked(), this.getMaxOffsetXLocked());
            if (Float.compare(this.mCurrentMagnificationSpec.offsetX, offsetX) != 0) {
                this.mCurrentMagnificationSpec.offsetX = offsetX;
                changed = true;
            }
            if (Float.compare(this.mCurrentMagnificationSpec.offsetY, offsetY = MathUtils.constrain(nonNormOffsetY, this.getMinOffsetYLocked(), this.getMaxOffsetYLocked())) != 0) {
                this.mCurrentMagnificationSpec.offsetY = offsetY;
                changed = true;
            }
            return changed;
        }

        float getMinOffsetXLocked() {
            float viewportWidth = this.mMagnificationBounds.width();
            float viewportLeft = this.mMagnificationBounds.left;
            return viewportLeft + viewportWidth - (viewportLeft + viewportWidth) * this.mCurrentMagnificationSpec.scale;
        }

        float getMaxOffsetXLocked() {
            return (float)this.mMagnificationBounds.left - (float)this.mMagnificationBounds.left * this.mCurrentMagnificationSpec.scale;
        }

        float getMinOffsetYLocked() {
            float viewportHeight = this.mMagnificationBounds.height();
            float viewportTop = this.mMagnificationBounds.top;
            return viewportTop + viewportHeight - (viewportTop + viewportHeight) * this.mCurrentMagnificationSpec.scale;
        }

        float getMaxOffsetYLocked() {
            return (float)this.mMagnificationBounds.top - (float)this.mMagnificationBounds.top * this.mCurrentMagnificationSpec.scale;
        }

        public String toString() {
            return "DisplayMagnification[mCurrentMagnificationSpec=" + this.mCurrentMagnificationSpec + ", mMagnificationRegion=" + this.mMagnificationRegion + ", mMagnificationBounds=" + this.mMagnificationBounds + ", mDisplayId=" + this.mDisplayId + ", mIdOfLastServiceToMagnify=" + this.mIdOfLastServiceToMagnify + ", mRegistered=" + this.mRegistered + ", mUnregisterPending=" + this.mUnregisterPending + ']';
        }
    }
}

