/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.MathUtils;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewConfiguration;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.accessibility.BaseEventStreamTransformation;
import com.android.server.accessibility.GestureUtils;
import com.android.server.accessibility.MagnificationController;
import java.util.Queue;

class MagnificationGestureHandler
extends BaseEventStreamTransformation {
    private static final String LOG_TAG = "MagnificationGestureHandler";
    private static final boolean DEBUG_ALL = false;
    private static final boolean DEBUG_STATE_TRANSITIONS = false;
    private static final boolean DEBUG_DETECTING = false;
    private static final boolean DEBUG_PANNING_SCALING = false;
    private static final boolean DEBUG_EVENT_STREAM = false;
    private static final float MIN_SCALE = 2.0f;
    private static final float MAX_SCALE = 8.0f;
    @VisibleForTesting
    final MagnificationController mMagnificationController;
    @VisibleForTesting
    final DelegatingState mDelegatingState;
    @VisibleForTesting
    final DetectingState mDetectingState;
    @VisibleForTesting
    final PanningScalingState mPanningScalingState;
    @VisibleForTesting
    final ViewportDraggingState mViewportDraggingState;
    private final ScreenStateReceiver mScreenStateReceiver;
    final boolean mDetectTripleTap;
    final boolean mDetectShortcutTrigger;
    @VisibleForTesting
    State mCurrentState;
    @VisibleForTesting
    State mPreviousState;
    private MotionEvent.PointerCoords[] mTempPointerCoords;
    private MotionEvent.PointerProperties[] mTempPointerProperties;
    private final int mDisplayId;
    private final Queue<MotionEvent> mDebugInputEventHistory;
    private final Queue<MotionEvent> mDebugOutputEventHistory;

    public MagnificationGestureHandler(Context context, MagnificationController magnificationController, boolean detectTripleTap, boolean detectShortcutTrigger, int displayId) {
        this.mMagnificationController = magnificationController;
        this.mDisplayId = displayId;
        this.mDelegatingState = new DelegatingState();
        this.mDetectingState = new DetectingState(context);
        this.mViewportDraggingState = new ViewportDraggingState();
        this.mPanningScalingState = new PanningScalingState(context);
        this.mDetectTripleTap = detectTripleTap;
        this.mDetectShortcutTrigger = detectShortcutTrigger;
        if (this.mDetectShortcutTrigger) {
            this.mScreenStateReceiver = new ScreenStateReceiver(context, this);
            this.mScreenStateReceiver.register();
        } else {
            this.mScreenStateReceiver = null;
        }
        this.mDebugInputEventHistory = null;
        this.mDebugOutputEventHistory = null;
        this.transitionTo(this.mDetectingState);
    }

    @Override
    public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        this.onMotionEventInternal(event, rawEvent, policyFlags);
    }

    private void onMotionEventInternal(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        if (!this.mDetectTripleTap && !this.mDetectShortcutTrigger || !event.isFromSource(4098)) {
            this.dispatchTransformedEvent(event, rawEvent, policyFlags);
            return;
        }
        this.handleEventWith(this.mCurrentState, event, rawEvent, policyFlags);
    }

    private void handleEventWith(State stateHandler, MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        this.mPanningScalingState.mScrollGestureDetector.onTouchEvent(event);
        this.mPanningScalingState.mScaleGestureDetector.onTouchEvent(event);
        stateHandler.onMotionEvent(event, rawEvent, policyFlags);
    }

    @Override
    public void clearEvents(int inputSource) {
        if (inputSource == 4098) {
            this.clearAndTransitionToStateDetecting();
        }
        super.clearEvents(inputSource);
    }

    @Override
    public void onDestroy() {
        if (this.mScreenStateReceiver != null) {
            this.mScreenStateReceiver.unregister();
        }
        this.mMagnificationController.resetAllIfNeeded(0);
        this.clearAndTransitionToStateDetecting();
    }

    void notifyShortcutTriggered() {
        if (this.mDetectShortcutTrigger) {
            boolean wasMagnifying = this.mMagnificationController.resetIfNeeded(this.mDisplayId, true);
            if (wasMagnifying) {
                this.clearAndTransitionToStateDetecting();
            } else {
                this.mDetectingState.toggleShortcutTriggered();
            }
        }
    }

    void clearAndTransitionToStateDetecting() {
        this.mCurrentState = this.mDetectingState;
        this.mDetectingState.clear();
        this.mViewportDraggingState.clear();
        this.mPanningScalingState.clear();
    }

    private void dispatchTransformedEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        super.onMotionEvent(event, rawEvent, policyFlags);
    }

    private static void storeEventInto(Queue<MotionEvent> queue, MotionEvent event) {
        queue.add(MotionEvent.obtain(event));
        while (!queue.isEmpty() && event.getEventTime() - queue.peek().getEventTime() > 5000L) {
            queue.remove().recycle();
        }
    }

    private MotionEvent.PointerCoords[] getTempPointerCoordsWithMinSize(int size) {
        int oldSize;
        int n = oldSize = this.mTempPointerCoords != null ? this.mTempPointerCoords.length : 0;
        if (oldSize < size) {
            MotionEvent.PointerCoords[] oldTempPointerCoords = this.mTempPointerCoords;
            this.mTempPointerCoords = new MotionEvent.PointerCoords[size];
            if (oldTempPointerCoords != null) {
                System.arraycopy(oldTempPointerCoords, 0, this.mTempPointerCoords, 0, oldSize);
            }
        }
        for (int i = oldSize; i < size; ++i) {
            this.mTempPointerCoords[i] = new MotionEvent.PointerCoords();
        }
        return this.mTempPointerCoords;
    }

    private MotionEvent.PointerProperties[] getTempPointerPropertiesWithMinSize(int size) {
        int oldSize;
        int n = oldSize = this.mTempPointerProperties != null ? this.mTempPointerProperties.length : 0;
        if (oldSize < size) {
            MotionEvent.PointerProperties[] oldTempPointerProperties = this.mTempPointerProperties;
            this.mTempPointerProperties = new MotionEvent.PointerProperties[size];
            if (oldTempPointerProperties != null) {
                System.arraycopy(oldTempPointerProperties, 0, this.mTempPointerProperties, 0, oldSize);
            }
        }
        for (int i = oldSize; i < size; ++i) {
            this.mTempPointerProperties[i] = new MotionEvent.PointerProperties();
        }
        return this.mTempPointerProperties;
    }

    private void transitionTo(State state) {
        this.mPreviousState = this.mCurrentState;
        this.mCurrentState = state;
    }

    private void zoomOn(float centerX, float centerY) {
        float scale = MathUtils.constrain(this.mMagnificationController.getPersistedScale(), 2.0f, 8.0f);
        this.mMagnificationController.setScaleAndCenter(this.mDisplayId, scale, centerX, centerY, true, 0);
    }

    private void zoomOff() {
        this.mMagnificationController.reset(this.mDisplayId, true);
    }

    private static MotionEvent recycleAndNullify(MotionEvent event) {
        if (event != null) {
            event.recycle();
        }
        return null;
    }

    public String toString() {
        return "MagnificationGesture{mDetectingState=" + this.mDetectingState + ", mDelegatingState=" + this.mDelegatingState + ", mMagnifiedInteractionState=" + this.mPanningScalingState + ", mViewportDraggingState=" + this.mViewportDraggingState + ", mDetectTripleTap=" + this.mDetectTripleTap + ", mDetectShortcutTrigger=" + this.mDetectShortcutTrigger + ", mCurrentState=" + State.nameOf(this.mCurrentState) + ", mPreviousState=" + State.nameOf(this.mPreviousState) + ", mMagnificationController=" + this.mMagnificationController + ", mDisplayId=" + this.mDisplayId + '}';
    }

    private static class ScreenStateReceiver
    extends BroadcastReceiver {
        private final Context mContext;
        private final MagnificationGestureHandler mGestureHandler;

        public ScreenStateReceiver(Context context, MagnificationGestureHandler gestureHandler) {
            this.mContext = context;
            this.mGestureHandler = gestureHandler;
        }

        public void register() {
            this.mContext.registerReceiver(this, new IntentFilter("android.intent.action.SCREEN_OFF"));
        }

        public void unregister() {
            this.mContext.unregisterReceiver(this);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            this.mGestureHandler.mDetectingState.setShortcutTriggered(false);
        }
    }

    private static final class MotionEventInfo {
        private static final int MAX_POOL_SIZE = 10;
        private static final Object sLock = new Object();
        private static MotionEventInfo sPool;
        private static int sPoolSize;
        private MotionEventInfo mNext;
        private boolean mInPool;
        public MotionEvent event;
        public MotionEvent rawEvent;
        public int policyFlags;

        private MotionEventInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static MotionEventInfo obtain(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            Object object = sLock;
            synchronized (object) {
                MotionEventInfo info = MotionEventInfo.obtainInternal();
                info.initialize(event, rawEvent, policyFlags);
                return info;
            }
        }

        private static MotionEventInfo obtainInternal() {
            MotionEventInfo info;
            if (sPoolSize > 0) {
                --sPoolSize;
                info = sPool;
                sPool = info.mNext;
                info.mNext = null;
                info.mInPool = false;
            } else {
                info = new MotionEventInfo();
            }
            return info;
        }

        private void initialize(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            this.event = MotionEvent.obtain(event);
            this.rawEvent = MotionEvent.obtain(rawEvent);
            this.policyFlags = policyFlags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            Object object = sLock;
            synchronized (object) {
                if (this.mInPool) {
                    throw new IllegalStateException("Already recycled.");
                }
                this.clear();
                if (sPoolSize < 10) {
                    ++sPoolSize;
                    this.mNext = sPool;
                    sPool = this;
                    this.mInPool = true;
                }
            }
        }

        private void clear() {
            this.event = MagnificationGestureHandler.recycleAndNullify(this.event);
            this.rawEvent = MagnificationGestureHandler.recycleAndNullify(this.rawEvent);
            this.policyFlags = 0;
        }

        static int countOf(MotionEventInfo info, int eventType) {
            if (info == null) {
                return 0;
            }
            return (info.event.getAction() == eventType ? 1 : 0) + MotionEventInfo.countOf(info.mNext, eventType);
        }

        public static String toString(MotionEventInfo info) {
            return info == null ? "" : MotionEvent.actionToString(info.event.getAction()).replace("ACTION_", "") + " " + MotionEventInfo.toString(info.mNext);
        }
    }

    final class DetectingState
    implements State,
    Handler.Callback {
        private static final int MESSAGE_ON_TRIPLE_TAP_AND_HOLD = 1;
        private static final int MESSAGE_TRANSITION_TO_DELEGATING_STATE = 2;
        final int mLongTapMinDelay;
        final int mSwipeMinDistance;
        final int mMultiTapMaxDelay;
        final int mMultiTapMaxDistance;
        private MotionEventInfo mDelayedEventQueue;
        MotionEvent mLastDown;
        private MotionEvent mPreLastDown;
        private MotionEvent mLastUp;
        private MotionEvent mPreLastUp;
        @VisibleForTesting
        boolean mShortcutTriggered;
        @VisibleForTesting
        Handler mHandler = new Handler(Looper.getMainLooper(), this);

        public DetectingState(Context context) {
            this.mLongTapMinDelay = ViewConfiguration.getLongPressTimeout();
            this.mMultiTapMaxDelay = ViewConfiguration.getDoubleTapTimeout() + context.getResources().getInteger(17694888);
            this.mSwipeMinDistance = ViewConfiguration.get(context).getScaledTouchSlop();
            this.mMultiTapMaxDistance = ViewConfiguration.get(context).getScaledDoubleTapSlop();
        }

        @Override
        public boolean handleMessage(Message message) {
            int type = message.what;
            switch (type) {
                case 1: {
                    MotionEvent down = (MotionEvent)message.obj;
                    this.transitionToViewportDraggingStateAndClear(down);
                    down.recycle();
                    break;
                }
                case 2: {
                    this.transitionToDelegatingStateAndClear();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message type: " + type);
                }
            }
            return true;
        }

        @Override
        public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            this.cacheDelayedMotionEvent(event, rawEvent, policyFlags);
            switch (event.getActionMasked()) {
                case 0: {
                    this.mHandler.removeMessages(2);
                    if (!MagnificationGestureHandler.this.mMagnificationController.magnificationRegionContains(MagnificationGestureHandler.this.mDisplayId, event.getX(), event.getY())) {
                        this.transitionToDelegatingStateAndClear();
                        break;
                    }
                    if (this.isMultiTapTriggered(2)) {
                        this.afterLongTapTimeoutTransitionToDraggingState(event);
                        break;
                    }
                    if (this.isTapOutOfDistanceSlop()) {
                        this.transitionToDelegatingStateAndClear();
                        break;
                    }
                    if (MagnificationGestureHandler.this.mDetectTripleTap || MagnificationGestureHandler.this.mMagnificationController.isMagnifying(MagnificationGestureHandler.this.mDisplayId)) {
                        this.afterMultiTapTimeoutTransitionToDelegatingState();
                        break;
                    }
                    this.transitionToDelegatingStateAndClear();
                    break;
                }
                case 5: {
                    if (MagnificationGestureHandler.this.mMagnificationController.isMagnifying(MagnificationGestureHandler.this.mDisplayId)) {
                        MagnificationGestureHandler.this.transitionTo(MagnificationGestureHandler.this.mPanningScalingState);
                        this.clear();
                        break;
                    }
                    this.transitionToDelegatingStateAndClear();
                    break;
                }
                case 2: {
                    if (!this.isFingerDown() || !(GestureUtils.distance(this.mLastDown, event) > (double)this.mSwipeMinDistance)) break;
                    if (this.isMultiTapTriggered(2)) {
                        this.transitionToViewportDraggingStateAndClear(event);
                        break;
                    }
                    this.transitionToDelegatingStateAndClear();
                    break;
                }
                case 1: {
                    this.mHandler.removeMessages(1);
                    if (!MagnificationGestureHandler.this.mMagnificationController.magnificationRegionContains(MagnificationGestureHandler.this.mDisplayId, event.getX(), event.getY())) {
                        this.transitionToDelegatingStateAndClear();
                        break;
                    }
                    if (this.isMultiTapTriggered(3)) {
                        this.onTripleTap(event);
                        break;
                    }
                    if (!this.isFingerDown() || this.timeBetween(this.mLastDown, this.mLastUp) < (long)this.mLongTapMinDelay && !(GestureUtils.distance(this.mLastDown, this.mLastUp) >= (double)this.mSwipeMinDistance)) break;
                    this.transitionToDelegatingStateAndClear();
                }
            }
        }

        public boolean isMultiTapTriggered(int numTaps) {
            if (this.mShortcutTriggered) {
                return this.tapCount() + 2 >= numTaps;
            }
            return MagnificationGestureHandler.this.mDetectTripleTap && this.tapCount() >= numTaps && this.isMultiTap(this.mPreLastDown, this.mLastDown) && this.isMultiTap(this.mPreLastUp, this.mLastUp);
        }

        private boolean isMultiTap(MotionEvent first, MotionEvent second) {
            return GestureUtils.isMultiTap(first, second, this.mMultiTapMaxDelay, this.mMultiTapMaxDistance);
        }

        public boolean isFingerDown() {
            return this.mLastDown != null;
        }

        private long timeBetween(MotionEvent a, MotionEvent b) {
            if (a == null && b == null) {
                return 0L;
            }
            return Math.abs(this.timeOf(a) - this.timeOf(b));
        }

        private long timeOf(MotionEvent event) {
            return event != null ? event.getEventTime() : Long.MIN_VALUE;
        }

        public int tapCount() {
            return MotionEventInfo.countOf(this.mDelayedEventQueue, 1);
        }

        public void afterMultiTapTimeoutTransitionToDelegatingState() {
            this.mHandler.sendEmptyMessageDelayed(2, this.mMultiTapMaxDelay);
        }

        public void afterLongTapTimeoutTransitionToDraggingState(MotionEvent event) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, MotionEvent.obtain(event)), ViewConfiguration.getLongPressTimeout());
        }

        @Override
        public void clear() {
            this.setShortcutTriggered(false);
            this.removePendingDelayedMessages();
            this.clearDelayedMotionEvents();
        }

        private void removePendingDelayedMessages() {
            this.mHandler.removeMessages(1);
            this.mHandler.removeMessages(2);
        }

        private void cacheDelayedMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            if (event.getActionMasked() == 0) {
                this.mPreLastDown = this.mLastDown;
                this.mLastDown = MotionEvent.obtain(event);
            } else if (event.getActionMasked() == 1) {
                this.mPreLastUp = this.mLastUp;
                this.mLastUp = MotionEvent.obtain(event);
            }
            MotionEventInfo info = MotionEventInfo.obtain(event, rawEvent, policyFlags);
            if (this.mDelayedEventQueue == null) {
                this.mDelayedEventQueue = info;
            } else {
                MotionEventInfo tail = this.mDelayedEventQueue;
                while (tail.mNext != null) {
                    tail = tail.mNext;
                }
                tail.mNext = info;
            }
        }

        private void sendDelayedMotionEvents() {
            while (this.mDelayedEventQueue != null) {
                MotionEventInfo info = this.mDelayedEventQueue;
                this.mDelayedEventQueue = info.mNext;
                MagnificationGestureHandler.this.handleEventWith(MagnificationGestureHandler.this.mDelegatingState, info.event, info.rawEvent, info.policyFlags);
                info.recycle();
            }
        }

        private void clearDelayedMotionEvents() {
            while (this.mDelayedEventQueue != null) {
                MotionEventInfo info = this.mDelayedEventQueue;
                this.mDelayedEventQueue = info.mNext;
                info.recycle();
            }
            this.mPreLastDown = null;
            this.mPreLastUp = null;
            this.mLastDown = null;
            this.mLastUp = null;
        }

        void transitionToDelegatingStateAndClear() {
            MagnificationGestureHandler.this.transitionTo(MagnificationGestureHandler.this.mDelegatingState);
            this.sendDelayedMotionEvents();
            this.removePendingDelayedMessages();
        }

        private void onTripleTap(MotionEvent up) {
            this.clear();
            if (MagnificationGestureHandler.this.mMagnificationController.isMagnifying(MagnificationGestureHandler.this.mDisplayId)) {
                MagnificationGestureHandler.this.zoomOff();
            } else {
                MagnificationGestureHandler.this.zoomOn(up.getX(), up.getY());
            }
        }

        void transitionToViewportDraggingStateAndClear(MotionEvent down) {
            this.clear();
            MagnificationGestureHandler.this.mViewportDraggingState.mZoomedInBeforeDrag = MagnificationGestureHandler.this.mMagnificationController.isMagnifying(MagnificationGestureHandler.this.mDisplayId);
            MagnificationGestureHandler.this.zoomOn(down.getX(), down.getY());
            MagnificationGestureHandler.this.transitionTo(MagnificationGestureHandler.this.mViewportDraggingState);
        }

        public String toString() {
            return "DetectingState{tapCount()=" + this.tapCount() + ", mShortcutTriggered=" + this.mShortcutTriggered + ", mDelayedEventQueue=" + MotionEventInfo.toString(this.mDelayedEventQueue) + '}';
        }

        void toggleShortcutTriggered() {
            this.setShortcutTriggered(!this.mShortcutTriggered);
        }

        void setShortcutTriggered(boolean state) {
            if (this.mShortcutTriggered == state) {
                return;
            }
            this.mShortcutTriggered = state;
            MagnificationGestureHandler.this.mMagnificationController.setForceShowMagnifiableBounds(MagnificationGestureHandler.this.mDisplayId, state);
        }

        boolean isTapOutOfDistanceSlop() {
            boolean outOfDistanceSlop;
            if (!MagnificationGestureHandler.this.mDetectTripleTap) {
                return false;
            }
            if (this.mPreLastDown == null || this.mLastDown == null) {
                return false;
            }
            boolean bl = outOfDistanceSlop = GestureUtils.distance(this.mPreLastDown, this.mLastDown) > (double)this.mMultiTapMaxDistance;
            if (this.tapCount() > 0) {
                return outOfDistanceSlop;
            }
            return outOfDistanceSlop && !GestureUtils.isTimedOut(this.mPreLastDown, this.mLastDown, this.mMultiTapMaxDelay);
        }
    }

    final class DelegatingState
    implements State {
        public long mLastDelegatedDownEventTime;

        DelegatingState() {
        }

        @Override
        public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            switch (event.getActionMasked()) {
                case 1: 
                case 3: {
                    MagnificationGestureHandler.this.transitionTo(MagnificationGestureHandler.this.mDetectingState);
                    break;
                }
                case 0: {
                    MagnificationGestureHandler.this.transitionTo(MagnificationGestureHandler.this.mDelegatingState);
                    this.mLastDelegatedDownEventTime = event.getDownTime();
                }
            }
            if (MagnificationGestureHandler.this.getNext() != null) {
                event.setDownTime(this.mLastDelegatedDownEventTime);
                MagnificationGestureHandler.this.dispatchTransformedEvent(event, rawEvent, policyFlags);
            }
        }
    }

    final class ViewportDraggingState
    implements State {
        boolean mZoomedInBeforeDrag;
        private boolean mLastMoveOutsideMagnifiedRegion;

        ViewportDraggingState() {
        }

        @Override
        public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            int action = event.getActionMasked();
            switch (action) {
                case 5: {
                    this.clear();
                    MagnificationGestureHandler.this.transitionTo(MagnificationGestureHandler.this.mPanningScalingState);
                    break;
                }
                case 2: {
                    if (event.getPointerCount() != 1) {
                        throw new IllegalStateException("Should have one pointer down.");
                    }
                    float eventX = event.getX();
                    float eventY = event.getY();
                    if (MagnificationGestureHandler.this.mMagnificationController.magnificationRegionContains(MagnificationGestureHandler.this.mDisplayId, eventX, eventY)) {
                        MagnificationGestureHandler.this.mMagnificationController.setCenter(MagnificationGestureHandler.this.mDisplayId, eventX, eventY, this.mLastMoveOutsideMagnifiedRegion, 0);
                        this.mLastMoveOutsideMagnifiedRegion = false;
                        break;
                    }
                    this.mLastMoveOutsideMagnifiedRegion = true;
                    break;
                }
                case 1: 
                case 3: {
                    if (!this.mZoomedInBeforeDrag) {
                        MagnificationGestureHandler.this.zoomOff();
                    }
                    this.clear();
                    MagnificationGestureHandler.this.transitionTo(MagnificationGestureHandler.this.mDetectingState);
                    break;
                }
                case 0: 
                case 6: {
                    throw new IllegalArgumentException("Unexpected event type: " + MotionEvent.actionToString(action));
                }
            }
        }

        @Override
        public void clear() {
            this.mLastMoveOutsideMagnifiedRegion = false;
        }

        public String toString() {
            return "ViewportDraggingState{mZoomedInBeforeDrag=" + this.mZoomedInBeforeDrag + ", mLastMoveOutsideMagnifiedRegion=" + this.mLastMoveOutsideMagnifiedRegion + '}';
        }
    }

    final class PanningScalingState
    extends GestureDetector.SimpleOnGestureListener
    implements ScaleGestureDetector.OnScaleGestureListener,
    State {
        private final ScaleGestureDetector mScaleGestureDetector;
        private final GestureDetector mScrollGestureDetector;
        final float mScalingThreshold;
        float mInitialScaleFactor = -1.0f;
        boolean mScaling;

        public PanningScalingState(Context context) {
            TypedValue scaleValue = new TypedValue();
            context.getResources().getValue(17105073, scaleValue, false);
            this.mScalingThreshold = scaleValue.getFloat();
            this.mScaleGestureDetector = new ScaleGestureDetector(context, this, Handler.getMain());
            this.mScaleGestureDetector.setQuickScaleEnabled(false);
            this.mScrollGestureDetector = new GestureDetector(context, this, Handler.getMain());
        }

        @Override
        public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
            int action = event.getActionMasked();
            if (action == 6 && event.getPointerCount() == 2 && MagnificationGestureHandler.this.mPreviousState == MagnificationGestureHandler.this.mViewportDraggingState) {
                this.persistScaleAndTransitionTo(MagnificationGestureHandler.this.mViewportDraggingState);
            } else if (action == 1 || action == 3) {
                this.persistScaleAndTransitionTo(MagnificationGestureHandler.this.mDetectingState);
            }
        }

        public void persistScaleAndTransitionTo(State state) {
            MagnificationGestureHandler.this.mMagnificationController.persistScale();
            this.clear();
            MagnificationGestureHandler.this.transitionTo(state);
        }

        @Override
        public boolean onScroll(MotionEvent first, MotionEvent second, float distanceX, float distanceY) {
            if (MagnificationGestureHandler.this.mCurrentState != MagnificationGestureHandler.this.mPanningScalingState) {
                return true;
            }
            MagnificationGestureHandler.this.mMagnificationController.offsetMagnifiedRegion(MagnificationGestureHandler.this.mDisplayId, distanceX, distanceY, 0);
            return true;
        }

        @Override
        public boolean onScale(ScaleGestureDetector detector) {
            if (!this.mScaling) {
                if (this.mInitialScaleFactor < 0.0f) {
                    this.mInitialScaleFactor = detector.getScaleFactor();
                    return false;
                }
                float deltaScale = detector.getScaleFactor() - this.mInitialScaleFactor;
                this.mScaling = Math.abs(deltaScale) > this.mScalingThreshold;
                return this.mScaling;
            }
            float initialScale = MagnificationGestureHandler.this.mMagnificationController.getScale(MagnificationGestureHandler.this.mDisplayId);
            float targetScale = initialScale * detector.getScaleFactor();
            float scale = targetScale > 8.0f && targetScale > initialScale ? 8.0f : (targetScale < 2.0f && targetScale < initialScale ? 2.0f : targetScale);
            float pivotX = detector.getFocusX();
            float pivotY = detector.getFocusY();
            MagnificationGestureHandler.this.mMagnificationController.setScale(MagnificationGestureHandler.this.mDisplayId, scale, pivotX, pivotY, false, 0);
            return true;
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return MagnificationGestureHandler.this.mCurrentState == MagnificationGestureHandler.this.mPanningScalingState;
        }

        @Override
        public void onScaleEnd(ScaleGestureDetector detector) {
            this.clear();
        }

        @Override
        public void clear() {
            this.mInitialScaleFactor = -1.0f;
            this.mScaling = false;
        }

        public String toString() {
            return "PanningScalingState{mInitialScaleFactor=" + this.mInitialScaleFactor + ", mScaling=" + this.mScaling + '}';
        }
    }

    static interface State {
        public void onMotionEvent(MotionEvent var1, MotionEvent var2, int var3);

        default public void clear() {
        }

        default public String name() {
            return this.getClass().getSimpleName();
        }

        public static String nameOf(State s) {
            return s != null ? s.name() : "null";
        }
    }
}

