/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.content.ComponentName;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.util.DumpUtils;
import com.android.server.accessibility.AbstractAccessibilityServiceConnection;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accessibility.GlobalActionPerformer;
import com.android.server.wm.WindowManagerInternal;
import java.io.FileDescriptor;
import java.io.PrintWriter;

class UiAutomationManager {
    private static final ComponentName COMPONENT_NAME = new ComponentName("com.android.server.accessibility", "UiAutomation");
    private static final String LOG_TAG = "UiAutomationManager";
    private final Object mLock;
    private UiAutomationService mUiAutomationService;
    private AccessibilityServiceInfo mUiAutomationServiceInfo;
    private AbstractAccessibilityServiceConnection.SystemSupport mSystemSupport;
    private int mUiAutomationFlags;
    private IBinder mUiAutomationServiceOwner;
    private final IBinder.DeathRecipient mUiAutomationServiceOwnerDeathRecipient = new IBinder.DeathRecipient(){

        @Override
        public void binderDied() {
            UiAutomationManager.this.mUiAutomationServiceOwner.unlinkToDeath(this, 0);
            UiAutomationManager.this.mUiAutomationServiceOwner = null;
            UiAutomationManager.this.destroyUiAutomationService();
        }
    };

    UiAutomationManager(Object lock) {
        this.mLock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerUiTestAutomationServiceLocked(IBinder owner, IAccessibilityServiceClient serviceClient, Context context, AccessibilityServiceInfo accessibilityServiceInfo, int id2, Handler mainHandler, AccessibilityManagerService.SecurityPolicy securityPolicy, AbstractAccessibilityServiceConnection.SystemSupport systemSupport, WindowManagerInternal windowManagerInternal, GlobalActionPerformer globalActionPerfomer, int flags) {
        Object object = this.mLock;
        synchronized (object) {
            accessibilityServiceInfo.setComponentName(COMPONENT_NAME);
            if (this.mUiAutomationService != null) {
                throw new IllegalStateException("UiAutomationService " + serviceClient + "already registered!");
            }
            try {
                owner.linkToDeath(this.mUiAutomationServiceOwnerDeathRecipient, 0);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Couldn't register for the death of a UiTestAutomationService!", re);
                return;
            }
            this.mSystemSupport = systemSupport;
            this.mUiAutomationService = new UiAutomationService(context, accessibilityServiceInfo, id2, mainHandler, this.mLock, securityPolicy, systemSupport, windowManagerInternal, globalActionPerfomer);
            this.mUiAutomationServiceOwner = owner;
            this.mUiAutomationFlags = flags;
            this.mUiAutomationServiceInfo = accessibilityServiceInfo;
            this.mUiAutomationService.mServiceInterface = serviceClient;
            this.mUiAutomationService.onAdded();
            try {
                this.mUiAutomationService.mServiceInterface.asBinder().linkToDeath(this.mUiAutomationService, 0);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed registering death link: " + re);
                this.destroyUiAutomationService();
                return;
            }
            this.mUiAutomationService.connectServiceUnknownThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterUiTestAutomationServiceLocked(IAccessibilityServiceClient serviceClient) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiAutomationService == null || serviceClient == null || this.mUiAutomationService.mServiceInterface == null || serviceClient.asBinder() != this.mUiAutomationService.mServiceInterface.asBinder()) {
                throw new IllegalStateException("UiAutomationService " + serviceClient + " not registered!");
            }
            this.destroyUiAutomationService();
        }
    }

    void sendAccessibilityEventLocked(AccessibilityEvent event) {
        if (this.mUiAutomationService != null) {
            this.mUiAutomationService.notifyAccessibilityEvent(event);
        }
    }

    boolean isUiAutomationRunningLocked() {
        return this.mUiAutomationService != null;
    }

    boolean suppressingAccessibilityServicesLocked() {
        return this.mUiAutomationService != null && (this.mUiAutomationFlags & 1) == 0;
    }

    boolean isTouchExplorationEnabledLocked() {
        return this.mUiAutomationService != null && this.mUiAutomationService.mRequestTouchExplorationMode;
    }

    boolean canRetrieveInteractiveWindowsLocked() {
        return this.mUiAutomationService != null && this.mUiAutomationService.mRetrieveInteractiveWindows;
    }

    int getRequestedEventMaskLocked() {
        if (this.mUiAutomationService == null) {
            return 0;
        }
        return this.mUiAutomationService.mEventTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRelevantEventTypes() {
        UiAutomationService uiAutomationService;
        Object object = this.mLock;
        synchronized (object) {
            uiAutomationService = this.mUiAutomationService;
        }
        if (uiAutomationService == null) {
            return 0;
        }
        return uiAutomationService.getRelevantEventTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AccessibilityServiceInfo getServiceInfo() {
        UiAutomationService uiAutomationService;
        Object object = this.mLock;
        synchronized (object) {
            uiAutomationService = this.mUiAutomationService;
        }
        if (uiAutomationService == null) {
            return null;
        }
        return uiAutomationService.getServiceInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpUiAutomationService(FileDescriptor fd, PrintWriter pw, String[] args) {
        UiAutomationService uiAutomationService;
        Object object = this.mLock;
        synchronized (object) {
            uiAutomationService = this.mUiAutomationService;
        }
        if (uiAutomationService != null) {
            uiAutomationService.dump(fd, pw, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyUiAutomationService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiAutomationService != null) {
                this.mUiAutomationService.mServiceInterface.asBinder().unlinkToDeath(this.mUiAutomationService, 0);
                this.mUiAutomationService.onRemoved();
                this.mUiAutomationService.resetLocked();
                this.mUiAutomationService = null;
                this.mUiAutomationFlags = 0;
                if (this.mUiAutomationServiceOwner != null) {
                    this.mUiAutomationServiceOwner.unlinkToDeath(this.mUiAutomationServiceOwnerDeathRecipient, 0);
                    this.mUiAutomationServiceOwner = null;
                }
                this.mSystemSupport.onClientChangeLocked(false);
            }
        }
    }

    private class UiAutomationService
    extends AbstractAccessibilityServiceConnection {
        private final Handler mMainHandler;

        UiAutomationService(Context context, AccessibilityServiceInfo accessibilityServiceInfo, int id2, Handler mainHandler, Object lock, AccessibilityManagerService.SecurityPolicy securityPolicy, AbstractAccessibilityServiceConnection.SystemSupport systemSupport, WindowManagerInternal windowManagerInternal, GlobalActionPerformer globalActionPerfomer) {
            super(context, COMPONENT_NAME, accessibilityServiceInfo, id2, mainHandler, lock, securityPolicy, systemSupport, windowManagerInternal, globalActionPerfomer);
            this.mMainHandler = mainHandler;
        }

        void connectServiceUnknownThread() {
            this.mMainHandler.post(() -> {
                try {
                    IBinder service;
                    IAccessibilityServiceClient serviceInterface;
                    Object object = this.mLock;
                    synchronized (object) {
                        serviceInterface = this.mServiceInterface;
                        service = this.mService = serviceInterface == null ? null : this.mServiceInterface.asBinder();
                    }
                    if (serviceInterface != null) {
                        service.linkToDeath(this, 0);
                        serviceInterface.init(this, this.mId, this.mOverlayWindowToken);
                    }
                }
                catch (RemoteException re) {
                    Slog.w(UiAutomationManager.LOG_TAG, "Error initialized connection", re);
                    UiAutomationManager.this.destroyUiAutomationService();
                }
            });
        }

        @Override
        public void binderDied() {
            UiAutomationManager.this.destroyUiAutomationService();
        }

        @Override
        protected boolean isCalledForCurrentUserLocked() {
            return true;
        }

        @Override
        protected boolean supportsFlagForNotImportantViews(AccessibilityServiceInfo info) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(this.mContext, UiAutomationManager.LOG_TAG, pw)) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                pw.append("Ui Automation[eventTypes=" + AccessibilityEvent.eventTypeToString(this.mEventTypes));
                pw.append(", notificationTimeout=" + this.mNotificationTimeout);
                pw.append("]");
            }
        }

        @Override
        public boolean setSoftKeyboardShowMode(int mode) {
            return false;
        }

        @Override
        public int getSoftKeyboardShowMode() {
            return 0;
        }

        @Override
        public boolean isAccessibilityButtonAvailable() {
            return false;
        }

        @Override
        public void disableSelf() {
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder service) {
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
        }

        @Override
        public boolean isCapturingFingerprintGestures() {
            return false;
        }

        @Override
        public void onFingerprintGestureDetectionActiveChanged(boolean active) {
        }

        @Override
        public void onFingerprintGesture(int gesture) {
        }
    }
}

